/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.org.IOrgHRCommon;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRFaceUtil {
    private static Logger logger = Logger.getLogger((String)HRFaceUtil.class.getName());

    public static String[] getPersonsByRoleAndAdminOrg(Context ctx, String roleID, String adminOrgUnitId) {
        if (StringUtils.isEmpty((String)roleID) || StringUtils.isEmpty((String)adminOrgUnitId)) {
            throw new RuntimeException(roleID + adminOrgUnitId + EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"127_HRFaceUtil"));
        }
        try {
            IOrgHRCommon iorgHrCommon = null;
            IUserRoleOrgManager iuserRole = null;
            IOrgRange iorgRange = null;
            if (ctx != null) {
                iorgHrCommon = OrgHRCommonFactory.getLocalInstance((Context)ctx);
                iuserRole = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
                iorgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
            } else {
                iorgHrCommon = OrgHRCommonFactory.getRemoteInstance();
                iuserRole = UserRoleOrgManagerFactory.getRemoteInstance();
                iorgRange = OrgRangeFactory.getRemoteInstance();
            }
            HROrgUnitInfo hro = iorgHrCommon.getAdminOrgHRO(adminOrgUnitId);
            if (hro == null) {
                throw new RuntimeException(HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "166_HRFaceUtil", new String[]{adminOrgUnitId}));
            }
            logger.info((Object)("HRFaceInfo:orgPk_" + hro.getId() + "|roleID_" + roleID));
            UserCollection userCol = iuserRole.getUsers((IObjectPK)new ObjectUuidPK(hro.getId()), (IObjectPK)new ObjectUuidPK(roleID));
            int userSize = userCol.size();
            StringBuffer oql = new StringBuffer();
            oql.append("select user.person.id");
            oql.append(" where user.id in (");
            for (int i = 0; i < userSize; ++i) {
                if (i > 0) {
                    oql.append(",");
                }
                oql.append("'");
                oql.append(userCol.get(i).getId());
                oql.append("'");
            }
            oql.append(") and org.id = '");
            oql.append(adminOrgUnitId);
            oql.append("' ");
            oql.append("and type=");
            oql.append(20);
            logger.info((Object)("HRFaceInfo:oql_" + oql.toString()));
            if (userSize > 0) {
                HashSet<String> personIdSet = new HashSet<String>();
                OrgRangeCollection orgRangeCol = iorgRange.getOrgRangeCollection(oql.toString());
                for (int i = 0; i < orgRangeCol.size(); ++i) {
                    if (orgRangeCol.get(i).getUser().getPerson() == null) continue;
                    personIdSet.add(orgRangeCol.get(i).getUser().getPerson().getId().toString());
                }
                String[] personIds = new String[personIdSet.size()];
                personIdSet.toArray(personIds);
                return personIds;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String[0];
    }
}

