/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class HRResourceUtils {
    private static final String REGEX = "\\{\\d+\\}";
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    public static String getMessageInOrder(String resClassName, String resName, String[] parameters) {
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)SysContext.getSysContext().getOriginLocale());
        for (int i = 0; i < parameters.length; ++i) {
            message = message.replaceFirst(REGEX, parameters[i]);
        }
        return message;
    }

    public static String getMessage(String resClassName, String resName, String[] parameters) {
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)HRResourceUtils.getLocale());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            if (HRResourceUtils.isEmpty(parameters[i])) {
                parameters[i] = "\t";
            }
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    public static String getMessage(String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)HRResourceUtils.getLocale());
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    public static String getMessage(String resClassName, String resName, Locale locale, String[] parameters) {
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() <= 0;
    }
}

