/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountInfo;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitRuleCollection;
import com.kingdee.eas.hr.benefit.BenefitRuleFactory;
import com.kingdee.eas.hr.benefit.BenefitRuleInfo;
import com.kingdee.eas.hr.benefit.BenefitRulePersonRelCollection;
import com.kingdee.eas.hr.benefit.BenefitRulePersonRelFactory;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IBenefitRulePersonRel;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;

public class AccountBatchDataImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        AccountInfo account = new AccountInfo();
        AccountDetailInfo accountDetail = new AccountDetailInfo();
        String str = null;
        try {
            CmpPeriodCollection cmpColl;
            str = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            PersonInfo pInfo = this.getPersonInfo(ctx, str, "number");
            this.checkIsSocial(ctx, pInfo);
            this.checkIsCurHRUnit(ctx, pInfo, hrOrgUnitID);
            account.put("pid", pInfo.getId().toString());
            account.put("perNum", str);
            account.setPerson(pInfo);
            accountDetail.put("pid", pInfo.getId().toString());
            str = (String)((DataToken)hsData.get((Object)"FIsNative")).data;
            if (!StringUtils.isEmpty((String)str)) {
                if (str.trim().equals(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.YES"))) {
                    account.setIsNativeResidence(true);
                } else if (str.trim().equals(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NO"))) {
                    account.setIsNativeResidence(false);
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"Fcity")).data))) {
                account.setCity(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPayState")).data))) {
                if (str.trim().equals(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NORMALPAY"))) {
                    accountDetail.setPayState(PayTypeEnum.NORMALPAY);
                } else if (str.trim().equals(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.STOPPAY"))) {
                    accountDetail.setPayState(PayTypeEnum.STOPPAY);
                } else if (str.trim().equals(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.SEALPAY"))) {
                    accountDetail.setPayState(PayTypeEnum.SEALPAY);
                }
            } else {
                accountDetail.setPayState(PayTypeEnum.STOPPAY);
            }
            str = (String)((DataToken)hsData.get((Object)"FAccountType")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ATNUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            AccountTypeInfo atInfo = null;
            AccountTypeCollection atColl = null;
            IAccountType iAccountType = AccountTypeFactory.getLocalInstance(ctx);
            atColl = iAccountType.getAccountTypeCollection("select * where number = '" + str + "' and hrOrgUnit.id = '" + hrOrgUnitID + "'");
            if (atColl.size() <= 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ATNUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
            }
            atInfo = atColl.get(0);
            accountDetail.setAccountType(atInfo);
            accountDetail.setAccountNumber(atInfo.getNumber());
            str = (String)((DataToken)hsData.get((Object)"FBenefitRuleNumber")).data;
            if (!StringUtils.isEmpty((String)str)) {
                BenefitRuleInfo brInfo = null;
                BenefitRuleCollection brColl = null;
                brColl = this.checkBenefitRule(ctx, atInfo.getId().toString(), str);
                if (brColl.size() <= 0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BRNUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
                }
                brInfo = brColl.get(0);
                accountDetail.setBenefitRule(brInfo);
                IBenefitRulePersonRel iBRP = BenefitRulePersonRelFactory.getLocalInstance(ctx);
                StringBuffer oql = new StringBuffer("select benefitRule.id where benefitRule.accountType.id='");
                oql.append(accountDetail.getAccountType().getId().toString());
                oql.append("' and person.id='");
                oql.append(accountDetail.get("pid").toString());
                oql.append("'");
                BenefitRulePersonRelCollection brpColl = iBRP.getBenefitRulePersonRelCollection(oql.toString());
                if (brpColl != null && brpColl.size() > 0) {
                    accountDetail.put("oldBr", brpColl.get(0).getBenefitRule());
                }
            }
            if (StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"Faccounts")).data))) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            accountDetail.setAccounts(str);
            str = (String)((DataToken)hsData.get((Object)"FCreateDate")).data;
            if (!this.isDateFormat(str) && !StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException("FCreateDate\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u65e5\u671f\u5b57\u7b26\u4e32\uff0cyyyy-MM-dd\uff01\u5f53\u524d\u5efa\u7acb\u65f6\u95f4\u662f" + str);
            }
            if (!StringUtils.isEmpty((String)str)) {
                accountDetail.setCreateDate(DateTimeUtils.parseDate((String)str));
            }
            if (!this.isDateFormat(str = (String)((DataToken)hsData.get((Object)"FStopDate")).data) && !StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException("FStopDate\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u65e5\u671f\u5b57\u7b26\u4e32\uff0cyyyy-MM-dd\uff01\u5f53\u524d\u505c\u4ea4\u65e5\u671f\u662f" + str);
            }
            if (!StringUtils.isEmpty((String)str)) {
                accountDetail.setStopDate(DateTimeUtils.parseDate((String)str));
            }
            if (!this.isDateFormat(str = (String)((DataToken)hsData.get((Object)"FRetireTransactDate")).data) && !StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException("FRetireTransactDate\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u65e5\u671f\u5b57\u7b26\u4e32\uff0cyyyy-MM-dd\uff01\u5f53\u524d\u9000\u4f11\u529e\u7406\u65e5\u671f\u662f" + str);
            }
            if (!StringUtils.isEmpty((String)str)) {
                accountDetail.setRetireTransactDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FRetireNumber")).data))) {
                accountDetail.setRetireNumber(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FFundItem")).data))) {
                accountDetail.setFundItem(str);
            }
            if (!this.isDateFormat(str = (String)((DataToken)hsData.get((Object)"FTransactDate")).data) && !StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException("FTransactDate\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u65e5\u671f\u5b57\u7b26\u4e32\uff0cyyyy-MM-dd\uff01\u5f53\u524d\u529e\u7406\u65e5\u671f\u662f" + str);
            }
            if (!StringUtils.isEmpty((String)str)) {
                accountDetail.setTransactDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FCurPeriod")).data))) {
                ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
                cmpColl = icp.getCmpPeriodCollection("select * where number = '" + str + "' and hrOrgUnit.id = '" + hrOrgUnitID + "'");
                if (cmpColl == null || cmpColl.size() <= 0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.PERIOD_FORM_ERROR"));
                }
                CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod(ctx);
                CmpPeriodInfo inputInfo = cmpColl.get(0);
                if (DateTimeUtils.dayBefore((Date)inputInfo.getBeginDate(), (Date)initInfo.getBeginDate())) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.PERIOD_ERROR"));
                }
            } else {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.CURPERIOD_NOT_NULL"));
            }
            accountDetail.setCurPeriod(cmpColl.get(0));
            account.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            account.put("detail", accountDetail);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        catch (ParseException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return account;
    }

    private boolean isDateFormat(String str) {
        try {
            DateTimeUtils.parseDate((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkIsSocial(Context ctx, PersonInfo info) throws BOSException, TaskExternalException {
        block4: {
            String sql = "select fissocialinsu from t_hr_socialinsurance where fpersonid = ?";
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            try {
                if (rows.size() > 0) {
                    while (rows.next()) {
                        if (rows.getBoolean("fissocialinsu")) continue;
                        throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"0_AccountBatchDataImport", (Locale)ctx.getLocale()));
                    }
                    break block4;
                }
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"0_AccountBatchDataImport", (Locale)ctx.getLocale()));
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        String accID = null;
        String adID = null;
        AccountInfo accountInfo = (AccountInfo)coreBaseInfo;
        AccountDetailInfo adInfo = (AccountDetailInfo)coreBaseInfo.get("detail");
        AccountCollection accountColl = new AccountCollection();
        AccountDetailCollection adColl = new AccountDetailCollection();
        try {
            IEmpManagerFacade iEmpManagerFacade;
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                accID = this.getAccountID(ctx, accountInfo, false);
                if (accID != null) {
                    accountInfo.setId(BOSUuid.read((String)accID));
                }
                accountColl.add(accountInfo);
                adInfo.setAccount(accountInfo);
                adColl.add(adInfo);
                this.checkDupAccountTypeBenefitRule(ctx, adColl);
                iEmpManagerFacade = EmpManagerFacadeFactory.getLocalInstance(ctx);
                iEmpManagerFacade.submitAll(accountColl, adColl, null);
            }
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16) {
                accID = this.getAccountID(ctx, accountInfo, false);
                if (!StringUtils.isEmpty((String)accID)) {
                    accountInfo.setId(BOSUuid.read((String)accID));
                }
                if (!StringUtils.isEmpty((String)accID)) {
                    adID = this.getAdID(ctx, accountInfo, adInfo);
                }
                if (!StringUtils.isEmpty(adID)) {
                    boolean isSameCmp = false;
                    String id = adID.split("@_@")[0];
                    String cmpID = adID.split("@_@")[1];
                    if (adInfo.getCurPeriod() != null && cmpID.equals(adInfo.getCurPeriod().getId().toString())) {
                        isSameCmp = true;
                    }
                    Object[] param = new Object[]{adInfo.getAccounts()};
                    IAccountDetail iad = AccountDetailFactory.getLocalInstance(ctx);
                    if (iad.hasInitBenefitData(id) && !isSameCmp) {
                        throw new EmpAccountManagerException(EmpAccountManagerException.EXISTINITDATA, param);
                    }
                    if (iad.hasCaculated(id) && !isSameCmp) {
                        throw new EmpAccountManagerException(EmpAccountManagerException.EXISTCALDATA, param);
                    }
                    if (adInfo.isHasBenefitBiz() && !isSameCmp) {
                        throw new EmpAccountManagerException(EmpAccountManagerException.HASBENEBIZ, param);
                    }
                    adInfo.setId(BOSUuid.read((String)id));
                }
                accountColl.add(accountInfo);
                adInfo.setAccount(accountInfo);
                adColl.add(adInfo);
                this.checkDupAccountTypeBenefitRule(ctx, adColl);
                iEmpManagerFacade = EmpManagerFacadeFactory.getLocalInstance(ctx);
                iEmpManagerFacade.submitAll(accountColl, adColl, null);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void checkDupAccountTypeBenefitRule(Context ctx, AccountDetailCollection adColl) throws BOSException, EmpAccountManagerException {
        int size = adColl.size();
        for (int i = 0; i < size; ++i) {
            BenefitRuleInfo benefitRuleInfo;
            AccountDetailInfo detailInfo = adColl.get(i);
            String accountNumber = detailInfo.getAccountNumber();
            if (detailInfo.getBenefitRule() == null) continue;
            String benefitRuleNumber = detailInfo.getBenefitRule().getNumber();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("accountType.number", (Object)accountNumber));
            viewInfo.setFilter(filterInfo);
            BenefitRuleCollection benefitRuleCollection = BenefitRuleFactory.getLocalInstance(ctx).getBenefitRuleCollection(viewInfo);
            int sizej = benefitRuleCollection.size();
            for (int j = 0; j < sizej && !(benefitRuleInfo = benefitRuleCollection.get(j)).getNumber().equals(benefitRuleNumber); ++j) {
                if (j != sizej - 1) continue;
                Object[] param = new Object[1];
                throw new EmpAccountManagerException(EmpAccountManagerException.DUPACCOUNTRULE);
            }
        }
    }

    private String getAccountID(Context ctx, AccountInfo accountInfo, boolean b) throws BOSException, SQLException, TaskExternalException {
        String sql = "select fid from t_hr_account where fpersonid = ? and fhrorgunitid = ? ";
        String perid = accountInfo.getPerson().getId().toString();
        String perNum = accountInfo.getPerson().getNumber();
        String accID = null;
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{perid, hrOrgUnitID});
        if (rows.size() <= 0 && b) {
            throw new TaskExternalException(perNum + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NO_ACCOUNT"));
        }
        if (rows.size() <= 0) {
            accID = null;
        }
        while (rows.next()) {
            accID = rows.getString("fid");
        }
        return accID;
    }

    private String getAdID(Context ctx, AccountInfo accountInfo, AccountDetailInfo adInfo) throws BOSException, SQLException, TaskExternalException {
        IRowSet rows;
        String accID = this.getAccountID(ctx, accountInfo, false);
        String adID = null;
        String sql = "select fid,fcurPeriodid from t_hr_accountdetail where FAccountTypeID = ? and FAccountID = ?";
        String accTypeId = null;
        if (adInfo.getAccountType() != null) {
            accTypeId = adInfo.getAccountType().getId().toString();
        }
        if ((rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accTypeId, accID})).size() <= 0) {
            return null;
        }
        while (rows.next()) {
            adID = rows.getString("fid") + "@_@" + rows.getString("fcurPeriodid");
        }
        return adID;
    }

    private PersonInfo getPersonInfo(Context ctx, String str, String filterName) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(filterName, (Object)str));
        view.setFilter(filterInfo);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection(view);
        if (personColl == null || personColl.size() == 0) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
        }
        return personColl.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        return ExportUtil.transeExport(rs, ExportUtil.ACC_BATCH_MAP);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return new FilterInfo();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.benefit.app.AccountBatchExportQuery";
    }

    private void checkIsCurHRUnit(Context ctx, PersonInfo info, String HROUnitID) throws BOSException, TaskExternalException {
        boolean isCurHRUnit = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select pp.FPersonID from t_hr_personPosition pp ");
        sql.append("inner join T_ORG_UnitRelation ur ");
        sql.append("on pp.FPersonDep = ur.FFromUnitID ");
        sql.append("where ur.ftyperelationid = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sql.append("and pp.FPersonID = ? and ur.FToUnitID = ?");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getId().toString(), HROUnitID});
        try {
            while (rows.next()) {
                isCurHRUnit = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isCurHRUnit) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"58_ACCOUNTBATCHIMPORT", (Locale)ctx.getLocale()));
        }
    }

    private BenefitRuleCollection checkBenefitRule(Context ctx, String acTypeId, String benefitRuleNumber) throws BOSException {
        String hro = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        HashSet<String> adminID = new HashSet<String>();
        StringBuffer adminSql = new StringBuffer();
        adminSql.append(" select admin.fid as adminID from t_org_admin admin \n");
        adminSql.append(" left outer join T_ORG_UnitRelation rela on admin.fid = rela.FFromUnitID \n");
        adminSql.append(" left outer join T_ORG_HRO hro on rela.FToUnitID = hro.fid \n");
        adminSql.append(" left outer join T_PM_OrgRange ran on ran.FOrgID = admin.fid \n");
        adminSql.append(" left outer join T_PM_User us on ran.FUserID = us.fid \n");
        adminSql.append(" where rela.FTypeRelationID ='");
        adminSql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        adminSql.append("' and ran.FType = 20");
        adminSql.append(" and hro.fid ='" + hro + "' \n");
        adminSql.append(" and us.fid ='" + user + "'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)adminSql.toString());
        try {
            while (rows.next()) {
                adminID.add(rows.getString("adminID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select id, number, name, description,adminOrgUnit.id, ");
        sb.append(" adminOrgUnit.name,adminOrgunit.number,adminOrgUnit.displayName, accountType.id ");
        sb.append(" where hrOrgUnit.id = '" + hro + "' ");
        sb.append(" and (adminOrgUnit.id is null or adminOrgUnit.id in ");
        sb.append(BenefitUtils.getStrFromSet(adminID) + ")");
        sb.append(" and number = '").append(benefitRuleNumber).append("'");
        if (acTypeId != null) {
            sb.append(" and accountType.id = '");
            sb.append(acTypeId);
            sb.append("'");
        }
        return BenefitRuleFactory.getLocalInstance(ctx).getBenefitRuleCollection(sb.toString());
    }
}

