/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitDataFactory;
import com.kingdee.eas.hr.benefit.BenefitInitDataFactory;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.IBenefitData;
import com.kingdee.eas.hr.benefit.IBenefitInitData;
import com.kingdee.eas.hr.benefit.app.AbstractAccountDetailControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class AccountDetailControllerBean
extends AbstractAccountDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.benefit.app.AccountDetailControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDumpAccounts(ctx, model, "add");
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDumpAccounts(ctx, model, "update");
        super._update(ctx, pk, model);
    }

    private void checkDumpAccounts(Context ctx, IObjectValue model, String addOrUpdate) throws EASBizException, BOSException {
        AccountDetailInfo adInfo = (AccountDetailInfo)model;
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("accounts", (Object)adInfo.getAccounts(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo hrItem = new FilterItemInfo("account.hrOrgUnit.id", (Object)hrOrgUnit, CompareType.EQUALS);
        filter.getFilterItems().add(hrItem);
        if ("update".equals(addOrUpdate)) {
            AccountDetailInfo adInfo1 = AccountDetailFactory.getLocalInstance(ctx).getAccountDetailInfo("select *,account.id,account.person.id where id = '" + adInfo.getId().toString() + "'");
            filterItem = new FilterItemInfo("account.person.id", (Object)adInfo1.getAccount().getPerson().getId(), CompareType.NOTEQUALS);
        } else {
            filterItem = new FilterItemInfo("account.person.id", (Object)adInfo.getAccount().getPerson().getId(), CompareType.NOTEQUALS);
        }
        filter.getFilterItems().add(filterItem);
        if (adInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)adInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        if (super._exists(ctx, filter)) {
            throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTS_VALID);
        }
    }

    protected void _makeNormal(Context ctx, String aID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_AccountDetail set FPayState = 10, FStopDate = null where FID = '");
        sb.append(aID);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _makeSeal(Context ctx, String aID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_AccountDetail set FPayState = 30 where FID = '");
        sb.append(aID);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _makeStop(Context ctx, String aID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_AccountDetail set FPayState = 20, FStopDate = ");
        sb.append(this.getSqlDate(new Date()));
        sb.append(" where FID = '");
        sb.append(aID);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSqlDate(Date date) throws BOSException {
        String strTime = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    protected boolean _hasCacuLateOrEndInit(Context ctx, String accountDetailID) throws BOSException, EASBizException {
        IBenefitData ibd = BenefitDataFactory.getLocalInstance(ctx);
        if (ibd.exists("select * where AccountDetail.id = '" + accountDetailID + "'")) {
            return true;
        }
        IBenefitInitData ibid = BenefitInitDataFactory.getLocalInstance(ctx);
        return ibid.exists("select * where AccountDetail.id = '" + accountDetailID + "'");
    }

    protected boolean _hasCaculated(Context ctx, String accDetailID) throws BOSException, EASBizException {
        IBenefitData ibd = BenefitDataFactory.getLocalInstance(ctx);
        return ibd.exists("select * where AccountDetail.id = '" + accDetailID + "'");
    }

    protected boolean _hasInitBenefitData(Context ctx, String accDetailID) throws BOSException, EASBizException {
        IBenefitInitData ibid = BenefitInitDataFactory.getLocalInstance(ctx);
        return ibid.exists("select * where AccountDetail.id = '" + accDetailID + "'");
    }
}

