/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.BenefitDataImportFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitDataInitDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitInitDataFactory;
import com.kingdee.eas.hr.benefit.BenefitInitDataInfo;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IBenefitDataImportFacade;
import com.kingdee.eas.hr.benefit.IBenefitInitData;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class AccountInitDataImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BenefitInitDataInfo benefitInitDataInfo = new BenefitInitDataInfo();
        String str = null;
        String perNum = null;
        String hrOrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        try {
            String oql;
            str = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            perNum = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            str = (String)((DataToken)hsData.get((Object)"FAcounts")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            AccountDetailInfo adInfo = this.getAdInfo(ctx, str, hrOrg);
            if (adInfo.isHasBenefitBiz()) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.HAS_BIZ_ERROR"));
            }
            benefitInitDataInfo.setAccountDetail(adInfo);
            str = (String)((DataToken)hsData.get((Object)"FCmpPeriodNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.CMPPERIOD") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            ICmpPeriod iCmp = CmpPeriodFactory.getLocalInstance((Context)ctx);
            CmpPeriodCollection cmpColl = iCmp.getCmpPeriodCollection(oql = "Select * where enableState = 0 and number = '" + str + "' and hrOrgUnit.id ='" + hrOrg + "'");
            if (cmpColl == null || cmpColl.size() == 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.CMPPERIOD") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
            }
            CmpPeriodInfo cmpPeriodInfo = adInfo.getCurPeriod();
            CmpPeriodInfo initPeriod = cmpColl.get(0);
            if (DateTimeUtils.dayEquals((Date)cmpPeriodInfo.getBeginDate(), (Date)initPeriod.getBeginDate()) || DateTimeUtils.dayBefore((Date)cmpPeriodInfo.getBeginDate(), (Date)initPeriod.getBeginDate())) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"1_AccountInitDataImport", (Locale)ctx.getLocale()));
            }
            benefitInitDataInfo.setCmpPeriod(initPeriod);
            IBenefitInitData ibid = BenefitInitDataFactory.getLocalInstance(ctx);
            if (ibid.exists("select * where accountDetail.id = '" + adInfo.getId().toString() + "' and cmpPeriod.id = '" + initPeriod.getId().toString() + "' and isCheck = 1")) {
                throw new TaskExternalException(perNum + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.EXIST_AUDIT_DATA01") + initPeriod.getNumber() + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.EXIST_AUDIT_DATA02"));
            }
            benefitInitDataInfo.setIsCheck(false);
            benefitInitDataInfo.setIsEndInit(false);
            str = (String)((DataToken)hsData.get((Object)"FBenefitNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENE_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            String beneNum = str;
            str = (String)((DataToken)hsData.get((Object)"FBenefitItemNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEITEM_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            AccountItemInputInfo aiiInfo = BenefitUtils.getAiiInfo(ctx, BenefitUtils.getItemInfoByNum(ctx, beneNum, str).getId().toString(), adInfo.getId().toString());
            BenefitDataInitDetailInfo bddInfo = new BenefitDataInitDetailInfo();
            str = (String)((DataToken)hsData.get((Object)"Fvalue")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            bddInfo.setBenefitInitData(benefitInitDataInfo);
            bddInfo.setAccountItemInput(aiiInfo);
            bddInfo.setValue(new BigDecimal(str));
            benefitInitDataInfo.put("bdDetailInfo", bddInfo);
        }
        catch (ObjectNotFoundException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFIT_ITEM_NOT_NULL"));
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return benefitInitDataInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IBenefitDataImportFacade iBenefitDataImportFacade = BenefitDataImportFacadeFactory.getLocalInstance(ctx);
            BenefitInitDataInfo info = (BenefitInitDataInfo)coreBaseInfo;
            iBenefitDataImportFacade.importAccountData((IObjectValue)info);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        return ExportUtil.transeExport(rs, ExportUtil.ACC_INIT_MAP);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.benefit.app.BenefitDataInitQuery";
    }

    private AccountDetailInfo getAdInfo(Context ctx, String str, String hrOrg) throws BOSException, EASBizException, TaskExternalException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection adColl = null;
        String selectSql = "select *,curPeriod.* where accounts = '" + str + "' and account.hrOrgUnit.id ='" + hrOrg + "'";
        adColl = iAccountDetail.getAccountDetailCollection(selectSql);
        if (adColl.size() <= 0) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
        }
        return adColl.get(0);
    }
}

