/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.app.HRDbUtil;
import com.kingdee.eas.hr.benefit.BenefitDataDetailHisInfo;
import com.kingdee.eas.hr.benefit.BenefitDataHisInfo;
import com.kingdee.eas.hr.benefit.BenefitDataInitDetailCollection;
import com.kingdee.eas.hr.benefit.BenefitDataInitDetailFactory;
import com.kingdee.eas.hr.benefit.BenefitDataInitDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInitDataCollection;
import com.kingdee.eas.hr.benefit.BenefitInitDataFactory;
import com.kingdee.eas.hr.benefit.BenefitInitDataInfo;
import com.kingdee.eas.hr.benefit.IBenefitDataInitDetail;
import com.kingdee.eas.hr.benefit.IBenefitInitData;
import com.kingdee.eas.hr.benefit.app.AbstractAccountInitDataInputFacadeControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AccountInitDataInputFacadeControllerBean
extends AbstractAccountInitDataInputFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.benefit.app.AccountInitDataInputFacadeControllerBean");
    private static final String strUpdateSql = "update T_hr_benefitdatainitdetail set fValue=? where fBenefitInitDataID=? and fAccountItemInputID=?";

    protected void _submitAll(Context ctx, IObjectCollection benefitDataColl, IObjectCollection benefitDetailDataColl, List delIdList) throws BOSException, EASBizException {
        IBenefitInitData iBenefitInitData = BenefitInitDataFactory.getLocalInstance(ctx);
        IBenefitDataInitDetail iBenefitDataInitDetail = BenefitDataInitDetailFactory.getLocalInstance(ctx);
        if (delIdList.size() > 0) {
            String delBenefitDataDetail = "delete t_hr_benefitdatainitdetail where fbenefitinitdataid in " + BenefitUtils.getStrFromList(delIdList);
            String delBenefitData = "delete t_hr_benefitinitdata where fid in " + BenefitUtils.getStrFromList(delIdList);
            HRDbUtil.execute((Context)ctx, (String)delBenefitDataDetail);
            HRDbUtil.execute((Context)ctx, (String)delBenefitData);
        }
        BenefitInitDataInfo bidInfo = null;
        IObjectPK pk = null;
        int size = benefitDataColl.size();
        for (int i = 0; i < size; ++i) {
            bidInfo = ((BenefitInitDataCollection)benefitDataColl).get(i);
            if (bidInfo.getId() == null) {
                this.updateDupData(ctx, benefitDetailDataColl, bidInfo);
                pk = iBenefitInitData.addnew((CoreBaseInfo)bidInfo);
                bidInfo.setId(BOSUuid.read((String)pk.toString()));
                int count = benefitDetailDataColl.size();
                for (int j = 0; j < count; ++j) {
                    BenefitDataInitDetailInfo bdidInfo = null;
                    bdidInfo = ((BenefitDataInitDetailCollection)benefitDetailDataColl).get(j);
                    if (((Integer)bidInfo.get("index")).intValue() != ((Integer)bdidInfo.get("index")).intValue()) continue;
                    bdidInfo.setBenefitInitData(bidInfo);
                    iBenefitDataInitDetail.addnew(bdidInfo);
                }
                continue;
            }
            iBenefitInitData.update((IObjectPK)new ObjectUuidPK(bidInfo.getId().toString()), (CoreBaseInfo)bidInfo);
            this.updateDetailData(ctx, benefitDetailDataColl, bidInfo, iBenefitDataInitDetail);
        }
    }

    private void updateDetailData(Context ctx, IObjectCollection benefitDetailDataColl, BenefitInitDataInfo bidInfo, IBenefitDataInitDetail iBenefitDataInitDetail) throws BOSException, EASBizException {
        int count = benefitDetailDataColl.size();
        for (int j = 0; j < count; ++j) {
            BenefitDataInitDetailInfo bdidInfo = null;
            bdidInfo = ((BenefitDataInitDetailCollection)benefitDetailDataColl).get(j);
            if (((Integer)bidInfo.get("index")).intValue() != ((Integer)bdidInfo.get("index")).intValue()) continue;
            if (bdidInfo.getId() != null) {
                HRDbUtil.execute((Context)ctx, (String)strUpdateSql, (Object[])new Object[]{bdidInfo.getValue(), bidInfo.getId().toString(), bdidInfo.getAccountItemInput().getId().toString()});
                continue;
            }
            bdidInfo.setBenefitInitData(bidInfo);
            iBenefitDataInitDetail.addnew(bdidInfo);
        }
    }

    public void updateDupData(Context ctx, IObjectCollection benefitDetailDataColl, BenefitInitDataInfo bidInfo) throws BOSException, EASBizException {
        String sql = "select FID, FIsCheck from t_hr_benefitinitdata where faccountdetailid = ? and fcmpperiodid = ?";
        int isCheck = 0;
        IBenefitDataInitDetail iBenefitDataInitDetail = BenefitDataInitDetailFactory.getLocalInstance(ctx);
        IRowSet rows = HRDbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bidInfo.getAccountDetail().getId().toString(), bidInfo.getCmpPeriod().getId().toString()});
        try {
            while (rows.next()) {
                if (rows.getBoolean("FIsCheck")) {
                    isCheck = 1;
                    continue;
                }
                isCheck = -1;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        if (isCheck == -1) {
            this.updateDetailData(ctx, benefitDetailDataColl, bidInfo, iBenefitDataInitDetail);
        } else if (isCheck == 1) {
            throw new BenefitException(BenefitException.HAS_INIT);
        }
    }

    protected void _audit(Context ctx, ArrayList benefitInitDataList) throws BOSException, EASBizException {
        String benefitInitDataID = null;
        String updateSql = null;
        StringBuffer ids = new StringBuffer();
        int size = benefitInitDataList.size();
        for (int i = 0; i < size; ++i) {
            benefitInitDataID = benefitInitDataList.get(i).toString();
            ids.append("'").append(benefitInitDataID).append("'");
            if (i == size - 1) continue;
            ids.append(",");
        }
        updateSql = "update T_HR_BenefitInitData set FIsCheck = 1 where FID in (" + ids.toString() + ")";
        HRDbUtil.execute((Context)ctx, (String)updateSql);
    }

    protected void _endInit(Context ctx, String atTypeID, List initDataIDList) throws BOSException, EASBizException {
        TempTablePool pool = null;
        String tmpTable = null;
        HashMap map = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = this.createTmpTable(ctx, pool, initDataIDList);
            map = this.initBenefitDataHis(ctx, tmpTable);
            this.initBenefitDataDetailHis(ctx, map, tmpTable);
            this.updateBalance(ctx, atTypeID, initDataIDList);
            this.updateInitState(ctx, tmpTable);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.dropTmpTable(ctx, pool, tmpTable);
                throw throwable;
            }
        }
        this.dropTmpTable(ctx, pool, tmpTable);
    }

    private String createTmpTable(Context ctx, TempTablePool pool, List initDataIDList) throws Exception {
        String cSql = " create TABLE  t1 (FBenefitInitDataID varchar(44) not null primary key) ";
        String tmpTable = pool.createTempTable(cSql);
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTable + " (FBenefitInitDataID) values (?) \n");
        Object[] objects = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int s = initDataIDList.size();
        for (int i = 0; i < s; ++i) {
            objects = new Object[]{initDataIDList.get(i)};
            list.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, sbInsert.toString(), list);
        return tmpTable;
    }

    private void dropTmpTable(Context ctx, TempTablePool pool, String tableName) throws BOSException {
        try {
            if (tableName != null) {
                pool.releaseTable(tableName);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void updateInitState(Context ctx, String tmpTable) throws BOSException {
        String sql = "update t_hr_benefitinitdata set FIsEndInit = 1 where fid in ( select FBenefitInitDataID from " + tmpTable + " )";
        HRDbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateBalance(Context ctx, String atTypeID, List initDataIDList) throws BOSException, EASBizException {
        try {
            IBenefitDataInitDetail iBDetail = BenefitDataInitDetailFactory.getLocalInstance(ctx);
            ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
            BenefitDataInitDetailCollection biddcoll = null;
            String preCmpID = null;
            String curPeriodID = null;
            CmpPeriodInfo preCmpInfo = null;
            CmpPeriodInfo curPerInfo = null;
            String updateSql = "update T_HR_AccountItemInput set fvalue = ? where FID = ?";
            StringBuffer sss = new StringBuffer();
            sss.append("select ad.FCurPeriodID from T_HR_BenefitInitData bid \n");
            sss.append(" inner join T_HR_AccountDetail ad on bid.FAccountdetailid = ad.fid \n");
            sss.append("where bid.FID ='");
            String sql = null;
            IRowSet rowSet = null;
            StringBuffer selectSql = null;
            int size = initDataIDList.size();
            for (int i = 0; i < size; ++i) {
                sql = sss.toString() + (String)initDataIDList.get(i) + "'";
                rowSet = HRDbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rowSet.next() || StringUtils.isEmpty((String)(curPeriodID = rowSet.getString("FCurPeriodID")))) continue;
                curPerInfo = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(curPeriodID));
                preCmpInfo = HRUtils.getCmpPeriodInfoByConstantServer((Context)ctx, (CmpPeriodInfo)curPerInfo, (int)-1);
                preCmpID = preCmpInfo.getId().toString();
                selectSql = new StringBuffer();
                selectSql.append(" select value, benefitInitData.cmpPeiod.id, accountItemInput.id ");
                selectSql.append(" where accountItemInput.item.id in");
                selectSql.append(BenefitUtils.getItemInSql(ctx, atTypeID));
                selectSql.append(" and benefitInitData.id ='");
                selectSql.append((String)initDataIDList.get(i));
                selectSql.append("' and benefitInitData.cmpPeriod.id = '" + preCmpID + "'");
                biddcoll = iBDetail.getBenefitDataInitDetailCollection(selectSql.toString());
                int js = biddcoll.size();
                for (int j = 0; j < js; ++j) {
                    HRDbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{biddcoll.get(j).getValue(), biddcoll.get(j).getAccountItemInput().getId().toString()});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean _checkHasInit(Context ctx, String atTypeID) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        StringBuffer selectSql = new StringBuffer("select fvalue from T_HR_BenefitUtil where FHROrgUnitID = '");
        selectSql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        selectSql.append("' and FAccountTypeID = '");
        selectSql.append(atTypeID);
        selectSql.append("' and FTYPE = 'HASENDINIT'");
        iRowSet = HRDbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            if (iRowSet.next()) {
                return !iRowSet.getString("fvalue").equals("false");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private HashMap initBenefitDataHis(Context ctx, String tmpTable) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT BD.FID AS FID, BD.FControlUnitID AS FControlUnitID, BD.FIsCheck AS FIsCheck,  \n");
        selectSql.append(" BD.FAccountDetailID AS FAccountDetailID, BD.FCmpPeriodID AS FCmpPeriodID, \n");
        selectSql.append(" BD.FHROrgUnitID AS FHROrgUnitID FROM T_HR_BenefitInitData BD \n");
        selectSql.append(" inner join " + tmpTable + " tmp on BD.fid = tmp.FBenefitInitDataID ");
        logger.debug((Object)("initBenefitDataHis selectSql : " + selectSql.toString()));
        IRowSet rows = HRDbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_HR_BenefitDataHis \n");
        insertSql.append(" (FID, FCreatorID, FCreateTime, FControlUnitID, FHROrgUnitID, FAccountDetailID, FCmpPeriodID) \n");
        insertSql.append(" VALUES (? ,? ,? ,? ,? ,?, ?) \n");
        logger.debug((Object)("initBenefitDataHis insertSql : " + insertSql.toString()));
        BOSObjectType bosType = new BenefitDataHisInfo().getBOSType();
        Date fcreateTime = new Date(new java.util.Date().getTime());
        String createId = ctx.getCaller().toString();
        String id = null;
        Object[] param = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rows.next()) {
                id = BOSUuid.create((BOSObjectType)bosType).toString();
                map.put(rows.getString("FID"), id);
                param = new Object[]{id, createId, fcreateTime, rows.getString("FControlUnitID"), rows.getString("FHROrgUnitID"), rows.getString("FAccountDetailID"), rows.getString("FCmpPeriodID")};
                HRDbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])param);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void initBenefitDataDetailHis(Context ctx, HashMap map, String tempTable) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT BDD.FValue AS FValue,   \n");
        selectSql.append(" BDD.FBenefitInitDataID AS FBenefitInitDataID,  \n");
        selectSql.append(" BDD.FAccountItemInputID AS FAccountItemInputID \n");
        selectSql.append(" FROM T_HR_BenefitInitData BD INNER JOIN \n");
        selectSql.append(" t_hr_benefitdatainitdetail BDD ON BD.FID = BDD.FBenefitInitDataID \n");
        selectSql.append(" INNER JOIN ").append(tempTable).append(" temp on BD.FID = temp.FBenefitInitDataID ");
        logger.debug((Object)("initBenefitDataDetailHis selectSql : " + selectSql.toString()));
        IRowSet rows = HRDbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_HR_BenefitDataDetailHis \n");
        insertSql.append(" (FID, FValue, FTotalValue,  \n");
        insertSql.append(" FExistsComplementary, FAccountItemInputID, FBenefitDataHisID) \n");
        insertSql.append(" VALUES (? ,? ,? ,? ,? ,? ) \n");
        logger.debug((Object)("initBenefitDataDetailHis insertSql : " + insertSql.toString()));
        BOSObjectType bosType = new BenefitDataDetailHisInfo().getBOSType();
        String id = null;
        BigDecimal value = null;
        Object[] param = null;
        try {
            while (rows.next()) {
                id = BOSUuid.create((BOSObjectType)bosType).toString();
                value = rows.getBigDecimal("FValue");
                param = new Object[]{id, value, value, Boolean.FALSE, rows.getString("FAccountItemInputID"), map.get(rows.getString("FBenefitInitDataID"))};
                HRDbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])param);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

