/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountFactory;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccount;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.app.AbstractAccountQueryListUIHandler;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;

public class AccountQueryListUIHandler
extends AbstractAccountQueryListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        AccountTypeInfo accountTypeInfo;
        this.hasInitPeriod(context);
        String accountId = this.getCurAccountId(request, context);
        super._handleInit(request, response, context);
        AccountTypeCollection accountTypeInfos = this.getAccountTypeCollection(context);
        this.getRowSet(request, context);
        IQueryExecutor iexec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)request.getQueryPK());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        if (null != accountTypeInfos && accountTypeInfos.size() > 0 && null != (accountTypeInfo = accountTypeInfos.get(0)) && null != accountTypeInfo.getId()) {
            String atID = accountTypeInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atID));
        }
        if (null != ContextUtil.getCurrentHRUnit((Context)context) && null != ContextUtil.getCurrentHRUnit((Context)context).getId()) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)context).getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("benefitItem.isDisplay", (Object)1));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo mainQuery = new EntityViewInfo();
        mainQuery.setFilter(filter);
        iexec.setObjectView(mainQuery);
        iexec.doAllQueryTask(null, 0, 30, null, true);
    }

    private void getDataRowSet(Context context, String accountId, AccountTypeCollection accountTypeInfos, CmpPeriodInfo cmpPeriodInfo) throws Exception {
        String atID = null;
        if (null != accountTypeInfos.get(0)) {
            atID = accountTypeInfos.get(0).getId().toString();
        }
        if (null != accountId && null != atID) {
            this.getDataRow(context, accountId, atID, cmpPeriodInfo);
        }
    }

    private CmpPeriodInfo getCmpPeriodCollection(Context context, CmpPeriodInfo currCmpPeriod, int constant) throws BOSException {
        ICmpPeriod iCmpPeriod = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (null != ContextUtil.getCurrentHRUnit((Context)context)) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)context).getId().toString()));
            iCmpPeriod = CmpPeriodFactory.getLocalInstance((Context)context);
            entityViewInfo.setFilter(filter);
            SorterItemInfo sortInfo = new SorterItemInfo("begindate");
            sortInfo.setSortType(SortType.ASCEND);
            entityViewInfo.getSorter().add(sortInfo);
            CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
            if (cmpPeriodColl == null || cmpPeriodColl.size() <= 1) {
                return null;
            }
            String id = currCmpPeriod.getId().toString();
            String temp = null;
            int size = cmpPeriodColl.size();
            for (int i = 0; i < size; ++i) {
                temp = cmpPeriodColl.get(i).getId().toString();
                if (!temp.equals(id)) continue;
                if (constant > 0) {
                    if (size > constant + i) {
                        return cmpPeriodColl.get(constant + i);
                    }
                    return null;
                }
                if (constant < 0) {
                    if (i >= -constant) {
                        return cmpPeriodColl.get(i + constant);
                    }
                    return null;
                }
                return cmpPeriodColl.get(i);
            }
        }
        return null;
    }

    private AccountTypeCollection getAccountTypeCollection(Context context) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String strHROrgID = null;
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)context);
        if (null != hrOrgUnitInfo) {
            strHROrgID = hrOrgUnitInfo.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)strHROrgID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        return AccountTypeFactory.getLocalInstance(context).getAccountTypeCollection(view);
    }

    private String getCurAccountId(RequestContext request, Context context) throws BOSException, BenefitException {
        UserInfo info = ContextUtil.getCurrentUserInfo((Context)context);
        if (null != info && null != info.getPerson()) {
            String selectOQL = "select * where person.id = ";
            String personID = info.getPerson().getId().toString();
            IAccount iAccount = AccountFactory.getLocalInstance(context);
            AccountCollection accColl = iAccount.getAccountCollection(selectOQL + "'" + personID + "'");
            if (accColl.size() <= 0) {
                boolean isShowErr = false;
                if (null != request.get("isShowErr")) {
                    isShowErr = (Boolean)request.get("isShowErr");
                }
                if (isShowErr) {
                    isShowErr = false;
                    throw new BenefitException(BenefitException.NOT_ACCOUNT);
                }
                SysUtil.abort();
            }
            return accColl.get(0).getId().toString();
        }
        return null;
    }

    private void getRowSet(RequestContext request, Context context) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance((Context)context);
        EntityViewInfo view = new EntityViewInfo();
        qda.getRowSet(request.getQueryPK(), view, new HashMap(), new QueryExecuteOption(), 0, Integer.MAX_VALUE);
    }

    private void hasInitPeriod(Context context) throws BOSException, EASBizException {
        IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getLocalInstance(context);
        ibnf.hasInitPeriod();
    }

    private IRowSet getDataRow(Context context, String accountId, String atID, CmpPeriodInfo cmpPeriodInfo) throws Exception {
        IQueryExecutor iq = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.benefit.app.AccountDataQuery"));
        FilterInfo filter = new FilterInfo();
        ArrayList periodList = this.getPeriodListBy(cmpPeriodInfo, cmpPeriodInfo);
        CmpPeriodInfo info = null;
        int size = periodList.size();
        for (int i = 0; i < size; ++i) {
            info = (CmpPeriodInfo)periodList.get(i);
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)info.getId().toString()));
        }
        int count = filter.getFilterItems().size();
        StringBuffer sb = null;
        if (count >= 2) {
            sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i == 0) {
                    sb.append("#");
                } else {
                    sb.append(" or #");
                }
                sb.append(i);
            }
            filter.setMaskString(sb.toString());
        } else {
            filter.setMaskString("#0");
        }
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atID));
        int sum = filter.getFilterItems().size();
        sb = new StringBuffer();
        sb.append("#");
        sb.append(sum - 2);
        sb.append(" and #");
        sb.append(sum - 1);
        filter.setMaskString("(" + filter.getMaskString() + ") and " + sb.toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iq.setObjectView(evi);
        return iq.executeQuery();
    }

    private ArrayList getPeriodListBy(CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod) throws Exception {
        ArrayList<CmpPeriodInfo> periodList = new ArrayList<CmpPeriodInfo>();
        if (!endPeriod.getId().toString().equals(beginPeriod.getId().toString())) {
            CmpPeriodInfo nextPeriod = beginPeriod;
            CmpPeriodInfo tmp = null;
            while (!nextPeriod.getId().toString().equals(endPeriod.getId().toString())) {
                periodList.add(nextPeriod);
                tmp = HRUtils.getNextCmpPeriodInfoClient((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)nextPeriod.getId().toString())));
                if (tmp == null) break;
                nextPeriod = tmp;
            }
        }
        periodList.add(endPeriod);
        return periodList;
    }
}

