/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountSettleFacade;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.app.AbstractAccountSettleFacadeControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AccountSettleFacadeControllerBean
extends AbstractAccountSettleFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.benefit.app.AccountSettleFacadeControllerBean");

    protected void _settleAccountData(Context ctx, String accountTypeID, String cmpPeriodID, String admin, boolean includeSubOrg) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new AccountSettleFacade().getType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTSETTLE"), (String)"AccountSettle");
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String tmptableName = null;
        TempTablePool pool = null;
        try {
            String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            HashSet adminSet = BenefitUtils.getUserRangeAdminOrg(ctx, admin, includeSubOrg);
            List personList = this.getSettleAccountPerson(ctx, hrOrgUnitID, accountTypeID, cmpPeriodID, adminSet);
            pool = TempTablePool.getInstance((Context)ctx);
            tmptableName = this.createSettleAccountPersonTable(ctx, pool, personList);
            this.updateAiiValue(ctx, hrOrgUnitID, accountTypeID, cmpPeriodID, tmptableName);
            this.deleteBenefitData(ctx, hrOrgUnitID, accountTypeID, cmpPeriodID, tmptableName);
            this.updateAccountInfo(ctx, accountTypeID, cmpPeriodID, tmptableName);
            this.deleteTmpTable(ctx, hrOrgUnitID, accountTypeID, cmpPeriodID, tmptableName);
            this.updatePeriod(ctx, hrOrgUnitID, accountTypeID, cmpPeriodID, tmptableName);
            this.setHasBenefitBiz(ctx, hrOrgUnitID, accountTypeID, tmptableName);
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                this.dropTmpTable(ctx, pool, tmptableName);
                throw throwable;
            }
        }
        this.dropTmpTable(ctx, pool, tmptableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private List getSettleAccountPerson(Context ctx, String hrOrgUnitID, String accountTypeId, String cmpPeriodID, HashSet adminSet) throws BOSException {
        String temporaryTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (adminSet.size() > 500) {
            temporaryTableName = BenefitUtils.createTempTableName(ctx, "FAdminOrgid", "settleAccountPersonTempTable", adminSet);
        }
        ArrayList<String> personList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select p.FID as personID from T_BD_Person p \n");
            sb.append(" inner join T_HR_Account a on a.FPersonID = p.FID \n");
            sb.append(" inner join T_HR_AccountDetail ad on ad.FAccountid = a.FID \n");
            sb.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = p.FID \n");
            if (adminSet.size() > 500) {
                sb.append(" inner join ");
                sb.append(temporaryTableName);
                sb.append(" temp on pp.FPersonDep = temp.FAdminOrgid \n");
            }
            sb.append(" where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
            sb.append(" and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
            sb.append("\tand ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
            sb.append(" and ad.FPayState = 10 \n");
            if (adminSet.size() <= 500) {
                sb.append("\tand pp.FPersonDep in ");
                sb.append(BenefitUtils.getStrFromSet(adminSet));
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rows.next()) {
                if (personList.contains(rows.getString("personID"))) continue;
                personList.add(rows.getString("personID"));
            }
            sb = new StringBuffer();
            sb.append(" select distinct fp.fpersonid as personID from t_hr_fluctuationPerson fp \n");
            sb.append(" inner join t_hr_account a on a.fpersonid = fp.fpersonid \n");
            sb.append(" inner join T_HR_AccountDetail ad on ad.FAccountid = a.FID \n");
            if (adminSet.size() > 500) {
                sb.append(" inner join ");
                sb.append(temporaryTableName);
                sb.append(" temp on fp.FOldAdminOrgID = temp.FAdminOrgid \n");
            }
            sb.append(" where fp.FTranInOldDep =1 \n");
            sb.append(" and a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
            sb.append(" and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
            sb.append("\tand ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
            sb.append(" and ad.FPayState = 10 \n");
            if (adminSet.size() <= 500) {
                sb.append(" and fp.FOldAdminOrgID in ");
                sb.append(BenefitUtils.getStrFromSet(adminSet));
            }
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rows.next()) {
                if (personList.contains(rows.getString("personID"))) continue;
                personList.add(rows.getString("personID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            if (temporaryTableName != null) {
                pool.releaseTable(temporaryTableName);
            }
        }
        return personList;
    }

    private String createSettleAccountPersonTable(Context ctx, TempTablePool pool, List personList) throws BOSException {
        String cSql = " create TABLE  t1 (FPersonID varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            logger.error((Object)cSql.toString());
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FPersonID ) values (?) \n");
        Object[] objects = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int s = personList.size();
        for (int i = 0; i < s; ++i) {
            objects = new Object[]{personList.get(i)};
            list.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, sbInsert.toString(), list);
        return tmpTableName;
    }

    private void dropTmpTable(Context ctx, TempTablePool pool, String tableName) throws BOSException {
        try {
            if (tableName != null) {
                pool.releaseTable(tableName);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void setHasBenefitBiz(Context ctx, String hrOrgUnitID, String accountTypeID, String tmptableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_hr_accountdetail set fhasbenefitbiz = 1 ");
        sql.append(" where exists \n");
        sql.append(" (select ad.fid from t_hr_accountdetail ad \n");
        sql.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
        sql.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sql.append(" where (ad.fhasbenefitbiz = 0 or fhasbenefitbiz is null ) \n");
        sql.append(" and a.fhrorgunitid ='").append(hrOrgUnitID).append("'");
        sql.append(" and ad.faccounttypeid ='").append(accountTypeID).append("'");
        sql.append(" and t_hr_accountdetail.fid = ad.fid ");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateAiiValue(Context ctx, String hrOrgUnitID, String accountTypeId, String cmpPeriodID, String tmptableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append("update T_HR_AccountItemInput \n");
        sb.append("\tset FValue = (select T.FEMP_BALA \n");
        sb.append("\t\tfrom T_HR_AccountSettleTmp T \n");
        sb.append("\t\twhere T.FEMP_BALA_INPUT_ID = FID ) \n");
        sb.append("where exists \n ");
        sb.append("(select tmp.FEMP_BALA_INPUT_ID from T_HR_AccountSettleTmp tmp \n");
        sb.append("inner join T_HR_AccountDetail ad on tmp.FAccountDetailID = ad.FID \n");
        sb.append("inner join T_HR_Account a on tmp.FAccountID = a.FID \n");
        sb.append(" inner join " + tmptableName + " tmpTable on a.fpersonid = tmpTable.FPersonID \n");
        sb.append("where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("and ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
        sb.append("and  T_HR_AccountItemInput.fid = tmp.FEMP_BALA_INPUT_ID \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        sb.append("Update T_HR_AccountItemInput  \n");
        sb.append("\tset FValue = (select T.FCOM_BALA \n");
        sb.append("\t\tfrom T_HR_AccountSettleTmp T \n");
        sb.append("\t\twhere T.FCOM_BALA_INPUT_ID = FID )\n");
        sb.append("where exists \n");
        sb.append("(select tmp.FCOM_BALA_INPUT_ID from T_HR_AccountSettleTmp tmp \n");
        sb.append("inner join T_HR_AccountDetail ad on tmp.FAccountDetailID = ad.FID \n");
        sb.append("inner join T_HR_Account a on tmp.FAccountID = a.FID \n");
        sb.append(" inner join " + tmptableName + " tmpTable on a.fpersonid = tmpTable.FPersonID \n");
        sb.append("where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("and ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
        sb.append("and  T_HR_AccountItemInput.fid = tmp.FCOM_BALA_INPUT_ID \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        sb.append("Update T_HR_AccountItemInput  \n");
        sb.append("\tset FValue = (select T.FBALANCE \n");
        sb.append("\t\tfrom T_HR_AccountSettleTmp T \n");
        sb.append("\t\twhere T.FBALANCE_INPUT_ID = FID )\n");
        sb.append("where exists \n");
        sb.append("(select tmp.FBALANCE_INPUT_ID from T_HR_AccountSettleTmp tmp \n");
        sb.append("inner join T_HR_AccountDetail ad on tmp.FAccountDetailID = ad.FID \n");
        sb.append("inner join T_HR_Account a on tmp.FAccountID = a.FID \n");
        sb.append(" inner join " + tmptableName + " tmpTable on a.fpersonid = tmpTable.FPersonID \n");
        sb.append("where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("and ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
        sb.append("and  T_HR_AccountItemInput.fid = tmp.FBALANCE_INPUT_ID \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void deleteBenefitData(Context ctx, String hrOrgUnitID, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("(select bd.FID \n");
        sb.append("from T_HR_Benefitdata  bd \n");
        sb.append("inner join T_HR_AccountDetail ad on bd.FaccountDetailID = ad.FID \n");
        sb.append("inner join T_HR_Account a on ad.FAccountID = a.FID \n ");
        sb.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("where bd.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and bd.FCmpPeriodID = '").append(cmpPeriodId).append("' \n");
        sb.append("and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("and a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and T_HR_BenefitDataDetail.FBenefitDataID = bd.FID \n");
        sb.append(" )");
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from T_HR_BenefitDataDetail \n");
        delSql.append("where exists \n");
        delSql.append(sb.toString());
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        sb = new StringBuffer();
        sb.append("delete from T_HR_Benefitdata where exists ( \n");
        sb.append("select ad.FID from T_HR_AccountDetail ad \n");
        sb.append("inner join T_HR_Account a on ad.FAccountID = a.FID \n ");
        sb.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("where ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("and a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and T_HR_Benefitdata.faccountdetailid = ad.FID \n");
        sb.append(" )");
        sb.append("and  FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append("and FCmpPeriodID = '").append(cmpPeriodId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void deleteTmpTable(Context ctx, String hrOrgUnitID, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" (select ad.FID from T_HR_AccountDetail ad \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.FID \n");
        sb.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append(" where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append(" and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("\tand ad.FCurPeriodID ='").append(cmpPeriodId).append("' \n");
        sb.append(" )");
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from T_HR_AccountSettleTmp \n");
        delSql.append("where FHrorgunitID = '").append(hrOrgUnitID).append("' \n");
        delSql.append("and FAccountTypeID = '").append(accountTypeId).append("' \n");
        delSql.append(" and FAccountDetailID in ");
        delSql.append(sb.toString());
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        delSql = new StringBuffer();
        delSql.append("delete from T_HR_Benefitadjustdatatmp \n");
        delSql.append("where FHrorgunitID = '").append(hrOrgUnitID).append("' \n");
        delSql.append("and FAccountTypeID = '").append(accountTypeId).append("' \n");
        delSql.append("and FCurCmpPeriodID = '").append(cmpPeriodId).append("' \n");
        delSql.append("and FAccountDetailID in ");
        delSql.append(sb.toString());
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    private void updateAccountInfo(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        LowTimer t = new LowTimer();
        t.reset();
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append("update T_HR_AccountItemInput set FValue = 0 \n");
        sb.append("where exists \n");
        sb.append("\t\t(select aii.FID \n");
        sb.append("\t\tfrom T_HR_Account a \n");
        sb.append("\t\tinner join T_HR_AccountDetail ad on a.FID = ad.FAccountID  \n");
        sb.append("\t\tinner join T_HR_AccountItemInput aii on ad.FID = aii.FAccountDetailId \n");
        sb.append("\t\tinner join T_HR_Item i on i.FID = aii.FItemID \n");
        sb.append(" \tinner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("\t\twhere ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("\t\tand ad.FCurPeriodID = '").append(cmpPeriodId).append("' \n");
        sb.append(" \tand (i.FBenefitItemNumber ='").append("Emp_Accr").append("' \n");
        sb.append("\t\tor i.FBenefitItemNumber ='").append("Com_Accr").append("') \n");
        sb.append("\tand T_HR_AccountItemInput.fid = aii.FID \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void updatePeriod(Context ctx, String hrOrgUnitID, String accountTypeId, String cmpPeriodID, String tmptableName) throws BOSException, EASBizException {
        IBenefitInvokeFacade ibif = BenefitInvokeFacadeFactory.getLocalInstance(ctx);
        CmpPeriodInfo newCmpPeriod = ibif.getNextPeriod(cmpPeriodID);
        if (newCmpPeriod == null) {
            throw new BOSException("next cmpPeriod is null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_HR_AccountDetail set FCurPeriodID = '");
        sb.append(newCmpPeriod.getId().toString()).append("' \n");
        sb.append(" where exists ");
        sb.append(" (select ad.FID from T_HR_AccountDetail ad \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.FID \n");
        sb.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append(" where a.FHROrgUnitID = '").append(hrOrgUnitID).append("' \n");
        sb.append(" and ad.FAccountTypeID = '").append(accountTypeId).append("' \n");
        sb.append("\tand ad.FCurPeriodID ='").append(cmpPeriodID).append("' \n");
        sb.append("\tand  T_HR_AccountDetail.FID = ad.FID \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }
}

