/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.app.AbstractAccountTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class AccountTypeControllerBean
extends AbstractAccountTypeControllerBean {
    private static final long serialVersionUID = 1L;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        AccountTypeInfo atInfo = (AccountTypeInfo)model;
        this._checkNameDup(ctx, model);
        pk = super._addnew(ctx, model);
        this._updateBenefit(ctx, pk, (ArrayList)atInfo.get("ids"));
        this.addInitPeriod(ctx, pk);
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountTypeInfo info = (AccountTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        String hrOrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgID));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private void addInitPeriod(Context ctx, IObjectPK pk) throws BOSException {
        try {
            String initPeriod = null;
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            String insertSql = "Insert Into T_HR_BenefitUtil(FType, FHROrgUnitID, FValue, FAccountTypeID) Values (?, ?, ?, ?)";
            String sql = "select top 1 Fvalue from t_hr_benefitutil where Ftype = ? and FHROrgUnitID = ?";
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"INITPERIOD", hrOrgUnitId});
            if (rows.next()) {
                initPeriod = rows.getString("Fvalue");
            }
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{"INITPERIOD", hrOrgUnitId, initPeriod, pk.toString()});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void _updateBenefit(Context ctx, IObjectPK pk, ArrayList list) throws BOSException, EASBizException {
        IAccountType iAccountType = AccountTypeFactory.getLocalInstance(ctx);
        AccountTypeInfo accountTypeInfo = iAccountType.getAccountTypeInfo(pk);
        StringBuffer sb = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            sb = new StringBuffer();
            sb.append("update t_hr_benefit set fAccountTypeID = '");
            sb.append(accountTypeInfo.getId().toString());
            sb.append("' where FID = '");
            sb.append(list.get(i).toString());
            sb.append("'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountTypeInfo atInfo = (AccountTypeInfo)model;
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
        this._setAccountNull(ctx, atInfo.getId().toString());
        this._updateBenefit(ctx, pk, (ArrayList)atInfo.get("ids"));
    }

    private void _setAccountNull(Context ctx, String accId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_benefit set fAccountTypeID = null where fAccountTypeID = '");
        sb.append(accId);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._setAccountNull(ctx, pk.toString());
        super._delete(ctx, pk);
    }

    protected boolean _accountTypehasUsed(Context ctx, String accountTypeID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 * from T_HR_AccountDetail where FAccountTypeID ='");
        sb.append(accountTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return rows.size() > 0;
    }
}

