/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.BenefitDataImportFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitItemCollection;
import com.kingdee.eas.hr.benefit.BenefitItemFactory;
import com.kingdee.eas.hr.benefit.BenefitItemInfo;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IBenefitDataImportFacade;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Hashtable;

public class AccrInputDataImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AccountItemInputInfo aiiInfo = null;
        String str = null;
        try {
            str = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            this.getPersonInfo(ctx, str, "number");
            str = (String)((DataToken)hsData.get((Object)"FAcounts")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            AccountDetailInfo adInfo = this.getAdInfo(ctx, str);
            str = (String)((DataToken)hsData.get((Object)"FBenefitNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENE_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            String strTemp = str;
            str = (String)((DataToken)hsData.get((Object)"FBenefitItemNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEITEM_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            if (!"Emp_Accr".equals(str) && !"Com_Accr".equals(str)) {
                throw new TaskExternalException(str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENENUM_VALID"));
            }
            aiiInfo = BenefitUtils.getAiiInfo(ctx, BenefitUtils.getItemInfoByNum(ctx, strTemp, str).getId().toString(), adInfo.getId().toString());
            str = (String)((DataToken)hsData.get((Object)"Fvalue")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            try {
                new BigDecimal(str);
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + "[" + str + "]" + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.INVALIDATE_NUMBER"));
            }
            BenefitItemInfo info = this.getBenefitItemInfo(ctx);
            if (info != null) {
                int length = info.getLength();
                int precision = info.getPrecision();
                if (str.indexOf(".") == -1 && str.length() > length - precision || str.indexOf(".") > -1 && (str.substring(0, str.indexOf(".")).length() > length - precision || str.substring(str.indexOf(".") + 1).length() > precision)) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + "[" + str + "]" + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCRVALUE"));
                }
            }
            aiiInfo.setValue(new BigDecimal(str));
        }
        catch (ObjectNotFoundException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFIT_ITEM_NOT_NULL"));
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return aiiInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IBenefitDataImportFacade iBenefitDataImportFacade = BenefitDataImportFacadeFactory.getLocalInstance(ctx);
            AccountItemInputInfo info = (AccountItemInputInfo)coreBaseInfo;
            iBenefitDataImportFacade.importAccrData(info);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private AccountDetailInfo getAdInfo(Context ctx, String str) throws BOSException, EASBizException, TaskExternalException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection adInfo = null;
        String selectSql = "select * where accounts = '" + str + "'";
        adInfo = iAccountDetail.getAccountDetailCollection(selectSql);
        if (adInfo == null || adInfo.size() == 0) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
        }
        return adInfo.get(0);
    }

    private PersonInfo getPersonInfo(Context ctx, String str, String filterName) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(filterName, (Object)str));
        view.setFilter(filterInfo);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection(view);
        if (personColl == null || personColl.size() == 0) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
        }
        return personColl.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        return ExportUtil.transeExport(rs, ExportUtil.ACCR_MAP);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("item.benefitItemNumber", (Object)"Com_Accr"));
        filterInfo.getFilterItems().add(new FilterItemInfo("item.benefitItemNumber", (Object)"Emp_Accr"));
        filterInfo.getFilterItems().add(new FilterItemInfo("value", (Object)"0", CompareType.NOTEQUALS));
        filterInfo.setMaskString("(#0 or #1) and #2");
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.benefit.app.AccrAndRadixQuery";
    }

    private BenefitItemInfo getBenefitItemInfo(Context ctx) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"Base_insu"));
        filterInfo.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        BenefitItemCollection coll = BenefitItemFactory.getLocalInstance(ctx).getBenefitItemCollection(view);
        if (coll != null) {
            return coll.get(0);
        }
        return null;
    }
}

