/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountFactory;
import com.kingdee.eas.hr.benefit.AccountInfo;
import com.kingdee.eas.hr.benefit.AccountItemInputCollection;
import com.kingdee.eas.hr.benefit.AccountItemInputFactory;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataCollection;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataDetailCollection;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataDetailFactory;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataFactory;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitRuleFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccount;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IAccountItemInput;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IBenefit;
import com.kingdee.eas.hr.benefit.IBenefitAdjustData;
import com.kingdee.eas.hr.benefit.IBenefitAdjustDataDetail;
import com.kingdee.eas.hr.benefit.IItem;
import com.kingdee.eas.hr.benefit.ItemCollection;
import com.kingdee.eas.hr.benefit.ItemFactory;
import com.kingdee.eas.hr.benefit.ItemInfo;
import com.kingdee.eas.hr.benefit.OperateTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.emp.ISocialInsurance;
import com.kingdee.eas.hr.emp.SocialInsuranceCollection;
import com.kingdee.eas.hr.emp.SocialInsuranceFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class BenefitAdjustImportData
extends AbstractDataTransmission {
    private String strResourceURL = "com.kingdee.eas.hr.emp.EmployeeInputResource";
    public boolean isFirst = true;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BenefitAdjustDataDetailFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        BenefitAdjustDataDetailInfo info = null;
        BenefitCollection benefitCol = null;
        ItemInfo itemInfo = null;
        AccountInfo accountInfo = null;
        String accountTypeId = null;
        boolean accountTypeHasBenefit = false;
        String str = null;
        HashMap<ItemInfo, String> itemMap = null;
        try {
            str = (String)((DataToken)hsData.get((Object)"FOperateType")).data;
            this.verifyOperateType(ctx, str);
            int intOperateType = Integer.parseInt(str);
            OperateTypeEnum oprtEnum = OperateTypeEnum.getEnum(intOperateType);
            Locale locale = ctx.getLocale();
            str = (String)((DataToken)hsData.get((Object)"FEmployeeNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_NULL", (Locale)locale));
            }
            PersonInfo personInfo = this.getPersonInfoByNumber(ctx, str, hrOrgUnitID);
            if (personInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
            }
            String personName = (String)((DataToken)hsData.get((Object)"FEmployeeName")).data;
            if (!StringUtils.isEmpty((String)personName) && !personInfo.getName().toString().equals(personName)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"3_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
            this.verifyPersonIsSocialInsu(ctx, personInfo);
            String accounts = (String)((DataToken)hsData.get((Object)"FAccounts")).data;
            if (StringUtils.isEmpty((String)accounts)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"4_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
            accountInfo = this.getAccountInfoByPerson(ctx, personInfo.getId().toString());
            if (accountInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"18_BenefitAdjustImportData", (Locale)ctx.getLocale()) + personInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"21_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            String accountTypeNumber = (String)((DataToken)hsData.get((Object)"FAccountTypeNumber")).data;
            if (StringUtils.isEmpty((String)accountTypeNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"5_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
            AccountTypeInfo accountTypeInfo = this.getAccountTypeInfoByNumber(ctx, accountTypeNumber, hrOrgUnitID);
            if (accountTypeInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"6_BenefitAdjustImportData", (Locale)ctx.getLocale()) + accountTypeNumber + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"7_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            accountTypeId = accountTypeInfo.getId().toString();
            try {
                benefitCol = BenefitRuleFacadeFactory.getLocalInstance(ctx).getBenefitColl(accountTypeId);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            String benefitNumber = (String)((DataToken)hsData.get((Object)"FBenefitNumber")).data;
            if (StringUtils.isEmpty((String)benefitNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"8_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
            BenefitInfo benefitInfo = this.getBenefitInfoByNumber(ctx, benefitNumber, hrOrgUnitID);
            if (benefitInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"10_BenefitAdjustImportData", (Locale)ctx.getLocale()) + benefitNumber + "\u3011");
            for (int i = 0; i < benefitCol.size(); ++i) {
                if (!benefitInfo.getId().toString().equals(benefitCol.get(i).getId().toString())) continue;
                accountTypeHasBenefit = true;
                itemMap = new HashMap<ItemInfo, String>();
                String base_insu = (String)((DataToken)hsData.get((Object)"FBenefitItem.Base_insu")).data;
                this.verifyString(ctx, base_insu);
                if (!StringUtils.isEmpty((String)base_insu)) {
                    String benefitItemNumber = "Base_insu";
                    itemInfo = this.getItemInfo(ctx, benefitInfo, benefitItemNumber, hrOrgUnitID);
                    itemMap.put(itemInfo, base_insu);
                }
                String emp_insu = (String)((DataToken)hsData.get((Object)"FBenefitItem.Emp_insu")).data;
                this.verifyString(ctx, emp_insu);
                if (!StringUtils.isEmpty((String)emp_insu)) {
                    String benefitItemNumber = "Emp_insu";
                    itemInfo = this.getItemInfo(ctx, benefitInfo, benefitItemNumber, hrOrgUnitID);
                    itemMap.put(itemInfo, emp_insu);
                }
                String com_insu = (String)((DataToken)hsData.get((Object)"FBenefitItem.Com_insu")).data;
                this.verifyString(ctx, com_insu);
                if (!StringUtils.isEmpty((String)com_insu)) {
                    String benefitItemNumber = "Com_insu";
                    itemInfo = this.getItemInfo(ctx, benefitInfo, benefitItemNumber, hrOrgUnitID);
                    itemMap.put(itemInfo, com_insu);
                }
                String emp_sum = (String)((DataToken)hsData.get((Object)"FBenefitItem.Emp_sum")).data;
                this.verifyString(ctx, emp_sum);
                if (!StringUtils.isEmpty((String)emp_sum)) {
                    String benefitItemNumber = "Emp_Sum";
                    itemInfo = this.getItemInfo(ctx, benefitInfo, benefitItemNumber, hrOrgUnitID);
                    itemMap.put(itemInfo, emp_sum);
                }
                String com_sum = (String)((DataToken)hsData.get((Object)"FBenefitItem.Com_sum")).data;
                this.verifyString(ctx, com_sum);
                if (StringUtils.isEmpty((String)com_sum)) continue;
                String benefitItemNumber = "Com_Sum";
                itemInfo = this.getItemInfo(ctx, benefitInfo, benefitItemNumber, hrOrgUnitID);
                itemMap.put(itemInfo, com_sum);
            }
            if (!accountTypeHasBenefit) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"6_BenefitAdjustImportData", (Locale)ctx.getLocale()) + accountTypeNumber + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"9_BenefitAdjustImportData", (Locale)ctx.getLocale()) + benefitNumber + "\u3011");
            }
            AccountDetailInfo accountDetailInfo = this.getAccountDetailInfoByAccount(ctx, accountInfo, accounts);
            if (accountDetailInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"18_BenefitAdjustImportData", (Locale)ctx.getLocale()) + personInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"19_BenefitAdjustImportData", (Locale)ctx.getLocale()) + accounts + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"20_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            CmpPeriodInfo curPeriodInfo = accountDetailInfo.getCurPeriod();
            String cmpPeriodHisNumber = (String)((DataToken)hsData.get((Object)"FCmpPeriodHisNumber")).data;
            if (StringUtils.isEmpty((String)cmpPeriodHisNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"11_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
            CmpPeriodInfo cmpPeriodHisInfo = this.getCmpPeriodHisInfoByNumber(ctx, cmpPeriodHisNumber, hrOrgUnitID);
            if (cmpPeriodHisInfo == null || curPeriodInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"17_BenefitAdjustImportData", (Locale)ctx.getLocale()) + cmpPeriodHisNumber);
            this.checkHisPeriod(ctx, cmpPeriodHisInfo, curPeriodInfo);
            BenefitAdjustDataInfo benefitAdjustDataInfo = this.getBenefitAdjustDataInfoByAccountDetail(ctx, accountDetailInfo, curPeriodInfo, cmpPeriodHisInfo, intOperateType);
            if (benefitAdjustDataInfo == null) {
                benefitAdjustDataInfo = new BenefitAdjustDataInfo();
                benefitAdjustDataInfo.setCmpPeriod(curPeriodInfo);
                benefitAdjustDataInfo.setCmpPeriodHis(cmpPeriodHisInfo);
                benefitAdjustDataInfo.setAccountDetail(accountDetailInfo);
                benefitAdjustDataInfo.setIsCheck(false);
                benefitAdjustDataInfo.setOperateType(oprtEnum);
                try {
                    BenefitAdjustDataFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)benefitAdjustDataInfo);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else if (benefitAdjustDataInfo.isIsCheck()) {
                try {
                    throw new BenefitException(BenefitException.ADJUST_DATA_ERROR, new Object[]{personInfo.getNumber(), cmpPeriodHisInfo.getNumber()});
                }
                catch (BenefitException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
                }
            }
            Object[] o = itemMap.entrySet().toArray();
            for (int i = 0; i < itemMap.size(); ++i) {
                Map.Entry x = (Map.Entry)o[i];
                itemInfo = (ItemInfo)x.getKey();
                String strValue = x.getValue().toString();
                BigDecimal value = new BigDecimal(strValue);
                AccountItemInputInfo accountItemInputInfo = this.getAccountItemInput(ctx, itemInfo, accountDetailInfo);
                if (accountItemInputInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"12_BenefitAdjustImportData", (Locale)ctx.getLocale()) + accountDetailInfo.getAccountType().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"15_BenefitAdjustImportData", (Locale)ctx.getLocale()) + itemInfo.getBenefitNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"16_BenefitAdjustImportData", (Locale)ctx.getLocale()));
                if (benefitAdjustDataInfo == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"12_BenefitAdjustImportData", (Locale)ctx.getLocale()) + accountDetailInfo.getAccountType().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"13_BenefitAdjustImportData", (Locale)ctx.getLocale()) + cmpPeriodHisNumber + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"14_BenefitAdjustImportData", (Locale)ctx.getLocale()));
                info = this.getBenefitAdjustDataDetailInfo(ctx, benefitAdjustDataInfo, accountItemInputInfo);
                if (info != null) {
                    info.setValue(value);
                    info.setOperateType(oprtEnum);
                    try {
                        BenefitAdjustDataDetailFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
                        continue;
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
                info = new BenefitAdjustDataDetailInfo();
                info.setValue(value);
                info.setOperateType(oprtEnum);
                info.setBenefitAdjustData(benefitAdjustDataInfo);
                info.setAccountItemInput(accountItemInputInfo);
                try {
                    BenefitAdjustDataDetailFactory.getLocalInstance(ctx).addnew(info);
                    continue;
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            if (itemMap.isEmpty()) {
                info = new BenefitAdjustDataDetailInfo();
                info.setBenefitAdjustData(benefitAdjustDataInfo);
                info.setOperateType(oprtEnum);
                try {
                    BenefitAdjustDataDetailFactory.getLocalInstance(ctx).addnew(info);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            info.put("FROM_IMPORT_SYSTEM", "TRUE");
            return info;
        }
        catch (BOSException bose) {
            throw new TaskExternalException(bose.getMessage(), (Throwable)bose);
        }
    }

    public PersonInfo getPersonInfoByNumber(Context ctx, String personNumber, String hrOrgUnitID) throws BOSException, TaskExternalException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pInfos = iPerson.getPersonCollection("select * Where number = '" + personNumber + "'");
        if (pInfos.size() > 0) {
            String perHRO;
            String curHRO = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            if (!curHRO.equals(perHRO = BenefitAdjustImportData.getPersonHRInfo(ctx, pInfos.get(0).getId().toString()))) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.OTHER_HRO_PERSON_01") + pInfos.get(0).getNumber() + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.OTHER_HRO_PERSON_02"));
            }
            return pInfos.get(0);
        }
        return null;
    }

    public AccountTypeInfo getAccountTypeInfoByNumber(Context ctx, String accountTypeNumber, String hrOrgUnitID) throws BOSException {
        IAccountType iAccountType = AccountTypeFactory.getLocalInstance(ctx);
        AccountTypeCollection accountTypeInfos = iAccountType.getAccountTypeCollection("select * Where number = '" + accountTypeNumber + "' and hrOrgUnit = '" + hrOrgUnitID + "'");
        if (accountTypeInfos.size() > 0) {
            return accountTypeInfos.get(0);
        }
        return null;
    }

    public AccountInfo getAccountInfoByPerson(Context ctx, String personId) throws BOSException {
        IAccount iAccount = AccountFactory.getLocalInstance(ctx);
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        AccountCollection accountInfos = iAccount.getAccountCollection("Where person ='" + personId.trim() + "' and hrOrgUnit.id ='" + hrOrgUnitID + "'");
        if (accountInfos.size() > 0) {
            return accountInfos.get(0);
        }
        return null;
    }

    public AccountDetailInfo getAccountDetailInfoByAccount(Context ctx, AccountInfo accountInfo, String accounts) throws BOSException {
        if (accountInfo.getId() == null) {
            return null;
        }
        IAccountDetail iAccounDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection accountDetailInfos = iAccounDetail.getAccountDetailCollection("select id,name,curPeriod.id, curPeriod.name, curPeriod.beginDate, curPeriod.number Where account ='" + accountInfo.getId().toString().trim() + "' and accounts='" + accounts + "'");
        if (accountDetailInfos.size() > 0) {
            return accountDetailInfos.get(0);
        }
        return null;
    }

    public BenefitAdjustDataInfo getBenefitAdjustDataInfoByAccountDetail(Context ctx, AccountDetailInfo accountDetailInfo, CmpPeriodInfo cmpPeriodInfo, CmpPeriodInfo cmpPeriodHisInfo, int operateType) throws BOSException {
        if (accountDetailInfo.getId() == null || cmpPeriodInfo.getId() == null || cmpPeriodHisInfo.getId() == null) {
            return null;
        }
        IBenefitAdjustData iBenefitAdjustDate = BenefitAdjustDataFactory.getLocalInstance(ctx);
        BenefitAdjustDataCollection benefitAdjustDataInfos = iBenefitAdjustDate.getBenefitAdjustDataCollection("select * Where accountDetail = '" + accountDetailInfo.getId().toString().trim() + "' and cmpPeriodHis = '" + cmpPeriodHisInfo.getId().toString().trim() + "' and cmpPeriod = '" + cmpPeriodInfo.getId().toString().trim() + "'" + " and operateType = " + operateType);
        if (benefitAdjustDataInfos.size() > 0) {
            return benefitAdjustDataInfos.get(0);
        }
        return null;
    }

    public CmpPeriodInfo getCmpPeriodHisInfoByNumber(Context ctx, String cmpPeriodNumber, String hrOrgUnitID) throws BOSException {
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance((Context)ctx);
        CmpPeriodCollection cmpPeriodInfos = iCmpPeriod.getCmpPeriodCollection("select * Where number = '" + cmpPeriodNumber.trim() + "' and hrOrgUnit = '" + hrOrgUnitID + "'");
        if (cmpPeriodInfos.size() > 0) {
            return cmpPeriodInfos.get(0);
        }
        return null;
    }

    public BenefitAdjustDataDetailInfo getBenefitAdjustDataDetailInfo(Context ctx, BenefitAdjustDataInfo benefitAdjustDataInfo, AccountItemInputInfo accountItemInputInfo) throws BOSException {
        if (benefitAdjustDataInfo.getId() == null || accountItemInputInfo.getId() == null) {
            return null;
        }
        IBenefitAdjustDataDetail iBenefitAdjustDateDetail = BenefitAdjustDataDetailFactory.getLocalInstance(ctx);
        BenefitAdjustDataDetailCollection benefitAdjustDataDetailInfos = iBenefitAdjustDateDetail.getBenefitAdjustDataDetailCollection("select * Where benefitAdjustData = '" + benefitAdjustDataInfo.getId().toString().trim() + "' and accountItemInput = '" + accountItemInputInfo.getId().toString().trim() + "'");
        if (benefitAdjustDataDetailInfos.size() > 0) {
            return benefitAdjustDataDetailInfos.get(0);
        }
        return null;
    }

    public BenefitInfo getBenefitInfoByNumber(Context ctx, String benefitNumber, String hrOrgUnitID) throws BOSException {
        IBenefit iBenefit = BenefitFactory.getLocalInstance(ctx);
        BenefitCollection benefitInfos = iBenefit.getBenefitCollection("select * Where number = '" + benefitNumber.trim() + "' and hrOrgUnit = '" + hrOrgUnitID + "'");
        if (benefitInfos.size() > 0) {
            return benefitInfos.get(0);
        }
        return null;
    }

    public ItemInfo getItemInfo(Context ctx, BenefitInfo benefitInfo, String benefitItemNumber, String hrOrgUnitID) throws BOSException {
        if (benefitInfo.getId() == null || hrOrgUnitID == null) {
            return null;
        }
        IItem iItem = ItemFactory.getLocalInstance(ctx);
        ItemCollection itemInfos = iItem.getItemCollection("select * Where benefit = '" + benefitInfo.getId().toString().trim() + "' and benefitItemNumber = '" + benefitItemNumber + "' and hrOrgUnit = '" + hrOrgUnitID + "'");
        if (itemInfos.size() > 0) {
            return itemInfos.get(0);
        }
        return null;
    }

    public AccountItemInputInfo getAccountItemInput(Context ctx, ItemInfo itemInfo, AccountDetailInfo accountDetailInfo) throws BOSException {
        if (itemInfo.getId() == null || accountDetailInfo.getId() == null) {
            return null;
        }
        IAccountItemInput iAccountItemInput = AccountItemInputFactory.getLocalInstance(ctx);
        AccountItemInputCollection accountItemInputInfos = iAccountItemInput.getAccountItemInputCollection("select * Where item = '" + itemInfo.getId().toString().trim() + "' and accountDetail = '" + accountDetailInfo.getId().toString().trim() + "'");
        if (accountItemInputInfos.size() > 0) {
            return accountItemInputInfos.get(0);
        }
        return null;
    }

    public void checkHisPeriod(Context ctx, CmpPeriodInfo cmpPeriodHisInfo, CmpPeriodInfo curPeriodInfo) throws BOSException, TaskExternalException {
        Date dtHis = cmpPeriodHisInfo.getBeginDate();
        Date dtCur = curPeriodInfo.getBeginDate();
        if (DateTimeUtils.dayBefore((Date)dtCur, (Date)dtHis) || DateTimeUtils.dayEquals((Date)dtCur, (Date)dtHis)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"22_BenefitAdjustImportData", (Locale)ctx.getLocale()) + cmpPeriodHisInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"23_BenefitAdjustImportData", (Locale)ctx.getLocale()) + curPeriodInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"24_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
    }

    public void verifyPersonIsSocialInsu(Context ctx, PersonInfo pInfo) throws BOSException, TaskExternalException {
        ISocialInsurance iSocialInsurance = SocialInsuranceFactory.getLocalInstance((Context)ctx);
        SocialInsuranceCollection socialInsuranceInfos = iSocialInsurance.getSocialInsuranceCollection("select id,name Where person ='" + pInfo.getId().toString().trim() + "' and isSocialInsu = 1");
        if (socialInsuranceInfos.size() == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"25_BenefitAdjustImportData", (Locale)ctx.getLocale()) + pInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"26_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
    }

    public void verifyString(Context ctx, String strBenefitItem) throws BOSException, TaskExternalException {
        if (StringUtils.isEmpty((String)strBenefitItem)) {
            return;
        }
        try {
            BigDecimal benefitItem = new BigDecimal(strBenefitItem);
            if (benefitItem.compareTo(new BigDecimal(0)) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"27_BenefitAdjustImportData", (Locale)ctx.getLocale()));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"27_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
    }

    public void verifyOperateType(Context ctx, String strOperateType) throws BOSException, TaskExternalException {
        int operateType;
        if (StringUtils.isEmpty((String)strOperateType)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"28_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
        try {
            operateType = Integer.parseInt(strOperateType.trim());
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"29_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
        OperateTypeEnum oprtEnum = OperateTypeEnum.getEnum(operateType);
        if (oprtEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"29_BenefitAdjustImportData", (Locale)ctx.getLocale()));
        }
    }

    public static String getPersonHRInfo(Context ctx, String personID) throws BOSException {
        String hrOrgID = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select unitRel.FToUnitID from T_ORG_UnitRelation unitRel \n");
        sql.append(" inner join T_ORG_TypeRelation typeRel on unitRel.FTypeRelationID = typeRel.FID \n");
        sql.append("\t\tand typeRel.FID ='00000000-0000-0000-0000-0000000000100FE9F8B5' \n");
        sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonDep = unitRel.FFromUnitID \n");
        sql.append(" where pp.FPersonID = '").append(personID).append("' \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                hrOrgID = rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrOrgID;
    }
}

