/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BaseInsuHistoryInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitRuleFactory;
import com.kingdee.eas.hr.benefit.BenefitRuleInfo;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.IBenefitRule;
import com.kingdee.eas.hr.benefit.app.AbstractBenefitCommonFacadeControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;

public class BenefitCommonFacadeControllerBean
extends AbstractBenefitCommonFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    public String localString;

    protected IObjectCollection _getAccDetailCollInPer(Context ctx, String pId) throws BOSException, EASBizException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection coll = null;
        if (pId != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(" select id,number,accountnumber,accounts,createDate,");
            sb.append(" paystate,stopdate,account.id,account.number,account.name, ");
            sb.append(" accountType.id,accountType.name,accountType.number, ");
            sb.append(" benefitRule.id,benefitRule.name,benefitRule.number,");
            sb.append(" retireTransactDate,retireNumber,fundItem,transactDate");
            sb.append(" where account.person.id = '" + pId + "'");
            sb.append(" and account.hrOrgUnit.id='");
            sb.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString() + "'");
            coll = iAccountDetail.getAccountDetailCollection(sb.toString());
        }
        return coll;
    }

    protected void _updateRadixValue(Context ctx, HashMap mapPerson) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new AccountItemInputInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.RADIX_ACCR_EDIT"), (String)"RadixInput_update");
        String personID = null;
        String itemID = null;
        BigDecimal value = null;
        HashMap mapItem = null;
        StringBuffer sqlSelect = null;
        IRowSet rowSet = null;
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        boolean isRecordBase = false;
        boolean isFromBase = false;
        String accountType = null;
        Object[] objectupdate = null;
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        Object[] objectinsert = null;
        ArrayList<Object[]> insertList = new ArrayList<Object[]>();
        Date createTime = new Date(new java.util.Date().getTime());
        if (mapPerson.get("accountType") != null) {
            isFromBase = true;
            accountType = mapPerson.get("accountType").toString();
            IBenefitInvokeFacade ibif = BenefitInvokeFacadeFactory.getLocalInstance(ctx);
            isRecordBase = ibif.EnableBaseInsuRecord(accountType);
            mapPerson.remove("accountType");
        }
        Set personSet = (Set)mapPerson.get("personSet");
        Set itemSet = (Set)mapPerson.get("itemSet");
        mapPerson.remove("personSet");
        mapPerson.remove("itemSet");
        String tempTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        HashMap<String, Object[]> aiiMap = new HashMap<String, Object[]>();
        HashMap<String, Object[]> itemMap = new HashMap<String, Object[]>();
        if (personSet.size() > 0) {
            try {
                tempTable = BenefitUtils.createTempTableName(ctx, "fpersonID", "radixOrAccrPersonTemp", personSet);
                sqlSelect = new StringBuffer("select aii.fid as fid,aii.fvalue as fvalue,\n");
                sqlSelect.append(" a.fid as account, i.fbenefitid as benefit,ad.FCurPeriodID as curPeriod \n");
                sqlSelect.append(" ,a.fpersonid as personid, aii.fitemid as itemid \n");
                sqlSelect.append(" from T_HR_Accountiteminput aii \n");
                sqlSelect.append(" inner join T_HR_Accountdetail ad on aii.fAccountDetailid = ad.fid \n");
                sqlSelect.append(" inner join t_hr_account a on ad.faccountID = a.fid ");
                sqlSelect.append(" inner join ").append(tempTable).append(" temp on temp.fpersonID = a.fpersonid ");
                sqlSelect.append(" inner join t_hr_item i on aii.fitemid = i.fid \n");
                sqlSelect.append(" where aii.fitemid in ").append(BenefitUtils.getStrFromSet(itemSet));
                sqlSelect.append(" and a.fhrorgunitid ='" + hrOrgUnit + "'");
                if (accountType != null) {
                    sqlSelect.append(" and ad.faccounttypeid = '").append(accountType).append("' ");
                }
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
                Object[] object = null;
                while (rowSet.next()) {
                    object = new Object[]{rowSet.getString("fid"), rowSet.getBigDecimal("fvalue"), rowSet.getString("account"), rowSet.getString("benefit"), rowSet.getString("curPeriod")};
                    aiiMap.put(rowSet.getString("personid") + rowSet.getString("itemid"), object);
                }
                StringBuffer adSQL = new StringBuffer();
                adSQL.append("select ad.fid as fid,a.fid as account,");
                adSQL.append("i.fbenefitid as benefit,ad.FCurPeriodID as curPeriod ");
                adSQL.append(" ,a.fpersonid as personid, i.fid as itemid \n");
                adSQL.append("from t_hr_accountdetail as ad ");
                adSQL.append("inner join t_hr_account a on ad.faccountID = a.fid ");
                adSQL.append(" inner join ").append(tempTable).append(" temp on temp.fpersonID = a.fpersonid ");
                adSQL.append("inner join t_hr_benefit b on b.faccounttypeid = ad.faccounttypeid ");
                adSQL.append("inner join t_hr_item i on i.fbenefitid = b.fid ");
                adSQL.append(" where i.fid in ").append(BenefitUtils.getStrFromSet(itemSet));
                adSQL.append(" and a.fhrorgunitid ='" + hrOrgUnit + "'");
                if (accountType != null) {
                    adSQL.append(" and ad.faccounttypeid = '").append(accountType).append("' ");
                }
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)adSQL.toString());
                Object[] object1 = null;
                while (rows.next()) {
                    object1 = new Object[]{rows.getString("fid"), rows.getString("account"), rows.getString("benefit"), rows.getString("curPeriod")};
                    itemMap.put(rows.getString("personid") + rows.getString("itemid"), object1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (tempTable != null) {
                    pool.releaseTable(tempTable);
                }
            }
        }
        ArrayList<Object[]> mainList = new ArrayList<Object[]>();
        Object[] objects = null;
        StringBuffer ins = new StringBuffer();
        ins.append(" insert into t_hr_baseinsuhistory ( \n");
        ins.append("FID,FPersonID,FAccountID,FAccountTypeID,FBenefitID, \n");
        ins.append("FCmpperiodID,FChangeTime,FBaseInsu ) values \n");
        ins.append("(?,?,?,?,?,?,?,? )");
        Object result = null;
        for (Map.Entry personEntry : mapPerson.entrySet()) {
            personID = (String)personEntry.getKey();
            mapItem = (HashMap)personEntry.getValue();
            for (Map.Entry itemEntry : mapItem.entrySet()) {
                BigDecimal tmp;
                itemID = (String)itemEntry.getKey();
                result = itemEntry.getValue();
                if (result == null) continue;
                value = new BigDecimal(result.toString()).compareTo(new BigDecimal(0)) == 0 ? new BigDecimal(0) : new BigDecimal(mapItem.get(itemID).toString());
                if (!aiiMap.containsKey(personID + itemID)) {
                    String bosType = new AccountItemInputInfo().getBOSType().toString();
                    String fid = BOSUuid.create((String)bosType).toString();
                    if (!itemMap.containsKey(personID + itemID)) continue;
                    Object[] o = (Object[])itemMap.get(personID + itemID);
                    String faccountDetailID = (String)o[0];
                    objectinsert = new Object[]{fid, itemID, faccountDetailID, value};
                    insertList.add(objectinsert);
                    if (!isFromBase || !isRecordBase) continue;
                    String bihfid = BOSUuid.create((BOSObjectType)new BaseInsuHistoryInfo().getBOSType()).toString();
                    String account = (String)o[1];
                    String benefit = (String)o[2];
                    String curPeriod = (String)o[3];
                    objects = new Object[]{bihfid, personID, account, accountType, benefit, curPeriod, createTime, value};
                    mainList.add(objects);
                    continue;
                }
                Object[] o = (Object[])aiiMap.get(personID + itemID);
                objectupdate = new Object[]{value, o[0]};
                updateList.add(objectupdate);
                if (!isFromBase || !isRecordBase || (tmp = (BigDecimal)o[1]).compareTo(value) == 0) continue;
                String bihfid = BOSUuid.create((BOSObjectType)new BaseInsuHistoryInfo().getBOSType()).toString();
                String account = (String)o[2];
                String benefit = (String)o[3];
                String curPeriod = (String)o[4];
                objects = new Object[]{bihfid, personID, account, accountType, benefit, curPeriod, createTime, tmp};
                mainList.add(objects);
            }
        }
        if (insertList.size() > 0) {
            String sqlInsert = "insert into T_HR_Accountiteminput (FID,FItemID,FAccountDetailID,FValue) values (?,?,?,?)";
            HrExDbUtil.executeBatch(ctx, sqlInsert, insertList);
        }
        if (updateList.size() > 0) {
            String sqlUpdate = "update T_HR_Accountiteminput set fvalue = ? where fid = ? ";
            HrExDbUtil.executeBatch(ctx, sqlUpdate, updateList);
        }
        if (isFromBase && isRecordBase) {
            HrExDbUtil.executeBatch(ctx, ins.toString(), mainList);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    public String getLocal(Context ctx) {
        this.localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        return this.localString;
    }

    private AccountTypeInfo getAccountTypeInfo(Context ctx, String atID) throws EASBizException, BOSException {
        IAccountType iAccountType = AccountTypeFactory.getLocalInstance(ctx);
        AccountTypeInfo info = null;
        ObjectUuidPK pk = null;
        if (!StringUtils.isEmpty((String)atID)) {
            pk = new ObjectUuidPK(atID);
            info = iAccountType.getAccountTypeInfo((IObjectPK)pk);
        }
        return info;
    }

    private BenefitRuleInfo getBenefitRuleInfo(Context ctx, String brID) throws EASBizException, BOSException {
        IBenefitRule iBenefitRule = BenefitRuleFactory.getLocalInstance(ctx);
        BenefitRuleInfo info = null;
        if (!StringUtils.isEmpty((String)brID)) {
            info = iBenefitRule.getBenefitRuleInfo("select id, number, name, description,hrOrgUnit.id,accountType.id where id = '" + brID + "'");
        }
        return info;
    }

    private CmpPeriodInfo getCurPeriodInfo(Context ctx, String cmpID) throws BOSException, EASBizException {
        ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
        CmpPeriodInfo info = null;
        if (!StringUtils.isEmpty((String)cmpID)) {
            info = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cmpID));
        }
        return info;
    }

    protected ArrayList _getPersonList(Context ctx, Object[] perIDArray) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        ArrayList outerList = new ArrayList();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "PersonAccBatchQuery");
        EntityViewInfo viewInfo = null;
        FilterInfo filterInfo = null;
        IQueryExecutor iQe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        HashSet<String> set = new HashSet<String>();
        int length = perIDArray.length;
        for (int i = 0; i < length; ++i) {
            set.add(((PersonInfo)perIDArray[i]).getId().toString());
        }
        HashMap<String, Object> innerMap = null;
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filterInfo);
        iQe.setObjectView(viewInfo);
        iQe.option().isAutoTranslateBoolean = true;
        rowSet = iQe.executeQuery();
        try {
            while (rowSet.next()) {
                innerMap = new HashMap<String, Object>();
                innerMap.put("perid", rowSet.getString("ID"));
                innerMap.put("accID", rowSet.getString("ACCOUNT.ID"));
                innerMap.put("accIs", rowSet.getBoolean("ACCOUNT.ISNATIVERESIDENCE"));
                innerMap.put("accCity", rowSet.getString("ACCOUNT.CITY"));
                innerMap.put("adAcc", rowSet.getString("ACCDETAIL.ACCOUNTS"));
                innerMap.put("adPay", rowSet.getInt("ACCDETAIL.PAYSTATE"));
                innerMap.put("adSd", rowSet.getDate("ACCDETAIL.STOPDATE"));
                innerMap.put("adID", rowSet.getString("ACCDETAIL.ID"));
                innerMap.put("adSt", rowSet.getDate("accDetail.createDate"));
                innerMap.put("perName", rowSet.getString("NAME"));
                innerMap.put("perNum", rowSet.getString("NUMBER"));
                innerMap.put("accNum", rowSet.getString("ACCDETAIL.ACCOUNTNUMBER"));
                innerMap.put("aname", rowSet.getString("ADMINORGUNIT.NAME"));
                innerMap.put("et", rowSet.getInt("ET.INSERVICE"));
                innerMap.put("reDate", rowSet.getDate("accDetail.retireTransactDate"));
                innerMap.put("reNum", rowSet.getString("accDetail.retireNumber"));
                innerMap.put("fund", rowSet.getString("accDetail.fundItem"));
                innerMap.put("tDate", rowSet.getDate("accDetail.transactDate"));
                innerMap.put("brName", this.getBenefitRuleInfo(ctx, rowSet.getString("BENEFITRULE.ID")));
                innerMap.put("atName", this.getAccountTypeInfo(ctx, rowSet.getString("ACCTYPE.ID")));
                innerMap.put("curPeriod", this.getCurPeriodInfo(ctx, rowSet.getString("curPeriod.id")));
                outerList.add(innerMap);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        outerList = this.addOtherPerson(ctx, set, outerList);
        return outerList;
    }

    protected IRowSet _getTheItemValueColl(Context ctx, List perList, List itemList) throws BOSException, EASBizException {
        if (perList.size() <= 0 || itemList.size() <= 0) {
            return null;
        }
        IRowSet rowSet = null;
        String perInCause = null;
        String tempTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (perList.size() <= 100) {
            perInCause = BenefitUtils.getStrFromList(perList);
        } else {
            tempTable = BenefitUtils.createTempTableName(ctx, "fpersonid", "accountInfoTempTable", perList);
            perInCause = " (select fpersonid from " + tempTable + ")";
        }
        String itemInCause = BenefitUtils.getStrFromList(itemList);
        StringBuffer sqlSelect = new StringBuffer(" select a.fpersonid as fid, aii.fitemid, aii.fvalue \n");
        sqlSelect.append(" from T_HR_Accountiteminput aii \n");
        sqlSelect.append(" inner join T_HR_Accountdetail ad on aii.fAccountDetailid = ad.fid \n");
        sqlSelect.append(" inner join t_hr_account a on ad.faccountID =  a.fid \n");
        sqlSelect.append(" where a.fpersonid in \n");
        sqlSelect.append(perInCause);
        sqlSelect.append(" and aii.fitemid in ");
        sqlSelect.append(itemInCause);
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
        if (tempTable != null) {
            pool.releaseTable(tempTable);
        }
        return rowSet;
    }

    protected ArrayList _getPersonListBySet(Context ctx, Set perIDSet) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        ArrayList outerList = new ArrayList();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "PersonAccBatchQuery");
        EntityViewInfo viewInfo = null;
        FilterInfo filterInfo = null;
        IQueryExecutor iQe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        HashMap<String, Object> innerMap = null;
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)perIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filterInfo);
        iQe.setObjectView(viewInfo);
        iQe.option().isAutoTranslateBoolean = true;
        rowSet = iQe.executeQuery();
        try {
            while (rowSet.next()) {
                innerMap = new HashMap<String, Object>();
                innerMap.put("perid", rowSet.getString("ID"));
                innerMap.put("accID", rowSet.getString("ACCOUNT.ID"));
                innerMap.put("accIs", rowSet.getBoolean("ACCOUNT.ISNATIVERESIDENCE"));
                innerMap.put("accCity", rowSet.getString("ACCOUNT.CITY"));
                innerMap.put("adAcc", rowSet.getString("ACCDETAIL.ACCOUNTS"));
                innerMap.put("adPay", rowSet.getInt("ACCDETAIL.PAYSTATE"));
                innerMap.put("adSd", rowSet.getDate("ACCDETAIL.STOPDATE"));
                innerMap.put("adID", rowSet.getString("ACCDETAIL.ID"));
                innerMap.put("adSt", rowSet.getDate("accDetail.createDate"));
                innerMap.put("perName", rowSet.getString("NAME"));
                innerMap.put("perNum", rowSet.getString("NUMBER"));
                innerMap.put("accNum", rowSet.getString("ACCDETAIL.ACCOUNTNUMBER"));
                innerMap.put("aname", rowSet.getString("ADMINORGUNIT.NAME"));
                innerMap.put("et", rowSet.getInt("ET.INSERVICE"));
                innerMap.put("reDate", rowSet.getDate("accDetail.retireTransactDate"));
                innerMap.put("reNum", rowSet.getString("accDetail.retireNumber"));
                innerMap.put("fund", rowSet.getString("accDetail.fundItem"));
                innerMap.put("tDate", rowSet.getDate("accDetail.transactDate"));
                innerMap.put("brName", this.getBenefitRuleInfo(ctx, rowSet.getString("BENEFITRULE.ID")));
                innerMap.put("atName", this.getAccountTypeInfo(ctx, rowSet.getString("ACCTYPE.ID")));
                innerMap.put("curPeriod", this.getCurPeriodInfo(ctx, rowSet.getString("curPeriod.id")));
                outerList.add(innerMap);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        outerList = this.addOtherPerson(ctx, perIDSet, outerList);
        return outerList;
    }

    protected IRowSet _executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    private ArrayList addOtherPerson(Context ctx, Set perIDSet, ArrayList outerList) throws BOSException, EASBizException {
        if (perIDSet == null || perIDSet.size() == 0) {
            return outerList;
        }
        HashMap<String, Object> innerMap = null;
        String hroId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        Locale local = ContextUtils.getLocaleFromEnv();
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct p.fid as fpersonid,p.fnumber as number,");
        sb.append("p.").append(BenefitUtils.getLocaleStr(local, "FName")).append(" as name,");
        sb.append(" et.FinService as finService,");
        sb.append(" admin.").append(BenefitUtils.getLocaleStr(local, "FName")).append(" as adminName");
        sb.append("  from t_bd_person p inner join t_hr_account a  on p.fid=a.fpersonid  ").append("  left outer join  T_HR_PersonPosition pp on p.fid=pp.FPersonID ").append("  left outer join  T_HR_BDEmployeeType et on p.FEmployeeTypeID=et.fid").append("  left outer join  T_ORG_Admin admin on pp.FPersonDep=admin.fid").append(" where p.fid in").append(CompUtils.getStrFromSet((Set)perIDSet)).append(" and a.FHROrgUnitID <> ?").append(" and a.fpersonid not in (").append(" select fpersonid from t_hr_account where fpersonid in ").append(CompUtils.getStrFromSet((Set)perIDSet)).append(" and FHROrgUnitID =? )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hroId, hroId});
        try {
            while (rowSet.next()) {
                innerMap = new HashMap<String, Object>();
                innerMap.put("perid", rowSet.getString("fpersonid"));
                innerMap.put("perName", rowSet.getString("name"));
                innerMap.put("perNum", rowSet.getString("number"));
                innerMap.put("aname", rowSet.getString("adminName"));
                innerMap.put("et", rowSet.getInt("finService"));
                innerMap.put("adPay", 0);
                outerList.add(innerMap);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return outerList;
    }

    protected IRowSet _getKDInfo(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app.PersonDetailQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (filterInfo != null) {
            viewInfo.setFilter(filterInfo);
        }
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        return rs;
    }

    protected IRowSet _getKDDetailInfo(Context ctx, String accTypeID, String benefitStr, HashMap infoMap, String person) throws BOSException, EASBizException {
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        Locale local = ContextUtils.getLocaleFromEnv();
        HashSet<String> IDSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)benefitStr)) {
            BenefitInfo bInfo = null;
            BenefitCollection bc = BenefitUtils.getBenefitCollFromApp(ctx, accTypeID);
            int size = bc.size();
            for (int i = 0; i < size; ++i) {
                bInfo = bc.get(i);
                IDSet.add(bInfo.getId().toString());
            }
        } else {
            String[] str = benefitStr.split("@");
            for (int i = 0; i < str.length; ++i) {
                IDSet.add(str[i]);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select p.fnumber as personNum,b.fid as beneID,\n");
        sb.append(" b.").append(BenefitUtils.getLocaleStr(local, "FName")).append(" as beneName,");
        sb.append(" acc.fbenfitnum as beneNum,cmp.fnumber as cmpNumber,\n");
        sb.append(" i.fbenefititemnumber as beneItemNum,bddh.fvalue as value \n");
        sb.append(" from t_hr_benefitdatadetailhis bddh \n");
        sb.append(" inner join t_hr_benefitdatahis bdh on bddh.fbenefitdatahisid = bdh.fid \n");
        sb.append(" inner join t_hr_cmpperiod cmp on bdh.fcmpperiodid = cmp.fid \n");
        sb.append(" inner join t_hr_accountdetail ad on bdh.faccountdetailid = ad.fid \n");
        sb.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
        sb.append(" inner join t_bd_person p on a.fpersonid = p.fid \n");
        sb.append(" inner join t_hr_accountiteminput aii on bddh.faccountiteminputid = aii.fid \n");
        sb.append(" inner join t_hr_item i on aii.fitemid = i.fid \n");
        sb.append(" inner join t_hr_benefit b on i.fbenefitid = b.fid \n");
        sb.append(" left outer join t_hr_accbeneappend acc on acc.faccountdetailid = ad.fid \n");
        sb.append(" \tand acc.fbenefitid = b.fid \n");
        sb.append(" where a.fhrorgunitid ='" + hrOrgUnit + "'\n");
        sb.append(" and b.fid in ");
        sb.append(BenefitUtils.getStrFromSet(IDSet));
        sb.append("\n and i.fbenefititemnumber in ('");
        sb.append("Base_insu','");
        sb.append("Emp_insu','");
        sb.append("Com_insu','");
        sb.append("Emp_Sum','");
        sb.append("Com_Sum','");
        sb.append("Balance' )");
        if (!StringUtils.isEmpty((String)person)) {
            List cmpList = (List)infoMap.get(person);
            sb.append("\n and ");
            sb.append(" ( p.fnumber ='").append(person).append("' and cmp.fnumber in ");
            sb.append(BenefitUtils.getStrFromList(cmpList)).append(") \n");
        }
        sb.append("");
        sb.append(" order by personNum,cmpNumber,beneName ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        LinkedMap map = new LinkedMap();
        HashMap dataMap = null;
        DynamicRowSet rowSet = null;
        try {
            while (rows.next()) {
                String personNum = rows.getString("personNum");
                String beneID = rows.getString("beneID");
                String beneName = rows.getString("beneName");
                String beneNum = rows.getString("beneNum");
                String beneItemNum = rows.getString("beneItemNum");
                BigDecimal value = rows.getBigDecimal("value");
                String cmpNum = rows.getString("cmpNumber");
                dataMap = map.containsKey((Object)(personNum + beneID + cmpNum)) ? (HashMap)map.get((Object)(personNum + beneID + cmpNum)) : new HashMap();
                dataMap.put("beneName", beneName);
                dataMap.put("beneNum", beneNum);
                dataMap.put("cmpNum", cmpNum);
                dataMap.put(beneItemNum, value);
                map.put((Object)(personNum + beneID + cmpNum), (Object)dataMap);
            }
            rowSet = new DynamicRowSet(9);
            rowSet.setColInfo(1, "benefitName", "benefitName", 12, null);
            rowSet.setColInfo(2, "benefitNum", "benefitNum", 12, null);
            rowSet.setColInfo(3, "Base_insu", "Base_insu", 3, null);
            rowSet.setColInfo(4, "Emp_insu", "Emp_insu", 3, null);
            rowSet.setColInfo(5, "Com_insu", "Com_insu", 3, null);
            rowSet.setColInfo(6, "Emp_Sum", "Emp_Sum", 3, null);
            rowSet.setColInfo(7, "Com_Sum", "Com_Sum", 3, null);
            rowSet.setColInfo(8, "Balance", "Balance", 3, null);
            rowSet.setColInfo(9, "cmpPeriod", "cmpPeriod", 12, null);
            Iterator iter = map.keySet().iterator();
            String key = null;
            BigDecimal zero = new BigDecimal(0);
            while (iter.hasNext()) {
                key = (String)iter.next();
                HashMap mapData = (HashMap)map.get((Object)key);
                rowSet.moveToInsertRow();
                rowSet.updateString("benefitName", (String)mapData.get("beneName"));
                rowSet.updateString("benefitNum", (String)mapData.get("beneNum"));
                rowSet.updateString("cmpPeriod", (String)mapData.get("cmpNum"));
                if (mapData.get("Base_insu") != null) {
                    rowSet.updateBigDecimal("Base_insu", (BigDecimal)mapData.get("Base_insu"));
                } else {
                    rowSet.updateBigDecimal("Base_insu", zero);
                }
                if (mapData.get("Emp_insu") != null) {
                    rowSet.updateBigDecimal("Emp_insu", (BigDecimal)mapData.get("Emp_insu"));
                } else {
                    rowSet.updateBigDecimal("Emp_insu", zero);
                }
                if (mapData.get("Com_insu") != null) {
                    rowSet.updateBigDecimal("Com_insu", (BigDecimal)mapData.get("Com_insu"));
                } else {
                    rowSet.updateBigDecimal("Com_insu", zero);
                }
                if (mapData.get("Emp_Sum") != null) {
                    rowSet.updateBigDecimal("Emp_Sum", (BigDecimal)mapData.get("Emp_Sum"));
                } else {
                    rowSet.updateBigDecimal("Emp_Sum", zero);
                }
                if (mapData.get("Com_Sum") != null) {
                    rowSet.updateBigDecimal("Com_Sum", (BigDecimal)mapData.get("Com_Sum"));
                } else {
                    rowSet.updateBigDecimal("Com_Sum", zero);
                }
                if (mapData.get("Balance") != null) {
                    rowSet.updateBigDecimal("Balance", (BigDecimal)mapData.get("Balance"));
                } else {
                    rowSet.updateBigDecimal("Balance", zero);
                }
                rowSet.insertRow();
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    protected void _deleteUselessData(Context ctx) throws BOSException, EASBizException {
        String adSql = "( select fid from  t_hr_accountdetail where fpaystate <> 10 )";
        StringBuffer delSql = new StringBuffer();
        delSql.append(" delete from t_hr_benefitdatadetail where fbenefitdataid in (");
        delSql.append(" select fid from t_hr_benefitdata where faccountdetailid in ");
        delSql.append(adSql);
        delSql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        delSql = new StringBuffer();
        delSql.append("delete from t_hr_benefitdata where faccountdetailid in ");
        delSql.append(adSql);
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        delSql.append("delete from t_hr_accountsettleTmp where faccountdetailid in");
        delSql.append(adSql);
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    protected ArrayList _getPersonListBySetAndFilter(Context ctx, ArrayList list) throws BOSException, EASBizException {
        Set perIDSet = (Set)list.get(0);
        EntityViewInfo info = (EntityViewInfo)list.get(1);
        IRowSet rowSet = null;
        ArrayList outerList = new ArrayList();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "PersonAccBatchQuery");
        EntityViewInfo viewInfo = null;
        FilterInfo filterInfo = null;
        IQueryExecutor iQe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        HashMap<String, Object> innerMap = null;
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)perIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        filterInfo.mergeFilter(info.getFilter(), "and");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSorter(info.getSorter());
        iQe.setObjectView(viewInfo);
        iQe.option().isAutoTranslateBoolean = true;
        rowSet = iQe.executeQuery();
        try {
            while (rowSet.next()) {
                innerMap = new HashMap<String, Object>();
                innerMap.put("perid", rowSet.getString("ID"));
                innerMap.put("accID", rowSet.getString("ACCOUNT.ID"));
                innerMap.put("accIs", rowSet.getBoolean("ACCOUNT.ISNATIVERESIDENCE"));
                innerMap.put("accCity", rowSet.getString("ACCOUNT.CITY"));
                innerMap.put("adAcc", rowSet.getString("ACCDETAIL.ACCOUNTS"));
                innerMap.put("adPay", rowSet.getInt("ACCDETAIL.PAYSTATE"));
                innerMap.put("adSd", rowSet.getDate("ACCDETAIL.STOPDATE"));
                innerMap.put("adID", rowSet.getString("ACCDETAIL.ID"));
                innerMap.put("adSt", rowSet.getDate("accDetail.createDate"));
                innerMap.put("perName", rowSet.getString("NAME"));
                innerMap.put("perNum", rowSet.getString("NUMBER"));
                innerMap.put("accNum", rowSet.getString("ACCDETAIL.ACCOUNTNUMBER"));
                innerMap.put("aname", rowSet.getString("ADMINORGUNIT.NAME"));
                innerMap.put("et", rowSet.getInt("ET.INSERVICE"));
                innerMap.put("reDate", rowSet.getDate("accDetail.retireTransactDate"));
                innerMap.put("reNum", rowSet.getString("accDetail.retireNumber"));
                innerMap.put("fund", rowSet.getString("accDetail.fundItem"));
                innerMap.put("tDate", rowSet.getDate("accDetail.transactDate"));
                innerMap.put("brName", this.getBenefitRuleInfo(ctx, rowSet.getString("BENEFITRULE.ID")));
                innerMap.put("atName", this.getAccountTypeInfo(ctx, rowSet.getString("ACCTYPE.ID")));
                innerMap.put("curPeriod", this.getCurPeriodInfo(ctx, rowSet.getString("curPeriod.id")));
                outerList.add(innerMap);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        outerList = this.addOtherPerson(ctx, perIDSet, outerList);
        return outerList;
    }

    protected Map _getAccountRuleItem(Context ctx, Map map) throws BOSException, EASBizException {
        IQueryExecutor iq = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK((String)map.get("queryName")));
        EntityViewInfo info = (EntityViewInfo)map.get("entityViewInfo");
        SelectorItemCollection sic = info.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        iq.setObjectView(info);
        IRowSet rows = iq.executeQuery();
        HashSet<String> set = new HashSet<String>();
        try {
            while (rows.next()) {
                set.add(rows.getString("id"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String typeId = null;
        if (map.containsKey("typeId")) {
            typeId = (String)map.get("typeId");
        }
        String temporaryTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (set.size() > 500) {
            temporaryTableName = BenefitUtils.createTempTableName(ctx, "FPersonID", "benefitReportTempTable", set);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select ad.fid as accountdetailid, ri.FBenefitID as benefitid, ");
        sb.append("ri.FComGetDecEnum as comGetDecEnum, ri.FEmpGetDecEnum as empGetDecEnum ");
        sb.append("from T_HR_Account a ");
        sb.append("inner join t_hr_accountdetail ad on a.fid = ad.FAccountID ");
        if (set.size() > 500) {
            sb.append(" inner join ").append(temporaryTableName).append(" temp on a.fpersonid = temp.FPersonID ");
        }
        sb.append("inner join T_HR_BenefitRuleItem ri on ad.FBenefitRuleID = ri.FBenefitRuleID ");
        sb.append("where a.FHROrgUnitID = '").append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()).append("' ");
        if (typeId != null) {
            sb.append("and ad.FAccountTypeID = '").append(typeId).append("' ");
        }
        if (set.size() > 0 && set.size() <= 500) {
            sb.append(" and a.fpersonid in ").append(BenefitUtils.getStrFromSet(set));
        }
        sb.append("order by ad.fid asc, ri.FBenefitID asc ");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap resultMap = new HashMap();
        List<ArrayList<Object>> list = null;
        ArrayList<Object> infoList = null;
        try {
            while (rows.next()) {
                infoList = new ArrayList<Object>();
                infoList.add(rows.getString("benefitid"));
                infoList.add(new Integer(rows.getInt("comGetDecEnum")));
                infoList.add(new Integer(rows.getInt("empGetDecEnum")));
                if (!resultMap.containsKey(rows.getString("accountdetailid"))) {
                    list = new ArrayList();
                    resultMap.put(rows.getString("accountdetailid"), list);
                } else {
                    list = (List)resultMap.get(rows.getString("accountdetailid"));
                }
                list.add(infoList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (temporaryTableName != null) {
                pool.releaseTable(temporaryTableName);
            }
        }
        return resultMap;
    }

    protected Map _getAccountRuleItemByKey(Context ctx, Map map) throws BOSException, EASBizException {
        Set set = (Set)map.get("set");
        String temporaryTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (set.size() > 500) {
            temporaryTableName = BenefitUtils.createTempTableName(ctx, "FPersonID", "benefitReportTempTable", set);
        }
        String typeId = null;
        if (map.containsKey("typeId")) {
            typeId = (String)map.get("typeId");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select ad.faccountid as accountid, ad.faccounttypeid as typeid, ad.fbenefitruleid as ruleid from t_hr_accountdetail ad ");
        sb.append(" inner join t_hr_account a ");
        sb.append(" on a.fid = ad.FAccountID ");
        if (set.size() > 500) {
            sb.append(" inner join ").append(temporaryTableName).append(" temp on a.fpersonid = temp.FPersonID ");
        }
        sb.append("where a.FHROrgUnitID = '").append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()).append("' ");
        if (set.size() > 0 && set.size() <= 500) {
            sb.append(" and a.fpersonid in ").append(BenefitUtils.getStrFromSet(set));
        }
        if (typeId != null) {
            sb.append("and ad.FAccountTypeID = '").append(typeId).append("' ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Object list = null;
        String accountid = null;
        String accounttypeid = null;
        String benefitruleid = null;
        try {
            while (rows.next()) {
                accountid = rows.getString("accountid");
                accounttypeid = rows.getString("typeid");
                benefitruleid = rows.getString("ruleid");
                resultMap.put(rows.getString("accountid") + "@@" + rows.getString("typeid"), benefitruleid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (temporaryTableName != null) {
                pool.releaseTable(temporaryTableName);
            }
        }
        return resultMap;
    }

    protected Map _existAdjustData(Context ctx, List list, String accountTypeID, String curPeriodID) throws BOSException, EASBizException {
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (list.size() > 500) {
            tempTableName = BenefitUtils.createTempTableName(ctx, "faccountid", "existAdjustDataTempTable", new HashSet(list));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select d.faccountid as accountid from t_hr_benefitadjustdata j ");
        sb.append(" inner join t_hr_accountdetail d ");
        sb.append("on j.faccountdetailid = d.fid ");
        if (list.size() > 500) {
            sb.append(" inner join ").append(tempTableName).append(" temp on d.faccountid = temp.faccountid ");
        }
        sb.append(" where j.fcmpperiodid = '").append(curPeriodID).append("' ");
        sb.append(" and d.faccounttypeid = '").append(accountTypeID).append("' ");
        if (list.size() <= 500) {
            sb.append(" and d.faccountid in ").append(BenefitUtils.getStrFromList(list));
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (row.next()) {
                map.put(row.getString("accountid"), "true");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableName != null) {
                pool.releaseTable(tempTableName);
            }
        }
        return map;
    }

    protected int _getAdminLevel(Context ctx, String longNumber) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(*) as count, max(flevel) as max, min(flevel) as min ");
        sb.append(" from t_org_admin where flongnumber = '").append(longNumber).append("'");
        sb.append(" or flongnumber like '").append(longNumber).append("!%'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int count = 0;
        try {
            if (row.next()) {
                count = row.getInt("count");
                if (count <= 1) {
                    return 0;
                }
                return row.getInt("max") - row.getInt("min");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }
}

