/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitItemFactory;
import com.kingdee.eas.hr.benefit.BenefitItemInfo;
import com.kingdee.eas.hr.benefit.BenefitPropEnum;
import com.kingdee.eas.hr.benefit.IBenefit;
import com.kingdee.eas.hr.benefit.IBenefitItem;
import com.kingdee.eas.hr.benefit.IItem;
import com.kingdee.eas.hr.benefit.ItemFactory;
import com.kingdee.eas.hr.benefit.ItemInfo;
import com.kingdee.eas.hr.benefit.app.AbstractBenefitControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BenefitControllerBean
extends AbstractBenefitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.benefit.app.BenefitControllerBean");
    public static final String ID = "id";
    public static final String INUM = "insuranceNum";
    public static final String HRID = "hrOrgUnit.id";
    public static final String ADD = "add";
    public static final String UP = "update";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        BenefitInfo bInfo = (BenefitInfo)model;
        ArrayList list = (ArrayList)bInfo.get("ids");
        ArrayList listCmp = (ArrayList)bInfo.get("idCmps");
        ArrayList listItemID = (ArrayList)bInfo.get("listItemID");
        HashMap delItemMap = (HashMap)bInfo.get("delItemMap");
        this._checkNameDup(ctx, model);
        pk = super._addnew(ctx, model);
        this._updateItem(ctx, pk, list, listCmp, listItemID, delItemMap, ADD);
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BenefitInfo info = (BenefitInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        String hrOrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo(HRID, (Object)hrOrgID));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo(ID, (Object)info.getId(), CompareType.NOTEQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BenefitInfo bInfo = (BenefitInfo)model;
        ArrayList list = (ArrayList)bInfo.get("ids");
        ArrayList listCmp = (ArrayList)bInfo.get("idCmps");
        ArrayList listItemID = (ArrayList)bInfo.get("listItemID");
        HashMap delItemMap = (HashMap)bInfo.get("delItemMap");
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
        this._updateItem(ctx, pk, list, listCmp, listItemID, delItemMap, UP);
    }

    private void _updateItem(Context ctx, IObjectPK pk, ArrayList idList, ArrayList listCmp, ArrayList listItemID, HashMap delItemMap, String AddOrUp) throws BOSException, EASBizException, BenefitException {
        String bItemIds = null;
        String cmpItemIds = null;
        ItemInfo itemInfo = null;
        ObjectUuidPK itemPK = null;
        BenefitItemInfo benefitItemInfo = null;
        IItem iItem = ItemFactory.getLocalInstance(ctx);
        IBenefit iBenefit = BenefitFactory.getLocalInstance(ctx);
        BenefitInfo benefitInfo = iBenefit.getBenefitInfo(pk);
        if (idList.size() <= 0) {
            Iterator iter = delItemMap.keySet().iterator();
            while (iter.hasNext()) {
                String itemId = iter.next().toString();
                String strDel = "delete t_hr_item where fid in (select i.fid from t_hr_item i inner join t_hr_benefititem bi on i.fitemid = bi.fid where bi.fisinner != 10 and i.fid = '" + itemId + "')";
                DbUtil.execute((Context)ctx, (String)strDel);
            }
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            CmpItemInfo cmpItemInfo = null;
            itemInfo = new ItemInfo();
            bItemIds = idList.get(i).toString();
            cmpItemIds = listCmp.get(i) == null ? null : listCmp.get(i).toString();
            benefitItemInfo = this.convertBeVO(ctx, bItemIds);
            cmpItemInfo = this.convertCmpVO(ctx, cmpItemIds);
            if (listItemID.get(i) != null) {
                itemInfo.setId(BOSUuid.read((String)listItemID.get(i).toString()));
            }
            itemInfo.setBenefit(benefitInfo);
            itemInfo.setBenefitNumber(benefitInfo.getNumber());
            itemInfo.setBenefitItem(benefitItemInfo);
            itemInfo.setBenefitItemNumber(benefitItemInfo.getNumber());
            itemInfo.setCmpItem(cmpItemInfo);
            itemInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            Iterator iter = delItemMap.keySet().iterator();
            while (iter.hasNext()) {
                String itemId = iter.next().toString();
                String strDel = "delete t_hr_item where fid in (select i.fid from t_hr_item i inner join t_hr_benefititem bi on i.fitemid = bi.fid where bi.fisinner != 10 and i.fid = '" + itemId + "')";
                DbUtil.execute((Context)ctx, (String)strDel);
            }
            if (AddOrUp.equals(ADD)) {
                iItem.addnew(itemInfo);
                continue;
            }
            if (!AddOrUp.equals(UP)) continue;
            if (itemInfo.getId() == null) {
                iItem.addnew(itemInfo);
                continue;
            }
            itemPK = new ObjectUuidPK(itemInfo.getId().toString());
            iItem.update((IObjectPK)itemPK, itemInfo);
        }
    }

    private CmpItemInfo convertCmpVO(Context ctx, String cmpItemIds) throws EASBizException, BOSException {
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        CmpItemInfo cmpItemInfo = null;
        if (cmpItemIds != null) {
            BOSUuid uuid = BOSUuid.read((String)cmpItemIds);
            pk = new ObjectUuidPK(uuid);
            cmpItemInfo = iCmpItem.getCmpItemInfo((IObjectPK)pk);
        }
        return cmpItemInfo;
    }

    private BenefitItemInfo convertBeVO(Context ctx, String itemIds) throws EASBizException, BOSException {
        IBenefitItem iBenefitItem = BenefitItemFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = null;
        BenefitItemInfo benefitItemInfo = null;
        if (itemIds != null) {
            BOSUuid uuid = BOSUuid.read((String)itemIds);
            pk = new ObjectUuidPK(uuid);
            benefitItemInfo = iBenefitItem.getBenefitItemInfo((IObjectPK)pk);
        }
        return benefitItemInfo;
    }

    protected void _setEnable(Context ctx, String benefitId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_benefit set fstate = 1 where fid = '");
        sb.append(benefitId);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _setUnEnable(Context ctx, String benefitId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_benefit set fstate = 0 where fid = '");
        sb.append(benefitId);
        sb.append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDel(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BenefitInfo benefitItemInfo = this.getBenefitInfo(ctx, pk);
        if (benefitItemInfo.getIsInner().equals((Object)BenefitPropEnum.INNER)) {
            throw new BenefitException(BenefitException.BENE_NOTDEL);
        }
        if (benefitItemInfo.isState()) {
            throw new BenefitException(BenefitException.BENEENABLE_NOTDEL);
        }
    }

    protected void _setBatchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() <= 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_benefit set fstate = 1 where fid in");
        sb.append(BenefitUtils.getStrFromList(idList));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void _setBatchUnEnable(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() <= 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_benefit set fstate = 0 where fid in");
        sb.append(BenefitUtils.getStrFromList(idList));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }
}

