/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.AgeSegScaleInfo;
import com.kingdee.eas.hr.benefit.BaseInsuHistoryInfo;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataDetailFactory;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataFactory;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataInfo;
import com.kingdee.eas.hr.benefit.BenefitAdjustDataTmpInfo;
import com.kingdee.eas.hr.benefit.BenefitDataDetailHisInfo;
import com.kingdee.eas.hr.benefit.BenefitDataDetailInfo;
import com.kingdee.eas.hr.benefit.BenefitDataFactory;
import com.kingdee.eas.hr.benefit.BenefitDataHisInfo;
import com.kingdee.eas.hr.benefit.BenefitDataInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitImportDataException;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.BenefitItemInfo;
import com.kingdee.eas.hr.benefit.BenefitRuleFacadeFactory;
import com.kingdee.eas.hr.benefit.FluctuationPersonFactory;
import com.kingdee.eas.hr.benefit.IBenefitAdjustData;
import com.kingdee.eas.hr.benefit.IBenefitAdjustDataDetail;
import com.kingdee.eas.hr.benefit.IBenefitData;
import com.kingdee.eas.hr.benefit.IBenefitRuleFacade;
import com.kingdee.eas.hr.benefit.IFluctuationPerson;
import com.kingdee.eas.hr.benefit.ItemInfo;
import com.kingdee.eas.hr.benefit.OperateTypeEnum;
import com.kingdee.eas.hr.benefit.app.AbstractBenefitInvokeFacadeControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpCommonFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpCommonFacade;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BenefitInvokeFacadeControllerBean
extends AbstractBenefitInvokeFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.benefit.app.BenefitInvokeFacadeControllerBean");

    protected Object _query(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException, EASBizException {
        return this._invokeMethod(ctx, methodName, clases, params);
    }

    protected Object _operate(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException, EASBizException {
        return this._invokeMethod(ctx, methodName, clases, params);
    }

    protected void _operate2(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException, EASBizException {
        this._invokeMethod(ctx, methodName, clases, params);
    }

    private Object _invokeMethod(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException {
        Class<?> wfClass = this.getClass();
        Class[] newClases = new Class[clases.length + 1];
        newClases[0] = Context.class;
        for (int i = 0; i < clases.length; ++i) {
            newClases[i + 1] = clases[i];
        }
        Object[] newParams = new Object[params.length + 1];
        newParams[0] = ctx;
        for (int i = 0; i < params.length; ++i) {
            newParams[i + 1] = params[i];
        }
        try {
            Method method = wfClass.getMethod(methodName, newClases);
            Object obj = method.invoke((Object)this, newParams);
            return obj;
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException(e.getTargetException());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initAccountType(Context ctx, String hrOrgUnitId, String cuId) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_HR_AccountType WHERE FHROrgUnitID = ?", (Object[])new Object[]{hrOrgUnitId});
        if (rows.size() > 0) {
            return;
        }
        String bosType = new AccountTypeInfo().getBOSType().toString();
        String fCreatorId = ctx.getCaller().toString();
        StringBuffer sbInsert = new StringBuffer();
        sbInsert.append("INSERT INTO T_HR_AccountType \n");
        sbInsert.append(" (FID, FCreatorID, FControlUnitID, FName_L1, FName_L2, FName_L3,\n");
        sbInsert.append("  FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName,\n");
        sbInsert.append("  FIsInner, FHROrgUnitID )  \n");
        logger.debug((Object)("AccountType Item Insert SQL :" + sbInsert.toString()));
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT newbosid('");
        sb.append(bosType).append("') , ");
        sb.append("'").append(fCreatorId).append("' , ");
        sb.append("'").append(cuId).append("' , \n");
        sb.append("FName_L1,FName_L2,FName_L3 ,");
        sb.append("FNumber, \n");
        sb.append("FDescription_L1,FDescription_L2,FDescription_L3, \n");
        sb.append("FSimpleName,FIsInner,");
        sb.append("'").append(hrOrgUnitId).append("' \n");
        sb.append(" FROM T_HR_AccountType \n");
        sb.append(" WHERE FHROrgUnitID IS NULL \n");
        DbUtil.execute((Context)ctx, (String)sbInsert.append(sb).toString());
    }

    private void initBenefitItem(Context ctx, String hrOrgUnitId, String cuId) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_HR_BenefitItem WHERE FHROrgUnitID = ?", (Object[])new Object[]{hrOrgUnitId});
        if (rows.size() > 0) {
            return;
        }
        String bosType = new BenefitItemInfo().getBOSType().toString();
        String fCreatorId = ctx.getCaller().toString();
        StringBuffer sbInsert = new StringBuffer();
        sbInsert.append("INSERT INTO T_HR_BenefitItem  \n");
        sbInsert.append(" (FID, FCreatorID, FControlUnitID, FNumber, \n");
        sbInsert.append(" FName_L1, FName_L2, FName_L3, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, \n");
        sbInsert.append(" FDataType, FLength, FPrecision, FIsInner, FIsDisplay, FState, FIsCheckItem, \n");
        sbInsert.append(" FIsReference, FHROrgUnitID, FLastUpdateUserID, FINDEX)  \n");
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT newbosid('");
        sb.append(bosType).append("') , ");
        sb.append("'").append(fCreatorId).append("' , ");
        sb.append("'").append(cuId).append("' , \n");
        sb.append("FNumber,");
        sb.append("FName_L1,FName_L2,FName_L3 ,");
        sb.append("FDescription_L1,FDescription_L2,FDescription_L3, \n");
        sb.append("FSimpleName,FDataType,FLength,FPrecision,FIsInner,");
        sb.append("FIsDisplay,FState,FIsCheckItem,FIsReference,\n");
        sb.append("'").append(hrOrgUnitId).append("' , ");
        sb.append("'").append(fCreatorId).append("' , ");
        sb.append("FINDEX \n");
        sb.append(" FROM T_HR_BenefitItem \n");
        sb.append(" WHERE FHROrgUnitID IS NULL \n");
        DbUtil.execute((Context)ctx, (String)sbInsert.append(sb).toString());
        logger.debug((Object)("Benefit Item Insert SQL :" + sbInsert.toString()));
    }

    private void initBenefit(Context ctx, String hrOrgUnitId, String cuId) throws BOSException, EASBizException {
        String fCreatorId = ctx.getCaller().toString();
        java.sql.Date fcreateTime = new java.sql.Date(new Date().getTime());
        Object[] param = null;
        StringBuffer sbInsert = new StringBuffer();
        sbInsert.append("INSERT INTO T_HR_Benefit \n");
        sbInsert.append(" (FID, FCreatorID, FCreateTime, FControlUnitID, FName_L1, FName_L2, FName_L3,  \n");
        sbInsert.append(" FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FState,  \n");
        sbInsert.append(" FInsuranceNum, FIsInner, FAccountTypeID, FHROrgUnitID, FLastUpdateUserID, FLastUpdateTime) \n");
        sbInsert.append("VALUES (? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?, ?, ?, ? ) \n");
        String bosType = new BenefitInfo().getBOSType().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2,  \n");
        sb.append("      FDescription_L3, FSimpleName, FState, FInsuranceNum, FIsInner, FAccountTypeID \n");
        sb.append("FROM T_HR_Benefit \n");
        sb.append("WHERE FHROrgUnitID IS NULL \n");
        logger.debug((Object)("Benefit SELECT SQL :" + sb.toString()));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Map map = this.getAccountTypeId(ctx, hrOrgUnitId);
        try {
            while (rows.next()) {
                param = new Object[]{BOSUuid.create((String)bosType).toString(), fCreatorId, fcreateTime, cuId, rows.getString("FName_L1"), rows.getString("FName_L2"), rows.getString("FName_L3"), rows.getString("FNumber"), rows.getString("FDescription_L1"), rows.getString("FDescription_L2"), rows.getString("FDescription_L3"), rows.getString("FSimpleName"), rows.getInt("FState"), rows.getString("FInsuranceNum"), rows.getInt("FIsInner"), map.get(rows.getString("FNumber")), hrOrgUnitId, fCreatorId, fcreateTime};
                paramList.add(param);
            }
            HrExDbUtil.executeBatch(ctx, sbInsert.toString(), paramList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initItem(Context ctx, String hrOrgUnitId) throws BOSException {
        String bosType = new ItemInfo().getBOSType().toString();
        StringBuffer insertOql = new StringBuffer();
        insertOql.append(" insert into T_HR_Item(FID,FItemID,FBenefitItemNumber,FBenefitID,FBenefitNumber,FHROrgUnitID)");
        insertOql.append(" SELECT newbosid('");
        insertOql.append(bosType).append("') , ").append(" a.fid,a.fnumber,b.fid,b.fnumber,a.fhrorgunitid ").append(" from t_hr_benefit b,t_hr_benefititem a ").append(" where  a.fhrorgunitid = b.fhrorgunitid and a.fisinner=10 ").append(" and a.fhrorgunitid='").append(hrOrgUnitId).append("'");
        DbUtil.execute((Context)ctx, (String)insertOql.toString());
    }

    private Map getAccountTypeId(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A1.N1,A2.N4  from \n");
        sb.append(" ( \n");
        sb.append("\t SELECT B.FNumber AS N1,A.Fnumber AS N2\n");
        sb.append("\t FROM T_HR_Benefit B INNER JOIN T_HR_AccountType A ON A.FID = B.FAccountTypeID \n");
        sb.append("\t where B.FHROrgUnitID IS NULL  \n");
        sb.append("\t )A1,  \n");
        sb.append("\t( select A.FNumber AS N3,A.FID AS N4 from T_HR_AccountType A \n");
        sb.append("\t  where A.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
        sb.append("\t      and A.Fnumber \n");
        sb.append("\t        in ( \n");
        sb.append("\t            SELECT T.Fnumber\n");
        sb.append("\t            FROM T_HR_Benefit B INNER JOIN T_HR_AccountType T ON T.FID = B.FAccountTypeID  \n");
        sb.append("\t            where B.FHROrgUnitID IS NULL  \n");
        sb.append("            )");
        sb.append("  )A2 where A1.N2=A2.N3");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                String id = rows.getString("N4");
                String number = rows.getString("N1");
                map.put(number, id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected CmpPeriodInfo _getNextPeriod(Context ctx, String curPeriodID) throws BOSException, EASBizException {
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance((Context)ctx);
        CmpPeriodInfo curPeriodInfo = iCmpPeriod.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(curPeriodID));
        Date nextBeginDate = DateTimeUtils.addDay((Date)curPeriodInfo.getEndDate(), (long)1L);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String nextDateSimpleString = sd.format(nextBeginDate);
        HROrgUnitInfo hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        StringBuffer oqlString = new StringBuffer();
        oqlString.append(" SELECT *  WHERE BEGINDATE='").append(nextDateSimpleString).append("'");
        oqlString.append(" AND hrOrgUnit ='").append(hrOrgInfo.getId().toString()).append("'");
        CmpPeriodCollection nextCmpPeriodColl = null;
        nextCmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(oqlString.toString());
        if (nextCmpPeriodColl.size() > 0) {
            return nextCmpPeriodColl.get(0);
        }
        return null;
    }

    public CmpPeriodInfo getCurMaxPeriod(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID ");
        sb.append("FROM T_HR_CMPPeriod ");
        sb.append("WHERE FEndDate in ( ");
        sb.append("\tSELECT MAX(FEndDate) ");
        sb.append("\tFROM T_HR_CMPPeriod ");
        sb.append("\tWHERE FID IN (select FValue from T_HR_BenefitUtil WHERE FType = ? and FHROrgUnitID = ?) ");
        sb.append("\t) ");
        String periodId = null;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"CURPERIOD", hrOrgUnitId});
        try {
            if (rows.next()) {
                periodId = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (periodId != null) {
            return CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
        }
        return null;
    }

    protected HashMap _getAccountInfos(Context ctx, String accountType, String curPeriod, String adminOrgUnit, boolean includeSubOrg) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        HashSet adminSet = BenefitUtils.getUserRangeAdminOrg(ctx, adminOrgUnit, includeSubOrg);
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        tempTableName = adminSet.size() > 100 ? BenefitUtils.createTempTableName(ctx, "fAdminOrgid", "accountInfoTempTable", adminSet) : BenefitUtils.getStrFromSet(adminSet);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            IRowSet rows = null;
            int fluPersonNum = 0;
            StringBuffer fluPerSql = new StringBuffer();
            String fluSele = " select fp.fpersonid as personID  \n";
            String fluState = " select fp.fpersonid as personID,ad.fpaystate as payState \n";
            fluPerSql.append(" from t_hr_fluctuationPerson fp");
            fluPerSql.append(" inner join t_hr_account a on a.fpersonid = fp.fpersonid \n");
            fluPerSql.append(" and a.fhrorgunitid ='").append(hrOrgUnitId).append("' \n ");
            fluPerSql.append(" inner join t_hr_accountdetail ad on ad.faccountid = a.fid \n");
            fluPerSql.append(" and ad.faccounttypeid ='").append(accountType).append("' \n");
            fluPerSql.append(" and ad.FCurPeriodID ='").append(curPeriod).append("' \n");
            fluPerSql.append(" and fp.FTranInOldDep = 1 \n");
            fluPerSql.append(" \n and fp.FOldAdminOrgID in ");
            if (adminSet.size() <= 100) {
                fluPerSql.append(tempTableName);
            } else {
                fluPerSql.append("( select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            String payStateSql = " and ad.FPayState = 10 \n";
            StringBuffer sb = new StringBuffer();
            sb.append(" select count (distinct personID) as FCount from \n");
            sb.append("( \n");
            sb.append("( Select p.FID as personID ");
            sb.append("FROM T_HR_AccountDetail detail  \n");
            sb.append("INNER JOIN T_HR_Account acc ON detail.FAccountID = acc.FID \n");
            sb.append("INNER JOIN T_BD_Person p ON acc.FPersonID = p.FID \n");
            sb.append("INNER JOIN T_HR_PersonPosition pp on pp.FPersonID = p.fid \n ");
            sb.append(" WHERE detail.FAccountTypeID = '").append(accountType).append("'");
            sb.append(" AND acc.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
            sb.append(" and detail.FCurPeriodID = '").append(curPeriod).append("' \n");
            sb.append(" and pp.FPersonDep in ");
            if (adminSet.size() <= 100) {
                sb.append(tempTableName);
            } else {
                sb.append(" (select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            sb.append(") \n union all \n (");
            sb.append(fluSele);
            sb.append(fluPerSql);
            sb.append(payStateSql);
            sb.append(") \n");
            sb.append(" ) as T");
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rows.next()) {
                map.put("COUNT_ACCOUNT_TOTAL", rows.getInt("FCount") + fluPersonNum);
            }
            sb = new StringBuffer();
            sb.append("select count (distinct personID) as FCount,payState from \n");
            sb.append("( \n");
            sb.append("( SELECT p.FID AS personID, detail.FPayState as payState \n");
            sb.append("FROM T_HR_AccountDetail detail  \n");
            sb.append("INNER JOIN T_HR_Account acc ON detail.FAccountID = acc.FID \n");
            sb.append("INNER JOIN T_BD_Person p ON acc.FPersonID = p.FID \n");
            sb.append("INNER JOIN T_HR_PersonPosition pp on pp.FPersonID = p.fid \n ");
            sb.append(" WHERE detail.FAccountTypeID = '").append(accountType).append("'");
            sb.append(" AND acc.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
            sb.append(" and detail.FCurPeriodID = '").append(curPeriod).append("' \n");
            sb.append(" and pp.FPersonDep in ");
            if (adminSet.size() <= 100) {
                sb.append(tempTableName);
            } else {
                sb.append(" (select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            sb.append(") \n union all \n (");
            sb.append(fluState);
            sb.append(fluPerSql);
            sb.append(") \n");
            sb.append(") as T");
            sb.append(" GROUP BY payState \n");
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int tmpType = 0;
            while (rows.next()) {
                tmpType = rows.getInt("payState");
                switch (tmpType) {
                    case 20: {
                        map.put("COUNT_ACCOUNT_STOP", rows.getInt("FCount"));
                        break;
                    }
                    case 30: {
                        map.put("COUNT_ACCOUNT_FREEZE", rows.getInt("FCount"));
                        break;
                    }
                    case 10: {
                        map.put("COUNT_ACCOUNT_NORMAL", rows.getInt("FCount") + fluPersonNum);
                    }
                }
            }
            StringBuffer fluCheck = new StringBuffer();
            fluCheck.append("select a.FPersonID as personID,d.fischeck as isCheck \n");
            fluCheck.append("FROM T_HR_BenefitData d  \n");
            fluCheck.append("INNER JOIN T_HR_AccountDetail ad ON d.FAccountDetailID = ad.FID \n");
            fluCheck.append("INNER JOIN T_HR_Account a ON ad.FAccountID = a.FID \n");
            fluCheck.append("Inner join t_hr_fluctuationPerson fp on a.FPersonID = fp.FPersonID \n");
            fluCheck.append(" and fp.FTranInOldDep = 1 \n");
            fluCheck.append(" WHERE ad.FAccountTypeID = '").append(accountType).append("' \n");
            fluCheck.append("AND a.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
            fluCheck.append("and d.FCmpPeriodID = '").append(curPeriod).append("' \n");
            fluCheck.append("and ad.FCurPeriodID = '").append(curPeriod).append("' \n");
            fluCheck.append(payStateSql);
            fluCheck.append(" and fp.FOldAdminOrgID in ");
            if (adminSet.size() <= 100) {
                fluCheck.append(tempTableName);
            } else {
                fluCheck.append(" (select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            sb = new StringBuffer();
            sb.append("select count (distinct personID) as FCount,isCheck from \n");
            sb.append("( \n");
            sb.append("( select p.FID as personID,d.FIsCheck as isCheck \n");
            sb.append("FROM T_HR_BenefitData d  \n");
            sb.append("INNER JOIN T_HR_AccountDetail ad ON d.FAccountDetailID = ad.FID \n");
            sb.append("INNER JOIN T_HR_Account a ON ad.FAccountID = a.FID \n");
            sb.append("INNER JOIN T_BD_Person p ON a.FPersonID = p.FID \n");
            sb.append("INNER JOIN T_HR_PersonPosition pp on pp.FPersonID = p.fid \n ");
            sb.append(" WHERE ad.FAccountTypeID = '").append(accountType).append("' \n");
            sb.append("AND a.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
            sb.append("and d.FCmpPeriodID = '").append(curPeriod).append("' \n");
            sb.append("and ad.FCurPeriodID = '").append(curPeriod).append("' \n");
            sb.append(payStateSql);
            sb.append(" and pp.FPersonDep in ");
            if (adminSet.size() <= 100) {
                sb.append(tempTableName);
            } else {
                sb.append(" (select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            sb.append(") \n union all \n(");
            sb.append(fluCheck);
            sb.append(") \n");
            sb.append(") as T");
            sb.append("\n GROUP by isCheck \n");
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            boolean hasCheck = false;
            while (rows.next()) {
                hasCheck = rows.getBoolean("isCheck");
                if (hasCheck) {
                    map.put("COUNT_ACCOUNT_CURRENT_CHK", rows.getInt("FCount"));
                    continue;
                }
                map.put("COUNT_ACCOUNT_CURRENT_UNCHK", rows.getInt("FCount"));
            }
            sb = new StringBuffer();
            sb.append("SELECT COUNT(DISTINCT p.FID) AS FCount, d.FIsCheck \n");
            sb.append("FROM T_HR_BenefitAdjustData d  \n");
            sb.append("INNER JOIN T_HR_AccountDetail ad ON d.FAccountDetailID = ad.FID  \n");
            sb.append("INNER JOIN T_HR_Account a ON ad.FAccountID = a.FID \n");
            sb.append("INNER JOIN T_BD_Person p ON a.FPersonID = p.FID \n");
            sb.append("INNER JOIN T_HR_PersonPosition pp on pp.FPersonID = p.fid \n ");
            sb.append(" WHERE ad.FAccountTypeID = '").append(accountType).append("' \n");
            sb.append("AND a.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
            sb.append("and d.FCmpPeriodID = '").append(curPeriod).append("' \n");
            sb.append("and ad.FCurPeriodID = '").append(curPeriod).append("' \n");
            sb.append(" and pp.FPersonDep in ");
            if (adminSet.size() <= 100) {
                sb.append(tempTableName);
            } else {
                sb.append(" (select fAdminOrgid from ").append(tempTableName).append(" )");
            }
            sb.append("GROUP BY d.FIsCheck \n");
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rows.next()) {
                hasCheck = rows.getBoolean("FIsCheck");
                if (!hasCheck) {
                    map.put("COUNT_ADJUST_CURRENT_UNCHK", rows.getInt("FCount"));
                    continue;
                }
                map.put("COUNT_ADJUST_CURRENT_CHK", rows.getInt("FCount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (adminSet.size() > 100) {
                this.dropTmpTable(ctx, pool, tempTableName);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _calcuBenefit(Context ctx, String accountTypeId, List personList, String curPeriod, HashMap map) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitDataInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITCAL"), (String)"AccountCalcu");
        map.put("accountTypeId", accountTypeId);
        IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getLocalInstance(ctx);
        iBenefitRuleFacade.saveCalculateData(map);
        if (personList == null || personList.size() == 0) {
            return;
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        long endTime = System.currentTimeMillis();
        System.out.println("saveCalculateData total time :" + (endTime - startTime));
        startTime = System.currentTimeMillis();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String tmptableName = null;
        TempTablePool pool = null;
        String accountDetailTempTableName = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmptableName = this.createPersonTmpTable(ctx, pool, personList);
            try {
                accountDetailTempTableName = pool.createTempTable(" create TABLE aa (fid varchar(44) not null primary key,FPayState INT DEFAULT 0) ");
                StringBuffer sql = new StringBuffer("insert ");
                sql.append(" INTO ");
                sql.append(accountDetailTempTableName);
                sql.append("(fid, FPayState) ");
                sql.append(" select ad.fid fid,ad.FPayState FPayState from  T_HR_AccountDetail ad  \n");
                sql.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
                sql.append(" inner join " + tmptableName + " as tmp on a.fpersonid = tmp.FPersonID \n");
                sql.append(" where ad.faccounttypeid ='" + accountTypeId + "'");
                sql.append(" and a.fhrorgunitid ='" + hrOrgUnitId + "' \n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._checkUncheckAdjustdata(ctx, accountTypeId, curPeriod, tmptableName);
            this.deleteBenefitData(ctx, hrOrgUnitId, accountTypeId, tmptableName, accountDetailTempTableName);
            this.copyNormalData(ctx, hrOrgUnitId, accountTypeId, curPeriod, tmptableName, accountDetailTempTableName);
            this.calAdjustData(ctx, accountTypeId, curPeriod, tmptableName);
            this.insertAccountSetTMP(ctx, accountTypeId, curPeriod, tmptableName);
        }
        catch (Throwable throwable) {
            this.dropTmpTable(ctx, pool, tmptableName);
            this.dropTmpTable(ctx, pool, accountDetailTempTableName);
            throw throwable;
        }
        this.dropTmpTable(ctx, pool, tmptableName);
        this.dropTmpTable(ctx, pool, accountDetailTempTableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        endTime = System.currentTimeMillis();
        System.out.println("calcuBenefit total time :" + (endTime - startTime));
    }

    private void copyNormalData(Context ctx, String hrOrgUnitId, String accountTypeId, String cmpPeriodId, String tmptableName, String accountDetailTempTableName) throws BOSException {
        String bosType1 = new BenefitDataInfo().getBOSType().toString();
        String bosType2 = new BenefitDataDetailInfo().getBOSType().toString();
        StringBuffer insertData = new StringBuffer();
        insertData.append(" insert into t_hr_benefitdata \n");
        insertData.append(" (FID,  FHROrgUnitID, FCmpPeriodID, FAccountDetailID, FIsCheck) \n");
        insertData.append(" select newbosid('");
        insertData.append(bosType1);
        insertData.append("') as FID,'");
        insertData.append(hrOrgUnitId + "' as FHROrgUnitID, '");
        insertData.append(cmpPeriodId + "' as FCmpPeriodID,");
        insertData.append(" ad.FID as FAccountDetailID, 0 as FIsCheck \n");
        insertData.append(" from ").append(accountDetailTempTableName).append(" ad \n");
        insertData.append(" where  ad.FPayState =");
        insertData.append(10);
        insertData.append(" and ad.fid not in (");
        StringBuffer sb = new StringBuffer();
        sb.append("select ad.fid from t_hr_accountdetail ad \n");
        sb.append("inner join t_hr_benefitdata bd on bd.faccountdetailid = ad.fid \n");
        sb.append("where bd.fischeck = 1 ");
        sb.append("and ad.faccounttypeid =?  \n");
        sb.append("and bd.fhrorgunitid =? ");
        insertData.append(sb.toString() + ")");
        DbUtil.execute((Context)ctx, (String)insertData.toString(), (Object[])new Object[]{accountTypeId, hrOrgUnitId});
        StringBuffer insertDetailData = new StringBuffer();
        insertDetailData.append(" insert into t_hr_benefitdatadetail \n");
        insertDetailData.append("(FID, FValue, FBenefitDataID, FAccountItemInputID)");
        insertDetailData.append(" select  newbosid('");
        insertDetailData.append(bosType2);
        insertDetailData.append("') as FID, isnull(aii.fvalue,0) as FValue, bd.fid as FBenefitDataID, aii.fid as FAccountItemInputID \n");
        insertDetailData.append(" from ").append(accountDetailTempTableName).append(" ad");
        insertDetailData.append(" inner join t_hr_benefitdata bd on bd.faccountdetailid = ad.fid \n");
        insertDetailData.append(" inner join t_hr_accountiteminput aii on  aii.faccountdetailid = bd.faccountdetailid \n");
        insertDetailData.append(" inner join t_hr_item item on  aii.fitemid = item.fid \n");
        insertDetailData.append(" where  ad.fpaystate =");
        insertDetailData.append(10);
        insertDetailData.append(" and bd.fischeck = 0 ");
        insertDetailData.append(" and bd.fhrorgunitid =? ");
        insertDetailData.append(" and item.fhrorgunitid =? ");
        DbUtil.execute((Context)ctx, (String)insertDetailData.toString(), (Object[])new Object[]{hrOrgUnitId, hrOrgUnitId});
    }

    private void deleteBenefitData(Context ctx, String hrOrgUnitId, String accountTypeId, String tmptableName, String accountDetailTempTableName) throws BOSException {
        StringBuffer delDetailSql = new StringBuffer();
        delDetailSql.append(" delete from T_HR_benefitDataDetail where exists( \n");
        delDetailSql.append(" select 1 from T_HR_BenefitData bd \n");
        delDetailSql.append(" inner join ").append(accountDetailTempTableName).append(" ad on bd.faccountdetailid = ad.fid \n");
        delDetailSql.append(" where  bd.FHrOrgUnitId ='" + hrOrgUnitId + "' \n");
        delDetailSql.append(" and bd.FIsCheck = 0 ");
        delDetailSql.append(" and bd.fid = T_HR_benefitDataDetail.FBenefitDataID ");
        delDetailSql.append(")");
        StringBuffer selSql = new StringBuffer();
        selSql.append(" delete from T_HR_BenefitData where exists\n");
        selSql.append("(select 1 from ");
        selSql.append(accountDetailTempTableName).append(" ad where ad.fid = T_HR_BenefitData.faccountdetailid)\n");
        selSql.append(" and FHrOrgUnitId ='" + hrOrgUnitId + "' \n");
        selSql.append(" and FIsCheck = 0 ");
        DbUtil.execute((Context)ctx, (String)delDetailSql.toString());
        DbUtil.execute((Context)ctx, (String)selSql.toString());
    }

    public void _checkUncheckAdjustdata(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException, EASBizException {
        try {
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select top 1 bad.fid from t_hr_benefitadjustdata bad \n");
            sql.append(" inner join t_hr_accountdetail ad on bad.faccountdetailid = ad.fid \n");
            sql.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
            sql.append(" inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
            sql.append(" where bad.fcmpperiodid = ? \n");
            sql.append(" and ad.faccounttypeid = ? \n");
            sql.append(" and bad.fhrorgunitid =? \n");
            sql.append(" and a.fhrorgunitid = ? \n");
            sql.append(" and bad.fischeck = 0");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cmpPeriodId, accountTypeId, hrOrgUnitId, hrOrgUnitId});
            if (rows.size() > 0) {
                throw new BenefitException(BenefitException.EXIST_UNCHECK_ADJUSTDATA);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
    }

    public void checkUncheckAdjData(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName, String accountDetailTempTableName) throws BOSException, EASBizException {
        try {
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select top 1 bad.fid from t_hr_benefitadjustdata bad \n");
            sql.append(" inner join ").append(accountDetailTempTableName).append(" ad on bad.faccountdetailid = ad.fid \n");
            sql.append(" where bad.fcmpperiodid = ? \n");
            sql.append(" and bad.fhrorgunitid =? \n");
            sql.append(" and bad.fischeck = 0");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cmpPeriodId, hrOrgUnitId});
            if (rows.size() > 0) {
                throw new BenefitException(BenefitException.EXIST_UNCHECK_ADJDATA);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
    }

    private void calAdjustData(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        if (!this.isExistAdjustData(ctx, accountTypeId, cmpPeriodId, tmptableName)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select badd.faccountiteminput accountiteminput,badd.fvalue value,badd.foperatetype optype \n");
        sb.append("from t_hr_benefitadjustdatadetail badd \n");
        sb.append("inner join t_hr_benefitadjustdata bad on badd.fbenefitadjustdataid = bad.fid \n");
        sb.append("inner join t_hr_accountdetail ad on bad.faccountdetailid = ad.fid \n");
        sb.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        sb.append("inner join " + tmptableName + " as tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("inner join t_hr_accountiteminput aii on badd.FAccountItemInput = aii.fid \n");
        sb.append("inner join t_hr_item i on aii.fitemid = i.fid \n");
        sb.append("left outer join t_hr_benefitdata bd on bd.faccountdetailid = ad.fid \n");
        sb.append("where bad.fcmpperiodid = ? \n");
        sb.append(" and ad.faccounttypeid = ? \n");
        sb.append(" and bd.fischeck =0 ");
        sb.append(" and i.fbenefititemnumber <> '");
        sb.append("Base_insu'");
        sb.append(" and a.fhrorgunitid = ? ");
        String sb1 = "update t_hr_benefitdatadetail set fvalue = fvalue + ? where faccountiteminputid = ? ";
        String sb2 = "update t_hr_benefitdatadetail set fvalue = fvalue - ? where faccountiteminputid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{cmpPeriodId, accountTypeId, ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()});
        try {
            String accountiteminput = null;
            String value = null;
            int type = 1;
            ArrayList<Object[]> paramOneList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramTwoList = new ArrayList<Object[]>();
            Object[] objects = null;
            while (rs.next()) {
                accountiteminput = rs.getString("accountiteminput");
                value = rs.getString("value");
                type = rs.getInt("optype");
                if (type == -1) {
                    objects = new Object[]{value, accountiteminput};
                    paramOneList.add(objects);
                    continue;
                }
                objects = new Object[]{value, accountiteminput};
                paramTwoList.add(objects);
            }
            if (paramOneList.size() > 0) {
                HrExDbUtil.executeBatch(ctx, sb2.toString(), paramOneList);
            }
            if (paramTwoList.size() > 0) {
                HrExDbUtil.executeBatch(ctx, sb1.toString(), paramTwoList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isExistAdjustData(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select top 1 bad.fid from t_hr_benefitadjustdata bad \n");
        selectSql.append("inner join t_hr_accountdetail ad on bad.faccountdetailid = ad.fid \n");
        selectSql.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        selectSql.append("inner join " + tmptableName + " tmp on a.fpersonID = tmp.FPersonID \n");
        selectSql.append("where ad.faccounttypeid = ? \n");
        selectSql.append("and bad.fcmpperiodid = ? \n");
        selectSql.append("and bad.fhrorgunitid = ? \n");
        selectSql.append("and a.fhrorgunitid = ? ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{accountTypeId, cmpPeriodId, hrOrgUnitId, hrOrgUnitId});
        if (rows.size() > 0) {
            return true;
        }
        return false;
    }

    private boolean isExistAdjustDataSP(Context ctx, String tmpTableName, String accountTypeId, String cmpPeriodId) throws BOSException {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select top 1 bad.fid from t_hr_benefitadjustdata bad \n");
        selectSql.append(" inner join " + tmpTableName + " tt on bad.faccountdetailid = tt.fid  ");
        selectSql.append(" where  bad.fhrorgunitid = ? and bad.fcmpperiodid = ? \n");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
            if (rows.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String[] getCtrlHRIdByAccountDetailId(Context ctx, String accountDetailId) throws BOSException {
        String ctrlUnitId = null;
        String hrOrgUnitId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select ad.FControlUnitID as FControlUnitID, a.FHROrgUnitID as FHROrgUnitID \n");
        sql.append("from t_hr_accountdetail ad \n");
        sql.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        sql.append("where ad.fid = ?");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountDetailId});
        try {
            if (rows.next()) {
                ctrlUnitId = rows.getString("FControlUnitID");
                hrOrgUnitId = rows.getString("FHROrgUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return new String[]{ctrlUnitId, hrOrgUnitId};
    }

    private String insertBenefitAdjData(Context ctx, HashMap ids, OperateTypeEnum oprtType) throws BOSException, EASBizException {
        String periodId = (String)ids.get("periodId");
        String periodHisId = (String)ids.get("periodHisId");
        String accountDetailId = (String)ids.get("accountDetailId");
        String ctrlUnitId = (String)ids.get("ctrlUnitId");
        String hrOrgUnitId = (String)ids.get("hrOrgUnitId");
        StringBuffer insertAdj = new StringBuffer();
        insertAdj.append("INSERT INTO T_HR_BenefitAdjustData \n");
        insertAdj.append("      (FID, FCreatorID, FCreateTime, FControlUnitID, FIsCheck, FOperateType,  \n");
        insertAdj.append("      FCmpPeriodID, FCmpPeriodHisID, FAccountDetailID, FHROrgUnitID) \n");
        insertAdj.append("VALUES (? ,? ,? ,? ,? ,? ,? ,? ,? ,? ) \n");
        String adjDataId = BOSUuid.create((BOSObjectType)new BenefitAdjustDataInfo().getBOSType()).toString();
        String createId = ctx.getCaller().toString();
        java.sql.Date createTime = new java.sql.Date(new Date().getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AD.FControlUnitID as FControlUnitID,A.FHROrgUnitID as FHROrgUnitID \n");
        sql.append("FROM T_HR_AccountDetail AD \n");
        sql.append("INNER JOIN T_HR_Account A on AD.FAccountID = A.FID \n ");
        sql.append("WHERE AD.FID = ? ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountDetailId});
        try {
            if (rows.next()) {
                hrOrgUnitId = rows.getString("FHROrgUnitID");
                ctrlUnitId = rows.getString("FControlUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)insertAdj.toString(), (Object[])new Object[]{adjDataId, createId, createTime, ctrlUnitId, 0, oprtType.getValue(), periodId, periodHisId, accountDetailId, hrOrgUnitId});
        return adjDataId;
    }

    private String updateBenefitAdjData(Context ctx, HashMap ids, OperateTypeEnum oprtType) throws BOSException, EASBizException {
        String periodId = (String)ids.get("periodId");
        String periodHisId = (String)ids.get("periodHisId");
        String accountDetailId = (String)ids.get("accountDetailId");
        String ctrlUnitId = (String)ids.get("ctrlUnitId");
        String hrOrgUnitId = (String)ids.get("hrOrgUnitId");
        StringBuffer updateAdj = new StringBuffer();
        updateAdj.append("update T_HR_BenefitAdjustData \n");
        updateAdj.append("      set FCreatorID = ?, FCreateTime = ?, FControlUnitID = ?, FIsCheck = ?, FOperateType = ?,  \n");
        updateAdj.append("      FCmpPeriodID = ?, FCmpPeriodHisID = ?, FAccountDetailID = ?, FHROrgUnitID = ? where fid = ?\n");
        String adjDataId = (String)ids.get("adjDataId");
        String createId = ctx.getCaller().toString();
        java.sql.Date createTime = new java.sql.Date(new Date().getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AD.FControlUnitID as FControlUnitID,A.FHROrgUnitID as FHROrgUnitID \n");
        sql.append("FROM T_HR_AccountDetail AD \n");
        sql.append("INNER JOIN T_HR_Account A on AD.FAccountID = A.FID \n ");
        sql.append("WHERE AD.FID = ? ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountDetailId});
        try {
            if (rows.next()) {
                hrOrgUnitId = rows.getString("FHROrgUnitID");
                ctrlUnitId = rows.getString("FControlUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)updateAdj.toString(), (Object[])new Object[]{createId, createTime, ctrlUnitId, 0, oprtType.getValue(), periodId, periodHisId, accountDetailId, hrOrgUnitId, adjDataId});
        return adjDataId;
    }

    public void deleteBenefitAdjustData(Context ctx, String adjDataId) throws BOSException, EASBizException {
        String delDataDetailSql = "DELETE FROM T_HR_BenefitAdjustDataDetail WHERE FBenefitAdjustDataID = ? ";
        String delDataSql = "DELETE FROM T_HR_BenefitAdjustData WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)delDataDetailSql, (Object[])new Object[]{adjDataId});
        DbUtil.execute((Context)ctx, (String)delDataSql, (Object[])new Object[]{adjDataId});
    }

    public void deleteBenefitAdjustData(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        HashSet set = new HashSet();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            set.add(idList.get(i));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("benefitAdjustData.id", set, CompareType.INCLUDE));
        IBenefitAdjustDataDetail ibadd = BenefitAdjustDataDetailFactory.getLocalInstance(ctx);
        ibadd.delete(filter);
        IBenefitAdjustData ibad = BenefitAdjustDataFactory.getLocalInstance(ctx);
        filter.getFilterItems().get(0).setPropertyName("id");
        ibad.delete(filter);
    }

    public void _saveBenefitAdjustData(Context ctx, String curPeriod, ArrayList valueList, OperateTypeEnum oprtType, String accountTypeId, HashMap listMap) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitAdjustDataDetailInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITADJUST"), (String)"BenefitAdjust_addnew");
        if (valueList == null || valueList.size() == 0) {
            return;
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT bdd.FID AS FID \n");
        selectSql.append("FROM T_HR_BenefitAdjustDataDetail bdd INNER JOIN \n");
        selectSql.append("      T_HR_BenefitAdjustData bd ON bdd.FBenefitAdjustDataID = bd.FID INNER JOIN \n");
        selectSql.append("      T_HR_AccountItemInput aii ON bdd.FAccountItemInput = aii.FID INNER JOIN \n");
        selectSql.append("      T_HR_Item i ON aii.FItemID = i.FID \n");
        selectSql.append("WHERE (bd.FID = ?) AND (i.FID = ?) \n");
        logger.debug((Object)("saveBenefitAdjustData() :selectSql " + selectSql.toString()));
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO T_HR_BenefitAdjustDataDetail \n");
        insertSql.append("      (FID, FValue, FOperateType, FBenefitAdjustDataID, FAccountItemInput) \n");
        insertSql.append("VALUES (? ,? ,? ,? ,? ) \n");
        String updateSql = "Update T_HR_BenefitAdjustDataDetail SET FValue = ? WHERE FID = ? ";
        String deleteSql = "Delete from T_HR_BenefitAdjustDataDetail where FID = ? ";
        String selItemInputSql = "SELECT FID from T_HR_AccountItemInput WHERE FItemID = ? and FAccountDetailID = ?";
        HashMap value = null;
        String accountDetailId = null;
        String periodHisId = null;
        String adjDataId = null;
        String[] ctrlAndhrIds = null;
        String ctrlUnitId = null;
        String hrOrgUnitId = null;
        IRowSet rows = null;
        Object[] datas = null;
        String itemId = null;
        BigDecimal data = null;
        String adjDataDetailId = null;
        String id = null;
        String accountItemInputId = null;
        ArrayList dataList = null;
        BigDecimal ZERO = new BigDecimal(0);
        boolean hasFind = false;
        int size = valueList.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, String> map;
            value = (HashMap)valueList.get(i);
            accountDetailId = (String)value.get("accountDetailId");
            periodHisId = (String)value.get("periodHisId");
            adjDataId = (String)value.get("adjustDataId");
            ctrlAndhrIds = this.getCtrlHRIdByAccountDetailId(ctx, accountDetailId);
            ctrlUnitId = ctrlAndhrIds[0];
            hrOrgUnitId = ctrlAndhrIds[1];
            rows = null;
            if (adjDataId == null) {
                map = new HashMap<String, String>();
                map.put("periodId", curPeriod);
                map.put("periodHisId", periodHisId);
                map.put("accountDetailId", accountDetailId);
                map.put("ctrlUnitId", ctrlUnitId);
                map.put("hrOrgUnitId", hrOrgUnitId);
                adjDataId = this.insertBenefitAdjData(ctx, map, oprtType);
            } else {
                map = new HashMap();
                map.put("periodId", curPeriod);
                map.put("periodHisId", periodHisId);
                map.put("accountDetailId", accountDetailId);
                map.put("ctrlUnitId", ctrlUnitId);
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("adjDataId", adjDataId);
                this.updateBenefitAdjData(ctx, map, oprtType);
            }
            dataList = (ArrayList)value.get("datas");
            int count = dataList.size();
            for (int j = 0; j < count; ++j) {
                datas = (Object[])dataList.get(j);
                itemId = (String)datas[0];
                data = (BigDecimal)datas[1];
                if (data == null) {
                    data = ZERO;
                }
                adjDataDetailId = null;
                rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{adjDataId, itemId});
                try {
                    hasFind = rows.next();
                    if (hasFind) {
                        adjDataDetailId = rows.getString("FID");
                    }
                    if (hasFind && data.compareTo(ZERO) != 0) {
                        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{data, adjDataDetailId});
                    } else if (hasFind && data.compareTo(ZERO) == 0) {
                        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{adjDataDetailId});
                    } else if (!hasFind && data.compareTo(ZERO) != 0) {
                        accountItemInputId = null;
                        IRowSet tmp = DbUtil.executeQuery((Context)ctx, (String)selItemInputSql, (Object[])new Object[]{itemId, accountDetailId});
                        if (tmp.next()) {
                            accountItemInputId = tmp.getString("FID");
                        }
                        tmp.close();
                        id = BOSUuid.create((BOSObjectType)new BenefitAdjustDataDetailInfo().getBOSType()).toString();
                        if (accountItemInputId != null && ctrlUnitId != null) {
                            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{id, data, oprtType.getValue(), adjDataId, accountItemInputId});
                        }
                    }
                    rows.close();
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        List hisCmp = (List)listMap.get("hisCmp");
        List account = (List)listMap.get("account");
        List benefitList = (List)listMap.get("benefitList");
        this.insertZeroToHis(ctx, curPeriod, hisCmp, account, accountTypeId, benefitList);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected String _checkAutidData(Context ctx, String accountTypeID, HashSet personID) throws BOSException, EASBizException {
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (personID.size() > 500) {
            tempTableName = BenefitUtils.createTempTableName(ctx, "fPersonId", "checkAutidDataTempTable", personID);
        }
        sql.append(" select bd.fid,p.fnumber from t_hr_benefitdata bd \n");
        sql.append(" inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
        sql.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
        sql.append(" inner join t_bd_person p on a.fpersonid = p.fid \n");
        if (personID.size() > 500) {
            sql.append(" inner join ").append(tempTableName).append(" temp on a.fpersonid = temp.fPersonId ");
        }
        sql.append(" where ad.faccounttypeid = ? \n ");
        sql.append(" and bd.fischeck = 1 ");
        sql.append(" and a.fhrorgunitid = ? \n");
        if (personID.size() <= 500) {
            sql.append(" and p.fid in ");
            sql.append(BenefitUtils.getStrFromSet(personID));
        }
        IRowSet rows = null;
        String perNumber = null;
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountTypeID, hrOrgUnit});
        if (rows.size() > 0) {
            try {
                rows.next();
                perNumber = rows.getString("fnumber");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.dropTmpTable(ctx, pool, tempTableName);
            }
        } else {
            this.dropTmpTable(ctx, pool, tempTableName);
        }
        return perNumber;
    }

    public void saveBenefitData(Context ctx, Object[] value) throws BOSException, EASBizException {
        String benefitDataId = (String)value[0];
        String itemId = (String)value[1];
        BigDecimal data = (BigDecimal)value[2];
        String benefitDataDetailId = null;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT bdd.FID AS FID \n");
        selectSql.append("FROM T_HR_BenefitDataDetail bdd INNER JOIN \n");
        selectSql.append("      T_HR_BenefitData bd ON bdd.FBenefitDataID = bd.FID INNER JOIN \n");
        selectSql.append("      T_HR_AccountItemInput aii ON bdd.FAccountItemInputID = aii.FID INNER JOIN \n");
        selectSql.append("      T_HR_Item i ON aii.FItemID = i.FID \n");
        selectSql.append("WHERE (bd.FID = ?) AND (i.FID = ?) \n");
        logger.debug((Object)("saveBenefitData() :selectSql " + selectSql.toString()));
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO T_HR_BenefitDataDetail \n");
        insertSql.append("      (FID, FValue, FBenefitDataID,  \n");
        insertSql.append("      FAccountItemInputID) \n");
        insertSql.append("VALUES (? ,? ,? ,?) \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{benefitDataId, itemId});
        try {
            if (rows.next()) {
                benefitDataDetailId = rows.getString("FID");
                DbUtil.execute((Context)ctx, (String)"Update T_HR_BenefitDataDetail SET FValue = ? WHERE FID = ? ", (Object[])new Object[]{data, benefitDataDetailId});
            } else {
                String accountItemInputId = null;
                String ctrlUnitId = null;
                String sql = "SELECT b.FControlUnitID as FControlUnitID, aii.FID as FID FROM T_HR_Item i INNER JOIN T_HR_AccountItemInput aii ON i.FID = aii.FItemID INNER JOIN T_HR_Benefit b ON i.FBenefitID = b.FID WHERE i.FID = ?";
                IRowSet tmp = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{itemId});
                if (tmp.next()) {
                    accountItemInputId = tmp.getString("FID");
                    ctrlUnitId = tmp.getString("FControlUnitID");
                }
                tmp.close();
                String id = BOSUuid.create((BOSObjectType)new BenefitDataDetailInfo().getBOSType()).toString();
                if (accountItemInputId != null && ctrlUnitId != null) {
                    DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{id, data, benefitDataId, accountItemInputId});
                }
            }
            rows.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void saveBenefitData(Context ctx, ArrayList list) throws BOSException, EASBizException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.saveBenefitData(ctx, (Object[])list.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _checkBenefitData(Context ctx, String accountTypeId, String cmpPeriodId, List accIdList) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitDataInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITAUDIT"), (String)"AccountCheck_audit");
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String tmptableName = null;
        TempTablePool pool = null;
        String accountDetailTempTableName = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmptableName = this.createTmpTable(ctx, pool, accIdList);
            try {
                accountDetailTempTableName = pool.createTempTable(" create TABLE aa (fid varchar(44) not null primary key) ");
                StringBuffer sql = new StringBuffer("insert ");
                sql.append(" INTO ");
                sql.append(accountDetailTempTableName);
                sql.append("(fid) ");
                sql.append(" select ad.fid fid from  T_HR_AccountDetail ad  \n");
                sql.append(" inner join " + tmptableName + " a on ad.faccountid = a.faccountid \n");
                sql.append(" where ad.faccounttypeid ='" + accountTypeId + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.checkUncheckAdjData(ctx, accountTypeId, cmpPeriodId, tmptableName, accountDetailTempTableName);
            this.updateStatus(ctx, tmptableName, accountTypeId, cmpPeriodId, hrOrgUnitId, accountDetailTempTableName, true);
            this.copyDataToHis(ctx, tmptableName, accountTypeId, cmpPeriodId, accountDetailTempTableName);
            if (this.isExistAdjustDataSP(ctx, accountDetailTempTableName, accountTypeId, cmpPeriodId)) {
                this.doInsertDataTmpJava(ctx, tmptableName, cmpPeriodId, accountTypeId, hrOrgUnitId);
                this.calcuBalanceNew(ctx, accountTypeId, cmpPeriodId, hrOrgUnitId, this.getAccDetailId(ctx, tmptableName, accountTypeId));
            }
            this.BuildBenefitReportData(ctx, tmptableName, accountTypeId, cmpPeriodId, hrOrgUnitId);
        }
        catch (Throwable throwable) {
            this.dropTmpTable(ctx, pool, tmptableName);
            this.dropTmpTable(ctx, pool, accountDetailTempTableName);
            throw throwable;
        }
        this.dropTmpTable(ctx, pool, tmptableName);
        this.dropTmpTable(ctx, pool, accountDetailTempTableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private String createTmpTable(Context ctx, TempTablePool pool, List accIdList) throws BOSException {
        String cSql = " create TABLE  t1 (FAccountId varchar(44) not null primary key) ";
        String tmpTable = null;
        try {
            tmpTable = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            logger.error((Object)cSql.toString());
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTable + " (FAccountId) values (?) \n");
        Object[] objects = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int s = accIdList.size();
        for (int i = 0; i < s; ++i) {
            objects = new Object[]{accIdList.get(i)};
            list.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, sbInsert.toString(), list);
        return tmpTable;
    }

    private String createPersonTmpTable(Context ctx, TempTablePool pool, List personList) throws BOSException {
        String cSql = " create TABLE  t1 (FPersonID varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            logger.error((Object)cSql.toString());
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FPersonID ) values (?) \n");
        Object[] objects = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int s = personList.size();
        for (int i = 0; i < s; ++i) {
            objects = new Object[]{personList.get(i)};
            list.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, sbInsert.toString(), list);
        return tmpTableName;
    }

    private void dropTmpTable(Context ctx, TempTablePool pool, String tableName) throws BOSException {
        try {
            if (tableName != null) {
                pool.releaseTable(tableName);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void copyDataToHis(Context ctx, String tmpTableName, String accountTypeId, String cmpPeriodId, String accountDetailTempTableName) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_HR_BenefitDataDetailHis \n");
        sb.append("WHERE FBenefitDataHisID in \n");
        sb.append("(SELECT his.FID \n");
        sb.append("FROM T_HR_BENEFITDATAHis his \n");
        sb.append(" inner join ").append(accountDetailTempTableName).append(" tmp on tmp.fid = his.FAccountDetailId");
        sb.append(" WHERE his.FHROrgUnitID = ? AND his.FCmpPeriodID = ?  \n");
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
        sb = new StringBuffer();
        sb.append("DELETE FROM T_HR_BENEFITDATAHis \n");
        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
        sb.append("AND exists  \n");
        sb.append(" (SELECT d.FID \n");
        sb.append("  FROM ").append(accountDetailTempTableName).append(" d   \n");
        sb.append("  WHERE  T_HR_BENEFITDATAHis.FAccountDetailId = d.FID \n");
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
        sb = new StringBuffer();
        sb.append("INSERT INTO T_HR_BENEFITDATAHIS(FID, FControlUnitID, FHROrgUnitID, FCmpPeriodID, FAccountDetailID \n");
        sb.append(",FAdminOrgUnitHis,FPositionHis)");
        sb.append("SELECT bd.fid");
        sb.append(", bd.FControlUnitID, bd.FHROrgUnitID, bd.FCmpPeriodID, bd.FAccountDetailID ,pp.FPersonDep as adminid,pp.FPrimaryPositionID as positionid \n");
        sb.append("FROM T_HR_BENEFITDATA bd \n");
        sb.append(" inner join ").append(accountDetailTempTableName).append(" tmp on bd.FAccountDetailId = tmp.FID\n");
        sb.append(" inner join T_HR_AccountDetail ad on ad.fid = tmp.fid \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.fid \n");
        sb.append(" left outer join T_HR_PersonPosition pp on pp.FPersonID = a.FPersonID  \n");
        sb.append("WHERE bd.FHROrgUnitID = ? AND bd.FCmpPeriodID = ? \n");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
        sb = new StringBuffer();
        sb.append("INSERT INTO T_HR_BenefitDataDetailHis (FID, FValue, FTotalValue, FExistsComplementary, FBenefitDataHisID, FAccountItemInputID) \n");
        sb.append("SELECT dd.fid");
        sb.append(", dd.FValue, dd.FValue, 0, dd.FBenefitDataID, dd.FAccountItemInputID \n");
        sb.append("FROM t_Hr_Benefitdatadetail dd \n");
        sb.append("where FBenefitDataID in (select d.fid ");
        sb.append(" from T_HR_BENEFITDATA D ");
        sb.append(" inner join ").append(accountDetailTempTableName).append(" AD on D.FAccountDetailId = ad.fid ");
        sb.append(" WHERE D.FHROrgUnitID = ? ");
        sb.append(" AND D.FCmpPeriodID = ? ");
        sb.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.FID as accountID,fluPer.FOldAdminOrgID as adminID \n");
        sql.append(" from t_hr_fluctuationPerson fluPer \n");
        sql.append(" inner join t_hr_account a on a.FPersonID =fluPer.FPersonID \n");
        sql.append(" inner join ").append(tmpTableName);
        sql.append(" tt on a.FID = tt.FAccountId \n");
        sql.append(" and fluPer.FTranInOldDep =1 ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows.size() > 0) {
            StringBuffer updAdmin = new StringBuffer();
            updAdmin.append("update T_HR_BenefitDataHis set FAdminOrgUnitHis = ? ");
            updAdmin.append(" where FCmpPeriodID = '");
            updAdmin.append(cmpPeriodId);
            updAdmin.append("' and FAccountDetailID in \n");
            updAdmin.append("( select fid from T_HR_AccountDetail ");
            updAdmin.append(" where FAccountID = ? and FAccountTypeID =? )");
            String accountID = null;
            String adminID = null;
            String positionID = null;
            ArrayList<Object[]> mainList = new ArrayList<Object[]>();
            try {
                while (rows.next()) {
                    accountID = rows.getString("accountID");
                    adminID = rows.getString("adminID");
                    mainList.add(new Object[]{adminID, accountID, accountTypeId});
                }
                HrExDbUtil.executeBatch(ctx, updAdmin.toString(), mainList);
                StringBuffer updPos = new StringBuffer();
                updPos.append("update T_HR_BenefitDataHis set FPositionHis = ? ");
                updPos.append("where FCmpPeriodID = '");
                updPos.append(cmpPeriodId);
                updPos.append("' and FAccountDetailID in \n");
                updPos.append("( select fid from T_HR_AccountDetail ");
                updPos.append(" where FAccountID = ? and FAccountTypeID =? )");
                IFluctuationPerson ifp = FluctuationPersonFactory.getLocalInstance(ctx);
                boolean useNewBill = ifp.useNewBill();
                StringBuffer fsql = new StringBuffer();
                if (!useNewBill) {
                    fsql.append("select a.FID as accountID,abd.FOldPositionID as position from T_HR_AffairHistory abd \n");
                    fsql.append(" inner join T_HR_FluctuationPerson fp on abd.FPersonID = fp.FPersonID \n");
                    fsql.append(" and fp.FOldAdminOrgID = abd.FOldDeptID \n");
                    fsql.append(" and fp.FNewAdminOrgID = abd.FNewDeptID \n");
                    fsql.append(" inner join t_hr_account a on fp.FPersonID = a.FPersonID \n");
                    fsql.append(" inner join ").append(tmpTableName);
                    fsql.append(" tt on a.FID = tt.FAccountId \n");
                    fsql.append(" where fp.FTranInOldDep = 1 \n");
                    fsql.append(" and abd.FOldDeptID <> abd.FNewDeptID");
                } else {
                    fsql.append("select a.FID as accountID,abd.FOldPositionID as position from T_HR_AffairBizDetail abd \n");
                    fsql.append(" inner join T_HR_FluctuationPerson fp on abd.FPersonID = fp.FPersonID \n");
                    fsql.append(" and fp.FOldAdminOrgID = abd.FOldAdminID \n");
                    fsql.append(" and fp.FNewAdminOrgID = abd.FNewAdminID \n");
                    fsql.append(" inner join t_hr_account a on fp.FPersonID = a.FPersonID \n");
                    fsql.append(" inner join ").append(tmpTableName);
                    fsql.append(" tt on a.FID = tt.FAccountId \n");
                    fsql.append(" where fp.FTranInOldDep = 1 \n");
                    fsql.append(" and abd.FBillState = 3");
                    fsql.append(" and abd.foldAdminid <> abd.fnewAdminid");
                }
                rows = DbUtil.executeQuery((Context)ctx, (String)fsql.toString());
                mainList = new ArrayList();
                while (rows.next()) {
                    accountID = rows.getString("accountID");
                    positionID = rows.getString("position");
                    mainList.add(new Object[]{positionID, accountID, accountTypeId});
                }
                HrExDbUtil.executeBatch(ctx, updPos.toString(), mainList);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
    }

    private void updateStatus(Context ctx, String tmptableName, String accountTypeId, String cmpPeriodId, String hrOrgUnitId, String accountDetailTempTableName, boolean isCheck) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("Update T_HR_BENEFITDATA SET FISCheck = ?  \n");
        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
        sb.append("AND FAccountDetailId in  \n");
        sb.append("(SELECT d.FID \n");
        sb.append(" FROM ").append(accountDetailTempTableName).append(" d  \n").append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{isCheck, hrOrgUnitId, cmpPeriodId});
    }

    private void BuildBenefitReportData(Context ctx, String tmpTableName, String accountTypeID, String cmpPeriodID, String hrOrgUnitId) throws BOSException, EASBizException {
        this.transDataImpl(ctx, tmpTableName, accountTypeID, cmpPeriodID, hrOrgUnitId);
    }

    private void deleteReportTablData(Context ctx, String tmpTableName, String accountTypeID, String cmpPeriodID, String hrOrgUnitId, List cmpIdList) throws BOSException, EASBizException {
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from T_HR_BenefitReportTable where FCMPPERIODID in ");
        delSql.append(CompUtils.getStrFromList((List)cmpIdList));
        delSql.append(" and FACCOUNTTYPEID = ?");
        delSql.append(" and faccountid in (");
        delSql.append(" select FAccountId from ");
        delSql.append(tmpTableName + ")");
        DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{accountTypeID});
    }

    private List getHisCmpPeriodList(Context ctx, String accountTypeID, String cmpPeriodID) throws BOSException, EASBizException {
        String selectSql = "select top 1 period.fbegindate as fbegindate from t_hr_benefitadjustdatatmp tmp inner join t_hr_cmpperiod period on tmp.fcmpperiodid = period.fid  where faccounttypeid = '" + accountTypeID + "' order by period.fbegindate asc";
        IRowSet rows = null;
        rows = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        java.sql.Date startDate = null;
        try {
            while (rows.next()) {
                startDate = rows.getDate("FBEGINDATE");
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        ArrayList<String> hisCmpIdList = new ArrayList<String>();
        if (startDate == null) {
            return hisCmpIdList;
        }
        if (this.getCmpPeriodInfoForConstant(ctx, cmpPeriodID, -1) == null) {
            return hisCmpIdList;
        }
        Date endDate = this.getCmpPeriodInfoForConstant(ctx, cmpPeriodID, -1).getEndDate();
        ICmpCommonFacade iCmpCommonFacade = CmpCommonFacadeFactory.getLocalInstance((Context)ctx);
        CmpPeriodCollection coll = null;
        coll = iCmpCommonFacade.getCmpPeriodColl((Date)startDate, endDate);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            hisCmpIdList.add(coll.get(i).getId().toString());
        }
        return hisCmpIdList;
    }

    private void transDataImpl(Context ctx, String tmpTableName, String accountTypeID, String cmpPeriodID, String hrOrgUnitId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT distinct acc.fpersonid AS PID, bdh.fcmpperiodid AS CMPID, at.fid AS ATID, ");
        sb.append(this.makeBeneItemSql(ctx, hrOrgUnitId));
        sb.append("acc.fid AS ACCID, benefit.fid AS BID, ");
        sb.append(" bdh.FAdminOrgUnitHis as FAdminOrgUnitHis, ");
        sb.append(" bdh.FPositionHis as FPositionHis \n");
        sb.append(" FROM t_hr_benefitdatadetailhis bddh \n");
        sb.append("INNER JOIN t_hr_benefitdatahis bdh ON bddh.fbenefitdatahisid = bdh.fid \n");
        sb.append("INNER JOIN t_hr_accountiteminput aii ON bddh.faccountiteminputid = aii.fid \n");
        sb.append("INNER JOIN t_hr_item i ON aii.fitemid = i.fid \n");
        sb.append("INNER JOIN t_hr_benefit benefit ON i.fbenefitid = benefit.fid \n");
        sb.append("INNER JOIN t_hr_benefititem bi ON i.fitemid = bi.fid \n");
        sb.append("INNER JOIN t_hr_accountdetail AD ON bdh.faccountdetailid = ad.fid \n");
        sb.append("INNER JOIN t_hr_account acc ON ad.faccountid = acc.fid \n");
        sb.append("INNER JOIN t_hr_accounttype at ON ad.faccounttypeid = at.fid \n");
        sb.append("inner join " + tmpTableName + " tt on acc.fid = tt.FAccountId \n");
        sb.append("where bdh.fcmpperiodid = ?  and at.fid = ? ");
        sb.append(" and bdh.fhrorgunitid = ? and benefit.fhrorgunitid = ? and bi.fhrorgunitid = ? \n");
        sb.append(" GROUP BY acc.fpersonid, bdh.fcmpperiodid, at.fid, acc.fid, benefit.fid,FAdminOrgUnitHis,FPositionHis");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{cmpPeriodID, accountTypeID, hrOrgUnitId, hrOrgUnitId, hrOrgUnitId});
        ArrayList<Object[]> mainList = new ArrayList<Object[]>();
        Object[] objects = null;
        String keyName = null;
        try {
            while (rows.next()) {
                objects = new Object[rows.getMetaData().getColumnCount()];
                int size = rows.getMetaData().getColumnCount();
                for (int i = 1; i <= size; ++i) {
                    keyName = rows.getMetaData().getColumnName(i);
                    objects[i - 1] = rows.getMetaData().getColumnType(i) == 12 ? rows.getString(keyName) : rows.getBigDecimal(keyName).setScale(5);
                }
                mainList.add(objects);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb = new StringBuffer();
        sb.append("INSERT INTO T_HR_BenefitReportTable ");
        sb.append("( FPersonID, FCmpPeriodID , FAccountTypeID, ");
        sb.append(this.makeInsertBeneReportSql(ctx, hrOrgUnitId));
        sb.append(" FAccountID, FBenefitID,FAdminOrgUnitHis,FPositionHis) VALUES(\n");
        sb.append(this.makeParams(ctx, hrOrgUnitId));
        sb.append(" ?, ?, ?, ?, ? )");
        HrExDbUtil.executeBatch(ctx, sb.toString(), mainList);
    }

    private String makeBeneItemSql(Context ctx, String hrOrgUnitId) throws BOSException {
        StringBuffer resultString = new StringBuffer();
        IRowSet rows = this.getBeneItemRows(ctx, hrOrgUnitId);
        String number = null;
        try {
            while (rows.next()) {
                number = rows.getString("FNumber");
                resultString.append("isnull(SUM(CASE bi.FNumber WHEN '");
                resultString.append(number);
                resultString.append("' THEN bddh.FVALUE END),0) AS ");
                resultString.append(number + ", ");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultString.toString();
    }

    private String makeParams(Context ctx, String hrOrgUnitId) throws BOSException {
        StringBuffer resultString = new StringBuffer();
        IRowSet rows = this.getBeneItemRows(ctx, hrOrgUnitId);
        int size = rows.size() + 2;
        for (int i = 0; i < size; ++i) {
            resultString.append("?, ");
        }
        return resultString.toString();
    }

    private IRowSet getBeneItemRows(Context ctx, String hrOrgUnitId) throws BOSException {
        String sql = "select FNumber from t_hr_benefititem where fhrorgunitid = ? order by fnumber";
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{hrOrgUnitId});
    }

    private String makeInsertBeneReportSql(Context ctx, String hrOrgUnitId) throws BOSException {
        StringBuffer resultString = new StringBuffer();
        IRowSet rows = this.getBeneItemRows(ctx, hrOrgUnitId);
        String number = null;
        try {
            while (rows.next()) {
                number = rows.getString("FNumber");
                resultString.append("F");
                resultString.append(number);
                resultString.append(", ");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultString.toString();
    }

    private CmpPeriodInfo getCmpPeriodInfoForConstant(Context ctx, String currCmpPeriodId, int constant) throws BOSException {
        ICmpPeriod iCmpPeriod = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ctx == null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
            iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo((Context)ctx).getId().toString()));
            iCmpPeriod = CmpPeriodFactory.getLocalInstance((Context)ctx);
        }
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl == null || cmpPeriodColl.size() <= 1) {
            return null;
        }
        String temp = null;
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            temp = cmpPeriodColl.get(i).getId().toString();
            if (!temp.equals(currCmpPeriodId)) continue;
            if (constant > 0) {
                if (size > constant + i) {
                    return cmpPeriodColl.get(constant + i);
                }
                return null;
            }
            if (constant < 0) {
                if (i >= -constant) {
                    return cmpPeriodColl.get(i + constant);
                }
                return null;
            }
            return cmpPeriodColl.get(i);
        }
        return null;
    }

    public void checkCurPeriodHis(Context ctx, String cmpPeriodId, String curHrId, String typeId) throws BOSException, EASBizException {
        IBenefitData ibd = BenefitDataFactory.getLocalInstance(ctx);
        if (!ibd.exists("select id where accountDetail.accountType.id = '" + typeId + "' and hrOrgUnit.id = '" + curHrId + "' and cmpPeriod.id = '" + cmpPeriodId + "'")) {
            throw new BenefitException(BenefitException.BADJUST_ERR_NOT_AUDIT);
        }
        if (ibd.exists("select id where accountDetail.accountType.id = '" + typeId + "' and hrOrgUnit.id = '" + curHrId + "' and cmpPeriod.id = '" + cmpPeriodId + "' and isCheck = 0")) {
            throw new BenefitException(BenefitException.BENEFITADJUST_NOT_AUDIT);
        }
    }

    private void doInsertDataTmpJava(Context ctx, String tmpTableName, String curCmpPeriodId, String accountTypeId, String curHROId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT 1 isAdjust, BD.FCMPPERIODHISID, '");
        sb.append(curCmpPeriodId);
        sb.append("', '");
        sb.append(accountTypeId);
        sb.append("', I.FBenefitID, AD.FID, '");
        sb.append(curHROId);
        sb.append("', BD.FOPERATETYPE,  \n");
        sb.append("SUM(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Com_Sum");
        sb.append("' THEN BDD.FVALUE ELSE 0 END) AS COM_ADD, \n");
        sb.append("SUM(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Emp_Sum");
        sb.append("' THEN BDD.FVALUE ELSE 0 END) AS EMP_ADD, \n");
        sb.append("SUM(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Com_insu");
        sb.append("' THEN BDD.FVALUE ELSE 0 END) AS COM_BALA, \n");
        sb.append("SUM(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Emp_insu");
        sb.append("' THEN BDD.FVALUE ELSE 0 END) AS EMP_BALA, \n");
        sb.append("SUM(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Balance");
        sb.append("' THEN BDD.FVALUE ELSE 0 END) AS BALANCE, \n");
        sb.append("MAX(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Balance");
        sb.append("' THEN AII.FID ELSE '' END) AS FBALANCE_INPUT_ID, \n");
        sb.append("MAX(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Com_Bala");
        sb.append("' THEN AII.FID ELSE '' END) AS FCOM_BALA_INPUT_ID, \n");
        sb.append("MAX(CASE I.FBenefitItemNumber WHEN '");
        sb.append("Emp_Bala");
        sb.append("' THEN AII.FID ELSE '' END) AS FEMP_BALA_INPUT_ID \n");
        sb.append("FROM t_Hr_Benefitadjustdatadetail BDD \n");
        sb.append("INNER JOIN T_HR_BENEFITADJUSTDATA BD ON BDD.FBENEFITADJUSTDATAID = BD.FID \n");
        sb.append("INNER JOIN T_HR_ACCOUNTDETAIL AD ON BD.FACCOUNTDETAILID = AD.FID \n");
        sb.append("INNER JOIN T_HR_ACCOUNTITEMINPUT AII ON AII.FID = BDD.FACCOUNTITEMINPUT \n");
        sb.append("INNER JOIN T_HR_ITEM I ON AII.FITEMID = I.FID \n");
        sb.append("INNER JOIN T_HR_ACCOUNT A ON AD.FACCOUNTID = A.FID \n");
        sb.append("INNER JOIN " + tmpTableName + " tt on A.fid = tt.FAccountId \n");
        sb.append("WHERE ((BD.FHRORGUNITID = '");
        sb.append(curHROId);
        sb.append("' AND BD.FISCHECK = 1 AND AD.FACCOUNTTYPEID = '");
        sb.append(accountTypeId);
        sb.append("') \n");
        sb.append("AND BD.FCMPPERIODID = '");
        sb.append(curCmpPeriodId);
        sb.append("') \n");
        sb.append("GROUP BY AD.FID, I.FBenefitID, BD.FCMPPERIODHISID,BD.FOPERATETYPE \n");
        ArrayList<Object[]> mainList = new ArrayList<Object[]>();
        BenefitAdjustDataTmpInfo beneAdjTmpInfo = null;
        Object[] objects = null;
        IRowSet rows = null;
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        IRowSet balaRows = null;
        try {
            while (rows.next()) {
                beneAdjTmpInfo = new BenefitAdjustDataTmpInfo();
                beneAdjTmpInfo.isAdjust = rows.getInt("isAdjust");
                beneAdjTmpInfo.cmpPeriodID = rows.getString("fcmpperiodhisid");
                beneAdjTmpInfo.curCmpPeriodID = curCmpPeriodId;
                beneAdjTmpInfo.accountTypeID = accountTypeId;
                beneAdjTmpInfo.benefitID = rows.getString("fbenefitid");
                beneAdjTmpInfo.accountDetailID = rows.getString("FID");
                beneAdjTmpInfo.operateType = rows.getInt("FoperateType");
                beneAdjTmpInfo.hrOrgUnitID = curHROId;
                beneAdjTmpInfo.COM_ADD = rows.getBigDecimal("COM_ADD");
                beneAdjTmpInfo.EMP_ADD = rows.getBigDecimal("EMP_ADD");
                beneAdjTmpInfo.COM_INSU = rows.getBigDecimal("COM_BALA");
                beneAdjTmpInfo.EMP_INSU = rows.getBigDecimal("EMP_BALA");
                beneAdjTmpInfo.BALANCE = beneAdjTmpInfo.COM_ADD.add(beneAdjTmpInfo.EMP_ADD);
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Balance");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.BALANCE_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Com_Bala");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.COM_BALA_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Emp_Bala");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.EMP_BALA_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Com_insu");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.COM_INSU_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Emp_insu");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.EMP_INSU_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Com_Sum");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.COM_ADD_INPUT_ID = balaRows.getString("fid");
                }
                sb = new StringBuffer();
                sb.append("\tselect at.fid  FID \n");
                sb.append("\tfrom t_hr_accountiteminput at   \n");
                sb.append("\tinner join t_hr_item i on at.fitemid = i.fid   \n");
                sb.append("\twhere i.fbenefititemnumber = '");
                sb.append("Emp_Sum");
                sb.append("' \tand i.fbenefitid = ? \n");
                sb.append("  \tAND at.faccountdetailid = ?\n");
                sb.append("  \tand i.FHROrgUnitID = ? ");
                balaRows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, curHROId});
                while (balaRows.next()) {
                    beneAdjTmpInfo.EMP_ADD_INPUT_ID = balaRows.getString("fid");
                }
                this.setHisID(ctx, beneAdjTmpInfo);
                objects = new Object[]{beneAdjTmpInfo.isAdjust, beneAdjTmpInfo.cmpPeriodID, beneAdjTmpInfo.curCmpPeriodID, beneAdjTmpInfo.accountTypeID, beneAdjTmpInfo.benefitID, beneAdjTmpInfo.accountDetailID, beneAdjTmpInfo.hrOrgUnitID, beneAdjTmpInfo.operateType, beneAdjTmpInfo.COM_ADD, beneAdjTmpInfo.EMP_ADD, beneAdjTmpInfo.COM_INSU, beneAdjTmpInfo.EMP_INSU, beneAdjTmpInfo.BALANCE, beneAdjTmpInfo.BALANCE_INPUT_ID, beneAdjTmpInfo.COM_BALA_INPUT_ID, beneAdjTmpInfo.EMP_BALA_INPUT_ID, beneAdjTmpInfo.COM_INSU_INPUT_ID, beneAdjTmpInfo.EMP_INSU_INPUT_ID, beneAdjTmpInfo.COM_ADD_INPUT_ID, beneAdjTmpInfo.EMP_ADD_INPUT_ID, beneAdjTmpInfo.BALANCE_HIS_ID, beneAdjTmpInfo.COM_BALA_HIS_ID, beneAdjTmpInfo.EMP_BALA_HIS_ID, beneAdjTmpInfo.COM_INSU_HIS_ID, beneAdjTmpInfo.EMP_INSU_HIS_ID, beneAdjTmpInfo.COM_ADD_HIS_ID, beneAdjTmpInfo.EMP_ADD_HIS_ID};
                mainList.add(objects);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb = new StringBuffer();
        sb.append("INSERT INTO T_HR_BENEFITADJUSTDATATMP \n");
        sb.append("      (FIsAdjust, FCmpPeriodID, FCurCmpPeriodID, FAccountTypeID, FBenefitID, FAccountDetailID, FHROrgUnitID, FOperateType,  \n");
        sb.append("      FCOM_Add, FEMP_Add, FCOM_INSU, FEMP_INSU, FBALANCE,  \n");
        sb.append("      FBALANCE_INPUT_ID, FCOM_BALA_INPUT_ID, FEMP_BALA_INPUT_ID, \n");
        sb.append("      FCOM_INSU_INPUT_ID, FEMP_INSU_INPUT_ID,FCOM_ADD_INPUT_ID, FEMP_ADD_INPUT_ID,");
        sb.append(" FBALANCE_HIS_ID, FCOM_BALA_HIS_ID, FEMP_BALA_HIS_ID, FCOM_INSU_HIS_ID,");
        sb.append(" FEMP_INSU_HIS_ID, FCOM_ADD_HIS_ID, FEMP_ADD_HIS_ID) VALUES(\n");
        sb.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        HrExDbUtil.executeBatch(ctx, sb.toString(), mainList);
    }

    private void setHisID(Context ctx, BenefitAdjustDataTmpInfo beneAdjTmpInfo) throws BOSException, SQLException {
        IRowSet rows = null;
        StringBuffer sb = null;
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.BALANCE_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.BALANCE_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.COM_BALA_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.COM_BALA_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.EMP_BALA_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.EMP_BALA_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.COM_INSU_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.COM_INSU_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.EMP_INSU_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.EMP_INSU_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.COM_ADD_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.COM_ADD_HIS_ID = rows.getString("fid");
        }
        sb = new StringBuffer();
        sb.append("select bdd.fid from t_hr_benefitdatadetailhis bdd ");
        sb.append("inner join t_hr_benefitdatahis bd on bdd.FBenefitDataHisID = bd.FID ");
        sb.append("where BDD.FAccountItemInputID = ? and bd.FCmpPeriodID = ?");
        rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{beneAdjTmpInfo.EMP_ADD_INPUT_ID, beneAdjTmpInfo.curCmpPeriodID});
        while (rows.next()) {
            beneAdjTmpInfo.EMP_ADD_HIS_ID = rows.getString("fid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAccountSetTMP(Context ctx, String accountTypeId, String cmpPeriodId, String tmptableName) throws BOSException {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_HR_ACCOUNTSETTLETMP \n");
        sb.append("WHERE FHRORGUNITID = ? AND FAccountTypeID = ? \n");
        sb.append("and FAccountID in (");
        sb.append("select fid from t_hr_account a \n");
        sb.append("inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("and a.fhrorgunitid =? )");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
        sb = new StringBuffer();
        sb.append("INSERT INTO T_HR_ACCOUNTSETTLETMP \n");
        sb.append("      (FAccountID, FBenefitID, FAccountTypeID, FHROrgUnitID, FAccountDetailID,  \n");
        sb.append("      FCOM_Add, FEMP_Add, FCOM_INSU, FEMP_INSU, FCOM_BALA, FEMP_BALA, FCOM_ACCR, FEMP_ACCR, FBALANCE,  \n");
        sb.append("      FCOM_BALA_ID, FEMP_BALA_ID, FCOM_ACC_ID, FEMP_ACC_ID, FBALANCE_ID,  \n");
        sb.append("      FCOM_BALA_INPUT_ID, FEMP_BALA_INPUT_ID, FCOM_ACC_INPUT_ID, FEMP_ACC_INPUT_ID, FBALANCE_INPUT_ID) \n");
        sb.append("SELECT A.FAccountID, B.FBenefitID, '");
        sb.append(accountTypeId);
        sb.append("', '");
        sb.append(hrOrgUnitId);
        sb.append("', B.FAccountDetailID \n");
        sb.append(",FCOM_ADD");
        sb.append(",FEMP_ADD");
        sb.append(",FCOM_INSU");
        sb.append(",FEMP_INSU");
        sb.append(",FCOM_BALA");
        sb.append(",FEMP_BALA");
        sb.append(",FCOM_ACCR");
        sb.append(",FEMP_ACCR");
        sb.append(",FBALANCE");
        sb.append(",FCOM_BALA_ID");
        sb.append(",FEMP_BALA_ID");
        sb.append(",FCOM_ACC_ID");
        sb.append(",FEMP_ACC_ID");
        sb.append(",FBALANCE_ID");
        sb.append(",FCOM_BALA_INPUT_ID");
        sb.append(",FEMP_BALA_INPUT_ID");
        sb.append(",FCOM_ACC_INPUT_ID");
        sb.append(",FEMP_ACC_INPUT_ID");
        sb.append(",FBALANCE_INPUT_ID");
        sb.append(" from (\n ");
        sb.append(" SELECT /*+ ORDERED USE_HASH(AD A TMP BD )*/ ");
        sb.append(" AD.FAccountID, AD.FID ");
        sb.append(" FROM  t_hr_accountdetail AD ");
        sb.append(" INNER JOIN t_hr_account A ON AD.faccountid = A.fid ");
        sb.append(" INNER JOIN ").append(tmptableName).append(" TMP ON A.fpersonid = tmp.FPersonID");
        sb.append(" WHERE  A.fhrorgunitid = ? and AD.faccounttypeid = ? ");
        sb.append(") A ,");
        sb.append("(select  BD.FAccountDetailID, i.FBenefitID,");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Sum");
        sb.append("' THEN BDD.FVALUE  END),0) AS FCOM_ADD, \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Sum");
        sb.append("' THEN BDD.FVALUE  END),0) AS FEMP_ADD, \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_insu");
        sb.append("' THEN BDD.FVALUE  END),0) AS FCOM_INSU, \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_insu");
        sb.append("' THEN BDD.FVALUE  END),0) AS FEMP_INSU,  \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Bala");
        sb.append("' THEN BDD.FVALUE  END),0) AS FCOM_BALA,  \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Bala");
        sb.append("' THEN BDD.FVALUE  END),0) AS FEMP_BALA,  \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Accr");
        sb.append("' THEN BDD.FVALUE  END),0) AS FCOM_ACCR,  \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Accr");
        sb.append("' THEN BDD.FVALUE  END),0) AS FEMP_ACCR,  \n");
        sb.append("ISNULL(SUM(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Balance");
        sb.append("' THEN BDD.FVALUE END),0) AS FBALANCE,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Bala");
        sb.append("' THEN BDD.FID  END),'') AS FCOM_BALA_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Bala");
        sb.append("' THEN BDD.FID  END),'') AS FEMP_BALA_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Accr");
        sb.append("' THEN BDD.FID END),'') AS FCOM_ACC_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Accr");
        sb.append("' THEN BDD.FID  END),'') AS FEMP_ACC_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Balance");
        sb.append("' THEN BDD.FID END),'') AS FBALANCE_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Bala");
        sb.append("' THEN AII.FID  END),'') AS FCOM_BALA_INPUT_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Bala");
        sb.append("' THEN AII.FID END),'') AS FEMP_BALA_INPUT_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Com_Accr");
        sb.append("' THEN AII.FID  END),'') AS FCOM_ACC_INPUT_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Emp_Accr");
        sb.append("' THEN AII.FID END),'') AS FEMP_ACC_INPUT_ID,  \n");
        sb.append("isnull(MAX(CASE I.FBenefitItemNumber WHEN  '");
        sb.append("Balance");
        sb.append("' THEN AII.FID END),'') AS FBALANCE_INPUT_ID  \n");
        sb.append(" FROM t_hr_benefitdata BD \n");
        sb.append("INNER JOIN T_HR_BENEFITDATADETAIL BDD  ON BDD.fbenefitdataid = BD.fid  \n");
        sb.append("INNER JOIN t_hr_accountiteminput AII ON AII.fid =  BDD.faccountiteminputid \n");
        sb.append("INNER JOIN t_hr_item I ON AII.fitemid = I.fid \n");
        sb.append(" WHERE BD.fhrorgunitid = ? \n");
        sb.append(" AND BD.fcmpperiodid = ? \n");
        sb.append(" GROUP BY BD.FAccountDetailID, i.FBenefitID )B \n");
        sb.append(" where  b.FAccountDetailID = A.fid ");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId, cmpPeriodId});
        sb = new StringBuffer();
        sb.append("UPDATE t_hr_accountsettletmp \n");
        sb.append("SET FCOM_BALA = ISNULL(FCOM_BALA, 0) + ISNULL(FCOM_INSU, 0) \n");
        sb.append(", FEMP_BALA = ISNULL(FEMP_BALA, 0) + ISNULL(FEMP_INSU, 0) \n");
        sb.append(", FBALANCE = ISNULL(FBALANCE, 0) + ISNULL(FCOM_ADD, 0) + ISNULL(FEMP_ADD, 0) + ISNULL(FCOM_ACCR, 0) + ISNULL(FEMP_ACCR, 0) \n");
        sb.append("WHERE FHROrgUnitID = ? AND FAccountTypeID = ?\n");
        sb.append("AND FAccountID in (");
        sb.append("select fid from t_hr_account a \n");
        sb.append("inner join " + tmptableName + " tmp on a.fpersonid = tmp.FPersonID \n");
        sb.append("where a.fhrorgunitid =? )");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
        sb = new StringBuffer();
        sb.append("UPDATE t_hr_accountsettletmp \n");
        sb.append("SET FBALANCE = FBALANCE + ISNULL((SELECT top 1 T.FShiftSum \n");
        sb.append("FROM t_hr_accountshiftsum T INNER JOIN t_hr_accountsettletmp T2 \n");
        sb.append("ON T.FAccountDetailID = T2.FAccountDetailId AND T.FBENEFITID = T2.FBENEFITID \n");
        sb.append("WHERE T2.FAccountDetailID = t_hr_accountsettletmp.FAccountDetailId \n");
        sb.append("AND T2.FBENEFITID = t_hr_accountsettletmp.FBENEFITID \n");
        sb.append("AND T.FCmpPeriodID = ?), 0) \n");
        sb.append("WHERE FHROrgUnitID = ? \n");
        sb.append("AND FAccountTypeID = ? \n");
        sb.append("AND FAccountID in ( \n");
        sb.append("SELECT ad.faccountID FROM t_hr_accountshiftsum  SS \n");
        sb.append("INNER JOIN T_HR_AccountDetail AD ON SS.FAccountDetailId = AD.FID \n");
        sb.append("WHERE ss.FCmpPeriodID = ? AND AD.FAccountTypeID = ?) \n");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{cmpPeriodId, hrOrgUnitId, accountTypeId, cmpPeriodId, accountTypeId});
        int dbType = 0;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (2 == dbType || 8 == dbType) {
            sb = new StringBuffer();
            sb.append("/*dialect*/MERGE INTO T_HR_BenefitDataDetail \n");
            sb.append(" USING (");
            sb.append("\tSELECT T.FCOM_BALA,T.FCOM_BALA_ID ");
            sb.append("\tFROM T_HR_AccountSettleTmp T,  T_HR_BenefitDataDetail A");
            sb.append("\tWHERE T.FCOM_BALA_ID = FID ");
            sb.append("\tAND FHROrgUnitID = ?  ");
            sb.append("\tAND FAccountTypeID = ? ");
            sb.append("\tAND A.FID = FCOM_BALA_ID ");
            sb.append("\tAND  EXISTS(");
            sb.append("\tSELECT bd.fid FROM t_hr_benefitdata BD ");
            sb.append("\tINNER JOIN t_hr_accountdetail AD ON bd.faccountdetailid = ad.fid ");
            sb.append("\tINNER JOIN t_hr_account A ON ad.faccountid = a.fid ");
            sb.append("\tINNER JOIN ").append(tmptableName).append(" TMP ON a.FPersonID = tmp.FPersonID  ");
            sb.append("\tWHERE a.fhrorgunitid = ?  ");
            sb.append(" AND A.FBenefitDataID = bd.fid )");
            sb.append(" )B ");
            sb.append(" ON (B.FCOM_BALA_ID = FID)");
            sb.append("WHEN MATCHED THEN UPDATE SET FValue = B.FCOM_BALA ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
            sb = new StringBuffer();
            sb.append("/*dialect*/MERGE INTO T_HR_BenefitDataDetail \n");
            sb.append(" USING (");
            sb.append("\tSELECT T.FEMP_BALA,T.FEMP_BALA_ID ");
            sb.append("\tFROM T_HR_AccountSettleTmp T,  T_HR_BenefitDataDetail A");
            sb.append("\tWHERE T.FEMP_BALA_ID = FID ");
            sb.append("\tAND FHROrgUnitID = ?  ");
            sb.append("\tAND FAccountTypeID = ? ");
            sb.append("\tAND A.FID = FEMP_BALA_ID ");
            sb.append("\tAND  EXISTS(");
            sb.append("\tSELECT bd.fid FROM t_hr_benefitdata BD ");
            sb.append("\tINNER JOIN t_hr_accountdetail AD ON bd.faccountdetailid = ad.fid ");
            sb.append("\tINNER JOIN t_hr_account A ON ad.faccountid = a.fid ");
            sb.append("\tINNER JOIN ").append(tmptableName).append(" TMP ON a.FPersonID = tmp.FPersonID  ");
            sb.append("\tWHERE a.fhrorgunitid = ?  ");
            sb.append(" AND A.FBenefitDataID = bd.fid )");
            sb.append(")B");
            sb.append(" ON (B.FEMP_BALA_ID = FID)");
            sb.append("WHEN MATCHED THEN UPDATE SET FValue = B.FEMP_BALA ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
            sb = new StringBuffer();
            sb.append("/*dialect*/MERGE INTO T_HR_BenefitDataDetail \n");
            sb.append(" USING (");
            sb.append("\tSELECT T.FBALANCE,T.FBALANCE_ID ");
            sb.append("\tFROM T_HR_AccountSettleTmp T,  T_HR_BenefitDataDetail A");
            sb.append("\tWHERE T.FBALANCE_ID = FID ");
            sb.append("\tAND FHROrgUnitID = ?  ");
            sb.append("\tAND FAccountTypeID = ? ");
            sb.append("\tAND A.FID = FBALANCE_ID ");
            sb.append("\tAND  EXISTS(");
            sb.append("\tSELECT bd.fid FROM t_hr_benefitdata BD ");
            sb.append("\tINNER JOIN t_hr_accountdetail AD ON bd.faccountdetailid = ad.fid ");
            sb.append("\tINNER JOIN t_hr_account A ON ad.faccountid = a.fid ");
            sb.append("\tINNER JOIN ").append(tmptableName).append(" TMP ON a.FPersonID = tmp.FPersonID  ");
            sb.append("\tWHERE a.fhrorgunitid = ?  ");
            sb.append(" AND A.FBenefitDataID = bd.fid )");
            sb.append(")B");
            sb.append(" ON (B.FBALANCE_ID = FID)");
            sb.append("WHEN MATCHED THEN UPDATE SET FValue = B.FBALANCE ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
        } else {
            sb = new StringBuffer();
            sb.append("Update T_HR_BenefitDataDetail \n");
            sb.append("SET FValue = (SELECT T.FCOM_BALA \n");
            sb.append("\tFROM T_HR_AccountSettleTmp T \n");
            sb.append("\tWHERE T.FCOM_BALA_ID = FID )\n");
            sb.append("WHERE exists (SELECT FCOM_BALA_ID FROM T_HR_AccountSettleTmp \n");
            sb.append("\t\tWHERE FHROrgUnitID = ? AND FAccountTypeID = ? AND T_HR_BenefitDataDetail.FID = FCOM_BALA_ID)\n");
            sb.append("AND exists (");
            sb.append("select bd.fid from t_hr_benefitdata bd \n");
            sb.append("inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
            sb.append("Inner join t_hr_account a on ad.faccountid = a.fid \n");
            sb.append("Inner join " + tmptableName + " tmp on a.FPersonID = tmp.FPersonID \n");
            sb.append("where a.fhrorgunitid = ? and T_HR_BenefitDataDetail.FBenefitDataID=bd.fid) ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
            sb = new StringBuffer();
            sb.append("Update T_HR_BenefitDataDetail \n");
            sb.append("SET FValue = (SELECT T.FEMP_BALA \n");
            sb.append("\tFROM T_HR_AccountSettleTmp T \n");
            sb.append("\tWHERE T.FEMP_BALA_ID = FID \n");
            sb.append(")");
            sb.append("WHERE exists (SELECT FEMP_BALA_ID FROM T_HR_AccountSettleTmp \n");
            sb.append("WHERE FHROrgUnitID = ? AND FAccountTypeID = ? AND T_HR_BenefitDataDetail.FID = FEMP_BALA_ID) ");
            sb.append("AND exists (");
            sb.append("select bd.fid from t_hr_benefitdata bd \n");
            sb.append("inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
            sb.append("Inner join t_hr_account a on ad.faccountid = a.fid \n");
            sb.append("Inner join " + tmptableName + " tmp on a.FPersonID = tmp.FPersonID \n");
            sb.append("where a.fhrorgunitid = ? and T_HR_BenefitDataDetail.FBenefitDataID = bd.fid) ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
            sb = new StringBuffer();
            sb.append("Update T_HR_BenefitDataDetail \n");
            sb.append("SET FValue = (SELECT T.FBALANCE \n");
            sb.append("\tFROM T_HR_AccountSettleTmp T \n");
            sb.append("\tWHERE T.FBALANCE_ID = FID \n");
            sb.append(")");
            sb.append("WHERE exists (SELECT FBALANCE_ID FROM T_HR_AccountSettleTmp \n");
            sb.append("WHERE FHROrgUnitID = ? AND FAccountTypeID = ? AND T_HR_BenefitDataDetail.FID = FBALANCE_ID) ");
            sb.append("AND exists (");
            sb.append("select bd.fid from t_hr_benefitdata bd \n");
            sb.append("inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
            sb.append("Inner join t_hr_account a on ad.faccountid = a.fid \n");
            sb.append("Inner join " + tmptableName + " tmp on a.FPersonID = tmp.FPersonID \n");
            sb.append("where a.fhrorgunitid = ? and T_HR_BenefitDataDetail.FBenefitDataID = bd.fid) ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, accountTypeId, hrOrgUnitId});
        }
    }

    public void _initBenefit(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
            throw new BOSException("current controlUnit is null !");
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        this.initAccountType(ctx, hrOrgUnitId, cuId);
        this.initBenefitItem(ctx, hrOrgUnitId, cuId);
        this.initBenefit(ctx, hrOrgUnitId, cuId);
        this.initItem(ctx, hrOrgUnitId);
        this.initUpdateInfo(ctx);
    }

    private void initUpdateInfo(Context ctx) throws BOSException {
        String sql = "select * from T_HR_BenefitUtil where FType ='DATAUPDATE' and FValue ='true'";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (row.size() > 0) {
            return;
        }
        String insSql = "insert into T_HR_BenefitUtil ( FType, FHROrgUnitID,FValue ) values ('DATAUPDATE','00000000-0000-0000-0000-000000000000CCE7AED4','true')";
        DbUtil.execute((Context)ctx, (String)insSql);
    }

    protected String _getInitPeriodId(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String periodId = null;
        String selectSql = "select FValue from T_HR_BenefitUtil WHERE FType = ? and FHROrgUnitID = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{"INITPERIOD", hrOrgUnitId});
        try {
            if (rows.next()) {
                periodId = rows.getString("FValue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodId;
    }

    protected CmpPeriodInfo _getCurMaxPeriod(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID ");
        sb.append("FROM T_HR_CMPPeriod ");
        sb.append("WHERE FEndDate in ( ");
        sb.append("\tSELECT MAX(FEndDate) ");
        sb.append("\tFROM T_HR_CMPPeriod ");
        sb.append("\tWHERE FID IN (select FValue from T_HR_BenefitUtil WHERE FType = ? and FHROrgUnitID = ?) ");
        sb.append("\t) ");
        String periodId = null;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"CURPERIOD", hrOrgUnitId});
        try {
            if (rows.next()) {
                periodId = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (periodId != null) {
            return CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
        }
        return null;
    }

    protected CmpPeriodInfo _getCurMaxPeriodById(Context ctx, String hrId) throws BOSException, EASBizException {
        if (hrId == null) {
            if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
                throw new BOSException("current hrOrgUnit is null !");
            }
            hrId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID ");
        sb.append("FROM T_HR_CMPPeriod ");
        sb.append("WHERE FEndDate in ( ");
        sb.append("\tSELECT MAX(FEndDate) ");
        sb.append("\tFROM T_HR_CMPPeriod ");
        sb.append("\tWHERE FID IN (select FValue from T_HR_BenefitUtil WHERE FType = ? and FHROrgUnitID = ?) ");
        sb.append("\t) ");
        String periodId = null;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"CURPERIOD", hrId});
        try {
            if (rows.next()) {
                periodId = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (periodId != null) {
            return CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
        }
        return null;
    }

    protected CmpPeriodInfo _getInitPeriod(Context ctx) throws BOSException, EASBizException {
        String periodId = this._getInitPeriodId(ctx);
        if (periodId != null) {
            return CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
        }
        return null;
    }

    protected boolean _hasInitPeriod(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BenefitImportDataException(BenefitImportDataException.HRORG_NULL);
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String selectSql = "select FValue from T_HR_BenefitUtil WHERE FType = ? and FHROrgUnitID = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{"INITPERIOD", hrOrgUnitId});
        return rows.size() > 0;
    }

    protected boolean _initCurrPeriod(Context ctx, String periodId) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer initSql = new StringBuffer();
        initSql.append(" insert into T_HR_BenefitUtil \n");
        initSql.append(" ( FType,FValue,FHrOrgUnitID,FAccountTypeID ) \n");
        initSql.append(" select '").append("INITPERIOD").append("' as FType, \n");
        initSql.append("'").append(periodId).append("' as FValue,\n");
        initSql.append("'").append(hrOrgUnitId).append("' as FHrOrgUnitID,\n");
        initSql.append(" fid as FAccountTypeID from T_HR_AccountType \n");
        initSql.append(" where FHROrgUnitID ='").append(hrOrgUnitId).append("'");
        DbUtil.execute((Context)ctx, (String)initSql.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getCurCalAccountCount(Context ctx, List personList, String accountTypeId) throws BOSException, EASBizException {
        if (personList == null || personList.size() == 0) {
            return 0;
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        int totalSelect = personList.size();
        StringBuffer sb = new StringBuffer();
        sb.append("select count(bd.fid) from t_hr_benefitdata bd \n");
        sb.append("inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
        sb.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        sb.append("where a.fhrorgunitid ='" + hrOrgUnitId + "' \n");
        sb.append("and ad.faccounttypeid ='" + accountTypeId + "' \n");
        sb.append("and bd.fischeck =1 \n");
        sb.append("and a.fpersonid in");
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (totalSelect <= 100) {
            sb.append(BenefitUtils.getStrFromList(personList));
        } else {
            tempTableName = BenefitUtils.createTempTableName(ctx, "FPersnoID", "accountInfoTempTable", personList);
            sb.append(" ( select FPersnoID from ").append(tempTableName).append(" )");
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int hasCalCount = 0;
        try {
            if (row.next()) {
                hasCalCount = row.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (tempTableName != null) {
                pool.releaseTable(tempTableName);
            }
        }
        return totalSelect - hasCalCount;
    }

    protected void _deleteBenefitAdjustData(Context ctx, String adjDataId) throws BOSException, EASBizException {
        String delDataDetailSql = "DELETE FROM T_HR_BenefitAdjustDataDetail WHERE FBenefitAdjustDataID = ? ";
        String delDataSql = "DELETE FROM T_HR_BenefitAdjustData WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)delDataDetailSql, (Object[])new Object[]{adjDataId});
        DbUtil.execute((Context)ctx, (String)delDataSql, (Object[])new Object[]{adjDataId});
    }

    protected void _deleteBenefitAdjustData(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        HashSet set = new HashSet();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            set.add(idList.get(i));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("benefitAdjustData.id", set));
        IBenefitAdjustDataDetail ibadd = BenefitAdjustDataDetailFactory.getLocalInstance(ctx);
        ibadd.delete(filter);
        IBenefitAdjustData ibad = BenefitAdjustDataFactory.getLocalInstance(ctx);
        filter.getFilterItems().get(0).setPropertyName("id");
        ibad.delete(filter);
    }

    protected void _saveBenefitData(Context ctx, HashMap map) throws BOSException, EASBizException {
        String accountID = null;
        HashMap dataMap = null;
        Iterator iteData = null;
        String key = null;
        String beneNum = null;
        String beneItemNum = null;
        String[] tmp = null;
        BigDecimal value = null;
        ArrayList<Object[]> mainList = new ArrayList<Object[]>();
        Object[] objects = null;
        Iterator ite = map.entrySet().iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            accountID = (String)entry.getKey();
            dataMap = (HashMap)entry.getValue();
            iteData = dataMap.entrySet().iterator();
            Map.Entry entry1 = null;
            while (iteData.hasNext()) {
                entry1 = iteData.next();
                key = (String)entry.getKey();
                tmp = key.split("#");
                beneNum = tmp[0];
                beneItemNum = tmp[1];
                String bddID = this.getBenefitDataDetailID(ctx, accountID, beneNum, beneItemNum);
                value = (BigDecimal)entry.getValue();
                if (StringUtils.isEmpty((String)bddID)) continue;
                objects = new Object[]{value, bddID};
                mainList.add(objects);
            }
        }
        String sql = "update t_hr_benefitdatadetail set fvalue = ? where fid = ?";
        HrExDbUtil.executeBatch(ctx, sql, mainList);
    }

    private String getBenefitDataDetailID(Context ctx, String accountID, String beneNum, String beneItemNum) throws BOSException {
        String id = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select bdd.fid as FID from t_hr_benefitdatadetail bdd \n");
        sb.append("inner join t_hr_benefitdata bd on bdd.fbenefitdataid = bd.fid \n");
        sb.append("inner join t_hr_accountdetail ad on bd.faccountdetailid = ad.fid \n");
        sb.append("inner join t_hr_accountiteminput aii on bdd.faccountiteminputid = aii.fid \n");
        sb.append("inner join t_hr_item i on aii.fitemid = i.fid \n");
        sb.append("where ad.faccountid = '");
        sb.append(accountID).append("' \n");
        sb.append("and i.fbenefitNumber ='");
        sb.append(beneNum).append("' \n");
        sb.append("and i.fbenefitItemNumber ='");
        sb.append(beneItemNum).append("' \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rows.next()) {
                id = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return id;
    }

    protected void _doCheckBenefitData(Context ctx, ArrayList benefitDataIds, boolean isCheck) throws BOSException, EASBizException {
        if (benefitDataIds.size() > 0) {
            StringBuffer uptSql = new StringBuffer();
            uptSql.append("Update T_HR_BenefitData Set FIsCheck = ? Where FID IN (");
            int size = benefitDataIds.size();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    uptSql.append("'");
                    uptSql.append(benefitDataIds.get(i));
                    uptSql.append("'");
                    continue;
                }
                uptSql.append(", '");
                uptSql.append(benefitDataIds.get(i));
                uptSql.append("'");
            }
            uptSql.append(")");
            DbUtil.execute((Context)ctx, (String)uptSql.toString(), (Object[])new Object[]{isCheck});
        }
    }

    protected void _doCheckBenefitAdjustData(Context ctx, boolean isCheck, List adjustDataIDList) throws BOSException, EASBizException {
        String resource = "";
        resource = isCheck ? EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITADJUSTAUDIT") : EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ANTIAUDIT");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitAdjustDataInfo().getBOSType(), null, (String)resource, (String)"BenefitAdjust_audit");
        StringBuffer uptSql = new StringBuffer();
        uptSql.append(" Update T_HR_BenefitAdjustData Set FIsCheck = ? Where FID IN ");
        uptSql.append(BenefitUtils.getStrFromList(adjustDataIDList));
        DbUtil.execute((Context)ctx, (String)uptSql.toString(), (Object[])new Object[]{isCheck});
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _checkCurPeriodHis(Context ctx, String cmpPeriodId, String curHrId, String typeId) throws BOSException, EASBizException {
        IBenefitData ibd = BenefitDataFactory.getLocalInstance(ctx);
        if (!ibd.exists("select id where accountDetail.accountType.id = '" + typeId + "' and hrOrgUnit.id = '" + curHrId + "' and cmpPeriod.id = '" + cmpPeriodId + "'")) {
            throw new BenefitException(BenefitException.BADJUST_ERR_NOT_AUDIT);
        }
        if (ibd.exists("select id where accountDetail.accountType.id = '" + typeId + "' and hrOrgUnit.id = '" + curHrId + "' and cmpPeriod.id = '" + cmpPeriodId + "' and isCheck = 0")) {
            throw new BenefitException(BenefitException.BENEFITADJUST_NOT_AUDIT);
        }
    }

    protected boolean _hasInitBase(Context ctx, String curHrId) throws BOSException, EASBizException {
        String selectSql = "select fid from t_hr_hrinit where fkey ='INIT_BENEFIT' and fhrorgunitid = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{curHrId});
        return rows.size() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _antiAuditBenfitData(Context ctx, String accountTypeId, String cmpPeriodId, List accIdList) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitDataInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFITANTIAUDIT"), (String)"AccountCheck_antiAudit");
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String tmptableName = null;
        TempTablePool pool = null;
        String accountDetailTempTableName = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmptableName = this.createTmpTable(ctx, pool, accIdList);
            try {
                accountDetailTempTableName = pool.createTempTable(" create TABLE aa (fid varchar(44) not null primary key) ");
                StringBuffer sql = new StringBuffer("insert ");
                sql.append(" INTO ");
                sql.append(accountDetailTempTableName);
                sql.append("(fid) ");
                sql.append(" select ad.fid fid from  T_HR_AccountDetail ad  \n");
                sql.append(" inner join " + tmptableName + " a on ad.faccountid = a.faccountid \n");
                sql.append(" where ad.faccounttypeid ='" + accountTypeId + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateStatus(ctx, tmptableName, accountTypeId, cmpPeriodId, hrOrgUnitId, accountDetailTempTableName, false);
            this.delHisTableData(ctx, accountDetailTempTableName, accountTypeId, cmpPeriodId);
            if (this.isExistAdjustDataSPUse_AccountID(ctx, tmptableName, accountTypeId, cmpPeriodId)) {
                this.rollbackHisData(ctx, accountTypeId, cmpPeriodId, hrOrgUnitId, this.getAccDetailId(ctx, tmptableName, accountTypeId));
            }
            this.rollbackReportTableData(ctx, tmptableName, accountTypeId, cmpPeriodId, hrOrgUnitId);
        }
        catch (Throwable throwable) {
            this.dropTmpTable(ctx, pool, tmptableName);
            this.dropTmpTable(ctx, pool, accountDetailTempTableName);
            throw throwable;
        }
        this.dropTmpTable(ctx, pool, tmptableName);
        this.dropTmpTable(ctx, pool, accountDetailTempTableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void rollbackReportTableData(Context ctx, String tmpTableName, String accountTypeId, String cmpPeriodId, String hrOrgUnitId) throws BOSException, EASBizException {
        List<String> cmpIdList = new ArrayList<String>();
        if (this.isExistAdjustDataSPUse_AccountID(ctx, tmpTableName, accountTypeId, cmpPeriodId)) {
            cmpIdList = this.getHisCmpPeriodList(ctx, accountTypeId, cmpPeriodId);
        }
        cmpIdList.add(cmpPeriodId);
        this.deleteReportTablData(ctx, tmpTableName, accountTypeId, cmpPeriodId, hrOrgUnitId, cmpIdList);
    }

    private void delHisTableData(Context ctx, String tmpTableName, String accountTypeId, String cmpPeriodId) throws BOSException {
        StringBuffer delDetail = new StringBuffer();
        delDetail.append("delete from t_hr_benefitdatadetailhis where fbenefitdatahisid in(");
        delDetail.append("select bdh.fid from t_hr_benefitdatahis bdh \n");
        delDetail.append("inner join " + tmpTableName + " tt on bdh.faccountdetailid = tt.fid \n");
        delDetail.append(" where bdh.fcmpperiodid ='").append(cmpPeriodId + "'");
        delDetail.append(")");
        StringBuffer delData = new StringBuffer();
        delData.append("delete from t_hr_benefitdatahis where faccountdetailid in(");
        delData.append(" select fid from ").append(tmpTableName);
        delData.append(") and fcmpperiodid ='").append(cmpPeriodId + "'");
        try {
            DbUtil.execute((Context)ctx, (String)delDetail.toString());
            DbUtil.execute((Context)ctx, (String)delData.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void rollbackHisData(Context ctx, String accountTypeId, String cmpPeriodId, String hrOrgUnitId, List accDetailId) throws BOSException {
        StringBuffer selSql = null;
        selSql = new StringBuffer();
        selSql.append("SELECT FISADJUST, FCOM_INSU, FEMP_INSU, FCOM_ADD, FEMP_ADD, FBALANCE, fcom_bala_his_id, ");
        selSql.append("femp_bala_his_id, fcom_insu_his_id, femp_insu_his_id, fcom_ADD_his_id, ");
        selSql.append("femp_ADD_his_id, fbalance_his_id, foperatetype, femp_bala_input_id, fcom_bala_input_id, fbalance_input_id ");
        selSql.append("FROM T_HR_BENEFITADJUSTDATATMP ");
        selSql.append("WHERE fcurcmpperiodid = ? and faccounttypeid = ? and fhrorgunitid = ? ");
        selSql.append(" and faccountdetailid in ");
        selSql.append(BenefitUtils.getStrFromList(accDetailId));
        selSql.append("order by FISADJUST desc");
        IRowSet selrows = null;
        selrows = DbUtil.executeQuery((Context)ctx, (String)selSql.toString(), (Object[])new Object[]{cmpPeriodId, accountTypeId, hrOrgUnitId});
        StringBuffer updateSql = null;
        try {
            while (selrows.next()) {
                if (selrows.getInt("FISADJUST") == 0) {
                    if (selrows.getInt("foperatetype") == -1) {
                        if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                            updateSql = new StringBuffer();
                            updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                            updateSql.append("fvalue = fvalue + ? where fid = ?");
                            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_INSU"), selrows.getString("fcom_bala_his_id")});
                        }
                        if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                            updateSql = new StringBuffer();
                            updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                            updateSql.append("fvalue = fvalue + ? where fid = ?");
                            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_bala_his_id")});
                        }
                        if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FBALANCE"), selrows.getString("fbalance_his_id")});
                        continue;
                    }
                    if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue - ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_INSU"), selrows.getString("fcom_bala_his_id")});
                    }
                    if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue - ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_bala_his_id")});
                    }
                    if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FBALANCE"), selrows.getString("fbalance_his_id")});
                    continue;
                }
                if (selrows.getInt("foperatetype") == -1) {
                    if (selrows.getString("fcom_insu_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getBigDecimal("FCOM_INSU"), selrows.getString("fcom_insu_his_id")});
                    }
                    if (selrows.getString("femp_insu_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_insu_his_id")});
                    }
                    if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_INSU"), selrows.getString("fcom_bala_his_id")});
                    }
                    if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_bala_his_id")});
                    }
                    if (selrows.getString("fcom_ADD_his_id") != null && selrows.getBigDecimal("FCOM_ADD").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_ADD"), selrows.getString("fcom_ADD_his_id")});
                    }
                    if (selrows.getString("femp_ADD_his_id") != null && selrows.getBigDecimal("FEMP_ADD").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                        updateSql.append("fvalue = fvalue + ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_ADD"), selrows.getString("femp_ADD_his_id")});
                    }
                    if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue + ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FBALANCE"), selrows.getString("fbalance_his_id")});
                    continue;
                }
                if (selrows.getString("fcom_insu_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getBigDecimal("FCOM_INSU"), selrows.getString("fcom_insu_his_id")});
                }
                if (selrows.getString("femp_insu_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_insu_his_id")});
                }
                if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_INSU"), selrows.getString("fcom_bala_his_id")});
                }
                if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_INSU"), selrows.getString("femp_bala_his_id")});
                }
                if (selrows.getString("fcom_ADD_his_id") != null && selrows.getBigDecimal("FCOM_ADD").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FCOM_ADD"), selrows.getString("fcom_ADD_his_id")});
                }
                if (selrows.getString("femp_ADD_his_id") != null && selrows.getBigDecimal("FEMP_ADD").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                    updateSql.append("fvalue = fvalue - ? where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FEMP_ADD"), selrows.getString("femp_ADD_his_id")});
                }
                if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                updateSql = new StringBuffer();
                updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0, ");
                updateSql.append("fvalue = fvalue - ? where fid = ?");
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("FBALANCE"), selrows.getString("fbalance_his_id")});
            }
            StringBuffer delSql = new StringBuffer();
            delSql.append(" delete from T_HR_BENEFITADJUSTDATATMP ");
            delSql.append("WHERE fcurcmpperiodid = ? and faccounttypeid = ? and fhrorgunitid = ? ");
            delSql.append(" and faccountdetailid in ");
            delSql.append(BenefitUtils.getStrFromList(accDetailId));
            DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{cmpPeriodId, accountTypeId, hrOrgUnitId});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List getAccDetailId(Context ctx, String tmpTableName, String accountTypeId) throws BOSException {
        ArrayList<String> accDetail = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select ad.fid fid from t_hr_accountdetail ad \n");
        sb.append("inner join " + tmpTableName + " tt on ad.faccountid = tt.FAccountId \n");
        sb.append("and ad.faccounttypeid ='");
        sb.append(accountTypeId + "'");
        IRowSet selrows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (selrows.next()) {
                accDetail.add(selrows.getString("fid"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return accDetail;
    }

    private void calcuBalanceNew(Context ctx, String accountTypeId, String cmpPeriod, String hrOrgUnitId, List accDetailId) throws BOSException {
        StringBuffer selSql = new StringBuffer();
        selSql.append("SELECT FISADJUST, FCOM_INSU, FEMP_INSU, FCOM_ADD, FEMP_ADD, FBALANCE, fcom_bala_his_id, ");
        selSql.append("femp_bala_his_id, fcom_insu_his_id, femp_insu_his_id, fcom_ADD_his_id, ");
        selSql.append("femp_ADD_his_id, fbalance_his_id, foperatetype, femp_bala_input_id, fcom_bala_input_id, fbalance_input_id ");
        selSql.append("FROM T_HR_BENEFITADJUSTDATATMP ");
        selSql.append("WHERE fcurcmpperiodid = ? and faccounttypeid = ? and fhrorgunitid = ? ");
        selSql.append(" and faccountdetailid in");
        selSql.append(BenefitUtils.getStrFromList(accDetailId));
        selSql.append("order by FISADJUST desc");
        IRowSet selrows = null;
        selrows = DbUtil.executeQuery((Context)ctx, (String)selSql.toString(), (Object[])new Object[]{cmpPeriod, accountTypeId, hrOrgUnitId});
        StringBuffer updateSql = null;
        try {
            while (selrows.next()) {
                if (selrows.getInt("FISADJUST") != 1) continue;
                if (selrows.getInt("foperatetype") == -1) {
                    if (selrows.getString("fcom_insu_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_insu_his_id")});
                    }
                    if (selrows.getString("femp_insu_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_insu_his_id")});
                    }
                    if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ? ");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_bala_his_id")});
                    }
                    if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ? ");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_bala_his_id")});
                    }
                    if (selrows.getString("fcom_ADD_his_id") != null && selrows.getBigDecimal("FCOM_ADD").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_ADD_his_id")});
                    }
                    if (selrows.getString("femp_ADD_his_id") != null && selrows.getBigDecimal("FEMP_ADD").compareTo(new BigDecimal(0)) != 0) {
                        updateSql = new StringBuffer();
                        updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ?");
                        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_ADD_his_id")});
                    }
                    if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fbalance_his_id")});
                    continue;
                }
                if (selrows.getString("fcom_insu_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_insu_his_id")});
                }
                if (selrows.getString("femp_insu_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_insu_his_id")});
                }
                if (selrows.getString("fcom_bala_his_id") != null && selrows.getBigDecimal("FCOM_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_bala_his_id")});
                }
                if (selrows.getString("femp_bala_his_id") != null && selrows.getBigDecimal("FEMP_INSU").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ?");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_bala_his_id")});
                }
                if (selrows.getString("fcom_ADD_his_id") != null && selrows.getBigDecimal("FCOM_ADD").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fcom_ADD_his_id")});
                }
                if (selrows.getString("femp_ADD_his_id") != null && selrows.getBigDecimal("FEMP_ADD").compareTo(new BigDecimal(0)) != 0) {
                    updateSql = new StringBuffer();
                    updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 1 where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("femp_ADD_his_id")});
                }
                if (selrows.getString("fbalance_his_id") == null || selrows.getBigDecimal("FBALANCE").compareTo(new BigDecimal(0)) == 0) continue;
                updateSql = new StringBuffer();
                updateSql.append("update t_hr_benefitdatadetailhis set FExistsComplementary = 0 where fid = ?");
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{selrows.getString("fbalance_his_id")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected List _getPersonID(Context ctx, List list, String accountTypeId, String curPeriod, String tmpTableName) throws BOSException, EASBizException {
        if (list == null || list.size() == 0) {
            return new ArrayList();
        }
        Locale local = ContextUtils.getLocaleFromEnv();
        FilterInfo info0 = (FilterInfo)list.get(0);
        FilterInfo info1 = (FilterInfo)list.get(1);
        FilterInfo info = info0 == null ? new FilterInfo() : info0;
        String info1Str = null;
        if (info1 != null && info1.getFilterItems() != null && info1.getFilterItems().size() > 0) {
            info.mergeFilter(info1, "and");
            info1Str = info1.toSql().replaceAll("number", "p.fnumber").replaceAll("name", "p." + BenefitUtils.getLocaleStr(local, "FName"));
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app.BenefitCalculateQuery");
        IQueryExecutor iquery = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(info);
        iquery.setObjectView(evi);
        String SQL = iquery.getSQL();
        try {
            SQL = KSqlUtil.optimize((String)SQL);
        }
        catch (SqlTranslateException e1) {
            e1.printStackTrace();
        }
        String hrUnitOrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String etStr = null;
        String tmp = null;
        if (info0 != null) {
            int i;
            int size = info0.getFilterItems().size();
            for (i = 0; i < size && !(etStr = info0.getFilterItems().get(i).toString()).startsWith("et.id"); ++i) {
                etStr = null;
            }
            size = info0.getFilterItems().size();
            for (i = 0; i < size && !(tmp = info0.getFilterItems().get(i).toString()).startsWith("admin.id") && !tmp.startsWith("admin.longNumber"); ++i) {
                tmp = null;
            }
        }
        StringBuffer fluPerSql = new StringBuffer();
        fluPerSql.append(" select fp.fpersonid as ID from t_hr_fluctuationPerson fp \n");
        fluPerSql.append(" inner join t_org_admin admin on fp.FOldAdminOrgID = admin.fid \n");
        fluPerSql.append(" inner join t_BD_person p on p.fid = fp.FPersonID \n");
        if (!StringUtils.isEmpty((String)etStr)) {
            fluPerSql.append(" left outer join T_HR_BDEmployeeType et on p.FEmployeeTypeID = et.FID \n");
        }
        fluPerSql.append(" inner join t_hr_account a on a.fpersonid = fp.fpersonid \n");
        fluPerSql.append(" and a.fhrorgunitid ='").append(hrUnitOrgID).append("' \n ");
        fluPerSql.append(" inner join t_hr_accountdetail ad on ad.faccountid = a.fid \n");
        if (!StringUtils.isEmpty((String)info1Str)) {
            fluPerSql.append(" and ").append(info1Str).append(" \n");
        }
        fluPerSql.append(" and ad.faccounttypeid ='").append(accountTypeId).append("' \n");
        fluPerSql.append(" and ad.FCurPeriodID ='").append(curPeriod).append("' \n");
        fluPerSql.append(" and ad.FPayState = 10 \n");
        if (!StringUtils.isEmpty((String)etStr)) {
            fluPerSql.append(" \tand ").append(etStr.replaceAll("et.id", "et.FID"));
        }
        if (tmp != null) {
            if (tmp.startsWith("admin.id")) {
                tmp = tmp.replaceAll("admin.id", " and fp.FOldAdminOrgID");
            } else if (tmp.startsWith("admin.longNumber")) {
                tmp = tmp.replaceAll("admin.longNumber", " and admin.flongNumber");
            }
            fluPerSql.append(tmp);
            fluPerSql.append(" and admin.fisSealUp = 0 \n");
        }
        fluPerSql.append(" and fp.FTranInOldDep = 1 \n");
        fluPerSql.append(" \n where fp.FOldAdminOrgID in ");
        fluPerSql.append("(").append(this.getUserHRAdminOrg(ctx, hrUnitOrgID)).append(")");
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + "\n");
        sbInsert.append(" select distinct * from (");
        sbInsert.append(SQL);
        sbInsert.append("\n union all \n ");
        sbInsert.append(fluPerSql + ") as T");
        DbUtil.execute((Context)ctx, (String)sbInsert.toString());
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select a.fpersonid as fid from t_hr_account a");
        sb.append(" inner join t_hr_accountdetail ad on ad.faccountid = a.fid \n");
        sb.append(" inner join t_hr_benefitdata bd on bd.faccountdetailid = ad.fid \n");
        sb.append(" where bd.fischeck = 1 ");
        sb.append(" and bd.fhrorgunitid ='");
        sb.append(hrOrgUnitId + "'");
        sb.append(" and ad.faccounttypeid ='");
        sb.append(accountTypeId + "'");
        StringBuffer delSql = new StringBuffer();
        delSql.append(" delete from " + tmpTableName + " where FPersonid in (");
        delSql.append(sb.toString() + ")");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        StringBuffer selSql = new StringBuffer();
        selSql.append(" select FPersonid as ID from " + tmpTableName);
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)selSql.toString());
        ArrayList<String> listRet = new ArrayList<String>();
        try {
            while (set.next()) {
                listRet.add(set.getString("ID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return listRet;
    }

    protected List _getBenefitList(Context ctx, String accounttype) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        ArrayList<String> item = new ArrayList<String>();
        ArrayList<String> benefit = new ArrayList<String>();
        try {
            Locale local = ContextUtils.getLocaleFromEnv();
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select fid,");
            sql.append(BenefitUtils.getLocaleStr(local, "FName")).append(",");
            sql.append("fnumber from t_hr_benefit where fhrorgunitid ='");
            sql.append(hrOrgUnitId + "'");
            sql.append(" and faccounttypeid ='");
            sql.append(accounttype + "'");
            sql.append(" and fstate = 1 ");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                benefit.add(row.getString("fid") + "@" + row.getString(BenefitUtils.getLocaleStr(local, "FName")) + "@" + row.getString("fnumber"));
            }
            StringBuffer getItem = new StringBuffer();
            getItem.append("select fnumber,");
            getItem.append(BenefitUtils.getLocaleStr(local, "FName"));
            getItem.append(" from t_hr_benefititem where fstate =1 and fhrorgunitid ='");
            getItem.append(hrOrgUnitId).append("' order by findex");
            row = DbUtil.executeQuery((Context)ctx, (String)getItem.toString());
            while (row.next()) {
                item.add(row.getString("fnumber") + "@" + row.getString(BenefitUtils.getLocaleStr(local, "FName")));
            }
            list.add(benefit);
            list.add(item);
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return list;
    }

    protected HashMap _getPersonInfo(Context ctx, String tmpTableName, String accountTypeId) throws BOSException, EASBizException {
        Locale local = ContextUtils.getLocaleFromEnv();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid fid ,");
        sql.append(" p.").append(BenefitUtils.getLocaleStr(local, "FName")).append(" as pName,");
        sql.append("p.fnumber as fnumber, p.fidcardNo as idcardno ,si.FTranSInsuTime as tranTime,");
        sql.append(" admin.").append(BenefitUtils.getLocaleStr(local, "FName")).append(" as admin,");
        sql.append(" ad.faccounts as accounts, ");
        sql.append(" a.fid as accountid, ad.fid as accountdetailid, ad.fbenefitruleid as benefitruleid ");
        sql.append(" from t_bd_person p ");
        sql.append(" inner join " + tmpTableName + " tmp");
        sql.append(" on p.fid = tmp.FPersonid ");
        sql.append(" inner join T_HR_SocialInsurance si on si.fpersonid = p.fid ");
        sql.append(" inner join t_hr_personposition pp on pp.fpersonid = p.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pp.fpersondep ");
        sql.append(" inner join t_hr_account a on p.fid = a.fpersonid ");
        sql.append(" inner join t_hr_accountdetail ad on ad.faccountid = a.fid ");
        sql.append(" where ad.faccounttypeid ='" + accountTypeId + "'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(row.getString("pName") + "@_@");
                tmp.append(row.getString("fnumber") + "@_@");
                tmp.append(row.getString("admin") + "@_@");
                tmp.append(row.getString("accounts") + "@_@");
                if (StringUtils.isEmpty((String)row.getString("idcardno"))) {
                    tmp.append("null@_@");
                } else {
                    tmp.append(row.getString("idcardno") + "@_@");
                }
                tmp.append(row.getString("tranTime") + "@_@");
                tmp.append(row.getString("accountid") + "@_@");
                tmp.append(row.getString("accountdetailid") + "@_@");
                tmp.append(row.getString("benefitruleid") + "@_@");
                map.put(row.getString("fid"), tmp.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected HashMap _getPersonData(Context ctx, String accountType, String tmpTableName) throws BOSException, EASBizException {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        HashMap beneMap = new HashMap();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select a.fpersonid as pid ,tmp.fbenefitid as benefitid, tmp.fcom_add as Com_Sum, \n");
            sb.append(" tmp.femp_add as Emp_Sum, tmp.fcom_insu as Com_insu, tmp.femp_insu as Emp_insu, \n");
            sb.append(" tmp.fcom_bala as Com_Bala, tmp.femp_bala as Emp_Bala,tmp.fcom_accr as Com_Accr, \n");
            sb.append(" tmp.femp_accr as Emp_Accr,tmp.fbalance as Balance \n ");
            sb.append(" from t_hr_accountsettletmp tmp \n");
            sb.append(" inner join t_hr_account a on tmp.faccountid = a.fid  \n ");
            sb.append(" inner join t_hr_benefit b on tmp.fbenefitid = b.fid \n");
            sb.append(" inner join ");
            sb.append(tmpTableName + " tt on a.fpersonid = tt.FPersonid");
            sb.append(" where tmp.faccounttypeid ='");
            sb.append(accountType + "'");
            sb.append(" and a.fhrorgunitid ='" + hrOrgUnitId + "' \n");
            sb.append(" and tmp.fhrorgunitid ='" + hrOrgUnitId + "' \n");
            sb.append(" and b.fhrorgunitid ='" + hrOrgUnitId + "' \n");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            HashMap<String, BigDecimal> itemValue = null;
            while (set.next()) {
                itemValue = new HashMap<String, BigDecimal>();
                itemValue.put("Com_Sum", set.getBigDecimal("Com_Sum"));
                itemValue.put("Emp_Sum", set.getBigDecimal("Emp_Sum"));
                itemValue.put("Com_insu", set.getBigDecimal("Com_insu"));
                itemValue.put("Emp_insu", set.getBigDecimal("Emp_insu"));
                itemValue.put("Com_Bala", set.getBigDecimal("Com_Bala"));
                itemValue.put("Emp_Bala", set.getBigDecimal("Emp_Bala"));
                itemValue.put("Com_Accr", set.getBigDecimal("Com_Accr"));
                itemValue.put("Emp_Accr", set.getBigDecimal("Emp_Accr"));
                itemValue.put("Balance", set.getBigDecimal("Balance"));
                beneMap.put(set.getString("pid") + "@" + set.getString("benefitid"), itemValue);
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" select T.pid pid, i.fbenefitid bid, aii.fvalue value  \n");
            sql.append(" from t_hr_accountiteminput aii \n");
            sql.append(" inner join t_hr_item i on aii.fitemid = i.fid\n");
            sql.append(" inner join (\n");
            sql.append(" SELECT a.fpersonid pid, AD.FID AS FAccountdetailID\n");
            sql.append(" FROM t_hr_accountdetail ad,t_hr_account a,").append(tmpTableName).append(" tt \n");
            sql.append(" where a.fpersonid = tt.FPersonid\n");
            sql.append(" AND ad.faccountid = a.fid \n");
            sql.append(" AND ad.faccounttypeid = ? \n");
            sql.append(" and a.fhrorgunitid =? ) T ");
            sql.append(" ON T.FAccountdetailID = aii.FAccountdetailID \n");
            sql.append(" where i.fbenefititemnumber =? ");
            sql.append(" and i.fhrorgunitid = ? ");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountType, hrOrgUnitId, "Base_insu", hrOrgUnitId});
            HashMap<String, BigDecimal> baseMap = new HashMap<String, BigDecimal>();
            while (row.next()) {
                baseMap.put(row.getString("pid") + "@" + row.getString("bid"), row.getBigDecimal("value"));
            }
            beneMap.put("Base_insu", baseMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return beneMap;
    }

    protected HashMap _getBenefitCalcuteData(Context ctx, List list, String accountTypeId, String curPeriod) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String cSql = " create TABLE t1(FPersonid varchar(44) not null primary key) ";
        String tmpTableName = null;
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTableName = pool.createTempTable(cSql);
            result.put("personid", this._getPersonID(ctx, list, accountTypeId, curPeriod, tmpTableName));
            result.put("personInfo", this._getPersonInfo(ctx, tmpTableName, accountTypeId));
            result.put("personData", this._getPersonData(ctx, accountTypeId, tmpTableName));
            result.put("radixInfo", this.getPersonPayScale(ctx, accountTypeId, tmpTableName));
        }
        catch (Exception ex) {
            logger.error((Object)cSql.toString());
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            this.dropTmpTable(ctx, pool, tmpTableName);
        }
        return result;
    }

    private HashMap getPersonPayScale(Context ctx, String accountTypeID, String tmpTableName) throws BOSException {
        HashMap<String, List> map = new HashMap<String, List>();
        String HROrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        Map ruleKeyMap = this.getBenefitRuleItem(ctx, accountTypeID, HROrgID);
        StringBuffer sql = new StringBuffer();
        sql.append("select tmp.FPersonid as personid, ad.fbenefitruleid as benefitruleid \n");
        sql.append(" from T_HR_AccountDetail ad \n");
        sql.append(" inner join T_HR_Account a on ad.faccountid = a.fid \n");
        sql.append(" inner join " + tmpTableName + " tmp on a.fpersonid = tmp.FPersonid \n");
        sql.append(" where ad.FAccountTypeID ='" + accountTypeID + "' \n");
        sql.append(" and a.FHROrgUnitID ='" + HROrgID + "' ");
        IRowSet rset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String personid = null;
        String benefitruleid = null;
        List listtmp = null;
        Map benefitMap = null;
        Map.Entry entry2 = null;
        String benefitNumber = null;
        try {
            while (rset.next()) {
                personid = rset.getString("personid");
                benefitruleid = rset.getString("benefitruleid");
                if (benefitruleid == null || !ruleKeyMap.containsKey(benefitruleid)) continue;
                benefitMap = (Map)ruleKeyMap.get(benefitruleid);
                for (Map.Entry entry2 : benefitMap.entrySet()) {
                    benefitNumber = (String)entry2.getKey();
                    listtmp = (List)entry2.getValue();
                    map.put(personid + "@" + benefitNumber, listtmp);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void insertZeroToHis(Context ctx, String cmp, List hisCmp, List account, String accType, List benefitList) throws BOSException, EASBizException {
        Connection con = null;
        Statement stmt = null;
        try {
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            StringBuffer sb = null;
            int size = hisCmp.size();
            for (int i = 0; i < size; ++i) {
                sb = new StringBuffer();
                sb.append("select bdh.fid from t_hr_benefitdatahis bdh \n");
                sb.append("inner join t_hr_accountdetail ad on bdh.FAccountDetailID = ad.fid \n");
                sb.append("where bdh.FCmpPeriodID = ");
                sb.append("'" + hisCmp.get(i) + "' \n");
                sb.append("and ad.FAccountTypeID =");
                sb.append("'" + accType + "' \n");
                sb.append(" and ad.FAccountID = ");
                sb.append("'" + account.get(i) + "'");
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rows.next()) continue;
                String bosType1 = new BenefitDataHisInfo().getBOSType().toString();
                String bdhID = BOSUuid.create((String)bosType1).toString();
                StringBuffer sql = new StringBuffer("select fid from t_hr_accountdetail where faccountid = '");
                sql.append(account.get(i));
                sql.append("' and faccounttypeid = '");
                sql.append(accType + "'");
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                row.next();
                String accDetID = row.getString("fid");
                StringBuffer sql1 = new StringBuffer("insert into t_hr_benefitdatahis (fid,faccountdetailid,fcmpperiodid,fhrorgunitid) values (");
                sql1.append("'" + bdhID + "',");
                sql1.append("'" + accDetID + "',");
                sql1.append("'" + hisCmp.get(i) + "',");
                sql1.append("'" + hrOrgUnitId + "')");
                DbUtil.execute((Context)ctx, (String)sql1.toString());
                List aiiIDList = this.getAiiID(ctx, account.get(i).toString(), accType, accDetID, benefitList);
                HashMap<String, String> map = new HashMap<String, String>();
                StringBuffer s = new StringBuffer();
                s.append("select badd.fvalue as value,badd.faccountiteminput as aiiid from t_hr_benefitadjustdatadetail badd \n");
                s.append("inner join t_hr_benefitadjustdata bad on badd.fbenefitadjustdataid = bad.fid \n");
                s.append("inner join t_hr_accountiteminput aii on badd.faccountiteminput = aii.fid \n");
                s.append(" and bad.faccountdetailid  = '" + accDetID + "' \n");
                s.append(" and bad.fcmpperiodhisid = '" + hisCmp.get(i) + "' \n");
                s.append(" and bad.fcmpperiodid = '" + cmp + "'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)s.toString());
                while (rs.next()) {
                    map.put(rs.getString("aiiid"), rs.getString("value"));
                }
                String bosType2 = new BenefitDataDetailHisInfo().getBOSType().toString();
                String bddhID = null;
                BigDecimal zero = new BigDecimal(0);
                int existCom = 1;
                int notExistCom = 0;
                con = EJBFactory.getConnection((Context)ctx);
                stmt = con.createStatement();
                int asize = aiiIDList.size();
                for (int j = 0; j < asize; ++j) {
                    bddhID = BOSUuid.create((String)bosType2).toString();
                    StringBuffer sql2 = new StringBuffer();
                    sql2.append("insert into t_hr_benefitdatadetailhis \n");
                    sql2.append("(fid,fvalue,ftotalvalue,FExistsComplementary,FBenefitDataHisID,FAccountItemInputID) \n values (");
                    sql2.append("'" + bddhID + "',");
                    sql2.append(zero + ",");
                    sql2.append(zero + ",");
                    if (map.get(aiiIDList.get(j)) == null) {
                        sql2.append(notExistCom + ",");
                    } else {
                        sql2.append(existCom + ",");
                    }
                    sql2.append("'" + bdhID + "',");
                    sql2.append("'" + aiiIDList.get(j) + "')");
                    stmt.addBatch(sql2.toString());
                }
                stmt.executeBatch();
                SQLUtils.cleanup((Statement)stmt);
                SQLUtils.cleanup((Connection)con);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(stmt);
            SQLUtils.cleanup(con);
        }
    }

    private List getAiiID(Context ctx, String account, String accType, String accDetID, List benefits) throws BOSException, SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> list1 = new ArrayList<String>();
        try {
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            StringBuffer sb = new StringBuffer("select fid from t_hr_item where fbenefititemnumber in('Emp_insu','Com_insu','Emp_Sum','Com_Sum') and fbenefitid in ");
            sb.append(BenefitUtils.getStrFromList(benefits));
            sb.append("and fhrorgunitid ='" + hrOrgUnitId + "'");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (row.next()) {
                String itemID = row.getString("fid");
                list1.add(itemID);
            }
            IRowSet rSet = null;
            StringBuffer str = new StringBuffer("select aii.fid from t_hr_accountiteminput aii  inner join t_hr_item it on aii.fitemid = it.fid ");
            str.append("inner join t_hr_accountdetail ad on aii.faccountdetailid = ad.fid  ");
            str.append("and ad.fid = '" + accDetID + "'");
            str.append("and ad.faccounttypeid ='" + accType + "'");
            str.append("and it.fhrorgunitid = '" + hrOrgUnitId + "'");
            str.append("where it.fbenefitid in ").append(BenefitUtils.getStrFromList(benefits));
            str.append("and it.fid in ").append(BenefitUtils.getStrFromList(list1));
            rSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rSet.next()) {
                list.add(rSet.getString("fid"));
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected HashMap _getAdjustData(Context ctx, HashMap map) throws BOSException, EASBizException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashSet personSet = (HashSet)map.get("personSet");
        ArrayList<String> personList = new ArrayList<String>();
        Iterator ite = personSet.iterator();
        String beginCmp = null;
        String endCmp = null;
        while (ite.hasNext()) {
            personList.add(ite.next().toString());
        }
        String accountType = map.get("accountType").toString();
        if (map.containsKey("beginCmp")) {
            beginCmp = map.get("beginCmp").toString();
        }
        if (map.containsKey("endCmp")) {
            endCmp = map.get("endCmp").toString();
        }
        List benefitList = (List)map.get("benefitList");
        String operateType = map.get("operateType").toString();
        ArrayList<String> beneItemNum = new ArrayList<String>();
        beneItemNum.add("Base_insu");
        beneItemNum.add("Emp_insu");
        beneItemNum.add("Com_insu");
        beneItemNum.add("Emp_Sum");
        beneItemNum.add("Com_Sum");
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fpersonid as pid ,a.fid as accid ,ad.fid as accdetailid , \n ");
        sql.append("bad.fcmpperiodid as cmpid , bad.fcmpperiodhisid as cmphisid ,badd.fvalue as value, \n");
        sql.append("i.fbenefitnumber as benefitnumber,i.fbenefititemnumber as beneitemnumber \n");
        sql.append("from t_hr_benefitadjustdatadetail badd \n");
        sql.append("inner join t_hr_benefitadjustdata bad on badd.fbenefitadjustdataid = bad.fid \n");
        sql.append("inner join t_hr_accountiteminput aii on badd.faccountiteminput = aii.fid \n");
        sql.append("inner join t_hr_item i on aii.fitemid = i.fid \n");
        sql.append("inner join t_hr_accountdetail ad on bad.faccountdetailid = ad.fid \n");
        sql.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        if (personList.size() > 0) {
            sql.append("where a.fpersonid in " + BenefitUtils.getStrFromList(personList));
        } else {
            sql.append("where a.fpersonid in ('') ");
        }
        sql.append("and ad.faccounttypeid = '" + accountType + "' \n");
        if (beginCmp != null && endCmp != null) {
            sql.append("and bad.fcmpperiodid = '" + beginCmp + "' \n");
            sql.append("and bad.fcmpperiodhisid = '" + endCmp + "' \n");
        }
        sql.append("and bad.foperatetype = " + operateType);
        sql.append(" and i.fbenefitid in " + BenefitUtils.getStrFromList(benefitList));
        sql.append(" and i.fbenefititemnumber in " + BenefitUtils.getStrFromList(beneItemNum));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                StringBuffer s = new StringBuffer();
                s.append(rs.getString("pid"));
                s.append(rs.getString("accid"));
                s.append(rs.getString("cmpid"));
                s.append(rs.getString("cmphisid"));
                s.append(rs.getString("benefitnumber"));
                s.append(rs.getString("beneitemnumber"));
                String value = rs.getString("value");
                if (value == null) {
                    dataMap.put(s.toString(), "0");
                    continue;
                }
                dataMap.put(s.toString(), value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    protected List _getcmpperiods(Context ctx, String beginCmp, String endCmp) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select cmp.FID fid from t_hr_cmpperiod cmp, ");
        sb.append("t_hr_cmpperiod beginCmp, ");
        sb.append("t_hr_cmpperiod endCmp ");
        sb.append("where cmp.FBEGINDATE >= beginCmp.fbegindate ");
        sb.append("and cmp.FBEGINDATE <= endCmp.FBEGINDATE ");
        sb.append("and cmp.FHROrgUnitID = ? ");
        sb.append("and beginCmp.FHROrgUnitID = ? ");
        sb.append("and endCmp.FHROrgUnitID = ? ");
        sb.append("and beginCmp.FID = ? and endCmp.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, hrOrgUnitId, hrOrgUnitId, beginCmp, endCmp});
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected void _recordCurBaseInsu(Context ctx, String accountTypeID) throws BOSException, EASBizException {
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String bosType = new BaseInsuHistoryInfo().getBOSType().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        GregorianCalendar cal = new GregorianCalendar();
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_hr_BaseInsuHistory (FID,FPersonID,FAccountID,FAccountTypeID, \n");
        sql.append(" FBenefitID,FCmpperiodID,FChangeTime,FBaseInsu ) \n");
        sql.append(" select newbosid ('" + bosType + "') as FID, \n ");
        sql.append(" a.fpersonid as FPersonID,a.fid as FAccountID, \n");
        sql.append(" ad.faccounttypeid as FAccountTypeID, \n ");
        sql.append(" i.fbenefitid as FBenefitID, \n");
        sql.append(" ad.FCurPeriodID as FCmpperiodID, \n");
        sql.append("{ts'" + format.format(cal.getTime()) + "'} as FChangeTime, \n");
        sql.append(" aii.fvalue as FBaseInsu \n");
        sql.append(" from t_hr_accountiteminput aii \n");
        sql.append(" inner join t_hr_item i on aii.fitemid = i.fid \n");
        sql.append(" inner join t_hr_accountdetail ad on aii.faccountdetailid = ad.fid \n");
        sql.append(" inner join t_hr_account a on ad.faccountid = a.fid \n");
        sql.append(" where a.fhrOrgUnitid ='" + hrOrgUnitID + "' \n");
        sql.append(" and ad.faccountTypeid ='" + accountTypeID + "'");
        sql.append(" and i.fbenefititemnumber ='Base_insu'");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" insert into t_hr_benefitutil (ftype,fhrorgunitid,fvalue,faccounttypeid )");
        insertSQL.append(" values ('BASEINSU',");
        insertSQL.append("'" + hrOrgUnitID + "','true',");
        insertSQL.append("'" + accountTypeID + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    protected boolean _EnableBaseInsuRecord(Context ctx, String accountTypeID) throws BOSException, EASBizException {
        return this._enableBaseInsuRecord(ctx, accountTypeID);
    }

    protected boolean _enableBaseInsuRecord(Context ctx, String accountTypeID) throws BOSException, EASBizException {
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from t_hr_benefitutil ");
        sql.append(" where ftype ='BASEINSU' ");
        sql.append(" and fhrorgunitid ='" + hrOrgUnit + "'");
        sql.append(" and faccounttypeid ='" + accountTypeID + "'");
        sql.append(" and fvalue ='true' ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rows.size() >= 1;
    }

    protected String _checkBenefitAdjustData(Context ctx, String accountTypeID, OperateTypeEnum oprtType, String curCmpperiod, HashMap map) throws BOSException, EASBizException {
        String msg = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fnumber as perNumber,hisCmp.fnumber as cmpNumber \n");
        sb.append("from t_hr_benefitadjustdata bad \n");
        sb.append("inner join t_hr_cmpperiod curCmp on bad.FCmpPeriodID = curCmp.fid \n");
        sb.append("inner join t_hr_cmpperiod hisCmp on bad.FCmpPeriodHisID = hisCmp.fid \n");
        sb.append("inner join t_hr_accountdetail ad on bad.faccountdetailid = ad.fid \n");
        sb.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        sb.append("inner join t_bd_person p on a.fpersonid = p.fid \n");
        sb.append("where ad.faccountTypeID = '" + accountTypeID + "'\n");
        sb.append("and bad.FOperateType =" + oprtType.getValue());
        sb.append("\n and curCmp.fid ='" + curCmpperiod + "'\n");
        try {
            Set set = map.keySet();
            String personID2 = null;
            List tmpList = null;
            StringBuffer sql = null;
            IRowSet row = null;
            for (String personID2 : set) {
                tmpList = (List)map.get(personID2);
                sql = new StringBuffer();
                sql.append(sb.toString());
                sql.append("and p.fid = '" + personID2 + "'\n");
                sql.append("and hisCmp.fid in \n");
                sql.append(BenefitUtils.getStrFromList(tmpList));
                row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!row.next()) continue;
                msg = row.getString("perNumber") + "@" + row.getString("cmpNumber");
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg;
    }

    protected void _checkAuditedBenefitData(Context ctx, List adjustDataIDList) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select bd.fid from t_hr_benefitdata bd \n");
        sb.append(" inner join t_hr_benefitadjustdata bad \n");
        sb.append(" \ton bad.faccountdetailid = bd.faccountdetailid \n");
        sb.append(" where bd.fischeck = 1 \n");
        sb.append(" and bad.fid in ");
        sb.append(BenefitUtils.getStrFromList(adjustDataIDList));
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (set.next()) {
                throw new BenefitException(BenefitException.ANAUDIT_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected CmpPeriodInfo _getPeriodFromUtilsTable(Context ctx, String accountType) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select FValue from T_HR_BenefitUtil \n");
        sb.append("where FType = '").append("CURPERIOD").append("' \n");
        sb.append("and FHrOrgUnitID = '").append(hrOrgUnitId).append("' \n");
        sb.append("and FAccountTypeID = '").append(accountType).append("'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String curPeriodID = null;
        CmpPeriodInfo cmpInfo = null;
        try {
            if (row.next()) {
                curPeriodID = row.getString("FValue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty(curPeriodID)) {
            ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
            cmpInfo = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(curPeriodID));
        }
        return cmpInfo;
    }

    protected HashMap _getHistoryData(Context ctx, HashMap map) throws BOSException, EASBizException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashSet personSet = (HashSet)map.get("personSet");
        ArrayList<String> personList = new ArrayList<String>();
        Iterator ite = personSet.iterator();
        while (ite.hasNext()) {
            personList.add(ite.next().toString());
        }
        String accountType = map.get("accountType").toString();
        List benefitList = (List)map.get("benefitList");
        ArrayList<String> beneItemNum = new ArrayList<String>();
        beneItemNum.add("Emp_insu");
        beneItemNum.add("Com_insu");
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fpersonid as pid ,a.fid as accid ,ad.fid as accdetailid , \n");
        sql.append("his.fcmpperiodid as cmpid, dehis.fvalue as value, \n");
        sql.append("i.fbenefitnumber as benefitnumber,i.fbenefititemnumber as beneitemnumber \n");
        sql.append("from t_hr_benefitdatadetailhis dehis \n");
        sql.append("inner join t_hr_benefitdatahis his on dehis.fbenefitdatahisid =his.fid \n");
        sql.append("inner join t_hr_accountiteminput aii on dehis.faccountiteminputid = aii.fid \n");
        sql.append("inner join t_hr_item i on aii.fitemid = i.fid \n");
        sql.append("inner join t_hr_accountdetail ad on his.faccountdetailid = ad.fid \n");
        sql.append("inner join t_hr_account a on ad.faccountid = a.fid \n");
        if (personList.size() > 0) {
            sql.append("where a.fpersonid in " + BenefitUtils.getStrFromList(personList));
        } else {
            sql.append("where a.fpersonid in ('') ");
        }
        sql.append("and ad.faccounttypeid = '" + accountType + "' \n");
        sql.append(" and i.fbenefitid in " + BenefitUtils.getStrFromList(benefitList));
        sql.append(" and i.fbenefititemnumber in " + BenefitUtils.getStrFromList(beneItemNum));
        sql.append(" and a.fhrorgunitid = '" + hrOrgUnitID + "' \n");
        sql.append(" and his.fhrorgunitid = '" + hrOrgUnitID + "' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                StringBuffer s = new StringBuffer();
                s.append(rs.getString("pid"));
                s.append(rs.getString("accid"));
                s.append(rs.getString("cmpid"));
                s.append(rs.getString("benefitnumber"));
                if (rs.getString("beneitemnumber").equals("Com_insu")) {
                    s.append("ComActual_insu");
                } else if (rs.getString("beneitemnumber").equals("Emp_insu")) {
                    s.append("EmpActual_insu");
                }
                String value = rs.getString("value");
                if (value == null) {
                    dataMap.put(s.toString(), "0");
                    continue;
                }
                dataMap.put(s.toString(), value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    protected boolean _checkInitPeriod(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BenefitImportDataException(BenefitImportDataException.HRORG_NULL);
        }
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select p.fid from T_HR_BenefitUtil b inner join t_hr_cmpPeriod p");
        selectSql.append(" on b.FValue = p.fid ");
        selectSql.append(" WHERE b.FType = ? and b.FHROrgUnitID = ? ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{"INITPERIOD", hrOrgUnitId});
        if (rows.size() > 0) {
            return true;
        }
        selectSql = new StringBuffer();
        selectSql.append("delete from T_HR_BenefitUtil ");
        selectSql.append(" WHERE FType = ? and FHROrgUnitID = ?");
        DbUtil.execute((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{"INITPERIOD", hrOrgUnitId});
        return false;
    }

    private String getUserHRAdminOrg(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        String userID = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            throw new BOSException("current user is null !");
        }
        userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation \n");
        sql.append("WHERE FToUnitID = '");
        sql.append(hrOrgUnitID);
        sql.append("' \n");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5' \n");
        sql.append("AND FFromUnitID IN \n");
        sql.append("( SELECT FOrgID FROM T_PM_OrgRange \n");
        sql.append("WHERE FUserID = '");
        sql.append(userID);
        sql.append("' \n");
        sql.append("AND FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    private Map getAgeSegMap(Context ctx, String accountTypeID, String hrorgID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select a.fageseg as ageseg, a.fscale as scale, a.fsign as sign, a.fbenefitruleid as ruleid from T_HR_AgeSegScale a ");
        sb.append(" inner join t_hr_benefitrule b on a.fbenefitruleid = b.fid ");
        sb.append(" where b.faccounttypeid = '").append(accountTypeID).append("'");
        sb.append(" and b.fhrorgunitid = '").append(hrorgID).append("'");
        sb.append(" order by a.fbenefitruleid, a.fageseg desc");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap map = new HashMap();
        AgeSegScaleInfo info = null;
        ArrayList<AgeSegScaleInfo> list = null;
        String ruleid = null;
        List l = null;
        try {
            while (row.next()) {
                info = new AgeSegScaleInfo();
                info.setScale(row.getBigDecimal("scale"));
                info.setSign(row.getInt("sign"));
                info.setAgeSeg(row.getInt("ageseg"));
                ruleid = row.getString("ruleid");
                if (!map.containsKey(ruleid)) {
                    list = new ArrayList<AgeSegScaleInfo>();
                    list.add(info);
                    map.put(ruleid, list);
                    continue;
                }
                l = (List)map.get(ruleid);
                l.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private Map getBenefitRuleItem(Context ctx, String accountTypeID, String hrOrgID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select b.fnumber as benefitnumber, bri.FComDeductModeEnum as comMode,bri.FEmpDeductModeEnum as empmode, \n");
        sb.append(" bri.FBalComPer as balcomper,bri.FBalPersPer as balperper,br.fid as brID ");
        sb.append(" from T_HR_BenefitRuleItem bri ");
        sb.append(" inner join T_HR_BenefitRule br on bri.FBenefitRuleID = br.fid \n");
        sb.append(" inner join t_hr_benefit b on bri.fbenefitid = b.fid ");
        sb.append(" where br.FAccountTypeID ='" + accountTypeID + "' \n");
        sb.append(" and br.FHROrgUnitID ='" + hrOrgID + "' ");
        IRowSet rset = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String benefitNum = null;
        String benefitRuleID = null;
        ArrayList<Object> listtmp = null;
        Map ageSegMap = this.getAgeSegMap(ctx, accountTypeID, hrOrgID);
        List ageSegInfoList = null;
        AgeSegScaleInfo info = null;
        BigDecimal comradix1 = null;
        HashMap rulekeyMap = new HashMap();
        Map benefitKeyMap = null;
        int comMode = 0;
        int empMode = 0;
        BigDecimal balcomper = null;
        BigDecimal balperper = null;
        try {
            while (rset.next()) {
                benefitRuleID = rset.getString("brID");
                benefitNum = rset.getString("benefitnumber");
                comMode = rset.getInt("comMode");
                empMode = rset.getInt("empMode");
                balcomper = rset.getBigDecimal("balcomper");
                balperper = rset.getBigDecimal("balperper");
                if (rulekeyMap.containsKey(benefitRuleID)) {
                    benefitKeyMap = (Map)rulekeyMap.get(benefitRuleID);
                } else {
                    benefitKeyMap = new HashMap();
                    rulekeyMap.put(benefitRuleID, benefitKeyMap);
                }
                if (!benefitNum.equals("Insu002")) {
                    listtmp = new ArrayList<Object>();
                    listtmp.add(balperper);
                    listtmp.add(balcomper);
                    if (comMode == 10 && empMode == 10) {
                        listtmp.add("TRUE_FLAG");
                    } else {
                        listtmp.add("FALSE_FLAG");
                    }
                    benefitKeyMap.put(benefitNum, listtmp);
                    continue;
                }
                listtmp = new ArrayList();
                listtmp.add(balperper);
                String brID = rset.getString("brID");
                if (ageSegMap.containsKey(brID)) {
                    ageSegInfoList = (List)ageSegMap.get(brID);
                    int size = ageSegInfoList.size();
                    for (int i = 0; i < size; ++i) {
                        info = (AgeSegScaleInfo)ageSegInfoList.get(i);
                        int sign = info.getSign();
                        int age = info.getAgeSeg();
                        comradix1 = info.getScale();
                        String tmp = String.valueOf(sign) + "@" + String.valueOf(age) + "@" + String.valueOf(comradix1);
                        listtmp.add(tmp);
                    }
                } else {
                    listtmp.add(null);
                }
                if (comMode == 10 && empMode == 10) {
                    listtmp.add("TRUE_FLAG");
                } else {
                    listtmp.add("FALSE_FLAG");
                }
                benefitKeyMap.put(benefitNum, listtmp);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rulekeyMap;
    }

    protected void _emptyAccountSettle(Context ctx, Map map) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BenefitInvokeFacade().getType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.EMPTYSETTLE"), (String)"AccountManager_settle");
        CmpPeriodInfo beforePeriodInfo = (CmpPeriodInfo)map.get("beforePeriodInfo");
        CmpPeriodInfo curPeriodInfo = (CmpPeriodInfo)map.get("curPeriodInfo");
        String settlePeriodID = (String)map.get("settlePeriodID");
        String accountDetailID = (String)map.get("accountDetailID");
        String personID = (String)map.get("id");
        String accountID = (String)map.get("accountID");
        String accountTypeID = (String)map.get("accountTypeID");
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        CmpPeriodInfo settlePeriodInfo = CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(settlePeriodID));
        CmpPeriodInfo info = HRUtils.getCmpPeriodInfoByConstantServer((Context)ctx, (CmpPeriodInfo)settlePeriodInfo, (int)-1);
        List periodList = HRUtils.getCmpPeriodList((Context)ctx, (CmpPeriodInfo)curPeriodInfo, (CmpPeriodInfo)info, (boolean)false);
        CmpPeriodInfo dataPeriod = null;
        String benefitDataHisID = null;
        boolean copy = false;
        StringBuffer sb = new StringBuffer();
        sb.append("(select bd.FID \n");
        sb.append("from T_HR_Benefitdata  bd \n");
        sb.append("where bd.FHROrgUnitID = '").append(hrOrgUnitId).append("' \n");
        sb.append("and bd.FCmpPeriodID = '").append(curPeriodInfo.getId().toString()).append("' \n");
        sb.append("and bd.FaccountdetailID = '").append(accountDetailID).append("')");
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from T_HR_BenefitDataDetail \n");
        delSql.append("where FBenefitDataID in \n");
        delSql.append(sb.toString());
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        delSql = new StringBuffer();
        delSql.append("delete from T_HR_Benefitdata \n");
        delSql.append("where fid in ");
        delSql.append(sb.toString());
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        if (beforePeriodInfo != null) {
            sb = new StringBuffer();
            sb.append("select * from T_HR_BENEFITDATAHis ");
            sb.append(" where FHROrgUnitID = ? AND FCmpPeriodID = ? And faccountdetailID = ? ");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, beforePeriodInfo.getId().toString(), accountDetailID});
            try {
                if (row.next()) {
                    copy = true;
                    for (int i = 0; i < periodList.size(); ++i) {
                        dataPeriod = (CmpPeriodInfo)periodList.get(i);
                        sb = new StringBuffer();
                        sb.append("DELETE FROM T_HR_BenefitDataDetailHis \n");
                        sb.append("WHERE FBenefitDataHisID IN \n");
                        sb.append("(SELECT FID \n");
                        sb.append("FROM T_HR_BENEFITDATAHis  \n");
                        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
                        sb.append("AND FAccountDetailId = ?)");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, dataPeriod.getId().toString(), accountDetailID});
                        sb = new StringBuffer();
                        sb.append("DELETE FROM T_HR_BENEFITDATAHis \n");
                        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
                        sb.append("AND FAccountDetailId = ? ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, dataPeriod.getId().toString(), accountDetailID});
                        sb = new StringBuffer();
                        sb.append("DELETE FROM T_HR_BenefitReportTable \n");
                        sb.append(" where faccountID = ? and faccountTypeID = ? and FCmpPeriodID = ? ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{accountID, accountTypeID, dataPeriod.getId().toString()});
                        sb = new StringBuffer();
                        sb.append("INSERT INTO T_HR_BENEFITDATAHIS(FID, FControlUnitID, FHROrgUnitID, FCmpPeriodID, FAccountDetailID, FAdminOrgUnitHis, FPositionHis) \n");
                        sb.append("SELECT newbosid('");
                        sb.append(new BenefitDataHisInfo().getBOSType().toString());
                        sb.append("'), FControlUnitID, FHROrgUnitID, '").append(dataPeriod.getId().toString()).append("', FAccountDetailID, FAdminOrgUnitHis, FPositionHis \n");
                        sb.append("FROM T_HR_BENEFITDATAHis  \n");
                        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
                        sb.append("AND FAccountDetailId = ? ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, beforePeriodInfo.getId().toString(), accountDetailID});
                        sb = new StringBuffer();
                        sb.append("select fid from T_HR_BENEFITDATAHis ");
                        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
                        sb.append("AND FAccountDetailId = ? ");
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, dataPeriod.getId().toString(), accountDetailID});
                        while (rowSet.next()) {
                            benefitDataHisID = rowSet.getString("fid");
                        }
                        sb = new StringBuffer();
                        sb.append("INSERT INTO T_HR_BenefitDataDetailHis (FID, FValue, FTotalValue, FExistsComplementary, FBenefitDataHisID, FAccountItemInputID) \n");
                        sb.append("SELECT newbosid('");
                        sb.append(new BenefitDataDetailHisInfo().getBOSType().toString());
                        sb.append("'), (CASE t.fbenefititemnumber when 'Com_Bala' then h.FValue when 'Emp_Bala' then h.fvalue when 'Balance' then h.fvalue when 'Emp_Sum' then h.fvalue when 'Com_Sum' then h.fvalue ELSE 0 end) as value,");
                        sb.append("(CASE t.fbenefititemnumber when 'Com_Bala' then h.FValue when 'Emp_Bala' then h.fvalue when 'Balance' then h.fvalue when 'Emp_Sum' then h.fvalue when 'Com_Sum' then h.fvalue ELSE 0 end) as totalvalue,");
                        sb.append(" h.FExistsComplementary,'").append(benefitDataHisID).append("', h.FAccountItemInputID \n");
                        sb.append("FROM T_HR_BenefitDataDetailHis h \n");
                        sb.append(" inner join t_hr_accountiteminput i on h.faccountiteminputid = i.fid \n");
                        sb.append(" inner join t_hr_item t on i.fitemid = t.fid \n");
                        sb.append(" WHERE h.FBenefitDataHisID IN \n");
                        sb.append("(SELECT FID \n");
                        sb.append("FROM T_HR_BENEFITDATAHis  \n");
                        sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
                        sb.append("AND FAccountDetailId = ? )");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, beforePeriodInfo.getId().toString(), accountDetailID});
                        sb = new StringBuffer();
                        sb.append("INSERT INTO T_HR_BenefitReportTable ");
                        sb.append("( FPersonID, FCmpPeriodID , FAccountTypeID, ");
                        sb.append(this.makeInsertBeneReportSql(ctx, hrOrgUnitId));
                        sb.append(" FAccountID, FBenefitID,FAdminOrgUnitHis,FPositionHis)\n");
                        sb.append("select FPersonID, '").append(dataPeriod.getId().toString()).append("' , FAccountTypeID,");
                        sb.append(this.makeInsertBeneReportZeroSql(ctx, hrOrgUnitId));
                        sb.append(" FAccountID, FBenefitID,FAdminOrgUnitHis,FPositionHis");
                        sb.append(" from T_HR_BenefitReportTable ");
                        sb.append(" where faccountID = ? and faccountTypeID = ? and FCmpPeriodID = ? ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{accountID, accountTypeID, beforePeriodInfo.getId().toString()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!copy) {
            sb = new StringBuffer();
            sb.append("DELETE FROM T_HR_BenefitDataDetailHis \n");
            sb.append("WHERE FBenefitDataHisID IN \n");
            sb.append("(SELECT FID \n");
            sb.append("FROM T_HR_BENEFITDATAHis  \n");
            sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
            sb.append("AND FAccountDetailId = ?)");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, curPeriodInfo.getId().toString(), accountDetailID});
            sb = new StringBuffer();
            sb.append("DELETE FROM T_HR_BENEFITDATAHis \n");
            sb.append("WHERE FHROrgUnitID = ? AND FCmpPeriodID = ? \n");
            sb.append("AND FAccountDetailId = ? ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hrOrgUnitId, curPeriodInfo.getId().toString(), accountDetailID});
            sb = new StringBuffer();
            sb.append("DELETE FROM T_HR_BenefitReportTable \n");
            sb.append(" where faccountID = ? and faccountTypeID = ? and FCmpPeriodID = ? ");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{accountID, accountTypeID, curPeriodInfo.getId().toString()});
        }
        sb = new StringBuffer();
        sb.append("update T_HR_AccountItemInput set FValue = 0 \n");
        sb.append(" where fid in \n");
        sb.append("\t(select aii.FID \n");
        sb.append("\tfrom T_HR_AccountItemInput aii \n");
        sb.append("\tinner join T_HR_Item i on i.FID = aii.FItemID \n");
        sb.append("\twhere aii.Faccountdetailid = '").append(accountDetailID).append("' \n");
        sb.append(" and (i.FBenefitItemNumber ='").append("Emp_Accr").append("' \n");
        sb.append(" or i.FBenefitItemNumber ='").append("Com_Accr").append("') \n");
        sb.append(" )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update T_HR_AccountDetail set FCurPeriodID = '");
        sb.append(settlePeriodID).append("' \n");
        sb.append(" where FID = ? ");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{accountDetailID});
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private String makeInsertBeneReportZeroSql(Context ctx, String hrOrgUnitId) throws BOSException {
        StringBuffer resultString = new StringBuffer();
        IRowSet rows = this.getBeneItemRows(ctx, hrOrgUnitId);
        String number = null;
        try {
            while (rows.next()) {
                number = rows.getString("FNumber");
                if ("Base_insu".equals(number) || "Emp_insu".equals(number) || "Com_insu".equals(number) || "Emp_Accr".equals(number) || "Com_Accr".equals(number)) {
                    resultString.append("0 as ");
                    resultString.append("F");
                    resultString.append(number);
                    resultString.append(", ");
                    continue;
                }
                resultString.append("F");
                resultString.append(number);
                resultString.append(", ");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultString.toString();
    }

    private boolean isExistAdjustDataSPUse_AccountID(Context ctx, String tmpTableName, String accountTypeId, String cmpPeriodId) throws BOSException {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select top 1 bad.fid from t_hr_benefitadjustdata bad \n");
        selectSql.append(" inner join " + tmpTableName + " tt on bad.faccountdetailid = tt.FAccountId  ");
        selectSql.append(" where  bad.fhrorgunitid = ? and bad.fcmpperiodid = ? \n");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{hrOrgUnitId, cmpPeriodId});
            if (rows.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

