/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.hr.base.app.HRDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbUtil
extends HRDbUtil {
    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    ps.setNull(i + 1, 12);
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    ps.setNull(i + 1, 12);
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }
}

