/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.benefit.AccBeneAppendCollection;
import com.kingdee.eas.hr.benefit.AccBeneAppendFactory;
import com.kingdee.eas.hr.benefit.AccBeneAppendInfo;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountFactory;
import com.kingdee.eas.hr.benefit.AccountInfo;
import com.kingdee.eas.hr.benefit.AccountItemInputCollection;
import com.kingdee.eas.hr.benefit.AccountItemInputFactory;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.AccountShiftSumCollection;
import com.kingdee.eas.hr.benefit.AccountShiftSumFactory;
import com.kingdee.eas.hr.benefit.AccountShiftSumInfo;
import com.kingdee.eas.hr.benefit.BaseInsuHistoryInfo;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitRuleFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitRuleInfo;
import com.kingdee.eas.hr.benefit.BenefitRulePersonRelInfo;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.IAccBeneAppend;
import com.kingdee.eas.hr.benefit.IAccount;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IAccountItemInput;
import com.kingdee.eas.hr.benefit.IAccountShiftSum;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.IBenefitRuleFacade;
import com.kingdee.eas.hr.benefit.IItem;
import com.kingdee.eas.hr.benefit.ItemCollection;
import com.kingdee.eas.hr.benefit.ItemFactory;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.benefit.app.AbstractEmpManagerFacadeControllerBean;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmpManagerFacadeControllerBean
extends AbstractEmpManagerFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String ATID = "accountType.id";
    private static final String PID = "person.id";
    public String accId = null;

    protected void _addNewAccAndAccDetail(Context ctx, IObjectValue accountValue, IObjectCollection accountDetailColl, IObjectCollection accountItemInputColl, IObjectCollection accountShiftSumColl, IObjectCollection accBeneAppendColl) throws BOSException, EmpAccountManagerException, EASBizException {
        int j;
        int size;
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        IAccount iAccount = AccountFactory.getLocalInstance(ctx);
        IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getLocalInstance(ctx);
        IAccountItemInput iAccountItemInput = AccountItemInputFactory.getLocalInstance(ctx);
        IAccountShiftSum iAccountShiftSum = AccountShiftSumFactory.getLocalInstance(ctx);
        IAccBeneAppend iAccBeneAppend = AccBeneAppendFactory.getLocalInstance(ctx);
        AccountInfo aInfo = (AccountInfo)accountValue;
        AccountItemInputInfo aiiInfo = null;
        AccountShiftSumInfo assInfo = null;
        AccBeneAppendInfo abaInfo = null;
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> accTypeList = new ArrayList<String>();
        String account = null;
        this.checkAccountInPersonOnly(ctx, aInfo);
        IObjectPK pk = iAccount.addnew((CoreBaseInfo)aInfo);
        accountValue.put("id", (Object)BOSUuid.read((String)pk.toString()));
        AccountDetailInfo detail = null;
        HashMap<String, String> periodMap = new HashMap<String, String>();
        if (accountDetailColl.size() > 0) {
            CoreBaseCollection adColl = new CoreBaseCollection();
            int size2 = accountDetailColl.size();
            for (int i = 0; i < size2; ++i) {
                detail = ((AccountDetailCollection)accountDetailColl).get(i);
                detail.setAccount(aInfo);
                periodMap.put(detail.getAccountType().getId().toString(), detail.getCurPeriod().getId().toString());
                accTypeList.add(i, detail.getAccountType().getId().toString());
                adColl.add((CoreBaseInfo)detail);
            }
            account = pk.toString();
            this.checkAccTypeOnly(ctx, accTypeList, account);
            Result result = iAccountDetail.addnew(adColl);
            if (result != null && result.size() > 0) {
                Exception exp = null;
                for (int i = 0; i < result.size(); ++i) {
                    exp = result.getLineResult(i).getException();
                    if (exp == null || !(exp instanceof EASBizException)) continue;
                    throw (EASBizException)((Object)exp);
                }
            }
        }
        int size3 = accountDetailColl.size();
        for (int i = 0; i < size3; ++i) {
            detail = ((AccountDetailCollection)accountDetailColl).get(i);
            detail.setAccount(aInfo);
            if (detail.getBenefitRule() == null) continue;
            iBenefitRuleFacade.processBrAndPer(aInfo.getPerson(), null, detail.getBenefitRule());
        }
        size3 = accountItemInputColl.size();
        for (int j2 = 0; j2 < size3; ++j2) {
            aiiInfo = ((AccountItemInputCollection)accountItemInputColl).get(j2);
            set.add(aiiInfo.get("atInfo").toString());
        }
        String personID = (String)aiiInfo.get("perID");
        Map map = this.getDetailInfo(ctx, set, personID);
        HashMap stateMap = this.getBaseInsuState(ctx, accTypeList);
        ArrayList<Object[]> mainList = new ArrayList<Object[]>();
        Object[] objects = null;
        Date createTime = new Date(new java.util.Date().getTime());
        StringBuffer ins = new StringBuffer();
        ins.append(" insert into t_hr_baseinsuhistory ( \n");
        ins.append("FID,FPersonID,FAccountID,FAccountTypeID,FBenefitID, \n");
        ins.append("FCmpperiodID,FChangeTime,FBaseInsu ) values \n");
        ins.append("(?,?,?,?,?,?,?,? )");
        if (accountItemInputColl.size() > 0) {
            CoreBaseCollection aiiInfoCol = new CoreBaseCollection();
            size = accountItemInputColl.size();
            for (j = 0; j < size; ++j) {
                aiiInfo = ((AccountItemInputCollection)accountItemInputColl).get(j);
                aiiInfo.setAccountDetail((AccountDetailInfo)map.get(aiiInfo.get("atInfo").toString() + aiiInfo.get("perID")));
                aiiInfoCol.add((CoreBaseInfo)aiiInfo);
                if (!aiiInfo.getItem().getBenefitItemNumber().equals("Base_insu") || stateMap.get((String)aiiInfo.get("atInfo")) == null) continue;
                String bihfid = BOSUuid.create((BOSObjectType)new BaseInsuHistoryInfo().getBOSType()).toString();
                String accType = aiiInfo.get("atInfo").toString();
                String cmpPeriod = periodMap.get(accType).toString();
                String benefit = aiiInfo.getItem().getBenefit().getId().toString();
                objects = new Object[]{bihfid, personID, account, accType, benefit, cmpPeriod, createTime, aiiInfo.getValue()};
                mainList.add(objects);
            }
            iAccountItemInput.addnew(aiiInfoCol);
        }
        if (mainList.size() > 0) {
            HrExDbUtil.executeBatch(ctx, ins.toString(), mainList);
        }
        if (accountShiftSumColl.size() > 0) {
            CoreBaseCollection assInfoCol = new CoreBaseCollection();
            size = accountShiftSumColl.size();
            for (j = 0; j < size; ++j) {
                assInfo = ((AccountShiftSumCollection)accountShiftSumColl).get(j);
                assInfo.setAccountDetail((AccountDetailInfo)map.get(assInfo.get("atInfo").toString() + assInfo.get("perID").toString()));
                assInfoCol.add((CoreBaseInfo)assInfo);
            }
            iAccountShiftSum.addnew(assInfoCol);
        }
        if (accBeneAppendColl.size() > 0) {
            CoreBaseCollection abaInfoCol = new CoreBaseCollection();
            size = accBeneAppendColl.size();
            for (j = 0; j < size; ++j) {
                abaInfo = ((AccBeneAppendCollection)accBeneAppendColl).get(j);
                abaInfo.setAccountDetail((AccountDetailInfo)map.get(abaInfo.get("atInfo").toString() + abaInfo.get("perID").toString()));
                abaInfoCol.add((CoreBaseInfo)abaInfo);
            }
            iAccBeneAppend.addnew(abaInfoCol);
        }
    }

    private HashMap getBaseInsuState(Context ctx, List accTypeList) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from t_hr_benefitutil ");
        sql.append(" where ftype ='BASEINSU' ");
        sql.append(" and fhrorgunitid ='" + hrOrgUnit + "'");
        sql.append(" and fvalue ='true' ");
        sql.append(" and faccounttypeid in");
        sql.append(BenefitUtils.getStrFromList(accTypeList));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String accType = rs.getString("faccounttypeid");
                map.put(accType, "true");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private HashMap getCurPeriodIDs(Context ctx, List accTypeList) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from t_hr_benefitutil ");
        sql.append(" where ftype ='CURPERIOD' ");
        sql.append(" and fhrorgunitid ='" + hrOrgUnit + "'");
        sql.append(" and faccounttypeid in");
        sql.append(BenefitUtils.getStrFromList(accTypeList));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String accType = rs.getString("faccounttypeid");
                String fcmpID = rs.getString("fvalue");
                map.put(accType, fcmpID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void checkAccTypeOnly(Context ctx, List accTypeList, String accID) throws BOSException, EmpAccountManagerException {
        int size = accTypeList.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < accTypeList.size(); ++j) {
                if (!accTypeList.get(i).equals(accTypeList.get(j))) continue;
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCDETAILPERSON);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FID from t_hr_AccountDetail \n");
        sb.append(" where FAccountID ='" + accID + "'");
        sb.append(" and FAccountTypeID in");
        sb.append(BenefitUtils.getStrFromList(accTypeList));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.size() > 0) {
            throw new EmpAccountManagerException(EmpAccountManagerException.ACCDETAILPERSON);
        }
    }

    private Map getDetailInfo(Context ctx, Set set, String perID) throws BOSException {
        HashMap<String, AccountDetailInfo> map = new HashMap<String, AccountDetailInfo>();
        StringBuffer sb = new StringBuffer();
        sb.append("select ad.FID as FID,ad.FAccountTypeID as FAccountTypeID,a.FPersonID as FPersonID \n");
        sb.append(" from T_HR_AccountDetail ad \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.FID \n");
        sb.append(" where ad.FAccountTypeID in \n");
        sb.append(BenefitUtils.getStrFromSet(set));
        sb.append(" and a.FPersonID ='" + perID + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                String fid = rs.getString("FID");
                if (fid == null) continue;
                AccountDetailInfo info = new AccountDetailInfo();
                info.setId(BOSUuid.read((String)fid));
                String key = rs.getString("FAccountTypeID") + rs.getString("FPersonID");
                map.put(key, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    protected void _updateAccAndAccDetail(Context ctx, IObjectValue accountValue, IObjectCollection accountDetailColl, IObjectPK accountPK, ArrayList accountDetailPK, IObjectCollection accountItemInputColl, IObjectCollection accountShiftSumColl, ArrayList atListDel, IObjectCollection accBeneAppendColl) throws BOSException, EmpAccountManagerException, EASBizException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        IAccount iAccount = AccountFactory.getLocalInstance(ctx);
        IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getLocalInstance(ctx);
        IAccountShiftSum iAccountShiftSum = AccountShiftSumFactory.getLocalInstance(ctx);
        IAccBeneAppend iAccBeneAppend = AccBeneAppendFactory.getLocalInstance(ctx);
        IBenefitInvokeFacade ibif = BenefitInvokeFacadeFactory.getLocalInstance(ctx);
        IObjectPK pk = null;
        AccountDetailInfo adInfo = null;
        AccountItemInputInfo aiiInfo = null;
        AccountShiftSumInfo assInfo = null;
        StringBuffer sb = null;
        StringBuffer sb1 = null;
        HashMap cmp = null;
        Connection con = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        BigDecimal zero = new BigDecimal(0);
        Date createTime = null;
        StringBuffer ins = null;
        String personID = null;
        String account = null;
        String cmpPeriod = null;
        String benefit = null;
        iAccount.update(accountPK, (CoreBaseInfo)((AccountInfo)accountValue));
        try {
            int size = accountDetailColl.size();
            for (int i = 0; i < size; ++i) {
                int j;
                adInfo = ((AccountDetailCollection)accountDetailColl).get(i);
                if (accountDetailPK.get(i) == null) {
                    pk = iAccountDetail.addnew((CoreBaseInfo)((AccountDetailCollection)accountDetailColl).get(i));
                    adInfo.setId(BOSUuid.read((String)pk.toString()));
                } else {
                    if (adInfo.getPayState() != null && adInfo.getPayState().equals((Object)PayTypeEnum.STOPPAY)) {
                        BenefitUtils.cleanBenefitData(ctx, adInfo.getId().toString());
                    }
                    pk = (IObjectPK)accountDetailPK.get(i);
                    iAccountDetail.update(pk, (CoreBaseInfo)adInfo);
                }
                if (adInfo.getBenefitRule() != null) {
                    iBenefitRuleFacade.processBrAndPer(adInfo.getAccount().getPerson(), (BenefitRuleInfo)adInfo.get("oldBr"), adInfo.getBenefitRule());
                }
                boolean flag1 = false;
                CoreBaseCollection assInfoCol = new CoreBaseCollection();
                con = EJBFactory.getConnection((Context)ctx);
                stmt1 = con.createStatement();
                int sum = accountShiftSumColl.size();
                for (int j2 = 0; j2 < sum; ++j2) {
                    assInfo = ((AccountShiftSumCollection)accountShiftSumColl).get(j2);
                    if (!assInfo.get("atInfo").toString().equals(adInfo.getAccountType().getId().toString())) continue;
                    if (assInfo.getId() != null) {
                        cmp = this.checkExistAss(ctx, assInfo.getBenefit().getId().toString(), adInfo.getId().toString());
                        if (cmp.size() <= 0 || assInfo.getShiftSum() == null && assInfo.getShiftDate() == null && assInfo.getCmpPeriod() == null) continue;
                        sb1 = new StringBuffer();
                        sb1.append("update T_HR_AccountShiftSum SET ");
                        if (assInfo.getShiftSum() != null) {
                            if ("0E-8".equals(assInfo.getShiftSum().toString())) {
                                sb1.append(" fShiftSum = 0.0,");
                            } else {
                                sb1.append(" fShiftSum = " + assInfo.getShiftSum() + ",");
                            }
                        }
                        if (assInfo.getShiftDate() != null) {
                            sb1.append(" fShiftDate = {ts'" + assInfo.getShiftDate().toString() + "'} ,");
                        }
                        if (assInfo.getCmpPeriod() != null) {
                            sb1.append(" fCmpPeriodID = '");
                            sb1.append(assInfo.getCmpPeriod().getId().toString());
                            sb1.append("' ,");
                        }
                        sb1.deleteCharAt(sb1.length() - 1);
                        sb1.append(" where FBenefitID = '");
                        sb1.append(assInfo.getBenefit().getId().toString());
                        sb1.append("' and FAccountDetailID = '");
                        sb1.append(adInfo.getId().toString());
                        sb1.append("'");
                        stmt1.addBatch(sb1.toString());
                        flag1 = true;
                        continue;
                    }
                    assInfo.setAccountDetail(adInfo);
                    assInfoCol.addObject((IObjectValue)assInfo);
                }
                if (flag1) {
                    stmt1.executeBatch();
                }
                if (assInfoCol.size() > 0) {
                    iAccountShiftSum.addnew(assInfoCol);
                }
                boolean flag2 = false;
                AccBeneAppendInfo abaInfo = null;
                CoreBaseCollection abaInfoCol = new CoreBaseCollection();
                stmt1 = con.createStatement();
                int sum2 = accBeneAppendColl.size();
                for (int k = 0; k < sum2; ++k) {
                    abaInfo = ((AccBeneAppendCollection)accBeneAppendColl).get(k);
                    if (!abaInfo.get("atInfo").toString().equals(adInfo.getAccountType().getId().toString())) continue;
                    if (abaInfo.getId() != null) {
                        sb1 = new StringBuffer();
                        sb1.append("update T_HR_AccBeneAppend set ");
                        if (abaInfo.getBenfitNum() != null) {
                            sb1.append(" fBenfitNum ='" + abaInfo.getBenfitNum().replaceAll("'", "''") + "', ");
                        }
                        sb1.append(" fBenefitSeq = '" + abaInfo.getBenefitSeq() + "' ");
                        if (abaInfo.getBenefitName() != null) {
                            sb1.append(", fBenefitName = '" + abaInfo.getBenefitName() + "'");
                        }
                        if (abaInfo.getBenefitCardID() != null) {
                            sb1.append(" ,fBenefitCardID = '" + abaInfo.getBenefitCardID() + "'");
                        }
                        sb1.append(" where FBenefitID = '");
                        sb1.append(abaInfo.getBenefit().getId().toString());
                        sb1.append("' and FAccountDetailID = '");
                        sb1.append(adInfo.getId().toString());
                        sb1.append("'");
                        stmt1.addBatch(sb1.toString());
                        flag2 = true;
                        continue;
                    }
                    abaInfo.setAccountDetail(adInfo);
                    abaInfoCol.add((CoreBaseInfo)abaInfo);
                }
                if (flag2) {
                    stmt1.executeBatch();
                }
                if (abaInfoCol.size() > 0) {
                    iAccBeneAppend.addnew(abaInfoCol);
                }
                boolean flag3 = false;
                boolean flag4 = false;
                String itemId = null;
                String accountDetailId = null;
                HashSet<String> itemIdSet = new HashSet<String>();
                Map map = new HashMap();
                String bosType = new AccountItemInputInfo().getBOSType().toString();
                String accType = adInfo.getAccountType().getId().toString();
                if (adInfo.getCurPeriod() != null) {
                    cmpPeriod = adInfo.getCurPeriod().getId().toString();
                }
                ArrayList<Object[]> mainList = null;
                Object[] objects = null;
                boolean enBaseInsuRecord = ibif.enableBaseInsuRecord(accType);
                if (enBaseInsuRecord) {
                    mainList = new ArrayList<Object[]>();
                    createTime = new Date(new java.util.Date().getTime());
                    AccountInfo accInfo = (AccountInfo)accountValue;
                    account = accInfo.getId().toString();
                    personID = accInfo.getPerson().getId().toString();
                    ins = new StringBuffer();
                    ins.append(" insert into t_hr_baseinsuhistory ( \n");
                    ins.append("FID,FPersonID,FAccountID,FAccountTypeID,FBenefitID, \n");
                    ins.append("FCmpperiodID,FChangeTime,FBaseInsu ) values \n");
                    ins.append("(?,?,?,?,?,?,?,? )");
                }
                stmt1 = con.createStatement();
                stmt2 = con.createStatement();
                int sum3 = accountItemInputColl.size();
                for (j = 0; j < sum3; ++j) {
                    aiiInfo = ((AccountItemInputCollection)accountItemInputColl).get(j);
                    aiiInfo.setAccountDetail(adInfo);
                    if (!aiiInfo.get("atInfo").equals(adInfo.getAccountType().getId().toString())) continue;
                    if (aiiInfo.getItem() != null && aiiInfo.getItem().getId() != null) {
                        itemId = aiiInfo.getItem().getId().toString();
                        accountDetailId = adInfo.getId().toString();
                    } else {
                        aiiInfo.getItem();
                    }
                    if (itemId == null) continue;
                    itemIdSet.add(itemId);
                }
                map = this.getFID(ctx, itemIdSet, accountDetailId);
                sum3 = accountItemInputColl.size();
                for (j = 0; j < sum3; ++j) {
                    String bihfid;
                    aiiInfo = ((AccountItemInputCollection)accountItemInputColl).get(j);
                    aiiInfo.setAccountDetail(adInfo);
                    if (!aiiInfo.get("atInfo").equals(adInfo.getAccountType().getId().toString())) continue;
                    itemId = aiiInfo.getItem().getId().toString();
                    accountDetailId = adInfo.getId().toString();
                    if (map.containsKey(itemId + "@@" + accountDetailId)) {
                        sb = new StringBuffer();
                        sb.append("update T_HR_AccountItemInput set fValue = ");
                        if (aiiInfo.getValue().compareTo(zero) == 0) {
                            sb.append(zero);
                        } else {
                            sb.append(aiiInfo.getValue());
                        }
                        sb.append(" where FItemID ='" + itemId + "'");
                        sb.append(" and FAccountDetailID ='" + accountDetailId + "'");
                        stmt1.addBatch(sb.toString());
                        flag3 = true;
                        if (!enBaseInsuRecord || !aiiInfo.getItem().getBenefitItemNumber().equals("Base_insu")) continue;
                        BigDecimal fvalue = null;
                        fvalue = map.get(itemId + "@@" + accountDetailId) != null ? (BigDecimal)map.get(itemId + "@@" + accountDetailId) : new BigDecimal(0);
                        if (fvalue.compareTo(aiiInfo.getValue()) == 0) continue;
                        bihfid = BOSUuid.create((BOSObjectType)new BaseInsuHistoryInfo().getBOSType()).toString();
                        benefit = aiiInfo.getItem().getBenefit().getId().toString();
                        objects = new Object[]{bihfid, personID, account, accType, benefit, cmpPeriod, createTime, aiiInfo.getValue()};
                        mainList.add(objects);
                        continue;
                    }
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append("insert into T_HR_AccountItemInput(FID, FVALUE, FITEMID, FACCOUNTDETAILID) values('");
                    sb2.append(BOSUuid.create((String)bosType).toString() + "',");
                    sb2.append(aiiInfo.getValue() + ",'");
                    sb2.append(itemId + "','");
                    sb2.append(accountDetailId + "')");
                    stmt2.addBatch(sb2.toString());
                    flag4 = true;
                    if (!enBaseInsuRecord || !aiiInfo.getItem().getBenefitItemNumber().equals("Base_insu")) continue;
                    bihfid = BOSUuid.create((BOSObjectType)new BaseInsuHistoryInfo().getBOSType()).toString();
                    benefit = aiiInfo.getItem().getBenefit().getId().toString();
                    objects = new Object[]{bihfid, personID, account, accType, benefit, cmpPeriod, createTime, aiiInfo.getValue()};
                    mainList.add(objects);
                }
                if (flag3) {
                    stmt1.executeBatch();
                }
                if (flag4) {
                    stmt2.executeBatch();
                }
                if (!enBaseInsuRecord) continue;
                HrExDbUtil.executeBatch(ctx, ins.toString(), mainList);
            }
            stmt2 = con.createStatement();
            int count = atListDel.size();
            for (int j = 0; j < count; ++j) {
                String atDelID = atListDel.get(j).toString();
                stmt2.addBatch("delete t_hr_accountshiftsum where faccountDetailID = '" + atDelID + "'");
                stmt2.addBatch("delete t_hr_accountiteminput where faccountDetailID = '" + atDelID + "'");
                stmt2.addBatch("delete t_hr_accountdetail where fid = '" + atDelID + "'");
            }
            stmt2.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt1);
                SQLUtils.cleanup(stmt2);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(stmt1);
        SQLUtils.cleanup((Statement)stmt2);
        SQLUtils.cleanup((Connection)con);
    }

    private Map getFID(Context ctx, Set set1, String accountDetailID) throws BOSException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select FItemID,FAccountDetailID,FValue \n");
        sb.append(" from T_HR_AccountItemInput where FItemID in \n");
        sb.append(BenefitUtils.getStrFromSet(set1));
        sb.append(" and FAccountDetailID ='" + accountDetailID + "' ");
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String key = rs.getString("FItemID") + "@@" + rs.getString("FAccountDetailID");
                BigDecimal fvalue = rs.getBigDecimal("FValue");
                map.put(key, fvalue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void checkDup(Context ctx, String id, String number) throws BOSException, EmpAccountManagerException {
        IRowSet rows;
        if (StringUtils.isEmpty((String)number)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_AccBeneAppend where fBenfitNum = '");
        sql.append(number + "'");
        if (!StringUtils.isEmpty((String)id)) {
            sql.append(" and fid != '" + id + "'");
        }
        if ((rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).size() > 0) {
            throw new EmpAccountManagerException(EmpAccountManagerException.BENEFITNUM_NOT_DUP);
        }
    }

    private HashMap checkExistAss(Context ctx, String bInfo, String adInfo) throws BOSException {
        String selectSql = "select FShiftDate, FCmpPeriodID from T_HR_AccountShiftSum where FBenefitID = ? and FAccountDetailID = ?";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{bInfo, adInfo});
            while (iRow.next()) {
                map.put("cmp", iRow.getString("FCmpPeriodID"));
                map.put("date", iRow.getDate("FShiftDate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public void checkAccountInPersonOnly(Context ctx, AccountInfo accountInfo) throws BOSException, EmpAccountManagerException {
        IAccount iAccount = AccountFactory.getLocalInstance(ctx);
        AccountCollection coll = iAccount.getAccountCollection("select * where person.id = '" + accountInfo.getPerson().getId().toString() + "'" + " and hrOrgUnit.id = '" + accountInfo.getHrOrgUnit().getId().toString() + "'");
        if (coll.size() > 0) {
            throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTINPERSON);
        }
    }

    protected void _submitAll(Context ctx, IObjectCollection accountColl, IObjectCollection accountDetailColl, IObjectPK[] pkList) throws BOSException, EASBizException {
        IAccount iAccount = AccountFactory.getLocalInstance(ctx);
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        HashMap<Object, AccountInfo> map = new HashMap<Object, AccountInfo>();
        AccountInfo accInfo = null;
        AccountDetailInfo adInfo = null;
        CoreBaseCollection newColl = null;
        CoreBaseCollection updateColl = null;
        try {
            newColl = new CoreBaseCollection();
            updateColl = new CoreBaseCollection();
            int size = accountColl.size();
            for (int i = 0; i < size; ++i) {
                accInfo = ((AccountCollection)accountColl).get(i);
                if (accInfo.getId() == null) {
                    accInfo.setId(BOSUuid.create((BOSObjectType)new AccountInfo().getBOSType()));
                    newColl.add((CoreBaseInfo)accInfo);
                } else {
                    updateColl.add((CoreBaseInfo)accInfo);
                }
                map.put(accInfo.get("pid"), accInfo);
            }
            iAccount.addnew(newColl);
            iAccount.update(updateColl);
            this.checkPersonAccountOnly(ctx, accountColl);
            newColl = new CoreBaseCollection();
            updateColl = new CoreBaseCollection();
            AccountDetailCollection newCollChk = new AccountDetailCollection();
            AccountDetailCollection updCollChk = new AccountDetailCollection();
            int sum = accountDetailColl.size();
            for (int j = 0; j < sum; ++j) {
                adInfo = ((AccountDetailCollection)accountDetailColl).get(j);
                if (adInfo.getAccount() == null) {
                    adInfo.setAccount((AccountInfo)map.get(adInfo.get("pid")));
                }
                if (adInfo.getId() == null) {
                    adInfo.setId(BOSUuid.create((BOSObjectType)new AccountDetailInfo().getBOSType()));
                    newColl.add((CoreBaseInfo)adInfo);
                    newCollChk.add(adInfo);
                    continue;
                }
                updateColl.add((CoreBaseInfo)adInfo);
                updCollChk.add(adInfo);
                if (adInfo.getPayState() == null || !adInfo.getPayState().equals((Object)PayTypeEnum.STOPPAY)) continue;
                BenefitUtils.cleanBenefitData(ctx, adInfo.getId().toString());
            }
            this.checkAccountsDump(ctx, newCollChk, updCollChk);
            iAccountDetail.addnew(newColl);
            iAccountDetail.update(updateColl);
            this.setAiiInfo(ctx, accountDetailColl);
            this.updateBenefitRule(ctx, accountDetailColl);
            this.checkPersonAccTypeOnly(ctx, accountDetailColl);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e1) {
            throw e1;
        }
    }

    protected void updateBenefitRule(Context ctx, IObjectCollection accountDetailColl) throws BOSException, EASBizException {
        int i;
        BenefitRuleInfo oldBrInfo = null;
        String personID = null;
        String brID = null;
        AccountDetailInfo adInfo = null;
        String delSql = "delete T_HR_BenefitRulePersonRel WHERE FPERSONID = ? AND FBENEFITRULEID = ?";
        String selSql = "select fid from T_HR_BenefitRulePersonRel WHERE FPERSONID = ? AND FBENEFITRULEID = ?";
        String insertSql = "insert into T_HR_BenefitRulePersonRel (FID,FPersonID,FBenefitRuleID) values (?,?,?)";
        IRowSet rows = null;
        Object[] objects = null;
        ArrayList<Object[]> mainList1 = new ArrayList<Object[]>();
        ArrayList<Object[]> mainList2 = new ArrayList<Object[]>();
        int size = accountDetailColl.size();
        for (i = 0; i < size; ++i) {
            adInfo = (AccountDetailInfo)accountDetailColl.getObject(i);
            personID = (String)adInfo.get("pid");
            if (adInfo.get("oldBr") == null) continue;
            oldBrInfo = (BenefitRuleInfo)adInfo.get("oldBr");
            objects = new Object[]{personID, oldBrInfo.getId().toString()};
            mainList1.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, delSql, mainList1);
        size = accountDetailColl.size();
        for (i = 0; i < size; ++i) {
            adInfo = (AccountDetailInfo)accountDetailColl.getObject(i);
            personID = (String)adInfo.get("pid");
            if (adInfo.getBenefitRule() == null) continue;
            brID = adInfo.getBenefitRule().getId().toString();
            rows = DbUtil.executeQuery((Context)ctx, (String)selSql, (Object[])new Object[]{personID, brID});
            if (rows.size() != 0) continue;
            String id = BOSUuid.create((BOSObjectType)new BenefitRulePersonRelInfo().getBOSType()).toString();
            objects = new Object[]{id, personID, brID};
            mainList2.add(objects);
        }
        HrExDbUtil.executeBatch(ctx, insertSql, mainList2);
    }

    public void checkPersonAccountOnly(Context ctx, IObjectCollection accountColl) throws BOSException, EASBizException {
        try {
            String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            ArrayList<String> perIDList = new ArrayList<String>();
            AccountInfo accInfo = null;
            int size = accountColl.size();
            for (int i = 0; i < size; ++i) {
                accInfo = (AccountInfo)accountColl.getObject(i);
                perIDList.add(accInfo.getPerson().getId().toString());
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select count(*) as count from t_hr_account ");
            sql.append("where fhrorgunitid ='" + hrOrgUnit + "' ");
            sql.append("and fpersonid in");
            sql.append(BenefitUtils.getStrFromList(perIDList));
            sql.append("group by fpersonid");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                int count = row.getInt("count");
                if (count <= 1) continue;
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTINPERSON);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void checkPersonAccTypeOnly(Context ctx, IObjectCollection accountDetailColl) throws BOSException, EmpAccountManagerException {
        ArrayList<String> perIDList = new ArrayList<String>();
        ArrayList<String> atIDList = new ArrayList<String>();
        AccountDetailInfo adInfo = null;
        int size = accountDetailColl.size();
        for (int i = 0; i < size; ++i) {
            adInfo = ((AccountDetailCollection)accountDetailColl).get(i);
            perIDList.add(adInfo.getAccount().getPerson().getId().toString());
            atIDList.add(adInfo.getAccountType().getId().toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select a.fpersonid as personID,count(distinct ad.fid) as count from t_hr_accountdetail ad");
        sb.append(" inner join t_hr_account a on ad.faccountid = a.fid ");
        sb.append(" where a.fpersonid in");
        sb.append(BenefitUtils.getStrFromList(perIDList));
        sb.append(" and ad.faccountTypeID in ");
        sb.append(BenefitUtils.getStrFromList(atIDList));
        sb.append(" group by a.fpersonid,ad.faccounttypeid ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("count") <= 1) continue;
                String perID = rows.getString("personID");
                PersonInfo info = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(perID));
                Object[] param = new Object[]{info.getName()};
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCDETAILPERSON, param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    private void setAiiInfo(Context ctx, IObjectCollection accountDetailColl) throws EASBizException, BOSException {
        String tmpTable = null;
        TempTablePool pool = null;
        try {
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            Object[] objects = null;
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            AccountDetailInfo adInfo = null;
            int adSize = accountDetailColl.size();
            for (int i = 0; i < adSize; ++i) {
                adInfo = ((AccountDetailCollection)accountDetailColl).get(i);
                objects = new Object[]{adInfo.getId().toString(), adInfo.getAccountType().getId().toString()};
                list.add(objects);
            }
            String cSql = "create TABLE tmp (FAccountDetailID varchar(44) ,FAccountTypeID varchar(44))";
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = pool.createTempTable(cSql);
            String sbInsert = "insert into " + tmpTable + " (FAccountDetailID,FAccountTypeID) values (?,?)";
            HrExDbUtil.executeBatch(ctx, sbInsert.toString(), list);
            String bosType = new AccountItemInputInfo().getBOSType().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into t_hr_accountiteminput (FID,FItemID,FAccountDetailID,FValue) \n");
            sql.append(" select newbosid('" + bosType + "') as FID,");
            sql.append(" item.FID as FItemID,");
            sql.append(" tmp.FAccountDetailID as FAccountDetailID,0 as FValue");
            sql.append(" from T_HR_Item as item ,T_HR_BenefitItem as bItem ,t_hr_benefit as b,");
            sql.append(tmpTable + " as tmp ");
            sql.append(" where item.FItemID = bItem.FID ");
            sql.append(" and item.fhrorgunitid = bItem.fhrorgunitid");
            sql.append(" and item.fbenefitid = b.fid ");
            sql.append(" and b.faccounttypeid = tmp.FAccountTypeID ");
            sql.append(" and bItem.FState = 1 ");
            sql.append(" and item.fhrorgunitid ='" + hrOrgUnitId + "'");
            sql.append(" and not exists (select * from t_hr_accountiteminput ");
            sql.append(" where faccountdetailid = tmp.faccountdetailid )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.dropTmpTable(ctx, pool, tmpTable);
                throw throwable;
            }
        }
        this.dropTmpTable(ctx, pool, tmpTable);
    }

    private void dropTmpTable(Context ctx, TempTablePool pool, String tableName) throws BOSException {
        try {
            if (tableName != null) {
                pool.releaseTable(tableName);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private void updateAiiInfo(Context ctx, AccountDetailInfo adInfo, List benefitIdList) throws EASBizException, BOSException {
        AccountItemInputInfo aiiInfo = null;
        ItemCollection biColl = null;
        BigDecimal zero = new BigDecimal(0);
        biColl = this.getExceptInnerColl(ctx, benefitIdList);
        AccountItemInputCollection accountItemInputColl = new AccountItemInputCollection();
        int count = biColl.size();
        for (int j = 0; j < count; ++j) {
            aiiInfo = new AccountItemInputInfo();
            aiiInfo.setAccountDetail(adInfo);
            aiiInfo.setItem(biColl.get(j));
            aiiInfo.setValue(zero);
            aiiInfo.put("atInfo", adInfo.getAccountType().getId().toString());
            accountItemInputColl.add(aiiInfo);
        }
        String selectSql = "select fid from T_HR_AccountItemInput where FItemID = ? and FAccountDetailID = ?";
        String insertSql = "insert into T_HR_AccountItemInput(FID, FVALUE, FITEMID, FACCOUNTDETAILID) values(?, ?, ?, ?)";
        String itemId = null;
        String accountDetailId = null;
        IRowSet rows = null;
        String bosType = new AccountItemInputInfo().getBOSType().toString();
        int sum = accountItemInputColl.size();
        for (int j = 0; j < sum; ++j) {
            aiiInfo = accountItemInputColl.get(j);
            aiiInfo.setAccountDetail(adInfo);
            if (!aiiInfo.get("atInfo").equals(adInfo.getAccountType().getId().toString())) continue;
            itemId = aiiInfo.getItem().getId().toString();
            accountDetailId = adInfo.getId().toString();
            rows = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{itemId, accountDetailId});
            if (rows.size() > 0) continue;
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{BOSUuid.create((String)bosType).toString(), aiiInfo.getValue(), itemId, accountDetailId});
        }
    }

    private ItemCollection getExceptInnerColl(Context ctx, List benefitIdList) throws BOSException {
        IItem iItem = ItemFactory.getLocalInstance(ctx);
        String oql = "where hrOrgUnit.id = '" + BenefitUtils.getCurrHROrgunitByCtx(ctx) + "' and benefit.id in " + BenefitUtils.getStrFromList(benefitIdList);
        return iItem.getItemCollection(oql);
    }

    protected IRowSet _setSaveId(Context ctx, HashMap atAndPerIdMap) throws BOSException, EASBizException {
        String perID = null;
        String atID = null;
        String maskString = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Iterator iter = atAndPerIdMap.keySet().iterator();
        IQueryExecutor iQe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.benefit.app.StoreAccountAndDetailQuery"));
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            perID = StringUtils.split((String)key, (String)"&&")[1];
            atID = atAndPerIdMap.get(key).toString();
            filterInfo.getFilterItems().add(new FilterItemInfo(PID, (Object)perID));
            filterInfo.getFilterItems().add(new FilterItemInfo(ATID, (Object)atID));
        }
        int size = atAndPerIdMap.size();
        for (int i = 0; i < size; ++i) {
            maskString = maskString != null ? maskString + "(#" + 2 * i + " and #" + (2 * i + 1) + ")" : "(#" + i + " and #" + (i + 1) + ")";
            if (i >= atAndPerIdMap.size() - 1) continue;
            maskString = maskString + " or ";
        }
        filterInfo.setMaskString(maskString);
        viewInfo.setFilter(filterInfo);
        iQe.setObjectView(viewInfo);
        iQe.getSQL();
        return iQe.executeQuery();
    }

    protected boolean _checkIsCheck(Context ctx, String accTypeID, String hrOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select top 1 bd.fid from t_hr_benefitdata bd inner join ");
        sql.append("t_hr_accountdetail ad on bd.faccountdetailid = ad.fid inner join ");
        sql.append("t_hr_accountType at on ad.faccounttypeid = at.fid inner join ");
        sql.append("t_org_hro hro on bd.fhrorgunitid = hro.fid where at.fid = ? ");
        sql.append("and hro.fid = ?");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accTypeID, hrOrgUnitID});
        return rows.size() > 0;
    }

    protected void _updateAiiInfo(Context ctx, List benefitIdList, IObjectCollection accDetailColl) throws BOSException, EASBizException {
        AccountDetailInfo adInfo = null;
        String accountTypeID = null;
        int sum = accDetailColl.size();
        for (int j = 0; j < sum; ++j) {
            adInfo = ((AccountDetailCollection)accDetailColl).get(j);
            accountTypeID = adInfo.getAccountType().getId().toString();
            if (adInfo.getId() == null) continue;
            this.updateAiiInfo(ctx, adInfo, this.getBenefitIDList(ctx, benefitIdList, accountTypeID));
        }
    }

    private List getBenefitIDList(Context ctx, List benefitIdList, String accountTypeID) throws BOSException, EASBizException {
        ArrayList<String> benefitList = new ArrayList<String>();
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_hr_benefit where faccounttypeid ='");
        sql.append(accountTypeID + "'");
        sql.append(" and fhrorgunitid ='");
        sql.append(hrOrgUnit + "'");
        sql.append(" and fid in");
        sql.append(BenefitUtils.getStrFromList(benefitIdList));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                benefitList.add(rows.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return benefitList;
    }

    protected void _updateAccountCurPeriod(Context ctx) throws BOSException, EASBizException {
        String str = "select * from T_HR_BenefitUtil where FType ='CURPERIOD'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str);
        StringBuffer sb = null;
        String hrOrgUnit = null;
        String accountTypeID = null;
        String cmpPeriodID = null;
        try {
            while (rows.next()) {
                hrOrgUnit = rows.getString("FHROrgUnitID");
                accountTypeID = rows.getString("FAccountTypeID");
                cmpPeriodID = rows.getString("FValue");
                if (StringUtils.isEmpty((String)hrOrgUnit) || StringUtils.isEmpty((String)accountTypeID) || StringUtils.isEmpty((String)cmpPeriodID)) continue;
                sb = new StringBuffer();
                sb.append(" update T_HR_AccountDetail set FCurPeriodID = '");
                sb.append(cmpPeriodID).append("' \n");
                sb.append(" where FAccountTypeID = '");
                sb.append(accountTypeID).append("' \n");
                sb.append(" and FAccountID in \n");
                sb.append(" (select fid from T_HR_Account where FHROrgUnitID = '");
                sb.append(hrOrgUnit).append("')");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
            String insSql = "insert into T_HR_BenefitUtil ( FType, FHROrgUnitID,FValue ) values ('DATAUPDATE','00000000-0000-0000-0000-000000000000CCE7AED4','true')";
            DbUtil.execute((Context)ctx, (String)insSql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected CmpPeriodInfo _getCurPeriodByAccountAndAccType(Context ctx, String accountID, String accountTypeID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FCurPeriodID from T_HR_AccountDetail \n");
        sb.append("where FAccountID ='").append(accountID).append("' \n");
        sb.append("and FAccountTypeId ='").append(accountTypeID).append("'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String curPeriod = null;
        CmpPeriodInfo cmpInfo = null;
        try {
            if (row.next()) {
                curPeriod = row.getString("FCurPeriodID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty(curPeriod)) {
            ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
            cmpInfo = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(curPeriod));
        }
        return cmpInfo;
    }

    protected List _getMinMaxPeriodOfAdminOrg(Context ctx, String admin, boolean includeSubOrg, String accountType) throws BOSException, EASBizException {
        ArrayList<CmpPeriodInfo> list = new ArrayList<CmpPeriodInfo>();
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select top 1 cmp.fid as PeriodID \n");
        sb.append(" from T_HR_AccountDetail ad \n");
        sb.append(" inner join T_HR_CmpPeriod cmp on ad.FCurPeriodID = cmp.FID \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.FID \n");
        sb.append(" left outer join T_HR_PersonPosition pp on a.FPersonID = pp.FPersonID \n");
        sb.append(" where pp.FPersonDep in ");
        sb.append(BenefitUtils.getStrFromSet(BenefitUtils.getUserRangeAdminOrg(ctx, admin, includeSubOrg)));
        if (!StringUtils.isEmpty((String)accountType)) {
            sb.append(" and ad.FAccountTypeID ='").append(accountType).append("'");
        }
        sb.append(" and a.fhrorgunitid = '").append(hrOrgUnit).append("'");
        sb.append(" and cmp.fhrorgunitid = '").append(hrOrgUnit).append("'");
        String minPeriodID = null;
        String maxPeriodID = null;
        ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
        IRowSet rows = null;
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)(sb.toString() + " order by cmp.FNumber ASC "));
            if (rows.next() && !StringUtils.isEmpty((String)(minPeriodID = rows.getString("PeriodID")))) {
                list.add(icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(minPeriodID)));
            }
            if ((rows = DbUtil.executeQuery((Context)ctx, (String)(sb.toString() + " order by cmp.FNumber DESC "))).next() && !StringUtils.isEmpty((String)(maxPeriodID = rows.getString("PeriodID")))) {
                list.add(icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(maxPeriodID)));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected HashSet _getUserRangeAdminOrg(Context ctx, String admin, boolean includeSubOrg) throws BOSException, EASBizException {
        HashSet<String> adminSet = new HashSet<String>();
        String curHROrgUnit = null;
        String curUser = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        curHROrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            throw new BOSException("current user is null !");
        }
        curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!StringUtils.isEmpty((String)admin)) {
            adminSet.add(admin);
            if (includeSubOrg) {
                IAdminOrgUnit iaou = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitInfo adminInfo = iaou.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(admin));
                String longNumber = adminInfo.getLongNumber();
                StringBuffer sql = new StringBuffer();
                sql.append(" select admin.fid as adminID from T_ORG_Admin admin \n");
                sql.append(" left outer join T_ORG_UnitRelation unitRel on unitRel.FFromUnitID = admin.FID \n");
                sql.append(" left outer join T_ORG_TypeRelation typeRel on unitRel.FTypeRelationID = typeRel.FID \n");
                sql.append("\t\tand typeRel.FID ='00000000-0000-0000-0000-0000000000100FE9F8B5' \n");
                sql.append(" left outer join T_PM_OrgRange range on range.FOrgID = admin.FID \n");
                sql.append("\t\tand range.FType = 20 \n");
                sql.append(" where unitRel.FToUnitID = '").append(curHROrgUnit).append("' \n");
                sql.append(" and range.FUserID = '").append(curUser).append("' \n");
                sql.append(" and FLongNumber like '").append(longNumber).append("%' ");
                try {
                    IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    String adminID = null;
                    while (rows.next()) {
                        adminID = rows.getString("adminID");
                        adminSet.add(adminID);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return adminSet;
    }

    protected HashSet _getUserRangeSubAdminOrg(Context ctx, AdminOrgUnitInfo admin, int subLevel) throws BOSException {
        HashSet<String> adminSet = new HashSet<String>();
        String curUser = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            throw new BOSException("current user is null !");
        }
        curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        int curAdminLevel = admin.getLevel();
        int subTotalLevel = curAdminLevel + subLevel;
        String longNumber = admin.getLongNumber();
        StringBuffer sb = new StringBuffer();
        sb.append("select FID from t_org_admin where ");
        sb.append("(FLongNumber = '").append(longNumber).append("' ");
        sb.append("or FLongNumber like '").append(longNumber).append("!%')");
        sb.append(" and flevel >=" + curAdminLevel);
        sb.append(" and flevel <=" + subTotalLevel);
        sb.append(" and FID in (");
        sb.append(BenefitUtils.getUserAdminOrgSql(curUser));
        sb.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String adminID = null;
        try {
            while (rows.next()) {
                adminID = rows.getString("FID");
                adminSet.add(adminID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminSet;
    }

    protected HashSet _getUserHRAdminOrg(Context ctx) throws BOSException, EASBizException {
        HashSet<String> adminSet = new HashSet<String>();
        String hrOrgUnitID = null;
        String userID = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            throw new BOSException("current user is null !");
        }
        userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation \n");
        sql.append("WHERE FToUnitID = '");
        sql.append(hrOrgUnitID);
        sql.append("' \n");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5' \n");
        sql.append("AND FFromUnitID IN \n");
        sql.append("( SELECT FOrgID FROM T_PM_OrgRange \n");
        sql.append("WHERE FUserID = '");
        sql.append(userID);
        sql.append("' \n");
        sql.append("AND FType = ");
        sql.append(20);
        sql.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                adminSet.add(rows.getString("FFromUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminSet;
    }

    protected boolean _hasUpdatePeriodData(Context ctx) throws BOSException, EASBizException {
        String sql = "select * from T_HR_BenefitUtil where FType ='DATAUPDATE' and FValue ='true'";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        return row.size() > 0;
    }

    protected void _cleanBenefitData(Context ctx, String accountDetailID) throws BOSException, EASBizException {
        String delDetail = "delete from T_HR_BenefitDataDetail where FBenefitDataID in (select fid from T_HR_BenefitData where FAccountDetailID ='" + accountDetailID + "')";
        String delData = "delete from T_HR_BenefitData Where FAccountDetailID = '" + accountDetailID + "'";
        DbUtil.execute((Context)ctx, (String)delDetail);
        DbUtil.execute((Context)ctx, (String)delData);
        IAccountDetail iad = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailInfo adInfo = iad.getAccountDetailInfo((IObjectPK)new ObjectStringPK(accountDetailID));
        String cmp = null;
        String accType = null;
        String accID = null;
        if (adInfo.getCurPeriod() != null) {
            cmp = adInfo.getCurPeriod().getId().toString();
        }
        if (adInfo.getAccountType() != null) {
            accType = adInfo.getAccountType().getId().toString();
        }
        if (adInfo.getAccount() != null) {
            accID = adInfo.getAccount().getId().toString();
        }
        String delDetailHis = "delete from T_HR_BenefitDataDetailHis where FBenefitDataHisID in (select fid from T_HR_BenefitDataHis where FAccountDetailID ='" + accountDetailID + "' and FCmpPeriodID = '" + cmp + "')";
        String delHis = "delete from T_HR_BenefitDataHis where FAccountDetailID ='" + accountDetailID + "' and FCmpPeriodID = '" + cmp + "'";
        String delRep = "delete from T_HR_BenefitReportTable where faccountID ='" + accID + "' and faccountTypeID ='" + accType + "' and fcmpperiodID ='" + cmp + "'";
        DbUtil.execute((Context)ctx, (String)delDetailHis);
        DbUtil.execute((Context)ctx, (String)delHis);
        DbUtil.execute((Context)ctx, (String)delRep);
        String adjustDetail = "delete from T_HR_BenefitAdjustDataDetail where FBenefitAdjustDataID in (select fid from T_HR_BenefitAdjustData where FAccountDetailID ='" + accountDetailID + "' and FCmpPeriodID = '" + cmp + "')";
        String adjustData = "delete from T_HR_BenefitAdjustData Where FAccountDetailID = '" + accountDetailID + "' and FCmpPeriodID = '" + cmp + "'";
        DbUtil.execute((Context)ctx, (String)adjustDetail);
        DbUtil.execute((Context)ctx, (String)adjustData);
    }

    protected Map _getPeriodCollection(Context ctx, String admin, boolean includeSubOrg, String accountType) throws BOSException, EASBizException {
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        HashSet adminSet = BenefitUtils.getUserRangeAdminOrg(ctx, admin, includeSubOrg);
        String temporaryTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (adminSet.size() > 500) {
            temporaryTableName = BenefitUtils.createTempTableName(ctx, "FAdminOrgid", "benefitCalFormTempTable", adminSet);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select cmp.fid as PeriodID \n");
        sb.append(" from T_HR_AccountDetail ad \n");
        sb.append(" inner join T_HR_CmpPeriod cmp on ad.FCurPeriodID = cmp.FID \n");
        sb.append(" inner join T_HR_Account a on ad.FAccountID = a.FID \n");
        sb.append(" left outer join T_HR_PersonPosition pp on a.FPersonID = pp.FPersonID \n");
        if (adminSet.size() > 500) {
            sb.append(" inner join ").append(temporaryTableName).append(" temp on pp.FPersonDep = temp.FAdminOrgid \n");
        }
        sb.append(" where 1=1 ");
        if (adminSet.size() <= 500) {
            sb.append(" and pp.FPersonDep in ");
            sb.append(BenefitUtils.getStrFromSet(adminSet));
        }
        if (!StringUtils.isEmpty((String)accountType)) {
            sb.append(" and ad.FAccountTypeID ='").append(accountType).append("'");
        }
        sb.append(" and a.fhrorgunitid = '").append(hrOrgUnit).append("'");
        sb.append(" and cmp.fhrorgunitid = '").append(hrOrgUnit).append("'");
        sb.append(" and ad.FPayState = 10 ");
        IRowSet rows = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)(sb.toString() + " order by cmp.fnumber ASC "));
            boolean temp = true;
            while (rows.next()) {
                set.add(rows.getString("PeriodID"));
                if (temp) {
                    ICmpPeriod icp = CmpPeriodFactory.getLocalInstance((Context)ctx);
                    map.put("CmpPeriodInfo", icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(rows.getString("PeriodID"))));
                }
                temp = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (temporaryTableName != null) {
                pool.releaseTable(temporaryTableName);
            }
        }
        map.put("periodset", set);
        return map;
    }

    private void checkAccountsDump(Context ctx, AccountDetailCollection newCollChk, AccountDetailCollection updCollChk) throws BOSException, EASBizException {
        try {
            IRowSet set = null;
            AccountDetailInfo adInfo = null;
            HashSet<String> newAccounts = new HashSet<String>();
            HashSet<String> updAccounts = new HashSet<String>();
            HashMap<String, String> map = new HashMap<String, String>();
            String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            HashMap<String, String> accountMap = new HashMap<String, String>();
            int sizeNew = newCollChk.size();
            for (int i = 0; i < sizeNew; ++i) {
                adInfo = newCollChk.get(i);
                newAccounts.add(adInfo.getAccounts().replaceAll("'", "''"));
                accountMap.put(adInfo.getAccounts(), adInfo.getAccount().getPerson().getId().toString());
            }
            StringBuffer sqlNew = new StringBuffer();
            sqlNew.append(" select distinct a.fpersonid, ad.faccounts from t_hr_accountdetail ad ");
            sqlNew.append(" inner join t_hr_account a on ad.faccountid = a.fid ");
            sqlNew.append(" where a.fhrorgunitid ='" + hrOrgUnitId + "'");
            sqlNew.append(" and ad.faccounts in ");
            sqlNew.append(BenefitUtils.getStrFromSet(newAccounts));
            set = DbUtil.executeQuery((Context)ctx, (String)sqlNew.toString());
            this.checkAccountsToOnlyPerson(set, accountMap);
            String accounts = null;
            String accountID = null;
            int sizeUpd = updCollChk.size();
            for (int j = 0; j < sizeUpd; ++j) {
                adInfo = updCollChk.get(j);
                updAccounts.add(adInfo.getAccounts().replaceAll("'", "''"));
                map.put(adInfo.getAccounts(), adInfo.getAccount().getId().toString());
            }
            StringBuffer sqlUpd = new StringBuffer();
            sqlUpd.append(" select a.fid as accountID,ad.faccounts as accounts from t_hr_accountdetail ad ");
            sqlUpd.append(" inner join t_hr_account a on ad.faccountid = a.fid ");
            sqlUpd.append(" where a.fhrorgunitid ='" + hrOrgUnitId + "'");
            sqlUpd.append(" and ad.faccounts in ");
            sqlUpd.append(BenefitUtils.getStrFromSet(updAccounts));
            set = DbUtil.executeQuery((Context)ctx, (String)sqlUpd.toString());
            while (set.next()) {
                accounts = set.getString("accounts");
                accountID = set.getString("accountID");
                if (accountID.equals((String)map.get(accounts))) continue;
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTS_VALID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkAccountsToOnlyPerson(IRowSet set, Map accountMap) throws SQLException, EmpAccountManagerException {
        while (set.next()) {
            String personId = set.getString("fpersonid");
            String account = set.getString("faccounts");
            if (accountMap.get(account).equals(personId)) continue;
            throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTS_VALID);
        }
    }
}

