/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountItemInputInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitDataImportFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitItemCollection;
import com.kingdee.eas.hr.benefit.BenefitItemFactory;
import com.kingdee.eas.hr.benefit.BenefitItemInfo;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IBenefitDataImportFacade;
import com.kingdee.eas.hr.benefit.ItemInfo;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RadixInputDataImport
extends AbstractDataTransmission {
    private Map map = null;
    private Map accDetailMap = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AccountItemInputInfo aiiInfo = null;
        String str = null;
        String benefitNumber = null;
        try {
            str = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            benefitNumber = (String)((DataToken)hsData.get((Object)"FBenefitNumber")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PER_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            str = (String)((DataToken)hsData.get((Object)"FAcounts")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            if (this.accDetailMap == null) {
                String aCCountNumber = this.getACCountNumber(ctx, benefitNumber);
                this.accDetailMap = this.getAccDetailMap(ctx, aCCountNumber);
            }
            if (!this.accDetailMap.containsKey(str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
            }
            AccountDetailInfo adInfo = (AccountDetailInfo)this.accDetailMap.get(str);
            if (adInfo == null) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFIT_ITEM_NOT_NULL"));
            }
            str = (String)((DataToken)hsData.get((Object)"FBenefitNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENE_NUM") + str + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            if (this.map == null) {
                this.map = BenefitUtils.getItemByNumForRadixImport(ctx, "Base_insu");
            }
            if (!this.map.containsKey(str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFIT_ITEM_NOT_NULL"));
            }
            aiiInfo = BenefitUtils.getAiiInfo(ctx, ((ItemInfo)this.map.get(str)).getId().toString(), adInfo.getId().toString());
            str = (String)((DataToken)hsData.get((Object)"Fvalue")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + "[" + str + "]" + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_NULL"));
            }
            try {
                new BigDecimal(str);
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + "[" + str + "]" + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.INVALIDATE_NUMBER"));
            }
            BenefitItemInfo info = this.getBenefitItemInfo(ctx);
            if (info != null) {
                int length = info.getLength();
                int precision = info.getPrecision();
                if (str.indexOf(".") == -1 && str.length() > length - precision || str.indexOf(".") > -1 && (str.substring(0, str.indexOf(".")).length() > length - precision || str.substring(str.indexOf(".") + 1).length() > precision)) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.VALUE") + "[" + str + "]" + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.RADIXVALUE"));
                }
            }
            aiiInfo.setValue(new BigDecimal(str));
        }
        catch (ObjectNotFoundException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.BENEFIT_ITEM_NOT_NULL"));
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return aiiInfo;
    }

    private String getACCountNumber(Context ctx, String benefitNumber) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("accountType.number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)benefitNumber));
        viewInfo.setFilter(filterInfo);
        BenefitCollection benefitCollection = BenefitFactory.getLocalInstance(ctx).getBenefitCollection(viewInfo);
        if (benefitCollection.size() > 0 && benefitCollection.get(0).getAccountType() != null) {
            BenefitInfo benefitInfo = benefitCollection.get(0);
            return benefitInfo.getAccountType().getNumber();
        }
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IBenefitDataImportFacade iBenefitDataImportFacade = BenefitDataImportFacadeFactory.getLocalInstance(ctx);
            AccountItemInputInfo info = (AccountItemInputInfo)coreBaseInfo;
            iBenefitDataImportFacade.importRadixData(info);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private AccountDetailInfo getAdInfo(Context ctx, String str) throws BOSException, EASBizException, TaskExternalException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection adColl = null;
        String selectSql = "select * where accounts = '" + str + "'";
        adColl = iAccountDetail.getAccountDetailCollection(selectSql);
        if (adColl.size() <= 0) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTS") + " '" + str + "' " + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.NOT_FOUND"));
        }
        return adColl.get(0);
    }

    private Map getAccDetailMap(Context ctx, String aCCountNumber) throws BOSException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getLocalInstance(ctx);
        AccountDetailCollection adColl = null;
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String selectSql = "select id, accounts,accountNumber where account.hrOrgUnit.id = '" + hrOrgUnit + "'";
        adColl = iAccountDetail.getAccountDetailCollection(selectSql);
        AccountDetailInfo adInfo = null;
        HashMap<String, AccountDetailInfo> map = new HashMap<String, AccountDetailInfo>();
        int size = adColl.size();
        for (int i = 0; i < size; ++i) {
            adInfo = adColl.get(i);
            if (!StringUtils.isEmpty((String)aCCountNumber)) {
                if (!aCCountNumber.equals(adInfo.getAccountNumber())) continue;
                map.put(adInfo.getAccounts(), adInfo);
                continue;
            }
            map.put(adInfo.getAccounts(), adInfo);
        }
        return map;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        return ExportUtil.transeExport(rs, ExportUtil.RADIX_MAP);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("item.benefitItemNumber", (Object)"Base_insu"));
        filterInfo.getFilterItems().add(new FilterItemInfo("value", (Object)"0", CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and #1");
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.benefit.app.AccrAndRadixQuery";
    }

    private BenefitItemInfo getBenefitItemInfo(Context ctx) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"Base_insu"));
        filterInfo.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        BenefitItemCollection coll = BenefitItemFactory.getLocalInstance(ctx).getBenefitItemCollection(view);
        if (coll != null) {
            return coll.get(0);
        }
        return null;
    }
}

