/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation;

import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import java.awt.Color;
import java.io.Serializable;

public class DynamicTableInfo
implements Serializable {
    private String name = null;
    private int countHeadLine = 1;
    private ColumnInfo[] infosColumn = null;
    private int headMergeMode = 1;
    private int selectMode = 15;
    private RowDataInfo[] infosDataRow = null;
    private boolean orderColumn = false;

    public int getCountHeadLine() {
        return this.countHeadLine;
    }

    public int getHeadMergeMode() {
        return this.headMergeMode;
    }

    public ColumnInfo[] getInfosColumn() {
        return this.infosColumn;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public void setCountHeadLine(int i) {
        this.countHeadLine = i;
    }

    public void setHeadMergeMode(int i) {
        this.headMergeMode = i;
    }

    public void setInfosColumn(ColumnInfo[] infos) {
        this.infosColumn = infos;
    }

    public void setSelectMode(int i) {
        this.selectMode = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public RowDataInfo[] getInfosDataRow() {
        return this.infosDataRow;
    }

    public void setInfosDataRow(RowDataInfo[] infos) {
        this.infosDataRow = infos;
    }

    public boolean isOrderColumn() {
        return this.orderColumn;
    }

    public void setOrderColumn(boolean b) {
        this.orderColumn = b;
    }

    public static class RowDataInfo
    implements Serializable {
        private Object[] dataCell = null;

        public Object[] getDataRow() {
            return this.dataCell;
        }

        public void setDataRow(Object[] objects) {
            this.dataCell = objects;
        }
    }

    public static class HeadInfo
    implements Serializable {
        private String headName = null;
        private String headValue = null;

        public String getHeadName() {
            return this.headName;
        }

        public String getHeadValue() {
            return this.headValue;
        }

        public void setHeadName(String string) {
            this.headName = string;
        }

        public void setHeadValue(String string) {
            this.headValue = string;
        }

        public String toString() {
            return this.headName;
        }
    }

    public static class ColumnInfo
    implements Serializable {
        private String columnName = null;
        private String columnNumber = null;
        private String value = null;
        private String format = null;
        private int width = -1;
        private HeadInfo[] infosHead = new HeadInfo[1];
        private int sizeColumnDisplay = 100;
        private boolean readOnly = true;
        private boolean isPrimaryKey = false;
        private int type = 10;
        private String columnTypeName = null;
        private int columnType = 0;
        private int scale = 0;
        private int precision = 0;
        private CmpItemPrecisionTypeEnum precisionType = CmpItemPrecisionTypeEnum.SISHEWURU;
        private boolean nullable = true;
        private boolean locked = false;
        private boolean hide = false;
        private boolean resizeable = true;
        private boolean mergeable = true;
        private boolean moveable = true;
        private boolean group = false;
        private boolean required = false;
        private Object userObject = null;
        private Styles.HorizontalAlignment alignHor = Styles.HorizontalAlignment.LEFT;
        private Styles.VerticalAlignment alignVer = Styles.VerticalAlignment.MIDDLE;
        private int order = -1;
        private Color color = null;
        private String itemValue = null;
        private String defaultObj = null;
        private String defaultQueryName = null;
        private String defaultF7UI = null;
        private ItemObjectTypeEnum objectType = ItemObjectTypeEnum.OTHER;
        private ICellEditor editor = null;
        private IBasicRender renderer = null;
        private String key = null;
        private boolean wrap = false;

        public ColumnInfo(CmpItemInfo info) {
            this.setColumnName(info.getName());
            this.setColumnNumber(info.getNumber());
            this.setPrecision(info.getLength());
            this.setScale(info.getDecDigital());
            this.setPrecisionType(info.getPrecisionType());
            this.setItemValue(info.getItemValue());
            ItemDataTypeEnum enumDataType = info.getDataType();
            this.setColumnTypeName(enumDataType.getName());
            this.setColumnType(enumDataType.getValue());
            this.setType(info.getType().getValue());
            if (enumDataType == ItemDataTypeEnum.CURRENCY || enumDataType == ItemDataTypeEnum.INT || enumDataType == ItemDataTypeEnum.FLOAT) {
                this.setAlignHor(Styles.HorizontalAlignment.RIGHT);
                this.setReadOnly(false);
            } else if (enumDataType == ItemDataTypeEnum.LOGIC) {
                this.setAlignHor(Styles.HorizontalAlignment.CENTER);
            } else {
                this.setAlignHor(Styles.HorizontalAlignment.LEFT);
            }
            HeadInfo[] infosHead = new HeadInfo[]{new HeadInfo()};
            infosHead[0].setHeadName(info.getName());
            this.setInfosHead(infosHead);
            this.setKey(info.getNumber());
            this.setCellEditor(info);
            this.setCellRender(info);
        }

        public ColumnInfo() {
        }

        private void setCellEditor(CmpItemInfo info) {
            if (this.getItemValue() != null && !this.getItemValue().trim().equals("")) {
                if (this.objectType == ItemObjectTypeEnum.BIZOBJECT) {
                    this.editor = HRTableTools.getBizCellEditor(this.getDefaultObj(), this.getDefaultQueryName(), this.getDefaultF7UI());
                } else if (this.objectType == ItemObjectTypeEnum.ENUM) {
                    this.editor = HRTableTools.getEnumCellEditor(this.getDefaultObj());
                }
            } else if (info.getDataType() == ItemDataTypeEnum.CURRENCY) {
                this.editor = HRTableTools.getCurCellEditor(info.getLength(), info.getDecDigital(), null, null);
                this.setFormat(HRCmpItemUtils.getColumnFormatStr(this.getScale()));
            } else if (info.getDataType() == ItemDataTypeEnum.INT) {
                this.editor = HRTableTools.getIntCellEditor(info.getLength(), 0);
            } else if (info.getDataType() == ItemDataTypeEnum.FLOAT) {
                this.editor = HRTableTools.getNumberCellEditor(info.getLength(), info.getDecDigital(), null);
                this.setFormat(HRCmpItemUtils.getColumnFormatStr(this.getScale()));
            } else if (info.getDataType() == ItemDataTypeEnum.DATE) {
                this.editor = HRTableTools.getDateCellEditor();
                this.setFormat("yyyy-MM-dd");
            } else if (info.getDataType() == ItemDataTypeEnum.STRING) {
                this.editor = HRTableTools.getStringCellEditor(info.getLength());
            }
        }

        public void setCellEditorByObjtype() {
            if (this.objectType == null) {
                return;
            }
            if (this.objectType == ItemObjectTypeEnum.BIZOBJECT) {
                this.editor = HRTableTools.getBizCellEditor(this.getDefaultObj(), this.getDefaultQueryName(), this.getDefaultF7UI());
            } else if (this.objectType == ItemObjectTypeEnum.ENUM) {
                this.editor = HRTableTools.getEnumCellEditor(this.getDefaultObj());
            } else if (this.objectType == ItemObjectTypeEnum.INTEGER) {
                this.editor = HRTableTools.getIntCellEditor(0, 0);
            } else if (this.objectType == ItemObjectTypeEnum.FLOAT) {
                this.editor = HRTableTools.getNumberCellEditor(0, 2, null);
            }
        }

        private void setCellRender(CmpItemInfo info) {
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnNumber() {
            return this.columnNumber;
        }

        public HeadInfo[] getInfosHead() {
            return this.infosHead;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isResizeable() {
            return this.resizeable;
        }

        public void setResizeable(boolean resizeable) {
            this.resizeable = resizeable;
        }

        public boolean isGroup() {
            return this.group;
        }

        public void setGroup(boolean group) {
            this.group = group;
        }

        public boolean isMergeable() {
            return this.mergeable;
        }

        public void setMergeable(boolean mergeable) {
            this.mergeable = mergeable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public void setMoveable(boolean moveable) {
            this.moveable = moveable;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setColumnName(String string) {
            this.columnName = string;
        }

        public void setColumnNumber(String string) {
            this.columnNumber = string;
        }

        public void setInfosHead(HeadInfo[] infos) {
            this.infosHead = infos;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public Styles.HorizontalAlignment getAlignHor() {
            return this.alignHor;
        }

        public Styles.VerticalAlignment getAlignVer() {
            return this.alignVer;
        }

        public int getColumnType() {
            return this.columnType;
        }

        public String getColumnTypeName() {
            return this.columnTypeName;
        }

        public boolean isHide() {
            return this.hide;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int getPrecision() {
            return this.precision;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public int getScale() {
            return this.scale;
        }

        public int getSizeColumnDisplay() {
            return this.sizeColumnDisplay;
        }

        public void setAlignHor(Styles.HorizontalAlignment align) {
            this.alignHor = align;
        }

        public void setAlignVer(Styles.VerticalAlignment align) {
            this.alignVer = align;
        }

        public void setColumnType(int type) {
            this.columnType = type;
        }

        public void setColumnTypeName(String string) {
            this.columnTypeName = string;
        }

        public void setHide(boolean b) {
            this.hide = b;
        }

        public void setLocked(boolean b) {
            this.locked = b;
        }

        public void setNullable(boolean b) {
            this.nullable = b;
        }

        public void setPrecision(int i) {
            this.precision = i;
        }

        public void setReadOnly(boolean b) {
            this.readOnly = b;
        }

        public void setScale(int i) {
            this.scale = i;
        }

        public CmpItemPrecisionTypeEnum getPrecisionType() {
            return this.precisionType;
        }

        public void setPrecisionType(CmpItemPrecisionTypeEnum precisionType) {
            this.precisionType = precisionType;
        }

        public void setSizeColumnDisplay(int i) {
            this.sizeColumnDisplay = i;
        }

        public String toString() {
            return this.columnName;
        }

        public String getDefaultF7UI() {
            return this.defaultF7UI;
        }

        public String getDefaultQueryName() {
            return this.defaultQueryName;
        }

        public String getItemValue() {
            return this.itemValue;
        }

        public void setDefaultF7UI(String string) {
            this.defaultF7UI = string;
        }

        public void setDefaultQueryName(String string) {
            this.defaultQueryName = string;
        }

        public void setItemValue(String string) {
            this.itemValue = string;
            if (this.itemValue == null || this.itemValue.trim().equals("")) {
                return;
            }
            String[] temp = this.itemValue.split(";");
            if (temp.length != 5) {
                return;
            }
            if (temp[0] != null && !temp[0].equals("")) {
                String strType = temp[0].trim();
                this.setObjectType(ItemObjectTypeEnum.getEnum(Integer.parseInt(strType)));
            }
            this.setDefaultObj(temp[1]);
            this.setDefaultQueryName(temp[2]);
            this.setDefaultF7UI(temp[3]);
        }

        public ItemObjectTypeEnum getObjectType() {
            return this.objectType;
        }

        public void setObjectType(ItemObjectTypeEnum enum0) {
            this.objectType = enum0;
        }

        public ICellEditor getEditor() {
            return this.editor;
        }

        public String getKey() {
            return this.key;
        }

        public IBasicRender getRenderer() {
            return this.renderer;
        }

        public void setEditor(ICellEditor editor) {
            this.editor = editor;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void setRenderer(IBasicRender render) {
            this.renderer = render;
        }

        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }

        public void setPrimaryKey(boolean b) {
            this.isPrimaryKey = b;
        }

        public String getDefaultObj() {
            return this.defaultObj;
        }

        public void setDefaultObj(String string) {
            this.defaultObj = string;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int i) {
            this.type = i;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String string) {
            this.format = string;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int i) {
            this.order = i;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object obj) {
            this.userObject = obj;
        }

        public boolean isWrap() {
            return this.wrap;
        }

        public void setWrap(boolean wrap) {
            this.wrap = wrap;
        }
    }
}

