/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.CmpTempTableInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AppCmpReportUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpSchemeControllerBean");

    public static CmpTempTableInfo fillDataToTempTable(Context ctx, List privateItems, List publicItems, CmpSchemeInfo[] cmpSchemeInfos, CmpPeriodInfo period, EntityViewInfo personViewInfo, String schemeFilter, boolean notIncDelItem) throws EASBizException, BOSException {
        return AppCmpReportUtil.fillDataToTempTable(ctx, privateItems, publicItems, cmpSchemeInfos, new CmpPeriodInfo[]{period}, personViewInfo, schemeFilter, notIncDelItem);
    }

    public static CmpTempTableInfo fillDataToTempTable(Context ctx, List privateItems, List publicItems, CmpSchemeInfo[] cmpSchemeInfos, CmpPeriodInfo[] period, EntityViewInfo personViewInfo, String schemeFilter, boolean notIncDelItem) throws EASBizException, BOSException {
        if (privateItems == null || publicItems == null || cmpSchemeInfos == null || period == null) {
            return null;
        }
        CmpTempTableInfo tInfo = null;
        tInfo = cmpSchemeInfos.length < 2 ? AppCmpReportUtil.getCmpDataTableInfo(ctx, privateItems, publicItems, cmpSchemeInfos, period, personViewInfo, schemeFilter, notIncDelItem) : AppCmpReportUtil.getMulCmpDataTableInfo(ctx, privateItems, publicItems, cmpSchemeInfos, period, personViewInfo, schemeFilter, notIncDelItem);
        return tInfo;
    }

    private static CmpTempTableInfo getCmpDataTableInfo(Context ctx, List privateItems, List publicItems, CmpSchemeInfo[] cmpSchemeInfos, CmpPeriodInfo[] period, EntityViewInfo personViewInfo, String schemeFilter, boolean notIncDelItem) throws EASBizException, BOSException {
        Object tmp;
        List schemeIDs = AppCmpReportUtil.getCmpschemeIdList(cmpSchemeInfos);
        String[] periodNumber = AppCmpReportUtil.getPeriodNumber(period);
        String personTempTable = AppCmpReportUtil.createPersonTempTable(ctx, schemeIDs, periodNumber, personViewInfo, schemeFilter);
        Map schemeTableMap = HRSchemeUtils.getCmpSchemeDataTableNames(ctx, schemeIDs, periodNumber);
        if (personTempTable == null) {
            return null;
        }
        HashMap schemePrefixMap = new HashMap();
        int size = schemeIDs.size();
        for (int i = 0; i < size; ++i) {
            schemePrefixMap.put(schemeIDs.get(i), "F" + i);
        }
        Map itemMap = AppCmpReportUtil.getItemMap(ctx, schemeIDs, publicItems);
        Iterator<Object> iter = itemMap.keySet().iterator();
        String itemNumber = null;
        Object values = null;
        while (iter.hasNext()) {
            itemNumber = iter.next().toString();
            Iterator idSet = ((Set)itemMap.get(itemNumber)).iterator();
            StringBuffer sb = new StringBuffer();
            while (idSet.hasNext()) {
                if (sb.length() != 0) {
                    sb.append("+");
                }
                sb.append(" isnull(").append(schemePrefixMap.get(idSet.next())).append(".").append(itemNumber).append(",0)");
            }
            itemMap.put(itemNumber, sb.toString());
        }
        ArrayList<String> allPrivateitemNum = new ArrayList<String>();
        int size2 = privateItems.size();
        for (int i = 0; i < size2; ++i) {
            allPrivateitemNum.add(((CmpItemInfo)privateItems.get(i)).getNumber());
        }
        HashMap schemeItemMap = CmpReportFacadeFactory.getLocalInstance(ctx).getPrivateItemsByScheme(schemeIDs, allPrivateitemNum, notIncDelItem);
        CmpTempTableInfo tInfo = AppCmpReportUtil.createDataTable(ctx, schemePrefixMap, schemeItemMap, publicItems);
        List columnNameList = tInfo.getColumns();
        String dataTable = tInfo.getTableName();
        tInfo.setCmpSchemeInfos(cmpSchemeInfos);
        tInfo.setSchemePrefixMap(schemePrefixMap);
        tInfo.setPersonTempTable(personTempTable);
        StringBuffer insertSql = new StringBuffer(1024);
        insertSql.append("insert into ").append(dataTable);
        insertSql.append("(FAdminOrgUnitID,FLongNumber,FPositionID,FPersonId,FPeriodNum,FTime");
        StringBuffer priItemsStr = new StringBuffer();
        StringBuffer pubItemStr = new StringBuffer();
        int size3 = columnNameList.size();
        for (int i = 0; i < size3; ++i) {
            String columnName = columnNameList.get(i).toString();
            insertSql.append(",").append(columnName);
            if (columnName.indexOf("_") > 0) {
                priItemsStr.append(",").append(columnName.replace('_', '.'));
                continue;
            }
            if (StringUtils.isEmpty((String)((String)itemMap.get(columnName)))) {
                pubItemStr.append(",0 ");
                continue;
            }
            pubItemStr.append(",").append(itemMap.get(columnName));
        }
        insertSql.append(")");
        insertSql.append(" select personTemp.FAdminOrgUnitID,personTemp.FLongNumber,personTemp.FPositionID,personTemp.FPersonId,personTemp.FPeriodNum,personTemp.FTime ");
        insertSql.append(pubItemStr);
        insertSql.append(priItemsStr);
        insertSql.append(" from ").append(personTempTable).append(" as personTemp ");
        String aliasName = null;
        iter = schemePrefixMap.entrySet().iterator();
        StringBuffer pSql = new StringBuffer(insertSql.toString());
        Map.Entry entry = null;
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            tmp = entry.getKey();
            aliasName = entry.getValue().toString();
            pSql.append(" left outer join (select T.*,CP.FNumber AS FPeriodNum from ");
            pSql.append(schemeTableMap.get(tmp.toString()));
            pSql.append(" as T inner join t_hr_cmpperiod as CP on T.FPeriod = CP.FID where T.FPositionID is not null) as ");
            pSql.append(aliasName);
            pSql.append(" on ");
            pSql.append(AppCmpReportUtil.getConditions("personTemp", aliasName, true));
        }
        pSql.append(" where personTemp.FPositionID is not null");
        DbUtil.execute((Context)ctx, (String)pSql.toString());
        iter = schemePrefixMap.entrySet().iterator();
        pSql = new StringBuffer(insertSql.toString());
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            tmp = entry.getKey();
            aliasName = entry.getValue().toString();
            pSql.append(" left outer join (select T.*,CP.FNumber AS FPeriodNum from ");
            pSql.append(schemeTableMap.get(tmp.toString()));
            pSql.append(" as T inner join t_hr_cmpperiod as CP on T.FPeriod = CP.FID where T.FPositionID is null) as ");
            pSql.append(aliasName);
            pSql.append(" on ");
            pSql.append(AppCmpReportUtil.getConditions("personTemp", aliasName, false));
        }
        pSql.append(" where personTemp.FPositionID is null");
        DbUtil.execute((Context)ctx, (String)pSql.toString());
        return tInfo;
    }

    private static CmpTempTableInfo getMulCmpDataTableInfo(Context ctx, List privateItems, List publicItems, CmpSchemeInfo[] cmpSchemeInfos, CmpPeriodInfo[] period, EntityViewInfo personViewInfo, String schemeFilter, boolean notIncDelItem) throws EASBizException, BOSException {
        List schemeIDs = AppCmpReportUtil.getCmpschemeIdList(cmpSchemeInfos);
        String[] periodNumber = AppCmpReportUtil.getPeriodNumber(period);
        String personTempTable = AppCmpReportUtil.createPersonTempTable(ctx, schemeIDs, periodNumber, personViewInfo, schemeFilter);
        Map schemeTableMap = HRSchemeUtils.getCmpSchemeDataTableNames(ctx, schemeIDs, periodNumber);
        if (personTempTable == null) {
            return null;
        }
        HashMap schemePrefixMap = new HashMap();
        int size = schemeIDs.size();
        for (int i = 0; i < size; ++i) {
            schemePrefixMap.put(schemeIDs.get(i), "F" + i);
        }
        ArrayList<String> allPrivateitemNum = new ArrayList<String>();
        int size2 = privateItems.size();
        for (int i = 0; i < size2; ++i) {
            allPrivateitemNum.add(((CmpItemInfo)privateItems.get(i)).getNumber());
        }
        HashMap schemeItemMap = CmpReportFacadeFactory.getLocalInstance(ctx).getPrivateItemsByScheme(schemeIDs, allPrivateitemNum, notIncDelItem);
        CmpTempTableInfo tInfo = AppCmpReportUtil.createDataTable(ctx, schemePrefixMap, schemeItemMap, publicItems);
        String dataTable = tInfo.getTableName();
        tInfo.setCmpSchemeInfos(cmpSchemeInfos);
        tInfo.setSchemePrefixMap(schemePrefixMap);
        tInfo.setPersonTempTable(personTempTable);
        tInfo.setHasDataSchemeMap(AppCmpReportUtil.getHaveDataInPeriods(ctx, schemeIDs, periodNumber));
        Map collectItemMap = AppCmpReportUtil.getSchemeItemMap(ctx, schemeIDs, publicItems, true, notIncDelItem);
        Map privateItemMap = AppCmpReportUtil.getSchemeItemMap(ctx, schemeIDs, privateItems, false, notIncDelItem);
        String schemeId = null;
        Set collectItemSet = null;
        Set privateItemSet = null;
        long time0 = System.currentTimeMillis();
        logger.debug((Object)("getMulCmpDataTableInfo() update temp table start:  " + dataTable + " :"));
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        int size3 = schemeIDs.size();
        for (int i = 0; i < size3; ++i) {
            schemeId = (String)schemeIDs.get(i);
            if (!schemeTableMap.containsKey(schemeId)) continue;
            if (i % 30 != 0 || i != 0) {
                // empty if block
            }
            long time11 = System.currentTimeMillis();
            collectItemSet = (Set)collectItemMap.get(schemeId);
            privateItemSet = (Set)privateItemMap.get(schemeId);
            if (!(collectItemSet != null && !collectItemSet.isEmpty() || privateItemSet != null && !privateItemSet.isEmpty())) continue;
            String insertPosNotNullSql = AppCmpReportUtil.getInsertSql(personTempTable, schemeTableMap, schemePrefixMap, dataTable, schemeId, collectItemSet, privateItemSet, true);
            String insertPosIsNullSql = AppCmpReportUtil.getInsertSql(personTempTable, schemeTableMap, schemePrefixMap, dataTable, schemeId, collectItemSet, privateItemSet, false);
            DbUtil.execute((Context)ctx, (String)insertPosNotNullSql.toString());
            DbUtil.execute((Context)ctx, (String)insertPosIsNullSql.toString());
            long time12 = System.currentTimeMillis();
            logger.debug((Object)("" + i + "----update tempTable of scheme(ID:'" + schemeId + "'),use time:" + (time12 - time11)));
        }
        try {
            if (conn != null) {
                pool.analyzeTable(conn, dataTable);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        SQLUtils.cleanup((Connection)conn);
        long time1 = System.currentTimeMillis();
        logger.debug((Object)("getMulCmpDataTableInfo() end for update,use time:" + (time1 - time0)));
        try {
            pool.createIndex(dataTable, "FAdminOrgUnitID ,FPositionID ,FPersonId ,FPeriodNum ,FTime,FLongNumber", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        CmpTempTableInfo tempInfo = AppCmpReportUtil.createDataTable(ctx, schemePrefixMap, schemeItemMap, publicItems);
        String dataTempTableName = tempInfo.getTableName();
        Set canNotSumColumns = tempInfo.getCanNotSumColumns();
        List columns = tempInfo.getColumns();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer sumSql = new StringBuffer("select FAdminOrgUnitID ,FPositionID ,FPersonId ,FPeriodNum ,FTime,FLongNumber");
        insertSql.append("insert into ").append(dataTempTableName).append(" (FAdminOrgUnitID ,FPositionID ,FPersonId ,FPeriodNum ,FTime,FLongNumber");
        int size4 = columns.size();
        for (int i = 0; i < size4; ++i) {
            insertSql.append(",").append(columns.get(i));
            if (canNotSumColumns != null && canNotSumColumns.contains(columns.get(i))) {
                sumSql.append(",max(").append(columns.get(i)).append(")");
                continue;
            }
            sumSql.append(",isnull(sum(").append(columns.get(i)).append("),0)");
        }
        insertSql.append(") ");
        sumSql.append(" from ").append(dataTable);
        sumSql.append(" group by FAdminOrgUnitID ,FPositionID ,FPersonId ,FPeriodNum ,FTime,FLongNumber");
        insertSql.append(sumSql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        long time2 = System.currentTimeMillis();
        logger.debug((Object)("getMulCmpDataTableInfo() end for sum,use time:" + (time2 - time1)));
        try {
            pool.createIndex(dataTempTableName, "FAdminOrgUnitID ,FPositionID ,FPersonId ,FPeriodNum ,FTime", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        tInfo.setTableName(dataTempTableName);
        pool.releaseTable(dataTable);
        return tInfo;
    }

    private static String getUpdateSql(String personTempTable, Map schemeTableMap, Map schemePrefixMap, String dataTable, String schemeId, Set collectItemSet, Set privateItemSet, boolean postionNotNull) {
        Iterator privateItemNumSet;
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(dataTable).append(" set (");
        if (collectItemSet != null) {
            Iterator collectItemNumSet = collectItemSet.iterator();
            while (collectItemNumSet.hasNext()) {
                updateSql.append(collectItemNumSet.next()).append(",");
            }
        }
        String prefixStr = (String)schemePrefixMap.get(schemeId);
        if (privateItemSet != null) {
            privateItemNumSet = privateItemSet.iterator();
            while (privateItemNumSet.hasNext()) {
                updateSql.append(prefixStr).append("_").append(privateItemNumSet.next()).append(",");
            }
        }
        updateSql = new StringBuffer(updateSql.substring(0, updateSql.length() - 1));
        updateSql.append(") = (select ");
        if (collectItemSet != null) {
            for (String curItem : collectItemSet) {
                updateSql.append("isnull(").append(dataTable).append(".").append(curItem).append(",0)+isnull(").append("curSchmTbl.").append(curItem).append(",0),");
            }
        }
        if (privateItemSet != null) {
            privateItemNumSet = privateItemSet.iterator();
            while (privateItemNumSet.hasNext()) {
                updateSql.append("curSchmTbl.").append(privateItemNumSet.next()).append(",");
            }
        }
        updateSql = new StringBuffer(updateSql.substring(0, updateSql.length() - 1));
        updateSql.append(" from ").append(schemeTableMap.get(schemeId)).append(" curSchmTbl ");
        updateSql.append(" inner join t_hr_cmpperiod as CP on curSchmTbl.FPeriod = CP.FID ");
        if (postionNotNull) {
            updateSql.append(" where curSchmTbl.FPositionID is not null and ");
        } else {
            updateSql.append(" where curSchmTbl.FPositionID is null and ");
        }
        if (postionNotNull) {
            updateSql.append(AppCmpReportUtil.getConditionsWithPeriod(dataTable, "curSchmTbl", true));
        } else {
            updateSql.append(AppCmpReportUtil.getConditionsWithPeriod(dataTable, "curSchmTbl", false));
        }
        updateSql.append(" and ").append(dataTable).append(".FPersonId in ( select personTemp.FPersonId from ").append(personTempTable);
        if (postionNotNull) {
            updateSql.append(" personTemp where personTemp.FPositionID is not null and ").append(AppCmpReportUtil.getConditions("personTemp", dataTable, true));
        } else {
            updateSql.append(" personTemp where personTemp.FPositionID is null and ").append(AppCmpReportUtil.getConditions("personTemp", dataTable, false));
        }
        updateSql.append("))");
        return updateSql.toString();
    }

    private static String getInsertSql(String personTempTable, Map schemeTableMap, Map schemePrefixMap, String dataTable, String schemeId, Set collectItemSet, Set privateItemSet, boolean postionNotNull) {
        Iterator privateItemNumSet;
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(dataTable).append(" (FAdminOrgUnitID,FLongNumber,FPositionID,FPersonId,FPeriodNum,FTime");
        if (collectItemSet != null) {
            Iterator collectItemNumSet = collectItemSet.iterator();
            while (collectItemNumSet.hasNext()) {
                insertSql.append(",").append(collectItemNumSet.next());
            }
        }
        String prefixStr = (String)schemePrefixMap.get(schemeId);
        if (privateItemSet != null) {
            privateItemNumSet = privateItemSet.iterator();
            while (privateItemNumSet.hasNext()) {
                insertSql.append(",").append(prefixStr).append("_").append(privateItemNumSet.next());
            }
        }
        insertSql.append(") select curSchmTbl.FAdminOrgUnitID,org.FLongNumber,curSchmTbl.FPositionID,curSchmTbl.FPersonId,CP.FNumber,curSchmTbl.FTime,");
        if (collectItemSet != null) {
            for (String curItem : collectItemSet) {
                insertSql.append("curSchmTbl.").append(curItem).append(",");
            }
        }
        if (privateItemSet != null) {
            privateItemNumSet = privateItemSet.iterator();
            while (privateItemNumSet.hasNext()) {
                insertSql.append("curSchmTbl.").append(privateItemNumSet.next()).append(",");
            }
        }
        insertSql = new StringBuffer(insertSql.substring(0, insertSql.length() - 1));
        insertSql.append(" from ").append(schemeTableMap.get(schemeId)).append(" curSchmTbl inner join t_hr_cmpperiod as CP on curSchmTbl.FPeriod = CP.FID ").append(" inner join t_org_admin org on curSchmTbl.FAdminOrgUnitID=org.fid ");
        if (postionNotNull) {
            insertSql.append(" inner join ").append(personTempTable).append(" personTemp on ");
            insertSql.append(AppCmpReportUtil.getConditionsWithPeriod("personTemp", "curSchmTbl", true));
            insertSql.append(" where curSchmTbl.FPositionID >' '");
        } else {
            insertSql.append(" inner join ").append(personTempTable).append(" personTemp on ");
            insertSql.append(AppCmpReportUtil.getConditionsWithPeriod("personTemp", "curSchmTbl", false));
            insertSql.append(" where curSchmTbl.FPositionID is null and personTemp.fpositionid is null");
        }
        return insertSql.toString();
    }

    public static String getPeriodNumbers(String[] pNum) {
        if (pNum == null) {
            return null;
        }
        StringBuffer numStr = null;
        for (int i = 0; i < pNum.length; ++i) {
            if (numStr == null) {
                numStr = new StringBuffer();
            } else {
                numStr.append(",");
            }
            numStr.append("'");
            numStr.append(pNum[i]);
            numStr.append("'");
        }
        return numStr.toString();
    }

    public static String[] getPeriodNumber(CmpPeriodInfo[] period) {
        if (period == null) {
            return null;
        }
        String[] nums = new String[period.length];
        for (int i = 0; i < period.length; ++i) {
            nums[i] = period[i].getNumber();
        }
        return nums;
    }

    public static CmpPeriodInfo[] getPeriods(Context ctx, CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod, String hrOrgID) throws EASBizException, BOSException {
        int size;
        if (beginPeriod == null || endPeriod == null || StringUtils.isEmpty((String)hrOrgID)) {
            return null;
        }
        CmpPeriodCollection col = null;
        Date beginDate = beginPeriod.getBeginDate();
        Date endDate = endPeriod.getEndDate();
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgID));
        infoFilter.setMaskString("#0 and #1 and #2");
        evi.setFilter(infoFilter);
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        if (col != null && (size = col.size()) > 0) {
            CmpPeriodInfo[] infos = new CmpPeriodInfo[size];
            for (int i = 0; i < size; ++i) {
                infos[i] = col.get(i);
            }
            return infos;
        }
        return null;
    }

    public static CmpTempTableInfo fillDataToTempTable(Context ctx, HashMap customFilterMap, boolean notIncDelItem) throws EASBizException, BOSException {
        List allPrivateItems = (List)customFilterMap.get("AllPrivateItem");
        List allPublicItems = (List)customFilterMap.get("AllPublicItem");
        CmpSchemeInfo[] CmpSchemeInfos = (CmpSchemeInfo[])customFilterMap.get("CmpSchemeInfos");
        CmpPeriodInfo period = (CmpPeriodInfo)customFilterMap.get("CmpPeriodInfo");
        return AppCmpReportUtil.fillDataToTempTable(ctx, allPrivateItems, allPublicItems, CmpSchemeInfos, period, null, null, notIncDelItem);
    }

    private static List getCmpschemeIdList(CmpSchemeInfo[] CmpSchemeInfos) {
        ArrayList<String> idList = new ArrayList<String>();
        int n = CmpSchemeInfos.length;
        for (int i = 0; i < n; ++i) {
            idList.add(CmpSchemeInfos[i].getId().toString());
        }
        return idList;
    }

    private static Map getItemMap(Context ctx, List schemeID, List publicItem) throws BOSException {
        CmpItemInfo cmpItemInfo = null;
        HashSet<String> publicItemNumberSet = new HashSet<String>();
        int size = publicItem.size();
        for (int i = 0; i < size; ++i) {
            cmpItemInfo = (CmpItemInfo)publicItem.get(i);
            publicItemNumberSet.add(cmpItemInfo.getNumber());
        }
        HashSet schemeIDs = new HashSet();
        schemeIDs.addAll(schemeID);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme", schemeIDs, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCollect", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", publicItemNumberSet, CompareType.INCLUDE));
        filterInfo.setMaskString("#0 and #1 and #2");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cmpItem.number"));
        sic.add(new SelectorItemInfo("cmpItem.id"));
        sic.add(new SelectorItemInfo("isCollect"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        sic.add(new SelectorItemInfo("cmpScheme.number"));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo isCollSort = new SorterItemInfo("isCollect");
        isCollSort.setSortType(SortType.DESCEND);
        sorter.add(isCollSort);
        sorter.add(new SorterItemInfo("cmpItem.number"));
        sorter.add(new SorterItemInfo("cmpScheme.number"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filterInfo);
        viewInfo.setSorter(sorter);
        CmpSchemeItemCollection schemeItemColl = CmpSchemeItemFactory.getLocalInstance(ctx).getCmpSchemeItemCollection(viewInfo);
        if (schemeItemColl == null || schemeItemColl.size() == 0) {
            return new HashMap();
        }
        HashMap itemMap = new HashMap();
        Set<String> schemeSet = null;
        int size2 = schemeItemColl.size();
        for (int i = 0; i < size2; ++i) {
            cmpItemInfo = schemeItemColl.get(i).getCmpItem();
            if (itemMap.containsKey(cmpItemInfo.getNumber())) {
                schemeSet = (Set)itemMap.get(cmpItemInfo.getNumber());
            } else {
                schemeSet = new HashSet();
                itemMap.put(cmpItemInfo.getNumber(), schemeSet);
            }
            schemeSet.add(schemeItemColl.get(i).getCmpScheme().getId().toString());
        }
        return itemMap;
    }

    private static CmpTempTableInfo createDataTable(Context ctx, Map schemePrefixMap, Map schemeItemMap, List allPublicItems) throws BOSException, EASBizException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        String temporaryTableName = "hrAllDataTempTable";
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create TABLE ").append(temporaryTableName).append(" (FAdminOrgUnitID varchar(44),FPositionID varchar(44),FPersonId varchar(44),FPeriodNum NVarchar(80),FTime Int,FLongNumber nvarchar(");
        int longNumberLen = HRParamUtil.getTreeLongNumberLen((Context)ctx);
        createTableSql.append(longNumberLen);
        createTableSql.append(") ");
        CmpItemInfo itemInfo = null;
        int size = allPublicItems.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)allPublicItems.get(i);
            if (itemInfo == null || itemInfo.getNumber().startsWith("FPER") || itemInfo.getNumber().startsWith("FFPER")) continue;
            createTableSql.append(",");
            createTableSql.append(itemInfo.getNumber());
            createTableSql.append(AppCmpReportUtil.getDataTypeAndLength(itemInfo));
            columnNameList.add(itemInfo.getNumber());
        }
        Iterator iter = schemeItemMap.keySet().iterator();
        List schemeItems = null;
        String key = null;
        String column_prefix = null;
        HashSet<String> canNotSumColumns = new HashSet<String>();
        while (iter.hasNext()) {
            key = iter.next().toString();
            column_prefix = (String)schemePrefixMap.get(key);
            schemeItems = (List)schemeItemMap.get(key);
            if (schemeItems == null || schemeItems.size() == 0) continue;
            int size2 = schemeItems.size();
            for (int i = 0; i < size2; ++i) {
                itemInfo = (CmpItemInfo)schemeItems.get(i);
                if (itemInfo == null) continue;
                createTableSql.append(",");
                createTableSql.append(column_prefix).append("_").append(itemInfo.getNumber());
                createTableSql.append(AppCmpReportUtil.getDataTypeAndLength(itemInfo));
                columnNameList.add(column_prefix + "_" + itemInfo.getNumber());
                int dataType = itemInfo.getDataType().getValue();
                if (dataType != 20 && dataType != 30 && dataType != 10) continue;
                canNotSumColumns.add(column_prefix + "_" + itemInfo.getNumber());
            }
        }
        if (!StringUtils.isEmpty((String)createTableSql.toString())) {
            createTableSql.append(" )");
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            temporaryTableName = pool.createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        CmpTempTableInfo tInfo = new CmpTempTableInfo();
        tInfo.setTableName(temporaryTableName);
        tInfo.setColumns(columnNameList);
        tInfo.setCanNotSumColumns(canNotSumColumns);
        return tInfo;
    }

    private static String getDataTypeAndLength(CmpItemInfo itemInfo) {
        int dataType = itemInfo.getDataType().getValue();
        String str = null;
        switch (dataType) {
            case 60: {
                str = " Decimal(22,8) ";
                break;
            }
            case 50: {
                str = " Decimal(22,8)";
                break;
            }
            case 40: {
                str = " Int ";
                break;
            }
            case 20: {
                str = " DATETIME ";
                break;
            }
            case 10: {
                str = " Int ";
                break;
            }
            case 30: {
                str = " nvarchar(255)";
                break;
            }
            default: {
                str = " varchar(44) ";
            }
        }
        return str;
    }

    private static String getConditions(String personTempTable, String schemeTable, boolean isUsePosition) {
        StringBuffer str = new StringBuffer();
        str.append(personTempTable).append(".FAdminOrgUnitID=").append(schemeTable).append(".FAdminOrgUnitID");
        if (isUsePosition) {
            str.append(" and (");
            str.append(personTempTable).append(".FPositionID=").append(schemeTable).append(".FPositionID");
            str.append(")");
        }
        str.append(" and ");
        str.append(personTempTable).append(".FPersonId=").append(schemeTable).append(".FPersonId");
        str.append(" and ");
        str.append(personTempTable).append(".FPeriodNum=").append(schemeTable).append(".FPeriodNum");
        str.append(" and ");
        str.append(personTempTable).append(".FTime=").append(schemeTable).append(".FTime");
        return str.toString();
    }

    private static String getConditionsWithPeriod(String dataTable, String schemeTable, boolean isUsePosition) {
        StringBuffer str = new StringBuffer();
        str.append(dataTable).append(".FAdminOrgUnitID=").append(schemeTable).append(".FAdminOrgUnitID");
        if (isUsePosition) {
            str.append(" and (");
            str.append(dataTable).append(".FPositionID=").append(schemeTable).append(".FPositionID");
            str.append(")");
        }
        str.append(" and ");
        str.append(dataTable).append(".FPersonId=").append(schemeTable).append(".FPersonId");
        str.append(" and ");
        str.append(dataTable).append(".FPeriodNum=").append("CP").append(".FNumber");
        str.append(" and ");
        str.append(dataTable).append(".FTime=").append(schemeTable).append(".FTime");
        return str.toString();
    }

    public static String createPersonTempTable(Context ctx, List cmpSchemeIds, String[] cmpPeriodNum) throws EASBizException, BOSException {
        return AppCmpReportUtil.createPersonTempTable(ctx, cmpSchemeIds, cmpPeriodNum, null, null);
    }

    public static String createPersonTempTable(Context ctx, List cmpSchemeIds, String[] cmpPeriodNum, EntityViewInfo personViewInfo, String schemeFilter) throws EASBizException, BOSException {
        if (cmpSchemeIds == null || cmpPeriodNum == null) {
            return null;
        }
        String tempTableName = null;
        String tmpTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        boolean isUsePersonInfoQuery = AppCmpReportUtil.isUsePersonInfoQuery(personViewInfo);
        try {
            StringBuffer createTmpSqlBuf = new StringBuffer();
            createTmpSqlBuf.append("create table personTempTableName(KSQL_SEQ int identity (1,1),fpersonid varchar(44),fAdminOrgUnitId varchar(44),FPositionID varchar(44),FPeriodNum NVarchar(80),FTime Int,fLongNumber nvarchar(");
            int longNumberLen = HRParamUtil.getTreeLongNumberLen((Context)ctx);
            createTmpSqlBuf.append(longNumberLen);
            createTmpSqlBuf.append("))");
            if (isUsePersonInfoQuery) {
                tmpTable = pool.createTempTable(createTmpSqlBuf.toString());
                createTmpSqlBuf = new StringBuffer();
                createTmpSqlBuf.append("create table personTempTableName(KSQL_SEQ int,fpersonid varchar(44),fAdminOrgUnitId varchar(44),FPositionID varchar(44),FPeriodNum NVarchar(80),FTime Int,fLongNumber nvarchar(");
                createTmpSqlBuf.append(longNumberLen);
                createTmpSqlBuf.append("))");
            }
            tempTableName = pool.createTempTable(createTmpSqlBuf.toString());
        }
        catch (Exception e1) {
            pool.releaseTable(tempTableName);
            pool.releaseTable(tmpTable);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer insertSql = null;
        Map schemeMap = HRSchemeUtils.getCmpSchemeDataTableNames(ctx, cmpSchemeIds, cmpPeriodNum);
        StringBuffer sqlBuf = null;
        String periodStr = AppCmpReportUtil.getPeriodNumbers(cmpPeriodNum);
        String currSchmId = null;
        String tblName = null;
        String permissionTab = HRSchemeUtils.getAddQueryPermissionTable(ctx);
        if (!isUsePersonInfoQuery) {
            insertSql = new StringBuffer();
            sqlBuf = new StringBuffer();
            int n = cmpSchemeIds.size();
            for (int i = 0; i < n; ++i) {
                currSchmId = (String)cmpSchemeIds.get(i);
                tblName = (String)schemeMap.get(currSchmId);
                if (StringUtils.isEmpty((String)tblName)) continue;
                if (sqlBuf.length() > 0) {
                    sqlBuf.append(" union ");
                }
                sqlBuf.append(" select fpersonid,fAdminOrgUnitId,FPositionID,T_HR_CMPPERIOD.FNumber as FPeriodNum,FTime,fLongNumber as FPeriod from ");
                if (StringUtils.indexOfIgnoreCase((String)tblName, (String)"select") > 0) {
                    sqlBuf.append("(" + tblName + ")");
                } else {
                    sqlBuf.append(tblName);
                }
                sqlBuf.append(" AS T inner join T_ORG_Admin on  T_ORG_Admin.fid=T.fAdminOrgUnitId ");
                sqlBuf.append(" inner join T_HR_CMPPERIOD on T_HR_CMPPERIOD.fid = T.FPERIOD ");
                sqlBuf.append(" where  T_HR_CMPPERIOD.fnumber in (");
                sqlBuf.append(periodStr);
                sqlBuf.append(")");
                if (StringUtils.isEmpty((String)schemeFilter)) continue;
                sqlBuf.append(" and ");
                sqlBuf.append(schemeFilter);
            }
            if (StringUtils.isEmpty((String)sqlBuf.toString())) {
                return tempTableName;
            }
            insertSql.append("insert into ").append(tempTableName).append("(KSQL_SEQ,fpersonid,fAdminOrgUnitId,FPositionID,FPeriodNum,FTime,fLongNumber) ").append("select TA.fpersonid,TA.fAdminOrgUnitId,TA.FPositionID,FPeriodNum,FTime,FPeriod from (").append(sqlBuf).append(") as TA");
            if (!StringUtils.isEmpty((String)permissionTab)) {
                insertSql.append(" inner join ");
                insertSql.append(permissionTab + " on TA.fpersonid=" + permissionTab + ".FPERSONID ");
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        } else {
            String personFilter = null;
            String tempTableAlias = "CmpSchemeDataTable";
            int n = cmpSchemeIds.size();
            for (int i = 0; i < n; ++i) {
                currSchmId = (String)cmpSchemeIds.get(i);
                tblName = (String)schemeMap.get(currSchmId);
                if (StringUtils.isEmpty((String)tblName)) continue;
                sqlBuf = new StringBuffer("( ");
                sqlBuf.append("select T.*,T_HR_CMPPERIOD.FNumber as FPeriodNum from ");
                if (StringUtils.indexOfIgnoreCase((String)tblName, (String)"select") > 0) {
                    sqlBuf.append("(" + tblName + ")");
                } else {
                    sqlBuf.append(tblName);
                }
                sqlBuf.append(" as T inner join T_HR_CMPPERIOD on T_HR_CMPPERIOD.fid = T.FPERIOD ");
                sqlBuf.append("where T_HR_CMPPERIOD.fnumber in (");
                sqlBuf.append(periodStr);
                sqlBuf.append(")");
                if (!StringUtils.isEmpty((String)schemeFilter)) {
                    sqlBuf.append(" and ");
                    sqlBuf.append(schemeFilter);
                }
                sqlBuf.append(")");
                personFilter = AppCmpReportUtil.getPersonFilterSql(ctx, personViewInfo, sqlBuf.toString(), tempTableAlias, permissionTab);
                personFilter = PersonInfoUtils.getOptimizeSql(personFilter);
                String orderByStr = null;
                int index = personFilter.indexOf("ORDER BY");
                if (index != -1) {
                    orderByStr = personFilter.substring(index);
                    personFilter = personFilter.substring(0, index);
                }
                insertSql = new StringBuffer("insert into ");
                insertSql.append(tmpTable);
                insertSql.append("(KSQL_SEQ,fpersonid,fAdminOrgUnitId,FPositionID,FPeriodNum,FTime,fLongNumber) select fpersonid,fAdminOrgUnitId,FPositionID,FPeriodNum,FTime,fLongNumber from (");
                insertSql.append(personFilter);
                insertSql.append(") AS T ");
                if (orderByStr != null) {
                    insertSql.append(orderByStr);
                }
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
            }
            StringBuffer sql = new StringBuffer("insert into ");
            sql.append(tempTableName);
            sql.append("(fpersonid,fAdminOrgUnitId,FPositionID,FPeriodNum,FTime,fLongNumber) ");
            sql.append("select distinct fpersonid,fAdminOrgUnitId,FPositionID,FPeriodNum,FTime,fLongNumber from ");
            sql.append(tmpTable);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            StringBuffer updateSql = new StringBuffer("update ");
            updateSql.append(tempTableName);
            updateSql.append(" set KSQL_SEQ = select top 1 KSQL_SEQ from ");
            updateSql.append(tmpTable);
            updateSql.append(" where ");
            updateSql.append(tmpTable);
            updateSql.append(".fpersonid = ");
            updateSql.append(tempTableName);
            updateSql.append(".fpersonid");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            pool.releaseTable(tmpTable);
        }
        try {
            pool.createIndex(tempTableName, "fpersonid,fadminorgunitid,fpositionid,fperiodnum,ftime", false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempTableName;
    }

    private static boolean isUsePersonInfoQuery(EntityViewInfo personViewInfo) {
        if (personViewInfo == null) {
            return false;
        }
        if (personViewInfo.getFilter() != null && personViewInfo.getFilter().getFilterItems().size() > 0) {
            return true;
        }
        return personViewInfo.getSorter() != null && personViewInfo.getSorter().size() > 0;
    }

    public static String getAdminFilter(Context ctx, AdminOrgUnitCollection colDept) throws BOSException {
        if (colDept == null || colDept.size() <= 0) {
            return null;
        }
        if (colDept.size() > 100) {
            String tempTableName = null;
            try {
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable("create table aa (FAdminOrgID varchar(44))");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                int size = colDept.size();
                for (int i = 0; i < size; ++i) {
                    paramsList.add(new Object[]{colDept.get(i).getId().toString()});
                }
                DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + " (FAdminOrgID) values(?) "), paramsList);
                ctx.put((Object)"ADMINTEMPTABLE", (Object)tempTableName);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            return "T.FAdminOrgUnitId in ( select FAdminOrgID from " + tempTableName + " )";
        }
        StringBuffer condition = new StringBuffer("T.FAdminOrgUnitId in (");
        int size = colDept.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                condition.append(",");
            }
            condition.append("'");
            condition.append(colDept.get(i).getId());
            condition.append("'");
        }
        condition.append(")");
        return condition.toString();
    }

    private static String getPersonFilterSql(Context ctx, EntityViewInfo personViewInfo, String schemTable, String schemeTableAlias, String permissionTab) throws EASBizException, BOSException {
        String strQueryPK = "com.kingdee.eas.hr.compensation.app.PersonInfoQuery";
        ArrayList<String[]> lstSelectItems = new ArrayList<String[]>();
        lstSelectItems.add(new String[]{"FPersonID", "\"PERSON\".FID"});
        lstSelectItems.add(new String[]{"FAdminOrgUnitID", "\"ATTACHDEPT\".FID"});
        lstSelectItems.add(new String[]{"FPositionID", "\"POSITION\".FID"});
        lstSelectItems.add(new String[]{"FPeriodNum", "\"cmpSchemePerson\".FPeriodNum"});
        lstSelectItems.add(new String[]{"FTime", "\"cmpSchemePerson\".FTime"});
        lstSelectItems.add(new String[]{"FLongNumber", "\"ATTACHDEPT\".Flongnumber"});
        ArrayList selectList = HRSchemeUtils.buildSelectListWithOrder(lstSelectItems);
        String rtnSql = HRSchemeUtils.getNoPermissionDynamicSqlByQuery(ctx, strQueryPK, schemTable, schemeTableAlias, selectList, personViewInfo, true);
        if (!StringUtils.isEmpty((String)permissionTab)) {
            rtnSql = HRSchemeUtils._innerAddPermissionTableSQL(ctx, rtnSql, permissionTab);
        }
        return rtnSql;
    }

    private static Map getSchemeItemMap(Context ctx, List schemeIDList, List itemList, boolean collectFlag, boolean notIncDelItem) throws BOSException {
        CmpItemInfo cmpItemInfo = null;
        HashSet<String> publicItemNumberSet = new HashSet<String>();
        int size = itemList.size();
        for (int i = 0; i < size; ++i) {
            cmpItemInfo = (CmpItemInfo)itemList.get(i);
            publicItemNumberSet.add(cmpItemInfo.getNumber());
        }
        HashSet schemeIDs = new HashSet();
        schemeIDs.addAll(schemeIDList);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme", schemeIDs, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", publicItemNumberSet, CompareType.INCLUDE));
        if (notIncDelItem) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cmpItem.number"));
        sic.add(new SelectorItemInfo("cmpItem.id"));
        sic.add(new SelectorItemInfo("isCollect"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        sic.add(new SelectorItemInfo("cmpScheme.number"));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("cmpItem.number"));
        sorter.add(new SorterItemInfo("cmpScheme.number"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filterInfo);
        viewInfo.setSorter(sorter);
        CmpSchemeItemCollection schemeItemColl = CmpSchemeItemFactory.getLocalInstance(ctx).getCmpSchemeItemCollection(viewInfo);
        if (schemeItemColl == null || schemeItemColl.size() == 0) {
            return new HashMap();
        }
        HashMap schmItemMap = new HashMap();
        Set<String> schemeItemSet = null;
        CmpSchemeItemInfo schemItemInfo = null;
        String schmId = null;
        int size2 = schemeItemColl.size();
        for (int i = 0; i < size2; ++i) {
            schemItemInfo = schemeItemColl.get(i);
            cmpItemInfo = schemeItemColl.get(i).getCmpItem();
            schmId = schemItemInfo.getCmpScheme().getId().toString();
            if (schmItemMap.containsKey(schmId)) {
                schemeItemSet = (Set)schmItemMap.get(schmId);
            } else {
                schemeItemSet = new LinkedHashSet();
                schmItemMap.put(schmId, schemeItemSet);
            }
            if (collectFlag) {
                if (!schemItemInfo.isIsCollect()) continue;
                schemeItemSet.add(cmpItemInfo.getNumber());
                continue;
            }
            if (schemItemInfo.isIsCollect()) continue;
            schemeItemSet.add(cmpItemInfo.getNumber());
        }
        return schmItemMap;
    }

    public static Map getHaveDataInPeriods(Context ctx, List schemeIDList, String[] periodNum) throws BOSException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        StringBuffer periodNums = new StringBuffer("'" + periodNum[0] + "'");
        for (int i = 1; i < periodNum.length; ++i) {
            periodNums.append(",'").append(periodNum[i]).append("'");
        }
        String ids = HRSchemeUtils.getStrFromList(schemeIDList);
        String oql = "select *,cmpPeriod.* where id in  " + ids;
        StringBuffer sbSql = null;
        CmpSchemeCollection cmpSchemes = iCmpScheme.getCmpSchemeCollection(oql);
        int time = 1;
        CmpSchemeInfo cmpSchemeInfo = null;
        String strCmpCurrentPeriodNum = null;
        String hisTableName = null;
        String horTableName = null;
        String strTableName = null;
        IRowSet rs = null;
        HashMap<String, String> schmTblMap = new HashMap<String, String>();
        int n = cmpSchemes.size();
        for (int i = 0; i < n; ++i) {
            cmpSchemeInfo = cmpSchemes.get(i);
            time = cmpSchemeInfo.getTime();
            strCmpCurrentPeriodNum = cmpSchemeInfo.getCmpPeriod().getNumber();
            hisTableName = cmpSchemeInfo.getHisTableName();
            horTableName = cmpSchemeInfo.getHorTableName();
            strTableName = null;
            if (hisTableName == null) {
                strTableName = horTableName;
            } else if (periodNum.length <= 1 && time <= 1) {
                if (periodNum.length == 1 && strCmpCurrentPeriodNum.equals(periodNum[0])) {
                    if (time == 1) {
                        strTableName = cmpSchemeInfo.getHorTableName();
                    }
                } else {
                    strTableName = cmpSchemeInfo.getHisTableName();
                }
            }
            if (StringUtils.isEmpty((String)strTableName)) {
                strTableName = " ( select FPersonID,fperiod from " + horTableName + " union all select FPersonID,fperiod from " + hisTableName + " )";
            }
            sbSql = new StringBuffer();
            sbSql.append("select count(T.FPersonID) from " + strTableName + " T ").append(" inner join t_hr_cmpperiod p on T.fperiod = p.fid where p.fnumber in (").append(periodNums).append(")");
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            try {
                if (!rs.next() || rs.getInt(1) <= 0) continue;
                schmTblMap.put(cmpSchemeInfo.getId().toString(), strTableName);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return schmTblMap;
    }
}

