/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.hr.compensation.AdjItemValue;
import com.kingdee.eas.hr.compensation.AdjStateEnum;
import com.kingdee.eas.hr.compensation.AffairFixedSalaryFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjHistoryFactory;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemCollection;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemInfo;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.IAffairFixedSalaryFacade;
import com.kingdee.eas.hr.compensation.ICmpAdjHistory;
import com.kingdee.eas.hr.compensation.ICmpAdjustScheme;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCmpAdjExecutorControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpAdjExecutorControllerBean
extends AbstractCmpAdjExecutorControllerBean {
    private static Logger logger = Logger.getLogger(CmpAdjExecutorControllerBean.class);

    @Override
    protected void _updCmpSchDataBySch(Context ctx, String adjSchID) throws BOSException, EASBizException, EASDBException {
        if (adjSchID == null) {
            return;
        }
        ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getLocalInstance(ctx);
        CmpAdjustSchemeInfo info = adjSch.getCmpAdjustSchemeInfo((IObjectPK)new ObjectUuidPK(adjSchID), HRUtils.getAdjustSchemeSelectors());
        if (!info.getAdjSchemeState().equals((Object)AdjStateEnum.APPROVED)) {
            return;
        }
        java.util.Date enableDate = info.getEffectDate();
        HashMap writeHisMap = new HashMap();
        CmpAdjSchItemInfo itemInfo = null;
        String empID = null;
        String cmpItemNum = null;
        BigDecimal oldValue = null;
        BigDecimal newValue = null;
        Object oldSalPoint = null;
        Object newSalPoint = null;
        int itemCount = 0;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            itemInfo = info.getEntries().get(i);
            empID = itemInfo.getAdjEmp().getId().toString();
            cmpItemNum = itemInfo.getAdjCmpItem().getNumber();
            oldValue = itemInfo.getOldValue();
            newValue = itemInfo.getNewValue();
            if (cmpItemNum.compareToIgnoreCase("FSAL000") != 0 ? newValue == null : itemInfo.getNewSalPoint() == null) continue;
            if (!writeHisMap.containsKey(empID)) {
                writeHisMap.put(empID, new HashMap());
            }
            Map cmpItemMap = (Map)writeHisMap.get(empID);
            AdjItemValue adjItemValue = new AdjItemValue();
            adjItemValue.setEffectDate(itemInfo.getEffectDate());
            adjItemValue.setRemark(itemInfo.getRemark());
            if (cmpItemNum.compareToIgnoreCase("FSAL000") == 0) {
                adjItemValue.setOldSalPoint(itemInfo.getOldSalPoint());
                adjItemValue.setNewSalPoint(itemInfo.getNewSalPoint());
            } else {
                adjItemValue.setNewValue(newValue);
                adjItemValue.setOldValue(oldValue);
            }
            adjItemValue.setCmpItemInfo(itemInfo.getAdjCmpItem());
            cmpItemMap.put(cmpItemNum, adjItemValue);
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        this.adjustFixedSalaryTable(ctx, adjSchID, info, true);
        ICmpAdjHistory adjHistory = CmpAdjHistoryFactory.getLocalInstance(ctx);
        adjHistory.writeAdjHistory(null, adjSchID, enableDate, writeHisMap);
    }

    /*
     * Loose catch block
     */
    private void adjustFixedSalaryTable(Context ctx, String adjSchId, CmpAdjustSchemeInfo model, boolean isAudit) throws BOSException, EASBizException {
        PreparedStatement pstmSalPointSalGrade;
        PreparedStatement pstm;
        Connection con;
        block24: {
            Map mapItems;
            con = null;
            if (model.getHrOrgUnit() == null) {
                return;
            }
            if (model.getEntries() == null || model.getEntries().size() == 0) {
                return;
            }
            FixedCmpSchemeInfo fixedInfo = model.getEntries().get(0).getFixedCmpScheme();
            String sql = null;
            IRowSet coll = null;
            if (fixedInfo == null) {
                String strHroId = model.getHrOrgUnit().getId().toString();
                sql = "select fhortablename from t_hr_fixedcmpScheme where fenable = 1 and fhrOrgUnitID = ? ";
                coll = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{strHroId});
            } else {
                sql = "select fhortablename from t_hr_fixedcmpScheme where fid = ? ";
                coll = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fixedInfo.getId().toString()});
            }
            String table = null;
            try {
                while (coll.next()) {
                    table = coll.getString("fhortablename");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (StringUtils.isEmpty(table)) {
                return;
            }
            CmpAdjSchItemInfo itemInfo = null;
            String empID = null;
            ArrayList<String> personIDList = new ArrayList<String>();
            String adjustID = null;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Object[] values = null;
            int size = model.getEntries().size();
            for (int i = 0; i < size; ++i) {
                itemInfo = model.getEntries().get(i);
                empID = itemInfo.getAdjEmp().getId().toString();
                adjustID = itemInfo.getAdjustReason().getId().toString();
                personIDList.add(empID);
                values = new Object[]{adjustID, empID};
                paramsList.add(values);
            }
            IAffairFixedSalaryFacade iAfs = AffairFixedSalaryFacadeFactory.getLocalInstance(ctx);
            ArrayList columnList = iAfs.getDynTableColumn(table);
            if (isAudit && columnList.contains("FADJUSTCAUSE".toUpperCase())) {
                String updateSql = "update " + table + " set FADJUSTCAUSE = ? where FPersonID = ? ";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
            if ((mapItems = this.getAdjustFixedItem(ctx, adjSchId)).size() == 0) {
                return;
            }
            List lstNumber = (List)mapItems.get("numbers");
            sql = this.createAdjustFixedSalarySql(table, lstNumber);
            pstm = null;
            pstmSalPointSalGrade = null;
            int size2 = lstNumber.size();
            CmpAdjSchItemCollection entries = model.getEntries();
            Map mapNewValue = this.regroupData(ctx, adjSchId, entries, mapItems, isAudit);
            try {
                con = this.getConnection(ctx);
                pstm = con.prepareStatement(sql);
                String sqlSalPointSalGrade = "update " + table + " set FSalPointSalGradeID = ? where FPersonID = ?";
                pstmSalPointSalGrade = con.prepareStatement(sqlSalPointSalGrade);
                Iterator itor = mapNewValue.entrySet().iterator();
                Map.Entry entry = null;
                while (itor.hasNext()) {
                    entry = itor.next();
                    String personid = (String)entry.getKey();
                    Map mapItemValue = (Map)entry.getValue();
                    int j = 1;
                    for (int i = 0; i < size2; ++i) {
                        String number = (String)lstNumber.get(i);
                        Object obj = mapItemValue.get(number);
                        if (number.compareToIgnoreCase("FSAL000") == 0) {
                            if (obj != null) {
                                pstm.setString(j++, obj.toString());
                                continue;
                            }
                            pstm.setString(j++, "");
                            continue;
                        }
                        if (obj != null) {
                            BigDecimal value = (BigDecimal)obj;
                            pstm.setBigDecimal(j++, value);
                            continue;
                        }
                        pstm.setBigDecimal(j++, new BigDecimal("0.00"));
                    }
                    pstm.setString(j++, personid);
                    pstm.addBatch();
                    int m = 1;
                    if (mapItemValue.get("FSalPointSalGradeID") != null) {
                        pstmSalPointSalGrade.setString(m++, mapItemValue.get("FSalPointSalGradeID").toString());
                    } else {
                        pstmSalPointSalGrade.setString(m++, null);
                    }
                    pstmSalPointSalGrade.setString(m++, personid);
                    pstmSalPointSalGrade.addBatch();
                }
                pstm.executeBatch();
                pstmSalPointSalGrade.executeBatch();
                if (personIDList.size() <= 0) break block24;
                StringBuffer updateDateSql = new StringBuffer();
                updateDateSql.append("update ").append(table).append(" hor set FOtherEnabledate = (");
                updateDateSql.append("select Max(item.FEffectDate) from T_HR_ADJSCHITEM item ");
                updateDateSql.append(" inner join T_HR_ADJSCHEME scheme on item.FADJSCHEMEID = scheme.fid ");
                updateDateSql.append(" where scheme.FadjSchemeState = 30 and item.fadjempid in ").append(CompUtils.getStrFromList(personIDList));
                updateDateSql.append(" and hor.FPersonID = item.fadjempid");
                updateDateSql.append(" group by item.FAdjEmpID )");
                updateDateSql.append(" where hor.fpersonid in ").append(CompUtils.getStrFromList(personIDList));
                DbUtil.execute((Context)ctx, (String)updateDateSql.toString());
                StringBuffer updatePerSql = new StringBuffer();
                updatePerSql.append("update T_HR_PersonCmp per set FLastAdjustSalDate = (");
                updatePerSql.append("select Max(item.FEffectDate) from T_HR_ADJSCHITEM item ");
                updatePerSql.append(" inner join T_HR_ADJSCHEME scheme on item.FADJSCHEMEID = scheme.fid ");
                updatePerSql.append(" where scheme.FadjSchemeState = 30 and item.fadjempid in ").append(CompUtils.getStrFromList(personIDList));
                updatePerSql.append(" and per.FPersonID = item.fadjempid");
                updatePerSql.append(" group by item.FAdjEmpID )");
                updatePerSql.append(" where per.fpersonid in ").append(CompUtils.getStrFromList(personIDList));
                DbUtil.execute((Context)ctx, (String)updatePerSql.toString());
            }
            catch (SQLException e1) {
                logger.error((Object)e1.getMessage());
                SQLUtils.cleanup((Statement)pstm, (Connection)con);
                SQLUtils.cleanup(pstmSalPointSalGrade);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstm, (Connection)con);
                        SQLUtils.cleanup(pstmSalPointSalGrade);
                        throw throwable;
                    }
                }
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
        SQLUtils.cleanup((Statement)pstmSalPointSalGrade);
    }

    private String createAdjustFixedSalarySql(String tableName, List lstItem) {
        StringBuffer buff = new StringBuffer(1024);
        buff.append("update " + tableName + " set ");
        int size = lstItem.size();
        for (int i = 0; i < size; ++i) {
            String number = (String)lstItem.get(i);
            if (i != 0) {
                buff.append(",");
            }
            buff.append(number + "=? ");
        }
        buff.append(" where fpersonid = ? ");
        return buff.toString();
    }

    private Map getAdjustFixedItem(Context ctx, String adjustId) throws BOSException {
        String sql = "select distinct a.fid,a.fnumber from t_hr_cmpitem a,t_hr_adjschitem b where a.fid=b.fadjcmpitemid and fadjschemeid = ?";
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, Object> mapItems = new HashMap<String, Object>(32);
        ArrayList<String> lstNumber = new ArrayList<String>(32);
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, adjustId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                mapItems.put(rs.getString(1), rs.getString(2));
                lstNumber.add(rs.getString(2));
            }
            mapItems.put("numbers", lstNumber);
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return mapItems;
    }

    @Override
    protected void _updCmpSchDataByItems(Context ctx, IObjectCollection itemCols, String tableName) throws BOSException, EASBizException, EASDBException {
    }

    private Map regroupData(Context ctx, String adjSchId, CmpAdjSchItemCollection entries, Map mapItems, boolean isAudit) throws EASBizException, BOSException {
        HashMap mapData = new HashMap(32);
        HashMap<String, Object> mapSub = null;
        Map effectdateMap = null;
        if (!isAudit) {
            effectdateMap = this.getLastEffectDate(ctx, adjSchId);
        }
        int esize = entries.size();
        for (int i = 0; i < esize; ++i) {
            CmpAdjSchItemInfo item = entries.get(i);
            String personid = item.getAdjEmp().getId().toString();
            if (mapData.containsKey(personid)) {
                mapSub = (HashMap<String, Object>)mapData.get(personid);
            } else {
                mapSub = new HashMap<String, Object>(16);
                mapData.put(personid, mapSub);
            }
            String itemId = item.getAdjCmpItem().getId().toString();
            if (!mapItems.containsKey(itemId)) continue;
            String number = (String)mapItems.get(itemId);
            if (number.compareToIgnoreCase("FSAL000") == 0) {
                SalariatHiberPropsInfo point;
                SalariatHiberPropsInfo salariatHiberPropsInfo = point = isAudit ? item.getNewSalPoint() : item.getOldSalPoint();
                if (point != null && point.getId() != null) {
                    mapSub.put(number, point.getId().toString());
                }
                String salPointSalGradeID = null;
                if (isAudit) {
                    if (item.getSalPointSalGradeID() != null) {
                        salPointSalGradeID = item.getSalPointSalGradeID().toString();
                    }
                } else if (item.getOldSalPointSalGradeID() != null) {
                    salPointSalGradeID = item.getOldSalPointSalGradeID().toString();
                }
                mapSub.put("FSalPointSalGradeID", salPointSalGradeID);
            } else {
                BigDecimal value = isAudit ? item.getNewValue() : item.getOldValue();
                mapSub.put(number, value);
            }
            if (mapSub.containsKey("effectdate")) continue;
            if (!isAudit && effectdateMap != null) {
                mapSub.put("effectdate", effectdateMap.get(personid));
                continue;
            }
            mapSub.put("effectdate", item.getEffectDate());
        }
        return mapData;
    }

    private Map getLastAdjustData(Context ctx, String adjSchId, CmpAdjSchItemCollection entries, Map mapItems, boolean isAudit) throws EASBizException, BOSException {
        HashMap mapData = new HashMap(32);
        HashMap<String, Object> mapSub = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select aa.FOldValue,aa.FAdjDate,aa.FNewValue,aa.FCmpAdjustSchemeID,aa.FCmpItemID,aa.FAdjEmpID,aa.FOldSalPoint,aa.FNewSalPoint,").append(" adjItem.FSalPointSalGradeID,adjItem.FOldSalPointSalGradeID ").append(" from T_HR_CMPADJHISTORY aa ").append(" inner join ( select distinct fadjempid,max(fadjdate) as fadjdate ").append(" from T_HR_CMPADJHISTORY ").append(" where fadjempid in (select FAdjEmpID from T_HR_ADJSCHITEM where FADJSCHEMEID =  ? )");
        if (!isAudit) {
            sql.append(" and FCmpAdjustSchemeID <> ? ");
        }
        sql.append(" group by fadjempid ) bb ").append(" on aa.fadjempid = bb.fadjempid and aa.fadjdate = bb.fadjdate").append(" left outer join T_HR_ADJSCHITEM adjItem ").append(" on aa.FCmpAdjustSchemeID = adjItem.FADJSCHEMEID and aa.FCmpItemID = adjItem.FAdjCmpItemID and aa.FAdjEmpID = adjItem.FAdjEmpID");
        IRowSet iRowSet = null;
        iRowSet = isAudit ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{adjSchId}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{adjSchId, adjSchId});
        try {
            while (iRowSet.next()) {
                String itemId;
                String personid = iRowSet.getString("FAdjEmpID");
                if (mapData.containsKey(personid)) {
                    mapSub = (HashMap<String, Object>)mapData.get(personid);
                } else {
                    mapSub = new HashMap<String, Object>(16);
                    mapData.put(personid, mapSub);
                }
                if (!mapItems.containsKey(itemId = iRowSet.getString("FCmpItemID"))) continue;
                String number = (String)mapItems.get(itemId);
                if (number.compareToIgnoreCase("FSAL000") == 0) {
                    String point = iRowSet.getString("FNewSalPoint");
                    if (point != null) {
                        mapSub.put(number, point);
                    }
                    String salPointSalGradeID = null;
                    if (iRowSet.getString("FSalPointSalGradeID") != null) {
                        salPointSalGradeID = iRowSet.getString("FSalPointSalGradeID");
                    }
                    mapSub.put("FSalPointSalGradeID", salPointSalGradeID);
                } else {
                    String value = null;
                    value = iRowSet.getString("FNewValue");
                    mapSub.put(number, value);
                }
                if (mapSub.containsKey("effectdate")) continue;
                mapSub.put("effectdate", iRowSet.getDate("FAdjDate"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return mapData;
    }

    @Override
    protected void _updCmpSchBalance(Context ctx, String adjSchID, Map adjItemMap) throws BOSException, EASBizException, EASDBException {
        if (adjSchID == null || adjItemMap == null) {
            return;
        }
        String tableName = "info.getCmpScheme().getHorTableName();";
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(tableName);
        sql.append(" set FSAL030= ? where FPERSONID= ?");
        PreparedStatement pstm = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            Iterator itl = adjItemMap.entrySet().iterator();
            Map.Entry entry = null;
            while (itl.hasNext()) {
                entry = itl.next();
                String empId = (String)entry.getKey();
                BigDecimal balanceValue = (BigDecimal)entry.getValue();
                pstm.setBigDecimal(1, balanceValue);
                pstm.setString(2, empId);
                pstm.executeUpdate();
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    @Override
    protected List _getPrePeriodAdjSch(Context ctx, String cmpSchID, java.util.Date startDate) throws BOSException, EASBizException, EASDBException {
        if (cmpSchID == null || startDate == null) {
            return null;
        }
        ArrayList<String> rst = new ArrayList<String>();
        Connection con = null;
        String sql = "SELECT fid from T_HR_ADJSCHEME where FAdjSchemeState=30 and FEffectDate < ? and FCmpSchemeID= ? order by FEffectDate DESC";
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql);
            pstm.setDate(1, Date.valueOf(HRUtils.utilDateToString(startDate)));
            pstm.setString(2, cmpSchID);
            rs = pstm.executeQuery();
            while (rs.next()) {
                rst.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return rst;
    }

    @Override
    protected List _getPrePeriodAdjSch(Context ctx, String schemeID, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException, EASDBException {
        if (schemeID == null) {
            return null;
        }
        ArrayList<String> rst = new ArrayList<String>();
        Connection con = null;
        String sql = "SELECT fid from T_HR_ADJSCHEME where FAdjSchemeState=30 and FEffectDate >= ? and FEffectDate <= ? and FCmpSchemeID= ? order by FEffectDate DESC";
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql);
            pstm.setDate(1, Date.valueOf(HRUtils.utilDateToString(beginDate)));
            pstm.setDate(2, Date.valueOf(HRUtils.utilDateToString(endDate)));
            pstm.setString(3, schemeID);
            rs = pstm.executeQuery();
            while (rs.next()) {
                rst.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return rst;
    }

    @Override
    protected HashMap _getAlreadyInAdjustScheme(Context ctx, ArrayList strPersonIds, String adjustSchemeID) throws BOSException, EASBizException {
        HashMap<String, String> mapEmpnumberAlreadyIn = new HashMap<String, String>();
        String strMsg = "";
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct TPerson.fid,TPerson.FNumber,TPerson.FName_" + ctx.getLocale().toString());
        sql.append(" from T_HR_ADJSCHEME TScheme");
        sql.append(" inner join T_HR_ADJSCHITEM TItem on TItem.FADJSCHEMEID = TScheme.Fid");
        sql.append(" inner join T_bd_person TPerson on TPerson.fid = TItem.FAdjEmpID");
        sql.append(" where TScheme.FAdjSchemeState in (10,20,70)");
        sql.append(" and TItem.FAdjEmpID in ");
        if (strPersonIds == null) {
            sql.append("(select distinct FAdjEmpID from T_HR_ADJSCHITEM where FADJSCHEMEID ='").append(adjustSchemeID).append("')");
        } else if (strPersonIds.size() != 0) {
            sql.append(CompUtils.getStrFromList(strPersonIds));
        } else {
            return mapEmpnumberAlreadyIn;
        }
        if (adjustSchemeID != null) {
            sql.append(" and TScheme.fid <> '" + adjustSchemeID + "'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                strMsg = rs.getString(2) + "(" + rs.getString(3) + ")";
                mapEmpnumberAlreadyIn.put(rs.getString(1), strMsg);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return mapEmpnumberAlreadyIn;
    }

    @Override
    protected void _cancelAuditAdjSch(Context ctx, String adjustSchID) throws BOSException, EASBizException {
        if (adjustSchID == null) {
            return;
        }
        ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getLocalInstance(ctx);
        CmpAdjustSchemeInfo info = adjSch.getCmpAdjustSchemeInfo((IObjectPK)new ObjectUuidPK(adjustSchID), HRUtils.getAdjustSchemeSelectors());
        this.adjustFixedSalaryTable(ctx, adjustSchID, info, false);
        ICmpAdjHistory adjHistory = CmpAdjHistoryFactory.getLocalInstance(ctx);
        try {
            adjHistory.delByCmpScheme(null, adjustSchID);
        }
        catch (EASDBException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getLastEffectDate(Context ctx, String adjustSchID) throws BOSException, EASBizException {
        if (adjustSchID == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select t1.fadjempid, max(t1.feffectdate) as feffectdate ").append(" from t_hr_adjschitem t1 inner join t_hr_adjscheme t2 on t2.fid = t1.fadjschemeid ").append("where t2.fadjschemestate=30 and t1.fadjempid in (").append(" select fadjempid from t_hr_adjschitem where fadjschemeid =? ").append(" ) ").append("  group by t1.fadjempid  ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{adjustSchID});
        HashMap<String, Date> effectdateMap = new HashMap<String, Date>();
        try {
            while (iRowSet.next()) {
                effectdateMap.put(iRowSet.getString("fadjempid"), iRowSet.getDate("feffectdate"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return effectdateMap;
    }
}

