/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.CombinCmpItemInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.app.AbstractCmpSchemeItemControllerBean;
import com.kingdee.eas.hr.compensation.app.CmpItemTempTableUtil;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpSchemeItemControllerBean
extends AbstractCmpSchemeItemControllerBean {
    private static Logger logger = Logger.getLogger(CmpSchemeItemControllerBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getAllItemsByScheme(Context ctx, List schemeIDs, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cmpItem.*"));
        sic.add(new SelectorItemInfo("cmpItem.CmpItemCatalog.number"));
        sic.add(new SelectorItemInfo("isCollect"));
        sic.add(new SelectorItemInfo("sortOrder"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        sic.add(new SelectorItemInfo("cmpScheme.number"));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo isCollSort = new SorterItemInfo("isCollect");
        isCollSort.setSortType(SortType.DESCEND);
        sorter.add(isCollSort);
        sorter.add(new SorterItemInfo("cmpScheme.number"));
        sorter.add(new SorterItemInfo("sortOrder"));
        viewInfo.setSelector(sic);
        viewInfo.setSorter(sorter);
        CmpItemTempTableUtil util = new CmpItemTempTableUtil();
        try {
            FilterInfo ruleFilter = new FilterInfo("cmpItem.id in " + util.getCmpItemViewConstraintSql(ctx, this.getBOSType()));
            if (viewInfo.getFilter() != null) {
                viewInfo.getFilter().mergeFilter(ruleFilter, "and");
            } else {
                viewInfo.setFilter(ruleFilter);
            }
            CmpSchemeItemCollection schemeItemColl = this.getCmpSchemeItemCollection(ctx, viewInfo);
            if (schemeItemColl == null || schemeItemColl.size() == 0) {
                List list = null;
                return list;
            }
            HashMap<String, CombinCmpItemInfo> itemMap = new HashMap<String, CombinCmpItemInfo>();
            CombinCmpItemInfo combinCmpItemInfo = null;
            CombinCmpItemInfo combinInfo = null;
            CmpItemInfo cmpItemInfo = null;
            ArrayList<CombinCmpItemInfo> returnList = new ArrayList<CombinCmpItemInfo>();
            for (int i = 0; i < schemeItemColl.size(); ++i) {
                combinCmpItemInfo = new CombinCmpItemInfo();
                cmpItemInfo = schemeItemColl.get(i).getCmpItem();
                combinCmpItemInfo.setCmpItemInfo(cmpItemInfo);
                combinCmpItemInfo.setSortOrder(schemeItemColl.get(i).getSortOrder());
                combinCmpItemInfo.setNumber(cmpItemInfo.getNumber());
                combinCmpItemInfo.setId(schemeItemColl.get(i).getId().toString());
                String collectSate = null;
                collectSate = cmpItemInfo.getNumber().startsWith("FPER") ? "1" : (cmpItemInfo.getNumber().startsWith("FFPER") ? "0" : (schemeItemColl.get(i).isIsCollect() ? "1" : "0"));
                combinCmpItemInfo.setCollectState(collectSate);
                if (itemMap.containsKey(cmpItemInfo.getNumber())) {
                    combinInfo = (CombinCmpItemInfo)itemMap.get(cmpItemInfo.getNumber());
                    if (cmpItemInfo.getNumber().startsWith("FPER")) {
                        combinInfo.setCollectState("1");
                        continue;
                    }
                    if (cmpItemInfo.getNumber().startsWith("FFPER")) {
                        combinInfo.setCollectState("0");
                        continue;
                    }
                    if (combinInfo.getCmpItemInfo().getDecDigital() < cmpItemInfo.getDecDigital()) {
                        combinInfo.setCmpItemInfo(cmpItemInfo);
                    }
                    if (collectSate.equals(combinInfo.getCollectState())) continue;
                    combinInfo.setCollectState("10");
                    continue;
                }
                itemMap.put(cmpItemInfo.getNumber(), combinCmpItemInfo);
                returnList.add(combinCmpItemInfo);
            }
            itemMap = null;
            ArrayList<CombinCmpItemInfo> arrayList = returnList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List list = null;
            return list;
        }
        finally {
            util.release();
        }
    }

    @Override
    protected boolean _updateCollectFlag(Context ctx, CmpItemInfo cmpItem) throws BOSException, EASBizException {
        BOSUuid Id = cmpItem.getId();
        String sql = "update T_HR_CMPSCHEMEITEM set fIsCollect=0 where FCmpItemID= '" + Id.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected CmpItemCollection _getUnionSchemeItemColl(Context ctx, List schemeIDs, EntityViewInfo viewInfo, boolean isAddPersonItem) throws BOSException, EASBizException {
        CmpSchemeItemCollection schemeItemColl = this.getCmpSchemeItemCollection(ctx, viewInfo);
        if (schemeItemColl == null || schemeItemColl.size() == 0) {
            return null;
        }
        CmpItemCollection cmpItemColl = null;
        if (isAddPersonItem) {
            try {
                cmpItemColl = this.getPersonItem(ctx);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                cmpItemColl = new CmpItemCollection();
            }
        } else {
            cmpItemColl = new CmpItemCollection();
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        int count = schemeItemColl.size();
        for (int i = 0; i < count; ++i) {
            CmpSchemeItemInfo cmpSchemeItemInfo = schemeItemColl.get(i);
            CmpItemInfo cmpItemInfo = cmpSchemeItemInfo.getCmpItem();
            if (itemMap.containsKey(cmpItemInfo.getId().toString())) continue;
            itemMap.put(cmpItemInfo.getId().toString(), "true");
            cmpItemColl.add(cmpItemInfo);
        }
        return cmpItemColl;
    }

    private CmpItemCollection getPersonItem(Context ctx) throws BOSException, SQLException {
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        ArrayList personItems = HRCmpItemUtils.getMappingPersonItems(ctx, 1);
        HashSet set = new HashSet();
        if (personItems != null) {
            set.addAll(personItems);
        }
        String hroId = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        String sql = "SELECT FID FROM T_HR_CMPITEMCAT WHERE FNUMBER = 'FPER' AND FHRORGUNITID = '" + hroId + "'";
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.id", (Object)sql, CompareType.INNER));
        fi.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10));
        if (set != null && set.size() != 0) {
            fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10, CompareType.NOTEQUALS));
            fi.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
            fi.setMaskString("#0 and #1 and (#2 or (#3 and #4))");
        } else {
            fi.setMaskString("#0 and #1 and #2 ");
        }
        viewInfo.setFilter(fi);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("number");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterOrderItem1);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        CmpItemInfo cmpItemInfo = null;
        CmpItemCatalogInfo infoTemp = null;
        while (rs.next()) {
            cmpItemInfo = new CmpItemInfo();
            cmpItemInfo.setId(BOSUuid.read((String)rs.getString("id")));
            cmpItemInfo.setNumber(rs.getString("number"));
            cmpItemInfo.setName(rs.getString("name"));
            cmpItemInfo.setDataType(ItemDataTypeEnum.getEnum(rs.getInt("dataType")));
            cmpItemInfo.setDecDigital(rs.getInt("decDigital"));
            cmpItemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(rs.getInt("precisionType")));
            infoTemp = new CmpItemCatalogInfo();
            infoTemp.setId(BOSUuid.read((String)rs.getString("cmpItemCatalog.id")));
            cmpItemInfo.setCmpItemCatalog(infoTemp);
            cmpItemColl.add(cmpItemInfo);
        }
        return cmpItemColl;
    }

    @Override
    protected HashSet _getDeletedCmpItem(Context ctx, List schemeIDs) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select item.fnumber as fnumber from T_HR_CMPITEM item \n");
        sb.append(" inner join T_HR_CMPSCHEMEITEM schItem on schItem.FCmpItemID = item.FID \n");
        sb.append("where (schItem.FIsDelete = 0 or schItem.FIsDelete is null )\n");
        sb.append(" and schItem.FCmpSchemeID in ");
        sb.append(HRSchemeUtils.getStrFromList(schemeIDs));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                set.add(rows.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return set;
    }

    @Override
    protected HashMap _getSchemeItemEndInputEdit(Context ctx, HashMap mapSchemeId) throws BOSException, EASBizException {
        if (mapSchemeId.get("schemeID") == null) {
            return null;
        }
        String schemeID = mapSchemeId.get("schemeID").toString();
        String sql = "select FCmpItemID,FIsEndInputEdit from T_HR_CMPSCHEMEITEM where FCmpSchemeID = '" + schemeID + "' and fisdelete = 0";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Serializable> stateResult = new HashMap<String, Serializable>();
        ArrayList<String> listCmpItem = new ArrayList<String>();
        try {
            while (rows.next()) {
                listCmpItem.add(rows.getString("FCmpItemID"));
                stateResult.put(rows.getString("FCmpItemID"), Boolean.valueOf(rows.getBoolean("FIsEndInputEdit")));
            }
            stateResult.put("listCompItem", listCmpItem);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return stateResult;
    }

    @Override
    protected CmpItemCollection _getSchemeItemByOrder(Context ctx, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        String cmpItemids = HRUtils.getCmpItemIds(ctx);
        if (cmpItemids != null && cmpItemids.length() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)cmpItemids, CompareType.INNER));
            viewInfo.getFilter().mergeFilter(fi, "and");
        }
        CmpSchemeItemCollection cmpSchemeItemColl = this.getCmpSchemeItemCollection(ctx, viewInfo);
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        CmpSchemeItemInfo cmpSchemeItemTemp = null;
        int j = cmpSchemeItemColl.size();
        for (int i = 0; i < j; ++i) {
            cmpSchemeItemTemp = cmpSchemeItemColl.get(i);
            cmpItemColl.add(cmpSchemeItemTemp.getCmpItem());
        }
        return cmpItemColl;
    }

    @Override
    protected Map _getPreviousCmpPeriodVals(Context ctx, Map paramsMap) throws BOSException {
        CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)paramsMap.get("infoCmpScheme");
        CmpPeriodInfo infoCmpPeriod = (CmpPeriodInfo)paramsMap.get("infoCmpPeriod");
        int time = Integer.parseInt(paramsMap.get("time").toString());
        HashMap<String, String> map = new HashMap<String, String>();
        Date beginDate = infoCmpPeriod.getBeginDate();
        String previousCmpPeriodId = infoCmpPeriod.getId().toString();
        int previousCmpPeriodTime = 0;
        CmpSchemeInfo cmpSchemeInfo = null;
        try {
            cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo("select hisTableName where id='" + infoCmpScheme.getId().toString() + "'");
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        if (cmpSchemeInfo != null) {
            if (cmpSchemeInfo.getHisTableName() == null) {
                return null;
            }
            infoCmpScheme.setHisTableName(cmpSchemeInfo.getHisTableName());
        }
        if (time == 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("select top 1 fid from  T_HR_CMPPERIOD where fbeginDate < {ts'");
            sb.append(DateTimeUtils.format((Date)beginDate));
            sb.append("'} and FHROrgUnitID='");
            sb.append(HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString());
            sb.append("'order by fbeginDate desc");
            IRowSet iRowSetCmpPeriod = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (iRowSetCmpPeriod.next()) {
                    previousCmpPeriodId = iRowSetCmpPeriod.getString(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
            String hisTableName = infoCmpScheme.getHisTableName();
            sb.setLength(0);
            sb.append("select Max(ftime) as maxTime from ");
            sb.append(hisTableName);
            sb.append(" where fperiod='");
            sb.append(previousCmpPeriodId);
            sb.append("'");
            IRowSet iRowSetHisTableVal = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (iRowSetHisTableVal.next()) {
                    previousCmpPeriodTime = iRowSetHisTableVal.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        previousCmpPeriodTime = time - 1;
        String sqlItem = " SELECT T_HR_CMPITEM.FID,T_HR_CMPITEM.FNUMBER FROM T_HR_CMPSCHEMEITEM  LEFT OUTER JOIN T_HR_CMPITEM ON T_HR_CMPITEM.FID=T_HR_CMPSCHEMEITEM.FCMPITEMID WHERE FCMPSCHEMEID='" + infoCmpScheme.getId().toString() + "' AND FIsValueKeep =1 AND FIsSignDataChange = 1 AND FIsDelete=0";
        IRowSet iRowSetItem = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
        ArrayList<String> lstItem = new ArrayList<String>();
        ArrayList<String> lstItemNumber = new ArrayList<String>();
        try {
            while (iRowSetItem.next()) {
                lstItem.add(iRowSetItem.getString(1));
                lstItemNumber.add(iRowSetItem.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String personID = null;
        String itemNumber = null;
        String cmpitemValue = null;
        String hisdataTabName = infoCmpScheme.getHisTableName();
        if (previousCmpPeriodId != null && previousCmpPeriodTime > 0) {
            StringBuffer sqlSelect = new StringBuffer();
            sqlSelect.append(" SELECT fpersonId");
            int size = lstItemNumber.size();
            for (int i = 0; i < size; ++i) {
                sqlSelect.append(",");
                sqlSelect.append(lstItemNumber.get(i));
            }
            sqlSelect.append(" FROM ");
            sqlSelect.append(hisdataTabName);
            sqlSelect.append(" WHERE ");
            sqlSelect.append(" FTime=");
            sqlSelect.append(String.valueOf(previousCmpPeriodTime));
            sqlSelect.append(" and fperiod='");
            sqlSelect.append(previousCmpPeriodId);
            sqlSelect.append("'");
            IRowSet iRowSetSelect = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
            try {
                while (iRowSetSelect.next()) {
                    personID = iRowSetSelect.getString("FPERSONID");
                    int size2 = lstItem.size();
                    for (int i = 0; i < size2; ++i) {
                        itemNumber = lstItemNumber.get(i).toString();
                        cmpitemValue = iRowSetSelect.getString(itemNumber);
                        map.put(personID + "&" + lstItem.get(i), cmpitemValue);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectCollection _getSchemeItemsByItemPerm(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        CmpItemTempTableUtil util = new CmpItemTempTableUtil();
        try {
            FilterInfo filter = new FilterInfo("cmpItem.id in " + util.getCmpItemViewConstraintSql(ctx, this.getBOSType()));
            if (view != null & view.getFilter() != null) {
                view.getFilter().mergeFilter(filter, "and");
            }
            CoreBaseCollection coreBaseCollection = this.getCollection(ctx, view);
            return coreBaseCollection;
        }
        catch (Exception e) {
            e.printStackTrace();
            IObjectCollection iObjectCollection = null;
            return iObjectCollection;
        }
        finally {
            util.release();
        }
    }
}

