/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.AssignTypeEnum;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandardAmountEnum;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeCmpItemsCollection;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeCmpItemsFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeException;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.IDepCmpStandradScheme;
import com.kingdee.eas.hr.compensation.IDeptInnerScheme;
import com.kingdee.eas.hr.compensation.IDeptInnerSchemeEntry;
import com.kingdee.eas.hr.compensation.IDeptSchemeEntry;
import com.kingdee.eas.hr.compensation.InputTypeEnum;
import com.kingdee.eas.hr.compensation.PeriodEndInputInfo;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.app.AbstractDeptSchemeEntryControllerBean;
import com.kingdee.eas.hr.compensation.util.DeptInnerSchemePersonHisUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeptSchemeEntryControllerBean
extends AbstractDeptSchemeEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.DeptSchemeEntryControllerBean");
    private CmpSchemeInfo cmpSchemeInfo = null;
    private boolean isPersonRange = false;

    @Override
    protected void _release(Context ctx, IObjectPK pk) throws BOSException, DeptSchemeException, EASBizException {
    }

    @Override
    protected void _submitWF(Context ctx, BOSUuid depEntryID) throws BOSException, EASBizException {
        if (depEntryID == null) {
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
        this._auditApproving(ctx, depEntryID);
    }

    @Override
    protected void _auditApproved(Context ctx, BOSUuid depEntryID) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deptInnerScheme.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("cmpPeriod.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)depEntryID.toString()));
        entityViewInfo.setFilter(filterInfo);
        DeptSchemeEntryCollection deptSchemeEntityCollection = DeptSchemeEntryFactory.getLocalInstance(ctx).getDeptSchemeEntryCollection(entityViewInfo);
        DeptSchemeEntryInfo deptSchemeEntryInfoGolTemp = null;
        if (deptSchemeEntityCollection.size() <= 0) {
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
        deptSchemeEntryInfoGolTemp = deptSchemeEntityCollection.get(0);
        HashMap cmpItemsMap = this.getDeptInnerCmpItems(ctx, deptSchemeEntryInfoGolTemp);
        BigDecimal sendRateVal = deptSchemeEntryInfoGolTemp.getSendRate();
        if (sendRateVal == null) {
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
        CmpPeriodInfo cmpPeriodInfoGol = deptSchemeEntryInfoGolTemp.getCmpPeriod();
        try {
            HashMap returnMap = this.processPersonalCmpItemValue(ctx, deptSchemeEntryInfoGolTemp, cmpItemsMap, sendRateVal);
            HashMap endInputMap = (HashMap)returnMap.get("endInputMapKey");
            BigDecimal sumValue = new BigDecimal(returnMap.get("PlanTotalVlaueKey").toString());
            BigDecimal bgDispentTotal = sumValue.multiply(deptSchemeEntryInfoGolTemp.getSendRate());
            BigDecimal bgLeaveTotal = sumValue.subtract(bgDispentTotal);
            ArrayList<Serializable> endInputList = new ArrayList<Serializable>();
            endInputList.add(cmpPeriodInfoGol);
            endInputList.add(cmpItemsMap);
            endInputList.add(endInputMap);
            DeptInnerSchemeEntryFactory.getLocalInstance(ctx).aduitAction((IObjectValue)deptSchemeEntryInfoGolTemp, bgDispentTotal, bgLeaveTotal, endInputList, deptSchemeEntryInfoGolTemp.getDeptScheme());
        }
        catch (Exception ex) {
            throw new BOSException("workflow error!");
        }
    }

    private HashMap processPersonalCmpItemValue(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo, HashMap cmpItemsMap, BigDecimal sendRate) throws SQLException, DeptSchemeException, BOSException {
        String zeroString = "0.00";
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        HashMap endInputMap = new HashMap();
        IRowSet personRowSet = this.getPersonDeptInnerSchEntryData(ctx, deptSchemeEntryInfo);
        CmpItemInfo cmpItemInfoTemp = null;
        HashMap<String, String> hashDataMap = new HashMap<String, String>();
        String initZero = "0.00";
        BigDecimal sumValue = new BigDecimal(initZero);
        while (personRowSet.next()) {
            if (personRowSet.getBigDecimal("FAmount") == null) continue;
            if (personRowSet.getString("FCmpItemID") == null || !cmpItemsMap.containsKey(personRowSet.getString("FCmpItemID"))) {
                throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
            }
            if (cmpItemInfoTemp == null) {
                cmpItemInfoTemp = (CmpItemInfo)cmpItemsMap.get(personRowSet.getString("FCmpItemID"));
            }
            if (!cmpItemInfoTemp.getId().toString().equals(personRowSet.getString("FCmpItemID"))) {
                endInputMap.put(cmpItemInfoTemp.getId().toString(), hashDataMap);
                hashDataMap = new HashMap();
                cmpItemInfoTemp = (CmpItemInfo)cmpItemsMap.get(personRowSet.getString("FCmpItemID"));
            }
            if (personRowSet.getString("FPersonID") != null) {
                sumValue = sumValue.add(personRowSet.getBigDecimal("FAmount"));
                BigDecimal bg = personRowSet.getBigDecimal("FAmount");
                if (bg.compareTo(new BigDecimal(zeroString)) != 0) {
                    bg = personRowSet.getBigDecimal("FAmount").multiply(sendRate).setScale(2);
                }
                hashDataMap.put(personRowSet.getString("FPersonID"), bg.toString());
                continue;
            }
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
        endInputMap.put(cmpItemInfoTemp.getId().toString(), hashDataMap);
        returnMap.put("endInputMapKey", endInputMap);
        returnMap.put("PlanTotalVlaueKey", sumValue);
        return returnMap;
    }

    private IRowSet getPersonDeptInnerSchEntryData(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo) throws BOSException {
        IRowSet personRowSet = null;
        DeptInnerSchemeInfo deptInnerSchemeInfo = deptSchemeEntryInfo.getDeptInnerScheme();
        String sqlSelectStr = "SELECT * FROM T_HR_DeptInnerSchemeEntry WHERE FDeptInnerSchemeID ='" + deptInnerSchemeInfo.getId().toString() + "' ORDER BY FCmpItemID";
        personRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSelectStr);
        return personRowSet;
    }

    private HashMap getDeptInnerCmpItems(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo) throws BOSException {
        HashMap<String, CmpItemInfo> cmpItemsMap = new HashMap<String, CmpItemInfo>();
        String deptInnerSchemePKString = deptSchemeEntryInfo.getDeptInnerScheme().getId().toString();
        EntityViewInfo entTemp = new EntityViewInfo();
        entTemp.getSelector().add(new SelectorItemInfo("*"));
        entTemp.getSelector().add(new SelectorItemInfo("cmpItem.*"));
        FilterInfo filterInfoTemp = new FilterInfo();
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("deptInnerScheme", (Object)deptInnerSchemePKString));
        entTemp.setFilter(filterInfoTemp);
        DeptInnerSchemeCmpItemsCollection depInnerCmpItemsCollection = DeptInnerSchemeCmpItemsFactory.getLocalInstance(ctx).getDeptInnerSchemeCmpItemsCollection(entTemp);
        int sizeTemp = depInnerCmpItemsCollection.size();
        for (int i = 0; i < sizeTemp; ++i) {
            CmpItemInfo cmpItemInfo = depInnerCmpItemsCollection.get(i).getCmpItem();
            cmpItemsMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
        }
        return cmpItemsMap;
    }

    @Override
    protected void _aduitNotApproved(Context ctx, BOSUuid depEntryID) throws BOSException, EASBizException {
        this.updateFaudit(ctx, depEntryID, 30);
    }

    @Override
    protected void _auditApproving(Context ctx, BOSUuid depEntiryID) throws BOSException, EASBizException {
        this.updateFaudit(ctx, depEntiryID, 20);
    }

    private void updateFaudit(Context ctx, BOSUuid id, int auditState) throws BOSException, EASBizException {
        String sqlSelectStr = "SELECT FDeptInnerSchemeID FROM T_HR_DEPTSCHEMEENTRY WHERE FID = '" + id.toString() + "'";
        IRowSet rowSetTemp = DbUtil.executeQuery((Context)ctx, (String)sqlSelectStr);
        String depInnerSchemId = "";
        try {
            if (rowSetTemp.next()) {
                depInnerSchemId = rowSetTemp.getString("FDeptInnerSchemeID");
            }
        }
        catch (SQLException e) {
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
        if ("".equals(depInnerSchemId)) {
            throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
        }
    }

    private String getPersonalType(DepCmpStandardAmountEnum standAmountEnum) {
        switch (standAmountEnum.getValue()) {
            case 20: {
                return "position.id";
            }
            case 10: {
                return "JobGrade.id";
            }
            case 30: {
                return "Diploma.id";
            }
        }
        return null;
    }

    private EntityViewInfo getFilterForSys(Context ctx, AdminOrgUnitInfo adminOrgInfo, boolean hasSubDept, DepCmpStandardAmountEnum depStandEnum, boolean hasPositonFlag) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("FPersonID"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("FPER002"));
        if (depStandEnum.getValue() != 20 || hasPositonFlag) {
            entityViewInfo.getSelector().add(new SelectorItemInfo(this.getPersonalType(depStandEnum)));
        }
        FilterInfo filterInfoTemp = new FilterInfo();
        if (hasPositonFlag) {
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PM.isPrimary", (Object)"1"));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonCmp.isPayPerson", (Object)"1"));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", (Object)"1"));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", null));
            filterInfoTemp.setMaskString("(#0) AND (#1) AND (#2 OR #3)");
            FilterInfo filterAdminOrg = new FilterInfo();
            filterAdminOrg = this.getHasSubDepPositionFilter(ctx, adminOrgInfo, hasSubDept);
            filterInfoTemp.mergeFilter(filterAdminOrg, "AND");
            entityViewInfo.setFilter(filterInfoTemp);
        } else {
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonCmp.isPayPerson", (Object)"1"));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", (Object)"1"));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", null));
            filterInfoTemp.getFilterItems().add(new FilterItemInfo("Position.id", null));
            filterInfoTemp.setMaskString("(#0) AND (#1 OR #2) AND #3");
            FilterInfo filterAdminOrg = new FilterInfo();
            filterAdminOrg = this.getHasSubNotPositionFilter(ctx, adminOrgInfo, hasSubDept);
            filterInfoTemp.mergeFilter(filterAdminOrg, "AND");
            entityViewInfo.setFilter(filterInfoTemp);
        }
        if (this.isPersonRange) {
            DeptInnerSchemePersonHisUtils.addCmpSchemeFilter(entityViewInfo, this.cmpSchemeInfo);
        }
        return entityViewInfo;
    }

    private FilterInfo getHasSubNotPositionFilter(Context ctx, AdminOrgUnitInfo adminOrgInfo, boolean hasSubDept) {
        FilterInfo filterInfoOrg = new FilterInfo();
        if (hasSubDept) {
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgInfo.getLongNumber()));
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminOrgInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfoOrg.setMaskString("#0 OR #1");
        } else {
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgInfo.getId().toString()));
            filterInfoOrg.setMaskString(" #0 ");
        }
        return filterInfoOrg;
    }

    private FilterInfo getHasSubDepPositionFilter(Context ctx, AdminOrgUnitInfo adminOrgInfo, boolean hasSubDept) {
        FilterInfo filterInfoOrg = new FilterInfo();
        if (hasSubDept) {
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgInfo.getLongNumber()));
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminOrgInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfoOrg.setMaskString("(#0) and (#1) and (#2 or #3))");
        } else {
            filterInfoOrg.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgInfo.getId().toString()));
            filterInfoOrg.setMaskString("#0");
        }
        return filterInfoOrg;
    }

    private DeptSchemeEntryCollection doDeptScheme(Context ctx, DeptSchemeInfo info) throws EASBizException, BOSException {
        info = (DeptSchemeInfo)DeptSchemeFactory.getLocalInstance(ctx).getDeptSchemeInfo(true, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        String oql = null;
        oql = info.getAssignType().equals((Object)AssignTypeEnum.ADMIN) ? " select id,sendRate,hasSubDept,amountPlan,amountFact,amountBalance,isParentNode ,isAudit,cmpPeriod.*,adminOrgUnit.*,deptInnerScheme.* where deptScheme.id='" + info.getId().toString() + "'" : " select id,sendRate,hasSubDept,amountPlan,amountFact,amountBalance,isParentNode ,isAudit,cmpPeriod.*,teamGroup.*,deptInnerScheme.* where deptScheme.id='" + info.getId().toString() + "'";
        DeptSchemeEntryCollection colEntry = DeptSchemeEntryFactory.getLocalInstance(ctx).getDeptSchemeEntryCollection(oql);
        return colEntry;
    }

    private String getCmpItemIdBycurrHR(Context ctx) throws BOSException {
        String cmpItemId = null;
        HROrgUnitInfo currHR = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (currHR == null) {
            return cmpItemId;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)currHR.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"FOTH2166"));
        evi.setFilter(filter);
        CmpItemCollection coll = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(evi);
        if (coll != null && coll.size() > 0) {
            CmpItemInfo cmpItem = coll.get(0);
            cmpItemId = cmpItem.getId().toString();
        }
        return cmpItemId;
    }

    private HashMap getStandrdValueThisSch(Context ctx, DeptSchemeInfo info, boolean flag) throws EASBizException, BOSException {
        HashMap hashMapTemp = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (flag) {
            filterInfo.getFilterItems().add(new FilterItemInfo("depCmpStardScheme.id", (Object)info.getDepCmpStandrad().getId().toString()));
            if (this.getCmpItemIdBycurrHR(ctx) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)this.getCmpItemIdBycurrHR(ctx), CompareType.NOTEQUALS));
                filterInfo.setMaskString("#0 and #1");
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("depCmpStardScheme.id", (Object)info.getDepCmpStandrad().getId().toString()));
            if (this.getCmpItemIdBycurrHR(ctx) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)this.getCmpItemIdBycurrHR(ctx), CompareType.EQUALS));
                filterInfo.setMaskString("#0 and #1");
            }
        }
        entityViewInfo.setFilter(filterInfo);
        hashMapTemp = DepCmpStandSchemeEntryFactory.getLocalInstance(ctx).getStandradValueIF((IObjectValue)entityViewInfo);
        return hashMapTemp;
    }

    private BigDecimal getPlanAmount(Context ctx, EntityViewInfo entityViewInfoPosition, EntityViewInfo entityViewInfoNoPosition, HashMap standradValuMap, DeptSchemeInfo info) throws BOSException {
        String queryHasPositionPersonURL = "com.kingdee.eas.hr.compensation.app.DepInnerSchemePersonPositionDataQuery";
        String queryHasPositionNoPersonURL = "com.kingdee.eas.hr.compensation.app.DepInnerSchemePersonNoPositionDataQuery";
        DepCmpStandardAmountEnum depCmpStanEnum = info.getDepCmpStandrad().getPersonalItemType();
        BigDecimal positionSumValue = this.statisticSumValue(ctx, queryHasPositionPersonURL, entityViewInfoPosition, depCmpStanEnum, standradValuMap);
        BigDecimal noPositionSumValue = HRSchemeUtils.BD_ZERO;
        if (depCmpStanEnum.getValue() != 20) {
            noPositionSumValue = this.statisticSumValue(ctx, queryHasPositionNoPersonURL, entityViewInfoNoPosition, depCmpStanEnum, standradValuMap);
        }
        return positionSumValue.add(noPositionSumValue);
    }

    private BigDecimal statisticSumValue(Context ctx, String queryString, EntityViewInfo entityViewInfo, DepCmpStandardAmountEnum depCmpStanEnum, HashMap standradValuMap) throws BOSException {
        BigDecimal sum = HRSchemeUtils.BD_ZERO;
        BigDecimal amountOfPersonalItem = HRSchemeUtils.BD_ZERO;
        MetaDataPK metadataPK = new MetaDataPK(queryString);
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        queryExec.setObjectView(entityViewInfo);
        IRowSet rowSetPerson = queryExec.executeQuery();
        String personalItemType = this.getPersonalType(depCmpStanEnum);
        String personalItemKey = "";
        try {
            while (rowSetPerson.next()) {
                personalItemKey = rowSetPerson.getString(personalItemType);
                if (!standradValuMap.containsKey(personalItemKey)) continue;
                amountOfPersonalItem = standradValuMap.get(personalItemKey).toString() == null ? HRSchemeUtils.BD_ZERO : new BigDecimal(standradValuMap.get(personalItemKey).toString());
                sum = sum.add(amountOfPersonalItem);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sum;
    }

    private boolean hasSubDeptScheme(Context ctx, AdminOrgUnitInfo adminInfo, DeptSchemeInfo depSchInfo) throws EASBizException, BOSException {
        if (depSchInfo.getAssignType().equals((Object)AssignTypeEnum.TEAMGROUP)) {
            return false;
        }
        DeptSchemeEntryCollection colEntry = this.doDeptScheme(ctx, depSchInfo);
        DeptSchemeEntryInfo infoEntry = null;
        int size = colEntry.size();
        for (int i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            AdminOrgUnitInfo infoDeptTemp = infoEntry.getAdminOrgUnit();
            if (!adminInfo.getId().toString().equals(infoDeptTemp.getId().toString()) || !infoEntry.isHasSubDept()) continue;
            return infoEntry.isHasSubDept();
        }
        return false;
    }

    private HashMap getDeptPlanAmount(Context ctx, DeptSchemeInfo info, boolean flag) throws EASBizException, BOSException {
        int i;
        if (info.getAssignType().equals((Object)AssignTypeEnum.TEAMGROUP)) {
            return this.getTeamGroupPlanAmount(ctx, info);
        }
        AdminOrgUnitInfo infoDept = null;
        DeptSchemeEntryInfo infoEntry = null;
        HashMap<String, AdminOrgUnitInfo> hashDepMap = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, BigDecimal> hashDepPlanMoneyMap = new HashMap<String, BigDecimal>();
        EntityViewInfo entityViewInfoPosition = null;
        EntityViewInfo entityViewInfoNoPosition = null;
        BigDecimal depPlanMoney = null;
        DepCmpStandardAmountEnum depStandEnum = info.getDepCmpStandrad().getPersonalItemType();
        HashMap hashStandradMap = this.getStandrdValueThisSch(ctx, info, flag);
        DeptSchemeEntryCollection colEntry = this.doDeptScheme(ctx, info);
        AdminOrgUnitCollection colDept = info.getDeptCollection();
        int size = colDept.size();
        for (i = 0; i < size; ++i) {
            infoDept = colDept.get(i);
            hashDepMap.put(infoDept.getId().toString(), infoDept);
        }
        size = colEntry.size();
        for (i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            AdminOrgUnitInfo infoDeptTemp = infoEntry.getAdminOrgUnit();
            if (!hashDepMap.containsKey(infoDeptTemp.getId().toString())) continue;
            entityViewInfoPosition = this.getFilterForSys(ctx, infoDeptTemp, infoEntry.isHasSubDept(), depStandEnum, true);
            entityViewInfoNoPosition = this.getFilterForSys(ctx, infoDeptTemp, infoEntry.isHasSubDept(), depStandEnum, false);
            depPlanMoney = this.getPlanAmount(ctx, entityViewInfoPosition, entityViewInfoNoPosition, hashStandradMap, info);
            hashDepMap.remove(infoDeptTemp.getId().toString());
            hashDepPlanMoneyMap.put(infoDeptTemp.getId().toString(), depPlanMoney);
        }
        return hashDepPlanMoneyMap;
    }

    @Override
    protected HashMap _getDeptPlanAmountIF(Context ctx, IObjectValue deptSchemeInfo) throws BOSException, EASBizException {
        DeptSchemeInfo deptScheme = (DeptSchemeInfo)deptSchemeInfo;
        this.cmpSchemeInfo = deptScheme.getCmpScheme();
        this.isPersonRange = deptScheme.isPersonRange();
        return this.getDeptPlanAmount(ctx, deptScheme, true);
    }

    @Override
    protected HashMap _getDeptPlanAmountIFForYT(Context ctx, IObjectValue _deptScheme) throws BOSException, EASBizException {
        DeptSchemeInfo deptScheme = (DeptSchemeInfo)_deptScheme;
        this.cmpSchemeInfo = deptScheme.getCmpScheme();
        this.isPersonRange = deptScheme.isPersonRange();
        return this.getDeptPlanAmount(ctx, deptScheme, false);
    }

    @Override
    protected boolean _hasSubDept(Context ctx, IObjectValue adminInfo, IObjectValue deptSchemeInfo) throws BOSException, EASBizException {
        return this.hasSubDeptScheme(ctx, (AdminOrgUnitInfo)adminInfo, (DeptSchemeInfo)deptSchemeInfo);
    }

    @Override
    protected IRowSet _getDepCmpBalanceData(Context ctx, IObjectValue filterInfo) throws BOSException, EASBizException {
        IRowSet rowSetDepBalanceData = null;
        if (filterInfo != null) {
            EntityViewInfo entityViewInfo = null;
            if (filterInfo instanceof FilterInfo) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter((FilterInfo)filterInfo);
            } else if (filterInfo instanceof EntityViewInfo) {
                entityViewInfo = (EntityViewInfo)filterInfo;
            }
            MetaDataPK metadataPK = null;
            metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.DepCmpDeptBalanceQuery");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(entityViewInfo);
            queryExec.getSQL();
            rowSetDepBalanceData = queryExec.executeQuery();
        }
        return rowSetDepBalanceData;
    }

    private void insertStandradValue(Context ctx, DeptSchemeInfo info, String entryID) throws EASBizException, BOSException {
        if (info.getAssignType().equals((Object)AssignTypeEnum.TEAMGROUP)) {
            this.insertStandradValueByTeam(ctx, info, entryID);
            return;
        }
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        String oql = "SELECT *,adminOrgUnit.* WHERE id='" + entryID + "'";
        DeptSchemeEntryInfo DeptSchemeEntryInfo2 = iDeptSchemeEntry.getDeptSchemeEntryInfo(oql);
        AdminOrgUnitInfo adminOrgUnitInfo = DeptSchemeEntryInfo2.getAdminOrgUnit();
        DeptInnerSchemeInfo deptInnerSchemeInfo = DeptSchemeEntryInfo2.getDeptInnerScheme();
        boolean hashSubDept = DeptSchemeEntryInfo2.isHasSubDept();
        BigDecimal sentRate = DeptSchemeEntryInfo2.getSendRate();
        IDepCmpStandradScheme iDepCmpStand = DepCmpStandradSchemeFactory.getLocalInstance(ctx);
        HashMap hashPersonalItemValueMap = iDepCmpStand.getPersonalItemAndValue((IObjectValue)info.getDepCmpStandrad());
        HashMap hashCmpItemMap = iDepCmpStand.getCmpItemMapIF((IObjectValue)info.getDepCmpStandrad());
        DepCmpStandardAmountEnum depStandEnum = info.getDepCmpStandrad().getPersonalItemType();
        String personalTypeKey = this.getPersonalType(depStandEnum);
        EntityViewInfo entityViewInfoPosition = this.getFilterForSys(ctx, adminOrgUnitInfo, hashSubDept, depStandEnum, true);
        String queryHasPositionPersonURL = "com.kingdee.eas.hr.compensation.app.DepInnerSchemePersonPositionDataQuery";
        IRowSet rowSetPositionSet = this.executeQueryFun(ctx, queryHasPositionPersonURL, entityViewInfoPosition);
        this.addToDepInnerEntry(ctx, rowSetPositionSet, hashCmpItemMap, deptInnerSchemeInfo, personalTypeKey, hashPersonalItemValueMap, sentRate, true);
        String queryHasPositionNoPersonURL = "com.kingdee.eas.hr.compensation.app.DepInnerSchemePersonNoPositionDataQuery";
        EntityViewInfo entityViewInfoNoPosition = this.getFilterForSys(ctx, adminOrgUnitInfo, hashSubDept, depStandEnum, false);
        IRowSet rowSetNoPositionSet = this.executeQueryFun(ctx, queryHasPositionNoPersonURL, entityViewInfoNoPosition);
        this.addToDepInnerEntry(ctx, rowSetNoPositionSet, hashCmpItemMap, deptInnerSchemeInfo, personalTypeKey, hashPersonalItemValueMap, sentRate, false);
        int rowCount = rowSetPositionSet.size() + rowSetNoPositionSet.size();
        String sqlUpdateString = "UPDATE T_HR_DEPTINNERSCHEME SET FEntryNumber =" + rowCount + "  WHERE FID='" + deptInnerSchemeInfo.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sqlUpdateString);
    }

    private void addToDepInnerEntry(Context ctx, IRowSet rowSetData, HashMap hashCmpItemMap, DeptInnerSchemeInfo deptInnerSchemeInfo, String personalTypeKey, HashMap hashPersonalItemValueMap, BigDecimal sendRate, boolean hasPosition) throws EASBizException, BOSException {
        IDeptInnerSchemeEntry idepInnSchEnt = DeptInnerSchemeEntryFactory.getLocalInstance(ctx);
        Set keySet = null;
        String keyString = "";
        String personKeyID = "";
        BigDecimal needPayTemp = HRSchemeUtils.BD_ZERO;
        try {
            CoreBaseCollection addEntryColl = new CoreBaseCollection();
            while (rowSetData.next()) {
                if (rowSetData.getString("FPersonID") == null) continue;
                keySet = hashCmpItemMap.keySet();
                Iterator iterCmpItem = keySet.iterator();
                while (iterCmpItem.hasNext()) {
                    keyString = iterCmpItem.next().toString();
                    CmpItemInfo cmpItemInfo = (CmpItemInfo)hashCmpItemMap.get(keyString);
                    if (cmpItemInfo == null) continue;
                    needPayTemp = personalTypeKey.equalsIgnoreCase("position.id") && !hasPosition ? HRSchemeUtils.BD_ZERO : ((personKeyID = rowSetData.getString(personalTypeKey)) != null ? this.getStandValue(hashPersonalItemValueMap, personKeyID, cmpItemInfo, sendRate) : HRSchemeUtils.BD_ZERO);
                    DeptInnerSchemeEntryInfo depInnSchEntryInfo = new DeptInnerSchemeEntryInfo();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)rowSetData.getString("FPersonID")));
                    depInnSchEntryInfo.setPerson(personInfo);
                    depInnSchEntryInfo.setCmpItem(cmpItemInfo);
                    depInnSchEntryInfo.setSeq(0);
                    depInnSchEntryInfo.setDeptInnerScheme(deptInnerSchemeInfo);
                    depInnSchEntryInfo.setDepNeedPay(needPayTemp);
                    addEntryColl.add((CoreBaseInfo)depInnSchEntryInfo);
                }
            }
            idepInnSchEnt.addnewBatchData(addEntryColl);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private BigDecimal getStandValue(HashMap mapStand, String personaTypeId, CmpItemInfo cmpItemInfo, BigDecimal sendRate) {
        BigDecimal cmpItemValue = HRSchemeUtils.BD_ZERO;
        HashMap cmpItemValueMap = (HashMap)mapStand.get(personaTypeId);
        if (cmpItemValueMap != null && (cmpItemValue = (BigDecimal)cmpItemValueMap.get(cmpItemInfo.getId().toString())) != null) {
            cmpItemValue = cmpItemValue.multiply(sendRate);
            cmpItemValue = HRCmpItemUtils.convertPrecisionForBigDecimal(cmpItemValue, cmpItemInfo.getDecDigital(), cmpItemInfo.getPrecisionType());
        }
        return cmpItemValue;
    }

    private IRowSet executeQueryFun(Context ctx, String queryStringURL, EntityViewInfo entityViewInfo) throws BOSException {
        IRowSet rowSetDepPersonData = null;
        MetaDataPK metadataPK = null;
        if (entityViewInfo != null) {
            metadataPK = new MetaDataPK(queryStringURL);
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(entityViewInfo);
            queryExec.getSQL();
            rowSetDepPersonData = queryExec.executeQuery();
        }
        return rowSetDepPersonData;
    }

    @Override
    protected void _insertToInnerSchemeIF(Context ctx, IObjectValue deptSchemeInfo, String entryID) throws BOSException, EASBizException {
        DeptSchemeInfo deptScheme = (DeptSchemeInfo)deptSchemeInfo;
        this.cmpSchemeInfo = deptScheme.getCmpScheme();
        this.isPersonRange = deptScheme.isPersonRange();
        this.insertStandradValue(ctx, deptScheme, entryID);
    }

    @Override
    protected void _updateChildPlanAmount(Context ctx, HashMap rowDataMap) throws BOSException, EASBizException {
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        Set keySet = rowDataMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String keyID = iter.next().toString();
            BigDecimal planAmount = HRSchemeUtils.BD_ZERO;
            Object obj = rowDataMap.get(keyID);
            if (obj != null) {
                planAmount = (BigDecimal)obj;
            }
            ObjectUuidPK currPk = new ObjectUuidPK(keyID);
            DeptSchemeEntryInfo deptSchemeEntryInfo = new DeptSchemeEntryInfo();
            deptSchemeEntryInfo.setId(BOSUuid.read((String)currPk.toString()));
            deptSchemeEntryInfo.setAmountPlan(planAmount);
            deptSchemeEntryInfo.setAmountBalance(planAmount);
            deptSchemeEntryInfo.setSendRate(HRSchemeUtils.BD_ZERO);
            deptSchemeEntryInfo.setAmountFact(HRSchemeUtils.BD_ZERO);
            iDeptSchemeEntry.update((IObjectPK)currPk, (CoreBaseInfo)deptSchemeEntryInfo);
        }
    }

    @Override
    protected ArrayList _getDepCmpPersonalBalanceKeys(Context ctx, IObjectValue filterInfo, boolean isMultiPeriod) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        if (!isMultiPeriod) {
            strSql.append(" SELECT distinct PERSON.FID PersonId, ADMINORGUNIT.FID AdminOrgUnitId ");
        } else {
            strSql.append(" SELECT distinct PERSON.FID PersonId,TEAMGROUP.FID TeamGroupID ");
        }
        strSql.append(" FROM T_HR_DeptInnerSchemeEntry DEPTINNERSCHEMEENTRY");
        strSql.append(" INNER JOIN T_BD_Person PERSON ON DEPTINNERSCHEMEENTRY.FPersonID = PERSON.FID");
        strSql.append(" INNER JOIN T_HR_DeptInnerScheme DEPTINNERSCHEME ON DEPTINNERSCHEMEENTRY.FDeptInnerSchemeID = DEPTINNERSCHEME.FID");
        strSql.append(" INNER JOIN T_HR_DeptSchemeEntry DEPTSCHEMEENTRY ON DEPTINNERSCHEME.FID = DEPTSCHEMEENTRY.FDeptInnerSchemeID");
        strSql.append(" INNER JOIN T_HR_DeptScheme DEPTSCHEME ON DEPTSCHEMEENTRY.FDeptSchemeID = DEPTSCHEME.FID");
        strSql.append(" INNER JOIN T_HR_CMPPERIOD CMPPERIOD ON DEPTSCHEMEENTRY.FCmpPeriodID = CMPPERIOD.FID");
        if (!isMultiPeriod) {
            strSql.append(" INNER JOIN T_ORG_Admin ADMINORGUNIT ON DEPTSCHEMEENTRY.FAdminOrgUnitID = ADMINORGUNIT.FID").append(" LEFT OUTER JOIN T_HR_TEAMGROUP TEAMGROUP ON DEPTSCHEMEENTRY.FTeamGroupID = TEAMGROUP.FID");
        } else {
            strSql.append(" INNER JOIN T_HR_TEAMGROUP TEAMGROUP ON DEPTSCHEMEENTRY.FTeamGroupID = TEAMGROUP.FID").append(" LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ON DEPTSCHEMEENTRY.FAdminOrgUnitID = ADMINORGUNIT.FID");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (filterInfo != null) {
            if (filterInfo instanceof FilterInfo) {
                entityViewInfo.setFilter((FilterInfo)filterInfo);
            } else if (filterInfo instanceof EntityViewInfo) {
                entityViewInfo.setFilter(((EntityViewInfo)filterInfo).getFilter());
            }
        }
        String strWhere = HRCommonQueryUtils.getQueryWhereSqlByFilter(ctx, "com.kingdee.eas.hr.compensation.app.DepCmpPersonalBalanceOfHisQuery", entityViewInfo);
        strSql.append(" where " + strWhere);
        if (isMultiPeriod) {
            strSql.append(" ORDER BY TEAMGROUP.FID ,Person.FID ASC");
        } else {
            strSql.append(" ORDER BY ADMINORGUNIT.FID ,Person.FID ASC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        ArrayList<String> lstIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                lstIds.add(rs.getString(1) + "~" + rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return lstIds;
    }

    @Override
    protected IRowSet _getDepCmpPersonalBalanceData(Context ctx, IObjectValue filterInfo, boolean isMulPeriod, ArrayList lstKeys) throws BOSException, EASBizException {
        String query = "";
        query = "com.kingdee.eas.hr.compensation.app.DepCmpPersonalBalanceOfHisQuery";
        IRowSet rowSetDepBalanceData = this.getDepCmpPersonalBalanceDataByQuery(ctx, filterInfo, query, lstKeys, isMulPeriod);
        return rowSetDepBalanceData;
    }

    private IRowSet getDepCmpPersonalBalanceDataByQuery(Context ctx, IObjectValue filterInfo, String query, ArrayList lstKeys, boolean isTeamGroup) throws BOSException, EASBizException {
        IRowSet rowSetDepBalanceData = null;
        if (filterInfo != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (isTeamGroup) {
                entityViewInfo.getSorter().add(new SorterItemInfo("teamGroup.id"));
            } else {
                entityViewInfo.getSorter().add(new SorterItemInfo("AdminOrgUnit.id"));
            }
            entityViewInfo.getSorter().add(new SorterItemInfo("Person.id"));
            StringBuffer strMask = new StringBuffer();
            String[] strIds = null;
            FilterInfo keyFilter = new FilterInfo();
            int size = lstKeys.size();
            for (int i = 0; i < size; ++i) {
                strIds = lstKeys.get(i).toString().split("~");
                keyFilter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)strIds[0]));
                if (isTeamGroup) {
                    keyFilter.getFilterItems().add(new FilterItemInfo("teamGroup.id", (Object)strIds[1]));
                } else {
                    keyFilter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)strIds[1]));
                }
                if (i > 0) {
                    strMask.append(" or ");
                }
                strMask.append(" (#").append(i * 2).append(" and #").append(i * 2 + 1).append(")");
            }
            if (!strMask.toString().equals("")) {
                keyFilter.setMaskString(strMask.toString());
                entityViewInfo.setFilter(keyFilter);
            }
            if (filterInfo instanceof FilterInfo) {
                if (!strMask.toString().equals("")) {
                    keyFilter.mergeFilter((FilterInfo)filterInfo, "AND");
                }
                entityViewInfo.setFilter(keyFilter);
            } else if (filterInfo instanceof EntityViewInfo) {
                if (!strMask.toString().equals("")) {
                    keyFilter.mergeFilter(((EntityViewInfo)filterInfo).getFilter(), "AND");
                }
                entityViewInfo.setFilter(keyFilter);
            }
            MetaDataPK metadataPK = null;
            metadataPK = new MetaDataPK(query);
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(entityViewInfo);
            String strExce = queryExec.getSQL();
            int iOrderIndex = strExce.toLowerCase().indexOf("order");
            strExce = strExce.substring(0, iOrderIndex) + " and DEPTSCHEMEENTRYHIS.FID = DEPTSCHEMEENTRY.Fid " + strExce.substring(iOrderIndex, strExce.length());
            try {
                strExce = KSqlUtil.optimize((String)strExce);
            }
            catch (SqlTranslateException e) {
                logger.error((Object)e.getMessage());
            }
            rowSetDepBalanceData = DbUtil.executeQuery((Context)ctx, (String)strExce);
        }
        return rowSetDepBalanceData;
    }

    @Override
    protected IRowSet _getDepCmpPersonalBalanceNotExitScheme(Context ctx, IObjectValue filterInfo, CmpSchemeInfo cmpScheme) throws BOSException, EASBizException {
        IRowSet rowSetDepBalanceData = null;
        String query = "com.kingdee.eas.hr.compensation.app.DepCmpPersonalBalanceOfHisQuery";
        String cmpSchemeSql = " select FPersonID  from T_HR_CMPSCHEMEPERSON  where FCmpSchemeID='" + cmpScheme.getId().toString() + "' and fisdelete = 0";
        if (filterInfo != null) {
            EntityViewInfo entityViewInfo = null;
            if (filterInfo instanceof FilterInfo) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter((FilterInfo)filterInfo);
            } else if (filterInfo instanceof EntityViewInfo) {
                entityViewInfo = (EntityViewInfo)filterInfo;
            }
            MetaDataPK metadataPK = null;
            metadataPK = new MetaDataPK(query);
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(entityViewInfo);
            String sql = queryExec.getSQL();
            sql = sql + " and DEPTSCHEMEENTRYHIS.FID = DEPTSCHEMEENTRY.Fid ";
            sql = sql + " and Person.fid not in(" + cmpSchemeSql + ")";
            sql = " select distinct t.\"PERSON.NAME\", t.\"PERSON.NUMBER\"  from (" + sql + " ) t ";
            rowSetDepBalanceData = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        return rowSetDepBalanceData;
    }

    private Map getPersonSumCmpItemValue(Context ctx, IObjectValue filterInfo) throws BOSException, SQLException {
        String sqlSel = " select t.\"PERSON.ID\", t.\"PERSON.NAME\",t.\"depNeedPay\",t.\"DeptSchemeEntry.sendRate\",t.\"CmpItem.decDigital\",t.\"CmpItem.precisionType\" from ";
        String query = "com.kingdee.eas.hr.compensation.app.DepCmpPersonalBalanceOfHisQuery";
        IRowSet rowSetDepBalanceData = null;
        if (filterInfo != null) {
            EntityViewInfo entityViewInfo = null;
            if (filterInfo instanceof FilterInfo) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter((FilterInfo)filterInfo);
            } else if (filterInfo instanceof EntityViewInfo) {
                entityViewInfo = (EntityViewInfo)filterInfo;
            }
            MetaDataPK metadataPK = null;
            metadataPK = new MetaDataPK(query);
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(entityViewInfo);
            String sql = queryExec.getSQL();
            sql = sql + " and DEPTSCHEMEENTRYHIS.FID = DEPTSCHEMEENTRY.Fid ";
            sql = sqlSel + "(" + sql + ") t  ";
            rowSetDepBalanceData = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        Map retMap = null;
        if (rowSetDepBalanceData != null) {
            retMap = this.getBalanceSumData(rowSetDepBalanceData);
        }
        return retMap;
    }

    public Map getBalanceSumData(IRowSet depBalanceRowSet) throws SQLException {
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        BigDecimal tempStandEValue = HRSchemeUtils.BD_ZERO;
        BigDecimal tempSentRateValue = HRSchemeUtils.BD_ZERO;
        BigDecimal tempSendTotalValue = HRSchemeUtils.BD_ZERO;
        BigDecimal tempSentRateTempValue = HRSchemeUtils.BD_ZERO;
        BigDecimal tempBalance = HRSchemeUtils.BD_ZERO;
        BigDecimal tempSum = HRSchemeUtils.BD_ZERO;
        String DEPSTANDRAD = "depNeedPay";
        String SENTRATE = "DeptSchemeEntry.sendRate";
        String PERSONID = "Person.id";
        String personId = null;
        while (depBalanceRowSet.next()) {
            tempStandEValue = depBalanceRowSet.getBigDecimal("depNeedPay");
            tempSentRateValue = depBalanceRowSet.getBigDecimal("DeptSchemeEntry.sendRate");
            tempSendTotalValue = this.opDive(tempStandEValue, tempSentRateValue, depBalanceRowSet.getInt("CmpItem.decDigital") + 4);
            tempSentRateTempValue = new BigDecimal("1").subtract(tempSentRateValue);
            tempBalance = tempSendTotalValue.multiply(tempSentRateTempValue);
            tempBalance = HRCmpItemUtils.convertPrecisionForBigDecimal(tempBalance, depBalanceRowSet.getInt("CmpItem.decDigital"), CmpItemPrecisionTypeEnum.getEnum(depBalanceRowSet.getInt("CmpItem.precisionType")));
            personId = depBalanceRowSet.getString("Person.id");
            tempSum = retMap.containsKey(personId) ? (BigDecimal)retMap.get(personId) : HRSchemeUtils.BD_ZERO;
            tempSum = tempSum.add(tempBalance);
            retMap.put(personId, tempSum);
        }
        return retMap;
    }

    private BigDecimal opDive(BigDecimal b1, BigDecimal b2, int iScale) {
        BigDecimal retBigDecimal = null;
        try {
            retBigDecimal = b1.divide(b2, iScale, 0);
        }
        catch (Exception e) {
            retBigDecimal = new BigDecimal(0);
        }
        return retBigDecimal;
    }

    private PreparedStatement getUpdatePStmt(Context ctx, Connection conn, String tableName) throws BOSException {
        PreparedStatement psUpdate = null;
        try {
            String strUpdate = "UPDATE " + tableName + " SET FVALUE=? WHERE FID=?";
            psUpdate = conn.prepareStatement(strUpdate);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("ERROR");
        }
        return psUpdate;
    }

    private PreparedStatement getInsertPStmt(Context ctx, Connection conn, String tableName) throws BOSException {
        PreparedStatement psAddNew = null;
        try {
            String strInsert = "INSERT INTO " + tableName + "(FID,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FVALUE,FTIME) VALUES( ?,?,?,?,?,?,?)";
            psAddNew = conn.prepareStatement(strInsert);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("ERROR");
        }
        return psAddNew;
    }

    private void convertTonEndInput(Context ctx, Map sumMap, CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriod, int time, CmpItemInfo cmpItem, InputTypeEnum inputTypeEnum) throws BOSException, SQLException, EASBizException {
        String tableName = HRTableTools.getEndInputTableName(ctx, cmpScheme.getId().toString());
        Map endInputData = this.getEndInputData(ctx, cmpScheme, cmpPeriod, time, cmpItem, tableName, sumMap);
        Connection conn = EJBFactory.getConnection((Context)ctx);
        PreparedStatement psAddNew = this.getInsertPStmt(ctx, conn, tableName);
        PreparedStatement psUpdate = this.getUpdatePStmt(ctx, conn, tableName);
        String personId = null;
        String endInputKey = null;
        BigDecimal sumValue = null;
        Iterator iterSumMap = sumMap.keySet().iterator();
        while (iterSumMap.hasNext()) {
            personId = iterSumMap.next().toString();
            sumValue = (BigDecimal)sumMap.get(personId);
            sumValue = HRCmpItemUtils.convertPrecisionForBigDecimal(sumValue, cmpItem.getDecDigital(), cmpItem.getPrecisionType());
            endInputKey = personId + "~" + cmpItem.getId().toString() + "~" + cmpScheme.getId().toString() + "~" + cmpPeriod.getId().toString() + "~" + time;
            this.setPeriodEndInputNew(ctx, endInputKey, cmpScheme, cmpPeriod, time, cmpItem, personId, sumValue, psAddNew, psUpdate, endInputData, inputTypeEnum);
        }
        try {
            psAddNew.executeBatch();
            psUpdate.executeBatch();
            conn.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)psAddNew, (Connection)conn);
            SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
        }
    }

    private void setPeriodEndInputNew(Context ctx, String keyStringHelper, CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriod, int time, CmpItemInfo cmpItem, String personId, BigDecimal sumValue, PreparedStatement psAddNew, PreparedStatement psUpdate, Map endInputMap, InputTypeEnum inputTypeEnum) throws EASBizException, BOSException, SQLException {
        BigDecimal valueTemp = null;
        if (!endInputMap.containsKey(keyStringHelper)) {
            PeriodEndInputInfo periodEndInputInfoAddNew = new PeriodEndInputInfo();
            String fid = BOSUuid.create((BOSObjectType)periodEndInputInfoAddNew.getBOSType()).toString();
            psAddNew.setString(1, fid);
            psAddNew.setString(2, cmpPeriod.getId().toString());
            psAddNew.setString(3, cmpItem.getId().toString());
            psAddNew.setString(4, personId);
            psAddNew.setString(5, cmpScheme.getId().toString());
            psAddNew.setBigDecimal(6, sumValue);
            psAddNew.setInt(7, time);
            psAddNew.addBatch();
        } else {
            String[] arrayHelper = endInputMap.get(keyStringHelper).toString().split("~");
            valueTemp = "null".equals(arrayHelper[1]) ? null : new BigDecimal(arrayHelper[1]);
            this.updateMode(valueTemp, sumValue, arrayHelper[0], inputTypeEnum, psUpdate);
        }
    }

    private void updateMode(BigDecimal endInputData, BigDecimal newData, String id, InputTypeEnum inputTypeEnum, PreparedStatement psUpdate) throws SQLException {
        if (inputTypeEnum.getValue() == 1) {
            psUpdate.setBigDecimal(1, newData.add(endInputData));
            psUpdate.setString(2, id);
            psUpdate.addBatch();
            return;
        }
        if (inputTypeEnum.getValue() == 0) {
            psUpdate.setBigDecimal(1, newData);
            psUpdate.setString(2, id);
            psUpdate.addBatch();
            return;
        }
        if (inputTypeEnum.getValue() == 2 && endInputData == null) {
            psUpdate.setBigDecimal(1, newData);
            psUpdate.setString(2, id);
            psUpdate.addBatch();
            return;
        }
    }

    private Map getEndInputData(Context ctx, CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriod, int time, CmpItemInfo cmpItem, String tableName, Map personMap) throws BOSException, SQLException {
        HashMap<String, String> rowHelperMap = new HashMap<String, String>();
        if (personMap == null || personMap.size() == 0) {
            return rowHelperMap;
        }
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT FID,FVALUE,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FTIME ");
        strSql.append(" FROM ").append(tableName).append(" WHERE ");
        strSql.append("  FCMPPERIODID='" + cmpPeriod.getId().toString() + "' ");
        strSql.append(" AND FCMPSCHEMEID='" + cmpScheme.getId().toString() + "' ");
        strSql.append(" AND FCMPITEMID='" + cmpItem.getId().toString() + "'");
        strSql.append(" AND FTIME=" + time);
        StringBuffer personSelectSql = new StringBuffer();
        Iterator iterTemp = personMap.keySet().iterator();
        String personKeyString = null;
        int i = 0;
        while (iterTemp.hasNext()) {
            personKeyString = iterTemp.next().toString();
            if (i == 0) {
                personSelectSql.append(" FPERSONID='" + personKeyString + "'");
            } else {
                personSelectSql.append(" OR FPERSONID='" + personKeyString + "'");
            }
            ++i;
        }
        strSql.append("AND (" + personSelectSql.toString() + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        String keyStringHelp = null;
        String valueHelper = "";
        BigDecimal valueTemp = null;
        while (rowSet.next()) {
            keyStringHelp = "";
            if (rowSet.getString("FPERSONID") != null) {
                keyStringHelp = keyStringHelp + rowSet.getString("FPERSONID") + "~";
            }
            if (rowSet.getString("FCMPITEMID") != null) {
                keyStringHelp = keyStringHelp + rowSet.getString("FCMPITEMID") + "~";
            }
            if (rowSet.getString("FCMPSCHEMEID") != null) {
                keyStringHelp = keyStringHelp + rowSet.getString("FCMPSCHEMEID") + "~";
            }
            if (rowSet.getString("FCMPPERIODID") != null) {
                keyStringHelp = keyStringHelp + rowSet.getString("FCMPPERIODID") + "~";
            }
            keyStringHelp = keyStringHelp + time;
            valueHelper = "";
            valueTemp = HRSchemeUtils.BD_ZERO;
            if (rowSet.getBigDecimal("FVALUE") != null) {
                valueTemp = rowSet.getBigDecimal("FVALUE");
                valueHelper = rowSet.getString("FID") + "~" + valueTemp.toString();
            } else {
                valueHelper = rowSet.getString("FID") + "~" + "null";
            }
            rowHelperMap.put(keyStringHelp, valueHelper);
        }
        return rowHelperMap;
    }

    @Override
    protected boolean _convertBalanceToEndInput(Context ctx, CmpSchemeInfo cmpScheme, CmpPeriodInfo cmpPeriod, int time, CmpItemInfo cmpItem, InputTypeEnum inputTypeEnum, IObjectValue filterInfo, HashMap bMap) throws BOSException, EASBizException {
        boolean ret = false;
        try {
            Map sumMap = this.getPersonSumCmpItemValue(ctx, filterInfo);
            this.convertTonEndInput(ctx, sumMap, cmpScheme, cmpPeriod, time, cmpItem, inputTypeEnum);
            ret = true;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private HashMap getTeamGroupPlanAmount(Context ctx, DeptSchemeInfo info) throws EASBizException, BOSException {
        int i;
        DeptSchemeEntryInfo infoEntry = null;
        HashMap<String, TeamGroupCollection> hashDepMap = new HashMap<String, TeamGroupCollection>();
        HashMap<String, BigDecimal> hashDepPlanMoneyMap = new HashMap<String, BigDecimal>();
        BigDecimal depPlanMoney = null;
        HashMap hashStandradMap = this.getStandrdValueThisSch(ctx, info, true);
        DeptSchemeEntryCollection colEntry = this.doDeptScheme(ctx, info);
        TeamGroupCollection teamColl = info.getTeamGroupCollection();
        TeamGroupInfo teamInfo = null;
        int size = teamColl.size();
        for (i = 0; i < size; ++i) {
            teamInfo = teamColl.get(i);
            hashDepMap.put(teamInfo.getId().toString(), teamColl);
        }
        size = colEntry.size();
        for (i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            TeamGroupInfo teamInfoTemp = infoEntry.getTeamGroup();
            if (!hashDepMap.containsKey(teamInfoTemp.getId().toString())) continue;
            depPlanMoney = this.getTeamGroupPlanAmount(ctx, hashStandradMap, info, teamInfoTemp);
            hashDepMap.remove(teamInfoTemp.getId().toString());
            hashDepPlanMoneyMap.put(teamInfoTemp.getId().toString(), depPlanMoney);
        }
        return hashDepPlanMoneyMap;
    }

    private BigDecimal getTeamGroupPlanAmount(Context ctx, HashMap standradValuMap, DeptSchemeInfo info, TeamGroupInfo teamInfoTemp) throws BOSException {
        int size = info.getTeamGroupCollection().size();
        if (size <= 0) {
            return HRSchemeUtils.BD_ZERO;
        }
        IRowSet rowSetPerson = this.getPersonInfoByTeamGroup(ctx, teamInfoTemp);
        DepCmpStandardAmountEnum depCmpStanEnum = info.getDepCmpStandrad().getPersonalItemType();
        BigDecimal sumValue = this.statisticSumValue(ctx, rowSetPerson, depCmpStanEnum, standradValuMap);
        return sumValue;
    }

    private IRowSet getPersonInfoByTeamGroup(Context ctx, TeamGroupInfo teamInfoTemp) throws BOSException {
        String queryString = "com.kingdee.eas.hr.compensation.app.DeptInnerTeamGroupDataQuery";
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("teamGroupID", (Object)teamInfoTemp.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("PersonDegree.isHighest", null, CompareType.EMPTY));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK metadataPK = new MetaDataPK(queryString);
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        queryExec.setObjectView(entityViewInfo);
        IRowSet rowSetPerson = queryExec.executeQuery();
        return rowSetPerson;
    }

    private BigDecimal statisticSumValue(Context ctx, IRowSet rowSetPerson, DepCmpStandardAmountEnum depCmpStanEnum, HashMap standradValuMap) throws BOSException {
        BigDecimal sum = HRSchemeUtils.BD_ZERO;
        BigDecimal amountOfPersonalItem = HRSchemeUtils.BD_ZERO;
        String personalItemType = this.getPersonalType(depCmpStanEnum);
        String personalItemKey = "";
        try {
            while (rowSetPerson.next()) {
                personalItemKey = rowSetPerson.getString(personalItemType);
                if (!standradValuMap.containsKey(personalItemKey)) continue;
                amountOfPersonalItem = standradValuMap.get(personalItemKey).toString() == null ? HRSchemeUtils.BD_ZERO : new BigDecimal(standradValuMap.get(personalItemKey).toString());
                sum = sum.add(amountOfPersonalItem);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sum;
    }

    private void insertStandradValueByTeam(Context ctx, DeptSchemeInfo info, String entryID) throws EASBizException, BOSException {
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        String oql = "SELECT *,teamGroup.* WHERE id='" + entryID + "'";
        DeptSchemeEntryInfo deptSchemeEntryInfo = iDeptSchemeEntry.getDeptSchemeEntryInfo(oql);
        TeamGroupInfo teamGroupInfo = deptSchemeEntryInfo.getTeamGroup();
        DeptInnerSchemeInfo deptInnerSchemeInfo = deptSchemeEntryInfo.getDeptInnerScheme();
        if (deptInnerSchemeInfo == null || deptInnerSchemeInfo.getId() == null) {
            IDeptInnerScheme iDeptInnerScheme = DeptInnerSchemeFactory.getLocalInstance(ctx);
            deptInnerSchemeInfo = new DeptInnerSchemeInfo();
            deptInnerSchemeInfo.setAudit(SchemeAuditedEnum.NOTAUDITED);
            deptInnerSchemeInfo.setIsSubmitAudit(false);
            IObjectPK iObjectPK = iDeptInnerScheme.addnew(deptInnerSchemeInfo);
        }
        BigDecimal sentRate = deptSchemeEntryInfo.getSendRate();
        IDepCmpStandradScheme iDepCmpStand = DepCmpStandradSchemeFactory.getLocalInstance(ctx);
        HashMap hashPersonalItemValueMap = iDepCmpStand.getPersonalItemAndValue((IObjectValue)info.getDepCmpStandrad());
        HashMap hashCmpItemMap = iDepCmpStand.getCmpItemMapIF((IObjectValue)info.getDepCmpStandrad());
        DepCmpStandardAmountEnum depStandEnum = info.getDepCmpStandrad().getPersonalItemType();
        String personalTypeKey = this.getPersonalType(depStandEnum);
        IRowSet rowSet = this.getPersonInfoByTeamGroup(ctx, teamGroupInfo);
        this.addToDepInnerEntry(ctx, rowSet, hashCmpItemMap, deptInnerSchemeInfo, personalTypeKey, hashPersonalItemValueMap, sentRate, true);
        int rowCount = rowSet.size();
        String sqlUpdateString = "UPDATE T_HR_DEPTINNERSCHEME SET FEntryNumber =?  WHERE FID= ? ";
        DbUtil.execute((Context)ctx, (String)sqlUpdateString, (Object[])new Object[]{rowCount, deptInnerSchemeInfo.getId().toString()});
    }

    @Override
    protected void _updateAuditState(Context ctx, String entryID, int auditState) throws BOSException, EASBizException {
        String sqlUpdateString = "UPDATE T_HR_DeptSchemeEntry SET FIsAudit = ? where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sqlUpdateString, (Object[])new Object[]{auditState, entryID});
    }

    @Override
    protected IRowSet _getPersonNotInSchemeInDept(Context ctx, String sql, Object[] params) throws BOSException, EASBizException {
        if (params == null) {
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected int _getPersonCount(Context ctx, String deptSchemeID, String cmpPeriodID) throws BOSException, EASBizException {
        return 0;
    }

    @Override
    protected Map _getPersonInSchemeInDept(Context ctx, Map paramMap) throws BOSException, EASBizException {
        IObjectValue filterInfo = (IObjectValue)paramMap.get("filterInfo");
        Map sumMap = new HashMap();
        try {
            sumMap = this.getPersonSumCmpItemValue(ctx, filterInfo);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return sumMap;
    }
}

