/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.hr.base.CmpSystemConfigCollection;
import com.kingdee.eas.hr.base.CmpSystemConfigFactory;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.CompenException;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ISalariatMapPersonItem;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemCollection;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemFactory;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeCollection;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeFactory;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeInfo;
import com.kingdee.eas.hr.compensation.SalariatRangeFactory;
import com.kingdee.eas.hr.compensation.SalariatRangeInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractEmpCmpSchmFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.DependForest;
import com.kingdee.eas.hr.compensation.util.DependNode;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EmpCmpSchmFacadeControllerBean
extends AbstractEmpCmpSchmFacadeControllerBean {
    static final String BUILDSTMT = "BUILDSTMT";
    static final String DISPLAYQUERY = "DISPLAYQUERY";
    static final String UPDQUERY = "UPDQUERY";
    static final String EMPCMPSEQNAME = "FSequence";
    static final Logger logger = Logger.getLogger(EmpCmpSchmFacadeControllerBean.class);

    @Override
    protected String _getOrderedItemSelectSQL(Context ctx, IObjectPK schemePK) throws BOSException, EASBizException {
        return this._getOrderedItemSelectSQL(ctx, schemePK, null);
    }

    @Override
    protected String _getOrderedItemSelectSQL(Context ctx, IObjectPK schemePK, List orderByList) throws BOSException, EASBizException {
        return this._innergetOrderedItemSelectSQL(ctx, schemePK, null, orderByList);
    }

    protected String _innergetOrderedItemSelectSQL(Context ctx, IObjectPK schemePK, FilterInfo infoFilter, List orderByList) throws BOSException, EASBizException {
        String oql;
        ICmpSchemeItem schEntry = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection entries = schEntry.getCmpSchemeItemCollection(oql = "select CmpScheme.cmpSchm.id , cmpScheme.horTableName,cmpItem.number,cmpItem.dataType where cmpScheme.id = '" + schemePK.toString() + "' order by sortOrder");
        if (entries == null || entries.size() < 1) {
            return "";
        }
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        for (int i = 0; i < entries.size(); ++i) {
            itemList.add(entries.get(i).getCmpItem());
        }
        String horTableName = entries.get(0).getCmpScheme().getHorTableName();
        SqlSelect select = null;
        select = this.getFixedItemSQL(ctx, 1);
        ArrayList orderedSelectors = this.buildSelectItemList(ctx, itemList, horTableName, select);
        select.selectList = null;
        select.selectList = orderedSelectors;
        select.tableSource = this.buildTableSource(select, horTableName);
        select.condition = this.buildWhereExpr(select, horTableName);
        select.orderBy = this.buildOrderByExprList(orderByList, select);
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    protected String getBuildedSQL(Context ctx, IObjectPK schemePK) throws EmpCmpSchmFacadeException {
        String selectStmt = "";
        Connection con = null;
        String sql = "SELECT FSELECTSTMT FROM T_HR_CMPSCHEME EMPSCH WHERE (FSELECTSTMT IS NOT NULL ) AND FID= ?";
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql);
            pstm.setString(1, schemePK.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                selectStmt = rs.getString(1);
            }
        }
        catch (Exception e) {
            try {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GEG_BUILDEDSQL_EXEC, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        if (selectStmt.length() > 0) {
            return selectStmt;
        }
        return BUILDSTMT;
    }

    private SqlSelect getFixedItemSQL(Context ctx, int type) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        IQueryExecutor exec = null;
        String sql = null;
        String queryPK = null;
        queryPK = type == 1 ? "com.kingdee.eas.hr.compensation.app.PersonInfoQuery" : "com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery";
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        try {
            EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(queryPK));
            exec.setObjectView(evi);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = exec.getSQL();
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    protected ArrayList buildSelectItemList(Context ctx, List itemSelect, String horTableName, SqlSelect select) throws EmpCompenseException {
        String language = ctx.getLocale().getLanguage();
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        try {
            parser = new SqlExprParser("\"PERSON\".FID");
            SqlSelectItem personID = new SqlSelectItem(parser.expr(), "FPERSONID");
            orderedSelectors.add(personID);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        boolean hasAdminLongName = false;
        CmpItemInfo itemInfo = null;
        int size = itemSelect.size();
        for (int i = 0; i < size; ++i) {
            SqlSelectItem item = null;
            itemInfo = (CmpItemInfo)itemSelect.get(i);
            if (itemInfo == null || itemInfo.getNumber() == null) continue;
            itemNumber = itemInfo.getNumber();
            if ("FPER003".equals(itemNumber)) {
                hasAdminLongName = true;
            }
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) {
                boolean flag = true;
                try {
                    if (itemNumber.indexOf("FPER") > -1 || itemNumber.indexOf("PERSON.FFPER") > -1) {
                        DbUtil.execute((Context)ctx, (String)("SELECT " + itemNumber + " FROM " + horTableName + " WHERE 1<>1"));
                    }
                }
                catch (Exception ee) {
                    flag = false;
                }
                if (!flag) continue;
                try {
                    item = new SqlSelectItem();
                    parser = new SqlExprParser(horTableName + "." + itemNumber);
                    item.expr = parser.expr();
                    item.alias = itemNumber;
                    orderedSelectors.add(item);
                    continue;
                }
                catch (ParserException e1) {
                    throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
                }
            }
            orderedSelectors.add(item);
        }
        if (orderedSelectors != null && orderedSelectors.size() > 0 && !hasAdminLongName) {
            try {
                parser = new SqlExprParser("\"ATTACHDEPT\".FDisplayName_" + language);
                SqlSelectItem displayName = new SqlSelectItem(parser.expr(), "FPER003");
                orderedSelectors.add(displayName);
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
        }
        if (orderedSelectors != null && orderedSelectors.size() > 0) {
            try {
                boolean existItem = false;
                parser = new SqlExprParser("\"PERSON\".FIndex");
                SqlSelectItem indexOf = new SqlSelectItem(parser.expr(), "INDEXOF");
                int size2 = orderedSelectors.size();
                for (int i = 0; i < size2; ++i) {
                    if (!indexOf.toString().equals(orderedSelectors.get(i).toString())) continue;
                    existItem = true;
                    break;
                }
                if (!existItem) {
                    orderedSelectors.add(indexOf);
                }
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
        }
        try {
            SqlSelectItem item = new SqlSelectItem();
            parser = new SqlExprParser(horTableName + ".FCalType");
            item.expr = parser.expr();
            item.alias = "CalType";
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return orderedSelectors;
    }

    protected SqlTableSourceBase buildTableSource(SqlSelect select, String horTableName) {
        SqlTableSource tableSource = new SqlTableSource(horTableName);
        return new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 4, null);
    }

    protected SqlBinaryOpExpr buildWhereExpr(SqlSelect select, String horTableName) throws EmpCompenseException {
        SqlBinaryOpExpr newExpr = null;
        try {
            newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(horTableName + ".FPersonID").expr());
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        if (select.condition == null) {
            return newExpr;
        }
        return new SqlBinaryOpExpr(select.condition, 7, (SqlExpr)newExpr);
    }

    protected List buildOrderByExprList(List orderByList, SqlSelect select) throws EmpCmpSchmFacadeException {
        if (orderByList != null && orderByList.size() > 0) {
            ArrayList<SqlOrderByItem> orderByItems = new ArrayList<SqlOrderByItem>();
            SqlSelectItem selectItem = null;
            String orderByItem = null;
            int size = orderByList.size();
            for (int i = 0; i < size; ++i) {
                orderByItem = (String)orderByList.get(i);
                this.checkOrderByItem(orderByItem);
                selectItem = this.getItem(select.selectList, orderByItem.substring(0, orderByItem.indexOf(59)));
                if (selectItem == null) {
                    throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
                }
                if (orderByItem.substring(orderByItem.indexOf(59) + 1).toUpperCase().equals("ASC")) {
                    orderByItems.add(new SqlOrderByItem(selectItem.expr, 0));
                    continue;
                }
                if (!orderByItem.substring(orderByItem.indexOf(59) + 1).toUpperCase().equals("DESC")) continue;
                orderByItems.add(new SqlOrderByItem(selectItem.expr, 1));
            }
            return orderByItems;
        }
        return select.orderBy;
    }

    protected void checkOrderByItem(String orderByItem) throws EmpCmpSchmFacadeException {
        if (orderByItem.indexOf(";") < 1) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBY_FORMAT_INVALID);
        }
        if (orderByItem.lastIndexOf(";") != orderByItem.indexOf(";")) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBY_FORMAT_INVALID);
        }
        String direct = orderByItem.substring(orderByItem.indexOf(";") + 1).toUpperCase();
        if (!direct.equals("ASC") && !direct.equals("DESC")) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBY_FORMAT_INVALID);
        }
    }

    protected SqlSelectItem getItem(List selectors, String alias) {
        if (selectors == null || selectors.size() == 0) {
            return null;
        }
        int size = selectors.size();
        for (int i = 0; i < size; ++i) {
            if (!(selectors.get(i) instanceof SqlSelectItem) || !((SqlSelectItem)selectors.get((int)i)).alias.equalsIgnoreCase("\"" + alias + "\"") && !((SqlSelectItem)selectors.get((int)i)).alias.equalsIgnoreCase(alias)) continue;
            return (SqlSelectItem)selectors.get(i);
        }
        return null;
    }

    @Override
    protected List _getEmpCompenseDataPKs(Context ctx, IObjectPK scheme, List orderByList) throws BOSException, EASDBException, EASBizException {
        if (scheme == null) {
            return null;
        }
        String sql = this._getOrderedItemSelectSQL(ctx, scheme, orderByList);
        String horTableName = HRSchemeUtils.getCmpSchemeHorTableName(ctx, scheme.toString());
        SqlSelectBase selectBase = null;
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            selectBase = parser.select(true);
            if (selectBase instanceof SqlSelect) {
                select = (SqlSelect)selectBase;
            }
        }
        catch (ParserException e) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR, e);
        }
        ArrayList<Integer> rst = new ArrayList<Integer>();
        if (select != null) {
            SqlSelectItem item = new SqlSelectItem();
            SqlExprParser exprParser = null;
            String sequence = horTableName + "." + EMPCMPSEQNAME;
            try {
                exprParser = new SqlExprParser(sequence);
                item.expr = exprParser.expr();
                item.alias = "EMPSequence";
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            select.selectList.add(0, item);
            StringBuffer sb = new StringBuffer();
            try {
                DrSQLFormater formater = new DrSQLFormater(sb);
                formater.formatSelect(select);
            }
            catch (FormaterException e2) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
            IRowSet rs = exec.executeSQL();
            try {
                while (rs.next()) {
                    rst.add(rs.getInt(1));
                }
            }
            catch (SQLException e3) {
                throw new CompenException(CompenException.COMPENDBEXCEPTION, e3);
            }
        }
        return rst;
    }

    @Override
    protected IRowSet _getEmpCompenseData(Context ctx, IObjectPK schemePK, List IDs, List orderByList) throws BOSException, EASDBException, EASBizException {
        if (schemePK == null) {
            return null;
        }
        FilterInfo temp = HRSchemeUtils.addCmpSchemeIDCondition(ctx, null, schemePK.toString());
        String sql = this._innergetOrderedItemSelectSQL(ctx, schemePK, temp, orderByList);
        sql = sql.trim();
        StringBuffer sb = new StringBuffer();
        if (IDs != null && IDs.size() > 0) {
            ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
            CmpSchemeInfo schemeInfo = sch.getCmpSchemeInfo(schemePK);
            String horTableName = schemeInfo.getHorTableName();
            sb.append(sql.substring(0, sql.indexOf("ORDER BY")));
            sb.append(" and (");
            sb.append(horTableName);
            sb.append(".FPersonID");
            sb.append(" in ");
            sb.append("(");
            int size = IDs.size();
            for (int i = 0; i < size; ++i) {
                sb.append("'");
                sb.append(IDs.get(i));
                sb.append("',");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append(")) ");
            sb.append(sql.substring(sql.indexOf("ORDER BY")));
        } else {
            sb.append(sql);
        }
        sql = this.getOrderBySQL(sb.toString());
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    private String addOrderBySQL(Context ctx, String sql, SorterItemCollection colSorter) throws EmpCmpSchmFacadeException, BOSException {
        if (colSorter == null || colSorter.size() <= 0) {
            return sql;
        }
        SqlSelect select = HRSchemeUtils.getSqlSelectFromQuery(ctx, "com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
        SqlSelectItem selectItem = null;
        int fromIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"FROM");
        String beforeFrom = sql.substring(0, fromIndex);
        String addSelectString = "";
        StringBuffer orderByString = new StringBuffer();
        int size = colSorter.size();
        for (int i = 0; i < size; ++i) {
            selectItem = this.getItem(select.selectList, colSorter.get(i).getPropertyName());
            if (selectItem == null) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
            }
            if (StringUtils.indexOfIgnoreCase((String)beforeFrom, (String)selectItem.expr.toString()) <= 0) {
                addSelectString = addSelectString + " ," + selectItem.toString();
            }
            if (!orderByString.toString().equals("")) {
                orderByString.append(",");
            }
            orderByString.append(selectItem.expr.toString()).append(" ").append(colSorter.get(i).getSortType().getName());
        }
        String strRtnSql = beforeFrom + addSelectString + "  " + sql.substring(fromIndex, sql.length() - 1);
        int iOrderByIndex = StringUtils.indexOfIgnoreCase((String)strRtnSql, (String)"ORDER BY");
        strRtnSql = iOrderByIndex > 0 ? strRtnSql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString : strRtnSql + " ORDER BY " + orderByString;
        return strRtnSql;
    }

    protected String getOrderBySQL(String sql) {
        String beforeFrom = sql.substring(0, sql.indexOf("FROM"));
        String addString = "";
        sql = sql + "  ";
        if (beforeFrom.indexOf("\"ATTACHDEPT\".FLongNumber") <= 0) {
            addString = addString + " ,\"ATTACHDEPT\".FLongNumber ";
        }
        if (beforeFrom.indexOf("\"PERSON\".FNumber") <= 0) {
            addString = addString + " ,\"PERSON\".FNumber ";
        }
        if ((sql = beforeFrom + addString + sql.substring(sql.indexOf("FROM"), sql.length() - 1)).indexOf("ORDER BY") > 0) {
            sql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if (sql.indexOf("ORDER BY") <= 0) {
            sql = sql + " ORDER BY \"PERSON\".FIndex ";
        }
        return sql;
    }

    @Override
    protected Map _getEmpSalariatPoint(Context ctx, String schemeID, String salariatPointSchmID, List empIDList, String salPointSalGradeID) throws EASBizException, BOSException {
        HashMap empSalariat = new HashMap();
        String salGradeTableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        List allCol = this.getSalaritColList(ctx, salariatPointSchmID, true);
        String defaultSalColName = (String)allCol.get(0);
        List personItemList = this.getSalSchPersonItemList(ctx, salariatPointSchmID);
        int iPageSize = this.getPageSize(ctx);
        String sql = "SELECT * FROM " + salGradeTableName;
        String sql1 = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + salGradeTableName + "'";
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql1);
        if (rst.size() > 0) {
            sql = salPointSalGradeID == null ? sql + " where FSalPointSalGradeID is null" : sql + " where FSalPointSalGradeID ='" + salPointSalGradeID + "'";
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ArrayList<String> personItemValues = null;
            List matchEmp = null;
            while (rows.next()) {
                personItemValues = new ArrayList<String>();
                int size = personItemList.size();
                for (int i = 0; i < size; ++i) {
                    personItemValues.add(rows.getString(personItemList.get(i).toString()));
                }
                matchEmp = this.getMatchEmp(ctx, personItemList, personItemValues, iPageSize, empIDList);
                int jsize = matchEmp.size();
                for (int j = 0; j < jsize; ++j) {
                    empSalariat.put(matchEmp.get(j), rows.getString(defaultSalColName));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return empSalariat;
    }

    @Override
    protected Map _getEmpSalariatPointRange(Context ctx, String salariatPointSchmID, String personID, String salPointSalGradeID) throws BOSException, EASBizException {
        String strNumber = null;
        HashMap<String, Integer> empSalariat = new HashMap<String, Integer>();
        String salTableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        List lstAllCol = this.getSalaritColList(ctx, salariatPointSchmID, false);
        List personItemList = this.getSalSchPersonItemList(ctx, salariatPointSchmID);
        Map mapPersonValue = this.getFixedItemValue(ctx, personItemList, personID);
        for (int i = personItemList.size() - 1; i >= 0; --i) {
            strNumber = personItemList.get(i).toString();
            if (mapPersonValue.get(strNumber) != null) continue;
            personItemList.remove(i);
        }
        if (personItemList.size() == 0) {
            return empSalariat;
        }
        StringBuffer personItemSql = new StringBuffer();
        personItemSql.append(" SELECT item.fnumber as fnumber,item.fDataType as fDataType").append(" FROM t_hr_cmpItem item where fHrOrgUnitID in (").append(" select fHrOrgUnitID from T_HR_SALARIATSCH where T_HR_SALARIATSCH.fid='").append(salariatPointSchmID).append("')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)personItemSql.toString());
        HashMap<String, String> itemMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                itemMap.put(rs.getString("fnumber"), rs.getString("fDataType"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        personItemSql.append(" select fHrOrgUnitID from T_HR_SALARIATSCH");
        StringBuffer sbSql = new StringBuffer(" SELECT * FROM ");
        sbSql.append(salTableName);
        sbSql.append(" where ");
        int size = personItemList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sbSql.append(" and ");
            }
            strNumber = personItemList.get(i).toString();
            sbSql.append(" ");
            sbSql.append(strNumber);
            if (mapPersonValue.get(strNumber) != null) {
                String dataType = (String)itemMap.get(strNumber);
                if (Integer.parseInt(dataType) == 40 || Integer.parseInt(dataType) == 50 || Integer.parseInt(dataType) == 60) {
                    sbSql.append("=");
                    sbSql.append(mapPersonValue.get(strNumber));
                    continue;
                }
                sbSql.append("='");
                sbSql.append(mapPersonValue.get(strNumber));
                sbSql.append("' ");
                continue;
            }
            sbSql.append(" IS NULL ");
        }
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + salTableName + "'";
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rst.size() > 0) {
            if (salPointSalGradeID == null) {
                sbSql.append(" and FSalPointSalGradeID is null");
            } else {
                sbSql.append(" and FSalPointSalGradeID ='" + salPointSalGradeID + "'");
            }
        }
        IRowSet iRS = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        try {
            while (iRS.next()) {
                int size2 = lstAllCol.size();
                for (int i = 0; i < size2; ++i) {
                    strNumber = lstAllCol.get(i).toString();
                    int iSeq = Integer.parseInt(strNumber.substring(strNumber.indexOf("_") + 1, strNumber.length()));
                    if (iRS.getString(strNumber) == null) continue;
                    empSalariat.put(iRS.getString(strNumber), i);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRS);
        }
        return empSalariat;
    }

    protected Map _getEmpSalariatPointRangeOld(Context ctx, String salariatPointSchmID, String personID) throws BOSException, EASBizException {
        HashMap empSalariat = new HashMap();
        String salTableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        List lstAllCol = this.getSalaritColList(ctx, salariatPointSchmID, false);
        List personItemList = this.getSalSchPersonItemList(ctx, salariatPointSchmID);
        int iPageSize = this.getPageSize(ctx);
        ISalariatMapPersonItem iMapItem = SalariatMapPersonItemFactory.getLocalInstance(ctx);
        String oql = "select * where salSchm.id='" + salariatPointSchmID + "'";
        SalariatMapPersonItemCollection col = iMapItem.getSalariatMapPersonItemCollection(oql);
        Object info = null;
        String itemValue = "";
        HashMap mapSalPointID = this.getMapPersonItemSalPoint(ctx, col, salTableName, lstAllCol);
        ArrayList<String> empIDList = new ArrayList<String>();
        empIDList.add(personID);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            List lstSalPointID = (List)mapSalPointID.get(col.get(i).getId().toString());
            List matchEmp = this.getMatchEmp(ctx, personItemList, null, iPageSize, empIDList);
            if (matchEmp.size() <= 0) continue;
            int length = lstSalPointID.size();
            for (int m = 0; m < length; ++m) {
                empSalariat.put(lstSalPointID.get(m), lstSalPointID.get(m));
            }
        }
        return empSalariat;
    }

    protected Map getPointValue(Context ctx, String salariatPointSchmID, double base) throws SQLException, EASBizException, BOSException {
        List lst = this.getCmpItemsOfSalariatPointSchm(ctx, salariatPointSchmID);
        String tableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        return this.getSalariatValue(ctx, tableName, lst, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getCmpItemsOfSalariatPointSchm(Context ctx, String salariatPointSchmID) throws SQLDataException, SQLException {
        String sql = "select b.fnumber from t_hr_salarcmpitem a,t_hr_cmpitem b where a.itemid = b.fid and a.fschemeid= ? ";
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> lst = new ArrayList<String>(16);
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            stmt.setString(0, salariatPointSchmID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSalariatValue(Context ctx, String tableName, List lstCol, double base) throws SQLDataException, SQLException {
        String cols = this.getSelectColumn(lstCol);
        String sql = "select fpointid," + cols + " from " + tableName;
        Connection cn = null;
        Statement stmt = null;
        ResultSet rs = null;
        HashMap map = new HashMap(32);
        HashMap<String, Double> subMap = null;
        int size = lstCol.size();
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String point = rs.getString("fpoint");
                subMap = new HashMap<String, Double>(32);
                for (int i = 0; i < size; ++i) {
                    String item = (String)lstCol.get(i);
                    subMap.put(item, new Double(rs.getDouble(item) * base));
                }
                map.put(point, subMap);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return map;
    }

    protected String getSelectColumn(List lst) {
        StringBuffer buff = new StringBuffer(1024);
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            buff.append(lst.get(i) + ",");
        }
        return buff.substring(0, buff.length() - 1);
    }

    protected Map getSalariatLevleList(Context ctx, String salariatPointSchmID, String colNameOfPersonItem) throws EASBizException, BOSException {
        String salTableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        List lstCol = this.getSalaritColList(ctx, salariatPointSchmID, true);
        String defaultSalColName = (String)lstCol.get(0);
        String sql = "select " + colNameOfPersonItem + "," + defaultSalColName + " from T_HR_SALMAPPERITM a," + salTableName + " b where a.FSalSchmID=b.FPersonMapID and a.FSalSchmID='" + salariatPointSchmID + "' and " + colNameOfPersonItem + " is not null";
        return this.execQueryOfSalariatLevel(ctx, sql);
    }

    protected Map execQueryOfSalariatLevel(Context ctx, String sql) throws EmpCmpSchmFacadeException {
        Connection con = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql);
            rs = pstm.executeQuery();
            while (rs.next()) {
                map.put(rs.getString(1).trim(), rs.getString(2).trim());
            }
        }
        catch (Exception e) {
            try {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_PERSONITMLIST_EXEC, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return map;
    }

    protected Map getValueOfPersonItem(Context ctx, List lstEmp, String colName) throws BOSException, EmpCmpSchmFacadeException {
        HashMap mapPerson = new HashMap(lstEmp.size() * 2);
        List lstSet = this.splitLstEmp(lstEmp);
        int size = lstSet.size();
        for (int i = 0; i < size; ++i) {
            HashSet hset = (HashSet)lstSet.get(i);
            this.execQuery(ctx, mapPerson, hset, colName);
        }
        return mapPerson;
    }

    protected void execQuery(Context ctx, Map mapPerson, HashSet hset, String colName) throws EmpCmpSchmFacadeException, BOSException {
        MetaDataPK dataPk = new MetaDataPK("com.kingdee.eas.hr.compensation.app.EmpCompenseQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)dataPk);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(colName));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo fitem = new FilterItemInfo("Person.id", new HashSet(), CompareType.INCLUDE);
        filter.getFilterItems().add(fitem);
        view.setFilter(filter);
        exec.setObjectView(view);
        IRowSet rowSet = exec.executeQuery();
        this.setValueOfPersonItem(rowSet, mapPerson, colName);
    }

    protected void setValueOfPersonItem(IRowSet rowSet, Map map, String colName) throws EmpCmpSchmFacadeException {
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("fpersonid").trim(), rowSet.getString(colName).trim());
            }
        }
        catch (SQLException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_PERSONITMLIST_EXEC, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
    }

    protected List splitLstEmp(List lstEmp) {
        int factor = 400;
        ArrayList lst = new ArrayList();
        HashSet hset = new HashSet();
        int size = lstEmp.size();
        for (int i = 0; i < size; ++i) {
            if (i % factor == 0) {
                if (hset.size() > 0) {
                    lst.add(hset);
                }
                hset = new HashSet();
            }
            hset.add(lstEmp.get(i));
        }
        return lst;
    }

    @Override
    protected Map _getAllEmpSalariatPoint(Context ctx, String cmpSchmID) throws EASBizException, BOSException {
        if (cmpSchmID == null) {
            return null;
        }
        HashMap empSalariat = new HashMap();
        String salariatPointSchmID = "";
        String salTableName = this.getSalPointTableName(ctx, salariatPointSchmID);
        List allCol = this.getSalaritColList(ctx, salariatPointSchmID, true);
        String defaultSalColName = (String)allCol.get(0);
        List personItemList = this.getSalSchPersonItemList(ctx, salariatPointSchmID);
        int iPageSize = this.getPageSize(ctx);
        ISalariatMapPersonItem mapItem = SalariatMapPersonItemFactory.getLocalInstance(ctx);
        String oql = "select * where salSchm.id='" + salariatPointSchmID + "'";
        SalariatMapPersonItemCollection col = mapItem.getSalariatMapPersonItemCollection(oql);
        Object info = null;
        String itemValue = "";
        HashMap mapSalPointID = this.getMapPersonItemSalPoint(ctx, col, salTableName, defaultSalColName);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String salPointID = mapSalPointID.get(col.get(i).getId().toString()).toString();
            List matchEmp = this.getMatchEmp(ctx, personItemList, null, iPageSize, null);
            int jsize = matchEmp.size();
            for (int j = 0; j < jsize; ++j) {
                empSalariat.put(matchEmp.get(j), salPointID);
            }
        }
        return empSalariat;
    }

    protected int getPageSize(Context ctx) throws BOSException, EASBizException {
        int iPageSize = 50000;
        return iPageSize;
    }

    protected String getEmpCmpTableName(Context ctx, String cmpSchID) throws EASBizException, BOSException {
        String tableName = "";
        String sql = " SELECT FHorTableName FROM T_HR_CMPSCHEME WHERE FID=? ";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(sql);
            ps1.setString(1, cmpSchID);
            ResultSet iRowSet = ps1.executeQuery();
            while (iRowSet.next()) {
                tableName = iRowSet.getString("FHorTableName");
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        return tableName;
    }

    protected String getSalPointTableName(Context ctx, String salSchID) throws EASBizException, BOSException {
        String gradeTableName = "";
        String sql = " SELECT FGradeTableName FROM T_HR_SALARIATSCH WHERE FID=? ";
        Object[] param = new Object[]{salSchID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                gradeTableName = iRowSet.getString("FGradeTableName");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return gradeTableName;
    }

    protected HashMap getMapPersonItemSalPoint(Context ctx, SalariatMapPersonItemCollection col, String salTabName, String selectColName) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (col == null || col.size() <= 0) {
            return map;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FPersonMapID,");
        sql.append(selectColName);
        sql.append(" from ");
        sql.append(salTabName);
        sql.append(" where FPersonMapID in ( ");
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            sql.append("'");
            sql.append(col.get(i).getId().toString());
            sql.append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString(2) == null) {
                    map.put(rs.getString(1), "");
                    continue;
                }
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (Exception e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_PERSONITMLIST_EXEC, e);
        }
        return map;
    }

    protected HashMap getMapPersonItemSalPoint(Context ctx, SalariatMapPersonItemCollection col, String salTabName, List lstSelectColName) throws EASBizException, BOSException {
        int i;
        HashMap map = new HashMap();
        if (col == null || col.size() <= 0) {
            return map;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FPersonMapID,");
        int size = lstSelectColName.size();
        for (i = 0; i < size; ++i) {
            sql.append(lstSelectColName.get(i));
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from ");
        sql.append(salTabName);
        sql.append(" where FPersonMapID in ( ");
        size = col.size();
        for (i = 0; i < size; ++i) {
            sql.append("'");
            sql.append(col.get(i).getId().toString());
            sql.append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<String> lst = null;
            while (rs.next()) {
                lst = new ArrayList<String>();
                int size2 = lstSelectColName.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    lst.add(rs.getString(2 + i2));
                }
                map.put(rs.getString(1), lst);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_PERSONITMLIST_EXEC, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    protected List getSalSchPersonItemList(Context ctx, String salSchID) throws EmpCmpSchmFacadeException, BOSException {
        if (salSchID == null || salSchID.length() == 0) {
            return null;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        StringBuffer sbSql = new StringBuffer(" SELECT T_HR_CMPITEM.FNUMBER FROM T_HR_SALPERSONITEM  INNER JOIN T_HR_CMPITEM ON T_HR_CMPITEM.FID = T_HR_SALPERSONITEM.FItemID WHERE FSchemeID=? ");
        Object[] param = new Object[]{salSchID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])param);
        try {
            while (iRowSet.next()) {
                numberList.add(iRowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_ITEMNUM_EXEC, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return numberList;
    }

    protected List getSalaritColList(Context ctx, String salSchID, boolean isDefault) throws BOSException, EASBizException {
        if (salSchID == null || salSchID.length() == 0) {
            return null;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        StringBuffer sbSql = new StringBuffer(" SELECT FNUMBER FROM T_HR_SALARIATPOINT WHERE FSchemeID=? ");
        if (isDefault) {
            sbSql.append(" and FIsDefault=1 ");
        }
        sbSql.append(" order by FSeq ");
        Object[] param = new Object[]{salSchID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])param);
        try {
            while (iRowSet.next()) {
                numberList.add(iRowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_DEFSALPOINT_EXEC, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return numberList;
    }

    private List getMatchEmp(Context ctx, List personItemList, List personItemValues, int pageSize, List empIDList) throws EASBizException, BOSException {
        ArrayList<String> matchEmpList = new ArrayList<String>();
        ArrayList<String> sqlList = new ArrayList<String>();
        String sql = "";
        String empTabName = "\"PERSON\"";
        SqlSelect select = this.getSelectExpr(ctx, personItemList, empTabName, personItemValues);
        if (empIDList != null) {
            int count = 0;
            ArrayList page = new ArrayList();
            int size = empIDList.size();
            for (int i = 0; i < size; ++i) {
                page.add(empIDList.get(i));
                if (count > pageSize) {
                    SqlExpr where = this.getEmpIDWhereExpr(page, empTabName);
                    ArrayList<String> lstCmpItem = new ArrayList<String>();
                    lstCmpItem.add("FPERSONID");
                    lstCmpItem.add("FPER001");
                    select.selectList = HRSchemeUtils.getMatchSelectListFromSqlSelect(select, lstCmpItem, null);
                    sql = this.getSelectStmt(select, where);
                    if (sql != null && sql.length() > 0) {
                        sqlList.add(sql);
                    }
                    count = 0;
                    page.clear();
                }
                ++count;
            }
            if (page.size() > 0) {
                SqlExpr where = this.getEmpIDWhereExpr(page, empTabName);
                ArrayList<String> lstCmpItem = new ArrayList<String>();
                lstCmpItem.add("FPERSONID");
                lstCmpItem.add("FPER001");
                select.selectList = HRSchemeUtils.getMatchSelectListFromSqlSelect(select, lstCmpItem, null);
                sql = this.getSelectStmt(select, where);
                if (sql != null && sql.length() > 0) {
                    sqlList.add(sql);
                }
            }
        } else {
            sql = this.getSelectStmt(select, null);
            if (sql != null && sql.length() > 0) {
                sqlList.add(sql);
            }
        }
        IRowSet rs = null;
        int size = sqlList.size();
        for (int i = 0; i < size; ++i) {
            String optSql = PersonInfoUtils.getOptimizeSql((String)sqlList.get(i));
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)optSql);
            rs = exec.executeSQL();
            try {
                while (rs.next()) {
                    matchEmpList.add(rs.getString(1));
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_ITEMNUM_EXEC, e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return matchEmpList;
    }

    protected String getSelectStmt(SqlSelect select, SqlExpr where) throws EASBizException, BOSException {
        StringBuffer buff = new StringBuffer();
        if (select != null) {
            if (where != null) {
                SqlBinaryOpExpr binaryExpr = new SqlBinaryOpExpr(select.condition, 7, where);
                select.condition = binaryExpr;
            }
            try {
                DrSQLFormater formater = new DrSQLFormater(buff);
                formater.formatSelect(select);
            }
            catch (FormaterException e) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
            }
        }
        return buff.toString();
    }

    protected String getSelectItemSource(List selectItemList, String alias) throws EmpCmpSchmFacadeException {
        String sourceAlias;
        SqlSelectItem item;
        int i;
        if (selectItemList == null || selectItemList.size() == 0) {
            return "";
        }
        if (alias.equalsIgnoreCase("FPER006") || alias.equalsIgnoreCase("FPER007") || alias.equalsIgnoreCase("FPER016") || alias.equalsIgnoreCase("FPER017") || alias.equalsIgnoreCase("FPER022")) {
            alias = alias + ".ID";
        }
        if (alias.equalsIgnoreCase("FPER003") || alias.equalsIgnoreCase("FPER004") || alias.equalsIgnoreCase("FPER005")) {
            alias = "ATTACHDEPT.ID";
        }
        if (alias.equalsIgnoreCase("FPER001") || alias.equalsIgnoreCase("FPER002")) {
            alias = "FPERSONID";
        }
        StringBuffer sb = new StringBuffer(alias);
        int size = selectItemList.size();
        for (i = 0; i < size; ++i) {
            item = (SqlSelectItem)selectItemList.get(i);
            sourceAlias = item.alias.replaceAll("\"", "");
            if (!sourceAlias.trim().equals(alias + ".ID")) continue;
            sb.append(".ID");
        }
        size = selectItemList.size();
        for (i = 0; i < size; ++i) {
            item = (SqlSelectItem)selectItemList.get(i);
            sourceAlias = item.alias.replaceAll("\"", "");
            if (!sourceAlias.trim().equals(sb.toString())) continue;
            StringBuffer buff = new StringBuffer();
            try {
                DrSQLFormater formater = new DrSQLFormater(buff);
                formater.formatExpr(item.expr);
            }
            catch (FormaterException e) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
            }
            return buff.toString();
        }
        return "NOTFOUNT";
    }

    private SqlSelect getSelectExpr(Context ctx, List cmpItemList, String empTabName, List personItemValues) throws EASBizException, BOSException {
        StringBuffer buff = new StringBuffer();
        SqlSelect select = this.getFixedItemSQL(ctx, 2);
        String itemValue = "";
        String itemNumber = "";
        String itemSource = "";
        SqlBinaryOpExpr binaryExpr = null;
        SqlExprParser parser = null;
        int jsize = cmpItemList.size();
        for (int j = 0; j < jsize; ++j) {
            itemNumber = (String)cmpItemList.get(j);
            itemSource = this.getSelectItemSource(select.selectList, itemNumber);
            Object value = personItemValues.get(j);
            if (value == null) continue;
            itemValue = value instanceof AbstractCoreBaseInfo ? ((AbstractCoreBaseInfo)value).getId().toString() : value.toString();
            if (itemSource == null || itemSource.length() == 0 || itemValue == null || itemValue.length() == 0) continue;
            buff.delete(0, buff.length());
            buff.append(itemSource);
            buff.append(" = '");
            buff.append(itemValue);
            buff.append("'");
            try {
                parser = new SqlExprParser(buff.toString());
                SqlExpr expr = parser.expr();
                if (binaryExpr == null) {
                    binaryExpr = (SqlBinaryOpExpr)expr;
                    continue;
                }
                binaryExpr = new SqlBinaryOpExpr((SqlExpr)binaryExpr, 7, expr);
                continue;
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage());
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC);
            }
        }
        if (binaryExpr != null) {
            select.condition = new SqlBinaryOpExpr(select.condition, 7, binaryExpr);
        }
        return select;
    }

    protected SqlExpr getEmpIDWhereExpr(List empIDList, String empTabName) throws EASBizException {
        StringBuffer buff = new StringBuffer();
        SqlExprParser parser = null;
        SqlExpr expr = null;
        if (empIDList != null && empIDList.size() > 0) {
            buff.append(empTabName);
            buff.append(".FID");
            buff.append(" in ( ");
            int size = empIDList.size();
            for (int i = 0; i < size; ++i) {
                buff.append("'");
                buff.append(empIDList.get(i));
                buff.append("',");
            }
            buff.deleteCharAt(buff.lastIndexOf(","));
            buff.append(")");
        }
        if (buff.length() > 0) {
            try {
                parser = new SqlExprParser(buff.toString());
                expr = parser.expr();
            }
            catch (ParserException e) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
            }
        }
        return expr;
    }

    @Override
    protected void _setAllEmpSalariatPoint(Context ctx, String cmpSchmID) throws BOSException {
    }

    @Override
    protected List _getItemPriotityList(Context ctx, String schID) throws BOSException, EASBizException {
        if (schID == null) {
            return null;
        }
        String oql = "select formula,cmpItem.number where cmpScheme.id='" + schID + "'";
        ICmpSchemeItem sch = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection items = sch.getCmpSchemeItemCollection(oql);
        HashMap<String, String> itemFormula = new HashMap<String, String>();
        HashMap<String, DependNode> itemNode = new HashMap<String, DependNode>();
        StringBuffer regex = new StringBuffer();
        CmpSchemeItemInfo info = null;
        HashSet<String> noFormulaItem = new HashSet<String>();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            info = items.get(i);
            String key = info.getCmpItem().getNumber();
            itemFormula.put(key, info.getFormula());
            if (info.getFormula() == null) {
                noFormulaItem.add(key);
            }
            regex.append(key);
            if (i < size - 1) {
                regex.append("|");
            }
            itemNode.put(key, new DependNode(key));
        }
        Iterator itl = itemFormula.entrySet().iterator();
        Pattern p = Pattern.compile(regex.toString());
        Matcher m = null;
        Map.Entry entry2 = null;
        while (itl.hasNext()) {
            entry2 = itl.next();
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            if (value == null) continue;
            String formula = (String)value;
            m = p.matcher(formula);
            while (m.find()) {
                String depItem = formula.substring(m.start(), m.end());
                if (depItem == null || depItem.equals(key)) continue;
                ((DependNode)itemNode.get(key)).addDependItem((DependNode)itemNode.get(depItem));
            }
        }
        ArrayList nodeList = new ArrayList();
        for (Map.Entry entry2 : itemNode.entrySet()) {
            String key = (String)entry2.getKey();
            nodeList.add(entry2.getValue());
        }
        DependForest frst = new DependForest();
        frst.build(nodeList);
        List rst = frst.toSequence(frst.travelForest(), 0);
        ArrayList filterItemList = new ArrayList();
        int size2 = rst.size();
        for (int i = 0; i < size2; ++i) {
            if (noFormulaItem.contains((String)rst.get(i))) continue;
            filterItemList.add(rst.get(i));
        }
        return filterItemList;
    }

    @Override
    protected IRowSet _getEmpCompenseData(Context ctx, IObjectPK schemePK, List IDs, List orderByList, FilterInfo cmpCheckFilter) throws BOSException, EASBizException, EASDBException {
        if (schemePK == null) {
            return null;
        }
        String sql = this.getOrderedItemSelectSQL(ctx, schemePK, orderByList, cmpCheckFilter, null);
        if (StringUtils.isEmpty((String)(sql = sql.trim()))) {
            return null;
        }
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql);
        sql = this.getOrderBySQL(sql);
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    @Override
    protected IRowSet _getEmpCompenseData(Context ctx, IObjectPK schemePK, List IDs, List orderByList, FilterInfo cmpCheckFilter, HashMap paramMap) throws BOSException, EASBizException, EASDBException {
        CmpSchemeInfo info;
        String hortblName;
        String sql;
        if (schemePK == null) {
            return null;
        }
        String adjustSchemeId = null;
        if (paramMap != null && paramMap.containsKey("fadjustSchemeId001")) {
            adjustSchemeId = (String)paramMap.get("fadjustSchemeId001");
            paramMap.remove("fadjustSchemeId001");
        }
        boolean showUncheckPersonOnly = false;
        if (paramMap != null && paramMap.containsKey("showUncheckPersonOnly")) {
            showUncheckPersonOnly = (Boolean)paramMap.get("showUncheckPersonOnly");
            paramMap.remove("showUncheckPersonOnly");
        }
        if ((sql = this.getSalarySQL(ctx, schemePK, orderByList, cmpCheckFilter, paramMap)) == null) {
            return null;
        }
        sql = sql.trim();
        sql = this.getModifiedSql(ctx, sql, schemePK, paramMap);
        SorterItemCollection colSorter = null;
        if (paramMap != null && paramMap.get("customSorter") != null) {
            colSorter = (SorterItemCollection)paramMap.get("customSorter");
        }
        sql = colSorter != null && colSorter.size() > 0 ? this.addOrderBySQL(ctx, sql, colSorter) : this.getOrderBySQL(sql);
        if (StringUtils.indexOfIgnoreCase((String)(sql = PersonInfoUtils.getOptimizeSql(sql)), (String)"FSAL000") >= 0) {
            String hortblName2 = "";
            int time = 1;
            if (paramMap != null && paramMap.size() > 0) {
                CmpPeriodInfo cmpBeginPeriod = (CmpPeriodInfo)paramMap.get("CmpBeginPeriod");
                HashMap<String, Object> mapTemp = new HashMap<String, Object>();
                mapTemp.put("cmpSchemeMapKey", schemePK.toString());
                mapTemp.put("cmpPeriodMapKey", cmpBeginPeriod);
                if (paramMap.get("CmpBeginTime") != null) {
                    mapTemp.put("cmpBeginTimeMapKey", (Integer)paramMap.get("CmpBeginTime"));
                    time = (Integer)paramMap.get("CmpBeginTime");
                }
                hortblName2 = HRSchemeUtils.getCmpSchemeHorTableName(ctx, mapTemp);
            } else {
                CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo(schemePK);
                hortblName2 = cmpSchemeInfo.getHorTableName();
            }
            String language = ctx.getLocale().getLanguage();
            String salariaId = hortblName2 + ".FSAL000 FSAL000";
            String salariaName = " case when(salariaTreeParent.fname_" + language + " is null) then salariaTree.fname_" + language + " else salariaTreeParent.fname_" + language + " || '-' || salariaTree.fname_" + language + " end  as FSAL000 ";
            String oldChars = "WHERE";
            String newChars = " LEFT JOIN T_HR_SALARIATTREE salariaTree ON " + hortblName2 + ".FSAL000=salariaTree.fid LEFT JOIN T_HR_SALARIATTREE salariaTreeParent ON salariaTreeParent.fid=salariaTree.fParentId WHERE";
            sql = StringUtils.replace((String)sql, (String)salariaId, (String)salariaName);
            sql = StringUtils.replace((String)sql, (String)oldChars, (String)newChars);
        }
        if (adjustSchemeId != null) {
            sql = this.getModifiedSqlAddEffectDate(sql, adjustSchemeId);
        }
        if (paramMap != null && paramMap.get("TABLE_SORT_COLUMN") != null) {
            String orderColumnName = paramMap.get("TABLE_SORT_COLUMN").toString();
            Integer orderType = (Integer)paramMap.get("TABLE_SORT_Type");
            orderColumnName = orderType == 0 ? orderColumnName + " ASC" : orderColumnName + " DESC";
            int iOrderByIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"ORDER BY");
            sql = iOrderByIndex > 0 ? sql.substring(0, iOrderByIndex) + " ORDER BY " + orderColumnName : sql + " ORDER BY " + orderColumnName;
        }
        String cmpItemFilter = null;
        if (paramMap != null) {
            cmpItemFilter = (String)paramMap.get("cmpItemFilter");
        }
        if (!StringUtils.isEmpty(cmpItemFilter)) {
            sql = StringUtils.indexOfIgnoreCase((String)sql, (String)"ORDER BY") > 0 ? sql.replaceFirst("ORDER BY", " and " + cmpItemFilter + " ORDER BY ") : sql + " and " + cmpItemFilter;
        }
        if (showUncheckPersonOnly && !StringUtils.isEmpty((String)(hortblName = (info = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo(schemePK)).getHorTableName()))) {
            String andSql = " and " + hortblName + ".FCalType <> 1 ";
            int iOrderByIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"ORDER BY");
            sql = iOrderByIndex > 0 ? sql.substring(0, iOrderByIndex) + andSql + sql.substring(iOrderByIndex, sql.length()) : sql + andSql;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (ctx.get((Object)"tmpTable") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(ctx.get((Object)"tmpTable").toString());
        }
        return rs;
    }

    private String getModifiedSqlAddEffectDate(String sql, String adjustSchemeId) {
        StringBuffer newSql = new StringBuffer();
        String select = sql.substring(0, sql.indexOf(" FROM "));
        String from = sql.substring(sql.indexOf(" FROM ") + 1, sql.indexOf(" WHERE "));
        String where = sql.substring(sql.indexOf(" WHERE ") + 1);
        newSql.append(select).append(", adjscheme.feffectdate  FEFFECTDATE ");
        newSql.append(from).append(" inner join T_HR_ADJSCHITEM as adjscheme on  adjscheme.fadjempid =\"PERSON\".fid ");
        newSql.append(" WHERE ").append(" adjscheme.fadjschemeid ='").append(adjustSchemeId).append("'");
        newSql.append(" and ").append(where.trim().substring(5));
        return newSql.toString();
    }

    protected String getSalarySQL(Context ctx, IObjectPK schemePK, List orderByList, FilterInfo cmpCheckFilter, HashMap paramMap) throws BOSException, EASBizException {
        String oql;
        ICmpSchemeItem schEntry = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection entries = schEntry.getCmpSchemeItemCollection(oql = "select CmpScheme.id , cmpScheme.horTableName,cmpItem.number,cmpItem.dataType where cmpScheme.id = '" + schemePK.toString() + "' and isDelete=0 order by sortOrder");
        if (entries.size() < 1) {
            return "";
        }
        List<CmpItemInfo> selectItem = null;
        if (paramMap != null && paramMap.containsKey("SelectCmpItem_Data")) {
            selectItem = (List)paramMap.get("SelectCmpItem_Data");
        }
        if (selectItem == null || selectItem.size() == 0) {
            selectItem = new ArrayList();
            for (int i = 0; i < entries.size(); ++i) {
                selectItem.add(entries.get(i).getCmpItem());
            }
        }
        String horTableName = "";
        if (paramMap != null && paramMap.size() > 0) {
            paramMap.remove("SelectCmpItem_Data");
            CmpPeriodInfo cmpBeginPeriod = (CmpPeriodInfo)paramMap.get("CmpBeginPeriod");
            HashMap<String, Object> mapTemp = new HashMap<String, Object>();
            mapTemp.put("cmpSchemeMapKey", entries.get(0).getCmpScheme().getId().toString());
            mapTemp.put("cmpPeriodMapKey", cmpBeginPeriod);
            if (paramMap.get("CmpBeginTime") != null) {
                mapTemp.put("cmpBeginTimeMapKey", (Integer)paramMap.get("CmpBeginTime"));
            }
            horTableName = HRSchemeUtils.getCmpSchemeHorTableName(ctx, mapTemp);
        } else {
            horTableName = entries.get(0).getCmpScheme().getHorTableName();
        }
        if (horTableName == null) {
            return null;
        }
        SqlSelect select = null;
        select = this.getPersonSQL(ctx, horTableName, cmpCheckFilter);
        ArrayList orderedSelectors = this.buildSelectItemList(ctx, selectItem, horTableName, select);
        select.selectList = null;
        select.selectList = orderedSelectors;
        SqlSelectItem item1 = new SqlSelectItem();
        SqlSelectItem item2 = new SqlSelectItem();
        SqlSelectItem item3 = new SqlSelectItem();
        SqlSelectItem item4 = new SqlSelectItem();
        try {
            SqlExprParser parser1 = new SqlExprParser("\"personCmp\".FAccountOne");
            item1.expr = parser1.expr();
            SqlExprParser parser2 = new SqlExprParser("\"personCmp\".FAccountTwo");
            item2.expr = parser2.expr();
            SqlExprParser parser3 = new SqlExprParser("\"personCmp\".FAccountThree");
            item3.expr = parser3.expr();
            SqlExprParser parser4 = new SqlExprParser("\"personCmp\".FAccountFour");
            item4.expr = parser4.expr();
        }
        catch (ParserException e) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        item1.alias = "FPER025";
        item2.alias = "FPER026";
        item3.alias = "FPER027";
        item4.alias = "FPER057";
        select.selectList.add(item1);
        select.selectList.add(item2);
        select.selectList.add(item3);
        select.selectList.add(item4);
        select.condition = this.buildWhereExpr(select, horTableName);
        select.orderBy = this.buildOrderByExprList(orderByList, select);
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    protected SqlSelect getPersonSQL(Context ctx, String tableName, FilterInfo cmpCheckFilter) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        EntityViewInfo view = new EntityViewInfo();
        if (cmpCheckFilter != null) {
            view.setFilter(cmpCheckFilter);
        }
        String sql = HRSchemeUtils.getCmpDynamicTableSql(ctx, tableName, view);
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    protected String getModifiedSql(Context ctx, String sql, IObjectPK schemePK, HashMap paramMap) throws EASBizException, BOSException {
        int time = 1;
        if (paramMap != null && paramMap.size() > 0) {
            CmpPeriodInfo cmpBeginPeriod = (CmpPeriodInfo)paramMap.get("CmpBeginPeriod");
            HashMap<String, Object> mapTemp = new HashMap<String, Object>();
            mapTemp.put("cmpSchemeMapKey", schemePK.toString());
            mapTemp.put("cmpPeriodMapKey", cmpBeginPeriod);
            if (paramMap.get("CmpBeginTime") != null) {
                mapTemp.put("cmpBeginTimeMapKey", (Integer)paramMap.get("CmpBeginTime"));
                time = (Integer)paramMap.get("CmpBeginTime");
            }
            String horTableName = HRSchemeUtils.getCmpSchemeHorTableName(ctx, mapTemp);
            StringBuffer temp = new StringBuffer(sql.substring(0, sql.indexOf("FROM")) + " ,\"ATTACHDEPT\".FLongNumber ");
            temp.append(",").append(horTableName).append(".FPERIOD  ");
            sql = temp.toString() + sql.substring(sql.indexOf("FROM"), sql.length());
            String tempSql = sql.substring(sql.indexOf("WHERE") + 5, sql.length());
            temp = new StringBuffer(sql.substring(0, sql.indexOf("WHERE")));
            temp.append("WHERE ").append(horTableName).append(".FPERIOD='").append(cmpBeginPeriod.getId().toString()).append("' AND ").append(horTableName).append(".FTIME = ").append(time).append(" and ");
            if (paramMap.get("personList") != null) {
                List personIDList = (List)paramMap.get("personList");
                temp.append(horTableName).append(".FPERSONID IN(");
                if (personIDList != null && personIDList.size() > 500) {
                    TempTablePool pool = null;
                    String tmpTable = null;
                    tmpTable = this.createIdTmpTable(ctx, pool, personIDList);
                    ctx.put((Object)"tmpTable", (Object)tmpTable);
                    temp.append("select FID from ").append(tmpTable);
                } else if (personIDList != null) {
                    int sizePerson = personIDList.size();
                    for (int i = 0; i < sizePerson; ++i) {
                        temp.append("'").append(personIDList.get(i).toString()).append("'");
                        if (i == sizePerson - 1) continue;
                        temp.append(",");
                    }
                }
                temp.append(") AND ");
            }
            if ((sql = temp.toString() + tempSql).indexOf("ORDER BY") > 0) {
                sql = sql.substring(0, sql.indexOf("ORDER BY"));
            }
            sql = sql + " ORDER BY \"ATTACHDEPT\".FLongNumber, \"PERSON\".FNumber";
        } else {
            String temp = sql.substring(0, sql.indexOf("FROM")) + " ,\"ATTACHDEPT\".FLongNumber ";
            if ((sql = temp + sql.substring(sql.indexOf("FROM"), sql.length())).indexOf("ORDER BY") > 0) {
                sql = sql.substring(0, sql.indexOf("ORDER BY"));
            }
            sql = sql + " ORDER BY \"ATTACHDEPT\".FLongNumber ";
        }
        return sql;
    }

    private String createIdTmpTable(Context ctx, TempTablePool pool, List idList) throws BOSException {
        pool = TempTablePool.getInstance((Context)ctx);
        String cSql = " create TABLE  t1 (FID varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FID ) values (?) \n");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int j = idList.size();
        for (int i = 0; i < j; ++i) {
            list.add(new Object[]{idList.get(i)});
        }
        HRUtil.executeBatch((Context)ctx, (String)sbInsert.toString(), list);
        return tmpTableName;
    }

    protected String getOrderedItemSelectSQL(Context ctx, IObjectPK schemePK, List orderByList, FilterInfo cmpCheckFilter, HashMap paramMap) throws BOSException, EASBizException {
        String oql;
        ICmpSchemeItem schEntry = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection entries = schEntry.getCmpSchemeItemCollection(oql = "select CmpScheme.cmpSchm.id , cmpScheme.horTableName,cmpItem.number,cmpItem.dataType where cmpScheme.id = '" + schemePK.toString() + "' order by sortOrder");
        if (entries.size() < 1) {
            return "";
        }
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        for (int i = 0; i < entries.size(); ++i) {
            itemList.add(entries.get(i).getCmpItem());
        }
        String horTableName = "";
        if (paramMap != null && paramMap.size() > 0) {
            CmpPeriodInfo cmpBeginPeriod = (CmpPeriodInfo)paramMap.get("CmpBeginPeriod");
            HashMap<String, Object> mapTemp = new HashMap<String, Object>();
            mapTemp.put("cmpSchemeMapKey", entries.get(0).getCmpScheme().getId().toString());
            mapTemp.put("cmpPeriodMapKey", cmpBeginPeriod);
            horTableName = HRSchemeUtils.getCmpSchemeHorTableName(ctx, mapTemp);
        } else {
            horTableName = entries.get(0).getCmpScheme().getHorTableName();
        }
        if (horTableName == null) {
            return null;
        }
        SqlSelect select = null;
        select = this.getFixedItemSQL(ctx, 1, cmpCheckFilter);
        ArrayList orderedSelectors = this.buildSelectItemList(ctx, itemList, horTableName, select);
        select.selectList = null;
        select.selectList = orderedSelectors;
        select.tableSource = this.buildTableSource(select, horTableName);
        select.condition = this.buildWhereExpr(select, horTableName);
        select.orderBy = this.buildOrderByExprList(orderByList, select);
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    protected SqlSelect getFixedItemSQL(Context ctx, int type, FilterInfo cmpCheckFilter) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        String strQueryPK = null;
        strQueryPK = type == 1 ? "com.kingdee.eas.hr.compensation.app.PersonInfoQuery" : "com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery";
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(strQueryPK));
        EntityViewInfo view = new EntityViewInfo();
        if (cmpCheckFilter != null) {
            view.setFilter(cmpCheckFilter);
        }
        try {
            view = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, type, view);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    @Override
    protected Set _getPermSchemePersonSet(Context ctx, String schemeid) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet iRowSet = this._getEmpCompenseData(ctx, (IObjectPK)new ObjectUuidPK(schemeid), null, null, new FilterInfo());
            String id = null;
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    id = iRowSet.getString("FPersonID");
                    set.add(id);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    private List personItemIdList(Context ctx, List perItemList, List allSelectItem) throws BOSException, EmpCmpSchmFacadeException {
        if (perItemList == null || perItemList.size() == 0) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        SqlSelectItem selectItem = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < allSelectItem.size(); ++i) {
            selectItem = (SqlSelectItem)allSelectItem.get(i);
            map.put(selectItem.alias.replaceAll("\"", ""), selectItem.toString());
        }
        String itemNumber = null;
        for (int i = 0; i < perItemList.size(); ++i) {
            itemNumber = perItemList.get(i).toString();
            if (map.containsKey(itemNumber + ".ID")) {
                resultList.add(itemNumber + ".ID");
                continue;
            }
            resultList.add(itemNumber);
        }
        allSelectItem.clear();
        return resultList;
    }

    private Map getFixedItemValue(Context ctx, List perItemList, String personId) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        EntityViewInfo evi;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FPERSONID", (Object)personId));
        view.setFilter(filter);
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        try {
            evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(metaDataPK.toString()), view);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        exec.setObjectView(evi);
        String sql = exec.getSQL();
        if (sql.indexOf("ORDER") > 0) {
            sql = sql.substring(0, sql.indexOf("ORDER"));
        }
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        List perItemIdList = this.personItemIdList(ctx, perItemList, select.selectList);
        HashMap<String, String> mapPersonValue = new HashMap<String, String>();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String strNumber = null;
        try {
            while (iRowSet.next()) {
                int size = perItemIdList.size();
                for (int i = 0; i < size; ++i) {
                    strNumber = perItemIdList.get(i).toString();
                    if (strNumber.equalsIgnoreCase("FPER003") || strNumber.equalsIgnoreCase("FPER004") || strNumber.equalsIgnoreCase("FPER005")) {
                        mapPersonValue.put(strNumber, iRowSet.getString("ATTACHDEPT.ID"));
                        continue;
                    }
                    if (strNumber.equalsIgnoreCase("FPER001") || strNumber.equalsIgnoreCase("FPER002")) {
                        mapPersonValue.put(strNumber, iRowSet.getString("FPERSONID"));
                        continue;
                    }
                    if (strNumber.endsWith(".ID")) {
                        mapPersonValue.put(strNumber.substring(0, strNumber.length() - 3), iRowSet.getString(strNumber));
                        continue;
                    }
                    mapPersonValue.put(strNumber, iRowSet.getString(strNumber));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return mapPersonValue;
    }

    @Override
    protected IRowSet _getEmpSalPointSalGradeData(Context ctx, String salariatSchemeID, String personID, String salPointSalGradeID, boolean isFromReport) throws BOSException, EASBizException {
        Object[] objIDs;
        if (salariatSchemeID == null || salPointSalGradeID == null) {
            return null;
        }
        List<String> empSeqList = new ArrayList<String>();
        if (personID != null) {
            empSeqList.add(personID);
            try {
                empSeqList = this.getEmpSeqList(ctx, salPointSalGradeID, empSeqList);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new SQLDataException(e);
            }
        }
        Map map = null;
        if (empSeqList.size() > 0) {
            map = this._getEmpSalariatPointRange(ctx, salariatSchemeID, personID, salPointSalGradeID);
        }
        CmpSystemConfigCollection cmpSysConfigCol = new CmpSystemConfigCollection();
        String strCurHrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        if (strCurHrOrgUnitId != null) {
            String oql = "select isShowNoneOfSalaryPoint where hrOrgUnit.id = '" + strCurHrOrgUnitId + "'";
            cmpSysConfigCol = CmpSystemConfigFactory.getLocalInstance((Context)ctx).getCmpSystemConfigCollection(oql);
        }
        if (!isFromReport && cmpSysConfigCol.size() > 0 && cmpSysConfigCol.get(0).isIsShowNoneOfSalaryPoint() && (map == null || map.size() <= 0)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (map != null && !map.isEmpty() && (objIDs = map.keySet().toArray()) != null) {
            int size = objIDs.length;
            for (int i = 0; i < size; ++i) {
                if (objIDs[i] == null) continue;
                list.add(objIDs[i].toString());
            }
        }
        String salTableName = this.getPointTableName(ctx, salariatSchemeID);
        String querySQL = null;
        if (list.size() > 0) {
            String salPointIds = CompUtils.getStrFromList(list);
            querySQL = " select * from " + salTableName + " where FSalPointSalGradeID ='" + salPointSalGradeID + "' and FPointID in " + salPointIds;
        } else {
            querySQL = " select * from " + salTableName + " where FSalPointSalGradeID ='" + salPointSalGradeID + "'";
        }
        return DbUtil.executeQuery((Context)ctx, (String)querySQL);
    }

    protected String getPointTableName(Context ctx, String salariatSchemeID) throws EASBizException, BOSException {
        String PointTableName = "";
        String sql = " SELECT fpointtablename FROM T_HR_SALARIATSCH WHERE FID=? ";
        Object[] param = new Object[]{salariatSchemeID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                PointTableName = iRowSet.getString("fpointtablename");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return PointTableName;
    }

    @Override
    protected Map _getEmpSalPointSalGradeData1(Context ctx, String salariatSchemeID, List empSeqList) throws BOSException, EASBizException {
        ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)salariatSchemeID));
        SalariatSchemeInfo salariatSchemeInfo = (SalariatSchemeInfo)SalariatSchemeFactory.getLocalInstance(ctx).getValue((IObjectPK)schemePK);
        String isUpgradeSql = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + salariatSchemeInfo.getPointTableName() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)isUpgradeSql);
        if (rs.size() == 0) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.SALPOINTGRADE);
        }
        StringBuffer sql = new StringBuffer("select id,number,name where salariatscheme ='" + salariatSchemeID + "'");
        String adminSql = HRSchemeUtils.getAdminByUserRange(ctx);
        sql.append(" and enable = 1 ");
        sql.append("and id in (select fsalpointsalgradeid from T_HR_SalPointSalGradeAminOrg where fadminorgid in(" + adminSql + "));");
        SalariatPointSalariatGradeCollection coll = SalariatPointSalariatGradeFactory.getLocalInstance(ctx).getSalariatPointSalariatGradeCollection(sql.toString());
        SalariatPointSalariatGradeInfo info = null;
        HashMap empsSalariat = new HashMap();
        HashMap empHaveIds = new HashMap();
        Map empSalariat = null;
        HashMap<String, Map> empSalariatResult = new HashMap<String, Map>();
        List personIds = null;
        Map.Entry entry2 = null;
        TempTablePool pool = null;
        String tmpTable = null;
        if (coll.size() > 0 && empSeqList.size() > 500) {
            tmpTable = this.createIdTmpTable(ctx, pool, empSeqList);
            ctx.put((Object)"tmpTableForSal", (Object)tmpTable);
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info != null) {
                try {
                    try {
                        personIds = this.getEmpSeqList(ctx, info.getId().toString(), empSeqList);
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (ParserException e) {
                    throw new BOSException((Throwable)e);
                }
                if (personIds.size() == 0) continue;
                empSalariat = this._getEmpSalariatPoint(ctx, null, salariatSchemeID, personIds, info.getId().toString());
                if (empSalariat != null) {
                    for (Map.Entry entry2 : empSalariat.entrySet()) {
                        if (empsSalariat.containsKey(entry2.getKey())) {
                            empHaveIds.put(entry2.getKey(), entry2.getKey());
                            continue;
                        }
                        empsSalariat.put(entry2.getKey(), entry2.getValue());
                    }
                    empSalariat.put(info.getId().toString(), this.getPointValueMap(ctx, salariatSchemeInfo, info.getId().toString()));
                    empSalariatResult.put(info.getId().toString(), empSalariat);
                }
            }
            empSalariatResult.put("empHaveIds", empHaveIds);
        }
        if (tmpTable != null) {
            HRReportUtils.releaseTmpTable(ctx, tmpTable);
        }
        return empSalariatResult;
    }

    private List getEmpSeqList(Context ctx, String salPointSalGradeID, List empSeqList) throws BOSException, EASBizException, ParserException, SQLException {
        ArrayList<String> personids = new ArrayList<String>();
        if (!SalariatRangeFactory.getLocalInstance(ctx).exists("where salPointSalGrade = '" + salPointSalGradeID + "'")) {
            return null;
        }
        SalariatRangeInfo info = SalariatRangeFactory.getLocalInstance(ctx).getSalariatRangeInfo("select id,personRange where salPointSalGrade = '" + salPointSalGradeID + "'");
        String filterString = info.getPersonRange();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String adminOrgIds = "select FAdminOrgID from T_HR_SalariatRangeEntry where FSalariatRangeID in (select fid from T_HR_SalariatRange where FSalPointSalGradeID ='" + salPointSalGradeID + "' )";
        filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgIds, CompareType.INNER));
        String tmpTable = null;
        if (empSeqList.size() > 500 && ctx.get((Object)"tmpTableForSal") != null) {
            tmpTable = (String)ctx.get((Object)"tmpTableForSal");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)("select FID from " + tmpTable), CompareType.INNER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(empSeqList), CompareType.INCLUDE));
        }
        view.setFilter(filterInfo);
        if (filterString != null) {
            FilterInfo filterInfo1 = new FilterInfo(filterString);
            view.getFilter().mergeFilter(filterInfo1, "and");
        }
        IRowSet rowSetPerson = null;
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app", "PersonFilterQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        if (view != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            queryExec.setObjectView(view);
            rowSetPerson = queryExec.executeQuery();
            while (rowSetPerson.next()) {
                personids.add(rowSetPerson.getString("id"));
            }
        }
        return personids;
    }

    private Map getPointValueMap(Context ctx, SalariatSchemeInfo salariatSchemeInfo, String salariatPointSalariatGradeId) throws BOSException, EASBizException {
        CmpItemCollection cmpItems;
        HashMap pointMap = new HashMap();
        if (salariatSchemeInfo == null) {
            return pointMap;
        }
        if (!StateEnum.ENABLE.equals((Object)salariatSchemeInfo.getState())) {
            // empty if block
        }
        BigDecimal stand = new BigDecimal("1.0");
        if (salariatSchemeInfo.isFlagStandardBase()) {
            stand = new BigDecimal(salariatSchemeInfo.getStandardBase());
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<IntEnum> columnTypes = new ArrayList<IntEnum>();
        ArrayList<Integer> columnPer = new ArrayList<Integer>();
        columnNames.add("FPointID");
        columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        columnPer.add(null);
        try {
            cmpItems = this.getCmpItemsByScheme(ctx, salariatSchemeInfo.getId().toString());
        }
        catch (Exception e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        int size = cmpItems.size();
        for (int i = 0; i < size; ++i) {
            columnNames.add(cmpItems.get(i).getNumber());
            columnTypes.add(cmpItems.get(i).getDataType());
            columnPer.add(cmpItems.get(i).getDecDigital());
        }
        String querySQL = " select * from " + salariatSchemeInfo.getPointTableName() + " where FSalPointSalGradeID ='" + salariatPointSalariatGradeId + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)querySQL);
        IRowSet rowSet = exec.executeSQL();
        try {
            while (rowSet.next()) {
                String pointID = rowSet.getString("FPointID");
                HashMap<String, Object> pointValueMap = new HashMap<String, Object>();
                for (int i = 1; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    Object columnType = columnTypes.get(i);
                    if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                        String strValue = rowSet.getString(columnName);
                        pointValueMap.put(columnName, strValue);
                        continue;
                    }
                    if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                        BigDecimal value = rowSet.getBigDecimal(columnName);
                        if (value != null) {
                            if (columnPer.get(i) != null) {
                                pointValueMap.put(columnName, value.multiply(stand).setScale((int)((Integer)columnPer.get(i)), 4));
                                continue;
                            }
                            pointValueMap.put(columnName, value.multiply(stand).setScale(2, 4));
                            continue;
                        }
                        pointValueMap.put(columnName, null);
                        continue;
                    }
                    if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                    int intValue = rowSet.getInt(columnName);
                    pointValueMap.put(columnName, intValue);
                }
                pointMap.put(pointID, pointValueMap);
            }
        }
        catch (Exception e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        return pointMap;
    }

    private CmpItemCollection getCmpItemsByScheme(Context ctx, String schemeID) throws Exception {
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpItemsQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        entityView.setFilter(filterInfoItem);
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        Object cmpItem = null;
        while (selectItemRowSet.next()) {
            items.add(this.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    private CmpItemInfo getItemInfo(IRowSet selectItemRowSet) throws Exception {
        CmpItemInfo cmpItem = new CmpItemInfo();
        cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("item.id")));
        cmpItem.setNumber(selectItemRowSet.getString("item.number"));
        cmpItem.setName(selectItemRowSet.getString("item.name"));
        cmpItem.setEnable(StateEnum.getEnum(selectItemRowSet.getInt("item.enable")));
        cmpItem.setLength(selectItemRowSet.getInt("item.length"));
        cmpItem.setDecDigital(selectItemRowSet.getInt("item.decDigital"));
        cmpItem.setItemValue(selectItemRowSet.getString("item.itemValue"));
        cmpItem.setDefaultOrder(selectItemRowSet.getInt("item.defaultOrder"));
        cmpItem.setType(ItemTypeEnum.getEnum(selectItemRowSet.getInt("item.type")));
        cmpItem.setDataType(ItemDataTypeEnum.getEnum(selectItemRowSet.getInt("item.dataType")));
        cmpItem.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(selectItemRowSet.getInt("item.precisionType")));
        cmpItem.setSubject(ItemSubjectEnum.getEnum(selectItemRowSet.getInt("item.subject")));
        cmpItem.setUsed(ItemUsedEnum.getEnum(selectItemRowSet.getInt("item.used")));
        return cmpItem;
    }
}

