/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpReportFacade;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.MyCmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.app.AbstractMyCmpReportFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MyCmpReportFacadeControllerBean
extends AbstractMyCmpReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.MyCmpReportFacadeControllerBean");

    @Override
    protected HashMap _getAllItemsByScheme(Context ctx, List lstSchemeIds) throws BOSException, EASBizException {
        if (lstSchemeIds == null || lstSchemeIds.size() <= 0) {
            return null;
        }
        int iSchemeSize = lstSchemeIds.size();
        StringBuffer strSchemeIds = new StringBuffer();
        for (int i = 0; i < iSchemeSize; ++i) {
            if (i > 0) {
                strSchemeIds.append(",");
            }
            strSchemeIds.append("'").append(lstSchemeIds.get(i)).append("'");
        }
        HashMap allMap = new HashMap();
        ArrayList<CmpItemInfo> lstPublic = new ArrayList<CmpItemInfo>();
        CmpItemInfo itemInfo = null;
        String language = ctx.getLocale().getLanguage();
        if (iSchemeSize > 1) {
            StringBuffer sqlPublic = new StringBuffer();
            sqlPublic.append("select T2.fnumber as itemNumber,T2.fname_").append(language).append(" as itemName,T2.FDecDigital,T2.FDataType,T2.FPrecisionType,");
            sqlPublic.append(" count(T1.FCmpSchemeID) as schemeCount ");
            sqlPublic.append(" from T_HR_CMPSCHEMEITEM T1");
            sqlPublic.append(" inner join t_hr_cmpitem T2 on T2.fid = T1.FCmpItemID");
            sqlPublic.append(" inner join t_hr_cmpscheme T3 on T3.fid = T1.FCmpSchemeID");
            sqlPublic.append(" where T1.FCmpSchemeID in (" + strSchemeIds.toString() + ") and T1.FIsDelete = 0");
            sqlPublic.append(" and T1.FIsVisible = 1 and T1.FIsCollect = 1");
            sqlPublic.append(" and T2.FNumber <> 'FSAL000'");
            sqlPublic.append(" and T2.FDatatype != 10 ");
            sqlPublic.append(" group by T2.fnumber,T2.fname_").append(language).append(",T2.FDecDigital,T2.FDataType,T2.FPrecisionType");
            sqlPublic.append(" order by T2.fnumber,T2.FDecDigital desc");
            IRowSet rsPublic = DbUtil.executeQuery((Context)ctx, (String)sqlPublic.toString());
            try {
                HashMap<String, Integer> decDigitalMap = new HashMap<String, Integer>();
                String number = null;
                while (rsPublic.next()) {
                    number = rsPublic.getString("itemNumber");
                    if (decDigitalMap.containsKey(number)) continue;
                    decDigitalMap.put(number, rsPublic.getInt("FDecDigital"));
                    itemInfo = new CmpItemInfo();
                    itemInfo.setName(rsPublic.getString("itemName"));
                    itemInfo.setNumber(rsPublic.getString("itemNumber"));
                    itemInfo.setDecDigital(rsPublic.getInt("FDecDigital"));
                    itemInfo.setDataType(ItemDataTypeEnum.getEnum(rsPublic.getInt("FDataType")));
                    itemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(rsPublic.getInt("FPrecisionType")));
                    lstPublic.add(itemInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rsPublic);
            }
        }
        allMap.put("publicItem", lstPublic);
        StringBuffer sqlPrivate = new StringBuffer();
        sqlPrivate.append("select T2.fnumber as itemNumber,T2.fname_").append(language).append(" as itemName,T2.FDecDigital,T2.FDataType,T2.FPrecisionType,");
        sqlPrivate.append(" T1.FCmpSchemeID as schemeId,T3.fname_").append(language).append(" as schemeName ");
        sqlPrivate.append(" From T_HR_CMPSCHEMEITEM T1");
        sqlPrivate.append(" inner join t_hr_cmpitem T2 on T2.fid = T1.FCmpItemID");
        sqlPrivate.append(" inner join t_hr_cmpscheme T3 on T3.fid = T1.FCmpSchemeID");
        sqlPrivate.append(" where T1.FCmpSchemeID in (" + strSchemeIds + ") and T1.FIsDelete = 0");
        sqlPrivate.append(" and T1.FIsVisible = 1 ");
        if (iSchemeSize > 1) {
            sqlPrivate.append(" and ( T1.FIsCollect = 0 or T1.FIsCollect is null) ");
        }
        sqlPrivate.append(" and T2.FNumber not like '%FPER%'");
        sqlPrivate.append(" and T2.FNumber<> 'FSAL000'");
        sqlPrivate.append(" and T2.FDatatype != 10 ");
        sqlPrivate.append(" order by T1.FSortOrder");
        String strSchemeId = null;
        IRowSet rsPrivate = DbUtil.executeQuery((Context)ctx, (String)sqlPrivate.toString());
        try {
            while (rsPrivate.next()) {
                List<CmpItemInfo> lstPrivate = new ArrayList();
                strSchemeId = rsPrivate.getString("schemeId");
                if (allMap.get(strSchemeId) == null) {
                    allMap.put(strSchemeId, lstPrivate);
                }
                lstPrivate = (List)allMap.get(strSchemeId);
                itemInfo = new CmpItemInfo();
                itemInfo.setName(rsPrivate.getString("itemName"));
                itemInfo.setNumber(rsPrivate.getString("itemNumber"));
                itemInfo.setDecDigital(rsPrivate.getInt("FDecDigital"));
                itemInfo.setDataType(ItemDataTypeEnum.getEnum(rsPrivate.getInt("FDataType")));
                itemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(rsPrivate.getInt("FPrecisionType")));
                itemInfo.setCmpSchemeName(rsPrivate.getString("schemeName"));
                lstPrivate.add(itemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsPrivate);
        }
        ArrayList<CmpItemInfo> lstPerson = new ArrayList<CmpItemInfo>();
        StringBuffer sqlPerson = new StringBuffer();
        sqlPerson.append("select distinct T2.fnumber as itemNumber,T2.fname_").append(language).append(" as itemName,T2.FDataType, T2.FDEFAULTORDER,T2.fsubject,").append(" T2.FHROrgUnitID ").append(" ,T2.FDecDigital,T2.FPrecisionType ");
        sqlPerson.append(" From T_HR_CMPSCHEMEITEM T1");
        sqlPerson.append(" inner join t_hr_cmpitem T2 on T2.fid = T1.FCmpItemID");
        sqlPerson.append(" inner join t_hr_cmpscheme T3 on T3.fid = T1.FCmpSchemeID");
        sqlPerson.append(" inner join T_HR_CMPITEMCAT T4 on t4.fid = T2.FCmpItemCatalogID");
        sqlPerson.append(" where T1.FCmpSchemeID in (" + strSchemeIds + ") and T1.FIsDelete = 0");
        sqlPerson.append(" and T1.FIsVisible = 1");
        sqlPerson.append(" and T4.FNumber = 'FPER'");
        sqlPerson.append(" order by T2.FDEFAULTORDER ");
        IRowSet rsPerson = DbUtil.executeQuery((Context)ctx, (String)sqlPerson.toString());
        try {
            while (rsPerson.next()) {
                itemInfo = new CmpItemInfo();
                itemInfo.setName(rsPerson.getString("itemName"));
                itemInfo.setNumber(rsPerson.getString("itemNumber"));
                itemInfo.setDataType(ItemDataTypeEnum.getEnum(rsPerson.getInt("FDataType")));
                itemInfo.setSubject(ItemSubjectEnum.getEnum(rsPerson.getInt("fsubject")));
                itemInfo.setDecDigital(rsPerson.getInt("FDecDigital"));
                itemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(rsPerson.getInt("FPrecisionType")));
                HROrgUnitInfo unitInfo = new HROrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rsPerson.getString("FHROrgUnitID")));
                itemInfo.setHrOrgUnit(unitInfo);
                lstPerson.add(itemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsPrivate);
        }
        allMap.put("PersonItem", lstPerson);
        return allMap;
    }

    @Override
    protected Map _getMySummaryReportData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        List lstCmpSchemeInfo = null;
        HashMap mapAllSchemeItems = null;
        List lstAllSchemePerItems = null;
        HashMap mapAllDynamicTableNames = null;
        ICmpReportFacade iCmpReportFacade = null;
        CmpPeriodCollection colCmpPeriod = null;
        HROrgUnitInfo org = null;
        org = ContextUtil.getCurrentHRUnit((Context)ctx);
        Date beginDate = ((CmpPeriodInfo)paramMap.get("beginPeriond")).getBeginDate();
        Date endDate = ((CmpPeriodInfo)paramMap.get("endPeriond")).getEndDate();
        try {
            colCmpPeriod = this.getCmpPeriodCollection(ctx, (CmpPeriodInfo)paramMap.get("beginPeriond"), (CmpPeriodInfo)paramMap.get("endPeriond"), org);
            lstCmpSchemeInfo = this.getInfoCmpSchemeList(ctx, beginDate, endDate);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (iCmpReportFacade == null) {
            iCmpReportFacade = CmpReportFacadeFactory.getLocalInstance(ctx);
        }
        Map mapParam = paramMap;
        ArrayList<String> personId = new ArrayList<String>();
        personId.add(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
        AdminOrgUnitCollection orgCol = null;
        try {
            orgCol = this.getAdminOrgUnitCollection(ctx);
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        mapParam.put("CmpSchemeInfos", lstCmpSchemeInfo);
        mapParam.put("FPERIOD", colCmpPeriod);
        mapParam.put("isContainChildren", false);
        mapParam.put("isNeedAduitOfScheme", true);
        mapParam.put("IsFormMyCmpReportUI", Boolean.TRUE);
        mapAllDynamicTableNames = iCmpReportFacade.getAllSchemeTablesName(lstCmpSchemeInfo, colCmpPeriod, mapParam);
        Iterator itrDynamicTable = mapAllDynamicTableNames.entrySet().iterator();
        ArrayList listDynamicTable = new ArrayList();
        Map.Entry entry = null;
        while (itrDynamicTable.hasNext()) {
            Map tableMap;
            entry = itrDynamicTable.next();
            Object itrKey = entry.getKey();
            if ("AllTables".equals(itrKey) || "tableNameSchemeIDVal".equals(itrKey) || (tableMap = (Map)entry.getValue()).size() != 0) continue;
            listDynamicTable.add(itrKey);
        }
        block5: for (int i = 0; i < listDynamicTable.size(); ++i) {
            Object dynamicKey = listDynamicTable.get(i);
            mapAllDynamicTableNames.remove(dynamicKey);
            int schemeSize = lstCmpSchemeInfo.size();
            for (int j = 0; j < schemeSize; ++j) {
                CmpSchemeInfo cmpSch = (CmpSchemeInfo)lstCmpSchemeInfo.get(j);
                if (!cmpSch.getId().toString().equals(dynamicKey)) continue;
                lstCmpSchemeInfo.remove(cmpSch);
                continue block5;
            }
        }
        if (mapParam.get("CmpSchemeInfos") != null) {
            mapParam.remove("CmpSchemeInfos");
        }
        mapParam.put("CmpSchemeInfos", lstCmpSchemeInfo);
        if (lstCmpSchemeInfo.size() <= 0) {
            return null;
        }
        mapAllSchemeItems = this.getAllSchemeItems(ctx, beginDate, endDate, lstCmpSchemeInfo);
        lstAllSchemePerItems = this.getAllSchemePerItems(ctx, beginDate, endDate, lstCmpSchemeInfo);
        mapParam.put("MapAllSchemeItems", mapAllSchemeItems);
        mapParam.put("LstAllSchemePerItems", lstAllSchemePerItems);
        mapParam.put("AllDynamicTableNames", mapAllDynamicTableNames);
        List lstInitKeys = iCmpReportFacade.getEmployeeSummaryReportKey((HashMap)mapParam);
        ArrayList lstKeys = new ArrayList();
        String pId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        int size = lstInitKeys.size();
        for (int i = 0; i < size; ++i) {
            String[] arr = lstInitKeys.get(i).toString().split("~");
            if (!arr[0].equals(pId)) continue;
            lstKeys.add(lstInitKeys.get(i));
        }
        mapParam.put("KEYIDS", lstKeys);
        Map mapData = iCmpReportFacade.getEmployeeSummaryReportData(mapParam);
        HashMap<String, Map> mapCollection = new HashMap<String, Map>();
        mapCollection.put("mapParam", mapParam);
        mapCollection.put("mapData", mapData);
        return mapCollection;
    }

    public AdminOrgUnitCollection getAdminOrgUnitCollection(Context ctx) throws BOSException, SQLException {
        AdminOrgUnitCollection adminOrgCol = new AdminOrgUnitCollection();
        String language = ctx.getLocale().getLanguage();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sql = "SELECT FId, FName_" + language + ", FNumber FROM T_ORG_Admin WHERE FId IN (SELECT FAdminOrgUnitId FROM T_HR_CmpSchemePerson csp WHERE FPersonId = '" + personId + "')";
        IRowSet rs = null;
        ISQLExecutor exector = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        rs = exector.executeSQL();
        while (rs.next()) {
            AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
            admin.setId(BOSUuid.read((String)rs.getString(1)));
            admin.setName(rs.getString(2));
            admin.setNumber(rs.getString(3));
            adminOrgCol.add(admin);
        }
        return adminOrgCol;
    }

    private CmpPeriodCollection getCmpPeriodCollection(Context ctx, CmpPeriodInfo cmpBeginPeriod, CmpPeriodInfo cmpEndPeriod, HROrgUnitInfo org) throws Exception {
        CmpPeriodCollection col = null;
        Date beginDate = cmpBeginPeriod.getBeginDate();
        Date endDate = cmpEndPeriod.getEndDate();
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)org.getId().toString()));
        infoFilter.setMaskString("#0 and #1 and #2");
        evi.setFilter(infoFilter);
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        return col;
    }

    private List getCmpSchemeByUserId(Context ctx, Date beginDate, Date endDate) throws BOSException, SQLException {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        GregorianCalendar beginCal = new GregorianCalendar();
        beginCal.setTime(beginDate);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endDate);
        SimpleDateFormat sdf = new SimpleDateFormat("{yyyy-MM-dd HH:mm:ss}");
        String beginDateStr = sdf.format(beginCal.getTime());
        String language = ctx.getLocale().getLanguage();
        String sql = "SELECT cmpScheme.fid,cmpScheme.FName_" + language + ",cmpScheme.FNumber from T_HR_CmpScheme cmpScheme inner join t_hr_cmpperiod cp on cmpScheme.fcmpperiod = cp.fid inner join t_hr_cmpschemeitem item on item.fcmpschemeid = cmpScheme.fid WHERE cmpScheme.FId IN (SELECT FCmpSchemeID FROM T_HR_CmpSchemePerson WHERE FPersonId = '" + personId + "') and cp.fbegindate >= " + beginDateStr + "and item.fisvisible = 1 group by cmpScheme.fid,cmpScheme.FName_" + language + ", cmpScheme.FNumber having count(item.fid)>=1";
        IRowSet rs = null;
        ISQLExecutor exector = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        rs = exector.executeSQL();
        ArrayList<CmpSchemeInfo> cmpList = new ArrayList<CmpSchemeInfo>();
        while (rs.next()) {
            CmpSchemeInfo schemeInfo = new CmpSchemeInfo();
            schemeInfo.setId(BOSUuid.read((String)rs.getString(1)));
            schemeInfo.setName(rs.getString(2));
            schemeInfo.setNumber(rs.getString(3));
            cmpList.add(schemeInfo);
        }
        return cmpList;
    }

    public List getInfoCmpSchemeList(Context ctx, Date beginDate, Date endDate) throws BOSException, SQLException {
        List cmpList = this.getCmpSchemeByUserId(ctx, beginDate, endDate);
        return cmpList;
    }

    public List getAllSchemePerItems(Context ctx, Date beginDate, Date endDate, List getInfoCmpSchemeList) throws BOSException, EASBizException {
        List cmpList = getInfoCmpSchemeList;
        if (cmpList.size() < 0) {
            return new ArrayList();
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = cmpList.size();
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(((CmpSchemeInfo)cmpList.get(i)).getId().toString());
        }
        List lst = new ArrayList();
        lst = MyCmpReportFacadeFactory.getLocalInstance(ctx).getAllPerItemsBySchemes(lstSchemeIds);
        return lst;
    }

    public HashMap getAllSchemeItems(Context ctx, Date beginDate, Date endDate, List getInfoCmpSchemeList) throws BOSException, EASBizException {
        HashMap allMap = new HashMap();
        List cmpList = getInfoCmpSchemeList;
        if (cmpList.size() < 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = cmpList.size();
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(((CmpSchemeInfo)cmpList.get(i)).getId().toString());
        }
        allMap = MyCmpReportFacadeFactory.getLocalInstance(ctx).getAllItemsByScheme(lstSchemeIds);
        return allMap;
    }

    @Override
    protected List _getAllPerItemsBySchemes(Context ctx, List lstSchemeIds) throws BOSException, EASBizException {
        int iSchemeSize = lstSchemeIds.size();
        StringBuffer strSchemeIds = new StringBuffer();
        for (int i = 0; i < iSchemeSize; ++i) {
            if (i > 0) {
                strSchemeIds.append(",");
            }
            strSchemeIds.append("'").append(lstSchemeIds.get(i)).append("'");
        }
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct T2.fnumber,T2.FName_").append(language).append(",T2.FDataType ");
        sql.append(" from T_HR_CMPSCHEMEITEM T1");
        sql.append(" inner join t_hr_cmpitem T2 on T2.fid = T1.FCmpItemID");
        sql.append(" inner join t_hr_cmpscheme T3 on T3.fid = T1.FCmpSchemeID");
        sql.append(" where T1.FCmpSchemeID in (" + strSchemeIds.toString() + ") and T1.FIsDelete = 0");
        sql.append(" and T1.FIsVisible = 1 ");
        sql.append(" and T2.FNumber like 'FPER%'");
        sql.append(" order by T2.fnumber");
        CmpItemInfo itemInfo = null;
        ArrayList<CmpItemInfo> lstItems = new ArrayList<CmpItemInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                itemInfo = new CmpItemInfo();
                itemInfo.setNumber(rs.getString("fnumber"));
                itemInfo.setName(rs.getString("FName_" + language));
                if (rs.getInt("FDataType") == 0) {
                    itemInfo.setDataType(ItemDataTypeEnum.STRING);
                } else {
                    itemInfo.setDataType(ItemDataTypeEnum.getEnum(rs.getInt("FDataType")));
                }
                lstItems.add(itemInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return lstItems;
    }
}

