/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.compensation.SalariatPointSalariatGradeInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.app.AbstractSalariatPointSalariatGradeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class SalariatPointSalariatGradeControllerBean
extends AbstractSalariatPointSalariatGradeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.SalariatPointSalariatGradeControllerBean");
    private static final String SHARE_TYPE_NAME = "controlType";
    private String controlType = null;

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (IObjectValue)model);
        this.checkNameDup(ctx, (IObjectValue)model);
        SalariatPointSalariatGradeInfo salPointSalGrade = (SalariatPointSalariatGradeInfo)model;
        String pointTableName = (String)salPointSalGrade.get("PointTableName");
        List columnNames = (List)salPointSalGrade.get("columnNames");
        List columnTypes = (List)salPointSalGrade.get("columnTypes");
        List valueMapList = (List)salPointSalGrade.get("valueMapList");
        String salariatSchemeID = (String)salPointSalGrade.get("salariatSchemeID");
        String gradeTableName = (String)salPointSalGrade.get("GradeTableName");
        List pointColumnNames = (List)salPointSalGrade.get("pointColumnNames");
        List valueMapListGrade = (List)salPointSalGrade.get("valueMapListGrade");
        IObjectPK retValue = super.submit(ctx, model);
        SalariatSchemeFacadeFactory.getLocalInstance(ctx).saveListPointData(pointTableName, columnNames, columnTypes, valueMapList, retValue.toString());
        SalariatSchemeFacadeFactory.getLocalInstance(ctx).saveListGradeData(salariatSchemeID, gradeTableName, pointColumnNames, valueMapListGrade, retValue.toString());
        return retValue;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        SalariatPointSalariatGradeInfo dataBaseInfo = (SalariatPointSalariatGradeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filterItem = new FilterItemInfo("salariatScheme", (Object)dataBaseInfo.getSalariatScheme().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (this.getControlType(ctx, dataBaseInfo).equals("") && FilterUtility.hasFilterItem((FilterInfo)(filterCU = this.getFilterForDefaultCU(ctx, model)))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private String getControlType(Context ctx, DataBaseInfo info) throws BOSException {
        if (this.controlType != null) {
            return this.controlType;
        }
        this.controlType = "";
        EntityObjectInfo eoi = this.getBOSEntity(ctx, (CoreBaseInfo)info);
        boolean hasShareType = false;
        hasShareType = eoi.containsExtendedPropertyKey(SHARE_TYPE_NAME);
        if (hasShareType) {
            this.controlType = eoi.getExtendedProperty(SHARE_TYPE_NAME);
        } else if (eoi.getBaseEntity().getName().equals("DataBaseD")) {
            this.controlType = "D";
        }
        return this.controlType;
    }

    private void checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        SalariatPointSalariatGradeInfo dataBaseInfo = (SalariatPointSalariatGradeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filterItem = new FilterItemInfo("salariatScheme", (Object)dataBaseInfo.getSalariatScheme().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (this.getControlType(ctx, dataBaseInfo).equals("") && FilterUtility.hasFilterItem((FilterInfo)(filterCU = this.getFilterForDefaultCU(ctx, model)))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String deleteSQL = "delete from T_HR_SalariatRangeEntry where FSalariatRangeID in (select fid from T_HR_SalariatRange where FSalPointSalGradeID='" + pk.toString() + "')";
        String deleteSQL2 = "delete from T_HR_SalariatRange where FsalPointSalGradeID ='" + pk.toString() + "'";
        String pointTableName = this.getPointTableName(ctx, pk);
        String pointGradeTableName = this.getPointGradeTableName(ctx, pk);
        String deleteSQL3 = "delete from " + pointTableName + " where FsalPointSalGradeID ='" + pk.toString() + "'";
        String deleteSQL4 = "delete from " + pointGradeTableName + " where FsalPointSalGradeID ='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        DbUtil.execute((Context)ctx, (String)deleteSQL2);
        DbUtil.execute((Context)ctx, (String)deleteSQL3);
        DbUtil.execute((Context)ctx, (String)deleteSQL4);
        super.delete(ctx, pk);
    }

    protected String getPointTableName(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String pointTableName = null;
        String sql = " SELECT fpointtablename FROM T_HR_SALARIATSCH WHERE fid = (select FSalariatSchemeID from  T_HR_SalariatPointSalariaGrade where fid = '" + pk.toString() + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                pointTableName = rs.getString("fpointtablename");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pointTableName;
    }

    protected String getPointGradeTableName(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String pointGradeTableName = null;
        String sql = " SELECT FGradeTableName FROM T_HR_SALARIATSCH WHERE fid = (select FSalariatSchemeID from  T_HR_SalariatPointSalariaGrade where fid = '" + pk.toString() + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                pointGradeTableName = rs.getString("FGradeTableName");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pointGradeTableName;
    }
}

