/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.util.HRMulUtil;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpTemplateCollection;
import com.kingdee.eas.hr.compensation.CmpTemplateFactory;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpTemplate;
import com.kingdee.eas.hr.compensation.IFixedCmpScheme;
import com.kingdee.eas.hr.compensation.ISalaraitCmpItemProps;
import com.kingdee.eas.hr.compensation.ISalaraitCmpPersonItemProps;
import com.kingdee.eas.hr.compensation.ISalariatCurrencyProps;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.ISalariatPointProps;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.SalaraitCmpItemPropsCollection;
import com.kingdee.eas.hr.compensation.SalaraitCmpItemPropsFactory;
import com.kingdee.eas.hr.compensation.SalaraitCmpItemPropsInfo;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsCollection;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsFactory;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatCurrencyPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemFactory;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatPointPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractSalariatSchemeControllerBean;
import com.kingdee.eas.hr.compensation.app.AdapterDynamicDBTable;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.ToolsTableMetas;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class SalariatSchemeControllerBean
extends AbstractSalariatSchemeControllerBean {
    @Override
    protected boolean _existNumber(Context ctx, String number) throws BOSException, EASBizException {
        boolean exist = false;
        Connection cn = this.getConnection(ctx);
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        try {
            psStmt = cn.prepareStatement("SELECT * FROM T_HR_SALARIATSCH where FNumber=? ");
            psStmt.setString(1, number);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return exist;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)model;
        schemeInfo.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        IObjectPK schemePK = super._addnew(ctx, (IObjectValue)schemeInfo);
        schemeInfo.put("id", schemePK.getKeyValue("id"));
        this._modifyPropsInternal(ctx, schemeInfo);
        return schemePK;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)model;
        super._update(ctx, pk, (IObjectValue)schemeInfo);
        this._modifyPropsInternal(ctx, schemeInfo);
    }

    @Override
    protected void _updateState(Context ctx, IObjectPK pk, SalariatSchemeInfo model) throws BOSException, EASBizException {
        super._update(ctx, pk, (IObjectValue)model);
    }

    private void updateSalariatGradeTable(Context ctx, SalariatSchemeInfo schemeInfo) throws BOSException, EASBizException {
        String gradeTableName = schemeInfo.getGradeTableName();
        if (StringUtils.isEmpty((String)gradeTableName)) {
            return;
        }
        SalaraitCmpPersonItemPropsCollection personItemsCollection = schemeInfo.getPersonItemsCollection();
        CmpItemInfo cmpItemInfo = null;
        ArrayList<String> itemNumbers = new ArrayList<String>();
        for (int i = 0; i < personItemsCollection.size(); ++i) {
            cmpItemInfo = personItemsCollection.get(i).getItem();
            itemNumbers.add(cmpItemInfo.getNumber());
            HRTableTools.addDynColumn(ctx, cmpItemInfo, gradeTableName);
        }
        ArrayList columnNames = HRTableTools.getTableColumnNames(ctx, gradeTableName);
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            if (columnNames.get(i).toString().equalsIgnoreCase("FPERSONMAPID") || columnNames.get(i).toString().toUpperCase().indexOf("FPOINTID") == 0 || "FSALPOINTSALGRADEID".equals(columnNames.get(i).toString().toUpperCase()) || itemNumbers.contains(columnNames.get(i).toString())) continue;
            DbUtil.execute((Context)ctx, (String)("UPDATE " + gradeTableName + " SET " + columnNames.get(i).toString() + " = NULL "));
        }
    }

    protected void _modifyPropsInternal(Context ctx, SalariatSchemeInfo schemeInfo) throws BOSException, EASBizException {
        this.updateSalariatGradeTable(ctx, schemeInfo);
        FilterInfo filterSchemeID = new FilterInfo();
        filterSchemeID.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeInfo.getId()));
        ISalaraitCmpPersonItemProps iPerson = SalaraitCmpPersonItemPropsFactory.getLocalInstance(ctx);
        iPerson.delete(filterSchemeID);
        SalaraitCmpPersonItemPropsCollection personItemsCollection = schemeInfo.getPersonItemsCollection();
        for (int i = 0; i < personItemsCollection.size(); ++i) {
            SalaraitCmpPersonItemPropsInfo personInfo = personItemsCollection.get(i);
            personInfo.setScheme(schemeInfo);
            iPerson.addnew(personInfo);
        }
        ISalaraitCmpItemProps iCmpItem = SalaraitCmpItemPropsFactory.getLocalInstance(ctx);
        iCmpItem.delete(filterSchemeID);
        SalaraitCmpItemPropsCollection cmpItemsCollection = schemeInfo.getCmpItemsCollection();
        for (int i = 0; i < cmpItemsCollection.size(); ++i) {
            SalaraitCmpItemPropsInfo cmpItem = cmpItemsCollection.get(i);
            cmpItem.setScheme(schemeInfo);
            iCmpItem.addnew(cmpItem);
        }
        ISalariatCurrencyProps iCurr = SalariatCurrencyPropsFactory.getLocalInstance(ctx);
        iCurr.delete(filterSchemeID);
        SalariatCurrencyPropsCollection currCollection = schemeInfo.getCurrencyCollection();
        for (int i = 0; i < currCollection.size(); ++i) {
            SalariatCurrencyPropsInfo currInfo = currCollection.get(i);
            currInfo.setScheme(schemeInfo);
            iCurr.addnew(currInfo);
        }
        ISalariatHiberProps iHiber = SalariatHiberPropsFactory.getLocalInstance(ctx);
        iHiber.delete(filterSchemeID);
        SalariatHiberPropsCollection hiberCollection = schemeInfo.getHiberCollection();
        for (int i = 0; i < hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo hiberInfo = hiberCollection.get(i);
            hiberInfo.setScheme(schemeInfo);
            hiberInfo.setParent(null);
            IObjectPK hiberPK = iHiber.addnew((CoreBaseInfo)hiberInfo);
            hiberInfo.put("id", hiberPK.getKeyValue("id"));
            SalariatHiberPropsCollection subHiberCollection = hiberInfo.getSubHibersCollection();
            for (int j = 0; j < subHiberCollection.size(); ++j) {
                SalariatHiberPropsInfo subHiberInfo = subHiberCollection.get(j);
                subHiberInfo.setScheme(schemeInfo);
                subHiberInfo.setParent(hiberInfo);
                iHiber.addnew((CoreBaseInfo)subHiberInfo);
            }
        }
        ISalariatPointProps iPoint = SalariatPointPropsFactory.getLocalInstance(ctx);
        iPoint.delete(filterSchemeID);
        SalariatPointPropsCollection pointCollection = schemeInfo.getPointsCollection();
        String salaPointPropTbl = schemeInfo.getGradeTableName();
        for (int i = 0; i < pointCollection.size(); ++i) {
            SalariatPointPropsInfo pointInfo = pointCollection.get(i);
            pointInfo.setScheme(schemeInfo);
            if (pointInfo.getId() == null && !StringUtils.isEmpty((String)salaPointPropTbl)) {
                this.doUpdateTableItem(ctx, pointInfo, schemeInfo);
            }
            iPoint.addnew((CoreBaseInfo)pointInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterSchemeID = new FilterInfo();
        filterSchemeID.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)pk.toString()));
        ISalaraitCmpPersonItemProps iPerson = SalaraitCmpPersonItemPropsFactory.getLocalInstance(ctx);
        iPerson.delete(filterSchemeID);
        ISalaraitCmpItemProps iCmpItem = SalaraitCmpItemPropsFactory.getLocalInstance(ctx);
        iCmpItem.delete(filterSchemeID);
        ISalariatCurrencyProps iCurr = SalariatCurrencyPropsFactory.getLocalInstance(ctx);
        iCurr.delete(filterSchemeID);
        ISalariatHiberProps iHiber = SalariatHiberPropsFactory.getLocalInstance(ctx);
        iHiber.delete(filterSchemeID);
        ISalariatPointProps iPoint = SalariatPointPropsFactory.getLocalInstance(ctx);
        iPoint.delete(filterSchemeID);
        FilterInfo filterMapPerson = new FilterInfo();
        filterMapPerson.getFilterItems().add(new FilterItemInfo("salSchm.id", (Object)pk.toString()));
        SalariatMapPersonItemFactory.getLocalInstance(ctx).delete(filterMapPerson);
        ISalariatScheme iBiz = SalariatSchemeFactory.getLocalInstance(ctx);
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue(pk);
        if (StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
            String pointTableName = schemeInfo.getPointTableName();
            String gradeTableName = schemeInfo.getGradeTableName();
            Statement stmt = null;
            Connection cn = this.getConnection(ctx);
            try {
                String dropPointTableSQL = ToolsTableMetas.dropTable(pointTableName);
                String dropGradeTableSQL = ToolsTableMetas.dropTable(gradeTableName);
                stmt = cn.createStatement();
                stmt.execute(dropPointTableSQL);
                stmt.execute(dropGradeTableSQL);
            }
            catch (Exception exception) {
                SQLUtils.cleanup(null, stmt, (Connection)cn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(null, stmt, (Connection)cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _createDynTable(Context ctx, String createPointSQL, String createGradeSQL) throws BOSException, EASBizException {
        boolean result = false;
        Connection cn = this.getConnection(ctx);
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            result = stmt.execute(createPointSQL);
            result = stmt.execute(createGradeSQL);
            result = true;
        }
        catch (SQLException sqle) {
            throw new SalariatException(SalariatException.ERROR_CREATE_TABLE, sqle);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
        }
        return result;
    }

    @Override
    protected void _referencedCheck(Context ctx, String salariatSchID) throws BOSException, EASBizException {
        if (salariatSchID == null) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name where salariatScheme='");
        oql.append(salariatSchID);
        oql.append("'");
        StringBuffer msg = new StringBuffer();
        ICmpTemplate temp = CmpTemplateFactory.getLocalInstance(ctx);
        CmpTemplateCollection tempCols = temp.getCmpTemplateCollection(oql.toString());
        if (tempCols.size() > 0) {
            int size = tempCols.size();
            for (int i = 0; i < size; ++i) {
                msg.append(tempCols.get(i).getName());
                if (i == size - 1) continue;
                msg.append(";");
            }
            throw new SalariatException(SalariatException.SAL_BEEN_REF, new String[]{msg.toString()});
        }
        oql.delete(0, oql.length());
        oql.append("select id,name where salariatScheme='");
        oql.append(salariatSchID);
        oql.append("'");
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeCollection schCols = sch.getCmpSchemeCollection(oql.toString());
        if (schCols.size() > 0) {
            int size = schCols.size();
            for (int i = 0; i < size; ++i) {
                msg.append(schCols.get(i).getName());
                if (i == size - 1) continue;
                msg.append(";");
            }
            throw new SalariatException(SalariatException.SAL_BEEN_REF, new String[]{msg.toString()});
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
    }

    @Override
    protected String _copySalScheme(Context ctx, IObjectPK oldSalID) throws BOSException, EASBizException {
        Random ran = new Random();
        String strHZ = "_new" + ran.nextInt(1234);
        SalariatSchemeInfo oldSalSchemeInfo = (SalariatSchemeInfo)this.getValue(ctx, oldSalID);
        SalariatSchemeInfo newSalSchemeInfo = new SalariatSchemeInfo();
        newSalSchemeInfo.setName(oldSalSchemeInfo.getName() + strHZ);
        newSalSchemeInfo.setNumber(oldSalSchemeInfo.getNumber() + strHZ);
        newSalSchemeInfo.setCurrency(oldSalSchemeInfo.getCurrency());
        newSalSchemeInfo.setFlagStandardBase(oldSalSchemeInfo.isFlagStandardBase());
        newSalSchemeInfo.setStandardBase(oldSalSchemeInfo.getStandardBase());
        newSalSchemeInfo.setFlagPersonItemPriority(oldSalSchemeInfo.isFlagPersonItemPriority());
        newSalSchemeInfo.setHrOrgUnit(oldSalSchemeInfo.getHrOrgUnit());
        newSalSchemeInfo.setDescription(oldSalSchemeInfo.getDescription());
        newSalSchemeInfo.setState(StateEnum.UNENABLE);
        newSalSchemeInfo.setEnableDate(null);
        newSalSchemeInfo.setDisableDate(null);
        HRMulUtil.setAllMulStringValue((ObjectBaseInfo)newSalSchemeInfo, (String)"name", (String)(oldSalSchemeInfo.getName() + strHZ));
        HRMulUtil.setAllMulStringValue((ObjectBaseInfo)newSalSchemeInfo, (String)"description", (String)oldSalSchemeInfo.getDescription());
        IObjectPK salSchmPK = super._addnew(ctx, (IObjectValue)newSalSchemeInfo);
        newSalSchemeInfo.setId(BOSUuid.read((String)salSchmPK.toString()));
        String oql = "select id,item.id,seq where scheme.id = '" + oldSalID.toString() + "'";
        ISalaraitCmpPersonItemProps iPersonItem = SalaraitCmpPersonItemPropsFactory.getLocalInstance(ctx);
        SalaraitCmpPersonItemPropsCollection personItemsCollection = iPersonItem.getSalaraitCmpPersonItemPropsCollection(oql);
        CmpItemInfo cmpItemInfo = null;
        CoreBaseCollection newColl = new CoreBaseCollection();
        SalaraitCmpPersonItemPropsInfo personItemPropsInfo = null;
        for (int i = 0; i < personItemsCollection.size(); ++i) {
            personItemPropsInfo = new SalaraitCmpPersonItemPropsInfo();
            cmpItemInfo = personItemsCollection.get(i).getItem();
            personItemPropsInfo.setItem(cmpItemInfo);
            personItemPropsInfo.setSeq(personItemsCollection.get(i).getSeq());
            personItemPropsInfo.setScheme(newSalSchemeInfo);
            newColl.add((CoreBaseInfo)personItemPropsInfo);
        }
        if (newColl.size() > 0) {
            iPersonItem.addnew(newColl);
        }
        ISalaraitCmpItemProps iCmpItemProps = SalaraitCmpItemPropsFactory.getLocalInstance(ctx);
        SalaraitCmpItemPropsCollection cmpItemsCollection = iCmpItemProps.getSalaraitCmpItemPropsCollection(oql);
        newColl = new CoreBaseCollection();
        SalaraitCmpItemPropsInfo cmpItemProps = null;
        for (int i = 0; i < cmpItemsCollection.size(); ++i) {
            cmpItemProps = new SalaraitCmpItemPropsInfo();
            cmpItemProps.setScheme(newSalSchemeInfo);
            cmpItemProps.setSeq(cmpItemsCollection.get(i).getSeq());
            cmpItemProps.setItem(cmpItemsCollection.get(i).getItem());
            newColl.add((CoreBaseInfo)cmpItemProps);
        }
        if (newColl.size() > 0) {
            iCmpItemProps.addnew(newColl);
        }
        oql = "select * where scheme.id = '" + oldSalID.toString() + "' order by level";
        ISalariatHiberProps iHiber = SalariatHiberPropsFactory.getLocalInstance(ctx);
        SalariatHiberPropsCollection hiberCollection = iHiber.getSalariatHiberPropsCollection(oql);
        SalariatHiberPropsInfo newOiberInfo = null;
        SalariatHiberPropsInfo oldHiberInfo = null;
        HashMap<String, SalariatHiberPropsInfo> parentMap = new HashMap<String, SalariatHiberPropsInfo>();
        newColl = new CoreBaseCollection();
        for (int i = 0; i < hiberCollection.size(); ++i) {
            newOiberInfo = new SalariatHiberPropsInfo();
            oldHiberInfo = hiberCollection.get(i);
            newOiberInfo.setScheme(newSalSchemeInfo);
            newOiberInfo.setName(oldHiberInfo.getName());
            newOiberInfo.setNumber(oldHiberInfo.getNumber());
            newOiberInfo.setIsLeaf(oldHiberInfo.isIsLeaf());
            newOiberInfo.setLevel(oldHiberInfo.getLevel());
            newOiberInfo.setCU(oldHiberInfo.getCU());
            HRMulUtil.setAllMulStringValue((ObjectBaseInfo)newOiberInfo, (String)"name", (String)oldHiberInfo.getName());
            HRMulUtil.setAllMulStringValue((ObjectBaseInfo)newOiberInfo, (String)"description", (String)oldHiberInfo.getDescription());
            newOiberInfo.setScheme(newSalSchemeInfo);
            if (oldHiberInfo.getParent() == null && oldHiberInfo.getLevel() == 0) {
                newOiberInfo.setParent(null);
                IObjectPK parentPK = iHiber.addnew((CoreBaseInfo)newOiberInfo);
                newOiberInfo.setId(BOSUuid.read((String)parentPK.toString()));
                parentMap.put(oldHiberInfo.getId().toString(), newOiberInfo);
                continue;
            }
            newOiberInfo.setParent((SalariatHiberPropsInfo)parentMap.get(oldHiberInfo.getParent().getId().toString()));
            newColl.add((CoreBaseInfo)newOiberInfo);
        }
        if (newColl.size() > 0) {
            iHiber.addnew(newColl);
        }
        oql = "select * where scheme.id = '" + oldSalID.toString() + "'";
        ISalariatPointProps iPoint = SalariatPointPropsFactory.getLocalInstance(ctx);
        SalariatPointPropsCollection pointCollection = iPoint.getSalariatPointPropsCollection(oql);
        SalariatPointPropsInfo pointInfo = null;
        newColl = new CoreBaseCollection();
        for (int i = 0; i < pointCollection.size(); ++i) {
            pointInfo = new SalariatPointPropsInfo();
            pointInfo.setScheme(newSalSchemeInfo);
            pointInfo.setName(pointCollection.get(i).getName());
            pointInfo.setNumber(pointCollection.get(i).getNumber());
            pointInfo.setSeq(pointCollection.get(i).getSeq());
            pointInfo.setCU(pointCollection.get(i).getCU());
            pointInfo.setIsDefault(pointCollection.get(i).isIsDefault());
            HRMulUtil.setAllMulStringValue((ObjectBaseInfo)pointInfo, (String)"name", (String)pointCollection.get(i).getName());
            newColl.add((CoreBaseInfo)pointInfo);
        }
        if (newColl.size() > 0) {
            iPoint.addnew(newColl);
        }
        return salSchmPK.toString();
    }

    @Override
    protected boolean _hasInitFixedScheme(Context ctx, String salSchmID) throws BOSException, EASBizException {
        String oql;
        HROrgUnitInfo hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrOrgInfo == null) {
            return false;
        }
        String hrOrgId = hrOrgInfo.getId().toString();
        IFixedCmpScheme iFixed = FixedCmpSchemeFactory.getLocalInstance(ctx);
        return iFixed.exists(oql = " select id where salariatScheme.id='" + salSchmID + "' and hrOrgUnit.id='" + hrOrgId + "'");
    }

    private void doUpdateTableItem(Context ctx, SalariatPointPropsInfo pointInfo, SalariatSchemeInfo schemeInfo) throws BOSException, EASBizException {
        String gradeTableName = schemeInfo.getGradeTableName();
        ArrayList<ColumnMetasInfo> lstAddColumns = new ArrayList<ColumnMetasInfo>();
        ColumnMetasInfo infoColumnMetas = this.getColumnMetasInfoByPointGrade(pointInfo);
        lstAddColumns.add(infoColumnMetas);
        AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable();
        iDynamicDBTable.setContext(ctx);
        iDynamicDBTable.setListColumn(lstAddColumns);
        if (gradeTableName != null) {
            iDynamicDBTable.setTableName(gradeTableName);
            try {
                iDynamicDBTable.alter();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private ColumnMetasInfo getColumnMetasInfoByPointGrade(SalariatPointPropsInfo pointInfo) {
        ColumnMetasInfo metaInfo = new ColumnMetasInfo();
        metaInfo.setName(pointInfo.getNumber());
        metaInfo.setDataType(HRTableTools.getIDDataType());
        metaInfo.setLength(HRTableTools.getIDLength());
        metaInfo.setPrecision(HRTableTools.getIDPrecision());
        metaInfo.setAllowNull(Boolean.TRUE);
        metaInfo.setIntDataState(10);
        return metaInfo;
    }

    @Override
    protected void _upGradeSalTable(Context ctx, String pointTableName, String gradeTableName) throws BOSException, EASBizException {
        if (pointTableName == null || gradeTableName == null) {
            return;
        }
        this.upGradePointGradeTable(ctx, pointTableName);
        this.upGradePointGradeTable(ctx, gradeTableName);
    }

    private void upGradePointGradeTable(Context ctx, String tableName) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("If not exists (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + tableName + "')");
        sqlBuf.append(" ALTER TABLE " + tableName + " ADD FSalPointSalGradeID VARCHAR(44) ");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }
}

