/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpReportFacade;
import com.kingdee.eas.hr.compensation.IMyCmpReportFacade;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.MyCmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class CompensationWebService
extends BuffaloService {
    Logger logger = Logger.getLogger((String)CompensationWebService.class.getName());
    final String resClass = "com.kingdee.eas.hr.compensation.CmpWebResource";

    public String getCmpPeriodListString() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 8;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROUnitID(ctx)));
        try {
            FilterInfo filter = new FilterInfo("shutMyCmp = 0 or shutMyCmp is null");
            filterInfo.mergeFilter(filter, "and");
        }
        catch (ParserException e1) {
            this.logger.error((Object)e1.getMessage(), e1.getCause());
        }
        catch (BOSException e1) {
            this.logger.error((Object)e1.getMessage(), e1.getCause());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("description"));
        viewInfo.getSelector().add(new SelectorItemInfo("beginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("endDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("fiscalPeriod"));
        String xmlData = null;
        ArrayList<Object> list = null;
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery"));
            iqec.setObjectView(viewInfo);
            IRowSet rowSet = iqec.executeQuery();
            list = new ArrayList<Object>(rowSet.size() + 1);
            list.add("" + rowSet.size());
            int index = 0;
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + ++index;
                array[1] = rowSet.getString("id");
                array[2] = rowSet.getString("number");
                array[3] = rowSet.getString("name");
                array[4] = rowSet.getString("description");
                array[5] = rowSet.getDate("beginDate") != null ? rowSet.getDate("beginDate").toString() : "";
                array[6] = rowSet.getDate("endDate") != null ? rowSet.getDate("endDate").toString() : "";
                array[7] = rowSet.getString("fiscalPeriod");
                list.add(array);
            }
            xmlData = PerfWebUtils.makeProcDataToXMLData(list, (int)COLS);
        }
        catch (Exception e) {
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData((Context)ctx, (int)COLS);
        }
        return xmlData;
    }

    private String getHROUnitID(Context ctx) {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            return ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        HROrgUnitInfo info = new HROrgUnitInfo();
        return BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
    }

    public String[] getMyCmpTable(String param) {
        String[] arr = param.split("#");
        String idValue = arr[0];
        String repeatx = arr[1];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx == null) {
            this.logger.error((Object)"context is null");
        }
        boolean isRepeatx = false;
        if (repeatx != null && repeatx.equals("true")) {
            isRepeatx = true;
        }
        String[] result = isRepeatx ? this.getMyCmpTableStringRepeatx(idValue) : this.getMyCmpTableStringRepeaty(idValue);
        return result;
    }

    public String[] getMyCmpTableStringRepeaty(String cmpPeriodID) {
        String[] result = new String[4];
        String empStr = "<tr height=\"21\" width=\"50\" class=\"hr_table_title_bgColor\" ><td width=\"50\" >&nbsp;</td></tr>";
        String cmpDescription = "&nbsp;";
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx == null) {
            this.logger.error((Object)"context is null");
        }
        if (StringUtils.isEmpty((String)cmpPeriodID)) {
            result[0] = "faild";
            result[2] = this.getReportHtmlResource(ctx, "operateFaild");
        } else {
            try {
                ICmpReportFacade iCmpReportFacade = CmpReportFacadeFactory.getLocalInstance(ctx);
                Map hstData = iCmpReportFacade.getMyCmpData(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString(), cmpPeriodID);
                StringBuffer sb = new StringBuffer(3000);
                StringBuffer descriptionSB = new StringBuffer(150);
                if (hstData != null && !hstData.isEmpty() && hstData.keySet().size() > 1) {
                    result[2] = "" + this.getTableHTMLRepeaty(ctx, hstData, sb);
                    BigDecimal bdTotal = (BigDecimal)hstData.get("total");
                    this.getDescriptionHTML(ctx, bdTotal, descriptionSB);
                } else {
                    sb.append(empStr);
                    descriptionSB.append(cmpDescription);
                }
                if (sb.length() == 0) {
                    sb.append(empStr);
                    descriptionSB = new StringBuffer();
                    descriptionSB.append(cmpDescription);
                }
                result[0] = "success";
                sb.insert(0, "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"20\">&nbsp;</td><td>");
                sb.append("</td><td width=\"20\">&nbsp;</td></tr></table>");
                result[1] = sb.toString();
                result[3] = descriptionSB.toString();
            }
            catch (EASBizException e) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)e);
                result[0] = "faild";
                result[2] = e.getMessage();
            }
            catch (Exception ex) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)ex);
                result[0] = "faild";
                result[2] = this.getReportHtmlResource(ctx, "operateFaild");
            }
        }
        return result;
    }

    public String[] getMyCmpTableStringRepeatx(String cmpPeriodID) {
        String[] result = new String[4];
        String empStr = "<tr height=\"21\" width=\"50\" class=\"hr_table_title_bgColor\" ><td width=\"50\" >&nbsp;</td></tr>";
        String cmpDescription = "&nbsp;";
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx == null) {
            this.logger.error((Object)"context is null");
        }
        if (StringUtils.isEmpty((String)cmpPeriodID)) {
            result[0] = "faild";
            result[2] = this.getReportHtmlResource(ctx, "operateFaild");
        } else {
            try {
                ICmpReportFacade iCmpReportFacade = CmpReportFacadeFactory.getLocalInstance(ctx);
                Map hstData = iCmpReportFacade.getMyCmpData(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString(), cmpPeriodID);
                StringBuffer sb = new StringBuffer(3000);
                StringBuffer descriptionSB = new StringBuffer(150);
                if (hstData != null && !hstData.isEmpty() && hstData.keySet().size() > 1) {
                    result[2] = "" + this.getTableHTMLRepeatx(ctx, hstData, sb);
                    BigDecimal bdTotal = (BigDecimal)hstData.get("total");
                    this.getDescriptionHTML(ctx, bdTotal, descriptionSB);
                } else {
                    sb.append(empStr);
                    descriptionSB.append(cmpDescription);
                }
                if (sb.length() == 0) {
                    sb.append(empStr);
                    descriptionSB = new StringBuffer();
                    descriptionSB.append(cmpDescription);
                }
                result[0] = "success";
                sb.insert(0, "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"20\">&nbsp;</td><td>");
                sb.append("</td><td width=\"20\">&nbsp;</td></tr></table>");
                result[1] = sb.toString();
                result[3] = descriptionSB.toString();
            }
            catch (EASBizException e) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)e);
                result[0] = "faild";
                result[2] = e.getMessage();
            }
            catch (Exception ex) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)ex);
                result[0] = "faild";
                result[2] = this.getReportHtmlResource(ctx, "operateFaild");
            }
        }
        return result;
    }

    private void getDescriptionHTML(Context ctx, BigDecimal bdTotal, StringBuffer sb) {
        if (bdTotal == null) {
            return;
        }
        sb.append("&nbsp;&nbsp;&nbsp;<font color='red'>" + this.getReportHtmlResource(ctx, "myCmp_bz") + "");
        sb.append(bdTotal.setScale(2, 4));
        sb.append("\u3002");
        sb.append("<br>");
        sb.append("&nbsp;&nbsp;&nbsp;");
        sb.append(this.getReportHtmlResource(ctx, "myCmp_tqzy"));
        sb.append("</font>");
    }

    private String getReportHtmlResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpWebResource", (String)key, (Locale)ctx.getOriginLocale());
    }

    private int getTableHTMLRepeaty(Context ctx, Map hstData, StringBuffer sb) {
        CmpSchemeInfo infoCmpScheme = null;
        HashMap hspValue = null;
        int maxRows = 0;
        int maxColumns = 0;
        HashMap schemeTimesMap = (HashMap)hstData.get("CmpSchemeTimes");
        Iterator itrKey = hstData.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        Object obj = null;
        while (itrKey.hasNext()) {
            obj = itrKey.next();
            if (!(obj instanceof CmpSchemeInfo)) continue;
            arrayList.add(obj);
        }
        Object[] objList = arrayList.toArray();
        if (objList.length < 1) {
            return 100;
        }
        for (int i = objList.length - 1; i >= 0; --i) {
            infoCmpScheme = (CmpSchemeInfo)objList[i];
            hspValue = (HashMap)hstData.get(infoCmpScheme);
            if (hspValue.size() <= maxRows) continue;
            maxRows = hspValue.size();
        }
        if (maxRows == 0) {
            return 100;
        }
        ArrayList list = null;
        CmpSchemeItemInfo infoCmpSchemeItem = null;
        HashMap timeValueMap = null;
        String strAmount = this.getReportHtmlResource(ctx, "AMOUNT");
        String strCmpItem = this.getReportHtmlResource(ctx, "CMP_ITEM");
        int tableHeight = 0;
        sb.append("<tr>");
        for (int columnCount = objList.length - 1; columnCount >= 0; --columnCount) {
            int i;
            infoCmpScheme = (CmpSchemeInfo)objList[columnCount];
            int[] times = (int[])schemeTimesMap.get(infoCmpScheme);
            int size = times.length;
            maxColumns += size;
            sb.append("<td>");
            sb.append("<table frame=\"void\" border=\"0\" cellpadding=\"5\" cellspacing=\"1\" class=\"hr_table_bgColor\" ");
            sb.append("width=\"100%\" height=\"100%\">");
            sb.append("<tr height=\"25\" class=\"hr_table_title_bgColor\" align=\"left\"><td colspan = \"");
            sb.append("" + (size + 1));
            sb.append("\">");
            sb.append(infoCmpScheme.getName());
            sb.append("</td></tr>");
            sb.append("<tr height=\"25\" class=\"hr_table_title_bgColor\">");
            sb.append("<td width=\"140\">");
            sb.append(strCmpItem);
            sb.append("</td>");
            for (int colStrAmount = 0; colStrAmount < size; ++colStrAmount) {
                sb.append("<td width=\"100\">");
                sb.append(strAmount + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"87_CompensationWebService", (Locale)ctx.getOriginLocale()) + "\uff08" + times[colStrAmount] + "\uff09" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"88_CompensationWebService", (Locale)ctx.getOriginLocale()));
                sb.append("</td>");
            }
            sb.append("</tr>");
            hspValue = (HashMap)hstData.get(infoCmpScheme);
            list = this.getSortKeyList(hspValue);
            for (i = 0; i < list.size(); ++i) {
                infoCmpSchemeItem = (CmpSchemeItemInfo)list.get(i);
                sb.append("<tr height=\"25\" class=\"hr_table_content_bgColor\" align=\"center\">");
                sb.append("<td align=\"left\">");
                sb.append(infoCmpSchemeItem.getCmpItem().getName());
                sb.append("</td>");
                for (int j = 0; j < size; ++j) {
                    timeValueMap = (HashMap)hspValue.get(infoCmpSchemeItem);
                    CmpItemInfo infoCmpItem = infoCmpSchemeItem.getCmpItem();
                    sb.append("<td align=\"right\">");
                    if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                        BigDecimal value = (BigDecimal)timeValueMap.get(times[j]);
                        sb.append(HRCmpItemUtils.formatBigDecimal(value, infoCmpItem.getDecDigital()));
                    } else if (timeValueMap.get(times[j]) != null) {
                        sb.append(timeValueMap.get(times[j]));
                    } else {
                        sb.append("&nbsp");
                    }
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            if (list.size() < maxRows) {
                for (i = 0; i < maxRows - list.size(); ++i) {
                    sb.append("<tr height = \"25\" class=\"hr_table_content_bgColor\">");
                    sb.append("<td colspan=\"");
                    sb.append("" + (size + 1));
                    sb.append("\">");
                    sb.append("&nbsp;");
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            }
            sb.append("</table></td>");
        }
        sb.append("</tr>");
        int tableWidth = objList.length * 140 + maxColumns * 100;
        sb.append("<tr height=\"10\" class=\"hr_table_content_bgColor\" align=\"center\" >");
        sb.append("<td colspan=\"");
        sb.append("" + objList.length);
        sb.append("\" width = \"");
        sb.append(tableWidth);
        sb.append("\">");
        sb.append("");
        sb.append("</td>");
        sb.append("</tr>");
        BigDecimal bdTotal = (BigDecimal)hstData.get("total");
        bdTotal = bdTotal.setScale(2, 4);
        sb.append("<tr>");
        sb.append("<td colspan=\"");
        sb.append("" + objList.length);
        sb.append("\">");
        sb.append("<table border=\"0\" cellpadding=\"5\" cellspacing=\"1\" class=\"hr_table_bgColor\" width=\"100%\">");
        sb.append("<tr height=\"25\" class=\"hr_table_total_bgColor\" align=\"center\" >");
        sb.append("<td width=\"122\" align=\"left\" >");
        sb.append(this.getReportHtmlResource(ctx, "SHOULDTOTAL"));
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        sb.append(bdTotal.toString());
        sb.append("</td>");
        sb.append("</tr></table>");
        sb.append("</td></tr>");
        StringBuffer top = new StringBuffer();
        top.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"hr_table_bgColor\" ");
        top.append("width=\"" + tableWidth + "\" ");
        top.append(">");
        String buttom = "</table>";
        sb.insert(0, top);
        sb.append(buttom);
        tableHeight = (maxRows + 3) * 25 + 10;
        return tableHeight + 40;
    }

    private int getTableHTMLRepeatx(Context ctx, Map hstData, StringBuffer sb) {
        CmpSchemeInfo infoCmpScheme = null;
        HashMap hspValue = null;
        int maxColumns = 0;
        Iterator itrKey = hstData.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        Object obj = null;
        while (itrKey.hasNext()) {
            obj = itrKey.next();
            if (!(obj instanceof CmpSchemeInfo)) continue;
            arrayList.add(obj);
        }
        Object[] objList = arrayList.toArray();
        if (objList.length < 1) {
            return 100;
        }
        for (int i = objList.length - 1; i >= 0; --i) {
            infoCmpScheme = (CmpSchemeInfo)objList[i];
            hspValue = (HashMap)hstData.get(infoCmpScheme);
            if (hspValue.size() <= maxColumns) continue;
            maxColumns = hspValue.size();
        }
        if (maxColumns == 0) {
            return 100;
        }
        ArrayList list = null;
        CmpSchemeItemInfo infoCmpSchemeItem = null;
        HashMap timeValueMap = null;
        String strAmount = this.getReportHtmlResource(ctx, "AMOUNT");
        String strCmpItem = this.getReportHtmlResource(ctx, "CMP_ITEM");
        int tableWidth = (maxColumns + 2) * 80;
        int tableHeight = 0;
        for (int rowCount = objList.length - 1; rowCount >= 0; --rowCount) {
            infoCmpScheme = (CmpSchemeInfo)objList[rowCount];
            sb.append("<tr height=\"24\" class=\"hr_table_title_bgColor\" align=\"left\">");
            sb.append("<td colspan=\"");
            sb.append("" + (maxColumns + 1));
            sb.append("\" align=\"left\">");
            sb.append(infoCmpScheme.getName());
            sb.append("</td>");
            sb.append("</tr>");
            hspValue = (HashMap)hstData.get(infoCmpScheme);
            list = this.getSortKeyList(hspValue);
            HashMap schemeTimesMap = (HashMap)hstData.get("CmpSchemeTimes");
            int[] times = (int[])schemeTimesMap.get(infoCmpScheme);
            int size = times.length;
            for (int i = 0; i < 1 + size; ++i) {
                int j;
                sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\">");
                if (i == 0) {
                    for (j = 0; j < list.size() + 1; ++j) {
                        if (j == 0) {
                            sb.append("<td class=\"hr_table_title_bgColor\" width=\"200\">");
                            sb.append(strCmpItem);
                            sb.append("</td>");
                            continue;
                        }
                        infoCmpSchemeItem = (CmpSchemeItemInfo)list.get(j - 1);
                        sb.append("<td width=\"200\" align=\"center\">");
                        sb.append(infoCmpSchemeItem.getCmpItem().getName());
                        sb.append("</td>");
                    }
                } else {
                    for (j = 0; j < list.size() + 1; ++j) {
                        if (j == 0) {
                            sb.append("<td class=\"hr_table_title_bgColor\" width=\"200\">");
                            sb.append(strAmount + "\uff08" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"87_CompensationWebService", (Locale)ctx.getOriginLocale()) + times[i - 1] + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"88_CompensationWebService", (Locale)ctx.getLocale()) + "\uff09");
                            sb.append("</td>");
                            continue;
                        }
                        infoCmpSchemeItem = (CmpSchemeItemInfo)list.get(j - 1);
                        timeValueMap = (HashMap)hspValue.get(infoCmpSchemeItem);
                        CmpItemInfo infoCmpItem = infoCmpSchemeItem.getCmpItem();
                        sb.append("<td align=\"right\">");
                        if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                            BigDecimal value = (BigDecimal)timeValueMap.get(times[i - 1]);
                            sb.append(HRCmpItemUtils.formatBigDecimal(value, infoCmpItem.getDecDigital()));
                        } else if (timeValueMap.get(times[i - 1]) != null) {
                            sb.append(timeValueMap.get(times[i - 1]));
                        } else {
                            sb.append("&nbsp;");
                        }
                        sb.append("</td>");
                    }
                }
                if (list.size() < maxColumns) {
                    sb.append("<td colspan=\"");
                    sb.append("" + (maxColumns - list.size()));
                    sb.append("\"");
                    sb.append("&nbsp;");
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("<tr height=\"10\" class=\"hr_table_content_bgColor\" align=\"center\" >");
            sb.append("<td colspan=\"");
            sb.append("" + (maxColumns + 1));
            sb.append("\">");
            sb.append("");
            sb.append("</td>");
            sb.append("</tr>");
            tableHeight += 150;
        }
        BigDecimal bdTotal = (BigDecimal)hstData.get("total");
        bdTotal = bdTotal.setScale(2, 4);
        sb.append("<tr height=\"24\" class=\"hr_table_total_bgColor\" align=\"center\" >");
        sb.append("<td align=\"left\" >");
        sb.append(this.getReportHtmlResource(ctx, "SHOULDTOTAL"));
        sb.append("</td>");
        sb.append("<td colspan=\"");
        sb.append("" + maxColumns);
        sb.append("\"  align=\"right\" >");
        sb.append(bdTotal.toString());
        sb.append("</td>");
        sb.append("</tr>");
        StringBuffer top = new StringBuffer();
        top.append("<table border=\"0\" cellpadding=\"5\" cellspacing=\"1\" class=\"hr_table_bgColor\" ");
        top.append("width=\"" + tableWidth + "\" ");
        top.append(">");
        String buttom = "</table>";
        sb.insert(0, top);
        sb.append(buttom);
        return tableHeight + 30;
    }

    private void swap(ArrayList list, int i, int j) {
        Object obj = list.get(i);
        list.set(i, list.get(j));
        list.set(j, obj);
    }

    private ArrayList getSortKeyList(HashMap map) {
        ArrayList list = new ArrayList();
        Iterator iter = map.keySet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            list.add(count, iter.next());
            ++count;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            for (int j = size - 1; j > i; --j) {
                if (((CmpSchemeItemInfo)list.get(j)).getSortOrder() >= ((CmpSchemeItemInfo)list.get(j - 1)).getSortOrder()) continue;
                this.swap(list, j, j - 1);
            }
        }
        return list;
    }

    private CmpPeriodInfo getPeriodDateByPeriodId(Context ctx, String periodNum) throws BOSException, SQLException, EASBizException {
        CmpPeriodInfo periodInfo = null;
        String hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        periodInfo = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodInfo("where number = '" + periodNum + "' and hrOrgUnit = '" + hrOrgUnit + "'");
        return periodInfo;
    }

    public String[] getMyCmpReportString(String str) throws BOSException, SQLException, EASBizException {
        String[] arr = str.split("#");
        String beginPeriodId = arr[0];
        String endPeriodId = arr[1];
        String showDetail = arr[2];
        String showTimeDetail = arr[3];
        String strBegin = arr[4];
        String strEnd = arr[5];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx == null) {
            this.logger.error((Object)"context is null");
        }
        CmpPeriodInfo cmpBeginPeriod = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(beginPeriodId));
        CmpPeriodInfo cmpEndPeriod = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(endPeriodId));
        boolean isShowDetail = false;
        boolean isShowTimeDetail = false;
        if (showDetail != null && showDetail.equals("true")) {
            isShowDetail = true;
        }
        if (showTimeDetail != null && showTimeDetail.equals("true")) {
            isShowTimeDetail = true;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("beginPeriond", cmpBeginPeriod);
        paramMap.put("endPeriond", cmpEndPeriod);
        paramMap.put("isShowDetail", isShowDetail);
        paramMap.put("isShowTimeDetail", isShowTimeDetail);
        if (strBegin.equals("null")) {
            paramMap.put("fromTime", "1");
        } else {
            paramMap.put("fromTime", strBegin);
        }
        if (strEnd.equals("null")) {
            paramMap.put("toTime", null);
        } else {
            paramMap.put("toTime", strEnd);
        }
        paramMap.put("commonView", null);
        String[] result = this.getMyCmpReportTableString(cmpBeginPeriod, cmpEndPeriod, paramMap);
        return result;
    }

    private String[] getMyCmpReportTableString(CmpPeriodInfo cmpBeginPeriod, CmpPeriodInfo cmpEndPeriod, Map paramMap) {
        String[] result = new String[3];
        String empStr = "<tr height=\"21\" width=\"50\" class=\"hr_table_title_bgColor\" ><td width=\"50\" >&nbsp;</td></tr>";
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx == null) {
            this.logger.error((Object)"context is null");
        }
        if (cmpBeginPeriod == null || cmpEndPeriod == null) {
            result[0] = "faild";
            result[2] = this.getReportHtmlResource(ctx, "operateFaild");
        } else {
            if (!cmpBeginPeriod.getBeginDate().before(cmpBeginPeriod.getEndDate())) {
                result[0] = "faild";
                result[2] = this.getReportHtmlResource(ctx, "operateFaild");
            }
            try {
                IMyCmpReportFacade iMyCmpReportFacade = MyCmpReportFacadeFactory.getLocalInstance(ctx);
                Map hstData = iMyCmpReportFacade.getMySummaryReportData(paramMap);
                StringBuffer sb = new StringBuffer(3000);
                if (hstData != null && !hstData.isEmpty() && hstData.keySet().size() > 1) {
                    result[2] = "" + this.getMyCmpReportTableHTML(ctx, cmpBeginPeriod, cmpEndPeriod, paramMap, sb, hstData);
                } else {
                    sb.append(empStr);
                }
                if (sb.length() == 0) {
                    sb.append(empStr);
                }
                result[0] = "success";
                sb.insert(0, "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"20\">&nbsp;</td><td>");
                sb.append("</td><td width=\"20\">&nbsp;</td></tr></table>");
                result[1] = sb.toString();
            }
            catch (EASBizException e) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)e);
                result[0] = "faild";
                result[2] = e.getMessage();
            }
            catch (Exception ex) {
                this.logger.error((Object)this.getReportHtmlResource(ctx, "readMyCmpFaild"), (Throwable)ex);
                result[0] = "faild";
                result[2] = ex.getMessage();
            }
        }
        return result;
    }

    private int getMyCmpReportTableHTML(Context ctx, CmpPeriodInfo cmpBeginPeriod, CmpPeriodInfo cmpEndPeriod, Map paramMap, StringBuffer sb, Map hstData) throws BOSException, SQLException, EASBizException {
        HashMap<String, BigDecimal> total;
        String key;
        CmpItemInfo itemInfo;
        int i;
        boolean isShowDetail = (Boolean)paramMap.get("isShowDetail");
        boolean isShowTimeDetail = (Boolean)paramMap.get("isShowTimeDetail");
        Map mapParam = (Map)hstData.get("mapParam");
        Map mapData = (Map)hstData.get("mapData");
        if (mapData == null) {
            return 0;
        }
        List lstCmpSchemeInfo = (List)mapParam.get("CmpSchemeInfos");
        HashMap mapAllSchemeItems = (HashMap)mapParam.get("MapAllSchemeItems");
        List lstAllSchemePerItems = (List)mapParam.get("LstAllSchemePerItems");
        List publicItem = (List)mapAllSchemeItems.get("publicItem");
        int maxColumns = 0;
        sb.append("<tr height=\"24\" class=\"hr_table_title_bgColor\" rowspan=\"2\" align=\"left\">");
        int num = lstAllSchemePerItems.size();
        for (i = 0; i < num; ++i) {
            itemInfo = (CmpItemInfo)lstAllSchemePerItems.get(i);
            sb.append("<td colspan=\"");
            sb.append("");
            sb.append("\" align=\"center\" ");
            sb.append("width=\"140\"");
            sb.append(">");
            sb.append(itemInfo.getName());
            sb.append("</td>");
            ++maxColumns;
        }
        sb.append("<td colspan=\"");
        sb.append("\" align=\"center\" class=\"hr_table_title_bgColor\"");
        sb.append("width=\"140\"");
        sb.append(">");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"89_CompensationWebService", (Locale)ctx.getOriginLocale()));
        sb.append("</td>");
        sb.append("<td colspan=\"");
        sb.append("");
        sb.append("\" align=\"center\" class=\"hr_table_title_bgColor\" ");
        sb.append("width=\"140\"");
        sb.append(">");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"90_CompensationWebService", (Locale)ctx.getOriginLocale()));
        sb.append("</td>");
        maxColumns += 2;
        if (isShowTimeDetail) {
            sb.append("<td colspan=\"");
            sb.append("\" align=\"center\" class=\"hr_table_title_bgColor\"");
            sb.append("width=\"140\"");
            sb.append(">");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"72_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sb.append("</td>");
        }
        if (publicItem != null && publicItem.size() > 0) {
            sb.append("<td colspan=\"");
            sb.append(publicItem.size());
            sb.append("\" align=\"center\" class=\"hr_table_title_bgColor\">");
            sb.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"hr_table_bgColor\" width=\"100%\"");
            sb.append(" height=\"100%\"><tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"center\">");
            sb.append("<td colspan=\"");
            sb.append(publicItem.size());
            sb.append("\" class=\"hr_table_title_bgColor\">");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"91_CompensationWebService", (Locale)ctx.getOriginLocale()));
            sb.append("</td></tr><tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"center\">");
            num = publicItem.size();
            for (i = 0; i < num; ++i) {
                itemInfo = (CmpItemInfo)publicItem.get(i);
                sb.append("<td align=\"center\" ");
                sb.append("width=\"140\"");
                sb.append("colspan=\"\" class=\"hr_table_title_bgColor\">");
                sb.append(itemInfo.getName());
                sb.append("</td>");
                ++maxColumns;
            }
            sb.append("</tr></table>");
            sb.append("</td>");
        }
        num = lstCmpSchemeInfo.size();
        for (i = 0; i < num; ++i) {
            CmpSchemeInfo schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i);
            List privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
            if (privateItem == null) continue;
            sb.append("<td colspan=\"");
            sb.append(privateItem.size());
            sb.append("\" align=\"center\" class=\"hr_table_title_bgColor\">");
            sb.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"hr_table_bgColor\" width=\"100%\"");
            sb.append(" height=\"100%\"><tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"center\">");
            sb.append("<td colspan=\"");
            sb.append(privateItem.size());
            sb.append("\" class=\"hr_table_title_bgColor\">");
            sb.append(schemeInfo.getName());
            sb.append("</td></tr><tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"center\">");
            int number = privateItem.size();
            for (int j = 0; j < number; ++j) {
                CmpItemInfo itemInfo2 = (CmpItemInfo)privateItem.get(j);
                sb.append("<td align=\"center\" ");
                sb.append("width=\"140\"");
                sb.append(" colspan=\"\" class=\"hr_table_title_bgColor\">");
                sb.append(itemInfo2.getName());
                sb.append("</td>");
                ++maxColumns;
            }
            sb.append("</tr></table>");
            sb.append("</td>");
        }
        sb.append("</tr>");
        int tableWidth = (maxColumns + 4) * 140;
        int tableHeight = 150;
        Iterator allItem = mapData.entrySet().iterator();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        if (isShowDetail) {
            int number;
            List privateItem;
            CmpSchemeInfo schemeInfo;
            CmpItemInfo itemInfo3;
            int i2;
            int num2;
            key = null;
            total = new HashMap<String, BigDecimal>();
            Map.Entry entry = null;
            while (allItem.hasNext()) {
                entry = allItem.next();
                key = (String)entry.getKey();
                if (!key.equals(personId)) {
                    HashMap tempMap = (HashMap)entry.getValue();
                    if (tempMap.size() == 0) continue;
                    sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                    num2 = lstAllSchemePerItems.size();
                    for (i2 = 0; i2 < num2; ++i2) {
                        itemInfo3 = (CmpItemInfo)lstAllSchemePerItems.get(i2);
                        sb.append("<td colspan=\" ");
                        sb.append("");
                        sb.append("\" align=\"left\" ");
                        sb.append("width=\"140\"");
                        sb.append(">");
                        if (tempMap.get(itemInfo3.getNumber()) != null) {
                            sb.append(tempMap.get(itemInfo3.getNumber()));
                        } else {
                            sb.append("&nbsp;");
                        }
                        sb.append("</td>");
                    }
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" align=\"left\" ");
                    sb.append("width=\"140\"");
                    sb.append(">");
                    sb.append(this.getPeriodDateByPeriodId(ctx, tempMap.get("fPeriodNum").toString()).getBeginDate());
                    sb.append("</td>");
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" align=\"left\" ");
                    sb.append("width=\"140\"");
                    sb.append(">");
                    sb.append(this.getPeriodDateByPeriodId(ctx, tempMap.get("fPeriodNum").toString()).getEndDate());
                    sb.append("</td>");
                    if (publicItem != null && publicItem.size() > 0) {
                        num2 = publicItem.size();
                        for (i2 = 0; i2 < num2; ++i2) {
                            itemInfo3 = (CmpItemInfo)publicItem.get(i2);
                            BigDecimal bg = null;
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (tempMap.get(itemInfo3.getNumber()) != null) {
                                if (itemInfo3.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo3.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value = (BigDecimal)tempMap.get(itemInfo3.getNumber());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo3.getDecDigital()).toString());
                                } else if (itemInfo3.getDataType() == ItemDataTypeEnum.INT) {
                                    sb.append(tempMap.get(itemInfo3.getNumber()));
                                }
                                if (total.get(itemInfo3.getNumber()) != null) {
                                    bg = (BigDecimal)total.get(itemInfo3.getNumber());
                                    bg = bg.add(new BigDecimal(tempMap.get(itemInfo3.getNumber()).toString()));
                                    total.put(itemInfo3.getNumber(), bg);
                                } else {
                                    bg = new BigDecimal(tempMap.get(itemInfo3.getNumber()).toString());
                                    total.put(itemInfo3.getNumber(), bg);
                                }
                            } else {
                                sb.append("nbsp;");
                            }
                            sb.append("</td>");
                        }
                    }
                    num2 = lstCmpSchemeInfo.size();
                    for (i2 = 0; i2 < num2; ++i2) {
                        schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i2);
                        privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                        if (privateItem == null) continue;
                        number = privateItem.size();
                        for (int j = 0; j < number; ++j) {
                            BigDecimal bg = null;
                            CmpItemInfo itemInfo4 = (CmpItemInfo)privateItem.get(j);
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (tempMap.get(itemInfo4.getNumber() + "~" + schemeInfo.getId()) == null) {
                                sb.append("&nbsp;");
                            } else {
                                if (itemInfo4.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo4.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value = (BigDecimal)tempMap.get(itemInfo4.getNumber() + "~" + schemeInfo.getId());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo4.getDecDigital()).toString());
                                } else {
                                    sb.append(tempMap.get(itemInfo4.getNumber() + "~" + schemeInfo.getId()));
                                }
                                if (itemInfo4.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo4.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo4.getDataType() == ItemDataTypeEnum.INT) {
                                    if (total.get(itemInfo4.getNumber() + "~" + schemeInfo.getId()) != null) {
                                        bg = (BigDecimal)total.get(itemInfo4.getNumber() + "~" + schemeInfo.getId());
                                        bg = bg.add(new BigDecimal(tempMap.get(itemInfo4.getNumber() + "~" + schemeInfo.getId()).toString()));
                                        total.put(itemInfo4.getNumber() + "~" + schemeInfo.getId(), bg);
                                    } else {
                                        bg = new BigDecimal(tempMap.get(itemInfo4.getNumber() + "~" + schemeInfo.getId()).toString());
                                        total.put(itemInfo4.getNumber() + "~" + schemeInfo.getId(), bg);
                                    }
                                }
                            }
                            sb.append("</td>");
                        }
                    }
                }
                tableHeight = (int)((double)tableHeight + 22.5);
                sb.append("</tr>");
            }
            for (int sum = 0; sum < 1; ++sum) {
                sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                num2 = lstAllSchemePerItems.size() + 1;
                for (i2 = 0; i2 < num2; ++i2) {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append("&nbsp;");
                    sb.append("</td>");
                }
                if (sum == 0) {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append("</td>");
                } else {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append("</td>");
                }
                if (publicItem != null && publicItem.size() > 0) {
                    num2 = publicItem.size();
                    for (i2 = 0; i2 < num2; ++i2) {
                        itemInfo3 = (CmpItemInfo)publicItem.get(i2);
                        sb.append("<td ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"right\">");
                        if (total.get(itemInfo3.getNumber()) != null) {
                            if (itemInfo3.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo3.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo3.getDataType() == ItemDataTypeEnum.INT) {
                                BigDecimal value = (BigDecimal)total.get(itemInfo3.getNumber());
                                sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo3.getDecDigital()).toString());
                            }
                        } else {
                            sb.append("&nbsp;");
                        }
                        sb.append("</td>");
                    }
                }
                num2 = lstCmpSchemeInfo.size();
                for (i2 = 0; i2 < num2; ++i2) {
                    schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i2);
                    privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                    if (privateItem == null) continue;
                    number = privateItem.size();
                    for (int j = 0; j < number; ++j) {
                        CmpItemInfo itemInfo5 = (CmpItemInfo)privateItem.get(j);
                        sb.append("<td ");
                        sb.append("width=\"140\" align=\"right\">");
                        if (!itemInfo5.getNumber().equals("FSAL029")) {
                            if (total.get(itemInfo5.getNumber() + "~" + schemeInfo.getId()) == null) {
                                sb.append("&nbsp;");
                            } else if (itemInfo5.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo5.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo5.getDataType() == ItemDataTypeEnum.INT) {
                                BigDecimal value = (BigDecimal)total.get(itemInfo5.getNumber() + "~" + schemeInfo.getId());
                                sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo5.getDecDigital()).toString());
                            }
                        }
                        sb.append("</td>");
                    }
                }
                tableHeight = (int)((double)tableHeight + 22.5);
                sb.append("</tr>");
            }
        } else if (isShowTimeDetail) {
            int i3;
            BigDecimal value;
            CmpItemInfo itemInfo6;
            CmpSchemeInfo schemeInfo;
            CmpItemInfo itemInfo7;
            int i4;
            key = null;
            total = new HashMap();
            String subTotalsFlag = "";
            HashMap<String, BigDecimal> subTotals = new HashMap<String, BigDecimal>();
            int cellCount = 0;
            Map.Entry entry = null;
            while (allItem.hasNext()) {
                entry = allItem.next();
                key = (String)entry.getKey();
                if (!key.equals(personId)) {
                    int number;
                    List privateItem;
                    int num3;
                    HashMap tempMap = (HashMap)mapData.get(key);
                    if (tempMap.size() == 0) continue;
                    if (!"".equals(subTotalsFlag) && !tempMap.get("fPeriodNum").toString().equals(subTotalsFlag)) {
                        sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                        num3 = lstAllSchemePerItems.size() + 1;
                        for (i4 = 0; i4 < num3; ++i4) {
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" ");
                            sb.append("width=\"140\"");
                            sb.append(" align=\"left\">");
                            sb.append("&nbsp;");
                            sb.append("</td>");
                        }
                        sb.append("<td colspan=\" ");
                        sb.append("");
                        sb.append("\" ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"left\">");
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"92_CompensationWebService", (Locale)ctx.getOriginLocale()));
                        sb.append("</td>");
                        sb.append("<td colspan=\" ");
                        sb.append("");
                        sb.append("\" ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"left\">");
                        sb.append("&nbsp;");
                        sb.append("</td>");
                        if (publicItem != null && publicItem.size() > 0) {
                            num3 = publicItem.size();
                            for (i4 = 0; i4 < num3; ++i4) {
                                itemInfo7 = (CmpItemInfo)publicItem.get(i4);
                                sb.append("<td ");
                                sb.append("width=\"140\"");
                                sb.append(" align=\"right\">");
                                if (subTotals.get(itemInfo7.getNumber()) != null) {
                                    if (itemInfo7.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo7.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo7.getDataType() == ItemDataTypeEnum.INT) {
                                        BigDecimal value2 = (BigDecimal)subTotals.get(itemInfo7.getNumber());
                                        sb.append(HRCmpItemUtils.formatBigDecimal(value2, itemInfo7.getDecDigital()).toString());
                                    }
                                } else {
                                    sb.append("&nbsp;");
                                }
                                sb.append("</td>");
                            }
                        }
                        num3 = lstCmpSchemeInfo.size();
                        for (i4 = 0; i4 < num3; ++i4) {
                            schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i4);
                            privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                            if (privateItem == null) continue;
                            number = privateItem.size();
                            for (int j = 0; j < number; ++j) {
                                itemInfo6 = (CmpItemInfo)privateItem.get(j);
                                sb.append("<td ");
                                sb.append("width=\"140\"");
                                sb.append(" align=\"right\">");
                                if (!itemInfo6.getNumber().equals("FSAL029")) {
                                    if (subTotals.get(itemInfo6.getNumber() + "~" + schemeInfo.getId()) == null) {
                                        sb.append("&nbsp;");
                                    } else if (itemInfo6.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo6.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo6.getDataType() == ItemDataTypeEnum.INT) {
                                        value = (BigDecimal)subTotals.get(itemInfo6.getNumber() + "~" + schemeInfo.getId());
                                        sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo6.getDecDigital()).toString());
                                    }
                                }
                                sb.append("</td>");
                            }
                        }
                        tableHeight = (int)((double)tableHeight + 22.5);
                        sb.append("</tr>");
                        sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\">");
                        subTotals.clear();
                    }
                    cellCount = 0;
                    sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                    num3 = lstAllSchemePerItems.size();
                    for (i4 = 0; i4 < num3; ++i4) {
                        itemInfo7 = (CmpItemInfo)lstAllSchemePerItems.get(i4);
                        sb.append("<td colspan=\" ");
                        sb.append("");
                        sb.append("\" align=\"left\" ");
                        sb.append("width=\"140\"");
                        sb.append(">");
                        if (tempMap.get(itemInfo7.getNumber()) != null) {
                            sb.append(tempMap.get(itemInfo7.getNumber()));
                        } else {
                            sb.append("&nbsp;");
                        }
                        sb.append("</td>");
                        ++cellCount;
                    }
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" align=\"left\" ");
                    sb.append("width=\"140\"");
                    sb.append(">");
                    sb.append(this.getPeriodDateByPeriodId(ctx, tempMap.get("fPeriodNum").toString()).getBeginDate());
                    sb.append("</td>");
                    ++cellCount;
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" align=\"left\" ");
                    sb.append("width=\"140\"");
                    sb.append(">");
                    sb.append(this.getPeriodDateByPeriodId(ctx, tempMap.get("fPeriodNum").toString()).getEndDate());
                    sb.append("</td>");
                    ++cellCount;
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" align=\"left\" ");
                    sb.append("width=\"140\"");
                    sb.append(">");
                    sb.append(tempMap.get("time"));
                    sb.append("</td>");
                    ++cellCount;
                    if (publicItem != null && publicItem.size() > 0) {
                        num3 = publicItem.size();
                        for (i4 = 0; i4 < num3; ++i4) {
                            itemInfo7 = (CmpItemInfo)publicItem.get(i4);
                            BigDecimal bg = null;
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (tempMap.get(itemInfo7.getNumber()) != null) {
                                if (itemInfo7.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo7.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value3 = (BigDecimal)tempMap.get(itemInfo7.getNumber());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value3, itemInfo7.getDecDigital()).toString());
                                } else {
                                    sb.append(tempMap.get(itemInfo7.getNumber()));
                                }
                                if (itemInfo7.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo7.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo7.getDataType() == ItemDataTypeEnum.INT) {
                                    if (subTotals.get(itemInfo7.getNumber()) != null) {
                                        bg = (BigDecimal)subTotals.get(itemInfo7.getNumber());
                                        bg = bg.add(new BigDecimal(tempMap.get(itemInfo7.getNumber()).toString()));
                                        subTotals.put(itemInfo7.getNumber(), bg);
                                    } else {
                                        bg = new BigDecimal(tempMap.get(itemInfo7.getNumber()).toString());
                                        subTotals.put(itemInfo7.getNumber(), bg);
                                    }
                                    if (total.get(itemInfo7.getNumber()) != null) {
                                        bg = (BigDecimal)total.get(itemInfo7.getNumber());
                                        bg = bg.add(new BigDecimal(tempMap.get(itemInfo7.getNumber()).toString()));
                                        total.put(itemInfo7.getNumber(), bg);
                                    } else {
                                        bg = new BigDecimal(tempMap.get(itemInfo7.getNumber()).toString());
                                        total.put(itemInfo7.getNumber(), bg);
                                    }
                                }
                            } else {
                                sb.append("nbsp;");
                            }
                            sb.append("</td>");
                            ++cellCount;
                        }
                    }
                    num3 = lstCmpSchemeInfo.size();
                    for (i4 = 0; i4 < num3; ++i4) {
                        schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i4);
                        privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                        if (privateItem == null) continue;
                        number = privateItem.size();
                        for (int j = 0; j < number; ++j) {
                            BigDecimal bg = null;
                            CmpItemInfo itemInfo8 = (CmpItemInfo)privateItem.get(j);
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()) == null) {
                                sb.append("&nbsp;");
                            } else {
                                if (itemInfo8.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo8.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value4 = (BigDecimal)tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value4, itemInfo8.getDecDigital()).toString());
                                } else {
                                    sb.append(tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()));
                                }
                                if (itemInfo8.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo8.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo8.getDataType() == ItemDataTypeEnum.INT) {
                                    if (subTotals.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()) != null) {
                                        bg = (BigDecimal)subTotals.get(itemInfo8.getNumber() + "~" + schemeInfo.getId());
                                        bg = bg.add(new BigDecimal(tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()).toString()));
                                        subTotals.put(itemInfo8.getNumber() + "~" + schemeInfo.getId(), bg);
                                    } else {
                                        bg = new BigDecimal(tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()).toString());
                                        subTotals.put(itemInfo8.getNumber() + "~" + schemeInfo.getId(), bg);
                                    }
                                    if (total.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()) != null) {
                                        bg = (BigDecimal)total.get(itemInfo8.getNumber() + "~" + schemeInfo.getId());
                                        bg = bg.add(new BigDecimal(tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()).toString()));
                                        total.put(itemInfo8.getNumber() + "~" + schemeInfo.getId(), bg);
                                    } else {
                                        bg = new BigDecimal(tempMap.get(itemInfo8.getNumber() + "~" + schemeInfo.getId()).toString());
                                        total.put(itemInfo8.getNumber() + "~" + schemeInfo.getId(), bg);
                                    }
                                }
                            }
                            sb.append("</td>");
                            ++cellCount;
                        }
                    }
                    subTotalsFlag = tempMap.get("fPeriodNum").toString();
                }
                tableHeight = (int)((double)tableHeight + 22.5);
                sb.append("</tr>");
            }
            sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
            int num4 = lstAllSchemePerItems.size() + 1;
            for (i3 = 0; i3 < num4; ++i3) {
                sb.append("<td colspan=\" ");
                sb.append("");
                sb.append("\" ");
                sb.append("width=\"140\"");
                sb.append(" align=\"left\">");
                sb.append("&nbsp;");
                sb.append("</td>");
            }
            sb.append("<td colspan=\" ");
            sb.append("");
            sb.append("\" ");
            sb.append("width=\"140\"");
            sb.append(" align=\"left\">");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"92_CompensationWebService", (Locale)ctx.getOriginLocale()));
            sb.append("</td>");
            sb.append("<td colspan=\" ");
            sb.append("");
            sb.append("\" ");
            sb.append("width=\"140\"");
            sb.append(" align=\"left\">");
            sb.append("&nbsp;");
            sb.append("</td>");
            if (publicItem != null && publicItem.size() > 0) {
                num4 = publicItem.size();
                for (i3 = 0; i3 < num4; ++i3) {
                    CmpItemInfo itemInfo9 = (CmpItemInfo)publicItem.get(i3);
                    sb.append("<td ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"right\">");
                    if (subTotals.get(itemInfo9.getNumber()) != null) {
                        if (itemInfo9.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo9.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo9.getDataType() == ItemDataTypeEnum.INT) {
                            BigDecimal value5 = (BigDecimal)subTotals.get(itemInfo9.getNumber());
                            sb.append(HRCmpItemUtils.formatBigDecimal(value5, itemInfo9.getDecDigital()).toString());
                        }
                    } else {
                        sb.append("&nbsp;");
                    }
                    sb.append("</td>");
                }
            }
            num4 = lstCmpSchemeInfo.size();
            for (i3 = 0; i3 < num4; ++i3) {
                CmpSchemeInfo schemeInfo2 = (CmpSchemeInfo)lstCmpSchemeInfo.get(i3);
                List privateItem = (List)mapAllSchemeItems.get(schemeInfo2.getId().toString());
                if (privateItem == null) continue;
                int number = privateItem.size();
                for (int j = 0; j < number; ++j) {
                    CmpItemInfo itemInfo10 = (CmpItemInfo)privateItem.get(j);
                    sb.append("<td ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"right\">");
                    if (!itemInfo10.getNumber().equals("FSAL029")) {
                        if (subTotals.get(itemInfo10.getNumber() + "~" + schemeInfo2.getId()) == null) {
                            sb.append("&nbsp;");
                        } else if (itemInfo10.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo10.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo10.getDataType() == ItemDataTypeEnum.INT) {
                            BigDecimal value6 = (BigDecimal)subTotals.get(itemInfo10.getNumber() + "~" + schemeInfo2.getId());
                            sb.append(HRCmpItemUtils.formatBigDecimal(value6, itemInfo10.getDecDigital()).toString());
                        }
                    }
                    sb.append("</td>");
                }
            }
            tableHeight = (int)((double)tableHeight + 22.5);
            sb.append("</tr>");
            sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\">");
            for (int cell = 0; cell < cellCount; ++cell) {
                sb.append("<td colspan=\" ");
                sb.append("");
                sb.append("\" ");
                sb.append("width=\"140\"");
                sb.append(" align=\"left\">");
                sb.append("&nbsp;");
                sb.append("</td>");
            }
            sb.append("</tr>");
            tableHeight = (int)((double)tableHeight + 22.5);
            subTotals.clear();
            for (int sum = 0; sum < 1; ++sum) {
                sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                int num5 = lstAllSchemePerItems.size() + 1;
                for (i4 = 0; i4 < num5; ++i4) {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append("&nbsp;");
                    sb.append("</td>");
                }
                if (sum == 0) {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append("</td>");
                } else {
                    sb.append("<td colspan=\" ");
                    sb.append("");
                    sb.append("\" ");
                    sb.append("width=\"140\"");
                    sb.append(" align=\"left\">");
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append("</td>");
                }
                sb.append("<td colspan=\" ");
                sb.append("");
                sb.append("\" ");
                sb.append("width=\"140\"");
                sb.append(" align=\"left\">");
                sb.append("&nbsp;");
                sb.append("</td>");
                if (publicItem != null && publicItem.size() > 0) {
                    num5 = publicItem.size();
                    for (i4 = 0; i4 < num5; ++i4) {
                        itemInfo7 = (CmpItemInfo)publicItem.get(i4);
                        sb.append("<td ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"right\">");
                        if (total.get(itemInfo7.getNumber()) != null) {
                            if (itemInfo7.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo7.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo7.getDataType() == ItemDataTypeEnum.INT) {
                                BigDecimal value7 = (BigDecimal)total.get(itemInfo7.getNumber());
                                sb.append(HRCmpItemUtils.formatBigDecimal(value7, itemInfo7.getDecDigital()).toString());
                            }
                        } else {
                            sb.append("&nbsp;");
                        }
                        sb.append("</td>");
                    }
                }
                num5 = lstCmpSchemeInfo.size();
                for (i4 = 0; i4 < num5; ++i4) {
                    schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i4);
                    List privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                    if (privateItem == null) continue;
                    int number = privateItem.size();
                    for (int j = 0; j < number; ++j) {
                        itemInfo6 = (CmpItemInfo)privateItem.get(j);
                        sb.append("<td ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"right\">");
                        if (!itemInfo6.getNumber().equals("FSAL029")) {
                            if (total.get(itemInfo6.getNumber() + "~" + schemeInfo.getId()) == null) {
                                sb.append("&nbsp;");
                            } else if (itemInfo6.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo6.getDataType() == ItemDataTypeEnum.FLOAT || itemInfo6.getDataType() == ItemDataTypeEnum.INT) {
                                value = (BigDecimal)total.get(itemInfo6.getNumber() + "~" + schemeInfo.getId());
                                sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo6.getDecDigital()).toString());
                            }
                        }
                        sb.append("</td>");
                    }
                }
                tableHeight = (int)((double)tableHeight + 22.5);
                sb.append("</tr>");
            }
        } else {
            Map.Entry entry = null;
            String key2 = null;
            while (allItem.hasNext()) {
                entry = allItem.next();
                key2 = (String)entry.getKey();
                if (!key2.equals(personId)) continue;
                HashMap tempMap = (HashMap)mapData.get(key2);
                for (int sum = 0; sum < 1; ++sum) {
                    CmpItemInfo itemInfo11;
                    int i5;
                    int num6;
                    sb.append("<tr height=\"21\" class=\"hr_table_content_bgColor\" align=\"right\">");
                    if (sum == 0) {
                        num6 = lstAllSchemePerItems.size();
                        for (i5 = 0; i5 < num6; ++i5) {
                            itemInfo11 = (CmpItemInfo)lstAllSchemePerItems.get(i5);
                            sb.append("<td colspan=\"");
                            sb.append("");
                            sb.append("\" ");
                            sb.append("width=\"140\"");
                            sb.append(" align=\"left\">");
                            if (tempMap.get(itemInfo11.getNumber()) != null) {
                                sb.append(tempMap.get(itemInfo11.getNumber()));
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                        }
                        sb.append("<td colspan=\"");
                        sb.append("");
                        sb.append("\" ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"left\">");
                        sb.append(cmpBeginPeriod.getBeginDate());
                        sb.append("</td>");
                        sb.append("<td colspan=\"");
                        sb.append("");
                        sb.append("\" ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"left\">");
                        sb.append(cmpEndPeriod.getEndDate());
                        sb.append("</td>");
                    } else {
                        int nullCellCount = lstAllSchemePerItems.size() + 1;
                        for (int i6 = 0; i6 < nullCellCount; ++i6) {
                            sb.append("<td colspan=\" ");
                            sb.append("");
                            sb.append("\" ");
                            sb.append("width=\"140\"");
                            sb.append(" align=\"left\">");
                            sb.append("&nbsp;");
                            sb.append("</td>");
                        }
                        sb.append("<td colspan=\" ");
                        sb.append("");
                        sb.append("\" ");
                        sb.append("width=\"140\"");
                        sb.append(" align=\"left\">");
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"11_BIReportCmpFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                        sb.append("</td>");
                    }
                    if (publicItem != null && publicItem.size() > 0) {
                        num6 = publicItem.size();
                        for (i5 = 0; i5 < num6; ++i5) {
                            itemInfo11 = (CmpItemInfo)publicItem.get(i5);
                            sb.append("<td align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (tempMap.get(itemInfo11.getNumber()) != null) {
                                if (itemInfo11.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo11.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value = (BigDecimal)tempMap.get(itemInfo11.getNumber());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo11.getDecDigital()).toString());
                                } else {
                                    sb.append(tempMap.get(itemInfo11.getNumber()));
                                }
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                        }
                    }
                    num6 = lstCmpSchemeInfo.size();
                    for (i5 = 0; i5 < num6; ++i5) {
                        CmpSchemeInfo schemeInfo = (CmpSchemeInfo)lstCmpSchemeInfo.get(i5);
                        List privateItem = (List)mapAllSchemeItems.get(schemeInfo.getId().toString());
                        if (privateItem == null) continue;
                        int number = privateItem.size();
                        for (int j = 0; j < number; ++j) {
                            CmpItemInfo itemInfo12 = (CmpItemInfo)privateItem.get(j);
                            sb.append("<td align=\"right\" ");
                            sb.append("width=\"140\"");
                            sb.append(">");
                            if (!itemInfo12.getNumber().equals("FSAL029")) {
                                if (tempMap.get(itemInfo12.getNumber() + "~" + schemeInfo.getId()) == null) {
                                    sb.append("&nbsp;");
                                } else if (itemInfo12.getDataType() == ItemDataTypeEnum.CURRENCY || itemInfo12.getDataType() == ItemDataTypeEnum.FLOAT) {
                                    BigDecimal value = (BigDecimal)tempMap.get(itemInfo12.getNumber() + "~" + schemeInfo.getId());
                                    sb.append(HRCmpItemUtils.formatBigDecimal(value, itemInfo12.getDecDigital()).toString());
                                } else {
                                    sb.append(tempMap.get(itemInfo12.getNumber() + "~" + schemeInfo.getId()));
                                }
                            }
                            sb.append("</td>");
                        }
                    }
                    tableHeight = (int)((double)tableHeight + 22.5);
                    sb.append("</tr>");
                }
            }
        }
        StringBuffer top = new StringBuffer();
        top.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"hr_table_bgColor\" ");
        top.append("width=\"" + tableWidth + "\" ");
        top.append(">");
        String buttom = "</table>";
        sb.insert(0, top);
        sb.append(buttom);
        return tableHeight;
    }
}

