/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.formulateutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CompenItemFormuleException;
import com.kingdee.eas.hr.compensation.formulateutil.AggMethodTrans;
import com.kingdee.eas.hr.compensation.formulateutil.FormulaTranslatorUtil;
import com.kingdee.eas.hr.compensation.formulateutil.PersonItemTrans;
import com.kingdee.eas.hr.compensation.formulateutil.SQLExprTrans;
import java.util.ArrayList;
import java.util.List;

public class ExprTrans {
    List personItemList = null;

    public SqlExpr transSqlExpr(Context ctx, SqlExpr expr, IObjectPK schPK) throws EASBizException, BOSException {
        this.personItemList = FormulaTranslatorUtil.getSchPerItem(ctx, schPK);
        SqlExpr newExpr = this.travel(ctx, expr, schPK);
        return newExpr;
    }

    private SqlExpr travel(Context ctx, SqlExpr expr, IObjectPK schPK) throws EASBizException, BOSException {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binary = (SqlBinaryOpExpr)expr;
            binary.left = this.travel(ctx, binary.left, schPK);
            binary.right = this.travel(ctx, binary.right, schPK);
        } else if (expr instanceof SqlMethodInvokeExpr) {
            List params = ((SqlMethodInvokeExpr)expr).parameters;
            if (params != null) {
                ArrayList<SqlExpr> newParamList = new ArrayList<SqlExpr>();
                int size = params.size();
                for (int i = 0; i < size; ++i) {
                    SqlExpr paramExpr = (SqlExpr)params.get(i);
                    newParamList.add(this.travel(ctx, paramExpr, schPK));
                }
                ((SqlMethodInvokeExpr)expr).parameters = newParamList;
            }
            expr = this.transform(ctx, schPK, expr);
        } else if (expr instanceof SqlAggregateExpr) {
            List params = ((SqlAggregateExpr)expr).paramList;
            if (params != null) {
                ArrayList<SqlExpr> newParamList = new ArrayList<SqlExpr>();
                int size = params.size();
                for (int i = 0; i < size; ++i) {
                    SqlExpr paramExpr = (SqlExpr)params.get(i);
                    newParamList.add(this.travel(ctx, paramExpr, schPK));
                }
                ((SqlAggregateExpr)expr).paramList = newParamList;
            }
            expr = this.transform(ctx, schPK, expr);
        } else {
            expr = this.transform(ctx, schPK, expr);
        }
        return expr;
    }

    private SqlExpr transform(Context ctx, IObjectPK schPK, SqlExpr expr) throws EASBizException, BOSException {
        SQLExprTrans trans = null;
        if (expr instanceof SqlAggregateExpr) {
            trans = new AggMethodTrans(ctx, schPK);
            return trans.doExprTrans((SqlExpr)((SqlAggregateExpr)expr));
        }
        if (expr instanceof SqlIdentifierExpr && this.isPersonItem(expr)) {
            trans = new PersonItemTrans(ctx, schPK);
            return trans.doExprTrans(expr);
        }
        return expr;
    }

    private boolean isPersonItem(SqlExpr expr) throws CompenItemFormuleException {
        if (this.personItemList != null) {
            StringBuffer buff = new StringBuffer();
            try {
                DrSQLFormater formater = new DrSQLFormater(buff);
                formater.formatExpr(expr);
            }
            catch (FormaterException e) {
                throw new CompenItemFormuleException(CompenItemFormuleException.FORMAT_SQL_EXEC, e);
            }
            String idNumber = "";
            int size = this.personItemList.size();
            for (int i = 0; i < size; ++i) {
                idNumber = (String)this.personItemList.get(i);
                if (!idNumber.equals(buff.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

