/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpFormulaInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CompenItemFormuleException;
import com.kingdee.eas.hr.compensation.DateUnitEnum;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AccountFormulaUtils {
    private static Logger logger = Logger.getLogger(AccountFormulaUtils.class);
    public static final String ALIAS = "ALIAS";
    public static final String FORMULA = "FORMULA";
    public static final String FORMULA_NAME = "FORMULA_NAME";
    public static final String SCHMITEMFORMULAMAP = "SCHMITEMFORMULAMAP";
    public static final String ITEMNUM = "ITEMNUM";
    public static final String ITEMNAME = "ITEMNAME";
    public static final String PARAM_TYPE_MODEL = "model";
    public static final String PARAM_TYPE_SCHM = "schm";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_ID = "id";
    public static final String PARAM_DATA = "data";
    public static final String PARAM_INIT_FORMULASTR = "init_formulaStr";
    private static HashMap mapFormulaName = new HashMap(256);
    private static boolean loadFormulaName = false;

    private static void loadFormulaName() {
        if (loadFormulaName) {
            return;
        }
        loadFormulaName = true;
        String fname = "fname_" + SysContext.getSysContext().getLocale().getLanguage();
        String sql = "select fnumber," + fname + " from t_hr_cmpitem ";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = executor.executeSQL();
            while (rs.next()) {
                mapFormulaName.put(rs.getString(1).trim(), rs.getString(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FormulaEditResult getFormula(FormulaBuilderPanelBean formulaBean) throws Exception {
        Hashtable<String, String> rst = new Hashtable<String, String>();
        FormulaEditResult formulaData = null;
        if (formulaBean != null) {
            String formula = formulaBean.getFormulaStr();
            String formulaAlias = formulaBean.getFormulaAliasStr();
            if (formulaAlias != null) {
                rst.put(ALIAS, formulaAlias);
            } else {
                rst.put(FORMULA, "");
            }
            if (formula != null && formula.trim().length() > 0) {
                rst.put(FORMULA, formula);
                formulaData = new FormulaEditResult(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"FormulaF7Tips_YES"), rst);
            } else {
                rst.put(FORMULA, "");
                formulaData = new FormulaEditResult(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"FormulaF7Tips_NO"), rst);
            }
        }
        return formulaData;
    }

    public static FormulaEditResult getFormula(CmpFormulaInfo cmpfInfo) throws Exception {
        if (cmpfInfo == null) {
            return null;
        }
        Hashtable<String, String> rst = new Hashtable<String, String>();
        FormulaEditResult formulaData = null;
        String formulaDesc = cmpfInfo.getFormulaDesc();
        String formula = cmpfInfo.getFormula();
        if (formulaDesc != null) {
            rst.put(ALIAS, formula);
        } else {
            rst.put(ALIAS, "");
        }
        if (formula != null && formula.trim().length() > 0) {
            rst.put(FORMULA, cmpfInfo.getId().toString());
            formulaData = new FormulaEditResult(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"FormulaF7Tips_YES"), rst);
        } else {
            rst.put(FORMULA, "");
            formulaData = new FormulaEditResult(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"FormulaF7Tips_NO"), rst);
        }
        return formulaData;
    }

    public static FormulaCmpItemData[] getCmpItemList(List cmpItemList) throws Exception {
        if (cmpItemList == null) {
            return new FormulaCmpItemData[1];
        }
        String strHrOrgId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        IFormulaFacade formula = FormulaFacadeFactory.getRemoteInstance();
        cmpItemList.add("formula@@@20120328");
        Map rst = formula.getAllCmpItemInstanceList(cmpItemList, strHrOrgId);
        FormulaCmpItemData[] itemData = null;
        if (rst != null) {
            itemData = new FormulaCmpItemData[rst.size()];
            Iterator itl = rst.entrySet().iterator();
            int i = 0;
            Map.Entry entry = null;
            while (itl.hasNext()) {
                entry = itl.next();
                itemData[i] = (FormulaCmpItemData)entry.getValue();
                ++i;
            }
        }
        if (itemData != null) {
            return itemData;
        }
        itemData = new FormulaCmpItemData[]{new FormulaCmpItemData()};
        return itemData;
    }

    public static IHRObject[] getCmpItemInstList(FormulaCmpItemData[] itemDataList) {
        IHRObject[] enumArray = null;
        if (itemDataList == null) {
            enumArray = new IHRObject[]{new FormulaCmpItemData()};
            return enumArray;
        }
        ArrayList<IHRObject> enumList = new ArrayList<IHRObject>();
        FormulaCmpItemData data2 = null;
        for (FormulaCmpItemData data2 : itemDataList) {
            if (data2.getCmpItemInstList() == null) continue;
            int jsize = data2.getCmpItemInstList().length;
            for (int j = 0; j < jsize; ++j) {
                enumList.add(data2.getCmpItemInstList()[j]);
            }
        }
        enumArray = new IHRObject[enumList.size()];
        int size = enumList.size();
        for (int i = 0; i < size; ++i) {
            enumArray[i] = (IHRObject)enumList.get(i);
        }
        return enumArray;
    }

    public static void checkFormula(String itemNum, String itemName, String soureFormula, HashSet soureFormulaItemsNum, Map itemFormulaMap, String itemRegex, String personItemRegex) throws CompenItemFormuleException {
        if (StringUtils.isEmpty((String)soureFormula)) {
            return;
        }
        try {
            String formula = soureFormula.trim();
            AccountFormulaUtils.checkFormulaSelf(formula, personItemRegex);
            String key = AccountFormulaUtils.getFormulaKey(formula);
            if (key == null || key.length() == 0 || !key.trim().equals(itemNum)) {
                AccountFormulaUtils.loadFormulaName();
                String msg = key;
                if (mapFormulaName.containsKey(key)) {
                    msg = mapFormulaName.get(key).toString();
                }
                throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_DEF_FOR_OTHERITEM, new String[]{msg, itemName});
            }
            AccountFormulaUtils.checkFormulaItemIncludeSchemeItems(soureFormulaItemsNum, itemFormulaMap);
            if (itemRegex != null && itemRegex.length() > 0) {
                HashMap needCheckFormulaMap = AccountFormulaUtils.removeSpecialFunctionFormula(itemFormulaMap);
                String newFormula = AccountFormulaUtils.beforeDependCheck(formula);
                AccountFormulaUtils.dependCheck(itemNum, newFormula, needCheckFormulaMap, itemRegex);
            }
        }
        catch (ParserException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static void checkFormulaItemIncludeSchemeItems(HashSet soureFormulaItemsNum, Map itemFormulaMap) throws CompenItemFormuleException, BOSException {
        if (soureFormulaItemsNum == null) {
            return;
        }
        Object[] itemList = soureFormulaItemsNum.toArray();
        StringBuffer notExistNames = new StringBuffer();
        int size = itemList.length;
        for (int i = 0; i < size; ++i) {
            String itemNum = itemList[i].toString();
            if (itemNum != null && itemNum.startsWith("FPER") || itemFormulaMap.containsKey(itemNum)) continue;
            String strHrOrgId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            CmpItemCollection cmpItemCol = CmpItemFactory.getRemoteInstance().getCmpItemCollection("where number = '" + itemNum + "' and hrOrgUnit.id = '" + strHrOrgId + "'");
            if (cmpItemCol.size() <= 0) continue;
            if (!notExistNames.toString().equals("")) {
                notExistNames.append(",");
            }
            notExistNames.append(cmpItemCol.get(0).getName());
        }
        if (!notExistNames.toString().equals("")) {
            throw new CompenItemFormuleException(CompenItemFormuleException.FORMULAITEM_NOTIN_SCHEMEITEMS, new String[]{notExistNames.toString()});
        }
    }

    public static void checkFormulaSelf(String soureFormula, String personItemRegex, CmpItemInfo isRefByScheItem) throws CompenItemFormuleException, BOSException {
        AccountFormulaUtils.checkFormulaSelf(soureFormula, personItemRegex);
        if (isRefByScheItem == null) {
            return;
        }
        String formula = soureFormula.trim();
        String key = AccountFormulaUtils.getFormulaKey(formula);
        if (key == null || key.length() == 0 || !key.trim().equals(isRefByScheItem.getNumber())) {
            AccountFormulaUtils.loadFormulaName();
            String msg = key;
            if (mapFormulaName.containsKey(key)) {
                msg = mapFormulaName.get(key).toString();
            }
            throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_DEF_FOR_OTHERITEM_1, new String[]{isRefByScheItem.getName(), msg});
        }
    }

    public static void checkFormulaSelf(String soureFormula, String personItemRegex) throws CompenItemFormuleException, BOSException {
        if (StringUtils.isEmpty((String)soureFormula)) {
            return;
        }
        try {
            String formula = soureFormula.trim();
            AccountFormulaUtils.checkFormulaContainsPointItem(formula, "FSAL000");
            KScriptParser parser = new KScriptParser(formula);
            parser.parse();
            List stmts = parser.stmtList;
            if (stmts == null) {
                return;
            }
            if (stmts.size() != 1) {
                throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_MOREEXPR_EXEC);
            }
            Object obj = stmts.get(0);
            if (!(obj instanceof IfStmt) && !(obj instanceof ExprStmt)) {
                throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_NOTSUPPORTSTMT_EXEC);
            }
            if (obj instanceof ExprStmt) {
                ExprStmt exprStmt = (ExprStmt)obj;
                CodeExpr expr = exprStmt.expr;
                if (expr instanceof BinaryOpExpr) {
                    BinaryOpExpr binaryExpr = (BinaryOpExpr)expr;
                    if (binaryExpr.operator != 2) {
                        throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_EXPRSTMT_ASSIGN);
                    }
                }
                AccountFormulaUtils.checkDependPersonItem(expr, personItemRegex);
            }
            if (obj instanceof IfStmt) {
                IfStmt ifStmt = (IfStmt)obj;
                List tureStmtList = ifStmt.trueStmtList;
                int size = tureStmtList.size();
                for (int i = 0; i < size; ++i) {
                    ExprStmt exprStmt = (ExprStmt)tureStmtList.get(i);
                    AccountFormulaUtils.checkDependPersonItem(exprStmt.expr, personItemRegex);
                }
                List elseifList = ifStmt.elseIfList;
                int size2 = elseifList.size();
                for (int i = 0; i < size2; ++i) {
                    ElseIfItem item = (ElseIfItem)elseifList.get(i);
                    List elseifExprList = item.stmtList;
                    int jsize = elseifExprList.size();
                    for (int j = 0; j < jsize; ++j) {
                        ExprStmt elseIfExprStmt = (ExprStmt)elseifExprList.get(j);
                        AccountFormulaUtils.checkDependPersonItem(elseIfExprStmt.expr, personItemRegex);
                    }
                }
                List elseList = ifStmt.elseStmtList;
                int size3 = elseList.size();
                for (int i = 0; i < size3; ++i) {
                    ExprStmt exprStmt = (ExprStmt)elseList.get(i);
                    AccountFormulaUtils.checkDependPersonItem(exprStmt.expr, personItemRegex);
                }
            }
        }
        catch (ParserException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
        catch (ClassCastException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
    }

    private static boolean checkDependPersonItem(CodeExpr expr, String personItemRegex) throws CompenItemFormuleException, BOSException {
        boolean rst = false;
        if (expr == null || StringUtils.isEmpty((String)personItemRegex)) {
            return rst;
        }
        if (!(expr instanceof BinaryOpExpr)) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        BinaryOpExpr binaryExpr = (BinaryOpExpr)expr;
        StringBuffer formula = new StringBuffer();
        try {
            binaryExpr.right.output(formula);
        }
        catch (Exception e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        AccountFormulaUtils.checkFormulaLeft(binaryExpr, personItemRegex);
        AccountFormulaUtils.isCorrectFunction_get_adjust_age(formula);
        AccountFormulaUtils.isCorrectFunction_getYMD(formula);
        AccountFormulaUtils.checkItemValueFunction(formula);
        return rst;
    }

    private static boolean checkFormulaLeft(BinaryOpExpr binaryExpr, String personItemRegex) throws CompenItemFormuleException {
        StringBuffer leftFormula = new StringBuffer();
        try {
            binaryExpr.left.output(leftFormula);
        }
        catch (Exception e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        Pattern p = Pattern.compile(personItemRegex);
        Matcher m = p.matcher(leftFormula.toString());
        if (m.find()) {
            throw new CompenItemFormuleException(CompenItemFormuleException.HAVE_INCORRECT_ITEMNUMBER);
        }
        return true;
    }

    private static boolean checkFormulaContainsPointItem(String formula, String fSalPointItemRegex) throws CompenItemFormuleException, BOSException {
        Pattern p1 = Pattern.compile(fSalPointItemRegex);
        Matcher m1 = p1.matcher(formula);
        if (m1.find()) {
            throw new CompenItemFormuleException(CompenItemFormuleException.FSALITM_IN_EXPR_RIGTH);
        }
        return true;
    }

    private static boolean isCorrectFunction_get_adjust_age(StringBuffer rightFormula) throws CompenItemFormuleException, BOSException {
        int adjustFun_beforeIndex = rightFormula.indexOf("get_adjust_age", 1);
        if (adjustFun_beforeIndex >= 0) {
            int beginIndex = rightFormula.indexOf("(", adjustFun_beforeIndex);
            int endIndex = rightFormula.indexOf(")", adjustFun_beforeIndex);
            String allParams = rightFormula.substring(beginIndex + 1, endIndex);
            AccountFormulaUtils.checkGetAdjustAgeFormat(allParams);
            rightFormula.replace(adjustFun_beforeIndex, endIndex + 1, "1");
            return AccountFormulaUtils.isCorrectFunction_get_adjust_age(rightFormula);
        }
        return true;
    }

    private static boolean isCorrectFunction_getYMD(StringBuffer rightFormula) throws CompenItemFormuleException, BOSException {
        int adjustFun_beforeIndex = rightFormula.indexOf("get_y_m_d", 1);
        if (adjustFun_beforeIndex >= 0) {
            int beginIndex = rightFormula.indexOf("(", adjustFun_beforeIndex);
            int endIndex = rightFormula.indexOf(")", adjustFun_beforeIndex);
            String allParams = rightFormula.substring(beginIndex + 1, endIndex);
            AccountFormulaUtils.checkGetYMDFormat(allParams);
            rightFormula.replace(adjustFun_beforeIndex, endIndex + 1, "1");
        }
        return true;
    }

    private static boolean checkGetYMDFormat(String adjustFunParams) throws CompenItemFormuleException, BOSException {
        int i;
        if (adjustFunParams == null) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARAMS_NUMBER_ERROR);
        }
        if (adjustFunParams.split(",").length != 2) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARAMS_NUMBER_ERROR);
        }
        String[] params = adjustFunParams.split(",");
        String strHROrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String oql = "select name,number where dataType =20 and subject=10 and number like 'FPER%' and hrOrgUnit = '" + strHROrgUnitId + "'";
        CmpItemCollection itemCol = CmpItemFactory.getRemoteInstance().getCmpItemCollection(oql);
        StringBuffer dataNumber = new StringBuffer();
        dataNumber.append("currentDate,PeriodBeginDate,PeriodEndDate");
        for (i = 0; i < itemCol.size(); ++i) {
            dataNumber.append(",");
            dataNumber.append(itemCol.get(i).getNumber());
        }
        for (i = 0; i < 2; ++i) {
            if (params[i] == null || params[i].length() <= 2 || !params[i].trim().startsWith("\"") || !params[i].trim().endsWith("\"")) continue;
            params[i] = params[i].trim().substring(1, params[i].trim().length() - 1).trim();
        }
        Pattern p1 = Pattern.compile(params[0]);
        Matcher m1 = p1.matcher(dataNumber.toString());
        if (!m1.find()) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        List dateTypeList = DateUnitEnum.getEnumList();
        DateUnitEnum dateType = null;
        boolean flag = false;
        for (int i2 = 0; i2 < dateTypeList.size(); ++i2) {
            dateType = (DateUnitEnum)((Object)dateTypeList.get(i2));
            if (!dateType.getName().equalsIgnoreCase(params[1].trim())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        return true;
    }

    private static boolean checkGetAdjustAgeFormat(String adjustFunParams) throws CompenItemFormuleException, BOSException {
        if (adjustFunParams == null) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARAMS_NUMBER_ERROR);
        }
        String[] params = adjustFunParams.split(",");
        if (params.length != 3) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARAMS_NUMBER_ERROR);
        }
        Map paramsMap = AccountFormulaUtils.getAdjustAgeFunParam();
        for (int i = 0; i < 3; ++i) {
            boolean include = false;
            if (params[i] != null && params[i].length() > 2 && params[i].trim().startsWith("\"") && params[i].trim().endsWith("\"")) {
                params[i] = params[i].trim().substring(1, params[i].trim().length() - 1).trim();
            }
            String[] canIncludeParams = (String[])paramsMap.get("arg" + i);
            for (int j = 0; j < canIncludeParams.length; ++j) {
                if (!params[i].trim().equalsIgnoreCase(canIncludeParams[j])) continue;
                include = true;
                break;
            }
            if (include) continue;
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        return true;
    }

    private static Map getAdjustAgeFunParam() throws BOSException {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        String strHROrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String oqlDate = "select number where dataType =20 and number like 'FPER%' and hrOrgUnit = '" + strHROrgUnitId + "'";
        long t1 = System.currentTimeMillis();
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        String log = "CmpItemFactory.getRemoteInstance";
        logger.info((Object)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"749_AccountFormulaUtils", (String[])new String[]{log, String.valueOf(System.currentTimeMillis() - t1)}));
        t1 = System.currentTimeMillis();
        CmpItemCollection dateParams = iCmpItem.getCmpItemCollection(oqlDate);
        String log2 = "CmpItemFactory.getRemoteInstance";
        logger.info((Object)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"749_AccountFormulaUtils", (String[])new String[]{log2, String.valueOf(System.currentTimeMillis() - t1)}));
        int dateSize = dateParams.size();
        String[] dataNumber = new String[dateSize + 1];
        dataNumber[0] = "currentDate";
        for (int i = 0; i < dateParams.size(); ++i) {
            dataNumber[i + 1] = dateParams.get(i).getNumber();
        }
        paramsMap.put("arg0", dataNumber);
        paramsMap.put("arg1", dataNumber);
        String oqlFloat = "select name,number where dataType =50 and number like 'FPER%' and hrOrgUnit = '" + strHROrgUnitId + "'";
        CmpItemCollection adjustValueParams = iCmpItem.getCmpItemCollection(oqlFloat);
        int floatSize = adjustValueParams.size();
        String[] floatNumber = new String[floatSize + 1];
        floatNumber[0] = "0";
        for (int i = 0; i < adjustValueParams.size(); ++i) {
            floatNumber[i + 1] = adjustValueParams.get(i).getNumber();
        }
        paramsMap.put("arg2", floatNumber);
        return paramsMap;
    }

    public static String getFormulaKey(String formula) throws ParserException, CompenItemFormuleException {
        if (formula == null || formula.length() == 0) {
            return null;
        }
        KScriptParser parser = new KScriptParser(formula);
        parser.parse();
        List stmts = parser.stmtList;
        CodeStmt stmt = (CodeStmt)stmts.get(0);
        if (stmt instanceof ExprStmt) {
            ExprStmt exprStmt = (ExprStmt)stmt;
            return AccountFormulaUtils.getExprKey(exprStmt.expr);
        }
        if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            if (ifStmt.trueStmtList != null) {
                CodeExpr expr = ((ExprStmt)ifStmt.trueStmtList.get((int)0)).expr;
                return AccountFormulaUtils.getExprKey(expr);
            }
            if (ifStmt.elseIfList != null) {
                CodeExpr expr = ((ExprStmt)ifStmt.elseIfList.get((int)0)).expr;
                return AccountFormulaUtils.getExprKey(expr);
            }
        }
        return null;
    }

    public static boolean checkFromula(String formula, String item) throws ParserException, CompenItemFormuleException {
        String key = AccountFormulaUtils.getFormulaKey(formula);
        return key.compareToIgnoreCase(item) == 0;
    }

    private static String getExprKey(CodeExpr expr) throws CompenItemFormuleException {
        if (expr == null | !(expr instanceof BinaryOpExpr)) {
            return null;
        }
        BinaryOpExpr binaryExpr = (BinaryOpExpr)expr;
        if (binaryExpr.operator == 2) {
            StringBuffer buff = new StringBuffer();
            try {
                binaryExpr.left.output(buff);
            }
            catch (Exception e) {
                throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
            }
            return buff.toString();
        }
        return null;
    }

    private static void checkItemValueFunction(StringBuffer rightFormula) throws CompenItemFormuleException {
        if (rightFormula == null || rightFormula.toString().trim().length() <= 0) {
            return;
        }
        String strFormula = rightFormula.toString().replaceAll(" ", "");
        if (strFormula.toLowerCase().indexOf("itemvalue_abs_period") != -1 || strFormula.toLowerCase().indexOf("itemvalue_rel_period") != -1) {
            HashMap mapRel;
            HashMap mapAbs = AccountFormulaUtils.getItemValueParams(strFormula, "itemvalue_abs_period");
            if (mapAbs != null) {
                strFormula = (String)mapAbs.get("newFormula");
                AccountFormulaUtils.checkItemValueFunctionParams(null, (String)mapAbs.get("cmpPeriod"), (String)mapAbs.get("cmpSchemeNumber"), (String)mapAbs.get("cmpitemNumber"));
            }
            if ((mapRel = AccountFormulaUtils.getItemValueParams(strFormula, "itemvalue_rel_period")) != null) {
                strFormula = (String)mapRel.get("newFormula");
                AccountFormulaUtils.checkItemValueFunctionParams(null, null, (String)mapRel.get("cmpSchemeNumber"), (String)mapRel.get("cmpitemNumber"));
            }
            AccountFormulaUtils.checkItemValueFunction(new StringBuffer(strFormula));
        }
    }

    public static void checkItemValueFunctionParams(Context ctx, String cmpPeriod, String cmpSchemeNumber, String cmpItemNumber) throws CompenItemFormuleException {
        String strHrOrgUnitId = null;
        ICmpPeriod iPeriod = null;
        ICmpScheme iScheme = null;
        ICmpSchemeItem iSchemeItem = null;
        try {
            if (ctx == null) {
                strHrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
                iPeriod = CmpPeriodFactory.getRemoteInstance();
                iScheme = CmpSchemeFactory.getRemoteInstance();
                iSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
            } else {
                strHrOrgUnitId = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
                iPeriod = CmpPeriodFactory.getLocalInstance(ctx);
                iScheme = CmpSchemeFactory.getLocalInstance(ctx);
                iSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
            }
            EntityViewInfo view = null;
            FilterInfo filter = null;
            SelectorItemCollection sic = null;
            if (cmpPeriod != null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("hrorgunit.id", (Object)strHrOrgUnitId));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)cmpPeriod));
                view.setFilter(filter);
                sic = view.getSelector();
                sic.add(new SelectorItemInfo(PARAM_ID));
                CmpPeriodCollection periodCol = iPeriod.getCmpPeriodCollection(view);
                if (periodCol.size() <= 0) {
                    throw new CompenItemFormuleException(CompenItemFormuleException.FORMULA_PERIOD_NOTEXIST);
                }
            }
            if (!StringUtils.isEmpty((String)cmpSchemeNumber)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("hrorgunit.id", (Object)strHrOrgUnitId));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)cmpSchemeNumber));
                filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
                view.setFilter(filter);
                sic = view.getSelector();
                sic.add(new SelectorItemInfo(PARAM_ID));
                CmpSchemeCollection schemeCol = iScheme.getCmpSchemeCollection(view);
                if (schemeCol.size() <= 0) {
                    throw new CompenItemFormuleException(CompenItemFormuleException.FORMULA_SCHEME_NOTEXIST);
                }
            }
            if (cmpItemNumber != null && !StringUtils.isEmpty((String)cmpSchemeNumber)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("cmpScheme.hrOrgUnit.id", (Object)strHrOrgUnitId));
                filter.getFilterItems().add(new FilterItemInfo("cmpScheme.number", (Object)cmpSchemeNumber));
                filter.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)strHrOrgUnitId));
                filter.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)cmpItemNumber));
                view.setFilter(filter);
                sic = view.getSelector();
                sic.add(new SelectorItemInfo(PARAM_ID));
                CmpSchemeItemCollection schemeItemCol = iSchemeItem.getCmpSchemeItemCollection(view);
                if (schemeItemCol.size() <= 0) {
                    throw new CompenItemFormuleException(CompenItemFormuleException.FORMULA_ITEM_NOTEXIST);
                }
            }
        }
        catch (BOSException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
    }

    public static HashMap getItemValueParams(String strRightFormula, String functionName) throws CompenItemFormuleException {
        int begin = strRightFormula.toLowerCase().indexOf(functionName);
        if (begin < 0) {
            return null;
        }
        int innerBegin = strRightFormula.indexOf("(", begin);
        if (innerBegin < 0) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        int innerEnd = strRightFormula.indexOf(")", innerBegin);
        if (innerEnd < 0) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        String strInner = strRightFormula.substring(innerBegin + 1, innerEnd);
        String[] strAll = strInner.split(",");
        if (strAll == null || strAll.length != 3 && strAll.length != 6) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC);
        }
        for (int i = 0; i < strAll.length; ++i) {
            if (strAll[i].indexOf("\"") < 0) continue;
            strAll[i] = strAll[i].substring(strAll[i].indexOf("\"") + 1, strAll[i].lastIndexOf("\"")).trim();
        }
        String periodDif = strAll[0];
        String cmpSchemeNumber = strAll[1];
        String cmpitemNumber = strAll[2];
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmpPeriod", periodDif);
        map.put("cmpSchemeNumber", cmpSchemeNumber);
        map.put("cmpitemNumber", cmpitemNumber);
        if (strAll.length == 6) {
            map.put("timeType", strAll[3]);
            map.put("beginTime", strAll[4]);
            map.put("endTime", strAll[5]);
        } else {
            map.put("timeType", "");
            map.put("beginTime", "");
            map.put("endTime", "");
        }
        String funStr = strRightFormula.substring(begin, innerEnd + 1);
        strRightFormula = StringUtils.replace((String)strRightFormula, (String)funStr, (String)"");
        map.put("newFormula", strRightFormula);
        return map;
    }

    protected static String beforeDependCheck(String strFormula) {
        if (strFormula.toLowerCase().indexOf("itemvalue_abs_period") == -1 && strFormula.toLowerCase().indexOf("itemvalue_rel_period") == -1) {
            return strFormula;
        }
        String newFormula = null;
        if (strFormula.toLowerCase().indexOf("itemvalue_abs_period") != -1) {
            int posBefore = strFormula.indexOf("itemvalue_abs_period", 1);
            int endIndex = strFormula.indexOf(")", posBefore);
            String tempFun = strFormula.substring(posBefore, endIndex + 1);
            newFormula = StringUtils.replace((String)strFormula, (String)tempFun, (String)"1");
            return AccountFormulaUtils.beforeDependCheck(newFormula);
        }
        if (strFormula.toLowerCase().indexOf("itemvalue_rel_period") != -1) {
            int posBefore = strFormula.indexOf("itemvalue_rel_period", 1);
            int endIndex = strFormula.indexOf(")", posBefore);
            String tempFun = strFormula.substring(posBefore, endIndex + 1);
            newFormula = StringUtils.replace((String)strFormula, (String)tempFun, (String)"1");
            return AccountFormulaUtils.beforeDependCheck(newFormula);
        }
        return strFormula;
    }

    private static HashMap removeSpecialFunctionFormula(Map itemFormulaMap) {
        HashMap rtnMap = (HashMap)((HashMap)itemFormulaMap).clone();
        ArrayList lstRemove = new ArrayList();
        Iterator itor = rtnMap.entrySet().iterator();
        String strFormula = null;
        Map.Entry entry = null;
        while (itor.hasNext()) {
            Map obj;
            FormulaEditResult rst;
            entry = itor.next();
            Object key = entry.getKey();
            if (key == null || (rst = (FormulaEditResult)entry.getValue()) == null || (obj = rst.getFormulaDesc()) == null || (strFormula = (String)obj.get(ALIAS)).toLowerCase().indexOf("itemvalue_abs_period") == -1 && strFormula.toLowerCase().indexOf("itemvalue_rel_period") == -1) continue;
            lstRemove.add(key);
        }
        int size = lstRemove.size();
        for (int i = 0; i < size; ++i) {
            rtnMap.remove(lstRemove.get(i));
        }
        return rtnMap;
    }

    protected static boolean dependCheck(String itemNum, String formula, Map itemFormulaMap, String regex) throws CompenItemFormuleException, ParserException {
        if (formula == null || formula.length() == 0 || formula.indexOf("=") < 0) {
            return false;
        }
        String formulaKey = AccountFormulaUtils.getFormulaKey(formula);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(formula);
        HashSet<String> depItemSet = new HashSet<String>();
        int start = 0;
        int end = 0;
        while (m.find()) {
            start = m.start();
            String depItemNum = formula.substring(start, end = m.end());
            if (depItemNum.equals(formulaKey)) continue;
            depItemSet.add(depItemNum);
        }
        for (String key : depItemSet) {
            FormulaEditResult rst;
            Map obj;
            if (key.equals(itemNum)) {
                AccountFormulaUtils.loadFormulaName();
                String msg = formulaKey;
                if (mapFormulaName.containsKey(formulaKey)) {
                    msg = mapFormulaName.get(formulaKey).toString();
                }
                throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_DEPEND_NEST, new String[]{msg});
            }
            Object value = itemFormulaMap.get(key);
            String depFormula = null;
            if (value == null || (obj = (rst = (FormulaEditResult)value).getFormulaDesc()) == null) continue;
            depFormula = (String)obj.get(ALIAS);
            AccountFormulaUtils.dependCheck(itemNum, depFormula, itemFormulaMap, regex);
        }
        return false;
    }

    private static String parserErrorMsg(ParserException e) {
        String exec = e.getMessage();
        String row = exec.substring(exec.lastIndexOf("line") + 4, exec.lastIndexOf("column"));
        int pos = (row = row.trim()).lastIndexOf(",");
        if (pos > 0) {
            row = row.substring(0, pos);
        }
        String column = exec.substring(exec.lastIndexOf("column") + 6, exec.lastIndexOf(")"));
        column = column.trim();
        return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FormulaResource", (String)"Formula_Syntax_Error"), row, column);
    }

    public static class FormulaEditResult {
        private Map formulaDesc = null;
        private String label = "";

        public FormulaEditResult(String label, Map rst) {
            this.label = label;
            this.formulaDesc = rst;
        }

        public String toString() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }

        protected void setFormulaDesc(Map rst) {
            this.formulaDesc = rst;
        }

        public Map getFormulaDesc() {
            return this.formulaDesc;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

