/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.BgDimItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class HRReportUtils {
    private static Logger logger = Logger.getLogger(HRReportUtils.class);
    public static final String REPORT_PERIOD_BEGINDATE_NUMBER = "FBeginDate";
    public static final String REPORT_PERIOD_ENDDATE_NUMBER = "FEndDate";
    public static final String REPORT_DATA = "reportData";
    public static final String SCHEME_ID = "schemeID";
    public static final String TABLE_NAME = "tableName";
    public static final String TABLE_COLUMN = "tableColumn";
    public static final String AVG = "AVG";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String SUM = "SUM";
    public static final String COUNT = "COUNT";
    public static final String TOTAL = "TOTAL";
    public static final String RATE = "RATE";
    public static final String REPORT_ADMINORGUNITCOLL = "AdminOrgUnitColl";
    public static final String REPORT_HRORGUNIT_ID = "report_hrorgunit_id";
    public static final String REPORT_ADMINORGUNIT = "AdminOrgUnit";
    public static final String REPORT_ISCONTAINCHILDRED = "isContainChildren";
    public static final String REPORT_EMPLOYEETYPE = "EmployeeType";
    public static final String REPORT_PERSONNAME = "PersonName";
    public static final String REPORT_PERSONNUMBER = "PersonNumber";
    public static final String REPORT_ISAUDITOFSCHEME = "isNeedAduitOfScheme";
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final Color UNEDIT_COLOR = new Color(0xE8E8E3);
    public static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    public static final Color DAY_SUM_COLOR = new Color(16119270);
    public static final Color DAY_TOTAL_COLOR = new Color(15789529);
    public static final Color PERIOD_TOTAL_COLOR = new Color(15262923);
    public static final Color YEAR_TOTAL_COLOR = new Color(15327928);
    public static final Color TOTAL_COLOR = new Color(0xF6F6BF);
    public static final Color SPLIT_COLOR = Color.cyan;
    public static final Color RATE_COLOR = new Color(15594232);
    public static final Color AUDITING_COLOR = new Color(16711379);
    public static final Color AUDITED_COLOR = new Color(14938078);
    public static final BigDecimal HUNDRED = new BigDecimal("100");
    public static final String BOSTYPE_JobGrade = "67F02330";
    public static final String BOSTYPE_JobLevel = "6830FEDD";
    public static final String BOSTYPE_HRDiploma = "9B3E5DD3";
    public static final String BOSTYPE_BDEmployeeType = "A29E85B3";
    public static final String BOSTYPE_EmployeeFenLei = "5C14FC3A";
    public static final String BOSTYPE_BDTechnicalPost = "8AD80852";
    public static final String BOSTYPE_AdminOrgUnit = "CCE7AED4";
    public static final String BOSTYPE_Job = "75702498";
    public static final String BOSTYPE_Postion = "74AE612E";
    public static final String BOSTYPE_CmpPeriod = "6714F6A5";

    public static String getDateString(Date date) {
        StringBuffer sb = new StringBuffer("");
        sb.append(DateTimeUtils.getYear((Date)date));
        sb.append("-");
        if (String.valueOf(DateTimeUtils.getMonth((Date)date)).length() <= 1) {
            sb.append("0");
        }
        sb.append(String.valueOf(DateTimeUtils.getMonth((Date)date)));
        sb.append("-");
        if (String.valueOf(DateTimeUtils.getDay((Date)date)).length() <= 1) {
            sb.append("0");
        }
        sb.append(String.valueOf(DateTimeUtils.getDay((Date)date)));
        return sb.toString();
    }

    public static String getResource(String name) {
        String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportResource.";
        return EASResource.getString((String)(resClass + name));
    }

    public static String getReportHtmlResource(String name) {
        String resClass = "com.kingdee.eas.hr.compensation.client.CmpReportHtmlResource.";
        return EASResource.getString((String)(resClass + name));
    }

    public static List getAnalysisItem() throws Exception {
        ArrayList<CmpItemInfo> lstItem = new ArrayList<CmpItemInfo>();
        HashSet<String> setItem = new HashSet<String>();
        setItem.add("FPER007");
        setItem.add("FPER009");
        setItem.add("FPER010");
        setItem.add("FPER011");
        setItem.add("FPER012");
        setItem.add("FPER013");
        setItem.add("FPER021");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", setItem, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        CmpItemCollection colItem = iCmpItem.getCmpItemCollection(evi);
        if (colItem != null && colItem.size() > 0) {
            int size = colItem.size();
            for (int i = 0; i < size; ++i) {
                lstItem.add(colItem.get(i));
            }
        }
        return lstItem;
    }

    public static List getBalanceAnalysisItem() throws Exception {
        ArrayList<CmpItemInfo> lstItem = new ArrayList<CmpItemInfo>();
        HashSet<String> setItem = new HashSet<String>();
        setItem.add("FPER001");
        setItem.add("FPER005");
        setItem.add("FPER006");
        setItem.add("FPER013");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", setItem, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        CmpItemCollection colItem = iCmpItem.getCmpItemCollection(evi);
        if (colItem != null && colItem.size() > 0) {
            int size = colItem.size();
            for (int i = 0; i < size; ++i) {
                lstItem.add(colItem.get(i));
            }
        }
        return lstItem;
    }

    public static void setTableColumnsFormat(KDTable kdTable, String[] strColumnKeys, String strFormat) {
        if (strColumnKeys == null || strColumnKeys.length == 0) {
            return;
        }
        for (int i = 0; i < strColumnKeys.length; ++i) {
            if (kdTable.getColumn(strColumnKeys[i]) == null) continue;
            kdTable.getColumn(strColumnKeys[i]).getStyleAttributes().setNumberFormat(strFormat);
        }
    }

    public static void setTableColumnsFormat(KDTable kdTable, List columnInfos, String strFormat) {
        if (columnInfos == null || columnInfos.size() <= 0) {
            return;
        }
        DynamicTableInfo.ColumnInfo colInfo = null;
        int size = columnInfos.size();
        for (int i = 0; i < size; ++i) {
            colInfo = (DynamicTableInfo.ColumnInfo)columnInfos.get(i);
            if (colInfo.getColumnType() != 60 && colInfo.getColumnType() != 50) continue;
            kdTable.getColumn(colInfo.getKey()).getStyleAttributes().setNumberFormat(strFormat);
        }
    }

    public static void setTableColumnsFormatWithCurrencySeparator(KDTable kdTable, List columnInfos) {
        String strFormat = "#,##0.########";
        if (columnInfos == null || columnInfos.size() <= 0) {
            return;
        }
        DynamicTableInfo.ColumnInfo colInfo = null;
        int size = columnInfos.size();
        for (int i = 0; i < size; ++i) {
            colInfo = (DynamicTableInfo.ColumnInfo)columnInfos.get(i);
            if (colInfo.getColumnType() != 60 && colInfo.getColumnType() != 50) continue;
            kdTable.getColumn(colInfo.getKey()).getStyleAttributes().setNumberFormat(strFormat);
        }
        String curString = null;
        int size2 = columnInfos.size();
        for (int i = 0; i < size2; ++i) {
            colInfo = (DynamicTableInfo.ColumnInfo)columnInfos.get(i);
            if (colInfo.getColumnType() != 60 && colInfo.getColumnType() != 50) continue;
            int count = kdTable.getRowCount3();
            for (int j = 0; j < count; ++j) {
                Object cellVal = kdTable.getCell(j, colInfo.getKey()).getValue();
                if (cellVal == null || (curString = ((BigDecimal)cellVal).toString()) == null || !(curString.lastIndexOf(".") < 0 || curString.length() > 2 && curString.lastIndexOf(".0") == curString.length() - 2 || curString.length() > 3 && curString.lastIndexOf(".00") == curString.length() - 3 || curString.length() > 4 && curString.lastIndexOf(".000") == curString.length() - 4 || curString.length() > 5 && curString.lastIndexOf(".0000") == curString.length() - 5 || curString.length() > 6 && curString.lastIndexOf(".00000") == curString.length() - 6 || curString.length() > 7 && curString.lastIndexOf(".000000") == curString.length() - 7 || curString.length() > 8 && curString.lastIndexOf(".0000000") == curString.length() - 8) && (curString.length() <= 9 || curString.lastIndexOf(".00000000") != curString.length() - 9)) continue;
                kdTable.getCell(j, colInfo.getKey()).getStyleAttributes().setNumberFormat("#,##0");
            }
        }
    }

    public static String addOrderBySQL(Context ctx, String sql, SorterItemCollection colSorter, String strQueryName, boolean isNeedAddSelector) throws EmpCmpSchmFacadeException, BOSException {
        return HRReportUtils.addOrderBySQL(ctx, sql, colSorter, strQueryName, isNeedAddSelector, false, null);
    }

    public static String addOrderBySQL(Context ctx, String sql, SorterItemCollection colSorter, String strQueryName, boolean isNeedAddSelector, boolean isDefaultOrderByTime, String tempTableName) throws EmpCmpSchmFacadeException, BOSException {
        if (colSorter == null || colSorter.size() <= 0) {
            int iOrderByIndex;
            String orderByString = "PERSON.fnumber ASC";
            if (isDefaultOrderByTime && tempTableName != null) {
                orderByString = "PERSON.fnumber ASC," + tempTableName + ".fTime ASC";
            }
            sql = (iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)sql, (String)" ORDER ")) > 0 ? sql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString : sql + " ORDER BY " + orderByString;
            return sql;
        }
        SqlSelect select = HRSchemeUtils.getSqlSelectFromQuery(ctx, strQueryName);
        SqlSelectItem selectItem = null;
        int fromIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"FROM");
        String beforeFrom = sql.substring(0, fromIndex);
        StringBuffer addSelectString = new StringBuffer();
        StringBuffer orderByString = new StringBuffer();
        int size = colSorter.size();
        for (int i = 0; i < size; ++i) {
            selectItem = HRReportUtils.getItem(select.selectList, colSorter.get(i).getPropertyName());
            if (selectItem == null) {
                boolean columnExist = HRReportUtils.getItem(ctx, tempTableName, colSorter.get(i).getPropertyName());
                if (columnExist) {
                    selectItem = new SqlSelectItem();
                    try {
                        selectItem.expr = new SqlExprParser(colSorter.get(i).getPropertyName()).expr();
                    }
                    catch (ParserException e) {
                        throw new BOSException((Throwable)e);
                    }
                    selectItem.alias = colSorter.get(i).getPropertyName();
                } else {
                    throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
                }
            }
            if (isNeedAddSelector && StringUtils.indexOfIgnoreCase((String)beforeFrom, (String)selectItem.expr.toString()) <= 0 && selectItem.toString().indexOf("FPER001") < 0) {
                if (selectItem.toString().indexOf("FPER005") >= 0) {
                    addSelectString.append(" ,").append(selectItem.expr.toString()).append(" FPER005NeedName");
                } else {
                    addSelectString.append(" ,").append(selectItem.toString());
                }
            }
            if (!orderByString.toString().equals("")) {
                orderByString.append(",");
            }
            orderByString.append(selectItem.expr.toString()).append(" ").append(colSorter.get(i).getSortType().getName());
        }
        String strRtnSql = sql;
        if (isNeedAddSelector) {
            strRtnSql = beforeFrom + addSelectString.toString() + "  " + sql.substring(fromIndex, sql.length());
        }
        if (!orderByString.toString().equals("")) {
            int iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)strRtnSql, (String)" ORDER ");
            String timeOrder = "";
            if (tempTableName != null) {
                timeOrder = "," + tempTableName + ".fTime ASC";
            }
            strRtnSql = iOrderByIndex > 0 ? strRtnSql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString.toString() + timeOrder : strRtnSql + " ORDER BY " + orderByString.toString() + timeOrder;
        }
        return strRtnSql;
    }

    public static String addEmpSumRptOrderBySQL(Context ctx, String sql, SorterItemCollection colSorter, String strQueryName, boolean isNeedAddSelector) throws EmpCmpSchmFacadeException, BOSException {
        if (colSorter == null || colSorter.size() <= 0) {
            String orderByString = "\"PERSON\".FNumber ASC,fTime ASC";
            int iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)sql, (String)" ORDER ");
            sql = iOrderByIndex > 0 ? sql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString : sql + " ORDER BY " + orderByString;
            return sql;
        }
        SqlSelect select = HRSchemeUtils.getSqlSelectFromQuery(ctx, strQueryName);
        SqlSelectItem selectItem = null;
        int fromIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"FROM");
        String beforeFrom = sql.substring(0, fromIndex);
        StringBuffer addSelectString = new StringBuffer();
        StringBuffer orderByString = new StringBuffer();
        int size = colSorter.size();
        for (int i = 0; i < size; ++i) {
            selectItem = HRReportUtils.getItem(select.selectList, colSorter.get(i).getPropertyName());
            if (selectItem == null) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
            }
            if (isNeedAddSelector && StringUtils.indexOfIgnoreCase((String)beforeFrom, (String)selectItem.expr.toString()) <= 0 && selectItem.toString().indexOf("FPER001") < 0) {
                if (selectItem.toString().indexOf("FPER005") >= 0) {
                    addSelectString.append(" ,").append(selectItem.expr.toString()).append(" FPER005NeedName");
                } else {
                    addSelectString.append(" ,").append(selectItem.toString());
                }
            }
            if (!orderByString.toString().equals("")) {
                orderByString.append(",");
            }
            orderByString.append(selectItem.expr.toString()).append(" ").append(colSorter.get(i).getSortType().getName());
        }
        String strRtnSql = sql;
        if (isNeedAddSelector) {
            strRtnSql = beforeFrom + addSelectString.toString() + "  " + sql.substring(fromIndex, sql.length());
        }
        if (!orderByString.toString().equals("")) {
            orderByString.append(",fTime ASC");
            int iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)strRtnSql, (String)" ORDER ");
            strRtnSql = iOrderByIndex > 0 ? strRtnSql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString.toString() : strRtnSql + " ORDER BY " + orderByString.toString();
        }
        return strRtnSql;
    }

    public static String addEmpSumRptOrderBySQL(Context ctx, String sql, SorterItemCollection colSorter, String strQueryName, boolean isNeedAddSelector, String tableName) throws EmpCmpSchmFacadeException, BOSException {
        if (colSorter == null || colSorter.size() <= 0) {
            String orderByString = null;
            if (sql.indexOf("\"PERSON\".FNumber") != -1 || sql.indexOf("PERSON.FNumber") != -1) {
                orderByString = "\"PERSON\".FNumber ASC," + tableName + ".fTime ASC";
            } else {
                String language = ctx.getLocale().getLanguage();
                orderByString = "\"PERSON\".FName_" + language + " ASC," + tableName + ".fTime ASC";
            }
            int iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)sql, (String)" ORDER ");
            sql = iOrderByIndex > 0 ? sql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString : sql + " ORDER BY " + orderByString;
            return sql;
        }
        SqlSelect select = HRSchemeUtils.getSqlSelectFromQuery(ctx, strQueryName);
        SqlSelectItem selectItem = null;
        int fromIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"FROM");
        String beforeFrom = sql.substring(0, fromIndex);
        String addSelectString = "";
        String orderByString = "";
        int size = colSorter.size();
        for (int i = 0; i < size; ++i) {
            selectItem = HRReportUtils.getItem(select.selectList, colSorter.get(i).getPropertyName());
            if (selectItem == null) {
                boolean columnExist = HRReportUtils.getItem(ctx, tableName, colSorter.get(i).getPropertyName());
                if (columnExist) {
                    selectItem = new SqlSelectItem();
                    try {
                        selectItem.expr = new SqlExprParser(colSorter.get(i).getPropertyName()).expr();
                    }
                    catch (ParserException e) {
                        throw new BOSException((Throwable)e);
                    }
                    selectItem.alias = colSorter.get(i).getPropertyName();
                } else {
                    throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
                }
            }
            if (isNeedAddSelector && StringUtils.indexOfIgnoreCase((String)beforeFrom, (String)selectItem.expr.toString()) <= 0 && selectItem.toString().indexOf("FPER001") < 0) {
                addSelectString = selectItem.toString().indexOf("FPER005") >= 0 ? addSelectString + " ," + selectItem.expr.toString() + " FPER005NeedName" : addSelectString + " ," + selectItem.toString();
            }
            if (!orderByString.equals("")) {
                orderByString = orderByString + ",";
            }
            orderByString = orderByString + selectItem.expr.toString() + " " + colSorter.get(i).getSortType().getName();
        }
        String strRtnSql = sql;
        if (isNeedAddSelector) {
            strRtnSql = beforeFrom + addSelectString + "  " + sql.substring(fromIndex, sql.length());
        }
        if (!orderByString.equals("")) {
            orderByString = orderByString + "," + tableName + ".fTime ASC";
            int iOrderByIndex = StringUtils.lastIndexOfIgnoreCase((String)strRtnSql, (String)" ORDER ");
            strRtnSql = iOrderByIndex > 0 ? strRtnSql.substring(0, iOrderByIndex) + " ORDER BY " + orderByString : strRtnSql + " ORDER BY " + orderByString;
        }
        return strRtnSql;
    }

    private static SqlSelectItem getItem(List selectors, String alias) {
        if (selectors == null || selectors.size() == 0) {
            return null;
        }
        int size = selectors.size();
        for (int i = 0; i < size; ++i) {
            if (!(selectors.get(i) instanceof SqlSelectItem) || !((SqlSelectItem)selectors.get((int)i)).alias.equalsIgnoreCase("\"" + alias + "\"") && !((SqlSelectItem)selectors.get((int)i)).alias.equalsIgnoreCase(alias)) continue;
            return (SqlSelectItem)selectors.get(i);
        }
        return null;
    }

    private static boolean getItem(Context ctx, String tableName, String columnAlias) throws BOSException {
        List columnList = HRUtils.getColumnOfTable(ctx, tableName);
        String tempColumn = null;
        boolean existFlag = false;
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            tempColumn = (String)columnList.get(i);
            if (!columnAlias.equalsIgnoreCase(tempColumn)) continue;
            existFlag = true;
        }
        return existFlag;
    }

    public static String addSelectForSQL(Context ctx, String sql, SorterItemCollection colSorter, String strQueryName) throws EmpCmpSchmFacadeException, BOSException {
        if (colSorter == null || colSorter.size() <= 0) {
            return sql;
        }
        SqlSelect select = HRSchemeUtils.getSqlSelectFromQuery(ctx, strQueryName);
        SqlSelectItem selectItem = null;
        int fromIndex = StringUtils.indexOfIgnoreCase((String)sql, (String)"FROM");
        String beforeFrom = sql.substring(0, fromIndex);
        StringBuffer addSelectString = new StringBuffer();
        int size = colSorter.size();
        for (int i = 0; i < size; ++i) {
            selectItem = HRReportUtils.getItem(select.selectList, colSorter.get(i).getPropertyName());
            if (selectItem == null) {
                throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.ORDERBYLIST_INVALID);
            }
            if (StringUtils.indexOfIgnoreCase((String)beforeFrom, (String)selectItem.expr.toString()) > 0 || sql.indexOf(selectItem.alias) >= 0) continue;
            addSelectString.append(" ,").append(selectItem.toString());
        }
        String strRtnSql = sql;
        strRtnSql = beforeFrom + addSelectString.toString() + "  " + sql.substring(fromIndex, sql.length());
        return strRtnSql;
    }

    public static SqlSelect getFixedItemSQL(Context ctx, EntityViewInfo infoEntityView) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        EntityViewInfo evi;
        IQueryExecutor exec = null;
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery");
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        try {
            evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(metaDataPK.toString()), infoEntityView);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        exec.setObjectView(evi);
        String sql = exec.getSQL();
        if (sql.indexOf("ORDER") > 0) {
            sql = sql.substring(0, sql.indexOf("ORDER"));
        }
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    public static void hiddenNullColumn(KDTable tblMain) {
        logger.info((Object)("begin :" + System.currentTimeMillis()));
        int columnSize = tblMain.getColumnCount();
        int length = tblMain.getRowCount3();
        boolean columnNullFlag = true;
        Object currentVal = null;
        IRow row = null;
        for (int i = 0; i < columnSize; ++i) {
            for (int j = 0; j < length; ++j) {
                row = tblMain.getRow(j);
                currentVal = row.getCell(i).getValue();
                if (currentVal != null) continue;
                columnNullFlag = false;
                break;
            }
            if (!columnNullFlag) continue;
            tblMain.getColumn(i).getStyleAttributes().setHided(true);
        }
        logger.info((Object)("end :" + System.currentTimeMillis()));
    }

    public static List getCmpPeriodByTime(Context ctx, Date beginDate, Date endDate, String hrOrgId) throws BOSException {
        ArrayList<CmpPeriodInfo> periodList = new ArrayList<CmpPeriodInfo>();
        Object[] dates = new Object[]{beginDate, endDate};
        StringBuffer sql = new StringBuffer();
        CmpPeriodInfo period = null;
        ISQLExecutor iSQLExec = null;
        String fname = null;
        fname = ctx == null ? "fname_" + SysContext.getSysContext().getLocale().getLanguage() : "fname_" + ctx.getLocale().getLanguage();
        sql.append("select fid,fnumber,").append(fname).append(" from t_hr_cmpPeriod where FBeginDate>={ts'").append(beginDate.toString());
        sql.append("'}  and FEndDate<={ts'").append(endDate.toString()).append("'}");
        sql.append(" and fHrOrgUnitID='").append(hrOrgId).append("'");
        sql.append(" order by FBeginDate");
        iSQLExec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = iSQLExec.executeSQL();
        try {
            while (rs.next()) {
                period = new CmpPeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("fid")));
                period.setNumber(rs.getString("fnumber"));
                period.setName(rs.getString(fname));
                periodList.add(period);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodList;
    }

    public static List getDataBaseByBosType(List bosType) {
        ArrayList<BgDimItemInfo> typeInfoList = new ArrayList<BgDimItemInfo>();
        int n = bosType.size();
        for (int i = 0; i < n; ++i) {
            BgDimItemInfo obj;
            String strType = (String)bosType.get(i);
            if (strType.equals(BOSTYPE_JobGrade)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"388_FixedCmpSchemeReportUI"), BOSTYPE_JobGrade);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_JobLevel)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"633_HRReportUtils"), BOSTYPE_JobLevel);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_HRDiploma)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"634_HRReportUtils"), BOSTYPE_HRDiploma);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_BDEmployeeType)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"635_HRReportUtils"), BOSTYPE_BDEmployeeType);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_EmployeeFenLei)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"636_HRReportUtils"), BOSTYPE_EmployeeFenLei);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_BDTechnicalPost)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"214_CmpDimensionFilterUI"), BOSTYPE_BDTechnicalPost);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_AdminOrgUnit)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"206_CmpDimensionFilterUI"), BOSTYPE_AdminOrgUnit);
                typeInfoList.add(obj);
                continue;
            }
            if (strType.equals(BOSTYPE_Job)) {
                obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"209_CmpDimensionFilterUI"), BOSTYPE_Job);
                typeInfoList.add(obj);
                continue;
            }
            if (!strType.equals(BOSTYPE_Postion)) continue;
            obj = new BgDimItemInfo(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"207_CmpDimensionFilterUI"), BOSTYPE_Postion);
            typeInfoList.add(obj);
        }
        return typeInfoList;
    }

    public static String getRootHRUnitID(Context ctx, List hroIdList) throws BOSException, SQLException {
        ArrayList<HROrgUnitInfo> hroList = new ArrayList<HROrgUnitInfo>();
        IHROrgUnit ihro = null;
        ihro = ctx != null ? HROrgUnitFactory.getLocalInstance((Context)ctx) : HROrgUnitFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number,name,longNumber where id in ");
        oql.append(HRSchemeUtils.getStrFromList(hroIdList));
        HROrgUnitCollection hroCollection = ihro.getHROrgUnitCollection(oql.toString());
        int n = hroCollection.size();
        for (int i = 0; i < n; ++i) {
            HROrgUnitInfo org = hroCollection.get(i);
            hroList.add(org);
        }
        String hrOrgId = HRUtils.getParentOrgId(ctx, hroList, 1);
        return hrOrgId;
    }

    public static void doWithColumnWrap(KDTable tblMain, List lstColumn) {
        String columnNum = null;
        DynamicTableInfo.ColumnInfo infoColumn = null;
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infoColumn = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
            int columnType = infoColumn.getColumnType();
            boolean hiddenFlag = infoColumn.isHide();
            if (columnType != 30 || hiddenFlag) continue;
            columnNum = infoColumn.getColumnNumber();
            tblMain.getColumn(columnNum).getStyleAttributes().setWrapText(true);
        }
    }

    public static void doWithColumnWrapForCmpItem(KDTable tblMain, int headRow, List cmpItemLst) throws BOSException {
        int size = tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            tblMain.getHeadRow(headRow).getCell(i).getStyleAttributes().setWrapText(true);
        }
        String columnNum = null;
        CmpItemInfo infoColumn = null;
        int size2 = cmpItemLst.size();
        for (int i = 0; i < size2; ++i) {
            infoColumn = (CmpItemInfo)cmpItemLst.get(i);
            if (infoColumn.getDataType().getValue() != 30) continue;
            columnNum = infoColumn.getNumber();
            tblMain.getColumn(columnNum).getStyleAttributes().setWrapText(true);
        }
        tblMain.setRefresh(true);
        tblMain.reLayoutAndPaint();
    }

    public static void releaseTmpTable(Context ctx, String tempTableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)tempTableName)) {
            pool.releaseTable(tempTableName);
        }
    }
}

