/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomWRUtil {
    Map<String, String> cmpItemName_map = null;
    Map<String, String> cmpItemDataType_map = null;
    private static final Logger logger = CoreUIObject.getLogger(DomWRUtil.class);
    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
    public static final String path = System.getProperty("EAS_HOME") + "/server/properties/cmpItemConf.xml";

    public void writeNode(Context ctx) throws Exception {
        this.createXmlConfFile();
        logger.info((Object)"createXmlConfFile success");
        System.out.println("user.dir=" + System.getProperty("user.dir"));
        System.out.println("cmpItemConf path>>>>" + path);
        logger.info((Object)("cmpItemConf path>>>>" + path));
        logger.info((Object)("user.dir=" + System.getProperty("user.dir")));
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            Document doc = builder.parse(path);
            Element root = doc.getDocumentElement();
            String[] str = this.getDistinctCmpItem(ctx);
            this.addCmpItemNode(str, doc);
            TransformerFactory tr = TransformerFactory.newInstance();
            Transformer t = tr.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("encoding", "GB2312");
            DOMSource sourse = new DOMSource(doc);
            File file = new File(path);
            StreamResult result = new StreamResult(file);
            t.transform(sourse, result);
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
    }

    private void addCmpItemNode(String[] cmpitem, Document doc) {
        Element root = doc.getDocumentElement();
        for (String str : cmpitem) {
            Element ele = doc.createElement("cmpItem");
            ele.setAttribute("oldItemId", str);
            ele.setAttribute("oldItemName", this.cmpItemName_map.get(str));
            ele.setAttribute("oldItemDataType", this.cmpItemDataType_map.get(str));
            ele.setAttribute("newItemNumber", "");
            ele.setAttribute("newItemName", "");
            if (this.isExitCmpItem(doc, str)) continue;
            root.appendChild(ele);
        }
    }

    private boolean isExitCmpItem(Document doc, String strNumber) {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element ele;
            String number;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !strNumber.equals(number = (ele = (Element)node).getAttribute("oldItemId"))) continue;
            return true;
        }
        return false;
    }

    private String[] getDistinctCmpItem(Context ctx) {
        String[] str = null;
        this.cmpItemName_map = new HashMap<String, String>();
        this.cmpItemDataType_map = new HashMap<String, String>();
        String l = HRUtils.getShortCode(ctx);
        String sql = "select distinct fnumber,fname_" + l + " AS fname,FDataType from t_hr_cmpItem where FNumber not like 'FPER%' and Fnumber!='FSAL000' order by fnumber";
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String fnumber = rs.getString("fnumber");
                sb.append(fnumber).append(",");
                this.cmpItemName_map.put(fnumber, rs.getString("fname"));
                this.cmpItemDataType_map.put(fnumber, this.translateDataType(rs.getInt("FDataType")));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        str = sb.toString().split(",");
        return str;
    }

    public Map<String, String> getOldItemIdToItemId_info() {
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = null;
        try {
            DocumentBuilder builder = this.dFactory.newDocumentBuilder();
            doc = builder.parse(path);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            Element ele = (Element)node;
            String number = ele.getAttribute("oldItemId");
            if ("".equals(ele.getAttribute("newItemNumber"))) continue;
            map.put(number, ele.getAttribute("newItemNumber"));
        }
        return map;
    }

    private String translateDataType(int type) {
        return ItemDataTypeEnum.getEnum(type).getAlias();
    }

    public static void main(String[] args) {
    }

    private void createXmlConfFile() throws Exception {
        File tempFile = new File(path);
        if (tempFile.exists()) {
            return;
        }
        BufferedWriter outClient = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
        String[] sqlLine = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<cmpItems> ", "</cmpItems>"};
        for (int i = 0; i < sqlLine.length; ++i) {
            outClient.write(sqlLine[i]);
            outClient.newLine();
            outClient.flush();
        }
        outClient.close();
    }
}

