/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.exception.CommonSalaryException;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.syn.DomWRUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.ICmpItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SynCmpCalResultDataTo80 {
    public static final String tableName = "T_HR_SCHM_SummaryRecord";
    private Map<String, String> cmpItemMap = null;
    private Map<String, String> cmpItemDataType_Map = null;

    private Map<String, String> getAllCmpItem_EAS_SQL(String sql, Context ctx) throws BOSException, SQLException {
        HashMap<String, String> cmpItemMap = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String fnumber = rs.getString("fnumber");
            cmpItemMap.put(fnumber, rs.getString("fname"));
        }
        return cmpItemMap;
    }

    private Map<String, String> getAllCmpItem_EAS_CmpItemType(Context ctx) throws BOSException, SQLException {
        String sql = "select distinct fnumber,FDataType,FLength from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000' and FDataType=30 order by fnumber";
        HashMap<String, String> cmpItemTypeMap = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String fnumber = rs.getString("fnumber");
            cmpItemTypeMap.put(fnumber, rs.getInt("FLength") + "");
        }
        return cmpItemTypeMap;
    }

    public String createCalResultTable(Context ctx) throws BOSException, SQLException {
        StringBuffer sqlCreate = new StringBuffer("CREATE TABLE");
        sqlCreate.append(" ").append(tableName).append(" (FPersonID VARCHAR (44) NOT NULL,");
        sqlCreate.append(" FPERIOD VARCHAR (44) NOT NULL, ");
        sqlCreate.append(" FTIME INT NOT NULL, ");
        sqlCreate.append(" FADMINORGUNITID VARCHAR (44) NOT NULL, ");
        sqlCreate.append(" FPOSITIONID VARCHAR (44) NULL, ");
        sqlCreate.append(" FCalType INT NULL, ");
        sqlCreate.append(" FPERIODNumber VARCHAR (80) NULL, ");
        sqlCreate.append(" FADMINORGUNITName VARCHAR (255) NULL, ");
        sqlCreate.append(" FPOSITIOName VARCHAR (255) NULL, ");
        sqlCreate.append(" FBEGINDATE DateTime NULL, ");
        sqlCreate.append(" FENDDATE DateTime NULL, ");
        sqlCreate.append(" FOldSchemeId VARCHAR(44) NULL, ");
        String l = HRUtils.getShortCode(ctx);
        String getAllCmpItem_EAS_SQL = "select distinct fnumber,fname_" + l + " AS fname from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000' order by fnumber";
        this.cmpItemMap = this.getAllCmpItem_EAS_SQL(getAllCmpItem_EAS_SQL, ctx);
        this.cmpItemDataType_Map = this.getAllCmpItem_EAS_CmpItemType(ctx);
        Set<Map.Entry<String, String>> set = this.cmpItemMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String fnumber = entry.getKey();
            if (this.cmpItemDataType_Map.containsKey(fnumber)) {
                int length = Integer.parseInt(this.cmpItemDataType_Map.get(fnumber)) * 2;
                sqlCreate.append(" ").append(fnumber).append("  NVARCHAR (" + length + ") NULL , ");
                continue;
            }
            sqlCreate.append(" ").append(fnumber).append("  VARCHAR (44) NULL , ");
        }
        sqlCreate.append(" FID VARCHAR(135) DEFAULT '' NOT NULL ,CONSTRAINT PK_HR_SCmpCalResult PRIMARY KEY (FID)");
        sqlCreate.append(")");
        DbUtil.execute((Context)ctx, (String)sqlCreate.toString());
        return null;
    }

    private void insertValueToCalResultTable(Context ctx) throws BOSException, SQLException {
        CmpSchemeCollection coll = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeCollection(" where histableName is not null");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String histableName = coll.get(i).getHisTableName();
            String cmpSchemeId = coll.get(i).getId().toString();
            StringBuffer select_sql = new StringBuffer();
            StringBuffer cmpItem = new StringBuffer();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)coll.get(i).getId().toString()));
            evi.setFilter(filterInfo);
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("cmpItem.*"));
            SorterItemInfo sorterOrderItem = new SorterItemInfo("id");
            sorterOrderItem.setSortType(SortType.ASCEND);
            evi.getSorter().add(sorterOrderItem);
            ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
            CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
            if (col != null && col.size() > 0) {
                Iterator itr = col.iterator();
                CmpSchemeItemInfo info = null;
                CmpItemInfo infoCmpItem = null;
                while (itr.hasNext()) {
                    info = (CmpSchemeItemInfo)itr.next();
                    infoCmpItem = info.getCmpItem();
                    if (infoCmpItem == null || infoCmpItem.getNumber() == null || "FSAL000".equalsIgnoreCase(infoCmpItem.getNumber()) || infoCmpItem.getNumber().substring(0, 4).equalsIgnoreCase("FPer")) continue;
                    cmpItem.append(infoCmpItem.getNumber()).append(",");
                }
                cmpItem.deleteCharAt(cmpItem.length() - 1);
            }
            String l = HRUtils.getShortCode(ctx);
            StringBuffer insertSqlBf = new StringBuffer();
            insertSqlBf.append("insert into ").append(tableName).append(" (fid,FPersonID,FPERIOD,FTIME,FADMINORGUNITID,FPOSITIONID,FCalType,FPERIODNumber,FADMINORGUNITName,FPOSITIOName,FBeginDate,FEndDate,FOldSchemeId,").append(cmpItem).append(") ").append("select '").append(cmpSchemeId).append("'||FPersonID||FPERIOD||convert(varchar(7),FTime)").append(", FPersonID,FPERIOD,FTIME,tempTab.fadminOrgUnitId,tempTab.FpositionId,FCalType,period.fnumber,orgAdmin.fname_" + l + ",position.fname_" + l + ",period.FbeginDate,period.FendDate,'" + cmpSchemeId + "'as FOldSchemeId,").append(cmpItem).append(" from ").append(histableName).append(" AS tempTab  left join t_org_admin orgAdmin on orgAdmin.fid=tempTab.fadminOrgUnitId  left join T_ORG_Position position on position.fid=tempTab.FpositionId  inner join t_hr_cmpperiod period on period.fid=tempTab.FPERIOD  where NOT EXISTS (select 1 from T_HR_SCHM_SummaryRecord where fid='" + cmpSchemeId + "'||tempTab.FPersonID||tempTab.FPERIOD||convert(varchar(7),tempTab.FTIME))");
            DbUtil.execute((Context)ctx, (String)insertSqlBf.toString());
        }
    }

    private boolean isAlreadyInDB(Context ctx, String fid) throws BOSException, SQLException {
        String existSql = "select count(fid) from T_HR_SCHM_SummaryRecord where fid='" + fid + "'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)existSql.toString());
        while (rowSet1.next()) {
            if (rowSet1.getInt(1) <= 0) continue;
            return true;
        }
        return false;
    }

    private void addConfigColumn(Context ctx) throws BOSException {
        Map<Object, Object> map = new HashMap();
        try {
            Class<?> c = Class.forName("com.kingdee.shr.compensation.app.syn.DomWRUtil");
            DomWRUtil domWRUtil = (DomWRUtil)c.newInstance();
            map = domWRUtil.getOldItemIdToItemId_info();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String[] column_prefix_S = null;
        try {
            column_prefix_S = this.getColumnName_preCharS(ctx);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Set<Map.Entry<Object, Object>> entry = map.entrySet();
        Iterator<Map.Entry<Object, Object>> ite = entry.iterator();
        StringBuffer alertSql = new StringBuffer();
        while (ite.hasNext()) {
            Map.Entry<Object, Object> eachentry = ite.next();
            String oldItemId = (String)eachentry.getKey();
            String itemId = (String)eachentry.getValue();
            if (!"".equals(itemId)) {
                alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + itemId + "' and KSQL_COL_TABNAME='" + tableName + "') ").append("alter table T_HR_SCHM_SummaryRecord  add " + itemId + " VARCHAR(44) NULL;");
                DbUtil.execute((Context)ctx, (String)alertSql.toString());
                alertSql.delete(0, alertSql.length());
                alertSql.append("update T_HR_SCHM_SummaryRecord set ").append(itemId).append(" = ").append(oldItemId);
                DbUtil.execute((Context)ctx, (String)alertSql.toString());
            }
            if (alertSql.length() == 0) continue;
            alertSql.delete(0, alertSql.length());
        }
        for (String scolumn : column_prefix_S) {
            String dropColumnSql = "alter table T_HR_SCHM_SummaryRecord drop column ";
            if (map.containsValue(scolumn)) continue;
            dropColumnSql = dropColumnSql + scolumn;
            DbUtil.execute((Context)ctx, (String)dropColumnSql.toString());
        }
    }

    private String[] getColumnName_preCharS(Context ctx) throws BOSException, SQLException {
        String sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_NAME like 'S%' and KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer bb = new StringBuffer();
        while (rowSet1.next()) {
            bb.append(rowSet1.getString("KSQL_COL_NAME")).append(",");
        }
        if (bb.length() != 0) {
            bb.deleteCharAt(bb.length() - 1);
        }
        return bb.toString().split(",");
    }

    public int syn(Context ctx) throws BOSException {
        try {
            if (!this.isExistTableInDB(ctx)) {
                this.createCalResultTable(ctx);
            } else {
                this.alertCalResultTable(ctx);
            }
            this.insertValueToCalResultTable(ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        return 1;
    }

    public boolean isExistTableInDB(Context ctx) throws BOSException, SQLException {
        String sql = "select count(*) from KSQL_USERTABLES where KSQL_TABNAME ='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet1.next()) {
            if (rowSet1.getInt(1) <= 0) continue;
            return true;
        }
        return false;
    }

    public void insertValueTo_t_hr_scmpcaltable(Context ctx) throws Exception {
        this.sysCmpItemCatalogId(ctx);
        this.sysCmpItemId(ctx);
        this.synCmpschemeAndSchemeItem(ctx);
        Map<String, String> map_OldNumberToS = this.getOldNumberToSUserTable(ctx);
        Set<Map.Entry<String, String>> map_entry = map_OldNumberToS.entrySet();
        Iterator<Map.Entry<String, String>> iter = map_entry.iterator();
        StringBuffer cmpItem_S = new StringBuffer();
        StringBuffer cmpItem_oldNum = new StringBuffer();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            cmpItem_oldNum.append(",").append(entry.getKey());
            cmpItem_S.append(",").append(entry.getValue());
        }
        StringBuffer insertSqlBf = new StringBuffer();
        insertSqlBf.append("insert into ").append("t_hr_scmpcaltable").append(" ( fid,fpersonid,fcmpperiodid,fperiodYear,FperiodMonth,fIsCal,FisAudit,Fisgive,fadminOrgunitid,fpositionId,fcalTime,FlongNumber,FoldEasId,fbeginDate,FendDate,FCalSchemeId").append(cmpItem_S).append(") ").append("select newbosid('7B19597F'),FPersonID,newperiod.fid,case period.fcmpperiodyear when 0 then left(period.fnumber,4) when null then left(period.fnumber,4) else period.fcmpperiodyear end as fcmpperiodyear ,case  period.fcmpperiod when 0  then right(period.fnumber,2) when  null then right(period.fnumber,2)  else period.fcmpperiod end as FperiodMonth,'Y','Y','Y',tempTab.fadminOrgUnitid,fpositionId,ftime,orgAdmin.flongNumber,tempTab.fid,tempTab.fbeginDate,tempTab.FendDate,newscheme.Fid").append(cmpItem_oldNum).append(" from ").append(tableName).append(" AS tempTab  left join t_org_admin orgAdmin on orgAdmin.fid=tempTab.fadminOrgUnitId  left join t_hr_cmpperiod period on period.fid=tempTab.FPERIOD  left join t_hr_scmpperiod newperiod on newperiod.FoldPeriodId=tempTab.FPERIOD  left join T_HR_SCalScheme newscheme on newscheme.foldEasCmpSchemeId=tempTab.FOldSchemeId where NOT EXISTS (select 1 from t_hr_scmpcaltable where foldEasId=tempTab.Fid)");
        DbUtil.execute((Context)ctx, (String)insertSqlBf.toString());
        this.synPeriodYearMontToSCalSchemeHIS(ctx);
    }

    public Map<String, String> getOldNumberToSUserTable(Context ctx) throws BOSException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        HashMap<String, String> map_OldNumberToS = new HashMap<String, String>();
        String sql = "select Fnumber,fieldsn from T_HR_SCmpItem where fnumber IN (select distinct fnumber from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000')";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet1.next()) {
            String key = rowSet1.getString("Fnumber");
            String value = "S" + rowSet1.getInt("fieldsn");
            map_OldNumberToS.put(key, value);
        }
        return map_OldNumberToS;
    }

    public void sysPeriodId(Context ctx) throws BOSException, SQLException {
        String judgeDubPeriod = "select  FHROrgUnitID,fnumber,count(fnumber) from t_hr_scmpperiod group by FHROrgUnitID,fnumber having  count(fnumber) >1";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)judgeDubPeriod);
        if (rowSet1.next()) {
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION3)));
        }
        String sql = "update t_hr_scmpperiod  set FoldPeriodId =(select t2.fid from  t_hr_cmpperiod  t2 where  t_hr_scmpperiod.fnumber=concat(t2.fnumber,'_M') and t_hr_scmpperiod.FHrorgUnitId=t2.FHrorgUnitID)";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer insertSql = new StringBuffer();
        String l = HRUtils.getShortCode(ctx);
        insertSql.append("insert into t_hr_scmpperiod(fid,fbegindate,fenddate,fenable,FHROrgUnitID,FPEndInputClose,FCmpPeriodYear,fNumber,FoldPeriodId,fcmpperiod,fcmpperiodtype,fname_" + l + ") select newbosid('ACF73A45'),FBeginDate,FEndDate,Fenable,FHROrgUnitID,FPEndInputClose,FCmpPeriodYear,concat(fNumber,'_M'),fid,fnumber,2,fnumber from t_hr_cmpperiod");
        insertSql.append(" where NOT EXISTS (select 1 from t_hr_scmpperiod where t_hr_scmpperiod.fNumber=concat(t_hr_cmpperiod.fnumber,'_M') and t_hr_scmpperiod.FHrorgUnitId=t_hr_cmpperiod.FHrorgUnitID)");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    public void sysCmpItemCatalogId(Context ctx) throws BOSException, SQLException {
        String judgeDubPeriod = "select fnumber,count(fnumber) from T_HR_SCmpItemCatalog group by fnumber having  count(fnumber) >1";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)judgeDubPeriod);
        if (rowSet1.next()) {
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION4)));
        }
        String l = HRUtils.getShortCode(ctx);
        StringBuffer insertSql = new StringBuffer();
        String curOrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        insertSql.append("insert into T_HR_SCmpItemCatalog (FID,FHrOrgUnitID,FisPreset,fstate,fname_" + l + ",fnumber,FoldCmpItemCatalogId) select newBosid('8432DF82'),'" + curOrg + "',0,1,temp.fname_" + l + ",temp.fnumber,'FoldCmpItemCatalogId' from ( select distinct fnumber,Fname_" + l + " from T_HR_CMPITEMCAT group by fnumber,Fname_" + l + ") AS temp");
        insertSql.append(" where NOT EXISTS (select 1 from T_HR_SCmpItemCatalog where T_HR_SCmpItemCatalog.fnumber=temp.fnumber)");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    public void sysCmpItemId(Context ctx) throws BOSException, SQLException {
        String judgeDubCmpItem = "select fnumber,count(fnumber) from T_HR_SCmpItem group by fnumber having  count(fnumber) >1";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)judgeDubCmpItem);
        if (rowSet1.next()) {
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION5)));
        }
        String select_sql = "select distinct fnumber from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000'  and fnumber not in (select fnumber from t_hr_scmpitem) ";
        rowSet1 = DbUtil.executeQuery((Context)ctx, (String)select_sql);
        ArrayList<String> list = new ArrayList<String>();
        while (rowSet1.next()) {
            list.add(rowSet1.getString(1));
        }
        String l = HRUtils.getShortCode(ctx);
        StringBuffer cmpItem_diff = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(" select B.Fnumber from ( ").append(" select distinct cmpitem.FDataType,cmpitem.FLength,cmpitem.FDecDigital,cmpitem.fnumber,cmpitem.fname_" + l + ",T_HR_CMPITEMCAT.Fnumber as ").append(" catFnumber,T_HR_SCmpItemCatalog.fid as Catalog_fid from t_hr_cmpItem as cmpitem inner join T_HR_CMPITEMCAT ").append("  on cmpitem.FCmpItemCatalogID=T_HR_CMPITEMCAT.fid ").append(" inner join T_HR_SCmpItemCatalog on T_HR_SCmpItemCatalog.fnumber=T_HR_CMPITEMCAT.Fnumber ").append(" where cmpitem.FNumber not like 'FPER%' and cmpitem.FNumber!='FSAL000' ").append(" and cmpitem.fnumber not in (select fnumber from t_hr_scmpitem ) ").append(" ) As B group by B.Fnumber having count(B.Fnumber)>1");
        rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet1.next()) {
            cmpItem_diff.append("'" + rowSet1.getString(1) + "'").append(",");
        }
        sql.delete(0, sql.length());
        String curOrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        sql.append("insert into T_HR_SCmpItem(fid,fnumber,FDataType,FDataLength,FDataDot,fname_" + l + ",FCmpItemCatalogID,FoldCmpItemId,FHrOrgUnitID,FAdminOrgUnitID)").append(" select newBosid('FCB49097'),B.Fnumber,case B.FDataType when 40 then 0 when 50 then 0 when 60 then 0 else 1 end as datatype,max(B.Flength) as Flength,case when  max(B.FDecDigital)").append(" IN (0,1,2,3,4) then max(B.FDecDigital) else 4 end as FDecDigital,B.fname_" + l + ", ").append(" B.Catalog_fid,'FoldCmpItemId','" + curOrg + "','" + curOrg + "' from (").append(" select distinct cmpitem.FDataType,cmpitem.FLength,cmpitem.FDecDigital,cmpitem.fnumber,cmpitem.fname_" + l + ",T_HR_CMPITEMCAT.Fnumber as ").append(" catFnumber,T_HR_SCmpItemCatalog.fid as Catalog_fid from t_hr_cmpItem as cmpitem inner join T_HR_CMPITEMCAT").append("  on cmpitem.FCmpItemCatalogID=T_HR_CMPITEMCAT.fid ").append(" inner join T_HR_SCmpItemCatalog on T_HR_SCmpItemCatalog.fnumber=T_HR_CMPITEMCAT.Fnumber").append(" where cmpitem.FNumber not like 'FPER%' and cmpitem.FNumber!='FSAL000' ").append(" and cmpitem.fnumber not in (select fnumber from t_hr_scmpitem) ");
        if (cmpItem_diff.length() > 0) {
            sql.append(" and cmpitem.fnumber not in (" + cmpItem_diff.deleteCharAt(cmpItem_diff.length() - 1).toString() + ")");
        }
        sql.append(" ) As B group by B.Fnumber,B.FDataType,B.Flength,B.FDecDigital,B.fname_" + l + ", B.Catalog_fid ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (cmpItem_diff.length() > 0) {
            String insert_sql = "insert into T_HR_SCmpItem(fid,fnumber,FDataType,FDataLength,FDataDot,fname_" + l + ",FCmpItemCatalogID,FoldCmpItemId,FHrOrgUnitID,FAdminOrgUnitID) select newBosid('FCB49097'),cmpitem.fnumber,1 as FDataType,max(cmpitem.flength),max(cmpitem.FDecDigital),max(cmpitem.fname_" + l + "),max(T_HR_SCmpItemCatalog.fid) as Catalog_fid,'FoldCmpItemId' as FoldCmpItemId,'" + curOrg + "','" + curOrg + "' from t_hr_cmpItem as cmpitem inner join T_HR_CMPITEMCAT on cmpitem.FCmpItemCatalogID=T_HR_CMPITEMCAT.fid  inner join T_HR_SCmpItemCatalog on T_HR_SCmpItemCatalog.fnumber=T_HR_CMPITEMCAT.Fnumber where cmpitem.fdataType not in(40,50,60) and cmpitem.fnumber not in (select fnumber from t_hr_scmpitem) and cmpitem.fnumber in (" + cmpItem_diff + ")  group by  cmpitem.fnumber";
            DbUtil.execute((Context)ctx, (String)insert_sql);
            insert_sql = "insert into T_HR_SCmpItem(fid,fnumber,FDataType,FDataLength,FDataDot,fname_" + l + ",FCmpItemCatalogID,FoldCmpItemId,FHrOrgUnitID,FAdminOrgUnitID) select newBosid('FCB49097'),cmpitem.fnumber,0 as FDataType,max(cmpitem.flength),max(cmpitem.FDecDigital),max(cmpitem.fname_" + l + "),max(T_HR_SCmpItemCatalog.fid) as Catalog_fid,'FoldCmpItemId' as FoldCmpItemId,'" + curOrg + "','" + curOrg + "' from t_hr_cmpItem as cmpitem inner join T_HR_CMPITEMCAT on cmpitem.FCmpItemCatalogID=T_HR_CMPITEMCAT.fid  inner join T_HR_SCmpItemCatalog on T_HR_SCmpItemCatalog.fnumber=T_HR_CMPITEMCAT.Fnumber where cmpitem.fdataType  in(40,50,60) and cmpitem.fnumber not in (select fnumber from t_hr_scmpitem) and cmpitem.fnumber in (" + cmpItem_diff + ")  group by  cmpitem.fnumber";
            DbUtil.execute((Context)ctx, (String)insert_sql);
        }
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance((Context)ctx);
        String cmpItem_fnumber = null;
        com.kingdee.shr.compensation.CmpItemInfo cmpItemInfo = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            cmpItem_fnumber = (String)list.get(i);
            try {
                if (!iCmpItem.exists(" where number='" + cmpItem_fnumber + "'")) {
                    throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION6, new Object[]{cmpItem_fnumber})));
                }
                cmpItemInfo = iCmpItem.getCmpItemInfo(" where number='" + cmpItem_fnumber + "'");
                this.handler_FieldSn(ctx, cmpItemInfo);
                continue;
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        String sql2 = "update   T_HR_ScmpItem set fnumber = (select  c.oldNum from (select distinct T_HR_ScmpItem.FID newId, T_HR_cmpItem.Fname_" + l + " oldName,T_HR_ScmpItem.Fname_" + l + " newName, T_HR_cmpItem.Fnumber oldNum,T_HR_ScmpItem.Fnumber newNum from T_HR_cmpItem inner join T_HR_ScmpItem on T_HR_cmpItem.Fname_" + l + " = T_HR_ScmpItem.Fname_" + l + " where  T_HR_cmpItem.Fnumber <> T_HR_ScmpItem.Fnumber ) c where c.newId=T_HR_ScmpItem.fid)  where T_HR_ScmpItem.FID in ( select  d.newId from (select distinct T_HR_ScmpItem.FID newId, T_HR_cmpItem.Fname_" + l + " oldName,T_HR_ScmpItem.Fname_" + l + " newName, T_HR_cmpItem.Fnumber oldNum,T_HR_ScmpItem.Fnumber newNum from T_HR_cmpItem inner join T_HR_ScmpItem on T_HR_cmpItem.Fname_" + l + " = T_HR_ScmpItem.Fname_" + l + " where T_HR_cmpItem.Fnumber <> T_HR_ScmpItem.Fnumber or T_HR_ScmpItem.Fnumber is null ) d)";
    }

    private void handler_FieldSn(Context ctx, com.kingdee.shr.compensation.CmpItemInfo model) throws BOSException, SQLException, EASBizException {
        com.kingdee.shr.compensation.CmpItemInfo item;
        String sql = "select max(FieldSn) from T_HR_SCmpItem";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        int fieldSn = 0;
        if (list.next()) {
            fieldSn = list.getInt(1);
        }
        if ((item = model).getFieldSn() == 0) {
            item.setFieldSn(fieldSn + 1);
        }
        DbUtil.execute((Context)ctx, (String)("update T_HR_SCmpItem set FieldSn=" + item.getFieldSn() + " where fid='" + item.getId().toString() + "'"));
        this.cmpItemDataType_Map = this.getAllCmpItem_EAS_CmpItemType(ctx);
        StringBuffer lertSql = new StringBuffer();
        lertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='S" + item.getFieldSn() + "' and KSQL_COL_TABNAME='t_hr_scmpcaltable') ").append(" alter table t_hr_scmpcaltable  add S" + item.getFieldSn());
        if (item.getDataType() == CmpItemDataType.NUMBER) {
            lertSql.append(" numeric(20,10)");
        } else if (this.cmpItemDataType_Map.containsKey(item.getNumber())) {
            int length = Integer.parseInt(this.cmpItemDataType_Map.get(item.getNumber())) * 2;
            lertSql.append(" nvarchar(" + length + ")");
        } else {
            lertSql.append(" nvarchar(255)");
        }
        DbUtil.execute((Context)ctx, (String)lertSql.toString());
    }

    public void alertCalResultTable(Context ctx) throws BOSException, SQLException {
        String sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        while (rowSet1.next()) {
            list.add(rowSet1.getString("KSQL_COL_NAME"));
        }
        String l = HRUtils.getShortCode(ctx);
        String getAllCmpItem_EAS_SQL = "select distinct fnumber,fname_" + l + " AS fname from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000' order by fnumber";
        Map<String, String> cmpItemMap = this.getAllCmpItem_EAS_SQL(getAllCmpItem_EAS_SQL, ctx);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            cmpItemMap.remove(list.get(i));
        }
        Set<Map.Entry<String, String>> set = cmpItemMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String fnumber = entry.getKey();
            StringBuffer alertSql = new StringBuffer();
            alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + fnumber + "' and KSQL_COL_TABNAME='" + tableName + "') ").append("alter table T_HR_SCHM_SummaryRecord  add " + fnumber + " VARCHAR(44) NULL;");
            DbUtil.execute((Context)ctx, (String)alertSql.toString());
        }
        StringBuffer alertSql = new StringBuffer();
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FBEGINDATE' and KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord') ").append("alter table T_HR_SCHM_SummaryRecord  add FBEGINDATE DateTime NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
        alertSql = new StringBuffer();
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FENDDATE' and KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord') ").append("alter table T_HR_SCHM_SummaryRecord  add FENDDATE DateTime NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
        alertSql = new StringBuffer();
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FOldSchemeId' and KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord') ").append("alter table T_HR_SCHM_SummaryRecord  add FOldSchemeId VARCHAR(44) NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
    }

    public void synPeriodYearMontToSCalSchemeHIS(Context ctx) throws BOSException {
        String subSql;
        StringBuffer insert_sql;
        String adminOrgId;
        String cmpSchemeId;
        int i;
        StringBuffer alertSql = new StringBuffer();
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='foldEasSchemId_Period_Time' and KSQL_COL_TABNAME='T_HR_SCalSchemeHIS') ").append("alter table T_HR_SCalSchemeHIS  add foldEasSchemId_Period_Time VARCHAR(91) NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
        CmpSchemeCollection coll = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeCollection(" where histableName is not null");
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            String histableName = coll.get(i).getHisTableName();
            cmpSchemeId = coll.get(i).getId().toString();
            adminOrgId = coll.get(i).getAdminOrg().getId().toString();
            insert_sql = new StringBuffer();
            subSql = "(select fid from T_HR_SCalScheme where foldEascmpSchemeId='" + cmpSchemeId + "') as FCalSchemeID";
            insert_sql.append("insert into T_HR_SCalSchemeHIS(fid,FCalSchemeID,FAdminOrgUnitID,FCalTime,FBeginDate,FEndDate,FPeriodYear,FPeriodMonth,foldEasSchemId_Period_Time)").append(" select  newbosid('3F665B21')," + subSql + ",'" + adminOrgId + "' as FAdminOrgUnitID,temptable.ftime,period.fBeginDate,period.FEndDate,period.FCmpPeriodYear,period.FCmpPeriod,'" + cmpSchemeId + "'||temptable.FPeriod||convert(varchar(3),temptable.ftime) as foldEasSchemId_Period_Time from ").append(" (select distinct histable.fperiod,histable.ftime from " + histableName + " as histable) as temptable").append(" inner join T_HR_CMPPERIOD period on period.fid=temptable.FPeriod").append(" where not exists(select 1 from T_HR_SCalSchemeHIS where T_HR_SCalSchemeHIS.foldEasSchemId_Period_Time='" + cmpSchemeId + "'||temptable.FPeriod||convert(varchar(3),temptable.ftime))");
            DbUtil.execute((Context)ctx, (String)insert_sql.toString());
        }
        coll = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeCollection(" where horTableName is not null");
        size = coll.size();
        for (i = 0; i < size; ++i) {
            String horTableName = coll.get(i).getHorTableName();
            cmpSchemeId = coll.get(i).getId().toString();
            adminOrgId = coll.get(i).getAdminOrg().getId().toString();
            insert_sql = new StringBuffer();
            subSql = "(select fid from T_HR_SCalScheme where foldEascmpSchemeId='" + cmpSchemeId + "') as FCalSchemeID";
            insert_sql.append("insert into T_HR_SCalSchemeHIS(fid,FCalSchemeID,FAdminOrgUnitID,FCalTime,FBeginDate,FEndDate,FPeriodYear,FPeriodMonth,foldEasSchemId_Period_Time)").append("select  newbosid('3F665B21')," + subSql + ",'" + adminOrgId + "' as FAdminOrgUnitID,temptable.ftime,period.fBeginDate,period.FEndDate,period.FCmpPeriodYear,period.FCmpPeriod,'" + cmpSchemeId + "'||temptable.FPeriod||convert(varchar(3),temptable.ftime) as foldEasSchemId_Period_Time from ").append(" (select distinct histable.fperiod,histable.ftime from " + horTableName + " as histable) as temptable").append(" inner join T_HR_CMPPERIOD period on period.fid=temptable.FPeriod").append(" where not exists(select 1 from T_HR_SCalSchemeHIS where T_HR_SCalSchemeHIS.foldEasSchemId_Period_Time='" + cmpSchemeId + "'||temptable.FPeriod||convert(varchar(3),temptable.ftime))");
            DbUtil.execute((Context)ctx, (String)insert_sql.toString());
        }
        String sql = "update T_HR_SCmpCalTable set FCalState = 20,FIsCal = null,FIsAudit = null,FIsGive = null where FIsCal = 'Y' and FIsAudit = 'Y' and FIsGive = 'Y'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void synCmpschemeAndSchemeItem(Context ctx) throws BOSException {
        StringBuffer alertSql = new StringBuffer();
        String colName = "foldEasCmpSchemeId";
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + colName + "' and KSQL_COL_TABNAME='T_HR_SCalScheme') ").append("alter table T_HR_SCalScheme  add " + colName + " VARCHAR(44) NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
        String l = HRUtils.getShortCode(ctx);
        String insertValSql = "insert into T_HR_SCalScheme(fid,FName_" + l + ",FNumber,foldEasCmpSchemeId,FBeginDate,FEndDate,FPeriodYear,FPeriodMonth,FAdminOrgUnitID,FCalTime,FCalState)  select newBosid('FFCDF2B1'),scheme.Fname_" + l + ",scheme.fnumber,scheme.fid,period.FBeginDate,period.FEndDate,period.FCmpPeriodYear,period.FCmpPeriod,scheme.fadminOrgId,scheme.FTime,'1' from T_HR_CMPSCHEME scheme inner join T_HR_CMPPERIOD period on period.fid=scheme.FCmpPeriod Where not exists(select 1 from T_HR_SCalScheme where T_HR_SCalScheme.foldEasCmpSchemeId=scheme.fid)";
        DbUtil.execute((Context)ctx, (String)insertValSql.toString());
        alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='foldId' and KSQL_COL_TABNAME='T_HR_SCalSchemeItem') ").append("alter table T_HR_SCalSchemeItem  add foldId VARCHAR(90) NULL;");
        DbUtil.execute((Context)ctx, (String)alertSql.toString());
        StringBuffer insertBf = new StringBuffer();
        insertBf.append("insert into T_HR_SCalSchemeItem (fid,FCalSchemeID,FCmpItemID,FSortSn,FIsPayTotal,FIsGenerate,FIsCostBear,foldId)").append(" select fid,FCmpSchemeID,FCmpItemID,FSortOrder,FIsVisible,FIsValueKeep,FIsForGrant,foldId from(").append(" select newBosid('FFCDF2B1') fid,T_HR_SCalScheme.fid as FCmpSchemeID,T_HR_SCmpItem.fid as FCmpItemID,FSortOrder,FIsVisible,FIsValueKeep,FIsForGrant,T_HR_CMPSCHEME.fid||oldSchemeItem.fid foldId from").append(" T_HR_CMPSCHEMEITEM oldSchemeItem").append(" inner join T_HR_CMPSCHEME on T_HR_CMPSCHEME.fid=oldSchemeItem.FCmpSchemeID").append(" inner join T_HR_SCalScheme on T_HR_SCalScheme.foldEasCmpSchemeId=T_HR_CMPSCHEME.fid").append("  inner join T_HR_CmpItem on T_HR_CmpItem.fid=oldSchemeItem.FCmpItemID").append("  inner join T_HR_SCmpItem on T_HR_SCmpItem.fnumber=T_HR_CmpItem.fnumber").append(" where T_HR_CMPSCHEME.fhistableName is not null").append(") b").append(" where  not exists(select 1 from T_HR_SCalSchemeItem where T_HR_SCalSchemeItem.foldId=b.foldId)");
        DbUtil.execute((Context)ctx, (String)insertBf.toString());
    }

    public void updateSchemeBeginDateAndEndDate(Context ctx, String schemeId) throws BOSException {
        String beginDate_sql = "select t_hr_cmpperiod.FBeginDate from T_HR_cmpScheme inner join t_hr_cmpperiod on T_HR_cmpScheme.FCmpPeriod=t_hr_cmpperiod.fid where T_HR_cmpScheme.fid='" + schemeId + "' ";
        String endDate_sql = "select t_hr_cmpperiod.FendDate from T_HR_cmpScheme inner join t_hr_cmpperiod on T_HR_cmpScheme.FCmpPeriod=t_hr_cmpperiod.fid where T_HR_cmpScheme.fid='" + schemeId + "'";
        String FCalTime_sql = "select T_HR_cmpScheme.FTime from T_HR_cmpScheme inner join t_hr_cmpperiod on T_HR_cmpScheme.FCmpPeriod=t_hr_cmpperiod.fid where T_HR_cmpScheme.fid='" + schemeId + "'";
        String FPeriodYear_sql = "select t_hr_cmpperiod.FCmpPeriodYear from T_HR_cmpScheme inner join t_hr_cmpperiod on T_HR_cmpScheme.FCmpPeriod=t_hr_cmpperiod.fid where T_HR_cmpScheme.fid='" + schemeId + "'";
        String FPeriodMonth_sql = "select t_hr_cmpperiod.FCmpPeriod from T_HR_cmpScheme inner join t_hr_cmpperiod on T_HR_cmpScheme.FCmpPeriod=t_hr_cmpperiod.fid where T_HR_cmpScheme.fid='" + schemeId + "'";
        String sql = "update T_HR_SCalScheme set  FBeginDate=(" + beginDate_sql + "),FEndDate=(" + endDate_sql + "),FPeriodYear=(" + FPeriodYear_sql + "),FPeriodMonth=(" + FPeriodMonth_sql + "),FCalTime=(" + FCalTime_sql + ") where foldEasCmpSchemeId='" + schemeId + "'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

