/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.activity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.contract.ContractBizException;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.shr.shareservice.strategy.JobInnerOperation;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractBizBillActivityImpl
implements JobInnerOperation {
    private static Logger logger = LoggerFactory.getLogger(ContractBizBillActivityImpl.class);

    public Map<String, String> getUserParam(Context ctx, String billId, String activityId, String jobId, Map param) throws BOSException, EASBizException {
        String personId;
        String msg = "ContractBizBillActivityImpl.getUserParam billId: {0} activityId: {1} jobId: {2} param: {3} ";
        logger.error(MessageFormat.format(msg, billId, activityId, jobId, JSONUtils.convertObjectToJson((Context)ctx, (Object)param)));
        HashMap<String, String> result = new HashMap<String, String>();
        if (param != null && param.get("personId") != null && !StringUtils.isEmpty((CharSequence)(personId = (String)param.get("personId")))) {
            String oql = "where state = 1 and employee = '" + personId + "'";
            EmployeeContractCollection empContractColl = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(oql);
            if (empContractColl.isEmpty()) {
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("number"));
                coll.add(new SelectorItemInfo("name"));
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), coll);
                String personParm = personInfo.getNumber() + "_" + personInfo.getName();
                throw new ContractException(ContractException.SRC_CONTRACT_NOT_EFFECT, new Object[]{personParm});
            }
            String contractId = empContractColl.get(0).getId().toString();
            try {
                result.put("contractId", URLEncoder.encode(contractId, "UTF-8"));
                result.put("billId", URLEncoder.encode(contractId, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("03", e.getMessage()));
            }
        }
        result.put("ignoreHROrgF7Cache", "true");
        return result;
    }

    public Map<String, Object> checkCreateRule(Context ctx, String billId, String activityId, String personId, Map param) throws EASBizException, BOSException {
        String msg = "ContractBizBillActivityImpl.checkCreateRule billId: {0} activityId: {1} personId: {2} param: {3} ";
        logger.error(MessageFormat.format(msg, billId, activityId, personId, JSONUtils.convertObjectToJson((Context)ctx, (Object)param)));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        ContractBizException contractBizException = new ContractBizException(ContractBizException.EXCEPTION10);
        result.put("data", contractBizException.getMessage());
        if (!StringUtils.isEmpty((CharSequence)personId)) {
            String oql = "where state = 1 and employee = '" + personId + "'";
            EmployeeContractCollection empContractColl = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(oql);
            if (empContractColl.isEmpty()) {
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("number"));
                coll.add(new SelectorItemInfo("name"));
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), coll);
                String personParm = personInfo.getNumber() + "_" + personInfo.getName();
                ContractException except = new ContractException(ContractException.SRC_CONTRACT_NOT_EFFECT, new Object[]{personParm});
                result.put("data", except.getMessage());
            } else {
                result = new HashMap();
                result.put("success", true);
            }
        }
        return result;
    }
}

