/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractChangeBizBill;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractChangeBizBillFactory;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.HRBizSource;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractChangeBizBillEntry;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IOtherContractChangeBizBillEntry;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractChangeBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractChangeBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.ContractUtilsEx;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractSourceStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ContractChangeBizBillControllerBean
extends AbstractContractChangeBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractChangeBizBillControllerBean.class);
    protected static final String ENTRY_ENTITYNAME = "com.kingdee.eas.hr.contract.app.ContractChangeBizBillEntry";

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractChangeBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractChangeBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractChangeBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate;
        Date now;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        ContractChangeBizBillEntryInfo ccbbeInfo = (ContractChangeBizBillEntryInfo)entry;
        ContractChangeBizBillInfo ccbbInfo = (ContractChangeBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(ccbbeInfo.getBill().getId()));
        EmployeeContractInfo employeeContract = new EmployeeContractInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_EmployeeContract where fcontractno = '").append(ccbbeInfo.getContractNo()).append("'").append(" and fEmployeeId='").append(ccbbeInfo.getPerson().getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LabContractFirstPartyInfo firstParty = ccbbeInfo.getLabContractFirstParty();
        firstParty = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(firstParty.getId()));
        if (rs.size() == 0) {
            employeeContract.setContractNo(ccbbeInfo.getContractNo());
            employeeContract.setEmployee(ccbbeInfo.getPerson());
            employeeContract.setContractTemplet(ccbbeInfo.getContractTemplet());
            employeeContract.setRecordDate(ccbbeInfo.getSignDate());
            employeeContract.setEffectDate(ccbbeInfo.getBizDate());
            employeeContract.setEndDate(ccbbeInfo.getEndDate());
            employeeContract.setDescription(ccbbeInfo.getDescription());
            employeeContract.setState(EmployeeContractState.RECORD);
            employeeContract.setReason(ccbbeInfo.getChangeReason());
            employeeContract.setToUnit(ccbbeInfo.getToUnit());
            employeeContract.setDelegatePerson(ccbbeInfo.getDelegatePerson(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setDelegatePerson(ccbbeInfo.getDelegatePerson(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setDelegatePerson(ccbbeInfo.getDelegatePerson(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setToUnitAddress(ccbbeInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setToUnitAddress(ccbbeInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setToUnitAddress(ccbbeInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setEmpIdentityNum(ccbbeInfo.getIdCardNo());
            employeeContract.setEmpAddress(ccbbeInfo.getAddress());
            employeeContract.setCredentialsType(ccbbeInfo.getCredentialsType());
            employeeContract.setEmpPassPortNum(ccbbeInfo.getPassportNo());
            employeeContract.setHrOrgUnit(ccbbInfo.getHrOrgUnit());
            employeeContract.setContSerLimit(ccbbeInfo.getContractServerLimit());
            employeeContract.setVip(false);
            employeeContract.setTestBeginDate(ccbbeInfo.getTestBeginDate());
            employeeContract.setTestEndDate(ccbbeInfo.getTestEndDate());
            employeeContract.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContract.setContractLimitType(ccbbeInfo.getContractLimitType());
            employeeContract.setThirdDelegatePerson(ccbbeInfo.getThirdDelegatePerson());
            employeeContract.setThirdUnitName(ccbbeInfo.getThirdUnit());
            employeeContract.setThirdUnitAddress(ccbbeInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)ccbbeInfo.getContractLimit())) {
                employeeContract.setContractLimitAuto(new BigDecimal(ccbbeInfo.getContractLimit()));
            }
            employeeContract.setPenalty(ccbbeInfo.getPenalty());
            employeeContract.setCompensation(ccbbeInfo.getCompensation());
            employeeContract.setAppraisal(ccbbeInfo.getAppraisal());
            employeeContract.setAppraDate(ccbbeInfo.getAppraDate());
            employeeContract.setIsInAdmin(ccbbeInfo.isIsInAdmin());
            employeeContract.setContractSourceState(EmployeeContractSourceStateEnum.FROM_CHANGED);
            employeeContract.setPositionString(ccbbeInfo.getPositionString());
            employeeContract.setContractAgreedSalary(ccbbeInfo.getContractAgreedSalary());
            employeeContract.setLabContractFirstParty(firstParty);
            employeeContract.setAdminOrg(ccbbeInfo.getAdminOrg());
            employeeContract.setIsChanged(false);
            if (ccbbInfo.getApproveType().getValue() == 1) {
                employeeContract.setIsWorkflow(true);
            } else {
                employeeContract.setIsWorkflow(false);
            }
            EmployeeContractInfo sourceContract = ccbbeInfo.getSourceContract();
            sourceContract = iECF.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(sourceContract.getId()));
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)ccbbeInfo.getBizDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)ccbbeInfo.getBizDate(), (Date)curDate)) {
                sourceContract.setState(EmployeeContractState.END);
            }
            sourceContract.setNewState(EmployeeContractNewStateEnum.CHANGED);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            iECF.updatePartial((CoreBaseInfo)sourceContract, selector);
            employeeContract.setSourceContract(sourceContract);
            employeeContract.setCreator(ccbbInfo.getCreator());
            employeeContract.setCreateTime(ccbbInfo.getCreateTime());
            employeeContract.setIsContinuousSigned(sourceContract.isIsContinuousSigned());
            employeeContract.setContinuousSignedCount(sourceContract.getContinuousSignedCount());
            employeeContract.put("notNeedGenerateObjectNumber", (Object)true);
            ContractTempletInfo templetInfo = ccbbeInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId()));
            if (templetInfo.isIsElectronicSign() && ccbbInfo.getBizSource() != null && 1 == ccbbInfo.getBizSource().getValue()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicSsc);
                employeeContract.setSignStatus(EContractSignState.complete);
                employeeContract.setIsElectronicSign(templetInfo.isIsElectronicSign());
            } else if (templetInfo.isIsElectronicSign() && ccbbInfo.getBizSource() != null && 0 == ccbbInfo.getBizSource().getValue()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicEmp);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            } else {
                employeeContract.setContractClassify(ContractClassifyEnum.Normal);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            }
            IObjectPK contractId = iECF.addnew((CoreBaseInfo)employeeContract);
            this.updateSourceContractDate(ctx, employeeContract);
            employeeContract.setId(BOSUuid.read((String)contractId.toString()));
            this.reverseEmployeeContractAttachment(ctx, employeeContract, entry);
            super._entryEffect(ctx, entry);
        }
        if (!(now = new Date()).before(effectDate = this.getEffectDate(entry))) {
            this.updateHRContractInfo_afterEffect(ctx, ccbbeInfo);
        }
        if (null != ccbbInfo.getOtherEntrys()) {
            this.otherFollowLaborContract(ctx, ccbbInfo);
        }
    }

    protected void otherFollowLaborContract(Context ctx, ContractChangeBizBillInfo billInfo) throws EASBizException, BOSException {
        ContractChangeBizBillEntryInfo billEntryInfo = billInfo.getEntrys().get(0);
        OtherContractChangeBizBillEntryCollection otherEntrys = billInfo.getOtherEntrys();
        if (otherEntrys != null && otherEntrys.size() > 0) {
            logger.info("otherEntrys_ size is " + otherEntrys.size());
            IOtherContractChangeBizBillEntry iOtherContractChangeBizBillEntry = OtherContractChangeBizBillEntryFactory.getLocalInstance(ctx);
            IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < otherEntrys.size(); ++i) {
                String otherEntryId = otherEntrys.get(i).getId().toString();
                String oql = "where id = '" + otherEntryId + "'";
                logger.info("oql_ is : " + oql);
                OtherContractChangeBizBillEntryInfo otherEntryInfo = iOtherContractChangeBizBillEntry.getOtherContractChangeBizBillEntryInfo(oql);
                EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
                oContractInfo.setContractNo(otherEntryInfo.getContractNo());
                oContractInfo.setEmployee(otherEntryInfo.getPerson());
                oContractInfo.setContractLimitType(otherEntryInfo.getContractLimitType());
                oContractInfo.setContractTemplet(otherEntryInfo.getContractTemplet());
                oContractInfo.setRecordDate(otherEntryInfo.getSignDate());
                oContractInfo.setEffectDate(otherEntryInfo.getBizDate());
                oContractInfo.setEndDate(otherEntryInfo.getEndDate());
                oContractInfo.setDescription(billEntryInfo.getDescription());
                oContractInfo.setState(EmployeeContractState.RECORD);
                oContractInfo.setReason(billEntryInfo.getChangeReason());
                oContractInfo.setToUnit(billEntryInfo.getToUnit());
                oContractInfo.setLabContractFirstParty(billEntryInfo.getLabContractFirstParty());
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                oContractInfo.setEmpIdentityNum(otherEntryInfo.getIdCardNo());
                oContractInfo.setEmpAddress(otherEntryInfo.getAdrress());
                oContractInfo.setEmpPassPortNum(otherEntryInfo.getPassportNo());
                oContractInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
                oContractInfo.setContSerLimit(billEntryInfo.getContractServerLimit());
                oContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                oContractInfo.setContractLimitType(otherEntryInfo.getContractLimitType());
                oContractInfo.setThirdDelegatePerson(billEntryInfo.getThirdDelegatePerson());
                oContractInfo.setThirdUnitName(billEntryInfo.getThirdUnit());
                oContractInfo.setThirdUnitAddress(billEntryInfo.getThirdUnitAddress());
                if (!StringUtils.isEmpty((String)otherEntryInfo.getContractLimit())) {
                    oContractInfo.setContractLimitAuto(new BigDecimal(otherEntryInfo.getContractLimit()));
                }
                oContractInfo.setPenalty(billEntryInfo.getPenalty());
                oContractInfo.setCompensation(billEntryInfo.getCompensation());
                oContractInfo.setAppraisal(billEntryInfo.getAppraisal());
                oContractInfo.setAppraDate(billEntryInfo.getAppraDate());
                oContractInfo.setIsInAdmin(billEntryInfo.isIsInAdmin());
                oContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
                oContractInfo.setIsChanged(false);
                if (billInfo.getApproveType().getValue() == 1) {
                    oContractInfo.setIsWorkflow(true);
                } else {
                    oContractInfo.setIsWorkflow(false);
                }
                oContractInfo.setEntryID(otherEntryInfo.getId().toString());
                oContractInfo.setPositionString(billEntryInfo.getPositionString());
                oContractInfo.setContractAgreedSalary(billEntryInfo.getContractAgreedSalary());
                oContractInfo.setAdminOrg(otherEntryInfo.getAdminOrg());
                oContractInfo.setPreEntryPerson(null);
                oContractInfo.setSignStatus(EContractSignState.complete);
                oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicSsc);
                oContractInfo.setCredentialsType(billEntryInfo.getCredentialsType());
                IObjectPK contractId = iEmployeeOtherContract.addnew((CoreBaseInfo)oContractInfo);
                oContractInfo.setId(BOSUuid.read((String)contractId.toString()));
            }
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setLabContractFirstPartyName(ctx, model);
        IObjectPK retValue = super._submit(ctx, model);
        this.afterProcessContractChangeData(ctx, model, true);
        return retValue;
    }

    protected void setLabContractFirstPartyName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractChangeBizBillInfo ccbbInfo = (ContractChangeBizBillInfo)model;
        ContractChangeBizBillEntryCollection ccbbeInfoCol = ccbbInfo.getEntrys();
        if (ccbbeInfoCol != null && ccbbeInfoCol.size() > 0) {
            for (int i = 0; i < ccbbeInfoCol.size(); ++i) {
                ContractChangeBizBillEntryInfo ccbbeInfo = ccbbeInfoCol.get(i);
                LabContractFirstPartyInfo labContractFirstParty = ccbbeInfo.getLabContractFirstParty();
                if (labContractFirstParty == null || labContractFirstParty.getId() == null) continue;
                String labContractFirstPartyName = labContractFirstParty.getName();
                if (StringUtils.isEmpty((String)labContractFirstPartyName)) {
                    labContractFirstPartyName = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstParty.getId())).getName();
                }
                ccbbeInfo.setLCFPName(labContractFirstPartyName);
            }
        }
    }

    private void afterProcessContractChangeData(Context ctx, IObjectValue model, boolean isAddNew) throws EASBizException, BOSException {
        ContractChangeBizBillInfo billInfo = (ContractChangeBizBillInfo)model;
        if (!HRBizSource.SSC.equals((Object)billInfo.getBizSource())) {
            return;
        }
        try {
            ContractChangeBizBillEntryCollection entryColl = billInfo.getEntrys();
            ContractChangeBizBillEntryInfo entryInfo = entryColl.get(0);
            ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
            if (templetInfo.isIsElectronicSign()) {
                String clazzName = "com.kingdee.shr.econtractservice.service.ContractBizBillService";
                String methodName = "processEContractData";
                Class<?> clazz = Class.forName(clazzName);
                Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{Context.class, IObjectValue.class, Boolean.class});
                if (method == null) {
                    throw new BOSException("can not find com.kingdee.shr.econtractservice.service.ContractBizBillService processEContractData");
                }
                ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{ctx, model, isAddNew});
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof UndeclaredThrowableException) {
                Throwable t = e.getCause();
                logger.error(t.getMessage(), t);
                if (t instanceof EASBizException) {
                    throw (EASBizException)t;
                }
                if (t instanceof BOSException) {
                    throw (BOSException)t;
                }
                throw new BOSException(t.getMessage(), t);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateSourceContractDate(Context ctx, EmployeeContractInfo employeeContract) throws EASBizException, BOSException {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        EmployeeContractInfo sourceContract = employeeContract.getSourceContract();
        SelectorItemCollection selector = new SelectorItemCollection();
        if (DateTimeUtils.dayEquals((Date)employeeContract.getEffectDate(), (Date)sourceContract.getEffectDate())) {
            sourceContract.setEndDateReal(sourceContract.getEffectDate());
            selector.add(new SelectorItemInfo("endDateReal"));
            sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        } else if ((DateTimeUtils.dayBefore((Date)employeeContract.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)employeeContract.getEffectDate(), (Date)curDate)) && (sourceContract.getEndDate() == null || sourceContract.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceContract.getEndDate(), (Date)employeeContract.getEffectDate()))) {
            sourceContract.setEndDateReal(HRUtil.getBeforeDate((Date)employeeContract.getEffectDate()));
            selector.add(new SelectorItemInfo("endDateReal"));
            sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        }
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)sourceContract, selector);
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        this.beforeAbortBizBill(ctx, billId);
        super._abortBizBill(ctx, billId);
        this.afterAbortBizBill(ctx, billId);
    }

    protected void beforeAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
    }

    protected void afterAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            ElectronicContractRelationFactory.getLocalInstance(ctx).delete("where billID = '" + billId + "'");
        }
    }

    private void updateHRContractInfo_afterEffect(Context ctx, ContractChangeBizBillEntryInfo ccbbeInfo) throws EASBizException, BOSException {
        HRContractInfoInfo hRContractInfo = HRContractInfoUtils.getHRContractInfo(ctx, ccbbeInfo.getBill().getId().toString(), ccbbeInfo.getContractNo());
        hRContractInfo.setState(EmployeeContractState.RECORD);
        hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        hRContractInfo.setReason(ccbbeInfo.getChangeReason());
        hRContractInfo.setDescription(ccbbeInfo.getDescription());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("employeeContract"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("description"));
        String oql = "select id where contractNo='" + ccbbeInfo.getContractNo() + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = iEmployeeContract.getEmployeeContractInfo(oql);
        hRContractInfo.setEmployeeContract(contractInfo);
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        iHRContractInfo.updatePartial(hRContractInfo, selector);
        EmployeeContractInfo sourceContract = ccbbeInfo.getSourceContract();
        oql = "select * where employeeContract.id='" + sourceContract.getId() + "'";
        HRContractInfoCollection infoColl = iHRContractInfo.getHRContractInfoCollection(oql);
        if (infoColl.size() > 0) {
            HRContractInfoInfo sourceHRContractInfo = infoColl.get(0);
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayEquals((Date)ccbbeInfo.getBizDate(), (Date)sourceHRContractInfo.getEffectDate())) {
                sourceHRContractInfo.setEndDateReal(sourceHRContractInfo.getEffectDate());
                selector.add(new SelectorItemInfo("endDateReal"));
                sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceHRContractInfo.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            } else if ((DateTimeUtils.dayBefore((Date)ccbbeInfo.getBizDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)ccbbeInfo.getBizDate(), (Date)curDate)) && sourceHRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceHRContractInfo.getEndDate(), (Date)ccbbeInfo.getBizDate())) {
                sourceHRContractInfo.setEndDateReal(HRUtil.getBeforeDate((Date)ccbbeInfo.getBizDate()));
                selector.add(new SelectorItemInfo("endDateReal"));
                sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceHRContractInfo.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            }
            sourceHRContractInfo.setState(EmployeeContractState.END);
            sourceHRContractInfo.setNewState(EmployeeContractNewStateEnum.CHANGED);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            iHRContractInfo.updatePartial(sourceHRContractInfo, selector);
        }
    }

    protected String _getOrgRange(Context ctx, String hrId) throws BOSException, EASBizException {
        String adminStr = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("select ADMINORG.FID from T_ORG_Admin ADMINORG ");
        sql.append("left join T_ORG_UnitRelation UNITRELATION on ADMINORG.FID = UNITRELATION.FFromUnitID ");
        sql.append("left join T_PM_OrgRange ORGRANGE on ADMINORG.FID = ORGRANGE.FORGID ");
        sql.append("left join T_PM_USER PUSER on PUSER.FID = ORGRANGE.FUSERID ");
        sql.append("where  ORGRANGE.FType = 20 and ADMINORG.FIsSealUp = 0 ");
        sql.append("and (UNITRELATION.FToUnitID = '");
        sql.append(hrId);
        sql.append("' and UNITRELATION.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append("and PUSER.FID = '");
        sql.append(userId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer adminIdStr = new StringBuffer();
        try {
            while (rs.next()) {
                adminIdStr.append("'");
                adminIdStr.append(rs.getString(1));
                adminIdStr.append("',");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (adminIdStr.length() > 0) {
            adminStr = adminIdStr.substring(0, adminIdStr.length() - 1);
        }
        return adminStr;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractChangeBizBillInfo ccbbInfo = (ContractChangeBizBillInfo)model;
        this.updateContractSignBillEntryContractNo(ctx, ccbbInfo);
        this.checkSourceContractNewState(ctx, ccbbInfo);
        this.checkChild(ctx, ccbbInfo);
        this.checkEntry(ctx, ccbbInfo);
        this.checkEntryIsInOther(ctx, ccbbInfo);
        this.checkDate(ctx, ccbbInfo);
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String orgID = curCuInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) {
            this.checkContNoIsRepeat(ctx, ccbbInfo);
        }
        this.checkHasContractByDate(ctx, (IObjectValue)ccbbInfo);
        this.checkLabPartyIsOpenElec(ctx, ccbbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        this.addNewHrContractInfo(ctx, ccbbInfo, objectPk);
        return objectPk;
    }

    protected void checkLabPartyIsOpenElec(Context ctx, ContractChangeBizBillInfo csbbInfo) throws EASBizException, BOSException {
        ContractChangeBizBillEntryCollection entrys;
        if (HRBizSource.SSC.equals((Object)csbbInfo.getBizSource()) && (entrys = csbbInfo.getEntrys()) != null && entrys.size() > 0) {
            for (int dex = 0; dex < entrys.size(); ++dex) {
                ContractChangeBizBillEntryInfo entryInfo = entrys.get(0);
                ContractTempletInfo contractTemplet = entryInfo.getContractTemplet();
                if (contractTemplet.get("isElectronicSign") == null) {
                    contractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
                }
                if (!contractTemplet.isIsElectronicSign()) continue;
                LabContractFirstPartyInfo labContractFirstParty = entryInfo.getLabContractFirstParty();
                ElectronicContractUtils.checkLabContractFirstPartyIsOpenElec((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
                ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
            }
        }
    }

    private void checkSourceContractNewState(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws BOSException, EASBizException {
        ContractChangeBizBillEntryInfo ccbbeInfo = null;
        int count = ccbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            ccbbeInfo = ccbbInfo.getEntrys().get(i);
            String sourceContractId = "";
            if (ccbbeInfo.getSourceContract() == null) continue;
            sourceContractId = ccbbeInfo.getSourceContract().getId().toString();
            try {
                EmployeeContractInfo employeeContractInfo = new EmployeeContractInfo();
                EmployeeContractCollection coll = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection("select * where id = '" + sourceContractId + "'");
                if (coll.size() <= 0) continue;
                employeeContractInfo = coll.get(0);
                if (DateTimeUtils.dayBefore((Date)ccbbeInfo.getBizDate(), (Date)employeeContractInfo.getEffectDate())) {
                    throw new ContractException(ContractException.CHANGEDATE_BEFORE_EFFECTDATE);
                }
                ContractUtils.checkContractChangeOrRenewException(ctx, ccbbeInfo.getPerson().getId().toString(), employeeContractInfo, "CONTRACT_OPT_CHANGE");
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        ContractChangeBizBillEntryCollection entries;
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof ContractChangeBizBillInfo && (entries = ((ContractChangeBizBillInfo)model).getEntrys()) != null) {
            ContractChangeBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = new EmployeeContractInfo();
            String number = null;
            CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String orgID = curCuInfo.getId().toString();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                this.assembleContractInfoForCoding(ctx, contractInfo, entry);
                contractInfo.setContractNo(((ContractChangeBizBillInfo)model).getNumber());
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) continue;
                number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, orgID);
                while (this.isEmpContractNumberExist(ctx, number)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, orgID);
                }
                if (number == null) continue;
                entry.setContractNo(number);
            }
        }
        this.updateContractSignBillEntryContractNo(ctx, (ContractChangeBizBillInfo)model);
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeContractInfo contractInfo, ContractChangeBizBillEntryInfo entry) {
        String entityName = "com.kingdee.eas.hr.emp.app.EmployeeContract";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = entry.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = entry.get(propName);
                Object retValue = ContractUtilsEx.getEnumValue(value);
                contractInfo.put(propName, retValue);
                continue block0;
            }
        }
        contractInfo.setEmployee(entry.getPerson());
        contractInfo.setEffectDate(entry.getBizDate());
        contractInfo.setRecordDate(entry.getSignDate());
    }

    private boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException {
        String oql = "where contractNo ='" + numberTemp + "'";
        EmployeeContractCollection coll = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(oql);
        return coll != null && coll.size() > 0;
    }

    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillInfo oldContractChangeBizBillInfo = this.getContractChangeBizBillInfo(ctx, pk);
            ContractChangeBizBillEntryCollection oldEntries = null;
            if (oldContractChangeBizBillInfo != null) {
                oldEntries = oldContractChangeBizBillInfo.getEntrys();
            }
            ContractChangeBizBillEntryCollection entries = ((ContractChangeBizBillInfo)model).getEntrys();
            ContractChangeBizBillEntryInfo oldEntry = null;
            ContractChangeBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = null;
            String contno = null;
            if (oldEntries != null) {
                boolean isDelete = true;
                int oldsize = oldEntries.size();
                for (int i = 0; i < oldsize; ++i) {
                    oldEntry = oldEntries.get(i);
                    if (entries != null) {
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            entry = entries.get(j);
                            if (!oldEntry.getId().equals((Object)entry.getId())) continue;
                            isDelete = false;
                            break;
                        }
                    }
                    if (isDelete) {
                        contractInfo = new EmployeeContractInfo();
                        contractInfo.setContractNo(((ContractChangeBizBillInfo)model).getNumber());
                        this._dispachIntermitNumber(ctx, oldEntry, contractInfo);
                        continue;
                    }
                    isDelete = true;
                }
            }
            if (entries != null) {
                contractInfo = new EmployeeContractInfo();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    if (entry.getId() != null) continue;
                    contractInfo.setEmployee(entry.getPerson());
                    contractInfo.setContractNo(((ContractChangeBizBillInfo)model).getNumber());
                    contno = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule((IObjectValue)contractInfo, null, null);
                    if (contno == null) continue;
                    entry.setContractNo(contno);
                }
            }
        }
    }

    private void _dispachIntermitNumber(Context ctx, ContractChangeBizBillEntryInfo entry, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        if (entry != null && entry.getContractNo() != null) {
            CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
        }
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        ContractChangeBizBillEntryCollection entries;
        super._dispachIntermitNumber(ctx, pk);
        ContractChangeBizBillInfo contractchangebizbill = this.getContractChangeBizBillInfo(ctx, pk);
        if (contractchangebizbill != null && (entries = contractchangebizbill.getEntrys()) != null) {
            ContractChangeBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = new EmployeeContractInfo();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.getContractNo() == null) continue;
                contractInfo.setContractNo(contractchangebizbill.getNumber());
                CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractChangeBizBillInfo ccbbInfo = (ContractChangeBizBillInfo)model;
        this.checkSourceContractNewState(ctx, ccbbInfo);
        this.checkChild(ctx, ccbbInfo);
        this.checkEntry(ctx, ccbbInfo);
        this.checkEntryIsInOther(ctx, ccbbInfo);
        this.checkDate(ctx, ccbbInfo);
        this.checkContNoIsRepeat(ctx, ccbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)ccbbInfo);
        this.checkLabPartyIsOpenElec(ctx, ccbbInfo);
        this.preProcess(ctx, pk, model);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, ccbbInfo, pk);
    }

    private void checkChild(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws EASBizException, BOSException {
        boolean isHaveChild = false;
        try {
            isHaveChild = ContractUtils.isHaveChild(ctx, ccbbInfo.getEntrys().get(0).getSourceContract().getId().toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        if (isHaveChild) {
            throw new ContractException(ContractException.CONTRACT_CHANGECHILD);
        }
    }

    private void checkDate(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws EASBizException, BOSException {
        ContractChangeBizBillEntryInfo ccbbeInfo = null;
        IContractTemplet iCTF = ContractTempletFactory.getLocalInstance((Context)ctx);
        ContractTempletInfo cTemplet = null;
        int size = ccbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ccbbeInfo = ccbbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, ccbbeInfo.getPerson().getId().toString());
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)ccbbeInfo.getContractLimitType()) && ccbbeInfo.getEndDate() == null) {
                throw new ContractException(ContractException.ENDDATE_ISNULL, new Object[]{personParm});
            }
            if (ccbbeInfo.getEndDate() != null) {
                if (DateTimeUtils.dayAfter((Date)ccbbeInfo.getBizDate(), (Date)ccbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.BIZDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
                if (DateTimeUtils.dayAfter((Date)ccbbeInfo.getSignDate(), (Date)ccbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.SIGNDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
            }
            if (ccbbeInfo.getPenalty() != null && ccbbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (ccbbeInfo.getCompensation() != null && ccbbeInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
            }
            if (ccbbeInfo.getContinuousSignedCount() < 0) {
                throw new ContractException(ContractException.CONTINUESIGNCOUNT_ISMINUS, new Object[]{personParm});
            }
            cTemplet = iCTF.getContractTempletInfo((IObjectPK)new ObjectUuidPK(ccbbeInfo.getContractTemplet().getId()));
            if (cTemplet.getInvalidDate() == null || !DateTimeUtils.dayBefore((Date)cTemplet.getInvalidDate(), (Date)new Date())) continue;
            throw new ContractException(ContractException.CONTEMPLET_INVALID, new Object[]{personParm});
        }
    }

    private void checkContNoIsRepeat(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws BOSException, ContractException {
        IEmployeeContract employeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        IContractChangeBizBillEntry iCCBBE = ContractChangeBizBillEntryFactory.getLocalInstance(ctx);
        ContractChangeBizBillEntryInfo ccbbeInfo = null;
        EmployeeContractCollection ecCol = null;
        ContractChangeBizBillEntryCollection ccbbCol = null;
        int size = ccbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ccbbeInfo = ccbbInfo.getEntrys().get(i);
            StringBuffer sql = new StringBuffer();
            sql.append("select id where contractNo = '" + ccbbeInfo.getContractNo() + "'");
            ecCol = employeeContract.getEmployeeContractCollection(sql.toString());
            StringBuffer whereStr = new StringBuffer("select id where contractNo = '");
            whereStr.append(ccbbeInfo.getContractNo());
            if (ccbbInfo.getId() != null) {
                whereStr.append("' and bill <> '");
                whereStr.append(ccbbInfo.getId().toString());
            }
            whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
            whereStr.append(HRUtil.getCurrentDate());
            whereStr.append("))");
            ccbbCol = iCCBBE.getContractChangeBizBillEntryCollection(whereStr.toString());
            if (ecCol.size() <= 0 && ccbbCol.size() <= 0) continue;
            throw new ContractException(ContractException.CONTRACTNO_REPEAT, new Object[]{ccbbeInfo.getContractNo()});
        }
    }

    private void checkHasContractByDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractChangeBizBillInfo ccbbInfo = (ContractChangeBizBillInfo)model;
        int size = ccbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ContractChangeBizBillEntryInfo ccbbeInfo = ccbbInfo.getEntrys().get(i);
            ContractTypeInfo contractTypeInfo = ContractTypeFactory.getLocalInstance((Context)ctx).getContractTypeInfo((IObjectPK)new ObjectUuidPK(ccbbeInfo.getContractType().getId().toString()));
            if (!contractTypeInfo.isIsLaborContract()) continue;
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            contractInfo.setBillID(ccbbInfo.getId());
            contractInfo.setEmployee(ccbbeInfo.getPerson());
            contractInfo.setEffectDate(ccbbeInfo.getBizDate());
            contractInfo.setContractLimitType(ccbbeInfo.getContractLimitType());
            contractInfo.setEndDate(ccbbeInfo.getEndDate());
            contractInfo.put("hrOrgUnit", ccbbInfo.getHrOrgUnit());
            HashSet<String> excludeContractNo = new HashSet<String>();
            EmployeeContractInfo srcContract = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(ccbbeInfo.getSourceContract().getId().toString()));
            excludeContractNo.add(srcContract.getContractNo());
            excludeContractNo.add(ccbbeInfo.getContractNo());
            ContractUtils.checkContractTimeIsCrossing(ctx, contractInfo, excludeContractNo, false);
        }
    }

    private void checkEntry(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws BOSException, EASBizException {
        ContractChangeBizBillEntryInfo ccbbeInfo1 = null;
        ContractChangeBizBillEntryInfo ccbbeInfo2 = null;
        int count = ccbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            ccbbeInfo1 = ccbbInfo.getEntrys().get(i);
            int size = ccbbInfo.getEntrys().size() - i;
            for (int j = i + 1; j < size; ++j) {
                ccbbeInfo2 = ccbbInfo.getEntrys().get(j);
                if (!ccbbeInfo1.getSourceContract().getId().equals((Object)ccbbeInfo2.getSourceContract().getId())) continue;
                throw new ContractException(ContractException.CONTRACT_REPEAT, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
            ContractUtils.checkContractInBillByType(ctx, ccbbeInfo1.getSourceContract().getId().toString(), ccbbInfo.getId(), BillTypeEnum.CHANGE, i + 1);
            ContractUtils.checkContractInBillByHRContractInfo(ctx, ccbbeInfo1.getSourceContract().getId().toString(), ccbbInfo.getId());
        }
    }

    private void checkEntryIsInOther(Context ctx, ContractChangeBizBillInfo ccbbInfo) throws BOSException, EASBizException {
        ContractChangeBizBillEntryInfo ccbbeInfo = null;
        int count = ccbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            ccbbeInfo = ccbbInfo.getEntrys().get(i);
            ccbbeInfo.getSourceContract().setEmployee(ccbbeInfo.getPerson());
            ContractUtils.checkContractIsInOther(ctx, ccbbeInfo.getSourceContract(), ContractChangeBizBill.class.getName(), i + 1);
        }
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        contractInfo.put("delegatePerson", entryInfo.get("delegatePerson"));
        contractInfo.put("reason", entryInfo.get("changeReason"));
        contractInfo.put("toUnit", entryInfo.get("toUnit"));
        ContractChangeBizBillEntryInfo ccbbInfo = (ContractChangeBizBillEntryInfo)entryInfo;
        contractInfo.setSourceContract(ccbbInfo.getSourceContract());
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
        if (bill != null) {
            this._mappingSubmit(ctx, bill);
        }
    }

    protected boolean isNeedMappingReWrite(Context ctx, HRBillBaseInfo bill) {
        return false;
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        String oql = "where billID = '" + billId + "'";
        HRContractInfoCollection hrContractInfoCollection = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql);
        for (int i = 0; i < hrContractInfoCollection.size(); ++i) {
            HRContractInfoInfo hrContractInfo = hrContractInfoCollection.get(i);
            String empContractId = hrContractInfo.getEmployeeContract().getId().toString();
            EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, empContractId);
            ContractUtils.checkContractIsInOtherBill(ctx, employeeContractInfo, ContractChangeBizBill.class.getName(), 1);
            ContractUtils.checkContractIsInOther(ctx, employeeContractInfo);
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)curDate, (Date)hrContractInfo.getEntryBizDate())) {
                this.processUnEffectUnAudit(ctx, billId);
            }
            ContractUtils.deleteEmpEleContractSignRecordInfo(ctx, employeeContractInfo);
            EmpElectronicContractUtilsEx.deleteContractBillMiddleInfo(ctx, employeeContractInfo.getId().toString());
            this.recoverySourceContract(ctx, hrContractInfo);
            this.recoveryHRContract(ctx, hrContractInfo);
            ContractUtils.deleteEmployeeContractInfo(ctx, empContractId);
            this.recoveryContractPage(ctx, hrContractInfo);
        }
    }

    private void recoverySourceContract(Context ctx, HRContractInfoInfo hrContract) throws EASBizException, BOSException {
        if (null != hrContract.getEmployeeContract().getId()) {
            EmployeeContractInfo contractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
            StringBuffer sql = null;
            sql = new StringBuffer().append("update t_hr_employeeContract set FIsChanged = 0");
            sql.append(", FIsNewestContract = 1");
            sql.append(", FVIP = 1");
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (contractInfo.getSourceContract().getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)contractInfo.getEffectDate()) && !DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                if (DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)curDate)) {
                    sql.append(", FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
                } else {
                    sql.append(", FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
                }
            } else if (contractInfo.getSourceContract().getEndDate() == null) {
                sql.append(", FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
            } else {
                sql.append(",FNewState =FState ");
            }
            sql.append(" where  FID = '").append(hrContract.getSourceContract().getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void recoveryHRContract(Context ctx, HRContractInfoInfo hrContract) throws EASBizException, BOSException {
        ContractChangeBizBillInfo csbbInfo = ContractChangeBizBillFactory.getLocalInstance(ctx).getContractChangeBizBillInfo((IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
        this.recoveryHrContractInfo(ctx, csbbInfo, (IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
        EmployeeContractInfo contractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
        StringBuffer hrSql = null;
        hrSql = new StringBuffer().append("update t_hr_hrcontractinfo set ");
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        if (contractInfo.getSourceContract().getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)contractInfo.getEffectDate()) && !DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)curDate)) {
            if (DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)curDate)) {
                hrSql.append(" FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
            } else {
                hrSql.append(" FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
            }
        } else if (contractInfo.getSourceContract().getEndDate() == null) {
            hrSql.append(" FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
        } else {
            hrSql.append(" FNewState = FState");
        }
        hrSql.append(" where  FEmployeeContractID = '").append(hrContract.getSourceContract().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)hrSql.toString());
    }

    private void recoveryContractPage(Context ctx, HRContractInfoInfo hrContract) throws BOSException, EASBizException {
        if (null != hrContract.getEmployeeContract().getId() && null != hrContract.getSourceContract().getId()) {
            String sql = "update T_HR_ContractPageInfo set FEMPLOYEECONTRACTID= '" + hrContract.getSourceContract().getId().toString() + "' where FEMPLOYEECONTRACTID= '" + hrContract.getEmployeeContract().getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void updateContractSignBillEntryContractNo(Context ctx, ContractChangeBizBillInfo billInfo) throws EASBizException, BOSException {
        ContractChangeBizBillEntryCollection entryColl;
        if (HRBizSource.SSC.equals((Object)billInfo.getBizSource()) && (entryColl = billInfo.getEntrys()) != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                ContractChangeBizBillEntryInfo entryInfo = entryColl.get(index);
                ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign()) continue;
                String oldNumber = entryInfo.getContractNo();
                String newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)entryInfo.getContractNo());
                if (newNumber.equals(oldNumber)) continue;
                entryInfo.setContractNo(newNumber);
            }
        }
    }
}

