/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.MappingApplyUtil;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractPreNewSignBizBillEntry;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IOtherFollowPreNewConEntry;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryInfo;
import com.kingdee.eas.hr.contract.PreContractException;
import com.kingdee.eas.hr.contract.app.AbstractContractPreNewSignBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractPreNewSignBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractPreNewSignUtils;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.ContractUtilsEx;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtils;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractSourceStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryPersonCollection;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractPreNewSignBizBillControllerBean
extends AbstractContractPreNewSignBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractPreNewSignBizBillControllerBean.class);

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractPreNewSignBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractPreNewSignBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractPreNewSignBillBizBean();
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreNewSignBizBillInfo cpnsbbInfo = (ContractPreNewSignBizBillInfo)model;
        this.updateContractPreNewSignBizBillEntryContractNo(ctx, cpnsbbInfo);
        this.updateContractPreNewSignBizBillEntryContractNoSignState(ctx, cpnsbbInfo);
        this.updateOtherFollowPreNewConEntryNoSignState(ctx, cpnsbbInfo);
        this.checkPreEntryPersonHasBill(ctx, model);
        this.checkBeforeAddnewOrUpdate(ctx, cpnsbbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, cpnsbbInfo, EContractSignState.uninitiated);
        this.addNewHrContractInfo(ctx, cpnsbbInfo, objectPk);
        return objectPk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractPreNewSignBizBillInfo cpnsbbInfo = (ContractPreNewSignBizBillInfo)model;
        this.checkBeforeAddnewOrUpdate(ctx, cpnsbbInfo);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, cpnsbbInfo, pk);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private void updateContractPreNewSignBizBillEntryContractNo(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws EASBizException, BOSException {
        ContractPreNewSignBizBillEntryCollection entryColl = cpnsbbInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = entryColl.get(i);
                ContractTempletInfo templetInfo = cpnsbbeInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                String oldNumber = cpnsbbeInfo.getContractNo();
                if (templetInfo.isIsElectronicSign()) {
                    String newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)oldNumber);
                    if (oldNumber.equals(newNumber)) continue;
                    cpnsbbeInfo.setContractNo(newNumber);
                    continue;
                }
                cpnsbbeInfo.setContractNo(oldNumber);
            }
        }
    }

    private void updateContractPreNewSignBizBillEntryContractNoSignState(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) {
        ContractPreNewSignBizBillEntryCollection entryColl = cpnsbbInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = entryColl.get(i);
                cpnsbbeInfo.setSignState(EContractSignState.uninitiated);
            }
        }
    }

    private void updateOtherFollowPreNewConEntryNoSignState(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) {
        OtherFollowPreNewConEntryCollection entryColl = cpnsbbInfo.getOtherEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                OtherFollowPreNewConEntryInfo ofpnceInfo = entryColl.get(i);
                ofpnceInfo.setSignState(EContractSignState.uninitiated);
            }
        }
    }

    @Override
    protected void setBillUseDefault(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        ContractBillBaseInfo billInfo = (ContractBillBaseInfo)model;
        boolean useDefault = true;
        billInfo.setUseDefault(useDefault);
    }

    public void checkBeforeAddnewOrUpdate(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws BOSException, EASBizException {
        this.checkToUnit(cpnsbbInfo);
        this.checkContractTemplet(ctx, cpnsbbInfo);
        this.checkDate(ctx, cpnsbbInfo);
        this.checkPersonAndContractType(cpnsbbInfo);
        this.checkContNoIsRepeat(ctx, cpnsbbInfo);
        this.checkOtherContractEntryContractNoIsRepeat(ctx, cpnsbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)cpnsbbInfo);
        this.checkProbation(ctx, cpnsbbInfo);
    }

    @Override
    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof ContractPreNewSignBizBillInfo) {
            OtherFollowPreNewConEntryCollection otherEntrys;
            ContractPreNewSignBizBillInfo cpnsbbInfo = (ContractPreNewSignBizBillInfo)model;
            ContractPreNewSignBizBillEntryCollection entries = cpnsbbInfo.getEntrys();
            if (entries != null) {
                ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = null;
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                String number = null;
                HROrgUnitInfo hrOrgUnit = cpnsbbInfo.getHrOrgUnit();
                String hrOrgID = hrOrgUnit.getId().toString();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    cpnsbbeInfo = entries.get(i);
                    this.assembleContractInfoForCoding(ctx, contractInfo, cpnsbbInfo, cpnsbbeInfo);
                    contractInfo.setContractNo(cpnsbbInfo.getNumber());
                    contractInfo.setLabContractFirstParty(cpnsbbInfo.getLabContractFirstParty());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)hrOrgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, hrOrgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, hrOrgID);
                    while (this.isEmpContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, hrOrgID);
                    }
                    if (number == null) continue;
                    cpnsbbeInfo.setContractNo(number);
                }
            }
            if ((otherEntrys = cpnsbbInfo.getOtherEntrys()) != null && otherEntrys.size() > 0) {
                OtherFollowPreNewConEntryInfo otherEntry = null;
                EmployeeOtherContractInfo contractOtherInfo = new EmployeeOtherContractInfo();
                String number = null;
                CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                String orgID = curCuInfo.getId().toString();
                int size = otherEntrys.size();
                for (int i = 0; i < size; ++i) {
                    otherEntry = otherEntrys.get(i);
                    this.assembleOtherContractInfoForCoding(ctx, contractOtherInfo, otherEntry);
                    contractOtherInfo.setContractNo(cpnsbbInfo.getNumber());
                    contractOtherInfo.setLabContractFirstParty(cpnsbbInfo.getLabContractFirstParty());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractOtherInfo, orgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractOtherInfo, orgID);
                    while (this.isEmpOtherContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractOtherInfo, orgID);
                    }
                    if (number == null) continue;
                    otherEntry.setContractNo(number);
                }
            }
        }
        this.updateContractSignBillEntryContractNo(ctx, (ContractPreNewSignBizBillInfo)model);
    }

    protected void assembleOtherContractInfoForCoding(Context ctx, EmployeeOtherContractInfo otherContractInfo, OtherFollowPreNewConEntryInfo entry) {
        String entityName = "com.kingdee.eas.hr.emp.app.EmployeeOtherContract";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = entry.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = entry.get(propName);
                Object retValue = ContractUtilsEx.getEnumValue(value);
                otherContractInfo.put(propName, retValue);
                continue block0;
            }
        }
        otherContractInfo.setPreEntryPerson(entry.getPreEntryPerson());
        otherContractInfo.setEffectDate(entry.getBizDate());
        otherContractInfo.setRecordDate(entry.getSignDate());
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeContractInfo contractInfo, ContractPreNewSignBizBillInfo cpnsbbInfo, ContractPreNewSignBizBillEntryInfo cpnsbbeInfo) throws EASBizException, BOSException {
        String entityName = "com.kingdee.eas.hr.emp.app.EmployeeContract";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = cpnsbbeInfo.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = cpnsbbeInfo.get(propName);
                Object retValue = ContractUtilsEx.getEnumValue(value);
                contractInfo.put(propName, retValue);
                continue block0;
            }
        }
        contractInfo.setPreEntryPerson(cpnsbbeInfo.getPreEntryPerson());
        contractInfo.setEffectDate(cpnsbbeInfo.getBizDate());
        contractInfo.setRecordDate(cpnsbbeInfo.getSignDate());
        String hrOrgID = "";
        HROrgUnitInfo hrOrgUnit = cpnsbbInfo.getHrOrgUnit();
        hrOrgID = hrOrgUnit != null ? hrOrgUnit.getId().toString() : HRFilterUtils.getCurrentHROID((Context)ctx);
        MappingApplyUtil.setValueByMapping((Context)ctx, (IObjectValue)contractInfo, (IObjectValue)cpnsbbeInfo, (String)"entrys", (EntityFieldMappingCollection)MappingApplyUtil.getFieldMappingCollection((Context)ctx, (IObjectValue)cpnsbbInfo, (String)hrOrgID));
    }

    private void updateContractSignBillEntryContractNo(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws EASBizException, BOSException {
        ContractPreNewSignBizBillEntryCollection entryColl = cpnsbbInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                String newNumber;
                String oldNumber;
                ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = entryColl.get(index);
                ContractTempletInfo templetInfo = cpnsbbeInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign() || (oldNumber = cpnsbbeInfo.getContractNo()).equals(newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)cpnsbbeInfo.getContractNo()))) continue;
                cpnsbbeInfo.setContractNo(newNumber);
            }
        }
    }

    protected boolean isEmpOtherContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    private boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    private void checkToUnit(ContractPreNewSignBizBillInfo cpnsbbInfo) throws ContractException {
    }

    private void checkContractTemplet(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws EASBizException, BOSException {
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = null;
        OtherFollowPreNewConEntryInfo ofpnceInfo = null;
        ContractTempletInfo otherConTempletInfo = null;
        cpnsbbeInfo = cpnsbbInfo.getEntrys().get(0);
        ContractTempletInfo templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(cpnsbbeInfo.getContractTemplet().getId()));
        boolean empConIsEleSign = templetInfo.isIsElectronicSign();
        int size = cpnsbbInfo.getOtherEntrys().size();
        for (int i = 0; i < size; ++i) {
            ofpnceInfo = cpnsbbInfo.getOtherEntrys().get(i);
            otherConTempletInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(ofpnceInfo.getContractTemplet().getId()));
            if (empConIsEleSign == otherConTempletInfo.isIsElectronicSign()) continue;
            throw new ContractException(ContractException.CONTRACTTEMPLET_IS_NOT_SAME);
        }
    }

    private void checkDate(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws EASBizException, BOSException {
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = null;
        int size = cpnsbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cpnsbbeInfo = cpnsbbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, cpnsbbeInfo.getPreEntryPerson().getId().toString());
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)cpnsbbeInfo.getContractLimitType()) && cpnsbbeInfo.getEndDate() == null) {
                throw new ContractException(ContractException.ENDDATE_ISNULL, new Object[]{personParm});
            }
            if (cpnsbbeInfo.getEndDate() != null) {
                if (DateTimeUtils.dayAfter((Date)cpnsbbeInfo.getBizDate(), (Date)cpnsbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.BIZDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
                if (DateTimeUtils.dayAfter((Date)cpnsbbeInfo.getSignDate(), (Date)cpnsbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.SIGNDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
            }
            if (cpnsbbeInfo.getPenalty() != null && cpnsbbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (cpnsbbeInfo.getCompensation() != null && cpnsbbeInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
            }
            if (cpnsbbeInfo.getContinuousSignedCount() < 0) {
                throw new ContractException(ContractException.CONTINUESIGNCOUNT_ISMINUS, new Object[]{personParm});
            }
            if (cpnsbbeInfo.getContractTemplet().getInvalidDate() == null || !DateTimeUtils.dayBefore((Date)cpnsbbeInfo.getContractTemplet().getInvalidDate(), (Date)new Date())) continue;
            throw new ContractException(ContractException.CONTEMPLET_INVALID, new Object[]{personParm});
        }
        OtherFollowPreNewConEntryInfo ofpncInfo = null;
        if (cpnsbbInfo.getOtherEntrys() != null) {
            int size2 = cpnsbbInfo.getOtherEntrys().size();
            for (int i = 0; i < size2; ++i) {
                ofpncInfo = cpnsbbInfo.getOtherEntrys().get(i);
                if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)ofpncInfo.getContractLimitType()) && ofpncInfo.getEndDate() == null) {
                    throw new ContractException(ContractException.ENDDATE_CAN_NOT_NULL, new Object[]{ofpncInfo.getContractNo(), ofpncInfo.getContractType().getName()});
                }
                if (ofpncInfo.getEndDate() != null) {
                    if (DateTimeUtils.dayAfter((Date)ofpncInfo.getBizDate(), (Date)ofpncInfo.getEndDate())) {
                        throw new ContractException(ContractException.EFFECTDATE_NOT_WY_ENDDATE, new Object[]{ofpncInfo.getContractNo(), ofpncInfo.getContractType().getName()});
                    }
                    if (DateTimeUtils.dayAfter((Date)ofpncInfo.getSignDate(), (Date)ofpncInfo.getEndDate())) {
                        throw new ContractException(ContractException.OTHER_SIGNDATE_AFTER_ENDDATE, new Object[]{ofpncInfo.getContractNo(), ofpncInfo.getContractType().getName()});
                    }
                }
                if (ofpncInfo.getContractTemplet().getInvalidDate() == null || !DateTimeUtils.dayBefore((Date)ofpncInfo.getContractTemplet().getInvalidDate(), (Date)new Date())) continue;
                throw new ContractException(ContractException.OTHER_CONTEMPLET_INVALID, new Object[]{ofpncInfo.getContractNo(), ofpncInfo.getContractType().getName()});
            }
        }
    }

    private void checkPersonAndContractType(ContractPreNewSignBizBillInfo cpnsbbInfo) throws ContractException {
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo1 = null;
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo2 = null;
        int size = cpnsbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            int j;
            cpnsbbeInfo1 = cpnsbbInfo.getEntrys().get(i);
            boolean isNotSamePerson = false;
            boolean isNotSameContractType = false;
            int rowNum = cpnsbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                cpnsbbeInfo2 = cpnsbbInfo.getEntrys().get(j);
                if (i == j || cpnsbbeInfo1.getPreEntryPerson().equals((Object)cpnsbbeInfo2.getPreEntryPerson())) continue;
                isNotSamePerson = true;
                break;
            }
            rowNum = cpnsbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                cpnsbbeInfo2 = cpnsbbInfo.getEntrys().get(j);
                if (i == j || cpnsbbeInfo1.getContractType().equals((Object)cpnsbbeInfo2.getContractType())) continue;
                isNotSameContractType = true;
                break;
            }
            if (!isNotSamePerson || !isNotSameContractType) continue;
            throw new ContractException(ContractException.SAVELOSE);
        }
    }

    private void checkContNoIsRepeat(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws BOSException, ContractException {
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        IContractPreNewSignBizBillEntry cpnsbbeLocalInstance = ContractPreNewSignBizBillEntryFactory.getLocalInstance(ctx);
        EmployeeContractCollection ecCol = null;
        int size = cpnsbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = cpnsbbInfo.getEntrys().get(i);
            StringBuffer sql = new StringBuffer();
            sql.append("select id where contractNo = '" + cpnsbbeInfo.getContractNo() + "'");
            ecCol = employeeContractLocalInstance.getEmployeeContractCollection(sql.toString());
            StringBuffer whereStr = new StringBuffer("where contractNo = '");
            whereStr.append(cpnsbbeInfo.getContractNo());
            if (cpnsbbInfo.getId() != null) {
                whereStr.append("' and bill <> '");
                whereStr.append(cpnsbbInfo.getId().toString());
            }
            whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
            whereStr.append(HRUtil.getCurrentDate());
            whereStr.append("))");
            ContractPreNewSignBizBillEntryCollection cpnsbbCol = cpnsbbeLocalInstance.getContractPreNewSignBizBillEntryCollection(whereStr.toString());
            if (ecCol.size() <= 0 && cpnsbbCol.size() <= 0) continue;
            throw new ContractException(ContractException.CONTRACTNO_REPEAT, new Object[]{cpnsbbeInfo.getContractNo()});
        }
    }

    private void checkOtherContractEntryContractNoIsRepeat(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws BOSException, ContractException {
        IEmployeeOtherContract employeeOtherContractLocalInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        IOtherFollowPreNewConEntry otherFollowPreNewConEntryLocalInstance = OtherFollowPreNewConEntryFactory.getLocalInstance(ctx);
        EmployeeOtherContractCollection eocCol = null;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        int size = cpnsbbInfo.getOtherEntrys().size();
        for (int i = 0; i < size; ++i) {
            OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = cpnsbbInfo.getOtherEntrys().get(i);
            String contractNo = otherFollowPreNewConEntryInfo.getContractNo();
            if (!list.contains(contractNo)) {
                list.add(contractNo);
            } else {
                hashSet.add(contractNo);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select id where contractNo = '" + contractNo + "'");
            eocCol = employeeOtherContractLocalInstance.getEmployeeOtherContractCollection(sql.toString());
            StringBuffer whereStr = new StringBuffer("where contractNo = '");
            whereStr.append(contractNo);
            if (cpnsbbInfo.getId() != null) {
                whereStr.append("' and bill <> '");
                whereStr.append(cpnsbbInfo.getId().toString());
            }
            whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
            whereStr.append(HRUtil.getCurrentDate());
            whereStr.append("))");
            if (hashSet.size() > 0) {
                String contNo = "";
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    String number;
                    contNo = number = (String)iterator.next();
                }
                throw new ContractException(ContractException.CONTRACTNO_REPEAT_IN_OTHER_ENTRYS, new Object[]{contNo});
            }
            OtherFollowPreNewConEntryCollection ofpnceCol = otherFollowPreNewConEntryLocalInstance.getOtherFollowPreNewConEntryCollection(whereStr.toString());
            if (eocCol.size() <= 0 && ofpnceCol.size() <= 0) continue;
            throw new ContractException(ContractException.OTHERCONTRACT_CONTRACTNO_REPEAT, new Object[]{contractNo});
        }
    }

    private void checkHasContractByDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreNewSignBizBillInfo cpnsbbInfo = (ContractPreNewSignBizBillInfo)model;
        int size = cpnsbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = cpnsbbInfo.getEntrys().get(i);
            ContractTypeInfo contractTypeInfo = ContractTypeFactory.getLocalInstance((Context)ctx).getContractTypeInfo((IObjectPK)new ObjectUuidPK(cpnsbbeInfo.getContractType().getId().toString()));
            if (!contractTypeInfo.isIsLaborContract()) continue;
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            contractInfo.setBillID(cpnsbbInfo.getId());
            contractInfo.setPreEntryPerson(cpnsbbeInfo.getPreEntryPerson());
            contractInfo.setEffectDate(cpnsbbeInfo.getBizDate());
            contractInfo.setContractLimitType(cpnsbbeInfo.getContractLimitType());
            contractInfo.setEndDate(cpnsbbeInfo.getEndDate());
            contractInfo.put("hrOrgUnit", cpnsbbInfo.getHrOrgUnit());
            HashSet<String> excludeContractNo = new HashSet<String>();
            excludeContractNo.add(cpnsbbeInfo.getContractNo());
            ContractUtils.checkContractTimeIsCrossing(ctx, contractInfo, excludeContractNo, false);
        }
    }

    private void checkProbation(Context ctx, ContractPreNewSignBizBillInfo cpnsbbInfo) throws BOSException, EASBizException {
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = null;
        EmployeeContractInfo contractInfo = null;
        int size = cpnsbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cpnsbbeInfo = cpnsbbInfo.getEntrys().get(i);
            contractInfo = new EmployeeContractInfo();
            contractInfo.setContractNo(cpnsbbeInfo.getContractNo());
            contractInfo.setTestBeginDate(cpnsbbeInfo.getTestBeginDate());
            contractInfo.setTestEndDate(cpnsbbeInfo.getTestEndDate());
            contractInfo.setEffectDate(cpnsbbeInfo.getBizDate());
            contractInfo.setEndDate(cpnsbbeInfo.getEndDate());
            contractInfo.setContractLimitType(cpnsbbeInfo.getContractLimitType());
            contractInfo.setPreEntryPerson(cpnsbbeInfo.getPreEntryPerson());
            if (!StringUtils.isEmpty((String)cpnsbbeInfo.getContractLimit())) {
                contractInfo.setContractLimitAuto(new BigDecimal(cpnsbbeInfo.getContractLimit()));
            }
            int tryoutMonth = cpnsbbeInfo.getTryoutMonth();
            contractInfo.put("probation", (Object)tryoutMonth);
            ContractUtils.checkProbation(ctx, contractInfo);
        }
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        contractInfo.put("preEntryPerson", entryInfo.get("preEntryPerson"));
        String oql = "select * where preEntryPerson.id='" + contractInfo.getPreEntryPerson().getId() + "'";
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql);
        if (coll.size() == 0) {
            contractInfo.setIsNewEmpContract(true);
        }
    }

    @Override
    protected void updateHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billID) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            String oql = "select * where billID='" + billID + "' and preEntryPerson.id='" + ((PreEntryPersonInfo)entryInfo.get("preEntryPerson")).getId() + "'";
            HRContractInfoInfo contractInfo = iHRContractInfo.getHRContractInfoInfo(oql);
            this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.update((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()), contractInfo);
        }
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate;
        Date now;
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = (ContractPreNewSignBizBillEntryInfo)entry;
        ContractPreNewSignBizBillInfo cpnssbbInfo = cpnsbbeInfo.getBill();
        cpnssbbInfo = (ContractPreNewSignBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(cpnssbbInfo.getId()));
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_EmployeeContract where fcontractno = '").append(cpnsbbeInfo.getContractNo()).append("'").append(" and FPreEntryPersonId='").append(cpnsbbeInfo.getPreEntryPerson().getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            EmployeeContractInfo employeeContract = new EmployeeContractInfo();
            employeeContract.setContractNo(cpnsbbeInfo.getContractNo());
            employeeContract.setPreEntryPerson(cpnsbbeInfo.getPreEntryPerson());
            PersonInfo personInfo = this.getPersonInfoByPreEntryPersonInfo(ctx, cpnsbbeInfo.getPreEntryPerson());
            employeeContract.setEmployee(personInfo);
            employeeContract.setContractTemplet(cpnsbbeInfo.getContractTemplet());
            employeeContract.setRecordDate(cpnsbbeInfo.getSignDate());
            employeeContract.setEffectDate(cpnsbbeInfo.getBizDate());
            employeeContract.setEndDate(cpnsbbeInfo.getEndDate());
            employeeContract.setDescription(cpnsbbeInfo.getDescription());
            employeeContract.setState(EmployeeContractState.RECORD);
            employeeContract.setReason(cpnsbbeInfo.getSignReason());
            employeeContract.setToUnit(cpnssbbInfo.getToUnit());
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)cpnssbbInfo, (String)"delegatePersonText", (IObjectValue)employeeContract, (String)"delegatePerson");
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)cpnssbbInfo, (String)"toUnitAddress", (IObjectValue)employeeContract, (String)"toUnitAddress");
            employeeContract.setEmpIdentityNum(cpnsbbeInfo.getIdCardNo());
            employeeContract.setEmpAddress(cpnsbbeInfo.getAddress());
            employeeContract.setCredentialsType(cpnsbbeInfo.getCredentialsType());
            employeeContract.setEmpPassPortNum(cpnsbbeInfo.getPassportNo());
            employeeContract.setHrOrgUnit(cpnssbbInfo.getHrOrgUnit());
            employeeContract.setContSerLimit(cpnsbbeInfo.getContractServerLimit());
            employeeContract.setVip(false);
            employeeContract.setTestBeginDate(cpnsbbeInfo.getTestBeginDate());
            employeeContract.setTestEndDate(cpnsbbeInfo.getTestEndDate());
            employeeContract.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContract.setContractLimitType(cpnsbbeInfo.getContractLimitType());
            employeeContract.setThirdDelegatePerson(cpnssbbInfo.getThirdDelegatePerson());
            employeeContract.setThirdUnitName(cpnssbbInfo.getThirdUnit());
            employeeContract.setThirdUnitAddress(cpnssbbInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)cpnsbbeInfo.getContractLimit())) {
                employeeContract.setContractLimitAuto(new BigDecimal(cpnsbbeInfo.getContractLimit()));
            }
            employeeContract.setPenalty(cpnsbbeInfo.getPenalty());
            employeeContract.setCompensation(cpnsbbeInfo.getCompensation());
            employeeContract.setAppraisal(cpnsbbeInfo.getAppraisal());
            employeeContract.setAppraDate(cpnsbbeInfo.getAppraDate());
            employeeContract.setIsInAdmin(cpnssbbInfo.isIsInAdmin());
            employeeContract.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
            employeeContract.setIsContinuousSigned(true);
            employeeContract.setContinuousSignedCount(1);
            employeeContract.setPositionString(cpnsbbeInfo.getPositionString());
            employeeContract.setContractAgreedSalary(cpnsbbeInfo.getContractAgreedSalary());
            employeeContract.setLabContractFirstParty(cpnssbbInfo.getLabContractFirstParty());
            employeeContract.setAdminOrg(cpnsbbeInfo.getAdminOrg());
            employeeContract.setIsChanged(false);
            if (cpnssbbInfo.getApproveType().getValue() == 1) {
                employeeContract.setIsWorkflow(true);
            } else {
                employeeContract.setIsWorkflow(false);
            }
            employeeContract.setCreator(cpnssbbInfo.getCreator());
            employeeContract.setCreateTime(cpnssbbInfo.getCreateTime());
            employeeContract.setEntryID(cpnsbbeInfo.getId().toString());
            employeeContract.setCU(cpnssbbInfo.getHrOrgUnit().getCU());
            employeeContract.put("notNeedGenerateObjectNumber", (Object)true);
            ContractTempletInfo templetInfo = cpnsbbeInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId()));
            if (templetInfo.isIsElectronicSign()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicEmp);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            } else {
                employeeContract.setContractClassify(ContractClassifyEnum.Normal);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            }
            IObjectPK contractId = EmployeeContractFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)employeeContract);
            employeeContract.setId(BOSUuid.read((String)contractId.toString()));
            this.reverseEmployeeContractAttachment(ctx, employeeContract, entry);
            super._entryEffect(ctx, entry);
        }
        if (!(now = new Date()).before(effectDate = this.getEffectDate(entry))) {
            this.updateHRContractInfo_afterEffect(ctx, cpnsbbeInfo);
        }
        if (null != cpnssbbInfo.getOtherEntrys()) {
            this.otherFollowPreContract(ctx, cpnssbbInfo);
        }
    }

    private void otherFollowPreContract(Context ctx, ContractPreNewSignBizBillInfo billInfo) throws EASBizException, BOSException {
        logger.info("enter otherFollowLaborContract_");
        ContractPreNewSignBizBillEntryInfo entry = billInfo.getEntrys().get(0);
        OtherFollowPreNewConEntryCollection otherEntrys = billInfo.getOtherEntrys();
        PersonInfo personInfo = this.getPersonInfoByPreEntryPersonInfo(ctx, entry.getPreEntryPerson());
        logger.info("otherEntrys_ size is " + otherEntrys.size());
        for (int i = 0; i < otherEntrys.size(); ++i) {
            String otherEntryId = otherEntrys.get(i).getId().toString();
            logger.info("otherEntryId : " + otherEntryId);
            OtherFollowPreNewConEntryInfo otherEntry = otherEntrys.get(i);
            EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
            oContractInfo.setContractNo(otherEntry.getContractNo());
            logger.info("otherEntry_ ContractNo : " + otherEntry.getContractNo());
            oContractInfo.setPreEntryPerson(otherEntry.getPreEntryPerson());
            oContractInfo.setEmployee(personInfo);
            oContractInfo.setContractTemplet(otherEntry.getContractTemplet());
            oContractInfo.setRecordDate(otherEntry.getSignDate());
            oContractInfo.setEffectDate(otherEntry.getBizDate());
            oContractInfo.setEndDate(otherEntry.getEndDate());
            oContractInfo.setDescription(entry.getDescription());
            oContractInfo.setState(EmployeeContractState.RECORD);
            oContractInfo.setReason(entry.getSignReason());
            oContractInfo.setToUnit(billInfo.getToUnit());
            oContractInfo.setLabContractFirstParty(billInfo.getLabContractFirstParty());
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)billInfo, (String)"delegatePersonText", (IObjectValue)oContractInfo, (String)"delegatePerson");
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)billInfo, (String)"toUnitAddress", (IObjectValue)oContractInfo, (String)"toUnitAddress");
            oContractInfo.setEmpIdentityNum(otherEntry.getIdCardNo());
            oContractInfo.setEmpAddress(entry.getAddress());
            oContractInfo.setEmpPassPortNum(otherEntry.getPassportNo());
            oContractInfo.setCredentialsType(otherEntry.getCredentialsType());
            oContractInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
            oContractInfo.setContractLimit(null);
            oContractInfo.setContSerLimit(entry.getContractServerLimit());
            oContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            oContractInfo.setContractLimitType(otherEntry.getContractLimitType());
            oContractInfo.setThirdDelegatePerson(billInfo.getThirdDelegatePerson());
            oContractInfo.setThirdUnitName(billInfo.getThirdUnit());
            oContractInfo.setThirdUnitAddress(billInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)otherEntry.getContractLimit())) {
                oContractInfo.setContractLimitAuto(new BigDecimal(otherEntry.getContractLimit()));
            }
            oContractInfo.setPenalty(entry.getPenalty());
            oContractInfo.setCompensation(entry.getCompensation());
            oContractInfo.setAppraisal(entry.getAppraisal());
            oContractInfo.setAppraDate(entry.getAppraDate());
            oContractInfo.setIsInAdmin(billInfo.isIsInAdmin());
            oContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
            oContractInfo.setIsChanged(false);
            if (billInfo.getApproveType().getValue() == 1) {
                oContractInfo.setIsWorkflow(true);
            } else {
                oContractInfo.setIsWorkflow(false);
            }
            oContractInfo.setEntryID(otherEntry.getId().toString());
            oContractInfo.setPositionString(entry.getPositionString());
            oContractInfo.setContractAgreedSalary(entry.getContractAgreedSalary());
            oContractInfo.setAdminOrg(otherEntry.getAdminOrg());
            oContractInfo.setPreEntryPerson(otherEntry.getPreEntryPerson());
            ContractTempletInfo templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(otherEntry.getContractTemplet().getId()));
            if (templetInfo.isIsElectronicSign()) {
                oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicEmp);
                oContractInfo.setSignStatus(EContractSignState.uninitiated);
                oContractInfo.setIsElectronicSign(false);
            } else {
                oContractInfo.setContractClassify(ContractClassifyEnum.Normal);
                oContractInfo.setSignStatus(EContractSignState.uninitiated);
                oContractInfo.setIsElectronicSign(false);
            }
            IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
            IObjectPK contractId = iEmployeeOtherContract.addnew((CoreBaseInfo)oContractInfo);
            oContractInfo.setId(BOSUuid.read((String)contractId.toString()));
            this.addAttachmentForOtherContract(ctx, oContractInfo, billInfo.getId().toString());
        }
    }

    protected void addAttachmentForOtherContract(Context ctx, EmployeeOtherContractInfo employeeContract, String billId) throws BOSException, EASBizException {
        String strLan = ctx.getLocale().toString();
        String sql = "select FAttachmentID, FAssoType_" + strLan + " from T_BAS_BoAttchAsso where FBoID = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs != null && rs.size() > 0) {
            StringBuffer attachmentIdStr = new StringBuffer();
            String attachmentId = null;
            HashMap<String, String> attachmentMap = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    attachmentIdStr.append("'");
                    attachmentIdStr.append(rs.getString("FAttachmentID"));
                    attachmentIdStr.append("',");
                    attachmentMap.put(rs.getString("FAttachmentID"), rs.getString("FAssoType_" + strLan));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (attachmentIdStr.length() > 0) {
                attachmentId = attachmentIdStr.toString().substring(0, attachmentIdStr.length() - 1);
            }
            AttachmentCollection aCol = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection("where id in (" + attachmentId + ")");
            AttachmentInfo aInfo = null;
            BoAttchAssoInfo baaInfo = null;
            IBoAttchAsso bAAF = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            int size = aCol.size();
            for (int i = 0; i < size; ++i) {
                aInfo = aCol.get(i);
                baaInfo = new BoAttchAssoInfo();
                baaInfo.setAttachment(aInfo);
                baaInfo.setAssoType(((String)attachmentMap.get(aInfo.getId().toString())).toString());
                baaInfo.setBoID(employeeContract.getId().toString());
                baaInfo.setAssoBusObjType(employeeContract.getBOSType().toString());
                bAAF.addnew(baaInfo);
            }
        }
    }

    private void updateHRContractInfo_afterEffect(Context ctx, ContractPreNewSignBizBillEntryInfo cpnsbbeInfo) throws EASBizException, BOSException {
        HRContractInfoInfo hRContractInfo = HRContractInfoUtils.getHRContractInfo(ctx, cpnsbbeInfo.getBill().getId().toString(), cpnsbbeInfo.getContractNo());
        hRContractInfo.setState(EmployeeContractState.RECORD);
        hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        hRContractInfo.setIsNewEmpContract(false);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("employeeContract"));
        selector.add(new SelectorItemInfo("isNewEmpContract"));
        String oql = "select id where contractNo='" + cpnsbbeInfo.getContractNo() + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = iEmployeeContract.getEmployeeContractInfo(oql);
        hRContractInfo.setEmployeeContract(contractInfo);
        HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
    }

    protected SelectorItemCollection getBillSelector() throws BOSException, EASBizException {
        SelectorItemCollection selector = super.getBillSelector();
        selector.add(new SelectorItemInfo("toUnit"));
        selector.add(new SelectorItemInfo("delegatePersonText"));
        selector.add(new SelectorItemInfo("toUnitAddress"));
        selector.add(new SelectorItemInfo("thirdDelegatePerson"));
        selector.add(new SelectorItemInfo("thirdUnit"));
        selector.add(new SelectorItemInfo("thirdUnitAddress"));
        selector.add(new SelectorItemInfo("isInAdmin"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("createTime"));
        selector.add(new SelectorItemInfo("labContractFirstParty"));
        return selector;
    }

    protected void checkPreEntryPersonHasBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreNewSignBizBillInfo cpnssbbInfo = (ContractPreNewSignBizBillInfo)model;
        ContractPreNewSignBizBillEntryInfo cpnsbbeInfo = null;
        int size = cpnssbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cpnsbbeInfo = cpnssbbInfo.getEntrys().get(i);
            String preEntryPersonId = cpnsbbeInfo.getPreEntryPerson().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("preEntryPerson.id", (Object)preEntryPersonId));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)HRBillStateEnum.AUDITEND.getValue(), CompareType.NOTEQUALS));
            if (cpnsbbeInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)cpnsbbeInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            if (!ContractPreNewSignBizBillEntryFactory.getLocalInstance(ctx).exists(filter)) continue;
            throw new PreContractException(PreContractException.PRE_ENTRY_PERSON_HAS_BILL);
        }
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        int i;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        HRContractInfoCollection hrContractInfoCollection = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(entityViewInfo);
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label39", (Context)ctx);
        EmpEleContractFollowUtils.checkWhetherUnCheckBizBillBySignStatus(conPreNewSignBBInfo.getTotalState(), operation);
        for (i = 0; i < hrContractInfoCollection.size(); ++i) {
            HRContractInfoInfo hrContractInfoInfo = hrContractInfoCollection.get(i);
            EmployeeContractInfo employeeContract = hrContractInfoInfo.getEmployeeContract();
            if (employeeContract == null || employeeContract.getId() == null) {
                throw new PreContractException(PreContractException.HRCONTRACT_EMPLOYEECONTRACT_IS_NULL);
            }
            String empContractId = hrContractInfoInfo.getEmployeeContract().getId().toString();
            EmployeeContractInfo employeeContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(empContractId), this.getSelectorCollection());
            PersonInfo personInfo = employeeContractInfo.getEmployee();
            if (personInfo != null) {
                throw new PreContractException(PreContractException.EMPLOYEECONTRACT_EMPLOYEE_IS_NOT_NULL);
            }
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)curDate, (Date)hrContractInfoInfo.getEntryBizDate())) {
                this.processUnEffectUnAudit(ctx, billId);
            }
            ContractPreNewSignUtils.deleteEmpEleContractRelatedTable(ctx, employeeContractInfo);
            ContractPreNewSignUtils.deletePersonContractPageInfoInfo(ctx, empContractId);
            ContractPreNewSignUtils.deleteEmployeeContractInfo(ctx, empContractId);
            this.recoveryHRContractInfoInfo(ctx, hrContractInfoInfo);
            ContractPreNewSignUtils.updateContractPreNewSignBizBillEntrySignStatus(ctx, billId, EContractSignState.uninitiated);
        }
        if (conPreNewSignBBInfo.getOtherEntrys() != null && conPreNewSignBBInfo.getOtherEntrys().size() > 0) {
            for (i = 0; i < conPreNewSignBBInfo.getOtherEntrys().size(); ++i) {
                OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = conPreNewSignBBInfo.getOtherEntrys().get(i);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
                EmpEleContractFollowUtils.deleteEmpOtherEleContractRelatedTable(ctx, employeeOtherContractInfo);
                EmpEleContractFollowUtils.deleteEmpOtherContractInfo(ctx, employeeOtherContractInfo.getId().toString());
                EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, otherFollowPreNewConEntryInfo.getId().toString(), EContractSignState.uninitiated);
            }
        }
        EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, conPreNewSignBBInfo, EContractSignState.uninitiated);
        super._untiCheckBizBill(ctx, billId);
    }

    private void recoveryHRContractInfoInfo(Context ctx, HRContractInfoInfo hrContract) throws BOSException, EASBizException {
        ContractPreNewSignBizBillInfo cpnsbbInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
        this.recoveryHrContractInfo(ctx, cpnsbbInfo, (IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
    }

    @Override
    protected void recoveryHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billID) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            String oql = "select * where billID='" + billID + "' and preEntryPerson.id='" + ((PreEntryPersonInfo)entryInfo.get("preEntryPerson")).getId() + "'";
            HRContractInfoInfo hrContractInfoInfo = iHRContractInfo.getHRContractInfoInfo(oql);
            iHRContractInfo.delete((IObjectPK)new ObjectUuidPK(hrContractInfoInfo.getId().toString()));
            this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.addnew((IObjectPK)new ObjectUuidPK(hrContractInfoInfo.getId().toString()), contractInfo);
        }
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        viewInfo.setFilter(filter);
        IHRContractInfo hrContractInfoLocalInstance = HRContractInfoFactory.getLocalInstance(ctx);
        HRContractInfoCollection hrContractInfoCollection = hrContractInfoLocalInstance.getHRContractInfoCollection(viewInfo);
        int size = hrContractInfoCollection.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo hrContractInfoInfo = hrContractInfoCollection.get(i);
            hrContractInfoLocalInstance.delete((IObjectPK)new ObjectUuidPK(hrContractInfoInfo.getId().toString()));
        }
    }

    public SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("employee.number"));
        selector.add(new SelectorItemInfo("employee.idCardNO"));
        selector.add(new SelectorItemInfo("employee.nCell"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isLaborContract"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isRenewWarn"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("ContractLimit.id"));
        selector.add(new SelectorItemInfo("ContractLimit.name"));
        selector.add(new SelectorItemInfo("ContractLimit.number"));
        selector.add(new SelectorItemInfo("ContSerLimit.id"));
        selector.add(new SelectorItemInfo("ContSerLimit.name"));
        selector.add(new SelectorItemInfo("ContSerLimit.number"));
        selector.add(new SelectorItemInfo("sourceContract.id"));
        selector.add(new SelectorItemInfo("sourceContract.name"));
        selector.add(new SelectorItemInfo("sourceContract.number"));
        selector.add(new SelectorItemInfo("partyUnitsItem.id"));
        selector.add(new SelectorItemInfo("partyUnitsItem.name"));
        selector.add(new SelectorItemInfo("partyUnitsItem.number"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.number"));
        selector.add(new SelectorItemInfo("preEntryPerson.idCardNO"));
        selector.add(new SelectorItemInfo("preEntryPerson.passportNO"));
        return selector;
    }

    public PersonInfo getPersonInfoByPreEntryPersonInfo(Context ctx, PreEntryPersonInfo preEntryPersonInfo) throws BOSException, EASBizException {
        BOSUuid realPersonId = null;
        PersonInfo personInfo = new PersonInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)preEntryPersonInfo.getId().toString()));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("realPersonId"));
        view.setSelector(selector);
        PreEntryPersonCollection preEntryPersonCollection = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonCollection(view);
        if (preEntryPersonCollection != null && preEntryPersonCollection.size() > 0) {
            PreEntryPersonInfo preEntryPerson = preEntryPersonCollection.get(0);
            realPersonId = preEntryPerson.getRealPersonId();
            personInfo.setId(realPersonId);
            if (realPersonId != null) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)realPersonId.toString()));
                boolean exists = PersonFactory.getLocalInstance((Context)ctx).exists(filterInfo);
                if (!exists) {
                    return null;
                }
            }
        }
        if (realPersonId != null) {
            return personInfo;
        }
        return null;
    }
}

