/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.EmpEleContractException;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.eas.hr.contract.IEmpEleContractSignRecord;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.contract.app.AbstractEmpEleContractServiceFacadeControllerBean;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordCollection;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordFactory;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthResult;
import com.kingdee.shr.elecontract.util.Base64Utils;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.HttpMethodUtils;
import com.kingdee.shr.elecontract.vo.PersonThreeEleInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpEleContractServiceFacadeControllerBean
extends AbstractEmpEleContractServiceFacadeControllerBean {
    private static final long serialVersionUID = -245685229260479888L;
    private static Logger logger = LoggerFactory.getLogger(EmpEleContractServiceFacadeControllerBean.class);
    public static final String ERR_SYSTEM_ERROR = "10001";
    public static final String ERR_SERVICE_UNREGIST = "10002";
    public static final String ERR_SERVICE_ILLEGALSNO = "10003";
    public static final String ERR_SERVICE_UNEXISTNO = "10004";

    @Override
    protected Object _createEContract(Context ctx, IObjectValue empEleContractSignRecord, IObjectValue employeeContract, IObjectValue shrElectronicTemplate) throws BOSException, EASBizException {
        String eContractNO;
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = (EmpEleContractSignRecordInfo)empEleContractSignRecord;
        EmployeeContractInfo employeeContractInfo = (EmployeeContractInfo)employeeContract;
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = (SHRElectronicTemplateInfo)shrElectronicTemplate;
        if (!shrElectronicTemplateInfo.isIsRegister()) {
            throw new EmpEleContractException(EmpEleContractException.E_TEMPLATE_NOT_REGISTER);
        }
        String kdappIdEContractNo = eContractNO = empEleContractSignRecordInfo.getEContractNO();
        LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
        String labContractFirstPartyId = "";
        if (labContractFirstParty == null || labContractFirstParty.getId() == null) {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_LABCONTRACTFIRSTPARTY_CANNOT_NULL);
        }
        labContractFirstPartyId = labContractFirstParty.getId().toString();
        String templateId = shrElectronicTemplateInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        ArrayList osfContractDataList = new ArrayList();
        PersonInfo person = empEleContractSignRecordInfo.getPerson();
        Map<Object, Object> osfContractData = new HashMap();
        if (StringUtils.isEmpty((String)shrElectronicTemplateInfo.getConfig())) {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_DATA_ERROE);
        }
        osfContractData = EmpElectronicContractUtilsEx.assembleContractInfoData(ctx, employeeContractInfo.getId().toString(), shrElectronicTemplateInfo, person);
        osfContractDataList.add(osfContractData);
        Map dataMap = ElectronicContractUtils.packageOsfParams(templateIds, (String)kdappIdEContractNo, osfContractDataList);
        dataMap.put("labContractFirstPartyInfoId", labContractFirstPartyId);
        dataMap.put("contractId", employeeContractInfo.getId().toString());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        logger.error("EmpEleContractServiceFacadeControllerBean._createEContract dataMap : " + dataMap);
        JSONObject result = (JSONObject)osfServiceFacade.processService("empElectronicLaborContractCreateService", dataMap);
        logger.error("EmpEleContractServiceFacadeControllerBean._createEContract result : " + result);
        if (result.get((Object)"errcode") != null && (ERR_SERVICE_UNREGIST.equals(result.getString("errcode")) || ERR_SYSTEM_ERROR.equals(result.getString("errcode")) || ERR_SERVICE_ILLEGALSNO.equals(result.getString("errcode")) || ERR_SERVICE_UNEXISTNO.equals(result.getString("errcode")))) {
            throw new BOSException(result.getString("description"));
        }
        Object codeObj = result.get((Object)"code");
        int returnCode = result.getIntValue("code");
        if (codeObj == null || returnCode != 0) {
            throw new EmpEleContractException(EmpEleContractException.CREATE_ECOTRACT_ERROR, new Object[]{returnCode, result.get((Object)"msg").toString()});
        }
        empEleContractSignRecordInfo.setIsCreate(true);
        empEleContractSignRecordInfo.setEcreateTime(new Timestamp(System.currentTimeMillis()));
        empEleContractSignRecordInfo.setCreateMethod(0);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("ecreateTime"));
        selector.add(new SelectorItemInfo("createMethod"));
        EmpEleContractSignRecordFactory.getLocalInstance(ctx).updatePartial(empEleContractSignRecordInfo, selector);
        return empEleContractSignRecordInfo;
    }

    @Override
    protected Object _createEContractForNewTemplate(Context ctx, IObjectValue empEleContractSignRecord, IObjectValue employeeContract, IObjectValue shrElectronicTemplate) throws BOSException, EASBizException {
        String eContractNO;
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = (EmpEleContractSignRecordInfo)empEleContractSignRecord;
        EmployeeContractInfo employeeContractInfo = (EmployeeContractInfo)employeeContract;
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = (SHRElectronicTemplateInfo)shrElectronicTemplate;
        if (!shrElectronicTemplateInfo.isIsRegister()) {
            throw new EmpEleContractException(EmpEleContractException.E_TEMPLATE_NOT_REGISTER);
        }
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        String kdappIdEContractNo = eContractNO = empEleContractSignRecordInfo.getEContractNO();
        LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
        String labContractFirstPartyId = "";
        if (labContractFirstParty == null || labContractFirstParty.getId() == null) {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_LABCONTRACTFIRSTPARTY_CANNOT_NULL);
        }
        labContractFirstPartyId = labContractFirstParty.getId().toString();
        String templateId = shrElectronicTemplateInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        ArrayList<HashMap<String, String>> osfContractDataList = new ArrayList<HashMap<String, String>>();
        PersonInfo person = empEleContractSignRecordInfo.getPerson();
        HashMap<String, String> osfContractData = new HashMap();
        if (StringUtils.isEmpty((String)shrElectronicTemplateInfo.getConfig())) {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_DATA_ERROE);
        }
        osfContractData = EmpElectronicContractUtilsEx.assembleContractInfoData(ctx, employeeContractInfo.getId().toString(), shrElectronicTemplateInfo, person);
        osfContractDataList.add(osfContractData);
        Map dataMap = ElectronicContractUtils.packageOsfParams(templateIds, (String)kdappIdEContractNo, osfContractDataList);
        dataMap.put("labContractFirstPartyInfoId", labContractFirstPartyId);
        dataMap.put("contractId", employeeContractInfo.getId().toString());
        logger.error("EmpEleContractServiceFacadeControllerBean._createEContractForNewTemplate dataMap : " + dataMap);
        this.sendFillTemplateRequest(ctx, csTemplateId, eContractNO, osfContractData, empEleContractSignRecordInfo);
        return empEleContractSignRecordInfo;
    }

    private void sendFillTemplateRequest(Context ctx, String cpTemplateId, String contractNo, Map<String, String> osfContractData, EmpEleContractSignRecordInfo empEleContractSignRecordInfo) throws EASBizException, BOSException {
        try {
            String serverURL = CloudServiceUtil.getServiceUrl((Context)ctx, (String)"BASE") + "/kdcontract/contract/fillTemplate";
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(serverURL);
            httpPost = (HttpPost)HttpMethodUtils.addHeader((Context)ctx, (AbstractHttpMessage)httpPost);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("templateId", cpTemplateId);
            ArrayList<String> fileIdList = new ArrayList<String>();
            fileIdList.add(contractNo);
            params.put("fileId", fileIdList);
            params.put("fileName", contractNo);
            ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
            dataList.add(osfContractData);
            params.put("data", dataList);
            String content = JSONUtils.convertObjectToJson((Context)ctx, params);
            logger.error("EmpEleContractServiceFacadeControllerBean.sendFillTemplateRequest serverURL : " + serverURL + ", content: " + content);
            httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)httpEntity);
            String encodeStr = Base64Utils.encode((String)response);
            logger.error("EmpEleContractServiceFacadeControllerBean.sendFillTemplateRequest serverURL : " + serverURL + ", response: " + encodeStr);
            JSONObject result = JSONObject.parseObject((String)response);
            if (result.get((Object)"errcode") != null && "1".equals(result.getString("errcode"))) {
                throw new BOSException(result.getString("description"));
            }
            empEleContractSignRecordInfo.setIsCreate(false);
            empEleContractSignRecordInfo.setCreateMethod(1);
            empEleContractSignRecordInfo.setIsFillSuccess(true);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isCreate"));
            selector.add(new SelectorItemInfo("createMethod"));
            selector.add(new SelectorItemInfo("isFillSuccess"));
            EmpEleContractSignRecordFactory.getLocalInstance(ctx).updatePartial(empEleContractSignRecordInfo, selector);
        }
        catch (UnsupportedCharsetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Object _getEmpEleContractSignStatus(Context ctx, Map param) throws BOSException, EASBizException {
        JSONObject data;
        int signStatus;
        String userId = (String)param.get("userId");
        String eContractNo = (String)param.get("eContractNo");
        String contractId = (String)param.get("contractId");
        String entryId = (String)param.get("entryId");
        HRBillBaseInfo billBaseInfo = null;
        if (!StringUtils.isEmpty((String)entryId)) {
            BOSUuid entryBosId = BOSUuid.read((String)entryId);
            IHRBillBaseEntry entryIn = (IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryBosId.getType());
            HRBillBaseEntryInfo billBaseEntryInfo = entryIn.getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            billBaseInfo = (HRBillBaseInfo)billBaseEntryInfo.getObjectValue("bill");
        }
        boolean isQueryCompanySign = param.get("isQueryCompanySign") == null ? false : Boolean.valueOf(param.get("isQueryCompanySign").toString());
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        EContractSignState contractSignStatus = empEleContractSignRecordInfo.getSignStatus();
        if (!StringUtils.isEmpty((String)userId) && !isQueryCompanySign && 1 == contractSignStatus.getValue() && empEleContractSignRecordInfo.isIsPersonSign()) {
            JSONObject res = new JSONObject();
            JSONObject data2 = new JSONObject();
            res.put("code", (Object)0);
            res.put("msg", (Object)"SUCCESS");
            data2.put("signStatus", (Object)1);
            res.put("data", (Object)data2);
            return res;
        }
        if (isQueryCompanySign && 2 == contractSignStatus.getValue() && empEleContractSignRecordInfo.isIsCompanySign() && empEleContractSignRecordInfo.isIsSigned()) {
            JSONObject res = new JSONObject();
            JSONObject data3 = new JSONObject();
            res.put("code", (Object)0);
            res.put("msg", (Object)"SUCCESS");
            data3.put("signStatus", (Object)1);
            res.put("data", (Object)data3);
            return res;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("contractNo", eContractNo);
        if (!StringUtils.isEmpty((String)userId)) {
            dataMap.put("userId", userId);
        }
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        logger.error("EmpEleContractServiceFacadeControllerBean._getEmpEleContractSignStatus dataMap : " + dataMap);
        Object result = osfServiceFacade.processService("electronicLaborGetSignStatusService", dataMap);
        logger.error("EmpEleContractServiceFacadeControllerBean._getEmpEleContractSignStatus result : " + result);
        JSONObject resObj = null;
        resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
        int code = resObj.getIntValue("code");
        if (code == 0 && (signStatus = (data = resObj.getJSONObject("data")).getIntValue("signStatus")) == 1) {
            if (!StringUtils.isEmpty((String)userId)) {
                empEleContractSignRecordInfo.setIsPersonSign(true);
                empEleContractSignRecordInfo.setPersonSignTime(EmpElectronicContractUtilsEx.getCurTimestamp());
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.signing);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("isPersonSign"));
                selector.add(new SelectorItemInfo("personSignTime"));
                selector.add(new SelectorItemInfo("signStatus"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.signing);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.signing);
            } else if (isQueryCompanySign) {
                empEleContractSignRecordInfo.setIsCompanySign(true);
                empEleContractSignRecordInfo.setCompanySignTime(EmpElectronicContractUtilsEx.getCurTimestamp());
                empEleContractSignRecordInfo.setIsSigned(true);
                empEleContractSignRecordInfo.setSignedTime(EmpElectronicContractUtilsEx.getCurTimestamp());
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.complete);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("isCompanySign"));
                selector.add(new SelectorItemInfo("companySignTime"));
                selector.add(new SelectorItemInfo("isSigned"));
                selector.add(new SelectorItemInfo("signedTime"));
                selector.add(new SelectorItemInfo("signStatus"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.complete);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.complete);
            }
            EmpEleContractFollowUtils.doUpdateStateInBill(ctx, billBaseInfo);
        }
        return result;
    }

    @Override
    protected Object _checkPersonHashAuth(Context ctx, String personId, String kdContractConfigId, String contractId, String eContractNO) throws BOSException, EASBizException {
        IKDContractConfig instance;
        Object coll;
        KDContractConfigInfo kdContractConfigInfo = null;
        if (!StringUtils.isEmpty((String)kdContractConfigId) && (coll = (instance = KDContractConfigFactory.getLocalInstance((Context)ctx)).getKDContractConfigCollection(MessageFormat.format(" where id = ''{0}''", kdContractConfigId))) != null && coll.size() > 0) {
            kdContractConfigInfo = coll.get(0);
        }
        if (kdContractConfigInfo == null) {
            String kdConfigInfoId;
            IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance(ctx);
            coll = electronicContractRelation.getElectronicContractRelationCollection("where contractId = '" + eContractNO + "'");
            ElectronicContractRelationInfo relation = null;
            if (coll.size() > 0) {
                relation = ((ElectronicContractRelationCollection)((Object)coll)).get(0);
            }
            if (relation != null && !StringUtils.isEmpty((String)(kdConfigInfoId = relation.getSimpleName()))) {
                IKDContractConfig instance2 = KDContractConfigFactory.getLocalInstance((Context)ctx);
                KDContractConfigCollection kdColls = instance2.getKDContractConfigCollection(MessageFormat.format(" where id = ''{0}''", kdConfigInfoId));
                if (coll != null && coll.size() > 0) {
                    kdContractConfigInfo = kdColls.get(0);
                }
            }
        }
        if (kdContractConfigInfo == null) {
            IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
            EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
            LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
            kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
        }
        PersonThreeEleInfo personThreeInfo = EmpElectronicContractUtilsEx.getPersonThreeInfo(ctx, personId);
        SSCPersonAuthRecordInfo authRecordInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)personThreeInfo.getIdCardNO()));
        filter.getFilterItems().add(new FilterItemInfo("mobile", (Object)personThreeInfo.getMobile()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)personThreeInfo.getName()));
        filter.getFilterItems().add(new FilterItemInfo("kdContractConfig", (Object)kdContractConfigInfo.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        logger.error("EmpEleContractServiceFacadeControllerBean _checkPersonHashAuth view \uff1a " + view);
        SSCPersonAuthRecordCollection collection = SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).getSSCPersonAuthRecordCollection(view);
        boolean isNeedGetResultFormCloud = false;
        if (collection.size() > 0) {
            int PersonAuthResultValue;
            authRecordInfo = collection.get(0);
            SSCPersonAuthResult result = authRecordInfo.getResult();
            int n = PersonAuthResultValue = result != null ? result.getValue() : -999;
            if (1 != PersonAuthResultValue || StringUtils.isEmpty((String)authRecordInfo.getUserId())) {
                isNeedGetResultFormCloud = true;
            }
        } else {
            isNeedGetResultFormCloud = true;
        }
        if (isNeedGetResultFormCloud) {
            if (authRecordInfo == null) {
                authRecordInfo = new SSCPersonAuthRecordInfo();
                authRecordInfo.setKdContractConfig(kdContractConfigInfo);
                authRecordInfo.setIdCardNo(personThreeInfo.getIdCardNO());
                authRecordInfo.setMobile(personThreeInfo.getMobile());
                authRecordInfo.setName(personThreeInfo.getName());
                authRecordInfo.setPersonId(personThreeInfo.getId());
            }
            authRecordInfo = this.processAuthInfoFormCloud(ctx, kdContractConfigInfo, personThreeInfo, authRecordInfo);
        }
        logger.error("EmpEleContractServiceFacadeControllerBean _checkPersonHashAuth authRecordInfo \uff1a " + authRecordInfo.getId());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("userId", authRecordInfo.getUserId());
        res.put("result", (String)authRecordInfo.getResult());
        res.put("idCardNo", authRecordInfo.getIdCardNo());
        return res;
    }

    public SSCPersonAuthRecordInfo processAuthInfoFormCloud(Context ctx, KDContractConfigInfo configInfo, PersonThreeEleInfo personThreeEleInfo, SSCPersonAuthRecordInfo authRecordInfo) throws BOSException, EASBizException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", personThreeEleInfo.getIdCardNO());
        dataMap.put("name", personThreeEleInfo.getName());
        dataMap.put("kdAppId", configInfo.getClientKDAppId());
        dataMap.put("secret", configInfo.getClientSecret());
        dataMap.put("version", configInfo.getCloudSysVersion().getValue());
        dataMap.put("serverURL", configInfo.getCloudServerUrl());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject osfResult = (JSONObject)osfServiceFacade.processService("electronicLaborGetAuthResultService", dataMap);
        if (osfResult.getIntValue("code") == 0) {
            int resultCode = osfResult.getJSONObject("data").getIntValue("resultCode");
            String userId = osfResult.getJSONObject("data").getString("userId");
            SSCPersonAuthResult authResult = null;
            authResult = resultCode == 0 ? SSCPersonAuthResult.FAIL : (resultCode == 1 ? SSCPersonAuthResult.SUCCESS : (resultCode == 2 ? SSCPersonAuthResult.AUTHING : SSCPersonAuthResult.OTHER));
            authRecordInfo.setUserId(userId);
            authRecordInfo.setResult(authResult);
        }
        SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)authRecordInfo);
        return authRecordInfo;
    }
}

