/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.elecontract.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.elecontract.EContractSealTypeFactory;
import com.kingdee.shr.elecontract.EContractSealTypeInfo;
import com.kingdee.shr.elecontract.EContractSignImgFactory;
import com.kingdee.shr.elecontract.EContractSignImgInfo;
import com.kingdee.shr.elecontract.EElBizType;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDContractConfigRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigRecordInfo;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpSyncSaveContractConfigRecordInfoRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EmpSyncSaveContractConfigRecordInfoRunnable.class);
    private static final String EmployeeOtherContract = "61E64FC2";
    private Context ctx;
    private String contractId;
    private String contractNo;
    private Map<String, Object> dataMap;
    private JSONObject jsonObject;
    private KDContractConfigInfo config;

    public EmpSyncSaveContractConfigRecordInfoRunnable(Context ctx, String contractId, String contractNo, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo config) {
        this.ctx = ctx;
        this.contractId = contractId;
        this.contractNo = contractNo;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.config = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            UserInfo userInfo;
            if (this.jsonObject.getIntValue("code") != 0) return;
            BOSUuid empContractId = null;
            if (StringUtils.isEmpty((String)this.contractId)) {
                IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance(this.ctx);
                ElectronicContractRelationCollection coll = electronicContractRelation.getElectronicContractRelationCollection("where contractId = '" + this.contractNo + "'");
                if (coll.size() <= 0) return;
                ElectronicContractRelationInfo relation = coll.get(0);
                empContractId = relation.getEmpContractId();
                this.contractId = empContractId.toString();
            } else {
                empContractId = BOSUuid.read((String)this.contractId);
            }
            KDContractConfigRecordInfo kDContractConfigRecordInfo = new KDContractConfigRecordInfo();
            IObjectValue personInfo = this.getPersonInfo();
            if (personInfo != null) {
                if (personInfo instanceof PersonInfo) {
                    PersonInfo person = (PersonInfo)personInfo;
                    kDContractConfigRecordInfo.setPerson((PersonInfo)personInfo);
                    if (person.get("name") == null) {
                        person = PersonFactory.getLocalInstance((Context)this.ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()), this.getCommonSelector());
                    }
                    kDContractConfigRecordInfo.setPerson(person);
                    kDContractConfigRecordInfo.setPersonName(person.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    kDContractConfigRecordInfo.setPersonName(person.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    kDContractConfigRecordInfo.setPersonName(person.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                }
                if (personInfo instanceof PreEntryPersonInfo) {
                    PreEntryPersonInfo preEntryPerson = (PreEntryPersonInfo)personInfo;
                    if (preEntryPerson.get("name") == null) {
                        preEntryPerson = PreEntryPersonFactory.getLocalInstance((Context)this.ctx).getPreEntryPersonInfo((IObjectPK)new ObjectUuidPK(preEntryPerson.getId()), this.getCommonSelector());
                    }
                    kDContractConfigRecordInfo.setPreEntryPerson(preEntryPerson);
                    kDContractConfigRecordInfo.setPersonName(preEntryPerson.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    kDContractConfigRecordInfo.setPersonName(preEntryPerson.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    kDContractConfigRecordInfo.setPersonName(preEntryPerson.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                }
            }
            String bizType = empContractId.getType().toString();
            KDContractConfigInfo tempConfig = this.config;
            Map dataMaps = (Map)this.dataMap.get("data");
            if (EmployeeOtherContract.equals(bizType)) {
                KDContractConfigCollection configCollection;
                List userIds;
                String userId;
                Object userIdsObj;
                kDContractConfigRecordInfo.setUseBiz(EElBizType.Other_Contract);
                if (dataMaps != null && dataMaps.size() > 0 && (userIdsObj = dataMaps.get("userIds")) != null && userIdsObj.toString().length() > 0 && !StringUtils.isEmpty((String)(userId = (String)(userIds = (List)JSONUtils.convertJsonToObject((Context)this.ctx, (String)userIdsObj.toString(), List.class)).get(0))) && (configCollection = KDContractConfigFactory.getLocalInstance((Context)this.ctx).getKDContractConfigCollection("select id, clientEnterpriseId, enterpriseName where clientEnterpriseId = '" + userId + "'")).size() > 0) {
                    tempConfig = configCollection.get(0);
                }
            } else {
                kDContractConfigRecordInfo.setUseBiz(EElBizType.Lab_Contract);
            }
            if ((userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx)).get("name") == null) {
                userInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId()), this.getCommonSelector());
            }
            kDContractConfigRecordInfo.setCreatorName(userInfo.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            kDContractConfigRecordInfo.setCreatorName(userInfo.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            kDContractConfigRecordInfo.setCreatorName(userInfo.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            IKDContractConfig ikdContractConfig = KDContractConfigFactory.getLocalInstance((Context)this.ctx);
            if (tempConfig.get("clientEnterpriseId") == null || tempConfig.get("enterpriseName") == null) {
                SelectorItemCollection selector1 = new SelectorItemCollection();
                selector1.add(new SelectorItemInfo("id"));
                selector1.add(new SelectorItemInfo("clientEnterpriseId"));
                selector1.add(new SelectorItemInfo("enterpriseName"));
                tempConfig = ikdContractConfig.getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(tempConfig.getId()), selector1);
            }
            EContractSealTypeInfo eContractSealTypeInfo = new EContractSealTypeInfo();
            EContractSignImgInfo eContractSignImgInfo = null;
            logger.info("_dataMaps_ is " + dataMaps);
            if (dataMaps != null && dataMaps.size() > 0) {
                Object signatureIds;
                String signatureId = (String)dataMaps.get("signatureId");
                Object userIds = dataMaps.get("userIds");
                if (null != userIds && (signatureIds = dataMaps.get("signatureIds")) != null && signatureIds.toString().length() > 0) {
                    List signatureIdsList = (List)JSONUtils.convertJsonToObject((Context)this.ctx, (String)signatureIds.toString(), List.class);
                    signatureId = (String)signatureIdsList.get(0);
                }
                logger.info("_signatureId_ is " + signatureId);
                if (signatureId == null) {
                    eContractSealTypeInfo = EContractSealTypeFactory.getLocalInstance((Context)this.ctx).getEContractSealTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000057D8E364")));
                } else {
                    SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                    selectorItemCollection.add(new SelectorItemInfo("eContractSealType.name"));
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("signatrueId", (Object)signatureId));
                    filterInfo.getFilterItems().add(new FilterItemInfo("kdContractConfig", (Object)tempConfig.getId().toString()));
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    entityViewInfo.setSelector(selectorItemCollection);
                    entityViewInfo.setFilter(filterInfo);
                    eContractSignImgInfo = EContractSignImgFactory.getLocalInstance((Context)this.ctx).getEContractSignImgCollection(entityViewInfo).get(0);
                    eContractSealTypeInfo = eContractSignImgInfo.getEContractSealType();
                    logger.info("eContractSignImgInfo " + eContractSignImgInfo);
                }
            }
            kDContractConfigRecordInfo.setEContractSealTypeName(eContractSealTypeInfo.getName());
            kDContractConfigRecordInfo.setEContractSignImg(eContractSignImgInfo);
            Timestamp curTimestamp = HRUtilExtend.getCurTimestamp();
            kDContractConfigRecordInfo.setCreator(userInfo);
            kDContractConfigRecordInfo.setLastUpdateUser(userInfo);
            kDContractConfigRecordInfo.setLastUpdateTime(curTimestamp);
            kDContractConfigRecordInfo.setCreateTime(curTimestamp);
            kDContractConfigRecordInfo.setConfig(tempConfig);
            kDContractConfigRecordInfo.setEnterpId(tempConfig.getClientEnterpriseId());
            kDContractConfigRecordInfo.setEnterpName(tempConfig.getEnterpriseName());
            kDContractConfigRecordInfo.setBoId(empContractId);
            kDContractConfigRecordInfo.setBizBosType(bizType);
            kDContractConfigRecordInfo.setFileNo(this.contractNo);
            kDContractConfigRecordInfo.setState(BaseItemStateEnum.DISABLE);
            kDContractConfigRecordInfo.setResult(false);
            KDContractConfigRecordFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)kDContractConfigRecordInfo);
            return;
        }
        catch (EASBizException e) {
            logger.error("EmpSyncSaveContractConfigRecordInfoRunnable EASBizException : " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (BOSException e) {
            logger.error("EmpSyncSaveContractConfigRecordInfoRunnable BOSException : " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (UuidException e) {
            logger.error("EmpSyncSaveContractConfigRecordInfoRunnable UuidException : " + e.getMessage(), (Throwable)e);
        }
    }

    public IObjectValue getPersonInfo() throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)this.contractId)) {
            String bosType = BOSUuid.read((String)this.contractId).getType().toString();
            logger.error("EmpSyncSaveContractConfigRecordInfoRunnable getPersonInfo bosType: " + bosType + "===contractId==" + this.contractId);
            if (EmployeeOtherContract.equals(bosType)) {
                logger.error("EmpSyncSaveContractConfigRecordInfoRunnable getPersonInfo EmployeeOtherContract  bosType: " + bosType + "===contractId==" + this.contractId);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmployeeOtherContractFactory.getLocalInstance((Context)this.ctx).getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(this.contractId), this.getSelectorCollection());
                if (employeeOtherContractInfo != null) {
                    if (employeeOtherContractInfo.getEmployee() != null) {
                        return employeeOtherContractInfo.getEmployee();
                    }
                    return employeeOtherContractInfo.getPreEntryPerson();
                }
            } else {
                EmployeeContractInfo employeeContractInfo = EmployeeContractFactory.getLocalInstance((Context)this.ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(this.contractId), this.getSelectorCollection());
                if (employeeContractInfo != null) {
                    if (employeeContractInfo.getEmployee() != null) {
                        return employeeContractInfo.getEmployee();
                    }
                    return employeeContractInfo.getPreEntryPerson();
                }
            }
            return null;
        }
        return null;
    }

    public SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        return selector;
    }

    public SelectorItemCollection getCommonSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        return selector;
    }
}

