/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.emp.app.AbstractBIEmployeeStructureFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BIEmployeeStructureFacadeControllerBean
extends AbstractBIEmployeeStructureFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.BIEmployeeStructureFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        String times;
        String tempPerosnTable = this.createPersonTempTable(ctx, params);
        SchemaSource ss = new SchemaSource();
        ss.setCaller(BIEmployeeStructureFacadeControllerBean.class);
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)params.getObjectElement("prmtAdminUnit.value");
        if (adminOrgUnitInfo != null) {
            adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId()));
        }
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String choosed = params.getString("choosed");
        StringBuffer sql = null;
        StringBuffer mdx = null;
        if ("Age".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_Age.xml");
            String tempTable = null;
            boolean isUseDefault = params.getBoolean("isUseDefaultTimeSeg");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            if (isUseDefault) {
                tempTable = "T_HR_BDAgeSegment";
            } else {
                String times2 = params.getString("time");
                tempTable = this.createTimeTempTable(ctx, times2);
            }
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM ");
            sql.append(tempTable);
            sql.append(" union all ");
            sql.append("SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("Age", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,s.fid as FAgeID from ");
            sql.append(" t_bd_person p ");
            sql.append(" inner join ");
            sql.append(tempTable);
            sql.append(" s on ");
            if (isUseDefault) {
                sql.append("Year(now()) - Year(p.fbirthday) >= s.fstartage and Year(now()) - Year(p.fbirthday) <= s.fendage ");
            } else {
                sql.append("Year(now()) - Year(p.fbirthday) >= s.fstart and Year(now()) - Year(p.fbirthday) <= s.fend ");
            }
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID ");
            sql.append(" WHERE pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' GROUP BY a.FID,s.fid ");
            sql.append(" union all");
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,'XXXX' as FAgeID from");
            sql.append(" t_bd_person p");
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID");
            sql.append(" WHERE p.fbirthday is null and (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" GROUP BY a.FID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Age].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Age].Members,[Measures].[PersonCount]),sum([Age].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Age].Members,[Age].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("CompanyYears".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_CompanyYears.xml");
            times = params.getString("time");
            String tempTable = this.createTimeTempTable(ctx, times);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM ");
            sql.append(tempTable);
            sql.append(" union all ");
            sql.append(" SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"4_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("CompanyYears", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,t.fid as FJoinCompanyYears from ");
            sql.append(" t_bd_person p ");
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID ");
            sql.append(" inner join ");
            sql.append(tempTable);
            sql.append(" t on pp.FJoinCompanyYears >= t.fstart and pp.FJoinCompanyYears < t.fend");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID ");
            sql.append(" WHERE pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' GROUP BY a.FID,t.fid ");
            sql.append(" union all");
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,'XXXX' as FJoinCompanyYears from");
            sql.append(" t_bd_person p");
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID");
            sql.append(" WHERE pp.FJoinCompanyYears is null and (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" GROUP BY a.FID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [CompanyYears].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([CompanyYears].Members,[Measures].[PersonCount]),sum([CompanyYears].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[CompanyYears].Members,[CompanyYears].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("EmpClassify".equals(choosed)) {
            // empty if block
        }
        if ("GroupYears".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_GroupYears.xml");
            times = params.getString("time");
            String tempTable = this.createTimeTempTable(ctx, times);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM ");
            sql.append(tempTable);
            sql.append(" union all ");
            sql.append(" SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("GroupYears", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,t.fid as FJoinGroupYears from ");
            sql.append(" t_bd_person p ");
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID ");
            sql.append(" inner join ");
            sql.append(tempTable);
            sql.append(" t on pp.FJoinGroupYears >= t.fstart and pp.FJoinGroupYears < t.fend");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID ");
            sql.append(" WHERE pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' GROUP BY a.FID,t.fid ");
            sql.append(" union all");
            sql.append(" select count(p.fid) as FPersonCount,a.fid as FAdminOrgUnitID,'XXXX' as FJoinGroupYears from");
            sql.append(" t_bd_person p");
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition pp ON p.FID = pp.FPersonID");
            sql.append(" LEFT OUTER JOIN T_ORG_Admin a ON pp.FPersonDep = a.FID");
            sql.append(" WHERE pp.FJoinGroupYears is null and (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" GROUP BY a.FID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [GroupYears].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([GroupYears].Members,[Measures].[PersonCount]),sum([GroupYears].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[GroupYears].Members,[GroupYears].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("JobGrade".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_JobGrade.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM T_HR_JobGrade ");
            sql.append("union all ");
            sql.append("SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("JobGrade", sql.toString(), null);
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case pp.FJobGrade when null then 'XXXX' else pp.FJobGrade end as FJobGrade,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,pp.FJobGrade");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [JobGrade].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([JobGrade].Members,[Measures].[PersonCount]),sum([JobGrade].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[JobGrade].Members,[JobGrade].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("Job".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_Job.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append(" WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select j.fid as FJobID,j.fname_");
            sql.append(loc);
            sql.append(" as FJobName,jc.fid as FJobCategoryID,jc.fname_");
            sql.append(loc);
            sql.append(" as FJobCategoryName ");
            sql.append(" from T_ORG_Job j ");
            sql.append(" inner join t_org_jobCategory jc on j.FJobCategoryID = jc.FID");
            sql.append(" inner join t_org_position p on p.fjobId = j.fid");
            sql.append(" inner join t_org_admin a on p.FAdminOrgUnitId = a.fid");
            sql.append(" WHERE a.FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            sql.append(" union all ");
            sql.append(" SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName,'test' as FJobCategoryID,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' as FJobCategoryName");
            ss.setDataItem("Job", sql.toString(), null);
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case j.fid when null then 'XXXX' else j.fid end as FJobID,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" left outer join t_org_position po on pp.FPrimaryPositionID = po.fid");
            sql.append(" left outer join t_org_job j on po.fjobid = j.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,j.fid");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append(")] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Job].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Job].Members,[Measures].[PersonCount]),sum([Job].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Job].Members,[Job].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("JobCategory".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_JobCategory.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append(" WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select jc.fid as FID,jc.fname_");
            sql.append(loc);
            sql.append(" as FName,jc.FParentID as FParentID");
            sql.append(" from t_org_jobCategory jc");
            sql.append(" inner join t_org_job j on j.FJobCategoryID = jc.FID");
            sql.append(" inner join t_org_position p on p.fjobId = j.fid");
            sql.append(" inner join t_org_admin a on p.FAdminOrgUnitId = a.fid");
            sql.append(" WHERE a.FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            sql.append(" union all ");
            sql.append(" SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName,null as FParentID");
            ss.setDataItem("JobCategory", sql.toString(), null);
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case jc.fid when null then 'XXXX' else jc.fid end as FJobCategoryID,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" left outer join t_org_position po on pp.FPrimaryPositionID = po.fid");
            sql.append(" left outer join t_org_job j on po.fjobid = j.fid");
            sql.append(" left outer join t_org_jobcategory jc on j.FJobCategoryID = jc.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,jc.fid");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember) * descendants([JobCategory].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[JobCategory].Members} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("Sex".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_Sex.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select 1 as fid,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"5_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' as fname");
            sql.append(" union");
            sql.append(" select 2 as fid,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"6_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' as fname");
            sql.append(" union all ");
            sql.append(" select -1 as fid,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' as fname");
            ss.setDataItem("Sex", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case p.fgender when null then -1 else p.fgender end as FGender,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,p.fgender");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Sex].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Sex].Members,[Measures].[PersonCount]),sum([Sex].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Sex].Members,[Sex].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("Teach".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_Teach.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM T_BD_HRDiploma ");
            sql.append("union all ");
            sql.append("SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("Degree", sql.toString(), null);
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case p.FHighestDegreeID when null then 'XXXX' else p.FHighestDegreeID end as FHighestDegreeID,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,p.FHighestDegreeID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Degree].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Degree].Members,[Measures].[PersonCount]),sum([Degree].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Degree].Members,[Degree].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("Technical".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure_Technical.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append(" select tp.fid as FTechPostID,tp.Fname_");
            sql.append(loc);
            sql.append(" as FTechPostName,tpt.fid as FTechPostTypeID,tpt.fname_");
            sql.append(loc);
            sql.append(" as FTechPostTypeName");
            sql.append(" from T_HR_BDTechnicalPost tp");
            sql.append(" inner join T_HR_BDTechPostType tpt on tpt.fid = tp.FCATEGORYID");
            sql.append(" where tp.fisstandard = 0");
            ss.setDataItem("Tech", sql.toString(), null);
            sql = new StringBuffer();
            sql = new StringBuffer();
            sql.append(" select count(p.fid) as FPersonCount,case p.FHighestTechPostID when null then 'XXXX' else p.FHighestTechPostID end as FHighestTechPostID,a.fid as FAdminOrgUnitID");
            sql.append(" from t_bd_person p");
            sql.append(" left outer join t_hr_personposition pp on pp.fpersonid = p.fid");
            sql.append(" left outer join t_org_admin a on pp.FPersonDep = a.fid");
            sql.append(" WHERE (pp.FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR a.FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" group by a.fid,p.FHighestTechPostID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Tech].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Tech].Members,[Measures].[PersonCount]),sum([Tech].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Tech].Members,[Tech].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        if ("TechType".equals(choosed)) {
            // empty if block
        }
        if ("Wed".equals(choosed)) {
            ss.setFilename("BIEmployeeStructure.xml");
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName,FParentID FROM T_ORG_Admin ");
            sql.append("WHERE FID ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%' ");
            ss.setDataItem("AdminOrgUnit", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT FID,FName_");
            sql.append(loc);
            sql.append(" AS FName FROM T_BD_HRWed ");
            sql.append("union ");
            sql.append("SELECT 'XXXX' AS FID ,N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"0_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            sql.append("' AS FName ");
            ss.setDataItem("Wed", sql.toString(), null);
            sql = new StringBuffer();
            sql.append("SELECT T_ORG_Admin.FID AS FAdminOrgUnitID,");
            sql.append("CASE FWedID WHEN NULL THEN 'XXXX' ELSE FWedID END AS FWedID,");
            sql.append("COUNT(p.FID) AS FPersonCount ");
            sql.append("FROM T_BD_Person p ");
            sql.append("LEFT OUTER JOIN T_HR_PersonPosition ON p.FID=T_HR_PersonPosition.FPersonID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin ON T_HR_PersonPosition.FPersonDep=T_ORG_Admin.FID ");
            sql.append("LEFT OUTER JOIN T_BD_HRWed ON p.FWedID=T_BD_HRWed.FID ");
            sql.append("WHERE (FPersonDep ='");
            sql.append(adminOrgUnitInfo.getId().toString());
            sql.append("' OR FLongNumber LIKE '");
            sql.append(adminOrgUnitInfo.getLongNumber());
            sql.append("!%') ");
            this.addTempTableFilter(tempPerosnTable, sql);
            sql.append(" GROUP BY T_ORG_Admin.FID,FWedID");
            ss.setDataItem("Fact", sql.toString(), null);
            mdx = new StringBuffer();
            mdx.append(" WITH MEMBER [Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'sum({descendants([AdminOrgUnit].currentmember)},[Measures].[PersonCount])',FORMATSTRING = '#,##0'");
            mdx.append(" MEMBER [Wed].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("] as 'iif([Measures].CurrentMember = [Measures].[PersonCount],sum([Wed].Members,[Measures].[PersonCount]),sum([Wed].Members,[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]))',FORMATSTRING = '#,##0'");
            mdx.append(" SELECT {[AdminOrgUnit].Members} on rows,{[Wed].Members,[Wed].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"2_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} * {[Measures].[PersonCount],[Measures].[");
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"1_BIEmployeeStructureFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mdx.append("]} on columns from Fact");
            ss.setMdx(mdx.toString());
        }
        return ss;
    }

    private String createTimeTempTable(Context ctx, String times) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Object sql = null;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String createSql = "create table t_temp_tempempbi(fid varchar(44) not null,fname_" + loc + " nvarchar(80),fstart int,fend int)";
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String insertSql = "insert into " + tempTable + "(fid,fname_" + loc + ",fstart,fend) values(?,?,?,?)";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insertSql);
            String[][] result = this.getTimeFromTo(times, ";", "-");
            if (result != null) {
                for (int i = 0; i < result.length; ++i) {
                    ps.setString(1, Integer.valueOf(i).toString());
                    ps.setString(2, result[i][0] + " - " + result[i][1]);
                    ps.setInt(3, Integer.valueOf(result[i][0]));
                    ps.setInt(4, Integer.valueOf(result[i][1]));
                    ps.execute();
                }
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempTable;
    }

    private String[][] getTimeFromTo(String param, String sep1, String sep2) {
        String[][] result = null;
        if (StringUtils.isEmpty((String)param)) {
            return result;
        }
        String[] parse1 = StringUtils.split((String)param, (String)sep1);
        result = new String[parse1.length][];
        for (int i = 0; i < parse1.length; ++i) {
            result[i] = StringUtils.split((String)parse1[i], (String)sep2);
        }
        return result;
    }

    private void addTempTableFilter(String tempTable, StringBuffer sql) throws BOSException, EASBizException {
        sql.append(" AND p.FID IN ( SELECT FID FROM ");
        sql.append(tempTable);
        sql.append(") ");
    }

    private String createPersonTempTable(Context ctx, RptParams params) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Object sql = null;
        IMetaDataPK queryPK = (IMetaDataPK)params.getObject("QueryPK");
        EntityViewInfo evInfo = (EntityViewInfo)params.getObject("EntityViewInfo");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(evInfo);
        StringBuffer buf = new StringBuffer(" SELECT ID FROM (");
        buf.append(queryExcu.getSQL());
        buf.append(") ");
        String createSql = "create table t_temp_temppersonbi(fid varchar(44) not null)";
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String insertSql = "insert into " + tempTable + buf.toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insertSql);
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempTable;
    }
}

