/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import java.util.HashMap;

public class BillTypeEnum {
    public static final int SIGN_VALUE = 0;
    public static final int RENEW_VALUE = 1;
    public static final int CHANGE_VALUE = 2;
    public static final int END_VALUE = 3;
    public static final int FREE_VALUE = 4;
    public static final int PRE_SIGN_VALUE = 5;
    public static final int PRE_NEW_SIGN_VALUE = 6;
    public static final String SIGN_NAME = "SIGN";
    public static final String RENEW_NAME = "RENEW";
    public static final String CHANGE_NAME = "CHANGE";
    public static final String END_NAME = "END";
    public static final String FREE_NAME = "FREE";
    public static final String PRE_SIGN_NAME = "PRE_SIGN";
    public static final String PRE_NEW_SIGN_NAME = "PRE_NEW_SIGN";
    public static final String SIGN_TABLE = "T_HR_ContractSignBizBill";
    public static final String RENEW_TABLE = "T_HR_ContractRenewBizBill";
    public static final String CHANGE_TABLE = "T_HR_ContractChangeBizBill";
    public static final String END_TABLE = "T_HR_ContractEndBizBill";
    public static final String FREE_TABLE = "T_HR_ContractFreeBizBill";
    public static final String PRE_SIGN_TABLE = "T_HR_ContractPreSignBizBill";
    public static final String PRE_NEW_SIGN_TABLE = "T_HR_ContractPreNewSignBizBill";
    public static final String SIGN_ENTRY = "T_HR_ContractSignBizBillEntry";
    public static final String RENEW_ENTRY = "T_HR_ContractRenewBizBillEntry";
    public static final String CHANGE_ENTRY = "T_HR_ContractChangeBillEntry";
    public static final String END_ENTRY = "T_HR_ContractEndBizBillEntry";
    public static final String FREE_ENTRY = "T_HR_ContractFreeBizBillEntry";
    public static final String PRE_SIGN_ENTRY = "T_HR_ContractPreSignBillEntry";
    public static final String PRE_NEW_SIGN_ENTRY = "T_HR_ContractPreNewSignBBEntry";
    public static final String SIGN_BOSTYPE = "502B7D81";
    public static final String RENEW_BOSTYPE = "2A2632A9";
    public static final String CHANGE_BOSTYPE = "056FBF2E";
    public static final String END_BOSTYPE = "8015FF9B";
    public static final String FREE_BOSTYPE = "87AFF1F2";
    public static final String PRE_SIGN_BOSTYPE = "9F4ECBD6";
    public static final String PRE_NEW_SIGN_BOSTYPE = "A7021A44";
    public static final BillTypeEnum SIGN;
    public static final BillTypeEnum RENEW;
    public static final BillTypeEnum CHANGE;
    public static final BillTypeEnum END;
    public static final BillTypeEnum FREE;
    public static final BillTypeEnum PRE_SIGN;
    public static final BillTypeEnum PRE_NEW_SIGN;
    private static final HashMap<String, BillTypeEnum> bosTypeMap;
    private final int value;
    private final String typeName;
    private final String tableName;
    private final String entryTableName;
    private final String bosType;

    private BillTypeEnum(int value, String name, String table, String entry, String bosType) {
        this.value = value;
        this.typeName = name;
        this.tableName = table;
        this.entryTableName = entry;
        this.bosType = bosType;
        if (!bosTypeMap.containsKey(bosType)) {
            bosTypeMap.put(bosType, this);
        }
    }

    public static BillTypeEnum getEnum(int value) {
        switch (value) {
            case 0: {
                return SIGN;
            }
            case 1: {
                return RENEW;
            }
            case 2: {
                return CHANGE;
            }
            case 3: {
                return END;
            }
            case 4: {
                return FREE;
            }
            case 5: {
                return PRE_SIGN;
            }
            case 6: {
                return PRE_NEW_SIGN;
            }
        }
        return null;
    }

    public static BillTypeEnum getEnum(String bosType) {
        return bosTypeMap.get(bosType);
    }

    public int getValue() {
        return this.value;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntryTableName() {
        return this.entryTableName;
    }

    public String getBosType() {
        return this.bosType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BillTypeEnum) {
            return this.getValue() == ((BillTypeEnum)obj).getValue();
        }
        return super.equals(obj);
    }

    static {
        bosTypeMap = new HashMap();
        SIGN = new BillTypeEnum(0, SIGN_NAME, SIGN_TABLE, SIGN_ENTRY, SIGN_BOSTYPE);
        RENEW = new BillTypeEnum(1, RENEW_NAME, RENEW_TABLE, RENEW_ENTRY, RENEW_BOSTYPE);
        CHANGE = new BillTypeEnum(2, CHANGE_NAME, CHANGE_TABLE, CHANGE_ENTRY, CHANGE_BOSTYPE);
        END = new BillTypeEnum(3, END_NAME, END_TABLE, END_ENTRY, END_BOSTYPE);
        FREE = new BillTypeEnum(4, FREE_NAME, FREE_TABLE, FREE_ENTRY, FREE_BOSTYPE);
        PRE_SIGN = new BillTypeEnum(5, PRE_SIGN_NAME, PRE_SIGN_TABLE, PRE_SIGN_ENTRY, PRE_SIGN_BOSTYPE);
        PRE_NEW_SIGN = new BillTypeEnum(6, PRE_NEW_SIGN_NAME, PRE_NEW_SIGN_TABLE, PRE_NEW_SIGN_ENTRY, PRE_NEW_SIGN_BOSTYPE);
    }
}

