/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.hr.base.AgeSegmentCollection;
import com.kingdee.eas.hr.base.AgeSegmentFactory;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IAgeSegment;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.base.util.ReportOrgQueryInfo;
import com.kingdee.eas.hr.base.util.ShrIDCardNOPassportCheckUtil;
import com.kingdee.eas.hr.base.util.TreeData;
import com.kingdee.eas.hr.emp.EmployeeBosBizException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonCmp;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.IPersonEnrollHistory;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.ISocialInsurance;
import com.kingdee.eas.hr.emp.PersonCmpFactory;
import com.kingdee.eas.hr.emp.PersonCmpInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryFactory;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryInfo;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.SocialInsuranceFactory;
import com.kingdee.eas.hr.emp.SocialInsuranceInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpInnerFacadeControllerBean;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PosPerPlanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class EmpInnerFacadeControllerBean
extends AbstractEmpInnerFacadeControllerBean {
    private static final long serialVersionUID = -3580190740524761049L;
    private static String personIDCardNo = "com.kingdee.eas.basedata.person.PersonIDCardNoResource.";
    private String personTypeSign = null;
    private boolean nullPositionSign = false;

    @Override
    protected void _checkPersonValid(Context ctx, PersonInfo pInfo, String idCardNumber, String passportNumber) throws BOSException, EASBizException {
        String personId = null;
        if (pInfo.getId() != null) {
            personId = pInfo.getId().toString();
        }
        ShrIDCardNOPassportCheckUtil.checkIsIdCardNOPassportDuplicate((Context)ctx, (String)idCardNumber, (String)passportNumber, (String)personId, null, null, (boolean)false, null);
    }

    @Deprecated
    private void checkIdCardNumber(Context ctx, PersonInfo pInfo, String idCardNumber) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)idCardNumber)) {
            IRowSet rowSet;
            idCardNumber = IDCardCommonUtil.upperIdCardNo((String)idCardNumber);
            String _idCardNumber = null;
            String hrOrgUnit = null;
            if (pInfo.getHrOrgUnit() == null) {
                if (pInfo.get("PositionList") != null) {
                    hrOrgUnit = this._getPositionHROrgUnitID(ctx, this.getPrimaryPositionId((PositionMemberCollection)pInfo.get("PositionList")));
                } else if (pInfo.get("position") != null) {
                    hrOrgUnit = this._getPersonIDHROrgUnitID(ctx, pInfo.getId().toString());
                }
            } else {
                hrOrgUnit = pInfo.getHrOrgUnit().getId().toString();
            }
            boolean isCheckIDCard18To15 = false;
            isCheckIDCard18To15 = hrOrgUnit == null ? HRParamUtil.getParamOfHR((Context)ctx, (String)"IsCheckIDCardNO18To15", null) : HRParamUtil.getParamOfHR((Context)ctx, (String)"IsCheckIDCardNO18To15", (String)hrOrgUnit);
            _idCardNumber = !isCheckIDCard18To15 ? idCardNumber : (idCardNumber.length() == 15 ? IDCardCommonUtil.IDCardNO15To18((String)idCardNumber) : IDCardCommonUtil.IDCardNO18To15((String)idCardNumber));
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID, FNumber FROM T_BD_Person WHERE ");
            sql.append("(UPPER(FIDCardNO) = ? OR UPPER(FIDCardNO) = ?)");
            if (pInfo.getId() != null) {
                sql.append(" AND FID <> '" + pInfo.getId() + "'");
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{idCardNumber.toUpperCase(), _idCardNumber.toUpperCase()})) != null && rowSet.size() > 0) {
                StringBuffer sb = null;
                try {
                    while (rowSet.next()) {
                        if (sb == null) {
                            sb = new StringBuffer();
                        } else {
                            sb.append(", ");
                        }
                        String personId = rowSet.getString("FID");
                        String personNumber = rowSet.getString("FNumber");
                        PositionInfo position = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(BOSUuid.read((String)personId));
                        if (position != null) {
                            sb.append(position.getAdminOrgUnit().getDisplayName() + ResourceBase.getString((String)(personIDCardNo + "BelowEmployee"), (Locale)ctx.getLocale()) + personNumber);
                            continue;
                        }
                        sb.append(ResourceBase.getString((String)(personIDCardNo + "NoPositionEmployee"), (Locale)ctx.getLocale()) + personNumber);
                    }
                    throw new EmployeeException(EmployeeException.EMPLOYEE_ONLY, new Object[]{pInfo.getName(), sb == null ? "" : sb.toString()});
                }
                catch (SQLException sqlExption) {
                    throw new BOSException("sql execute exception: " + sql, (Throwable)sqlExption);
                }
            }
        }
    }

    private String _getPersonIDHROrgUnitID(Context ctx, String personid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FToUnitID FROM T_HR_PersonPosition pp ");
        sql.append("INNER JOIN T_ORG_UnitRelation  ON (pp.FPersonDep=T_ORG_UnitRelation.FFromUnitID AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5')");
        sql.append("WHERE  pp.FpersonID ='");
        sql.append(personid);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected IObjectPK _personAddNew(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        PersonInfo pInfo = (PersonInfo)personInfo;
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)pInfo.getName())) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        String isFromSHROPT = (String)personInfo.get("IS_FROM_SHR_OPT_CURD");
        if (!StringUtils.isEmpty((String)isFromSHROPT) && "true".equals(isFromSHROPT)) {
            this._checkPersonValid(ctx, pInfo, pInfo.getIdCardNO(), pInfo.getPassportNO());
        } else {
            this.checkIsOrgStratSHR(ctx, pInfo);
        }
        PersonPositionInfo posInfo = null;
        posInfo = pInfo.get("personPosition") != null ? (PersonPositionInfo)pInfo.get("personPosition") : new PersonPositionInfo();
        this._checkPersonPlan(ctx, pInfo, posInfo.getPrimaryPosition());
        IPersonPhoto iPhoto = PersonPhotoFactory.getLocalInstance(ctx);
        IObjectPK pk = iPerson.addnew((CoreBaseInfo)pInfo);
        pInfo.setId(BOSUuid.read((String)pk.toString()));
        PersonPhotoInfo photoInfo = (PersonPhotoInfo)pInfo.get("photoInfo");
        if (photoInfo != null) {
            photoInfo.setPerson(pInfo);
            iPhoto.addnew(photoInfo);
        }
        IPersonCmp iPersonCmp = PersonCmpFactory.getLocalInstance(ctx);
        PersonCmpInfo cmpInfo = new PersonCmpInfo();
        cmpInfo.setIsPayPerson(false);
        cmpInfo.setIsSociety(false);
        cmpInfo.setPerson(pInfo);
        iPersonCmp.addnew((CoreBaseInfo)cmpInfo);
        IPersonPosition iPos = PersonPositionFactory.getLocalInstance(ctx);
        posInfo.setPerson(pInfo);
        if (pInfo.get("JobGrade") != null) {
            posInfo.setJobGrade((JobGradeInfo)pInfo.get("JobGrade"));
        }
        if (pInfo.get("FExtWorkTime") != null) {
            posInfo.setExtWorkTime(new BigDecimal((String)pInfo.get("FExtWorkTime")));
        }
        if (pInfo.get("FLenOfActualService") != null) {
            posInfo.setLenOfActualService(new BigDecimal((String)pInfo.get("FLenOfActualService")));
        }
        PersonPositionCollection ppColl = null;
        ppColl = iPos.getPersonPositionCollection("select * where person.id = '" + pk.toString() + "'");
        if (ppColl.size() > 0) {
            posInfo.setId(ppColl.get(0).getId());
            posInfo.setPersonDep(ppColl.get(0).getPersonDep());
            posInfo.setPrimaryPosition(ppColl.get(0).getPrimaryPosition());
            iPos.update((IObjectPK)new ObjectUuidPK(posInfo.getId()), posInfo);
        } else {
            iPos.addnew(posInfo);
        }
        return pk;
    }

    private void checkIsOrgStratSHR(Context ctx, PersonInfo pInfo) throws EASBizException, BOSException {
        PositionMemberCollection pmColl = (PositionMemberCollection)pInfo.get("positionlist");
        if (null != pmColl) {
            for (int i = 0; i < pmColl.size(); ++i) {
                PositionMemberInfo pmInfo = pmColl.get(i);
                PositionInfo posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(pmInfo.getPosition().getId()));
                AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(posInfo.getAdminOrgUnit().getId()));
                if (!orgInfo.isIsStartSHR()) continue;
                throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.OPEN_SHR_ORG)));
            }
        }
    }

    public void check18Verify(String str18No, PersonInfo pInfo) throws EmployeeException {
        int iS = 0;
        int[] iW = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        String LastCode = "10X98765432";
        String strCardNo = str18No.substring(0, 17);
        for (int i = 0; i <= 16; ++i) {
            iS += Integer.parseInt(strCardNo.substring(i, i + 1)) * iW[i];
        }
        int iY = iS % 11;
        if (!LastCode.substring(iY, iY + 1).equals(str18No.substring(17, 18))) {
            throw new EmployeeException(EmployeeException.CARDNO_NOT_RIGHT, new Object[]{pInfo.getName()});
        }
    }

    @Override
    protected void _personUpdate(Context ctx, IObjectPK iobjValue, IObjectValue personInfo) throws BOSException, EASBizException {
        PersonInfo pInfo = (PersonInfo)personInfo;
        if (StringUtils.isEmpty((String)pInfo.getName())) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        String isFromSHROPT = (String)personInfo.get("IS_FROM_SHR_OPT_CURD");
        if (!StringUtils.isEmpty((String)isFromSHROPT) && "true".equals(isFromSHROPT)) {
            this._checkPersonValid(ctx, pInfo, pInfo.getIdCardNO(), pInfo.getPassportNO());
        } else {
            this.checkIsOrgStratSHR(ctx, pInfo);
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        IPersonPhoto iPhoto = PersonPhotoFactory.getLocalInstance(ctx);
        iPerson.update((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()), (CoreBaseInfo)pInfo);
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance(ctx);
        PersonPositionInfo ppInfo = null;
        PersonPositionCollection ppColl = null;
        ppColl = ipp.getPersonPositionCollection("select * where person.id = '" + pInfo.getId().toString() + "'");
        if (ppColl.size() > 0) {
            ppInfo = ppColl.get(0);
            boolean isNeedUpdatePersonPosition = false;
            boolean valNeedUpdate = false;
            if (pInfo.get("isEnroll") != null) {
                ppInfo.setIsEnrollAgain((Boolean)pInfo.get("isEnroll"));
                isNeedUpdatePersonPosition = true;
            }
            if (pInfo.get("personPosition") != null) {
                valNeedUpdate = this.copyPersonPositionInfo(pInfo, ppInfo);
            }
            if (isNeedUpdatePersonPosition || valNeedUpdate) {
                ipp.update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), ppInfo);
            }
        } else {
            ppInfo = new PersonPositionInfo();
            ppInfo.setPerson(pInfo);
            if (pInfo.get("isEnroll") != null) {
                ppInfo.setIsEnrollAgain((Boolean)pInfo.get("isEnroll"));
            }
            if (pInfo.get("personPosition") != null) {
                ppInfo.setEnterDate(((PersonPositionInfo)pInfo.get("personPosition")).getEnterDate());
                ppInfo.setPersonDep(((PersonPositionInfo)pInfo.get("personPosition")).getPersonDep());
                ppInfo.setGkAdmin(((PersonPositionInfo)pInfo.get("personPosition")).getGkAdmin());
                ppInfo.setJobStartDate(((PersonPositionInfo)pInfo.get("personPosition")).getJobStartDate());
            }
            if (pInfo.get("JobGrade") != null) {
                ppInfo.setJobGrade((JobGradeInfo)pInfo.get("JobGrade"));
            }
            if (pInfo.get("FWorkTime") != null) {
                ppInfo.setLenOfActualService(new BigDecimal((String)pInfo.get("FWorkTime")));
            }
            if (pInfo.get("FExtWorkTime") != null) {
                ppInfo.setLenOfActualService(new BigDecimal((String)pInfo.get("FExtWorkTime")));
            }
            if (pInfo.get("FLenOfActualService") != null) {
                ppInfo.setLenOfActualService(new BigDecimal((String)pInfo.get("FLenOfActualService")));
            }
            ipp.addnew(ppInfo);
        }
        PersonPhotoInfo photoInfo = (PersonPhotoInfo)pInfo.get("photoInfo");
        if (pInfo.get("photoInfo") != null && !((String)photoInfo.get("IS_UPDATE_PHOTO")).equals("FALSE")) {
            photoInfo.setPerson(pInfo);
            DbUtil.execute((Context)ctx, (String)("Delete from t_hr_personphoto where fpersonid='" + pInfo.getId().toString() + "'"));
            iPhoto.addnew(photoInfo);
        }
        if (pInfo.get("isEnroll") != null && Boolean.valueOf(pInfo.get("isEnroll").toString()).booleanValue()) {
            IPersonEnrollHistory ipEnroll = PersonEnrollHistoryFactory.getLocalInstance(ctx);
            PersonEnrollHistoryInfo pnhInfo = new PersonEnrollHistoryInfo();
            if (ppInfo != null) {
                pnhInfo.setJoinDate(ppInfo.getJoinDate());
                pnhInfo.setJoinGroupDate(ppInfo.getJoinGroupDate());
            }
            pnhInfo.setPerson(pInfo);
            pnhInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            ipEnroll.addnew((CoreBaseInfo)pnhInfo);
        }
    }

    @Override
    protected void _personDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        iPerson.delete(pk);
    }

    private IRowSet _getPersonStrucRowSet(Context ctx, String strType, ReportOrgQueryInfo reportOrgInfo, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears, String personID) throws BOSException, EASBizException {
        StringBuffer strBuffer = null;
        strBuffer = this.getQuerySQL(ctx, strType, reportOrgInfo, false, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears, personID);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        return rowSet;
    }

    private StringBuffer getCommonSQL(Context ctx, ReportOrgQueryInfo reportOrgInfo, String personTypeID) throws EASBizException, BOSException {
        this.personTypeSign = personTypeID;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" FROM T_BD_Person AS PERSON ");
        if (personTypeID == null) {
            strBuffer.append(" INNER JOIN T_HR_BDEmployeeType AS ET ON PERSON.FEmployeeTypeID=ET.FID");
        } else {
            strBuffer.append(" INNER JOIN T_HR_BDEmployeeType AS ET ON PERSON.FEmployeeTypeID in (" + personTypeID + ")");
        }
        String[] personTypeIDs = null;
        boolean nullPosition = false;
        if (personTypeID != null) {
            personTypeIDs = CtrlUtil.Str.splitString((String)personTypeID, (String)",");
            IEmployeeType iEmployeeType = EmployeeTypeFactory.getLocalInstance((Context)ctx);
            int count = personTypeIDs.length;
            for (int i = 0; i < count; ++i) {
                String[] personTypeIDss = CtrlUtil.Str.splitString((String)personTypeIDs[i], (String)"'");
                if (iEmployeeType.getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(personTypeIDss[1])).getInService().getValue() == 1) continue;
                nullPosition = true;
                this.nullPositionSign = true;
            }
        }
        if (nullPosition || personTypeID == null) {
            strBuffer.append(" INNER JOIN T_HR_PersonPosition AS PPn ");
            strBuffer.append(" ON PERSON.FID = PPn.FPersonID ");
            strBuffer.append(" INNER JOIN T_ORG_Admin AS STRUCTURE ");
            strBuffer.append(" ON PPn.FPersonDep = STRUCTURE.FID ");
        } else {
            strBuffer.append(" INNER JOIN T_ORG_PositionMember AS PM ");
            strBuffer.append(" ON PERSON.FID = PM.FPersonID and PM.FisPrimary=1 ");
            strBuffer.append(" INNER JOIN T_ORG_Position AS POSITION ");
            strBuffer.append(" ON PM.FPositionID = POSITION.FID ");
            strBuffer.append(" INNER JOIN T_ORG_Admin AS STRUCTURE ");
            strBuffer.append(" ON POSITION.FAdminOrgUnitID = STRUCTURE.FID ");
        }
        strBuffer.append(this.getConditionSQL(reportOrgInfo));
        return strBuffer;
    }

    private StringBuffer getConditionSQL(ReportOrgQueryInfo reportOrgInfo) {
        String oneOrgSql = this.getLongNumberWhereSql("STRUCTURE.FLongNumber", reportOrgInfo);
        String moreOrgSql = OrgStringUtil.getOrgsSqlIncludeChild((String)"STRUCTURE.FID", (String)"STRUCTURE.FLongNumber", (Object[])reportOrgInfo.getOrgInfos());
        StringBuffer strBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)oneOrgSql)) {
            strBuffer.append(" and ( " + oneOrgSql + " )");
        } else if (moreOrgSql != null) {
            strBuffer.append(" and ( " + moreOrgSql + " )");
        }
        return strBuffer;
    }

    private String getLongNumberWhereSql(String fieldName, ReportOrgQueryInfo reportOrgInfo) {
        String sql = null;
        if (reportOrgInfo.getOrgInfo() != null && reportOrgInfo.getOrgInfo().getLongNumber() != null) {
            String longNumber = reportOrgInfo.getOrgInfo().getLongNumber();
            sql = fieldName + " like '" + longNumber + "!%' OR " + fieldName + " = '" + longNumber + "'";
        }
        return sql;
    }

    private String getOrgIdsWhereSql(String fieldName, ReportOrgQueryInfo reportOrgInfo) {
        StringBuffer sql = new StringBuffer();
        Object[] orgs = reportOrgInfo.getOrgInfos();
        if (orgs != null) {
            sql.append(fieldName + " in (" + OrgStringUtil.getOrgIdsSql((Object[])orgs) + ")");
        }
        return sql.toString();
    }

    private String getSelectString(String strName) {
        String strSelect = "";
        if (strName.equals("chkAge")) {
            strSelect = "ISNULL(((YEAR(GETDATE()) - YEAR(PERSON.FBirthday)) - CASE  WHEN ((MONTH(PERSON.FBirthday) - MONTH(GETDATE())) > 0) THEN 1 WHEN ((MONTH(PERSON.FBirthday) - MONTH(GETDATE())) < 0) THEN 0 WHEN ((DAYOFMONTH(PERSON.FBirthday) - DAYOFMONTH(GETDATE())) <= 0) THEN 0 ELSE 1 END), 0) AS SNUMBER";
        } else if (strName.equals("chkPosition")) {
            strSelect = " JOB.FID AS SNUMBER ";
        } else if (strName.equals("chkTechnical")) {
            strSelect = " TECHNICALPOST.FID AS SNUMBER ";
        } else if (strName.equals("chkTeach")) {
            strSelect = " DIPLOMA.FID AS SNUMBER ";
        } else if (strName.equals("chkGroupYears")) {
            strSelect = this.getYearStr("PERSONPOS.FJoinGroupDate") + " AS SNUMBER ";
        } else if (strName.equals("chkCompanyYears")) {
            strSelect = this.getYearStr("PERSONPOS.FJoinDate") + " AS SNUMBER ";
        } else if (strName.equals("chkSex")) {
            strSelect = " PERSON.FGender AS SNUMBER ";
        } else if (strName.equals("chkWed")) {
            strSelect = " WED.FID AS SNUMBER ";
        } else if (strName.equals("chkEmpClassify")) {
            strSelect = " EmpClassify.FID AS SNUMBER ";
        } else if (strName.equals("chkJobGrade")) {
            strSelect = " JobGrade.FID AS SNUMBER ";
        } else if (strName.equals("chkJobLevel")) {
            strSelect = " JobLevel.FID AS SNUMBER ";
        } else if (strName.equals("chkPositionType")) {
            strSelect = " JOBCATEGORY.FID AS SNUMBER ";
        } else if (strName.equals("chkTechType")) {
            strSelect = "TECHTYPE.FID AS SNUMBER";
        } else if (strName.equals("chkTechLevel")) {
            strSelect = "TECHLEVEL.FID AS SNUMBER";
        }
        return strSelect;
    }

    private String getYearStr(String field) {
        StringBuffer buf = new StringBuffer();
        buf.append(" (((Year(add_days(now(),1)) - Year(Field_Name))*12 ");
        buf.append("+ CASE WHEN DayOfMonth(add_days(now(),1)) - DayOfMonth(Field_Name) < 0 ");
        buf.append("THEN (Month(add_days(now(),1)) - Month(Field_Name))-1 ");
        buf.append("ELSE (Month(add_days(now(),1)) - Month(Field_Name)) END ) / 12) ");
        return buf.toString().replaceAll("Field_Name", field);
    }

    private StringBuffer getAloneStringSQL(Context ctx, String strName, boolean isTotal, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears) throws BOSException {
        StringBuffer strBuffer = new StringBuffer();
        if (strName.equals("chkAge")) {
            int iMin = this._getMinAgeSegment(ctx, arrayCustomAge);
            int iMax = this._getMaxAgeSegment(ctx, arrayCustomAge);
            strBuffer.append(" AND PERSON.FBirthDay IS NOT NULL  ");
            strBuffer.append("AND (YEAR(GetDate())-YEAR(PERSON.FBirthday))>=" + iMin + " AND (YEAR(GetDate())-YEAR(PERSON.FBirthday))<=" + iMax);
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" PERSON.FBIRTHDAY ");
            }
        } else if (strName.equals("chkPosition")) {
            if (this.nullPositionSign || this.personTypeSign == null) {
                strBuffer.append(" INNER JOIN T_ORG_PositionMember AS PM ");
                strBuffer.append(" ON PERSON.FID = PM.FPersonID and PM.FisPrimary=1 ");
                strBuffer.append(" INNER JOIN T_ORG_Position AS POSITION ");
                strBuffer.append(" ON PM.FPositionID = POSITION.FID ");
            }
            strBuffer.append(" INNER JOIN T_ORG_Job AS JOB ");
            strBuffer.append(" ON POSITION.FJobID = JOB.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" JOB.FID ");
            }
        } else if (strName.equals("chkTechnical")) {
            strBuffer.append(" INNER JOIN T_HR_BDTechnicalPost AS TECHNICALPOST ");
            strBuffer.append(" ON PERSON.FHighestTechPostID = TECHNICALPOST.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" TECHNICALPOST.FID ");
            }
        } else if (strName.equals("chkTeach")) {
            strBuffer.append(" INNER JOIN T_BD_HRDiploma AS DIPLOMA ");
            strBuffer.append(" ON PERSON.FHighestDegreeID = DIPLOMA.FID");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" DIPLOMA.FID ");
            }
        } else if (strName.equals("chkGroupYears")) {
            int iMin = this.getMinFromArrayList(arrayGroupServiceYears);
            int iMax = this.getMaxFromArrayList(arrayGroupServiceYears);
            strBuffer.append(" INNER JOIN T_HR_PersonPosition PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            strBuffer.append(" AND " + this.getYearStr("PERSONPOS.FJoinGroupDate") + " >=" + iMin + " AND " + this.getYearStr("PERSONPOS.FJoinGroupDate") + " <" + iMax);
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(this.getYearStr("PERSONPOS.FJoinGroupDate"));
            }
        } else if (strName.equals("chkCompanyYears")) {
            int iMin = this.getMinFromArrayList(arrayCompanyServiceYears);
            int iMax = this.getMaxFromArrayList(arrayCompanyServiceYears);
            strBuffer.append(" INNER JOIN T_HR_PersonPosition PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            strBuffer.append(" AND " + this.getYearStr("PERSONPOS.FJoinDate") + " >=" + iMin + " AND " + this.getYearStr("PERSONPOS.FJoinDate") + " <" + iMax);
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(this.getYearStr("PERSONPOS.FJoinDate"));
            }
        } else if (strName.equals("chkSex")) {
            strBuffer.append(" AND PERSON.FGender IS NOT NULL");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" PERSON.FGender ");
            }
        } else if (strName.equals("chkWed")) {
            strBuffer.append(" INNER JOIN T_BD_HRWed AS WED ");
            strBuffer.append(" ON PERSON.FWedID = WED.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" WED.FID ");
            }
        } else if (strName.equals("chkEmpClassify")) {
            strBuffer.append(" INNER JOIN T_HR_EmployeeClassify AS EmpClassify ");
            strBuffer.append(" ON PERSON.FEmployeeClassifyID = EmpClassify.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" EmpClassify.FID ");
            }
        } else if (strName.equals("chkJobGrade")) {
            strBuffer.append(" INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID=PP.FPersonID ");
            strBuffer.append(" INNER JOIN T_HR_JobGrade AS JobGrade ");
            strBuffer.append(" ON PP.FJobGrade = JobGrade.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" JobGrade.FID ");
            }
        } else if (strName.equals("chkJobLevel")) {
            strBuffer.append(" INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID=PP.FPersonID ");
            strBuffer.append(" INNER JOIN T_HR_JobLevel AS JobLevel ");
            strBuffer.append(" ON PP.FJobLevelID = JobLevel.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" JobLevel.FID ");
            }
        } else if (strName.equals("chkPositionType")) {
            if (this.nullPositionSign || this.personTypeSign == null) {
                strBuffer.append(" INNER JOIN T_ORG_PositionMember AS PM ");
                strBuffer.append(" ON PERSON.FID = PM.FPersonID and PM.FisPrimary=1 ");
                strBuffer.append(" INNER JOIN T_ORG_Position AS POSITION ");
                strBuffer.append(" ON PM.FPositionID = POSITION.FID ");
            }
            strBuffer.append(" INNER JOIN T_ORG_Job AS JOB ");
            strBuffer.append(" ON POSITION.FJobID = JOB.FID ");
            strBuffer.append(" INNER JOIN T_ORG_JobCategory AS JOBCATEGORY ");
            strBuffer.append(" ON JOB.FJobCategoryID = JOBCATEGORY.FID ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" JOBCATEGORY.FID ");
            }
        } else if (strName.equals("chkTechType")) {
            strBuffer.append(" INNER JOIN T_HR_PersonTechPost AS PERSONTECH  ");
            strBuffer.append(" ON PERSON.FID = PERSONTECH.FPersonID AND PERSONTECH.FIsHighTechnical=1  ");
            strBuffer.append(" INNER JOIN T_HR_BDTechnicalPost AS TECHNICALPOST ");
            strBuffer.append(" ON PERSONTECH.FTechnicalPostID = TECHNICALPOST.FID  INNER JOIN T_HR_BDTechPostType AS TECHTYPE ON TECHNICALPOST.FCategoryID=TECHTYPE.FID  ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" TECHTYPE.FID ");
            }
        } else if (strName.equals("chkTechLevel")) {
            strBuffer.append(" INNER JOIN T_HR_PersonTechPost AS PERSONTECH  ");
            strBuffer.append(" ON PERSON.FID = PERSONTECH.FPersonID AND PERSONTECH.FIsHighTechnical=1  ");
            strBuffer.append(" INNER JOIN T_HR_BDTechnicalPost AS TECHNICALPOST ");
            strBuffer.append(" ON PERSONTECH.FTechnicalPostID = TECHNICALPOST.FID  INNER JOIN T_HR_BDTechPostLevel AS TECHLEVEL ON TECHNICALPOST.FLevelID=TECHLEVEL.FID  ");
            strBuffer.append(" GROUP BY ");
            if (isTotal) {
                strBuffer.append(" STRUCTURE.FLongNumber ");
            } else {
                strBuffer.append(" STRUCTURE.FLongNumber, ");
                strBuffer.append(" TECHLEVEL.FID ");
            }
        }
        return strBuffer;
    }

    private StringBuffer getQuerySQL(Context ctx, String strType, ReportOrgQueryInfo reportOrgInfo, boolean isTotal, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears, String personID) throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        if (isTotal) {
            strBuffer.append(" SELECT COUNT(distinct PERSON.FID) AS PERSONCOUNTS,STRUCTURE.FLongNumber AS LONGNUMBER");
        } else {
            strBuffer.append(" SELECT COUNT(distinct PERSON.FID) AS PERSONCOUNTS,STRUCTURE.FLongNumber AS LONGNUMBER, ");
            strBuffer.append(this.getSelectString(strType));
        }
        strBuffer.append(this.getCommonSQL(ctx, reportOrgInfo, personID));
        strBuffer.append(this.getAloneStringSQL(ctx, strType, isTotal, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears));
        return strBuffer;
    }

    private int _getMinAgeSegment(Context ctx, ArrayList arrayCustomAge) throws BOSException {
        if (arrayCustomAge != null && arrayCustomAge.size() != 0) {
            return this.getMinFromArrayList(arrayCustomAge);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select isnull(min(FStartAge),0) as minAge from t_hr_bdagesegment");
        if (rowSet.size() > 0) {
            try {
                rowSet.next();
                return rowSet.getInt("minAge");
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }

    private int _getMaxAgeSegment(Context ctx, ArrayList arrayCustomAge) throws BOSException {
        if (arrayCustomAge != null && arrayCustomAge.size() != 0) {
            return this.getMaxFromArrayList(arrayCustomAge);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select isnull(max(FEndAge),0) as maxAge from t_hr_bdagesegment");
        if (rowSet.size() > 0) {
            try {
                rowSet.next();
                return rowSet.getInt("maxAge");
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getMinFromArrayList(ArrayList arr) {
        int min = 0;
        for (int i = 0; i < arr.size(); ++i) {
            String str = (String)arr.get(i);
            String[] strList = str.split("-");
            String strMin = strList[0];
            if (i == 0) {
                min = Integer.parseInt(strMin);
            }
            if (Integer.parseInt(strMin) >= min) continue;
            min = Integer.parseInt(strMin);
        }
        return min;
    }

    private int getMaxFromArrayList(ArrayList arr) {
        int max = 0;
        for (int i = 0; i < arr.size(); ++i) {
            String str = (String)arr.get(i);
            String[] strList = str.split("-");
            String strMax = strList[1];
            if (i == 0) {
                max = Integer.parseInt(strMax);
            }
            if (Integer.parseInt(strMax) <= max) continue;
            max = Integer.parseInt(strMax);
        }
        return max;
    }

    @Override
    public HashMap getPersonCountsByProp(Context ctx, ReportOrgQueryInfo reportOrgInfo, ArrayList arrayParams, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears, boolean isDefault, String personTypeID) throws BOSException, EASBizException {
        try {
            ServiceContext svcCtx = this.createServiceContext(new MetaDataPK("fdc8ddfa-0100-1000-e000-0003c0a813cb"), new Object[]{ctx, reportOrgInfo, arrayParams, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears, new Boolean(isDefault)});
            this.invokeServiceBefore(svcCtx);
            HashMap retValue = this._getPersonCountsByProp(ctx, reportOrgInfo, arrayParams, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears, isDefault, personTypeID);
            svcCtx.setMethodReturnValue((Object)retValue);
            this.invokeServiceAfter(svcCtx);
            HashMap hashMap = retValue;
            return hashMap;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex0) {
            throw ex0;
        }
        finally {
            super.cleanUpServiceState();
        }
    }

    @Override
    protected HashMap _getPersonCountsByProp(Context ctx, ReportOrgQueryInfo reportOrgInfo, ArrayList arrayParams, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears, boolean isDefault, String personTypeID) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        if (arrayParams == null || arrayParams.size() == 0) {
            return null;
        }
        for (int i = 0; i < arrayParams.size(); ++i) {
            String str = (String)arrayParams.get(i);
            String[] strList = str.split("-@@-");
            String strName = strList[0];
            IRowSet rows = this._getPersonStrucRowSet(ctx, strName.trim(), reportOrgInfo, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears, personTypeID);
            try {
                if (strName.trim().equals("chkSex")) {
                    this.fillMapByRowSet(ctx, map, rows, strName, true, false, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears);
                } else {
                    this.fillMapByRowSet(ctx, map, rows, strName, false, false, arrayCustomAge, arrayGroupServiceYears, arrayCompanyServiceYears);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.fillNullData(ctx, map, strName, reportOrgInfo, personTypeID);
        }
        this.collectPersonData(ctx, map, reportOrgInfo);
        return map;
    }

    private void fillNullData(Context ctx, HashMap map, String strType, ReportOrgQueryInfo reportOrgInfo, String personTypeID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COUNT(distinct PERSON.FID) AS PERSONCOUNTS,STRUCTURE.FLongNumber AS LONGNUMBER");
        sql.append(this.getCommonSQL(ctx, reportOrgInfo, personTypeID));
        if (strType.equals("chkAge")) {
            sql.append("WHERE PERSON.FBIRTHDAY IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkPosition")) {
            if (this.nullPositionSign || this.personTypeSign == null) {
                sql.append(" LEFT JOIN T_ORG_PositionMember AS PM ");
                sql.append(" ON PERSON.FID = PM.FPersonID and PM.FisPrimary=1 ");
                sql.append(" LEFT JOIN T_ORG_Position AS POSITION ");
                sql.append(" ON PM.FPositionID = POSITION.FID ");
            }
            sql.append(" WHERE POSITION.FJobID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkTechnical")) {
            sql.append(" WHERE PERSON.FHighestTechPostID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkTeach")) {
            sql.append(" WHERE PERSON.FHighestDegreeID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkGroupYears")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            sql.append(" WHERE PERSONPOS.FJoinGroupDate IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkCompanyYears")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            sql.append(" WHERE PERSONPOS.FJoinDate IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkSex")) {
            sql.append(" WHERE PERSON.FGender IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkWed")) {
            sql.append(" WHERE PERSON.FWedID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkEmpClassify")) {
            sql.append(" WHERE PERSON.FEmployeeClassifyID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkJobGrade")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            sql.append(" WHERE PERSONPOS.FJobGrade IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkJobLevel")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOS ON PERSON.FID = PERSONPOS.FPersonID ");
            sql.append(" WHERE PERSONPOS.FJobLevelID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkPositionType")) {
            if (this.nullPositionSign || this.personTypeSign == null) {
                sql.append(" LEFT JOIN T_ORG_PositionMember AS PM ");
                sql.append(" ON PERSON.FID = PM.FPersonID and PM.FisPrimary=1 ");
                sql.append(" LEFT JOIN T_ORG_Position AS POSITION ");
                sql.append(" ON PM.FPositionID = POSITION.FID ");
            }
            sql.append(" LEFT OUTER JOIN T_ORG_Job AS JOB ");
            sql.append(" ON POSITION.FJobID = JOB.FID ");
            sql.append(" WHERE JOB.FJobCategoryID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkTechType")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonTechPost AS PERSONTECH  ");
            sql.append(" ON PERSON.FID = PERSONTECH.FPersonID AND PERSONTECH.FIsHighTechnical=1  ");
            sql.append(" LEFT OUTER JOIN T_HR_BDTechnicalPost AS TECHNICALPOST ");
            sql.append(" ON PERSONTECH.FTechnicalPostID = TECHNICALPOST.FID  ");
            sql.append(" WHERE TECHNICALPOST.FCategoryID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        } else if (strType.equals("chkTechLevel")) {
            sql.append(" LEFT OUTER JOIN T_HR_PersonTechPost AS PERSONTECH  ");
            sql.append(" ON PERSON.FID = PERSONTECH.FPersonID AND PERSONTECH.FIsHighTechnical=1  ");
            sql.append(" LEFT OUTER JOIN T_HR_BDTechnicalPost AS TECHNICALPOST ");
            sql.append(" ON PERSONTECH.FTechnicalPostID = TECHNICALPOST.FID  ");
            sql.append(" WHERE TECHNICALPOST.FLevelID IS NULL ");
            sql.append(" GROUP BY ");
            sql.append(" STRUCTURE.FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String strSign = "$@";
            while (rows.next()) {
                map.put("NULL" + strType + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void collectPersonData(Context ctx, HashMap map, ReportOrgQueryInfo reportOrgInfo) throws BOSException, EASBizException {
        ArrayList<String> keyList1 = new ArrayList<String>();
        ArrayList<String> keyList2 = new ArrayList<String>();
        String param = null;
        String[] keys = null;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            param = iter.next().toString();
            keys = StringUtils.split((String)param, (String)"$@");
            if (!keyList1.contains(keys[0])) {
                keyList1.add(keys[0]);
            }
            if (keyList2.contains(keys[1])) continue;
            keyList2.add(keys[1]);
        }
        String oneOrgSql = this.getLongNumberWhereSql("FLongNumber", reportOrgInfo);
        String moreOrgSql = OrgStringUtil.getOrgsSqlIncludeChild((String)"FID", (String)"FLongNumber", (Object[])reportOrgInfo.getOrgInfos());
        String whereSql = StringUtils.isEmpty((String)oneOrgSql) ? moreOrgSql : oneOrgSql;
        whereSql = StringUtils.isEmpty((String)whereSql) ? "" : " WHERE " + whereSql;
        String sql = "SELECT FID,FLongNumber,FParentID FROM T_ORG_Admin " + whereSql + " ORDER BY FLongNumber";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rows.next()) {
                if (keyList2.contains(rows.getString("FLongNumber"))) continue;
                keyList2.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < keyList1.size(); ++i) {
            for (int t = 0; t < keyList2.size(); ++t) {
                param = keyList1.get(i).toString() + "$@" + keyList2.get(t).toString();
                if (map.get(param) != null) continue;
                map.put(param, 0);
            }
        }
        TreeData treeData = this.buildTreeData(rows);
        this.sumTreeNodeData(treeData, keyList1, map);
    }

    private void fillMapByRowSet2(HashMap map, IRowSet rows, String strName, ArrayList list) throws SQLException {
        String strSign = "$@";
        String param = null;
        String[] strKey = null;
        int sum = 0;
        rows.beforeFirst();
        while (rows.next()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                param = list.get(i).toString();
                strKey = param.split("-");
                if (rows.getInt("SNUMBER") < Integer.parseInt(strKey[0]) || rows.getInt("SNUMBER") >= Integer.parseInt(strKey[1])) continue;
                Object temp = map.get(strName + param + strSign + rows.getString("LONGNUMBER"));
                if (temp != null) {
                    sum = Integer.valueOf(temp.toString());
                    map.put(strName + param + strSign + rows.getString("LONGNUMBER"), sum += rows.getInt("PERSONCOUNTS"));
                    continue;
                }
                map.put(strName + param + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
            }
        }
    }

    private void fillMapByRowSet3(HashMap map, IRowSet rows, String strName, ArrayList list) throws SQLException {
        String strSign = "$@";
        String param = null;
        String[] strKey = null;
        int sum = 0;
        rows.beforeFirst();
        while (rows.next()) {
            if (list == null) {
                return;
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                param = list.get(i).toString();
                strKey = param.split("-");
                if (rows.getInt("SNUMBER") < Integer.parseInt(strKey[0]) || rows.getInt("SNUMBER") > Integer.parseInt(strKey[1])) continue;
                Object temp = map.get(strName + param + strSign + rows.getString("LONGNUMBER"));
                if (temp != null) {
                    sum = Integer.valueOf(temp.toString());
                    map.put(strName + param + strSign + rows.getString("LONGNUMBER"), sum += rows.getInt("PERSONCOUNTS"));
                    continue;
                }
                map.put(strName + param + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
            }
        }
    }

    private void fillMapByRowSet(Context ctx, HashMap map, IRowSet rows, String strName, boolean isSex, boolean isTotal, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears) throws BOSException, EASBizException, SQLException {
        String strNumber = null;
        String strSign = "$@";
        rows.beforeFirst();
        if (!isTotal) {
            if (strName.equals("chkCompanyYears")) {
                this.fillMapByRowSet2(map, rows, strName, arrayCompanyServiceYears);
                return;
            }
            if (strName.equals("chkGroupYears")) {
                this.fillMapByRowSet2(map, rows, strName, arrayGroupServiceYears);
                return;
            }
            if (strName.equals("chkAge")) {
                IAgeSegment iAge;
                AgeSegmentCollection ageInfos;
                if ((arrayCustomAge == null || arrayCustomAge.size() == 0) && (ageInfos = (iAge = AgeSegmentFactory.getLocalInstance((Context)ctx)).getAgeSegmentCollection()).size() > 0) {
                    arrayCustomAge = new ArrayList<String>();
                    String param = null;
                    for (int i = 0; i < ageInfos.size(); ++i) {
                        param = Integer.toString(ageInfos.get(i).getStartAge());
                        param = param + "-" + Integer.toString(ageInfos.get(i).getEndAge());
                        arrayCustomAge.add(param);
                    }
                }
                this.fillMapByRowSet3(map, rows, strName, arrayCustomAge);
                return;
            }
        }
        while (rows.next()) {
            if (isTotal) {
                map.put("colTotal" + strName + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
                continue;
            }
            strNumber = rows.getString("SNUMBER");
            if (isSex) {
                if (rows.getString("SNUMBER") == null) continue;
                int gender = Integer.parseInt(rows.getString("SNUMBER"));
                if (gender == 1) {
                    map.put(Genders.Male.getName() + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
                    continue;
                }
                if (gender != 2) continue;
                map.put(Genders.Female.getName() + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
                continue;
            }
            map.put(strNumber + strSign + rows.getString("LONGNUMBER"), rows.getInt("PERSONCOUNTS"));
        }
    }

    @Override
    protected int _getMinAgeSegment(Context ctx) throws BOSException {
        return 0;
    }

    @Override
    protected int _getMaxAgeSegment(Context ctx) throws BOSException {
        return 0;
    }

    @Override
    protected int _getCmpPersonCounts(Context ctx) throws BOSException, EASBizException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT T_BD_Person.FID FROM T_BD_Person INNER JOIN T_HR_PersonCmp ON T_BD_Person.FID = T_HR_PersonCmp.FPersonID AND T_HR_PersonCmp.FIsPayPerson = 1 ");
        if (rowSet == null) {
            return 0;
        }
        return rowSet.size();
    }

    @Override
    protected HashMap _getPersonCmpByCurrentCU(Context ctx, String strCuId) throws BOSException, EASBizException {
        HashMap<String, PersonCmpInfo> map = new HashMap<String, PersonCmpInfo>();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.CmpPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("fullOrgUnit.id", (Object)strCuId));
        entityView.setFilter(filterInfoItem);
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        try {
            while (selectItemRowSet.next()) {
                map.put(selectItemRowSet.getString("person.id"), this.getPersonCmpInfo(selectItemRowSet));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private PersonCmpInfo getPersonCmpInfo(IRowSet selectItemRowSet) throws Exception {
        PersonCmpInfo cmpItem = new PersonCmpInfo();
        cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("id")));
        cmpItem.setIsPayPerson(selectItemRowSet.getBoolean("isPayPerson"));
        cmpItem.setIsSociety(selectItemRowSet.getBoolean("isSociety"));
        cmpItem.setAccountOne(selectItemRowSet.getString("accountOne"));
        cmpItem.setAccountOneName(selectItemRowSet.getString("accountOneName"));
        cmpItem.setAccountOne(selectItemRowSet.getString("accountTwo"));
        cmpItem.setAccountOneName(selectItemRowSet.getString("accountTwoName"));
        cmpItem.setAccountThree(selectItemRowSet.getString("accountThree"));
        cmpItem.setAccountThreeName(selectItemRowSet.getString("accountThreeName"));
        return cmpItem;
    }

    private void doBatchPersonPlanCheck(Context ctx, IObjectCollection personInfos) throws EASBizException, BOSException {
        PersonCollection pInfos = (PersonCollection)personInfos;
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        IPersonPosition ipersonPosition = PersonPositionFactory.getLocalInstance(ctx);
        PersonInfo pInfo = null;
        ArrayList<PosPerPlanInfo> addList = new ArrayList<PosPerPlanInfo>();
        ArrayList<PosPerPlanInfo> delList = new ArrayList<PosPerPlanInfo>();
        EmployeeTypeInfo newEmpType = null;
        EmployeeTypeInfo oldEmpType = null;
        PosPerPlanInfo temp = null;
        AdminOrgUnitInfo newAdmin = null;
        AdminOrgUnitInfo oldAdmin = null;
        PersonPositionInfo ppInfo = null;
        PersonPositionInfo oldPPinfo = null;
        PositionInfo positionInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("gkAdmin"));
        sic.add(new SelectorItemInfo("primaryPosition.adminOrgUnit"));
        for (int i = 0; i < pInfos.size(); ++i) {
            pInfo = pInfos.get(i);
            newEmpType = pInfo.getEmployeeType();
            ppInfo = (PersonPositionInfo)pInfo.get("personpositioninfo");
            newAdmin = ppInfo.getGkAdmin();
            positionInfo = (PositionInfo)pInfo.get("position");
            if (pInfo.getId() != null) {
                oldEmpType = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(pInfo.getId().toString())).getEmployeeType();
                oldPPinfo = ipersonPosition.getPersonPositionInfo((IObjectPK)new ObjectUuidPK(ppInfo.getId().toString()), sic);
                oldAdmin = oldPPinfo.getPrimaryPosition() != null ? oldPPinfo.getPrimaryPosition().getAdminOrgUnit() : oldPPinfo.getGkAdmin();
                temp = new PosPerPlanInfo(pInfo.getId().toString(), null, false, newEmpType);
                temp.setAdmin(newAdmin);
                temp.setPosition(positionInfo);
                addList.add(temp);
                temp = new PosPerPlanInfo(pInfo.getId().toString(), null, false, oldEmpType);
                temp.setAdmin(oldAdmin);
                temp.setPosition(positionInfo);
                delList.add(temp);
                continue;
            }
            temp = new PosPerPlanInfo(null, null, false, newEmpType);
            temp.setAdmin(newAdmin);
            temp.setPosition(positionInfo);
            addList.add(temp);
        }
        PersonPlanFactory.getLocalInstance((Context)ctx).canAddPersonBatch(addList, delList);
    }

    @Override
    protected IObjectPK[] _personBatchSubmit(Context ctx, IObjectCollection personInfos, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.doBatchPersonPlanCheck(ctx, personInfos);
        PersonCollection pInfos = (PersonCollection)personInfos;
        ArrayList<Object> arrList = new ArrayList<Object>();
        PersonInfo pInfo = null;
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        IPersonPosition iPP = PersonPositionFactory.getLocalInstance(ctx);
        IPersonCmp iPersonCmp = PersonCmpFactory.getLocalInstance(ctx);
        ISocialInsurance iSocialInsurance = SocialInsuranceFactory.getLocalInstance(ctx);
        IPersonDegree iDegree = PersonDegreeFactory.getLocalInstance(ctx);
        String strResourceURL = "com.kingdee.eas.hr.emp.EmployeeInputResource";
        for (int i = 0; i < pInfos.size(); ++i) {
            pInfo = pInfos.get(i);
            try {
                this._checkPersonValid(ctx, pInfo, pInfo.getIdCardNO(), pInfo.getPassportNO());
                if (pInfo.getId() != null) {
                    iPerson.update((IObjectPK)new ObjectUuidPK(pInfo.getId()), (CoreBaseInfo)pInfo);
                    if (pInfo.get("personPositionInfo") != null) {
                        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPositionInfo");
                        int curYear = new Date().getYear();
                        int joinYear = 0;
                        if (ppInfo.getJobStartDate() != null) {
                            joinYear = ppInfo.getJobStartDate().getYear();
                            if (curYear - joinYear >= 0) {
                                ppInfo.setWorkTime(curYear - joinYear);
                            }
                        } else {
                            ppInfo.setWorkTime(0L);
                        }
                        ppInfo.setPerson(pInfo);
                        if (ppInfo.getId() != null) {
                            iPP.update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), ppInfo);
                        } else {
                            iPP.addnew(ppInfo);
                        }
                    }
                    if (pInfo.get("degreeInfo") != null) {
                        PersonDegreeInfo degreeInfo = (PersonDegreeInfo)pInfo.get("degreeInfo");
                        degreeInfo.setPerson(pInfo);
                        if (degreeInfo.getId() != null) {
                            iDegree.update((IObjectPK)new ObjectUuidPK(degreeInfo.getId()), degreeInfo);
                        } else {
                            iDegree.addnew(degreeInfo);
                        }
                    }
                    if (pInfo.get("cmpInfo") != null) {
                        PersonCmpInfo cmpInfo = (PersonCmpInfo)pInfo.get("cmpInfo");
                        cmpInfo.setPerson(pInfo);
                        if (cmpInfo.getId() != null) {
                            iPersonCmp.update((IObjectPK)new ObjectUuidPK(cmpInfo.getId()), (CoreBaseInfo)cmpInfo);
                        } else {
                            iPersonCmp.addnew((CoreBaseInfo)cmpInfo);
                        }
                    }
                    if (pInfo.get("socialInfo") != null) {
                        SocialInsuranceInfo socialInfo = (SocialInsuranceInfo)pInfo.get("socialInfo");
                        socialInfo.setPerson(pInfo);
                        if (socialInfo.getId() != null) {
                            iSocialInsurance.update((IObjectPK)new ObjectUuidPK(socialInfo.getId()), (CoreBaseInfo)socialInfo);
                        } else {
                            iSocialInsurance.addnew((CoreBaseInfo)socialInfo);
                        }
                    }
                    arrList.add(new ObjectUuidPK(pInfo.getId()));
                    continue;
                }
                IObjectPK pk = iPerson.addnew((CoreBaseInfo)pInfo);
                pInfo.setId(BOSUuid.read((String)pk.toString()));
                if (pInfo.get("personPositionInfo") != null) {
                    PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPositionInfo");
                    int curYear = new Date().getYear();
                    int joinYear = 0;
                    if (ppInfo.getJobStartDate() != null) {
                        joinYear = ppInfo.getJobStartDate().getYear();
                        if (curYear - joinYear >= 0) {
                            ppInfo.setWorkTime(curYear - joinYear);
                        }
                    } else {
                        ppInfo.setWorkTime(0L);
                    }
                    ppInfo.setPerson(pInfo);
                    if (iPP.exists("where person.id='" + pInfo.getId() + "'")) {
                        PersonPositionCollection ppColl = iPP.getPersonPositionCollection("where person.id='" + pInfo.getId() + "'");
                        ppInfo.setId(ppColl.get(0).getId());
                        iPP.update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), ppInfo);
                    } else {
                        iPP.addnew(ppInfo);
                    }
                }
                if (pInfo.get("degreeInfo") != null) {
                    PersonDegreeInfo degreeInfo = (PersonDegreeInfo)pInfo.get("degreeInfo");
                    degreeInfo.setPerson(pInfo);
                    iDegree.addnew(degreeInfo);
                }
                if (pInfo.get("cmpInfo") != null) {
                    PersonCmpInfo cmpInfo = (PersonCmpInfo)pInfo.get("cmpInfo");
                    cmpInfo.setPerson(pInfo);
                    iPersonCmp.addnew((CoreBaseInfo)cmpInfo);
                }
                if (pInfo.get("socialInfo") != null) {
                    SocialInsuranceInfo socialInfo = (SocialInsuranceInfo)pInfo.get("socialInfo");
                    socialInfo.setPerson(pInfo);
                    iSocialInsurance.addnew((CoreBaseInfo)socialInfo);
                }
                arrList.add(pk);
                continue;
            }
            catch (EASBizException e) {
                Object[] obj = new Object[]{pInfo.getName()};
                String indexRow = ResourceBase.getString((String)strResourceURL, (String)"EMP_BATCH_INDEX", (Locale)ctx.getLocale());
                indexRow = indexRow + " " + Integer.toString(i + 1) + " " + ResourceBase.getString((String)strResourceURL, (String)"EMP_BATCH_INDEX_ROW", (Locale)ctx.getLocale());
                NumericExceptionSubItem subItem = new NumericExceptionSubItem(e.getCode(), indexRow + e.getMessage());
                throw new EASBizException(subItem, obj);
            }
            catch (BOSException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        ObjectUuidPK[] pks = new ObjectUuidPK[arrList.size()];
        int counts = arrList.size();
        for (int i = 0; i < counts; ++i) {
            pks[i] = (IObjectPK)arrList.get(i);
        }
        return pks;
    }

    private boolean cannotEnroll(Context ctx, String personId) throws BOSException, EASBizException {
        PersonPositionCollection ppColl = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionCollection("select id,dimissionReason.id,dimissionReason.isPermission where person.id = '" + personId + "'");
        PersonPositionInfo ppInfo = null;
        boolean canEnroll = true;
        if (ppColl.size() > 0 && (ppInfo = ppColl.get(0)).getDimissionReason() != null) {
            canEnroll = !ppInfo.getDimissionReason().isIsPermission();
        }
        return canEnroll;
    }

    @Override
    protected boolean _getIsEnrollAgain(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        PersonInfo pInfo = (PersonInfo)personInfo;
        return this.cannotEnroll(ctx, pInfo.getId().toString());
    }

    private TreeData buildTreeData(IRowSet rows) throws BOSException, EASBizException {
        TreeData rootNode = null;
        TreeData childNode = null;
        HashMap<String, TreeData> nodeMap = new HashMap<String, TreeData>();
        String id = null;
        String parentId = null;
        try {
            rows.beforeFirst();
            while (rows.next()) {
                id = rows.getString("FID");
                parentId = rows.getString("FParentID");
                if (rootNode == null) {
                    rootNode = this.createTreeDateNode(rows);
                    nodeMap.put(id, rootNode);
                    continue;
                }
                childNode = this.createTreeDateNode(rows);
                if (parentId != null && nodeMap.containsKey(parentId)) {
                    ((TreeData)nodeMap.get(parentId)).addChild(childNode);
                } else {
                    rootNode.addChild(childNode);
                }
                nodeMap.put(id, childNode);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rootNode;
    }

    private TreeData createTreeDateNode(IRowSet rows) throws SQLException {
        TreeData node = new TreeData();
        node.setLongNumber(rows.getString("FLongNumber"));
        return node;
    }

    private void sumTreeNodeData(TreeData treeData, ArrayList keyList, HashMap map) {
        int size = treeData.getChildrens().size();
        for (int i = 0; i < size; ++i) {
            this.sumTreeNodeData((TreeData)treeData.getChildrens().get(i), keyList, map);
        }
        String key = null;
        int sum = 0;
        TreeData childData = null;
        for (int i = 0; i < keyList.size(); ++i) {
            key = keyList.get(i).toString();
            sum = (Integer)map.get(key + "$@" + treeData.getLongNumber());
            int size2 = treeData.getChildrens().size();
            for (int t = 0; t < size2; ++t) {
                childData = (TreeData)treeData.getChildrens().get(t);
                sum += ((Integer)map.get(key + "$@" + childData.getLongNumber())).intValue();
            }
            map.put(key + "$@" + treeData.getLongNumber(), sum);
        }
    }

    @Override
    protected String _getEmpHROrgUnitID(Context ctx, String empId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FToUnitID FROM T_BD_Person ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON (T_BD_Person.FID=T_ORG_PositionMember.FPersonID AND T_ORG_PositionMember.FIsPrimary=1) ");
        sql.append("INNER JOIN T_ORG_Position ON T_ORG_PositionMember.FPositionID=T_ORG_Position.FID ");
        sql.append("INNER JOIN T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID=T_ORG_Admin.FID ");
        sql.append("INNER JOIN T_ORG_UnitRelation  ");
        sql.append("ON (T_ORG_Admin.FID=T_ORG_UnitRelation.FFromUnitID ");
        sql.append("AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append("WHERE T_BD_Person.FID = '");
        sql.append(empId);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected String _getPositionHROrgUnitID(Context ctx, String PrimaryPositonid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FToUnitID FROM T_ORG_Position INNER JOIN T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID=T_ORG_Admin.FID INNER JOIN T_ORG_UnitRelation  ON (T_ORG_Admin.FID=T_ORG_UnitRelation.FFromUnitID AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') WHERE  T_ORG_Position.FID = '");
        sql.append(PrimaryPositonid);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String getPrimaryPositionId(PositionMemberCollection pmColl) {
        for (int size = pmColl.size() - 1; size >= 0; --size) {
            PositionMemberInfo p = pmColl.get(size);
            if (!p.isIsPrimary()) continue;
            return p.getPosition().getId().toString();
        }
        return "";
    }

    @Override
    protected void _checkIdCardNumberDuplicate(Context ctx, List personInfoList) throws BOSException, EASBizException {
        if (personInfoList != null && personInfoList.size() > 0) {
            for (int i = 0; i < personInfoList.size(); ++i) {
                PersonInfo personInfo = (PersonInfo)personInfoList.get(i);
                this.checkIdCardNumber(ctx, personInfo, personInfo.getIdCardNO());
            }
        }
    }

    protected HashMap _getPersonCountsByProp(Context ctx, ReportOrgQueryInfo reportOrgInfo, ArrayList arrayParams, ArrayList arrayCustomAge, ArrayList arrayGroupServiceYears, ArrayList arrayCompanyServiceYears, boolean isDefault) throws BOSException, EASBizException {
        return null;
    }

    @Override
    @Deprecated
    protected boolean _checkPersonPlan(Context ctx, PersonInfo personInfo, PositionInfo position) throws BOSException, EASBizException {
        EmployeeTypeInfo empType = personInfo.getEmployeeType();
        if (position == null || empType == null) {
            return true;
        }
        if (empType.get("isOnTheStrength") == null) {
            empType = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getValue("select id, isOnTheStrength where id = '" + empType.getId().toString() + "'");
        }
        if (!empType.isIsOnTheStrength()) {
            return true;
        }
        PersonPlanFactory.getLocalInstance((Context)ctx).canAddPerson(position.getId().toString());
        return true;
    }

    private boolean copyPersonPositionInfo(PersonInfo pInfo, PersonPositionInfo ppInfo) {
        boolean isNeedUpdatePersonPosition = false;
        PersonPositionInfo tempPersonPosition = (PersonPositionInfo)pInfo.get("personPosition");
        if (tempPersonPosition.containsKey("enterDate")) {
            ppInfo.setEnterDate(tempPersonPosition.getEnterDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("joinDate")) {
            ppInfo.setJoinDate(tempPersonPosition.getJoinDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("joinGroupDate")) {
            ppInfo.setJoinGroupDate(tempPersonPosition.getJoinGroupDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("personDep")) {
            ppInfo.setPersonDep(tempPersonPosition.getPersonDep());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("gkAdmin")) {
            ppInfo.setGkAdmin(tempPersonPosition.getGkAdmin());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("jobStartDate")) {
            ppInfo.setJobStartDate(tempPersonPosition.getJobStartDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("jobGrade")) {
            ppInfo.setJobGrade(tempPersonPosition.getJobGrade());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("jobGradeEndDate")) {
            ppInfo.setJobGradeEndDate(tempPersonPosition.getJobGradeEndDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("jobLevel")) {
            ppInfo.setJobLevel(tempPersonPosition.getJobLevel());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("workTime")) {
            ppInfo.setWorkTime(tempPersonPosition.getWorkTime());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("extWorkTime")) {
            ppInfo.setExtWorkTime(tempPersonPosition.getExtWorkTime());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("lenOfActualService")) {
            ppInfo.setLenOfActualService(tempPersonPosition.getLenOfActualService());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("tryoutMonth")) {
            ppInfo.setTryoutMonth(tempPersonPosition.getTryoutMonth());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("formalDate")) {
            ppInfo.setFormalDate(tempPersonPosition.getFormalDate());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("primaryPosition")) {
            ppInfo.setPrimaryPosition(tempPersonPosition.getPrimaryPosition());
            isNeedUpdatePersonPosition = true;
        }
        if (tempPersonPosition.containsKey("personDep")) {
            ppInfo.setPersonDep(tempPersonPosition.getPersonDep());
            isNeedUpdatePersonPosition = true;
        }
        return isNeedUpdatePersonPosition;
    }

    @Override
    protected void _checkIdCardnumber2(Context ctx, PersonInfo pinfo, String idCardNumber) throws BOSException {
        try {
            this.checkIdCardNumber(ctx, pinfo, idCardNumber);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }
}

