/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpLaborRelationDomainFacadeFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.LogActionTypeEnum;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpLaborRelationUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.CredentialsTypeInfo;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoFactory;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoInfo;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.AbstractEmpQuickAddNewInfoInitFacadeControllerBean;
import com.kingdee.eas.hr.emp.app.EmpQuickAddNewInfoUtil;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpDoPersonCredentialsTypeUtil;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpQuickAddNewInfoInitFacadeControllerBean
extends AbstractEmpQuickAddNewInfoInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpQuickAddNewInfoInitFacadeControllerBean");

    @Override
    protected IObjectPK _employeeInitialize(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpQuickAddNewInfoInfo info = (EmpQuickAddNewInfoInfo)model;
        this.checkData(ctx, info);
        PersonOptBaseInfo personOptInfo = new PersonOptBaseInfo();
        PersonInfo personInfo = this.preparedPersonInfo(ctx, info);
        PersonPositionInfo ppInfo = this.preparedPersonPositionInfo(ctx, info);
        ppInfo.setPerson(personInfo);
        personOptInfo.setPerson(personInfo);
        personOptInfo.setPersonPosition(ppInfo);
        personOptInfo.setFromInitialize(true);
        String isAddUser = (String)info.get("isAddUser");
        String userNumber = (String)info.get("userName");
        if (isAddUser != null) {
            personInfo.put("isAddUser", (Object)isAddUser);
        }
        if (userNumber != null) {
            personInfo.put("userNumber", (Object)userNumber);
        }
        IObjectPK pk = PersonOptFacadeFactory.getLocalInstance(ctx).personAddNew(personInfo.getEFFDT(), personOptInfo);
        personInfo.setId(BOSUuid.read((String)pk.toString()));
        HRBizData bizData = EmpQuickAddNewInfoUtil.infosConvertToBizData(ctx, info, personInfo);
        bizData.setActionSource(LogActionTypeEnum.quickAddNew);
        EmpPosOrgRelationFacadeFactory.getLocalInstance((Context)ctx).operateHRBizDefine(bizData);
        this.afterInitialize(ctx, info, personInfo);
        HRUtilExtend.assableCell((CoreBaseInfo)info, (String)"telNum");
        this.checkAndSetCredentialsType(ctx, info, personInfo);
        return EmpQuickAddNewInfoFactory.getLocalInstance(ctx).addnew(info);
    }

    private void afterInitialize(Context ctx, EmpQuickAddNewInfoInfo info, PersonInfo personInfo) throws EASBizException, BOSException {
        EmployeeTypeInfo emptypeInfo = personInfo.getEmployeeType();
        emptypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo("where id ='" + emptypeInfo.getId().toString() + "'");
        personInfo.setEmployeeType(emptypeInfo);
        this.doWithEmpLaborRelatioinFields(ctx, info, personInfo);
        this.doWithPersonPhoto(ctx, (IObjectValue)info, personInfo);
        this.doWithDateFields(ctx, info, personInfo);
    }

    private void doWithDateFields(Context ctx, EmpQuickAddNewInfoInfo info, PersonInfo personInfo) throws EASBizException, BOSException {
        SelectorItemCollection selector;
        String oql;
        EmployeeTypeInfo emptypeInfo = personInfo.getEmployeeType();
        emptypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo("where id ='" + emptypeInfo.getId().toString() + "'");
        EmployeeTypeEnum inservice = emptypeInfo.getInService();
        if (EmployeeTypeEnum.DIMISSION.equals((Object)inservice)) {
            oql = "where person ='" + personInfo.getId().toString() + "'";
            PersonPositionInfo ppInfo = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionInfo(oql);
            ppInfo.setLeftDate(info.getEFFDT());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("leftDate"));
            PersonPositionOptFacadeFactory.getLocalInstance(ctx).updatePartialWithHis(ppInfo, selector);
        }
        if (EmployeeTypeEnum.RETIRE.equals((Object)inservice)) {
            oql = "where person ='" + personInfo.getId().toString() + "'";
            PersonOtherInfoInfo pOtherInfo = PersonOtherInfoFactory.getLocalInstance(ctx).getPersonOtherInfoInfo(oql);
            pOtherInfo.setRetireDate(info.getEFFDT());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("retireDate"));
            PersonOtherInfoFactory.getLocalInstance(ctx).updatePartial(pOtherInfo, selector);
        }
        if (EmployeeTypeEnum.RERETAIN.equals((Object)inservice)) {
            oql = "where person ='" + personInfo.getId().toString() + "'";
            EmpLaborRelationInfo empLaborRelationDB = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationInfo(oql);
            empLaborRelationDB.setReinviteDate(info.getEFFDT());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("reinviteDate"));
            EmpLaborRelationDomainFacadeFactory.getLocalInstance((Context)ctx).updatePartialWithHis(empLaborRelationDB, selector);
        }
    }

    private void doWithEmpLaborRelatioinFields(Context ctx, EmpQuickAddNewInfoInfo info, PersonInfo personInfo) throws EASBizException, BOSException {
        EmpLaborRelationInfo.EnrollInfo enrollInfo = new EmpLaborRelationInfo.EnrollInfo();
        enrollInfo.setEnrollAgain(false);
        enrollInfo.setEnrollDate(info.getEnterDate());
        enrollInfo.setPlanFormalDate(info.getPlanFormalDate());
        enrollInfo.setTryoutMonth(info.getProbation());
        EmpLaborRelationUtil.doWithEnrollEmpLaborRelatioinFields((Context)ctx, (EmpLaborRelationInfo.EnrollInfo)enrollInfo, (String)personInfo.getId().toString());
    }

    private void doWithPersonPhoto(Context ctx, IObjectValue model, PersonInfo pInfo) throws BOSException, EASBizException {
        if (model.get("tempperid") != null && !"".equals(model.get("tempperid"))) {
            String tempperid = model.get("tempperid").toString();
            IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance(ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)tempperid));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            if (coll.size() > 0) {
                personPhotoInfo = (PersonPhotoInfo)coll.get(0);
                PersonPhotoInfo addPhoto = new PersonPhotoInfo();
                addPhoto.setPerson(pInfo);
                addPhoto.setImageDataSource(personPhotoInfo.getImageDataSource());
                addPhoto.setImageData(personPhotoInfo.getImageData());
                addPhoto.setSourceImageHeight(personPhotoInfo.getSourceImageHeight());
                addPhoto.setSourceImageWidth(personPhotoInfo.getSourceImageWidth());
                addPhoto.setImageContentType(personPhotoInfo.getImageContentType());
                personPhoto.addnew(addPhoto);
                personPhoto.delete((IObjectPK)new ObjectUuidPK(personPhotoInfo.getId()));
            }
        }
    }

    private PersonPositionInfo preparedPersonPositionInfo(Context ctx, EmpQuickAddNewInfoInfo info) throws BOSException, EASBizException {
        PersonPositionInfo ppInfo = new PersonPositionInfo();
        ppInfo.setPrimaryPosition(info.getPosition());
        ppInfo.setPersonDep(info.getAdminOrg());
        ppInfo.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)info.getAdminOrg()));
        ppInfo.setJoinDate(info.getJoinDate());
        ppInfo.setJoinGroupDate(info.getJoinGroupDate());
        Date joinGroupDateCur = info.getEnterDate();
        if (DateTimeUtils.dayAfter((Date)info.getJoinGroupDate(), (Date)joinGroupDateCur)) {
            joinGroupDateCur = info.getJoinGroupDate();
        }
        ppInfo.setJoinGroupDateCur(joinGroupDateCur);
        ppInfo.setEFFDT(info.getJoinDate());
        ppInfo.setLEFFDT(HistoryUtil.getMaxDate());
        ppInfo.setStartDateTime(ppInfo.getEFFDT());
        ppInfo.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        ppInfo.setVersion(1);
        ppInfo.setIsLatestInAday(true);
        return ppInfo;
    }

    private PersonInfo preparedPersonInfo(Context ctx, EmpQuickAddNewInfoInfo info) throws EASBizException, BOSException {
        PersonInfo pInfo = new PersonInfo();
        pInfo.setNumber(info.getNumber());
        String idCardNO = info.getIdCardNO();
        if (!StringUtils.isEmpty((String)idCardNO)) {
            info.setIdCardNO(IDCardCommonUtil.upperIdCardNo((String)idCardNO));
        }
        pInfo.setIdCardNO(info.getIdCardNO());
        pInfo.setPassportNO(info.getPassportNO());
        pInfo.setEmployeeType(info.getLaborRelationState());
        if (!StringUtils.isEmpty((String)info.getName())) {
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"name", (IObjectValue)pInfo, (String)"name");
        }
        if (!StringUtils.isEmpty((String)info.getLastName())) {
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"lastName", (IObjectValue)pInfo, (String)"lastName");
        }
        if (!StringUtils.isEmpty((String)info.getMiddleName())) {
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"middleName", (IObjectValue)pInfo, (String)"middleName");
        }
        if (!StringUtils.isEmpty((String)info.getFirstName())) {
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"firstName", (IObjectValue)pInfo, (String)"firstName");
        }
        if (!StringUtils.isEmpty((String)info.getGlobalRoaming()) && !StringUtils.isEmpty((String)info.getNCell())) {
            pInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            pInfo.setNCell(info.getNCell().trim());
        }
        Date personEFFDT = info.getJoinGroupDate();
        if (DateTimeUtils.dayBefore((Date)info.getEnterDate(), (Date)personEFFDT)) {
            personEFFDT = info.getEnterDate();
        }
        pInfo.setEFFDT(personEFFDT);
        pInfo.setHireDate(info.getEnterDate());
        pInfo.setEmail(info.getEmail());
        pInfo.setHrOrgUnit(info.getHrOrgUnit());
        AdminOrgUnitInfo adminOrg = EmpQuickAddNewInfoUtil.getAdminInfoByPosition(ctx, info.getPosition());
        if (pInfo.get("notNeedGenerateObjectNumber") == null) {
            HRUtilExtend.setPersonNumber((Context)ctx, (PersonInfo)pInfo, (AdminOrgUnitInfo)adminOrg);
            info.setNumber(pInfo.getNumber());
        }
        pInfo.put("notNeedGenerateObjectNumber", (Object)true);
        EmpQuickAddNewInfoUtil.setBirthdayAndSexOfPerson(ctx, info, adminOrg, pInfo);
        EmpQuickAddNewInfoUtil.checkEnrollPerson(ctx, info);
        EmpQuickAddNewInfoUtil.checkPersonInAffairProcess(ctx, info.getNumber());
        return pInfo;
    }

    private void checkData(Context ctx, EmpQuickAddNewInfoInfo info) throws BOSException, EASBizException {
        Date personEFFDT = info.getJoinGroupDate();
        if (DateTimeUtils.dayBefore((Date)info.getEnterDate(), (Date)personEFFDT)) {
            personEFFDT = info.getEnterDate();
        }
        if (personEFFDT.after(new Date())) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)new Date())};
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_FUTURE_EFFDT, params);
        }
        if (DateTimeUtils.dayAfter((Date)info.getEFFDT(), (Date)new Date())) {
            throw new AffairActioniOperateException(AffairActioniOperateException.NOEFFECTFUTURE);
        }
        if (info.getEFFDT() == null || info.getJoinGroupDate() == null || info.getEnterDate() == null || info.getJoinDate() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EMP_INIT_DATE_CANT_NOT_NULL);
        }
        if (info.getPosition() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.TARGETPOSITIONNOTNULL);
        }
        if (DateTimeUtils.dayBefore((Date)info.getJoinDate(), (Date)info.getEnterDate())) {
            throw new AffairActioniOperateException(AffairActioniOperateException.JOINDATE_CANT_BEFORE_ENTERDATE, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)info.getJoinDate()), HRUtilExtend.getDateStringWithoutMininute((Date)info.getEnterDate())});
        }
        if (DateTimeUtils.dayBefore((Date)info.getEFFDT(), (Date)info.getJoinDate())) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EFFDT_CANT_BEFORE_JOINDATE, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)info.getEFFDT()), HRUtilExtend.getDateStringWithoutMininute((Date)info.getJoinDate())});
        }
        OrgAdjLockManager.checkIfOrgLocked((Context)ctx, null, (String)info.getPosition().getId().toString());
    }

    protected void checkAndSetCredentialsType(Context ctx, EmpQuickAddNewInfoInfo entryInfo, PersonInfo pInfo) throws EASBizException, BOSException {
        if (!entryInfo.containsKey("credentialsType") && entryInfo.getCredentialsType() == null && !StringUtils.isEmpty((String)entryInfo.getPassportNO())) {
            CredentialsTypeInfo typeInfo = new CredentialsTypeInfo();
            typeInfo.setId(BOSUuid.read((String)"DKku/T51SlSsPipwUmJ8WVlu4mQ="));
            entryInfo.setCredentialsType(typeInfo);
        }
        SHREmpCheckCredentialsTypeUtil.checkCredentiaslTypeForEmp(ctx, (CoreBaseInfo)entryInfo, pInfo.getId().toString());
        SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPerson(ctx, pInfo, (CoreBaseInfo)entryInfo);
        SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPersonOtherInfo(ctx, pInfo, entryInfo);
    }
}

