/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.BMCMessageCollection;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.AuditPersonPhotoCollection;
import com.kingdee.eas.hr.base.AuditPersonPhotoFactory;
import com.kingdee.eas.hr.base.AuditPersonPhotoInfo;
import com.kingdee.eas.hr.base.ConstellationInfo;
import com.kingdee.eas.hr.base.EmpAuditPageInfo;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.ZodiacInfo;
import com.kingdee.eas.hr.base.app.util.CoreBaseObjectUtil;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.CompareUtil;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.base.util.personphoto.PersonPhotoAuditUtil;
import com.kingdee.eas.hr.emp.CountryRegionInfo;
import com.kingdee.eas.hr.emp.CredentialsTypeException;
import com.kingdee.eas.hr.emp.CredentialsTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditStateEnum;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeePageDataSetCollection;
import com.kingdee.eas.hr.emp.EmployeePageDataSetFactory;
import com.kingdee.eas.hr.emp.EmployeePageDataSetInfo;
import com.kingdee.eas.hr.emp.IEmployeeAudit;
import com.kingdee.eas.hr.emp.IEmployeePageDataSet;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.OperateTypeEnum;
import com.kingdee.eas.hr.emp.PersonBankRecordInfo;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyInfo;
import com.kingdee.eas.hr.emp.PersonCredentialsTypeInfo;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeAuditControllerBean;
import com.kingdee.eas.hr.emp.app.util.BankAccountNumDuplicateValidateUtil;
import com.kingdee.eas.hr.emp.app.util.EMPhelper;
import com.kingdee.eas.hr.emp.app.util.EmployeeAuditUtil;
import com.kingdee.eas.hr.emp.app.util.EmployeePageAuditServerUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpDoPersonCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SendMessageSrv;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmployeeAuditControllerBean
extends AbstractEmployeeAuditControllerBean {
    private static final long serialVersionUID = 2695525486742895927L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmployeeAuditControllerBean");

    @Override
    protected IObjectPK _saveEmployeePageData(Context ctx, IObjectValue model, EmpAuditPageInfo auditPageInfo, String empPageDataTypeId) throws BOSException, EASBizException {
        ObjectBaseInfo objectInfo = (ObjectBaseInfo)model;
        PersonInfo person = EmployeePageAuditServerUtil.getPersonInfo((CoreBaseInfo)objectInfo);
        BOSUuid pageId = objectInfo.getId();
        if (pageId != null) {
            this.deleteExistAuditData(ctx, person.getId().toString(), auditPageInfo.getEntityName(), pageId.toString());
            EmployeeAuditCollection collection = this.getConfirmData(ctx, person.getId().toString(), auditPageInfo.getEntityName(), pageId.toString());
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    EmployeePageAuditServerUtil.confirmEmployeeAudit(ctx, (IObjectPK)new ObjectUuidPK(collection.get(i).getId()));
                }
            }
        }
        if (auditPageInfo.isMulti()) {
            return this.saveEmployeeMultiPageData(ctx, auditPageInfo, (CoreBaseInfo)objectInfo, empPageDataTypeId);
        }
        return this.saveEmployeeSinglePageData(ctx, auditPageInfo, (CoreBaseInfo)objectInfo, empPageDataTypeId);
    }

    @Override
    protected CoreBaseInfo _getEmployeePageData(Context ctx, IObjectPK empPageId, String entityName, EntityViewInfo view) throws BOSException, EASBizException {
        CoreBaseCollection coreBaseColl = this.getEmpPageCollectionByPageId(ctx, empPageId, entityName, view.getSelector());
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        EntityViewInfo auditViewInfo = new EntityViewInfo();
        SelectorItemCollection auditSelector = new SelectorItemCollection();
        auditSelector.add(new SelectorItemInfo("pk"));
        auditSelector.add(new SelectorItemInfo("status"));
        auditSelector.add(new SelectorItemInfo("reason"));
        auditSelector.add(new SelectorItemInfo("operateType"));
        auditSelector.add(new SelectorItemInfo("auditor.id"));
        auditSelector.add(new SelectorItemInfo("auditor.name"));
        auditSelector.add(new SelectorItemInfo("entrys.*"));
        FilterInfo auditFilter = new FilterInfo();
        FilterItemCollection filterItemColl = auditFilter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("pk", (Object)empPageId.toString()));
        filterItemColl.add(new FilterItemInfo("status", (Object)1));
        filterItemColl.add(new FilterItemInfo("status", (Object)3));
        filterItemColl.add(new FilterItemInfo("confirmStatus", (Object)false));
        filterItemColl.add(new FilterItemInfo("status", (Object)EmployeeAuditStateEnum.AUDIT));
        auditFilter.setMaskString("#0 and (#1 or (#2 and #3) or #4)");
        auditViewInfo.setFilter(auditFilter);
        auditViewInfo.setSelector(auditSelector);
        EmployeeAuditCollection auditColl = iEmployeeAudit.getEmployeeAuditCollection(auditViewInfo);
        CoreBaseCollection addNewColl = this.getAddNewEmpPageData(ctx, entityName, coreBaseColl, auditColl);
        coreBaseColl.addCollection(addNewColl);
        CoreBaseInfo sourcePageInfo = null;
        if (coreBaseColl.size() > 0) {
            sourcePageInfo = coreBaseColl.get(0);
            this.assembleEmployeePageInfoWithAuditData(ctx, entityName, sourcePageInfo, auditColl);
        }
        return sourcePageInfo;
    }

    protected boolean checkHasHighestDegree(Context ctx, PersonDegreeInfo personDegreeInfo, PersonInfo person) throws SQLException, BOSException {
        boolean hasHighestDegree = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select FDescAfter from  T_HR_EmployeeAudit ");
        sql.append("where fpersonid='").append(person.getId().toString());
        sql.append("' and fstatus=1 and fentity='com.kingdee.eas.hr.emp.app.PersonDegree'");
        if (null != personDegreeInfo && null != personDegreeInfo.getId()) {
            sql.append(" and fpk <> '").append(personDegreeInfo.getId().toString() + "'");
        }
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String pDegreeMessage = rs.getString("FDescAfter");
            if (!pDegreeMessage.contains(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"high_edu", (Context)ctx))) continue;
            hasHighestDegree = true;
            break;
        }
        return hasHighestDegree;
    }

    protected CoreBaseCollection _getEmployeePageDataCollection(Context ctx, IObjectPK personId, String entityName, EntityViewInfo view) throws BOSException, EASBizException {
        CoreBaseCollection coreBaseColl = this.getEmpPageCollectionByPersonId(ctx, personId, entityName, view);
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        EntityViewInfo auditViewInfo = new EntityViewInfo();
        SelectorItemCollection auditSelector = new SelectorItemCollection();
        auditSelector.add(new SelectorItemInfo("pk"));
        auditSelector.add(new SelectorItemInfo("status"));
        auditSelector.add(new SelectorItemInfo("reason"));
        auditSelector.add(new SelectorItemInfo("operateType"));
        auditSelector.add(new SelectorItemInfo("auditor.id"));
        auditSelector.add(new SelectorItemInfo("auditor.name"));
        auditSelector.add(new SelectorItemInfo("entrys.*"));
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId.toString(), CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("entity", (Object)entityName, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
        auditFilter.getFilterItems().add(new FilterItemInfo("confirmStatus", (Object)false, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("status", (Object)4));
        auditFilter.setMaskString("#0 and #1 and (#2 or (#3 and #4) or #5)");
        auditViewInfo.setFilter(auditFilter);
        auditViewInfo.setSelector(auditSelector);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("createTime"));
        auditViewInfo.setSorter(sorters);
        EmployeeAuditCollection auditColl = iEmployeeAudit.getEmployeeAuditCollection(auditViewInfo);
        CoreBaseCollection addNewColl = this.getAddNewEmpPageData(ctx, entityName, coreBaseColl, auditColl);
        coreBaseColl.addCollection(addNewColl);
        int size = coreBaseColl.size();
        for (int i = 0; i < size; ++i) {
            CoreBaseInfo sourcePageInfo = coreBaseColl.get(i);
            this.assembleEmployeePageInfoWithAuditData(ctx, entityName, sourcePageInfo, auditColl);
        }
        return coreBaseColl;
    }

    @Override
    protected void _deleteEmployeePageData(Context ctx, IObjectPK pk, EmpAuditPageInfo auditPageInfo, EntityViewInfo view, String empPageDataTypeId) throws BOSException, EASBizException {
        String entityName = auditPageInfo.getEntityName();
        ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)entityName);
        if (corebase.exists(pk)) {
            PersonCredentialsTypeInfo pcInfo;
            EmpInfoMultiPageInfo pInfo;
            CoreBaseInfo objectInfo = corebase.getValue(pk);
            PersonInfo person = EmployeePageAuditServerUtil.getPersonInfo(objectInfo);
            EmployeeAuditCollection collection = this.getConfirmData(ctx, person.getId().toString(), auditPageInfo.getEntityName(), pk.toString());
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    EmployeePageAuditServerUtil.confirmEmployeeAudit(ctx, (IObjectPK)new ObjectUuidPK(collection.get(i).getId()));
                }
            }
            this.deleteExistAuditData(ctx, person.getId().toString(), entityName, pk.toString());
            CoreBaseCollection coreBaseColl = this.getEmpPageCollectionByPageId(ctx, pk, entityName, view.getSelector());
            CoreBaseInfo sourcePageInfo = coreBaseColl.get(0);
            if (sourcePageInfo instanceof PersonCertifyCompetencyInfo) {
                pInfo = (PersonCertifyCompetencyInfo)sourcePageInfo;
                if (pInfo.getCertifiedCompetency() != null && pInfo.getCertifiedCompetency().getCategory() != null) {
                    sourcePageInfo.put("certifiedCompetency.category.name", (Object)pInfo.getCertifiedCompetency().getCategory().getName());
                }
                if (pInfo.getCertifiedCompetency() != null && pInfo.getCertifiedCompetency().getLevel() != null) {
                    sourcePageInfo.put("certifiedCompetency.level.name", (Object)pInfo.getCertifiedCompetency().getLevel().getName());
                }
            } else if (sourcePageInfo instanceof PersonTechnicalPostInfo) {
                pInfo = (PersonTechnicalPostInfo)sourcePageInfo;
                if (pInfo.getTechnicalPost().getCategory() != null) {
                    sourcePageInfo.put("technicalPost.category.name", (Object)pInfo.getTechnicalPost().getCategory().getName());
                }
                if (pInfo.getTechnicalPost().getLevel() != null) {
                    sourcePageInfo.put("technicalPost.level.name", (Object)pInfo.getTechnicalPost().getLevel().getName());
                }
            } else if (sourcePageInfo instanceof PersonCredentialsTypeInfo && (pcInfo = (PersonCredentialsTypeInfo)sourcePageInfo).isIsCertify()) {
                throw new CredentialsTypeException(CredentialsTypeException.CANNOT_DELETE_CERTIFY_CARD);
            }
            auditPageInfo.getFiledName();
            List fieldName = auditPageInfo.getFiledName();
            StringBuffer sourceDesc = new StringBuffer();
            EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx, auditPageInfo, sourcePageInfo, sourcePageInfo.getId(), empPageDataTypeId);
            EmployeeAuditEntryCollection entryColl = new EmployeeAuditEntryCollection();
            int size = fieldName.size();
            for (int i = 0; i < size; ++i) {
                HashMap propMap = (HashMap)fieldName.get(i);
                Map.Entry entry = propMap.entrySet().iterator().next();
                String propName = (String)entry.getKey();
                Object srcVal = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)sourcePageInfo, (String)propName);
                sourceDesc.append(EmployeePageAuditServerUtil.getFieldDescription(ctx, (String)entry.getValue(), sourcePageInfo, propName, false));
                EmployeeAuditEntryInfo entryInfo = EmployeePageAuditServerUtil.assembleAuditEntryInfo(auditInfo, propName, sourcePageInfo.get(propName));
                entryColl.add(entryInfo);
            }
            auditInfo.setPerson(person);
            auditInfo.put("entrys", (Object)entryColl);
            auditInfo.setOperateType(OperateTypeEnum.DELETE);
            auditInfo.setDescBefore(sourceDesc.toString());
            auditInfo.setDescAfter("");
            EmployeeAuditFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)auditInfo);
        } else {
            IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
            String oql = "select id where pk='" + pk + "' and (status =1 or status= 4)";
            iEmployeeAudit.delete(oql);
        }
    }

    @Override
    protected void _confirmEmployeeAuditData(Context ctx, IObjectPK pk) throws BOSException {
        EmployeePageAuditServerUtil.confirmEmployeeAudit(ctx, pk);
    }

    @Override
    protected void _auditEmployeeAuditData(Context ctx, EmployeeAuditCollection employeeAuditInfoColl) throws BOSException, EASBizException {
        EmployeeAuditInfo auditInfo = null;
        BMCMessageCollection messageList = null;
        UserCollection userColl = null;
        int size = employeeAuditInfoColl.size();
        for (int i = 0; i < size; ++i) {
            block18: {
                EmployeeAuditInfo curAuditInfo;
                block16: {
                    ICoreBase coreBase;
                    CoreBaseInfo coreBaseInfo;
                    ICoreBase bizInterface;
                    block20: {
                        IPersonPosition iPersonPosition;
                        block19: {
                            block17: {
                                auditInfo = employeeAuditInfoColl.get(i);
                                curAuditInfo = this.getEmployeeAuditInfo(ctx, auditInfo);
                                if (!EmployeeAuditStateEnum.PASSED.equals((Object)auditInfo.getStatus())) break block16;
                                if (curAuditInfo.getCategory() == null || curAuditInfo.getCategory().getId() == null || !StringUtils.equals((String)curAuditInfo.getCategory().getId().toString(), (String)PersonPhotoAuditUtil.personCategoryId)) break block17;
                                this.doWhthPersonPhotoInfo(ctx, curAuditInfo);
                                break block18;
                            }
                            bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (String)curAuditInfo.getEntity());
                            if (!OperateTypeEnum.DELETE.equals((Object)curAuditInfo.getOperateType())) break block19;
                            bizInterface.delete((IObjectPK)new ObjectUuidPK(curAuditInfo.getPk()));
                            break block18;
                        }
                        coreBaseInfo = null;
                        Class clazz = MetaDataServerUtil.getObjectValueClass((Context)ctx, (String)curAuditInfo.getEntity());
                        coreBase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)curAuditInfo.getEntity());
                        try {
                            CoreBaseInfo objectValue = (CoreBaseInfo)clazz.newInstance();
                            coreBaseInfo = objectValue instanceof EmpInfoMultiPageInfo ? EmployeeAuditUtil.convertObjectValueForMulti(ctx, curAuditInfo) : EmployeeAuditUtil.convertObjectValue(ctx, curAuditInfo);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                        if (!(coreBaseInfo instanceof PersonInfo)) {
                            coreBaseInfo.put("person", (Object)curAuditInfo.getPerson());
                        }
                        if (coreBaseInfo instanceof PersonInfo || coreBaseInfo instanceof PersonPositionInfo) {
                            coreBaseInfo.put("effdt", (Object)DateTimeUtils.truncateDate((Date)new Date()));
                            if (coreBaseInfo instanceof PersonInfo) {
                                PersonInfo pInfo = (PersonInfo)coreBaseInfo;
                                String fieldName = "";
                                if (curAuditInfo != null && curAuditInfo.getEntrys() != null && curAuditInfo.getEntrys().size() > 0) {
                                    fieldName = curAuditInfo.getEntrys().get(0).getFieldName();
                                }
                                this.doWhthPersonOtherInfo(ctx, pInfo, fieldName, true);
                            }
                        }
                        if (coreBaseInfo instanceof PersonPositionInfo && !(iPersonPosition = PersonPositionFactory.getLocalInstance(ctx)).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId().toString()))) {
                            PersonPositionInfo personPositionInfo = (PersonPositionInfo)coreBaseInfo;
                            PersonInfo personInfo = personPositionInfo.getPerson();
                            String sql = "select id where person.id = '" + personInfo.getId().toString() + "'";
                            coreBaseInfo.setId(iPersonPosition.getPersonPositionInfo(sql).getId());
                        }
                        if (!OperateTypeEnum.UPDATE.equals((Object)curAuditInfo.getOperateType())) break block20;
                        SelectorItemCollection sic = EmployeeAuditUtil.getSelectors(curAuditInfo);
                        if (coreBaseInfo instanceof EmpInfoMultiPageInfo) {
                            if (curAuditInfo.getEntity().equals("com.kingdee.eas.hr.emp.app.PersonBankRecord")) {
                                PersonBankRecordInfo info = (PersonBankRecordInfo)coreBaseInfo;
                                ctx.put((Object)"bankAccountPersonId", (Object)info.getPerson().getId().toString());
                                BankAccountNumDuplicateValidateUtil.checkBankAccountNumDup(ctx, info.getAccountNum(), info.getId().toString());
                            }
                            bizInterface.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId().toString()), coreBaseInfo);
                        } else {
                            PersonInfo personInfo;
                            if (coreBaseInfo instanceof PersonInfo && !DateTimeUtils.dayEquals((Date)(personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))).getEFFDT(), (Date)coreBaseInfo.getDate("effdt"))) {
                                coreBaseInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
                                sic.add(new SelectorItemInfo("creator"));
                                sic.add(new SelectorItemInfo("createTime"));
                                coreBaseInfo.put("creator", (Object)ContextUtil.getCurrentUserInfo((Context)ctx));
                                coreBaseInfo.put("createTime", (Object)new Date());
                            }
                            bizInterface.updatePartial(coreBaseInfo, sic);
                        }
                        break block18;
                    }
                    if (coreBase.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId().toString()))) break block18;
                    if (curAuditInfo.getEntity().equals("com.kingdee.eas.hr.emp.app.PersonBankRecord")) {
                        PersonBankRecordInfo info = (PersonBankRecordInfo)coreBaseInfo;
                        ctx.put((Object)"bankAccountPersonId", (Object)info.getPerson().getId().toString());
                        BankAccountNumDuplicateValidateUtil.checkBankAccountNumDup(ctx, info.getAccountNum(), null);
                    }
                    bizInterface.addnew(coreBaseInfo);
                    break block18;
                }
                if (messageList == null) {
                    messageList = new BMCMessageCollection();
                }
                userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person = '" + curAuditInfo.getPerson().getId().toString() + "'");
                for (int j = 0; j < userColl.size(); ++j) {
                    BMCMessageInfo messageInfo = new BMCMessageInfo();
                    messageInfo.setSender(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
                    messageInfo.setStatus(MsgStatus.UNREADED);
                    UserInfo user = userColl.get(j);
                    messageInfo.setReceiver(user.getId().toString());
                    messageInfo.setBizType(MsgBizType.WORKFLOW);
                    messageInfo.setAvailable(true);
                    messageInfo.setTitle("The personal information you submitted failed to be reviewed", LocaleUtils.locale_l1);
                    messageInfo.setTitle("\u60a8\u63d0\u4ea4\u7684\u4e2a\u4eba\u4fe1\u606f\u5ba1\u6838\u5931\u8d25", LocaleUtils.locale_l2);
                    messageInfo.setTitle("\u60a8\u63d0\u4ea4\u7684\u500b\u4eba\u4fe1\u606f\u5be9\u6838\u5931\u6557", LocaleUtils.locale_l3);
                    EmployeePageDataSetInfo pageInfo = EmployeePageDataSetFactory.getLocalInstance(ctx).getEmployeePageDataSetInfo((IObjectPK)new ObjectUuidPK(curAuditInfo.getCategory().getId().toString()));
                    String msgStr_l1 = "Failed to approve the modified individual file [{0}] {1}. Reason: {2}";
                    String msgStr_l2 = "\u60a8\u4fee\u6539\u4e2a\u4eba\u6863\u6848\u7684\u3010{0}\u3011{1} \u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u662f\uff1a{2}";
                    String msgStr_l3 = "\u60a8\u4fee\u6539\u500b\u4eba\u6a94\u6848\u7684\u3010{0}\u3011{1} \u5be9\u6279\u4e0d\u901a\u904e\uff0c\u539f\u56e0\u662f\uff1a{2}";
                    String messageResult_l1 = MessageFormat.format(msgStr_l1, pageInfo.getName(LocaleUtils.locale_l1), curAuditInfo.getOperateType().getAlias(LocaleUtils.locale_l1), auditInfo.getReason(LocaleUtils.locale_l1) == null ? "" : auditInfo.getReason());
                    String messageResult_l2 = MessageFormat.format(msgStr_l2, pageInfo.getName(LocaleUtils.locale_l2), curAuditInfo.getOperateType().getAlias(LocaleUtils.locale_l2), auditInfo.getReason(LocaleUtils.locale_l2) == null ? "" : auditInfo.getReason());
                    String messageResult_l3 = MessageFormat.format(msgStr_l3, pageInfo.getName(LocaleUtils.locale_l3), curAuditInfo.getOperateType().getAlias(LocaleUtils.locale_l3), auditInfo.getReason(LocaleUtils.locale_l3) == null ? "" : auditInfo.getReason());
                    messageInfo.setBody(messageResult_l1, LocaleUtils.locale_l1);
                    messageInfo.setBody(messageResult_l2, LocaleUtils.locale_l2);
                    messageInfo.setBody(messageResult_l3, LocaleUtils.locale_l3);
                    MsgType type = MsgType.getEnum((int)0);
                    MsgPriority priority = MsgPriority.getEnum((int)10);
                    messageInfo.setPriority(priority);
                    messageInfo.setType(type);
                    messageInfo.setSourceStatus(MsgSourceStatus.getEnum((int)0));
                    Calendar cal = Calendar.getInstance();
                    Timestamp timestamp = new Timestamp(cal.getTime().getTime());
                    messageInfo.setCategory("workflow");
                    messageInfo.setSendTime(timestamp);
                    messageList.add(messageInfo);
                }
            }
            auditInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            auditInfo.setSaveTime(DateTimeUtils.truncateDate((Date)new Date()));
            EmployeePageAuditServerUtil.updateEmployeeAuditStatus(ctx, auditInfo);
        }
        if (messageList != null && userColl != null && userColl.size() > 0) {
            SendMessageSrv messageSender = new SendMessageSrv(messageList);
            messageSender.sendMessage(ctx);
        }
    }

    protected void doWhthPersonPhotoInfo(Context ctx, EmployeeAuditInfo curAuditInfo) throws BOSException, EASBizException {
        IPersonPhoto iPersonPhoto = PersonPhotoFactory.getLocalInstance(ctx);
        AuditPersonPhotoCollection auditPersonPhotoCollection = AuditPersonPhotoFactory.getLocalInstance((Context)ctx).getAuditPersonPhotoCollection("where parent = '" + curAuditInfo.getId().toString() + "'");
        AuditPersonPhotoInfo auditPersonPhotoInfo = auditPersonPhotoCollection.get(0);
        PersonPhotoCollection coll = iPersonPhoto.getPersonPhotoCollection("select id where person = '" + curAuditInfo.getPerson().getId().toString() + "'");
        PersonPhotoInfo personPhotoInfo = null;
        personPhotoInfo = coll.isEmpty() ? new PersonPhotoInfo() : coll.get(0);
        personPhotoInfo.setPerson(curAuditInfo.getPerson());
        personPhotoInfo.setImageData(auditPersonPhotoInfo.getImageData());
        personPhotoInfo.setImageDataSource(auditPersonPhotoInfo.getImageDataSource());
        personPhotoInfo.setImageContentType(auditPersonPhotoInfo.getImageContentType());
        personPhotoInfo.setSourceImageHeight(auditPersonPhotoInfo.getSourceImageHeight());
        personPhotoInfo.setSourceImageWidth(auditPersonPhotoInfo.getSourceImageWidth());
        personPhotoInfo.setIsInFile(auditPersonPhotoInfo.isIsInFile());
        iPersonPhoto.save(personPhotoInfo);
    }

    private CoreBaseCollection getEmpPageCollectionByPageId(Context ctx, IObjectPK empPageId, String entityName, SelectorItemCollection selector) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)empPageId.toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)entityName);
        CoreBaseCollection coreBaseColl = corebase.getCollection(viewInfo);
        return coreBaseColl;
    }

    private CoreBaseCollection getEmpPageCollectionByPersonId(Context ctx, IObjectPK personId, String entityName, EntityViewInfo view) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(view.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        FilterItemCollection filterItemColl = view.getFilter().getFilterItems();
        FilterItemInfo filterItemInfo = null;
        int size = filterItemColl.size();
        for (int i = 0; i < size; ++i) {
            filterItemInfo = filterItemColl.get(i);
            String propName = filterItemInfo.getPropertyName();
            if (entityInfo.getPropertyByName(propName) == null) continue;
            filter.getFilterItems().add(filterItemInfo);
        }
        viewInfo.setFilter(filter);
        viewInfo.setSorter(view.getSorter());
        ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)entityName);
        CoreBaseCollection coreBaseColl = corebase.getCollection(viewInfo);
        return coreBaseColl;
    }

    private CoreBaseCollection getAddNewEmpPageData(Context ctx, String entityName, CoreBaseCollection existedEmpPageColl, EmployeeAuditCollection auditColl) throws BOSException {
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        int size = existedEmpPageColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(existedEmpPageColl.get(i).getId());
        }
        CoreBaseCollection addNewCollection = new CoreBaseCollection();
        int size2 = auditColl.size();
        for (int i = 0; i < size2; ++i) {
            if (idSet.contains(auditColl.get(i).getPk())) continue;
            Class clazz = MetaDataServerUtil.getObjectValueClass((Context)ctx, (String)entityName);
            try {
                CoreBaseInfo info = (CoreBaseInfo)clazz.newInstance();
                if (!StringUtils.isEmpty((String)entityName)) {
                    MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
                    EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
                    if (entityInfo.isDynamic() && info instanceof ICommonBOSType) {
                        ICommonBOSType commonObject = (ICommonBOSType)info;
                        commonObject.setBOSType(entityInfo.getType());
                        commonObject.setPK((IMetaDataPK)metaDataPK);
                    }
                }
                info.setId(auditColl.get(i).getPk());
                info.put("isOnlyInAuitedTable", (Object)"true");
                addNewCollection.add(info);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return addNewCollection;
    }

    private void assembleEmployeePageInfoWithAuditData(Context ctx, String entityName, CoreBaseInfo sourcePageInfo, EmployeeAuditCollection auditColl) throws BOSException {
        int size = auditColl.size();
        for (int i = 0; i < size; ++i) {
            EmployeeAuditInfo auditInfo = auditColl.get(i);
            if (!sourcePageInfo.getId().toString().equals(auditInfo.getPk().toString())) continue;
            EmployeeAuditEntryCollection entrys = auditInfo.getEntrys();
            int num = entrys.size();
            for (int j = 0; j < num; ++j) {
                EmployeeAuditEntryInfo entryInfo = entrys.get(j);
                try {
                    Map extendInfoMap;
                    EmployeePageAuditServerUtil.setModelField(ctx, sourcePageInfo, entryInfo, entityName);
                    if (sourcePageInfo instanceof EmpInfoSinglePageInfo || sourcePageInfo instanceof PersonInfo) {
                        extendInfoMap = this.getExtendInfoMap(auditInfo);
                        sourcePageInfo.put(entryInfo.getFieldName() + "_extendInfoMap", (Object)extendInfoMap);
                        continue;
                    }
                    extendInfoMap = this.getExtendInfoMap(auditInfo);
                    sourcePageInfo.put("extendInfoMap", (Object)extendInfoMap);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private Map getExtendInfoMap(EmployeeAuditInfo auditInfo) {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        extendInfoMap.put("status", (Object)auditInfo.getStatus());
        if (StringUtils.isEmpty((String)auditInfo.getReason())) {
            extendInfoMap.put("reason", "");
        } else {
            extendInfoMap.put("reason", auditInfo.getReason());
        }
        extendInfoMap.put("operateType", (Object)auditInfo.getOperateType());
        if (auditInfo.getAuditor() != null) {
            extendInfoMap.put("auditor", auditInfo.getAuditor().getName());
        } else {
            extendInfoMap.put("auditor", "");
        }
        extendInfoMap.put("id", auditInfo.getId());
        return extendInfoMap;
    }

    private ObjectUuidPK saveEmployeeSinglePageData(Context ctx, EmpAuditPageInfo auditPageInfo, CoreBaseInfo pageInfo, String empPageDataTypeId) throws BOSException, EASBizException {
        ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)auditPageInfo.getEntityName());
        PersonInfo newPerson = EmployeePageAuditServerUtil.getPersonInfo(pageInfo);
        PersonInfo sameperson = (PersonInfo)newPerson.clone();
        BOSUuid empPageId = null;
        CoreBaseInfo sourcePageInfo = null;
        OperateTypeEnum operateType = null;
        PersonOtherInfoInfo sourcePageOtherInfo = null;
        if (pageInfo.getId() != null) {
            empPageId = pageInfo.getId();
            CoreBaseCollection coll = corebase.getCollection("select * where id= '" + empPageId + "'");
            if (coll.size() > 0) {
                sourcePageInfo = coll.get(0);
                if ("com.kingdee.eas.basedata.person.app.Person".equals(auditPageInfo.getEntityName())) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)empPageId));
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSelector(sic);
                    PersonOtherInfoCollection otherColl = PersonOtherInfoFactory.getRemoteInstance().getPersonOtherInfoCollection(entityViewInfo);
                    if (otherColl != null && otherColl.size() > 0) {
                        sourcePageOtherInfo = otherColl.get(0);
                    }
                }
                operateType = OperateTypeEnum.UPDATE;
            } else {
                operateType = OperateTypeEnum.ADDNEW;
            }
        } else {
            System.out.println("=========EmployeeAuditControllerBean pageInfo BOSType start============");
            System.out.println(pageInfo.getBOSType().toString());
            System.out.println("=========EmployeeAuditControllerBean pageInfo BOSType end============");
            empPageId = BOSUuid.create((BOSObjectType)pageInfo.getBOSType());
            empPageId = BOSUuid.create((BOSObjectType)pageInfo.getBOSType());
            operateType = OperateTypeEnum.UPDATE;
        }
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        List fieldName = auditPageInfo.getFiledName();
        HashMap propMap = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int size = fieldName.size();
        for (int i = 0; i < size; ++i) {
            EmployeeAuditEntryCollection entryColl = new EmployeeAuditEntryCollection();
            EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx, auditPageInfo, pageInfo, empPageId, empPageDataTypeId);
            propMap = (HashMap)fieldName.get(i);
            Map.Entry entry = propMap.entrySet().iterator().next();
            String propName = (String)entry.getKey();
            String propAlias = (String)entry.getValue() + "\uff1a";
            if (propName.equals("globalRoaming") || propName.equals("nCell")) {
                map.put(propName, propAlias);
                continue;
            }
            this.dowithPersonOtherFields(ctx, propName, pageInfo);
            if (sourcePageInfo != null) {
                Object tarValue;
                Object srcValue = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)sourcePageInfo, (String)propName);
                if (null == srcValue && propName.contains("ext") && null != (srcValue = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)sourcePageOtherInfo, (String)propName.substring(4))) && srcValue instanceof Date) {
                    srcValue = srcValue.toString();
                }
                if (CompareUtil.compareValue((Object)srcValue, (Object)(tarValue = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)pageInfo, (String)propName))) || null == propName) continue;
                if (propName.contains("ext")) {
                    auditInfo.setDescBefore(propAlias + EmployeePageAuditServerUtil.getValueDescription(ctx, sourcePageOtherInfo, propName.substring(4)));
                } else {
                    auditInfo.setDescBefore(propAlias + EmployeePageAuditServerUtil.getValueDescription(ctx, sourcePageInfo, propName));
                }
                auditInfo.setDescAfter(propAlias + EmployeePageAuditServerUtil.getValueDescription(ctx, pageInfo, propName));
                auditInfo.setOperateType(operateType);
                EmployeeAuditEntryInfo entryInfo = EmployeePageAuditServerUtil.assembleAuditEntryInfo(auditInfo, propName, pageInfo.get(propName));
                entryColl.add(entryInfo);
                CoreBaseObjectUtil.setValue((Context)ctx, (CoreBaseInfo)pageInfo, (String)propName, (Object)srcValue);
                sameperson.put(propName, pageInfo.get(propName));
            } else {
                auditInfo.setDescBefore(propAlias + "");
                auditInfo.setDescAfter(propAlias + EmployeePageAuditServerUtil.getValueDescription(ctx, pageInfo, propName));
                auditInfo.setOperateType(operateType);
                EmployeeAuditEntryInfo entryInfo = EmployeePageAuditServerUtil.assembleAuditEntryInfo(auditInfo, propName, pageInfo.get(propName));
                entryColl.add(entryInfo);
                pageInfo.put(propName, null);
            }
            auditInfo.put("entrys", (Object)entryColl);
            iEmployeeAudit.addnew((CoreBaseInfo)auditInfo);
        }
        if (!map.isEmpty()) {
            String nCell;
            EmployeeAuditEntryCollection entryColl = new EmployeeAuditEntryCollection();
            String descBefore = nCell = (String)map.get("nCell");
            String descAfter = nCell;
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx, auditPageInfo, pageInfo, empPageId, empPageDataTypeId);
                EmployeeAuditEntryInfo entryInfo = EmployeePageAuditServerUtil.assembleAuditEntryInfo(auditInfo, key, pageInfo.get(key));
                entryColl.add(entryInfo);
                descBefore = descBefore + EmployeePageAuditServerUtil.getValueDescription(ctx, sourcePageInfo, key) + "-";
                descAfter = descAfter + EmployeePageAuditServerUtil.getValueDescription(ctx, pageInfo, key) + "-";
                pageInfo.put(key, EmployeePageAuditServerUtil.getValueDescription(ctx, sourcePageInfo, key));
            }
            if (!(StringUtils.isEmpty((String)descBefore) && StringUtils.isEmpty((String)descAfter) || descBefore.equals(descAfter))) {
                EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx, auditPageInfo, pageInfo, empPageId, empPageDataTypeId);
                auditInfo.setDescBefore(descBefore.substring(0, descBefore.length() - 1));
                auditInfo.setDescAfter(descAfter.substring(0, descAfter.length() - 1));
                auditInfo.setOperateType(operateType);
                auditInfo.put("entrys", (Object)entryColl);
                iEmployeeAudit.addnew((CoreBaseInfo)auditInfo);
            }
        }
        pageInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
        System.out.println("=========EmployeeAuditControllerBean pageInfo id============" + empPageId + " aaa");
        pageInfo.setId(empPageId);
        if (pageInfo instanceof PersonInfo || pageInfo instanceof PersonPositionInfo) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("id", pageInfo.getId().toString());
            param.put("selector", "id,effdt");
            CoreBaseInfo result = (CoreBaseInfo)OSFAppUtil.callService((Context)ctx, (String)"getValueByUuid", param);
            pageInfo.put("effdt", result.get("effdt"));
        }
        if (pageInfo instanceof PersonInfo) {
            ServiceStateManager.getInstance().enableNextCallServices();
        }
        corebase.save(pageInfo);
        this.doWhthPersonOtherInfo(ctx, sameperson, null, false);
        return new ObjectUuidPK(pageInfo.getId().toString());
    }

    private void dowithPersonOtherFields(Context ctx, String propName, CoreBaseInfo pageInfo) throws EASBizException, BOSException, UuidException {
        if (!propName.contains("ext_")) {
            return;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.emp.app.PersonOtherInfo"));
        PropertyInfo property = entityInfo.getPropertyByName(propName.replaceAll("ext_", ""));
        if (property instanceof LinkPropertyInfo) {
            if (pageInfo.get(propName) instanceof String) {
                CoreBaseInfo value = EmployeePageAuditServerUtil.getValue(ctx, pageInfo.get(propName).toString());
                pageInfo.put(propName, (Object)value);
            }
        } else if (property instanceof OwnPropertyInfo && ((OwnPropertyInfo)property).getDataType() == DataType.BOOLEAN) {
            Boolean value = TypeConversionUtils.objToBoolean((Object)pageInfo.get(propName));
            pageInfo.put(propName, (Object)value);
        }
    }

    private IObjectPK saveEmployeeMultiPageData(Context ctx, EmpAuditPageInfo auditPageInfo, CoreBaseInfo pageInfo, String empPageDataTypeId) throws BOSException, EASBizException {
        ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)auditPageInfo.getEntityName());
        BOSUuid empPageId = null;
        CoreBaseInfo sourcePageInfo = null;
        OperateTypeEnum operateType = null;
        if (pageInfo.getId() != null) {
            empPageId = pageInfo.getId();
            CoreBaseCollection coll = null;
            coll = pageInfo instanceof PersonCertifyCompetencyInfo ? corebase.getCollection("select *,certifiedCompetency.category.name,certifiedCompetency.level.name where id= '" + empPageId + "'") : (pageInfo instanceof PersonTechnicalPostInfo ? corebase.getCollection("select *,technicalPost.category.name,technicalPost.level.name where id= '" + empPageId + "'") : corebase.getCollection("select * where id= '" + empPageId + "'"));
            if (coll.size() > 0) {
                EmpInfoMultiPageInfo pInfo;
                sourcePageInfo = coll.get(0);
                if (sourcePageInfo instanceof PersonCertifyCompetencyInfo) {
                    pInfo = (PersonCertifyCompetencyInfo)sourcePageInfo;
                    if (pInfo.getCertifiedCompetency() != null && pInfo.getCertifiedCompetency().getCategory() != null) {
                        sourcePageInfo.put("certifiedCompetency.category.name", (Object)pInfo.getCertifiedCompetency().getCategory().getName());
                    }
                    if (pInfo.getCertifiedCompetency() != null && pInfo.getCertifiedCompetency().getLevel() != null) {
                        sourcePageInfo.put("certifiedCompetency.level.name", (Object)pInfo.getCertifiedCompetency().getLevel().getName());
                    }
                } else if (sourcePageInfo instanceof PersonTechnicalPostInfo) {
                    pInfo = (PersonTechnicalPostInfo)sourcePageInfo;
                    if (pInfo.getTechnicalPost().getCategory() != null) {
                        sourcePageInfo.put("technicalPost.category.name", (Object)pInfo.getTechnicalPost().getCategory().getName());
                    }
                    if (pInfo.getTechnicalPost().getLevel() != null) {
                        sourcePageInfo.put("technicalPost.level.name", (Object)pInfo.getTechnicalPost().getLevel().getName());
                    }
                }
                operateType = OperateTypeEnum.UPDATE;
            } else {
                operateType = OperateTypeEnum.ADDNEW;
            }
        } else {
            empPageId = BOSUuid.create((BOSObjectType)pageInfo.getBOSType());
            operateType = OperateTypeEnum.ADDNEW;
        }
        BOSObjectType bosType = pageInfo.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        List fieldName = auditPageInfo.getFiledName();
        EmployeeAuditEntryCollection entryColl = new EmployeeAuditEntryCollection();
        HashMap propMap = null;
        EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx, auditPageInfo, pageInfo, empPageId, empPageDataTypeId);
        StringBuffer sourceDesc = new StringBuffer();
        StringBuffer changeDesc = new StringBuffer();
        boolean isDifferent = false;
        int size = fieldName.size();
        for (int i = 0; i < size; ++i) {
            propMap = (HashMap)fieldName.get(i);
            Map.Entry entry = propMap.entrySet().iterator().next();
            String propName = (String)entry.getKey();
            if (sourcePageInfo != null) {
                Object tarVal;
                Object srcVal = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)sourcePageInfo, (String)propName);
                if (!CompareUtil.compareValue((Object)srcVal, (Object)(tarVal = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)pageInfo, (String)propName)))) {
                    isDifferent = true;
                    sourceDesc.append(EmployeePageAuditServerUtil.getFieldDescription(ctx, (String)entry.getValue(), sourcePageInfo, propName, true));
                    changeDesc.append(EmployeePageAuditServerUtil.getFieldDescription(ctx, (String)entry.getValue(), pageInfo, propName, true));
                } else {
                    sourceDesc.append(EmployeePageAuditServerUtil.getFieldDescription(ctx, (String)entry.getValue(), sourcePageInfo, propName, false));
                    changeDesc.append(EmployeePageAuditServerUtil.getFieldDescription(ctx, (String)entry.getValue(), pageInfo, propName, false));
                }
            } else if (null != propName) {
                isDifferent = true;
                Object tarVal = pageInfo.get(propName);
                changeDesc.append((String)entry.getValue()).append("\uff1a").append(EmployeePageAuditServerUtil.getValueDescription(ctx, pageInfo, propName)).append("\uff1b");
            }
            EmployeeAuditEntryInfo entryInfo = EmployeePageAuditServerUtil.assembleAuditEntryInfo(auditInfo, propName, pageInfo.get(propName));
            entryColl.add(entryInfo);
        }
        if (isDifferent) {
            auditInfo.put("entrys", (Object)entryColl);
            auditInfo.setDescBefore(sourceDesc.toString());
            auditInfo.setDescAfter(changeDesc.toString());
            auditInfo.setOperateType(operateType);
            EmployeeAuditFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)auditInfo);
        }
        return new ObjectUuidPK(auditInfo.getPk().toString());
    }

    private void deleteExistAuditData(Context ctx, String personId, String entityName, String pageId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("category.entityInfoSet.entityName", (Object)entityName));
        filterItemColl.add(new FilterItemInfo("status", (Object)1));
        filterItemColl.add(new FilterItemInfo("person.id", (Object)personId));
        filterItemColl.add(new FilterItemInfo("pk", (Object)pageId));
        filter.setMaskString("#0 and #1 and #2 and #3");
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        iEmployeeAudit.delete(filter);
    }

    private EmployeeAuditCollection getConfirmData(Context ctx, String personId, String entityName, String pageId) throws BOSException, EASBizException {
        EntityViewInfo auditViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection auditSelector = new SelectorItemCollection();
        auditSelector.add(new SelectorItemInfo("id"));
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("category.entityInfoSet.entityName", (Object)entityName));
        filterItemColl.add(new FilterItemInfo("status", (Object)3));
        filterItemColl.add(new FilterItemInfo("confirmStatus", (Object)false));
        filterItemColl.add(new FilterItemInfo("person.id", (Object)personId));
        filterItemColl.add(new FilterItemInfo("pk", (Object)pageId));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        auditViewInfo.setFilter(filter);
        auditViewInfo.setSelector(auditSelector);
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        EmployeeAuditCollection collection = iEmployeeAudit.getEmployeeAuditCollection(auditViewInfo);
        return collection;
    }

    private EmployeeAuditInfo assembleBaseAuditInfo(Context ctx, EmpAuditPageInfo auditPageInfo, CoreBaseInfo pageInfo, BOSUuid empPageId, String empPageDataTypeId) throws EASBizException, BOSException {
        PersonInfo personInfo = EmployeePageAuditServerUtil.getPersonInfo(pageInfo);
        EmployeePageDataSetInfo pageDataSetInfo = this.getEmployeePageDataSetInfo(ctx, auditPageInfo, empPageDataTypeId);
        EmployeeAuditInfo auditInfo = new EmployeeAuditInfo();
        auditInfo.setId(BOSUuid.create((BOSObjectType)auditInfo.getBOSType()));
        auditInfo.setCategory(pageDataSetInfo);
        auditInfo.setPerson(personInfo);
        auditInfo.setSaveTime(DateTimeUtils.truncateDate((Date)new Date()));
        auditInfo.setEntity(auditPageInfo.getEntityName());
        auditInfo.setPk(empPageId);
        auditInfo.setStatus(EmployeeAuditStateEnum.SUBMITED);
        auditInfo.setConfirmStatus(false);
        return auditInfo;
    }

    private EmployeePageDataSetInfo getEmployeePageDataSetInfo(Context ctx, EmpAuditPageInfo auditPageInfo, String empPageDataTypeId) throws BOSException, EASBizException {
        IEmployeePageDataSet iEmployeePageDataSet = EmployeePageDataSetFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("entityInfoSet.id"));
        sic.add(new SelectorItemInfo("empPageDataType.id"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityInfoSet.entityName", (Object)auditPageInfo.getEntityName(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("empPageDataType.id", (Object)empPageDataTypeId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        EmployeePageDataSetCollection collection = iEmployeePageDataSet.getEmployeePageDataSetCollection(entityViewInfo);
        if (collection.size() == 0) {
            throw new EmployeeException(EmployeeException.WRONG_EMPLOYEE_PAGE_DATA);
        }
        if (collection.size() > 1) {
            throw new EmployeeException(EmployeeException.TOO_MANY_ENTITY_CONFIG, new Object[]{collection.toString()});
        }
        return collection.get(0);
    }

    private EmployeeAuditInfo getEmployeeAuditInfo(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException, EASBizException {
        String oql = "select *,entrys.* where id='" + auditInfo.getId() + "'";
        if (!EmployeeAuditFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(auditInfo.getId()))) {
            throw new EmployeeException(EmployeeException.AUDITITEMCANNOTFIND);
        }
        EmployeeAuditInfo curAuditInfo = EmployeeAuditFactory.getLocalInstance(ctx).getEmployeeAuditInfo(oql);
        return curAuditInfo;
    }

    private void doWhthPersonOtherInfo(Context ctx, PersonInfo info, String fieldName, boolean isAudit) throws BOSException, EASBizException {
        PersonOtherInfoInfo otherInfo = this.getPersonOtherInfoInfo(ctx, info);
        if (otherInfo == null) {
            otherInfo = new PersonOtherInfoInfo();
            otherInfo.setPerson(info);
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).addnew(otherInfo);
        } else {
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(otherInfo.getId().toString()), otherInfo);
        }
        if (!isAudit || !StringUtils.isEmpty((String)fieldName) && ("idCardNO".equals(fieldName) || "passportNO".equals(fieldName) || "ext_countryRegion".equals(fieldName) || "ext_credentialsType".equals(fieldName))) {
            SelectorItemCollection personSelector = new SelectorItemCollection();
            personSelector.add(new SelectorItemInfo("idCardNO"));
            personSelector.add(new SelectorItemInfo("passportNO"));
            personSelector.add(new SelectorItemInfo("id"));
            PersonInfo personOldInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), personSelector);
            String personOldIdCard = personOldInfo.getIdCardNO();
            String personOldPassport = personOldInfo.getPassportNO();
            if (!info.containsKey("countryRegion")) {
                info.put("countryRegion", (Object)(otherInfo.getCountryRegion() != null ? otherInfo.getCountryRegion().getId().toString() : ""));
            }
            if (!info.containsKey("credentialsType")) {
                info.put("credentialsType", (Object)(otherInfo.getCredentialsType() != null ? otherInfo.getCredentialsType().getId().toString() : ""));
            }
            if (!info.containsKey("idCardNO")) {
                info.put("idCardNO", (Object)personOldIdCard);
            }
            if (!info.containsKey("passportNO")) {
                info.put("passportNO", (Object)personOldPassport);
            }
            if (logger.isInfoEnabled()) {
                logger.error((Object)("EmployeeAuditControllerBean.doWhthPersonOtherInfo: " + info.get("countryRegion") + "," + info.get("credentialsType") + "," + info.get("idCardNO") + "," + info.get("passportNO")));
            }
            SHREmpCheckCredentialsTypeUtil.checkCredentiaslTypeForEmp(ctx, (CoreBaseInfo)info, info.getId().toString());
            SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPerson(ctx, info, (CoreBaseInfo)info);
        }
    }

    private PersonOtherInfoInfo getPersonOtherInfoInfo(Context ctx, PersonInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.birthday"));
        selector.add(new SelectorItemInfo("age"));
        selector.add(new SelectorItemInfo("countryRegion"));
        selector.add(new SelectorItemInfo("credentialsType"));
        IPersonOtherInfo iPersonOtherInfo = PersonOtherInfoFactory.getLocalInstance(ctx);
        PersonOtherInfoCollection coll = iPersonOtherInfo.getPersonOtherInfoCollection(viewInfo);
        PersonOtherInfoInfo otherInfo = null;
        if (coll.size() > 0) {
            otherInfo = coll.get(0);
        }
        return otherInfo;
    }

    private void assemblePersonOtherInfo(Context ctx, PersonInfo personInfo, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        String entityName = "com.kingdee.eas.hr.emp.app.PersonOtherInfo";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            String propName = propColl.get(i).getName();
            if (this.isPersonOtherInfoExcludeField(propName) || !personInfo.containsKey("ext_" + propName)) continue;
            if (propName.equalsIgnoreCase("zodiac") && personInfo.get("ext_zodiac") != null) {
                ZodiacInfo z = new ZodiacInfo();
                if (personInfo.get("ext_zodiac") instanceof ZodiacInfo) {
                    z = (ZodiacInfo)personInfo.get("ext_zodiac");
                } else {
                    z.setId(BOSUuid.read((String)personInfo.get("ext_zodiac").toString()));
                }
                otherInfo.put(propColl.get(i).getName(), z);
                continue;
            }
            if (propName.equalsIgnoreCase("constellation") && personInfo.get("ext_constellation") != null && !"".equals(personInfo.get("ext_constellation"))) {
                ConstellationInfo c = new ConstellationInfo();
                if (personInfo.get("ext_constellation") instanceof ConstellationInfo) {
                    c = (ConstellationInfo)personInfo.get("ext_constellation");
                } else {
                    c.setId(BOSUuid.read((String)personInfo.get("ext_constellation").toString()));
                }
                otherInfo.put(propColl.get(i).getName(), c);
                continue;
            }
            if (propName.equalsIgnoreCase("countryRegion") && personInfo.get("ext_countryRegion") != null && !"".equals(personInfo.get("ext_countryRegion"))) {
                CountryRegionInfo country = new CountryRegionInfo();
                if (personInfo.get("ext_countryRegion") instanceof CountryRegionInfo) {
                    country = (CountryRegionInfo)personInfo.get("ext_countryRegion");
                } else {
                    country.setId(BOSUuid.read((String)personInfo.get("ext_countryRegion").toString()));
                }
                otherInfo.put(propColl.get(i).getName(), country);
                continue;
            }
            if (propName.equalsIgnoreCase("credentialsType") && personInfo.get("ext_credentialsType") != null && !"".equals(personInfo.get("ext_credentialsType"))) {
                CredentialsTypeInfo creType = new CredentialsTypeInfo();
                if (personInfo.get("ext_credentialsType") instanceof CredentialsTypeInfo) {
                    creType = (CredentialsTypeInfo)personInfo.get("ext_credentialsType");
                } else {
                    creType.setId(BOSUuid.read((String)personInfo.get("ext_credentialsType").toString()));
                }
                otherInfo.put(propColl.get(i).getName(), creType);
                continue;
            }
            otherInfo.put(propColl.get(i).getName(), personInfo.get("ext_" + propName));
        }
        otherInfo.setPerson(personInfo);
        otherInfo.setEFFDT(personInfo.getEFFDT());
        if (personInfo.getBirthday() != null) {
            this.calculateAge(personInfo, otherInfo);
        }
        if (otherInfo.getSocialServiceYears() == 0.0 && otherInfo.getJobStartDate() != null) {
            this.calculateSocialServiceYears(ctx, otherInfo);
        } else if (otherInfo.containsKey("jobStartDate") && otherInfo.getJobStartDate() == null) {
            otherInfo.setSocialServiceYears(0.0);
        }
        if (personInfo.getBirthday() != null && (otherInfo.getZodiac() == null || otherInfo.getConstellation() == null)) {
            try {
                Map<String, String> map = EMPhelper.getConZocByBirthDay(ctx, personInfo.getBirthday());
                if (map.get("zodiacId") != null && otherInfo.getZodiac() == null) {
                    ZodiacInfo z = new ZodiacInfo();
                    z.setId(BOSUuid.read((String)map.get("zodiacId")));
                    otherInfo.setZodiac(z);
                }
                if (map.get("constellationId") != null && otherInfo.getConstellation() == null) {
                    ConstellationInfo c = new ConstellationInfo();
                    c.setId(BOSUuid.read((String)map.get("constellationId")));
                    otherInfo.setConstellation(c);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (personInfo.getBirthday() != null) {
            String[] birthDay = DateUtils.DateToString((Date)personInfo.getBirthday(), (String)"yyyy-MM-dd").split("-");
            otherInfo.setBornYear(Integer.valueOf(birthDay[0]));
            otherInfo.setBornMonth(Integer.valueOf(birthDay[1]));
            otherInfo.setBornDay(Integer.valueOf(birthDay[2]));
        } else {
            otherInfo.put("bornYear", null);
            otherInfo.put("bornMonth", null);
            otherInfo.put("bornDay", null);
        }
    }

    private void calculateAge(PersonInfo personInfo, PersonOtherInfoInfo otherInfo) {
        Date birthDate = personInfo.getBirthday();
        Date endDate = otherInfo.getDeathDate();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        int yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)birthDate);
        int tempValue = 0;
        int birthMonth = DateTimeUtils.getMonth((Date)birthDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int birthDay = DateTimeUtils.getDay((Date)birthDate);
        int endDay = DateTimeUtils.getDay((Date)endDate);
        tempValue = endMonth < birthMonth ? -1 : (endMonth > birthMonth ? 0 : (endDay < birthDay ? -1 : 0));
        otherInfo.setAge(yearValue + tempValue);
    }

    private void calculateSocialServiceYears(Context ctx, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        int monthValue;
        int yearValue;
        double workTime;
        Date beginDate = otherInfo.getJobStartDate();
        Date endDate = otherInfo.getRetireDate();
        double adjustValue = otherInfo.getAdjustSerVal();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        if ((workTime = (double)(yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) + (double)(monthValue = DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) / 12.0 - adjustValue) < 0.0) {
            workTime = 0.0;
        }
        workTime = SHRMathUtils.getRoundValueBySysParam((Context)ctx, (double)workTime);
        otherInfo.setSocialServiceYears(workTime);
    }

    private boolean isPersonOtherInfoExcludeField(String key) {
        return key.equals("id") || key.equals("person") || key.equals("hasBURelation");
    }
}

