/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexCollection;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeCompetIndexControllerBean;
import java.util.ArrayList;
import java.util.HashSet;

public class EmployeeCompetIndexControllerBean
extends AbstractEmployeeCompetIndexControllerBean {
    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection competCols, IObjectPK[] deletelist) throws BOSException, EASBizException {
        this.deleteList(ctx, deletelist);
        return this.addAndUpdate(ctx, (EmployeeCompetIndexCollection)competCols);
    }

    private IObjectPK[] addAndUpdate(Context ctx, EmployeeCompetIndexCollection competCols) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < competCols.size(); ++i) {
            if (competCols.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)competCols.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(competCols.get(i).getId()), (IObjectValue)competCols.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    private void checkDupCompetIndex(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeCompetIndexInfo info = (EmployeeCompetIndexInfo)model;
        String oql = "where person.id='" + info.getPerson().getId() + "' and empCompetIndex.id='" + info.getEmpCompetIndex().getId() + "'";
        if (info.getId() != null) {
            oql = oql + " and id <> '" + info.getId() + "'";
        }
        if (this._exists(ctx, oql)) {
            throw new EmployeeException(EmployeeException.EMP_EXIST_COMPETINDEX);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDupCompetIndex(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDupCompetIndex(ctx, model);
        super._update(ctx, pk, model);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        EmployeeCompetIndexInfo info = (EmployeeCompetIndexInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

