/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.hr.emp.ContractPartyAdminCollection;
import com.kingdee.eas.hr.emp.ContractPartyAdminFactory;
import com.kingdee.eas.hr.emp.ContractPartyAdminInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartySrcTypeEnum;
import com.kingdee.eas.hr.emp.app.AbstractLabContractFirstPartyControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class LabContractFirstPartyControllerBean
extends AbstractLabContractFirstPartyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.LabContractFirstPartyControllerBean");
    private final String SHRBASICITEMID = "emUEprDcRRqj+iK+jxgOxJNzh54=";
    private static final String SHARE_TYPE_NAME = "controlType";
    private String controlType = null;

    @Override
    protected void _importFromHrOrg(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            throw new EmployeeException(EmployeeException.HRORGUNIT_ID_IS_NULL);
        }
        HROrgUnitCollection hrOrgColl = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id, number, name, simpleName where id = '" + id + "'");
        if (hrOrgColl.size() == 0) {
            throw new EmployeeException(EmployeeException.HRORGUNIT_ID_NOT_EXIST, new Object[]{id});
        }
        HROrgUnitInfo hrOrgUnit = hrOrgColl.get(0);
        if (this.exists(ctx, "where sourceHrOrg = '" + id + "'")) {
            throw new EmployeeException(EmployeeException.HRORGUNIT_EXIST_IN_CONTRACTPARTY, new Object[]{hrOrgUnit.getName()});
        }
        LabContractFirstPartyInfo contractPartyInfo = new LabContractFirstPartyInfo();
        contractPartyInfo.setHrOrgUnit(hrOrgUnit);
        contractPartyInfo.setUsePolicy(UsePolicy.GLOBALLY_SHARED);
        contractPartyInfo.setNumber(hrOrgUnit.getNumber());
        contractPartyInfo.setName(hrOrgUnit.getName());
        contractPartyInfo.setSimpleName(hrOrgUnit.getSimpleName());
        contractPartyInfo.setIsSysPreset(false);
        contractPartyInfo.setState(BaseItemStateEnum.ENABLE);
        contractPartyInfo.setSourceType(LabContractFirstPartySrcTypeEnum.IMPORT);
        contractPartyInfo.setSourceHrOrg(hrOrgUnit);
        contractPartyInfo.setString("shrBasicItem", "emUEprDcRRqj+iK+jxgOxJNzh54=");
        IObjectPK pk = this.addnew(ctx, contractPartyInfo);
        this.enableOrgRefBaseInfo(ctx, contractPartyInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setContractPartyAdminLongNumber(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this.processIncludeSubordinates(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setContractPartyAdminLongNumber(ctx, model);
        super._update(ctx, pk, model);
        this.processIncludeSubordinates(ctx, model);
    }

    protected void _verifyData(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        super._verifyData(ctx, shrBaseItem);
        LabContractFirstPartyInfo info = (LabContractFirstPartyInfo)shrBaseItem;
        if (info.getName() != null) {
            info.setName(info.getName().trim());
            if (!StringUtils.isEmpty((String)info.getName())) {
                this.checkNameDup(ctx, (DataBaseInfo)info);
            }
        }
    }

    private void setContractPartyAdminLongNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LabContractFirstPartyInfo info = (LabContractFirstPartyInfo)model;
        ContractPartyAdminCollection partyAdmins = info.getPartyAdmins();
        for (int i = 0; i < partyAdmins.size(); ++i) {
            ContractPartyAdminInfo contractPartyAdminInfo = partyAdmins.get(i);
            AdminOrgUnitInfo adminOrg = contractPartyAdminInfo.getAdminOrg();
            if (adminOrg != null && adminOrg.getLongNumber() == null) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrg.getId().toString()));
                contractPartyAdminInfo.setAdminOrg(adminOrgUnitInfo);
                contractPartyAdminInfo.setLongNumber(adminOrgUnitInfo.getLongNumber());
            } else {
                contractPartyAdminInfo.setLongNumber(adminOrg.getLongNumber());
            }
            Date time = Date.getTimeInst();
            if (contractPartyAdminInfo.getId() == null) {
                contractPartyAdminInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                contractPartyAdminInfo.setCreateTime((Timestamp)time);
            }
            contractPartyAdminInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            contractPartyAdminInfo.setLastUpdateTime((Timestamp)time);
        }
    }

    private void processIncludeSubordinates(Context ctx, IObjectValue model) throws BOSException {
        LabContractFirstPartyInfo info = (LabContractFirstPartyInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("isContainLowerOrg"));
        selectorItemCollection.add(new SelectorItemInfo("longNumber"));
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty", (Object)info.getId().toString()));
        view.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
        sortInfo.setSortType(SortType.ASCEND);
        sorterItemCollection.add(sortInfo);
        view.setSorter(sorterItemCollection);
        ContractPartyAdminCollection contractPartyAdminCollection = ContractPartyAdminFactory.getLocalInstance(ctx).getContractPartyAdminCollection(view);
        for (int i = 0; i < contractPartyAdminCollection.size(); ++i) {
            ContractPartyAdminInfo contractPartyAdminInfo = contractPartyAdminCollection.get(i);
            if (!contractPartyAdminInfo.isIsContainLowerOrg()) continue;
            String deleteSql = "DELETE FROM T_HR_ContractPartyAdmin WHERE FLongNumber LIKE '" + contractPartyAdminInfo.getLongNumber() + "!%'";
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
    }
}

