/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.IEmpLaborRelation;
import com.kingdee.eas.hr.emp.IPersonOptFacade;
import com.kingdee.eas.hr.emp.IPersonPositionOptFacade;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.AbstractPersonDataSourceOptFacadeControllerBean;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpDoPersonCredentialsTypeUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonDataSourceOptFacadeControllerBean
extends AbstractPersonDataSourceOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonDataSourceOptFacadeControllerBean");
    private static final String ENTITY_NAME_PERSON = "com.kingdee.eas.basedata.person.app.Person";
    private static final String ENTITY_NAME_PERSONPOSITION = "com.kingdee.eas.hr.emp.app.PersonPosition";
    private static final String ENTITY_NAME_EMPLABORRELATION = "com.kingdee.eas.hr.base.app.EmpLaborRelation";
    private static final String PERSON_OPT_FACADE = "PersonOptFacadeLocalInstance";
    private static final String PERSON_POSITION_OPT_FACADE = "PersonPositionOptFacadeLocalInstance";
    private static final String EMP_LABOR_RELATION = "EmpLaborRelationLocalInstance";
    private Map<String, ICoreBase> entityICoreBase = null;
    private Map<String, IPersonOptFacade> PersonOptFacade = null;
    private Map<String, IPersonPositionOptFacade> PersonPositionOptFacade = null;
    private Map<String, IEmpLaborRelation> EmpLaborRelation = null;

    @Override
    protected void _saveDataSource(Context ctx, Map saveModels) throws BOSException, EASBizException {
        if (saveModels.containsKey(ENTITY_NAME_PERSON)) {
            PersonInfo personSave = (PersonInfo)saveModels.get(ENTITY_NAME_PERSON);
            personSave.setExtendedProperty("historyOperateState", "revise");
            PersonOptBaseInfo personOptBaseInfo = new PersonOptBaseInfo();
            personOptBaseInfo.setPerson(personSave);
            personOptBaseInfo.setFromInitialize(false);
            IPersonOptFacade PersonOptFacadeLocalInstance = this.getPersonOptFacadeInterface(ctx);
            PersonOptFacadeLocalInstance.personUpdate(personSave.getEFFDT(), personOptBaseInfo);
            this.checkAndSetCredentialsType(ctx, personSave);
            saveModels.remove(ENTITY_NAME_PERSON);
        }
        if (saveModels.containsKey(ENTITY_NAME_PERSONPOSITION)) {
            PersonPositionInfo ppInfo = (PersonPositionInfo)saveModels.get(ENTITY_NAME_PERSONPOSITION);
            IPersonPositionOptFacade PersonPositionOptFacadeLocalInstance = this.getPersonPositionOptFacadeInterface(ctx);
            PersonPositionOptFacadeLocalInstance.updatePersonPositionWithRelatedData((IObjectValue)ppInfo, null);
            saveModels.remove(ENTITY_NAME_PERSONPOSITION);
        }
        if (saveModels.containsKey(ENTITY_NAME_EMPLABORRELATION)) {
            EmpLaborRelationInfo elrInfo = (EmpLaborRelationInfo)saveModels.get(ENTITY_NAME_EMPLABORRELATION);
            IEmpLaborRelation EmpLaborRelationLocalInstance = this.getEmpLaborRelationInterface(ctx);
            EmpLaborRelationLocalInstance.updateCurrentAndHisByCareer((IObjectPK)new ObjectUuidPK(elrInfo.getId()), elrInfo);
            saveModels.remove(ENTITY_NAME_EMPLABORRELATION);
        }
        this.saveModelDatas(ctx, saveModels);
    }

    private void saveModelDatas(Context ctx, Map saveModels) throws EASBizException, BOSException {
        Iterator iter = saveModels.entrySet().iterator();
        ICoreBase coreBase = null;
        String tempEntityFullName = null;
        try {
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                tempEntityFullName = (String)entry.getKey();
                CoreBaseInfo corebaseInfo = (CoreBaseInfo)entry.getValue();
                if (ENTITY_NAME_PERSON.equals(tempEntityFullName)) {
                    corebaseInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
                }
                coreBase = this.getEntityInterface(ctx, tempEntityFullName);
                coreBase.save(corebaseInfo);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    private ICoreBase getEntityInterface(Context ctx, String entityName) throws BOSException {
        ICoreBase coreBase;
        if (this.entityICoreBase == null) {
            this.entityICoreBase = new HashMap<String, ICoreBase>();
        }
        if ((coreBase = this.entityICoreBase.get(entityName)) == null) {
            MetaDataPK entityPK = MetaDataPK.create((String)entityName);
            coreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)entityPK);
            this.entityICoreBase.put(entityName, coreBase);
        }
        return coreBase;
    }

    private IPersonOptFacade getPersonOptFacadeInterface(Context ctx) throws BOSException {
        IPersonOptFacade PersonOptFacadeLocalInstance;
        if (this.PersonOptFacade == null) {
            this.PersonOptFacade = new HashMap<String, IPersonOptFacade>();
        }
        if ((PersonOptFacadeLocalInstance = this.PersonOptFacade.get(PERSON_OPT_FACADE)) == null) {
            PersonOptFacadeLocalInstance = PersonOptFacadeFactory.getLocalInstance(ctx);
            this.PersonOptFacade.put(PERSON_OPT_FACADE, PersonOptFacadeLocalInstance);
        }
        return PersonOptFacadeLocalInstance;
    }

    private IPersonPositionOptFacade getPersonPositionOptFacadeInterface(Context ctx) throws BOSException {
        IPersonPositionOptFacade PersonPositionOptFacadeLocalInstance;
        if (this.PersonPositionOptFacade == null) {
            this.PersonPositionOptFacade = new HashMap<String, IPersonPositionOptFacade>();
        }
        if ((PersonPositionOptFacadeLocalInstance = this.PersonPositionOptFacade.get(PERSON_POSITION_OPT_FACADE)) == null) {
            PersonPositionOptFacadeLocalInstance = PersonPositionOptFacadeFactory.getLocalInstance(ctx);
            this.PersonPositionOptFacade.put(PERSON_POSITION_OPT_FACADE, PersonPositionOptFacadeLocalInstance);
        }
        return PersonPositionOptFacadeLocalInstance;
    }

    private IEmpLaborRelation getEmpLaborRelationInterface(Context ctx) throws BOSException {
        IEmpLaborRelation EmpLaborRelationLocalInstance;
        if (this.EmpLaborRelation == null) {
            this.EmpLaborRelation = new HashMap<String, IEmpLaborRelation>();
        }
        if ((EmpLaborRelationLocalInstance = this.EmpLaborRelation.get(EMP_LABOR_RELATION)) == null) {
            EmpLaborRelationLocalInstance = EmpLaborRelationFactory.getLocalInstance((Context)ctx);
            this.EmpLaborRelation.put(EMP_LABOR_RELATION, EmpLaborRelationLocalInstance);
        }
        return EmpLaborRelationLocalInstance;
    }

    protected void checkAndSetCredentialsType(Context ctx, PersonInfo personInfo) throws EASBizException, BOSException {
        if (!personInfo.containsKey("credentialsType") && personInfo.get("credentialsType") == null && !StringUtils.isEmpty((String)personInfo.getPassportNO())) {
            String oql = "select credentialsType,credentialsType.name where person = '" + personInfo.getId() + "'";
            PersonOtherInfoInfo otherInfo = PersonOtherInfoFactory.getLocalInstance(ctx).getPersonOtherInfoInfo(oql);
            if (otherInfo != null && otherInfo.getCredentialsType() != null) {
                personInfo.put("credentialsType", (Object)otherInfo.getCredentialsType().getId().toString());
            } else {
                personInfo.put("credentialsType", (Object)"DKku/T51SlSsPipwUmJ8WVlu4mQ=");
            }
        }
        SHREmpCheckCredentialsTypeUtil.checkCredentiaslTypeForEmp(ctx, (CoreBaseInfo)personInfo, personInfo.getId().toString());
        SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPerson(ctx, personInfo, (CoreBaseInfo)personInfo);
    }
}

