/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.CheckStateEnum;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonWorkExpCurControllerBean;
import com.kingdee.eas.hr.emp.app.IWorkExpExtend;
import com.kingdee.eas.hr.emp.app.WorkExpExtendDecorator;
import com.kingdee.eas.hr.kt.CadreWorkExpCurFactory;
import com.kingdee.eas.hr.kt.ICadreWorkExpCur;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class PersonWorkExpCurControllerBean
extends AbstractPersonWorkExpCurControllerBean {
    @Override
    protected IObjectCollection _getRecordsByPerson(Context ctx, BOSUuid personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.getPersonWorkExpCurCollection(ctx, evi);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonWorkExpCurCollection workExpColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        Object workExpId = null;
        for (int i = 0; i < workExpColl.size(); ++i) {
            if (workExpColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)workExpColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(workExpColl.get(i).getId()), (IObjectValue)workExpColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection records, IObjectPK[] deleteList) throws EASBizException, BOSException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PersonWorkExpCurCollection)records);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonWorkExpCurInfo info = (PersonWorkExpCurInfo)model;
        IObjectPK workExpId = null;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getChekState() == null) {
            info.setChekState(CheckStateEnum.NO_CHECK);
        }
        workExpId = super._addnew(ctx, (IObjectValue)info);
        IWorkExpExtend extend = this.getWorkExpExtend();
        if (extend != null) {
            extend.addNew(ctx, (IObjectValue)info);
        }
        return workExpId;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonWorkExpCurInfo info = (PersonWorkExpCurInfo)model;
        if (info.getChekState() == null) {
            info.setChekState(CheckStateEnum.NO_CHECK);
        }
        super._update(ctx, pk, model);
    }

    protected IWorkExpExtend getWorkExpExtend() {
        return WorkExpExtendDecorator.getInstance();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICadreWorkExpCur icadreWorkExp = CadreWorkExpCurFactory.getLocalInstance((Context)ctx);
        icadreWorkExp.delete("where personWork.id='" + pk + "'");
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonWorkExpCurInfo info = (PersonWorkExpCurInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

