/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.app.AbstractZYDPersonFixControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class ZYDPersonFixControllerBean
extends AbstractZYDPersonFixControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.ZYDPersonFixControllerBean");

    @Override
    protected void _fixed(Context ctx) throws BOSException, EASBizException {
        Date date = new Date();
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        String deleteSql = "delete from T_HR_ZYDPersonFix where FMonth = " + month + " and FYear = " + year;
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String view = null;
        String insert = null;
        view = this.getStatSql(ctx, true, false, false);
        insert = this.getInsertSql(ctx, true, false, year, month, 0, view);
        DbUtil.execute((Context)ctx, (String)insert);
        view = this.getStatSql(ctx, false, false, true);
        insert = this.getInsertSql(ctx, false, false, year, month, 0, view);
        DbUtil.execute((Context)ctx, (String)insert);
        view = this.getStatSql(ctx, false, false, false);
        insert = this.getInsertSql(ctx, false, false, year, month, 1, view);
        DbUtil.execute((Context)ctx, (String)insert);
        this.insertOrgData(ctx, true, year, month);
        this.insertOrgData(ctx, false, year, month);
    }

    private void insertOrgData(Context ctx, boolean isEmpType, int year, int month) throws BOSException, EASBizException {
        int longNumberLen = HRParamUtil.getTreeLongNumberLen((Context)ctx);
        String createTempTable = "create Table Temp_ZYDPERSONFIX(FOrgId VARCHAR(44) NOT NULL,FLongNumber NVARCHAR(" + longNumberLen + "),FType VARCHAR(44),FCount  INT DEFAULT 0) ";
        String tempTable = null;
        String tempTableToUpdate = null;
        String view = null;
        String insert = null;
        view = this.getStatSql(ctx, false, true, isEmpType);
        int dbType = -1;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTable = pool.createTempTable(createTempTable);
            tempTableToUpdate = pool.createTempTable(createTempTable);
            if (!StringUtils.isEmpty((String)tempTable) && !StringUtils.isEmpty((String)tempTableToUpdate)) {
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FOrgId,FLongNumber,FType,FCount) " + view));
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTableToUpdate + "(FOrgId,FLongNumber,FType,FCount) select FOrgId,FLongNumber,FType,FCount from " + tempTable));
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update ");
                updateSql.append(tempTableToUpdate);
                updateSql.append(" set FCount = ");
                updateSql.append(" (");
                updateSql.append("  select sum(T.Fcount) from ");
                updateSql.append(tempTable);
                updateSql.append("  AS T ");
                updateSql.append("  where (T.FOrgId = ");
                updateSql.append(tempTableToUpdate);
                updateSql.append(".FOrgId ");
                if (1 == dbType) {
                    updateSql.append(" or CHARINDEX(CONCAT(");
                    updateSql.append(tempTableToUpdate);
                    updateSql.append(".FLongNumber,'!'),T.FLongNumber)=1)");
                } else {
                    updateSql.append(" or T.FLongNumber like CONCAT(");
                    updateSql.append(tempTableToUpdate);
                    updateSql.append(".FLongNumber,'!%'))");
                }
                updateSql.append(" and T.FType = ");
                updateSql.append(tempTableToUpdate);
                updateSql.append(".FType");
                updateSql.append(" )");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                view = "select FOrgId,FType,FCount from " + tempTableToUpdate;
                insert = isEmpType ? this.getInsertSql(ctx, false, true, year, month, 0, view) : this.getInsertSql(ctx, false, true, year, month, 1, view);
                DbUtil.execute((Context)ctx, (String)insert);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                pool.releaseTable(tempTable);
            }
            if (!StringUtils.isEmpty(tempTableToUpdate)) {
                pool.releaseTable(tempTableToUpdate);
            }
        }
    }

    private String getInsertSql(Context ctx, boolean isAll, boolean isAdmin, int year, int month, int category, String view) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_HR_ZYDPersonFix(fid,FYear,FMonth,");
        if (!isAll) {
            if (isAdmin) {
                insertSql.append("FOrgId,");
            }
            insertSql.append(" FType,");
        }
        insertSql.append(" FCount,FCategory) ");
        insertSql.append(" select newbosid('54B8ADAD') as fid,");
        insertSql.append(year);
        insertSql.append(" as FYear,");
        insertSql.append(month);
        insertSql.append(" as FMonth,");
        if (!isAll) {
            if (isAdmin) {
                insertSql.append("T.FOrgId as FOrgId,");
            }
            insertSql.append(" T.FType as FType,");
        }
        insertSql.append(" T.FCount as FCount,");
        insertSql.append(category);
        insertSql.append(" as FCategory ");
        insertSql.append(" from ( ");
        insertSql.append(view);
        insertSql.append(" ) as T ");
        return insertSql.toString();
    }

    private String getStatSql(Context ctx, boolean isAll, boolean isAdmin, boolean isEmpType) {
        StringBuffer statSql = new StringBuffer();
        statSql.append(" select ");
        if (!isAll) {
            if (isAdmin) {
                statSql.append("  a.fid as FOrgId,a.FLongNumber as FLongNumber, ");
            }
            if (isEmpType) {
                statSql.append(" p.femployeetypeid ");
            } else {
                statSql.append(" p.femployeeclassifyid ");
            }
            statSql.append(" as FType, ");
        }
        statSql.append(" count(*) as FCount ");
        statSql.append(" from t_bd_person p ");
        statSql.append(" inner join t_hr_personposition pp on p.fid = pp.fpersonid  ");
        statSql.append(" inner join t_org_admin a on a.fid = pp.fpersondep ");
        if (!isAll) {
            if (isEmpType) {
                statSql.append(" where p.femployeetypeid is not null");
            } else {
                statSql.append(" where p.femployeeclassifyid is not null");
            }
            statSql.append(" group by ");
            if (isAdmin) {
                statSql.append("  a.fid,a.FLongNumber, ");
            }
            if (isEmpType) {
                statSql.append(" p.femployeetypeid ");
            } else {
                statSql.append(" p.femployeeclassifyid ");
            }
        }
        return statSql.toString();
    }
}

