/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Flow003SHRSqlBuilder
extends CommonSHRSqlBuilder {
    private static final Logger logger = Logger.getLogger(Flow003SHRSqlBuilder.class);
    private Map<String, String> adminMap = new HashMap<String, String>();

    protected void recordOrgInfo(EntityObjectInfo clientEntity, StructureConfigInfo clientInfo, String clientField, String leftJoinField) {
        super.recordOrgInfo(clientEntity, clientInfo, clientField, leftJoinField);
        try {
            StructureConfigInfo parentConfigInfo;
            if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(clientEntity.getFullName()) && "FID".equals(clientField) && "com.kingdee.eas.hr.base.app.EmpFlowInOut".equals((parentConfigInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)clientInfo.getParent().getId().toString(), (String)this.param.getScheme())).getEntityName())) {
                this.permissFields.put("admin", leftJoinField);
                this.adminMap.put("admin", leftJoinField);
                this.param.setPAdminType("FLongNumber");
                this.param.setPAdminLongNumber("FLongNumber");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected FilterInfo privateDataSourceCustomFilter(String scheme, Map configParam, String effdtStr, Date effdt) throws EASBizException, BOSException {
        FilterInfo customFilter = null;
        String permItemId = (String)configParam.get("permItemId");
        if (scheme.equals("003")) {
            String startStr = (String)configParam.get("startDate");
            String endStr = (String)configParam.get("endDate");
            if (startStr.startsWith("{ts")) {
                startStr = startStr.replace("{ts'", "").replace("'}", "");
            }
            if (endStr.startsWith("{ts")) {
                endStr = endStr.replace("{ts'", "").replace("'}", "");
            }
            customFilter = this.getFlowInOutFilter(startStr, endStr);
        }
        return customFilter;
    }

    protected FilterInfo getFlowInOutFilter(String startStr, String endStr) throws BOSException {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = startStr != null && !"".equals(startStr) ? DateTimeUtils.parseDate((String)startStr, (String)"yyyy-MM-dd") : DateTimeUtils.truncateDate((Date)new Date());
            endDate = endStr != null && !"".equals(endStr) ? DateTimeUtils.parseDate((String)endStr, (String)"yyyy-MM-dd") : DateTimeUtils.truncateDate((Date)new Date());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo effectFilter = new FilterInfo();
        effectFilter.getFilterItems().add(new FilterItemInfo("empflowinout.EFFDT", (Object)new Timestamp(startDate.getTime()), CompareType.GREATER_EQUALS));
        effectFilter.getFilterItems().add(new FilterItemInfo("empflowinout.EFFDT", (Object)new Timestamp(endDate.getTime()), CompareType.LESS_EQUALS));
        return effectFilter;
    }
}

