/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.emp.CountryRegionInfo;
import com.kingdee.eas.hr.emp.CredentialsTypeException;
import com.kingdee.eas.hr.emp.CredentialsTypeFactory;
import com.kingdee.eas.hr.emp.CredentialsTypeInfo;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoInfo;
import com.kingdee.eas.hr.emp.PersonCredentialsTypeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.osf.ServiceLocatorException;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.preentry.PEPersonCredentialsTypeCollection;
import com.kingdee.shr.preentry.PEPersonCredentialsTypeFactory;
import com.kingdee.shr.preentry.PEPersonCredentialsTypeInfo;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SHREmpCheckCredentialsTypeUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil");

    public static void checkCredentiaslTypeForEmp(Context ctx, CoreBaseInfo model, String excludePersonID) throws EASBizException, BOSException {
        String credentialsNO = "";
        String idCardNO = "";
        String excludePreEntryBillID = "";
        String excludePreCreTypeId = "";
        String excludePersonCreTypeBillID = "";
        CountryRegionInfo countryRegion = null;
        CredentialsTypeInfo credentialsType = null;
        if (model instanceof EmpEnrollBizBillEntryInfo) {
            EmpEnrollBizBillEntryInfo enrollEntry = (EmpEnrollBizBillEntryInfo)model;
            credentialsNO = enrollEntry.getPassportNo();
            idCardNO = enrollEntry.getIDCardNo();
            countryRegion = enrollEntry.getCountryRegion();
            credentialsType = enrollEntry.getCredentialsType();
            excludePreEntryBillID = enrollEntry.getString("preEntryID");
        } else if (model instanceof EmpQuickAddNewInfoInfo) {
            EmpQuickAddNewInfoInfo quickEnroll = (EmpQuickAddNewInfoInfo)model;
            credentialsNO = quickEnroll.getPassportNO();
            idCardNO = quickEnroll.getIdCardNO();
            countryRegion = quickEnroll.getCountryRegion();
            credentialsType = quickEnroll.getCredentialsType();
        } else if (model instanceof PersonInfo) {
            String creTypeId;
            PersonInfo personInfo = (PersonInfo)model;
            credentialsNO = personInfo.getPassportNO();
            idCardNO = personInfo.getIdCardNO();
            String regionId = (String)personInfo.get("countryRegion");
            if (!StringUtils.isEmpty((String)regionId)) {
                countryRegion = new CountryRegionInfo();
                countryRegion.setId(BOSUuid.read((String)regionId));
            }
            if (!StringUtils.isEmpty((String)(creTypeId = (String)personInfo.get("credentialsType")))) {
                credentialsType = new CredentialsTypeInfo();
                credentialsType.setId(BOSUuid.read((String)creTypeId));
            }
        } else if (model instanceof PEPersonCredentialsTypeInfo) {
            PEPersonCredentialsTypeInfo pePerconCreInfo = (PEPersonCredentialsTypeInfo)model;
            credentialsNO = pePerconCreInfo.getCredentialsTypeNO();
            countryRegion = pePerconCreInfo.getCountryRegion();
            credentialsType = pePerconCreInfo.getCredentialsType();
            excludePreCreTypeId = pePerconCreInfo.getId() == null ? "" : pePerconCreInfo.getId().toString();
        } else if (model instanceof PersonCredentialsTypeInfo) {
            PersonCredentialsTypeInfo perconCreInfo = (PersonCredentialsTypeInfo)model;
            credentialsNO = perconCreInfo.getCredentialsTypeNO();
            countryRegion = perconCreInfo.getCountryRegion();
            credentialsType = perconCreInfo.getCredentialsType();
            String string = excludePersonCreTypeBillID = perconCreInfo.getId() == null ? "" : perconCreInfo.getId().toString();
        }
        if (credentialsType != null && credentialsType.getId() != null && StringUtils.isEmpty((String)credentialsNO)) {
            throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_MUST_SET);
        }
        if (credentialsType == null && !StringUtils.isEmpty((String)credentialsNO)) {
            throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSTYPE_MUST_SET);
        }
        if (logger.isInfoEnabled()) {
            String countryRegionIdLog = countryRegion != null && countryRegion.getId() != null ? countryRegion.getId().toString() : "''";
            String credentialsTypeLog = credentialsType != null && credentialsType.getId() != null ? credentialsType.getId().toString() : "''";
            logger.info((Object)("SHREmpCheckCredentialsTypeUtil:checkCredentiaslTypeForEmp-countryRegion is " + countryRegionIdLog + ", and credentialsType is " + credentialsTypeLog));
        }
        if (credentialsType != null && credentialsType.getId() != null) {
            CredentialsTypeInfo credentialsTypeRel = CredentialsTypeFactory.getLocalInstance(ctx).getCredentialsTypeInfo((IObjectPK)new ObjectUuidPK(credentialsType.getId()));
            SHREmpCheckCredentialsTypeUtil.checkCredentialsTypeAndNO(ctx, credentialsTypeRel, credentialsNO, idCardNO);
            SHREmpCheckCredentialsTypeUtil.checkCountryAndIDType(countryRegion, credentialsTypeRel);
        }
        SHREmpCheckCredentialsTypeUtil.checkCredentialsTypeNOExist(ctx, credentialsNO, excludePreEntryBillID, excludePreCreTypeId, excludePersonCreTypeBillID, excludePersonID);
    }

    public static void checkCredentialsTypeNOExist(Context ctx, String credentialsNO, String excludePreEntryBillID, String excludePreCreTypeId, String excludePersonCreTypeBillID, String excludePersonID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)credentialsNO)) {
            return;
        }
        try {
            IRowSet executResult;
            IRowSet executePreResult;
            String lan = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer strPreBuffer = new StringBuffer();
            strPreBuffer.append("select pep.FName_" + lan + " as name,pe.fid from T_HR_PEPersonCredentialsType ppct").append(" left join T_HR_PREENTRYPERSON pep on pep.fid = ppct.ftalentId").append(" left join T_HR_PREENTRY pe on pe.ftalentID = pep.fid").append(" where ppct.FCredentialsTypeNO = '").append(credentialsNO).append("'").append(" and ").append(" ((pe.fisSSC=0 and (pe.fisGenerateEntryBill<>1 or pe.fbillState<>").append(3).append(") and pe.fbillState <> ").append(4).append(" and pe.fcheckInState not in ('1','2')) or (pe.fisSSC=1 and pe.fisLatest=1))");
            if (!StringUtils.isEmpty((String)excludePreCreTypeId)) {
                strPreBuffer.append(" and ppct.fid <> '").append(excludePreCreTypeId).append("'");
            }
            if (!StringUtils.isEmpty((String)excludePreEntryBillID)) {
                strPreBuffer.append(" and pe.fid <> '").append(excludePreEntryBillID).append("'");
            }
            if ((executePreResult = DbUtil.executeQuery((Context)ctx, (String)strPreBuffer.toString())).next()) {
                String nameExist = executePreResult.getString("name");
                throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_EXIST_PREENTRY, new Object[]{nameExist});
            }
            StringBuffer strbuffer = new StringBuffer();
            strbuffer.append("select person.FName_" + lan + " as name,person.FNumber as number from T_HR_PersonCredentialsType pct").append(" left join T_BD_PERSON person on person.fid = pct.fpersonid").append(" left join t_hr_bdemployeetype empType on person.FEMPLOYEETYPEID = empType.fid").append(" where pct.FCredentialsTypeNO ='").append(credentialsNO).append("'").append(" and empType.fisInCount = '1' ");
            if (!StringUtils.isEmpty((String)excludePersonCreTypeBillID)) {
                strbuffer.append(" and pct.fid <> '").append(excludePersonCreTypeBillID).append("'");
            }
            if (!StringUtils.isEmpty((String)excludePersonID)) {
                strbuffer.append(" and pct.fpersonid <> '").append(excludePersonID).append("'");
            }
            if ((executResult = DbUtil.executeQuery((Context)ctx, (String)strbuffer.toString())).next()) {
                String nameExist = executResult.getString("name");
                throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_EXIST_PERSON, new Object[]{nameExist});
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    public static void checkCredentialsTypeAndNO(Context ctx, CredentialsTypeInfo credentialsType, String credentialsNO, String idCardNo) throws EASBizException, BOSException {
        String patternRule;
        if (!StringUtils.isEmpty((String)idCardNo) && credentialsType != null && "JjF2wJ+2SGKW+OZb5OkPOFlu4mQ=".equals(credentialsType.getId().toString())) {
            throw new CredentialsTypeException(CredentialsTypeException.IDCARD_NOT_ALLOWED);
        }
        if (credentialsType != null && credentialsType.getId() != null && StringUtils.isEmpty((String)credentialsNO)) {
            throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_MUST_SET);
        }
        if (credentialsType == null && !StringUtils.isEmpty((String)credentialsNO)) {
            throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSTYPE_MUST_SET);
        }
        if (!(credentialsType == null || StringUtils.isEmpty((String)credentialsNO) || StringUtils.isEmpty((String)(patternRule = credentialsType.getCredenRegular())) || StringUtils.isEmpty((String)credentialsNO))) {
            Pattern pattern;
            Matcher m;
            boolean result;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SHREmpCheckCredentialsTypeUtil:patternRule is " + patternRule + ", and credentialsNO is " + credentialsNO));
            }
            if (!(result = (m = (pattern = Pattern.compile(patternRule)).matcher(credentialsNO)).matches())) {
                throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_NOT_MATCH_PATTERN);
            }
        }
    }

    public static void checkCountryAndIDType(CountryRegionInfo countryRegion, CredentialsTypeInfo credentialsType) throws EASBizException {
        if (countryRegion == null || countryRegion.getId() == null || credentialsType == null || credentialsType.getCountryRegion() == null) {
            return;
        }
        String credentialsCountry = credentialsType.getCountryRegion().getId().toString();
        if (!credentialsCountry.equals(countryRegion.getId().toString())) {
            throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSTYPE_NOT_MATCH_COUNTRY);
        }
    }

    public static void checkCredentialsTypeNoByOSF(Context ctx, PersonCredentialsTypeInfo info) throws ServiceLocatorException, BOSException, EASBizException {
        CredentialsTypeInfo typeInfo = info.getCredentialsType();
        if (typeInfo == null || typeInfo.getId() == null) {
            return;
        }
        String excludePersonId = info.getPerson().getId().toString();
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(excludePersonId));
        String personName = personInfo.getName();
        String hrOrgUnitId = personInfo.getHrOrgUnit().getId().toString();
        HashMap<String, String> paramForCre = new HashMap<String, String>();
        paramForCre.put("personId", excludePersonId);
        paramForCre.put("personName", personName);
        if ("JjF2wJ+2SGKW+OZb5OkPOFlu4mQ=".equals(typeInfo.getId().toString())) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "getPersonIdCardNOInfoService");
            paramForCre.put("hrOrgUnitId", hrOrgUnitId);
            paramForCre.put("idCardNO", info.getCredentialsTypeNO());
            imsf.process(ctx, paramForCre);
        } else {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "getPersonPassPortNOInfoService");
            paramForCre.put("credentialsTypeId", typeInfo.getId().toString());
            paramForCre.put("passportNO", info.getCredentialsTypeNO());
            imsf.process(ctx, paramForCre);
        }
    }

    public static void checkCredentialsTypeNoByOSF(Context ctx, PEPersonCredentialsTypeInfo info) throws ServiceLocatorException, BOSException, EASBizException {
        CredentialsTypeInfo typeInfo = info.getCredentialsType();
        if (typeInfo == null || typeInfo.getId() == null) {
            return;
        }
        String excludePreEntryPersonId = info.getTalent().getId().toString();
        PreEntryCollection preEntryColl = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(" where talent = '" + excludePreEntryPersonId + "'");
        if (preEntryColl.size() > 0) {
            PreEntryInfo preEntryInfo = preEntryColl.get(0);
            String personName = preEntryInfo.getName();
            String hrOrgUnitId = preEntryInfo.getHrOrgUnit().getId().toString();
            HashMap<String, String> paramForCre = new HashMap<String, String>();
            paramForCre.put("preEntryId", preEntryInfo.getId().toString());
            paramForCre.put("personName", personName);
            if ("JjF2wJ+2SGKW+OZb5OkPOFlu4mQ=".equals(typeInfo.getId().toString())) {
                IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "getPersonIdCardNOInfoService");
                paramForCre.put("hrOrgUnitId", hrOrgUnitId);
                paramForCre.put("idCardNO", info.getCredentialsTypeNO());
                imsf.process(ctx, paramForCre);
            } else {
                IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "getPersonPassPortNOInfoService");
                paramForCre.put("credentialsTypeId", typeInfo.getId().toString());
                paramForCre.put("passportNO", info.getCredentialsTypeNO());
                imsf.process(ctx, paramForCre);
            }
        }
    }

    public static void checkCertifyType(Context ctx, PersonCredentialsTypeInfo info) throws EASBizException {
        if (info.isIsCertify()) {
            throw new CredentialsTypeException(CredentialsTypeException.CANNOT_ADD_CERTIFY_DATA);
        }
    }

    public static void checkCredentialsTypeUnique(Context ctx, PEPersonCredentialsTypeInfo info, PreEntryPersonInfo preEntryPersonInfo) throws BOSException, EASBizException {
        PEPersonCredentialsTypeCollection coll;
        CredentialsTypeInfo creTypeInfo = info.getCredentialsType();
        if (creTypeInfo == null || creTypeInfo.getId() == null) {
            return;
        }
        String infoId = info.getId() == null ? "" : info.getId().toString();
        String credentialsTypeId = creTypeInfo.getId().toString();
        String preEntryPersonId = preEntryPersonInfo.getId().toString();
        StringBuffer strbuffer = new StringBuffer();
        strbuffer.append("where talent = '" + preEntryPersonId + "' and credentialsType = '" + credentialsTypeId + "'");
        if (!StringUtils.isEmpty((String)infoId)) {
            strbuffer.append(" and id <> '" + infoId + "'");
        }
        if ((coll = PEPersonCredentialsTypeFactory.getLocalInstance((Context)ctx).getPEPersonCredentialsTypeCollection(strbuffer.toString())).size() > 0) {
            throw new CredentialsTypeException(CredentialsTypeException.PREENTRYPERSONCREDEN_REPEATED_NOT_ALLOW);
        }
    }

    public static void checkCredentialsTypeUniqueForTSP(Context ctx, PEPersonCredentialsTypeCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.size() < 2) {
            return;
        }
        boolean checkResult = false;
        boolean checkNoResult = false;
        HashSet<String> creTypeList = new HashSet<String>();
        HashSet<String> creTypeNoList = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PEPersonCredentialsTypeInfo info = coll.get(i);
            if (info.getCredentialsType() == null || StringUtils.isEmpty((String)info.getCredentialsType().getId().toString())) continue;
            String creTypeId = info.getCredentialsType().getId().toString();
            String creTypeNo = info.getCredentialsTypeNO();
            if (creTypeList.contains(creTypeId)) {
                checkResult = true;
                break;
            }
            creTypeList.add(creTypeId);
            if (creTypeNoList.contains(creTypeNo)) {
                checkNoResult = true;
                break;
            }
            creTypeNoList.add(creTypeNo);
        }
        if (checkResult) {
            throw new CredentialsTypeException(CredentialsTypeException.PREENTRYPERSONCREDEN_REPEATED_NOT_ALLOW);
        }
        if (checkNoResult) {
            throw new CredentialsTypeException(CredentialsTypeException.PREENTRYPERSONCREDENNO_REPEATED_NOT_ALLOW);
        }
    }

    public static void checkCredentiaslTypeForEmpForTSP(Context ctx, CoreBaseInfo model, PreEntryPersonInfo preEntryPersonInfo) throws EASBizException, BOSException {
        String credentialsNO = "";
        String idCardNO = "";
        String excludePreCreTypeId = "";
        CountryRegionInfo countryRegion = null;
        CredentialsTypeInfo credentialsType = null;
        if (model instanceof PEPersonCredentialsTypeInfo) {
            PEPersonCredentialsTypeInfo pePerconCreInfo = (PEPersonCredentialsTypeInfo)model;
            credentialsNO = pePerconCreInfo.getCredentialsTypeNO();
            countryRegion = pePerconCreInfo.getCountryRegion();
            credentialsType = pePerconCreInfo.getCredentialsType();
            String string = excludePreCreTypeId = pePerconCreInfo.getId() == null ? "" : pePerconCreInfo.getId().toString();
        }
        if (logger.isInfoEnabled()) {
            String countryRegionIdLog = countryRegion != null && countryRegion.getId() != null ? countryRegion.getId().toString() : "''";
            String credentialsTypeLog = credentialsType != null && credentialsType.getId() != null ? credentialsType.getId().toString() : "''";
            logger.info((Object)("SHREmpCheckCredentialsTypeUtil:checkCredentiaslTypeForEmp-countryRegion is " + countryRegionIdLog + ", and credentialsType is " + credentialsTypeLog));
        }
        if (credentialsType != null) {
            CredentialsTypeInfo credentialsTypeRel = CredentialsTypeFactory.getLocalInstance(ctx).getCredentialsTypeInfo((IObjectPK)new ObjectUuidPK(credentialsType.getId()));
            SHREmpCheckCredentialsTypeUtil.checkCredentialsTypeAndNO(ctx, credentialsTypeRel, credentialsNO, idCardNO);
            SHREmpCheckCredentialsTypeUtil.checkCountryAndIDType(countryRegion, credentialsTypeRel);
        }
        SHREmpCheckCredentialsTypeUtil.checkCredentialsTypeNOExistForTSP(ctx, credentialsNO, excludePreCreTypeId, preEntryPersonInfo);
    }

    public static void checkCredentialsTypeNOExistForTSP(Context ctx, String credentialsNO, String excludePreCreTypeId, PreEntryPersonInfo preEntryPersonInfo) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)credentialsNO)) {
            return;
        }
        try {
            String idCardNum = "";
            String passportNum = "";
            boolean isExist = false;
            String preEntryPersonInfoId = preEntryPersonInfo != null && preEntryPersonInfo.getId() != null ? preEntryPersonInfo.getId().toString() : "";
            String lan = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer strPreBuffer = new StringBuffer();
            strPreBuffer.append("select pep.Fid as id,pep.FName_" + lan + " as name,pep.FNumber as number,pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,ppct.FCredentialsTypeNO as credentialsTypeNO from T_HR_PEPersonCredentialsType ppct").append(" left join T_HR_PREENTRYPERSON pep on pep.fid = ppct.ftalentId").append(" left join T_HR_PREENTRY pe on pe.ftalentID = pep.fid").append(" where ppct.FCredentialsTypeNO = '").append(credentialsNO).append("'").append(" and pep.fid is not null and ppct.ftalentid <> '" + preEntryPersonInfoId + "'");
            if (!StringUtils.isEmpty((String)excludePreCreTypeId)) {
                strPreBuffer.append(" and ppct.fid <> '").append(excludePreCreTypeId).append("'");
            }
            IRowSet executePreResult = DbUtil.executeQuery((Context)ctx, (String)strPreBuffer.toString());
            while (executePreResult.next()) {
                idCardNum = executePreResult.getString("idCardNum");
                passportNum = executePreResult.getString("passportNo");
                if (!StringUtils.isEmpty((String)idCardNum) && !idCardNum.equals(preEntryPersonInfo.getIdCardNO())) {
                    isExist = true;
                } else if (!StringUtils.isEmpty((String)passportNum) && !passportNum.equals(preEntryPersonInfo.getPassportNO())) {
                    isExist = true;
                }
                if (!isExist) continue;
                String nameExist = executePreResult.getString("name");
                throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_EXIST_PREENTRY, new Object[]{nameExist});
            }
            StringBuffer strbuffer = new StringBuffer();
            strbuffer.append("select person.FName_" + lan + " as name,person.FNumber as number from T_HR_PersonCredentialsType pct").append(" left join T_BD_PERSON person on person.fid = pct.fpersonid").append(" left join t_hr_bdemployeetype empType on person.FEMPLOYEETYPEID = empType.fid").append(" where pct.FCredentialsTypeNO ='").append(credentialsNO).append("'").append(" and empType.fisInCount = '1' ");
            IRowSet executResult = DbUtil.executeQuery((Context)ctx, (String)strbuffer.toString());
            if (executResult.next()) {
                String nameExist = executePreResult.getString("name");
                throw new CredentialsTypeException(CredentialsTypeException.CREDENTIALSNO_EXIST_PERSON, new Object[]{nameExist});
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

