/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionHisCollection;
import com.kingdee.eas.hr.emp.PersonPositionHisFactory;
import com.kingdee.eas.hr.emp.PersonPositionHisInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SHREmpOptPersonPositionUtil {
    public static PersonPositionInfo getPersonPositionInfoByPersonId(Context ctx, String personId) throws BOSException {
        PersonPositionInfo ppInfo = null;
        if (personId != null) {
            IPersonPosition ipp = PersonPositionFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            viewInfo.setFilter(filterInfo);
            PersonPositionCollection ppColl = ipp.getPersonPositionCollection(viewInfo);
            if (ppColl.size() > 0) {
                ppInfo = ppColl.get(0);
            }
        }
        return ppInfo;
    }

    public static PersonPositionHisInfo getAppoinDatePersonPositionHisInfo(Context ctx, PersonPositionInfo ppInfo) throws BOSException {
        PersonPositionHisInfo ppHisInfo = new PersonPositionHisInfo();
        PersonInfo personInfo = ppInfo.getPerson();
        String personId = personInfo.getId().toString();
        Date appointDate = ppInfo.getEFFDT();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)appointDate);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        PersonPositionHisCollection ppColl = PersonPositionHisFactory.getLocalInstance(ctx).getPersonPositionHisCollection(view);
        if (ppColl.size() > 0) {
            ppHisInfo = ppColl.get(0);
        }
        return ppHisInfo;
    }

    public static PersonPositionHisCollection getPoinDatePersonPositionHisCollection(Context ctx, String personId, Date pointDate) throws BOSException {
        String effdt = HRUtilExtend.getDateStringWithoutMininuteTs((Date)pointDate);
        StringBuffer oql = new StringBuffer();
        oql.append("where person='").append(personId).append("'");
        oql.append(" and EFFDT<=").append(effdt).append(" and LEFFDT>=").append(effdt);
        oql.append(" order by endDateTime desc");
        return PersonPositionHisFactory.getLocalInstance(ctx).getPersonPositionHisCollection(oql.toString());
    }

    public static List getUserPositionList(Context ctx, String userId) throws BOSException {
        ArrayList list = new ArrayList();
        String local = ctx.getLocale() != null ? ctx.getLocale().toString() : "l2";
        StringBuffer sql = new StringBuffer("select position.fid positionId,position.fname_" + local + " positionName").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" inner join T_PM_User pmuser on person.fid = pmuser.fpersonid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" where emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and pmuser.fid = '").append(userId).append("'").append(" order by emprelation.fassigntype desc,position.findex asc");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("positionId", rowSet.getString("positionId"));
                map.put("positionName", rowSet.getString("positionName"));
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public static float calWorkTimeYears(Context ctx, Date beginDate, Date endDate, float adjVal) throws EASBizException, BOSException {
        int dayDiff;
        int monthDiff;
        int yearDiff;
        float joinCompanyYears;
        if (beginDate == null) {
            return 0.0f;
        }
        if (endDate == null) {
            endDate = new Date();
        }
        if ((joinCompanyYears = (float)(yearDiff = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) + (float)(monthDiff = DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) / 12.0f + (float)(dayDiff = DateTimeUtils.getDay((Date)endDate) - DateTimeUtils.getDay((Date)beginDate)) / 365.0f - adjVal) < 0.0f) {
            joinCompanyYears = 0.0f;
        }
        return SHRMathUtils.getRoundValueBySysParam((Context)ctx, (float)joinCompanyYears);
    }
}

